/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Copy;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;
    private int validationAction = 3;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string4 = this.getNamePool().getClarkName(n2);
            if (string4 == "use-attribute-sets") {
                this.use = attributeCollection.getValue(n);
            } else if (string4 == "copy-namespaces") {
                string = attributeCollection.getValue(n).trim();
            } else if (string4 == "type") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string4 == "validation") {
                string2 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.copyNamespaces = true;
        } else if (string.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'");
        }
        if (string3 != null && string2 != null) {
            this.compileError("The type and validation attributes must not both be specified");
        }
        if (string2 != null) {
            this.validationAction = Validation.getCode(string2);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
        }
        if (string3 != null) {
            this.schemaType = this.getSchemaType(string3);
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        Copy copy = new Copy(this.attributeSets, this.copyNamespaces, this.schemaType, this.validationAction);
        this.compileChildren(copy);
        return copy;
    }
}

