// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __file_source_h__
#define __file_source_h__

#include "Puma/ErrorSink.h"
#include "Puma/FdSource.h"
#include "Puma/SysCall.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

namespace Puma {


class FileSource : public FdSource {
public:
  FileSource (const char *name, ErrorSink *err = (ErrorSink*)0)
   { fd (SysCall::open (name, O_RDONLY, err)); }
  ~FileSource ()
   { SysCall::close (fd ()); }

  virtual int read (char *dest, int n)
   { return FdSource::read (dest, n); }
};


} // namespace Puma

#endif /* __file_source_h__ */
