// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_element_h__
#define __list_element_h__

/** \file
 *  Double-linked list element. */

#include <assert.h>

namespace Puma {


class List;


/** \class ListElement ListElement.h Puma/ListElement.h
 *  Double-linked list element type to be used as elements
 *  for Puma::List. To be derived for concrete list elements. */
class ListElement {
  friend class List;

  List        *_belonging_to;
  ListElement *_next;
  ListElement *_prev;

public:
  /** Constructor. */
  ListElement () : _belonging_to ((List*)0) {}
  /** Destructor. */
  virtual ~ListElement () { assert (! _belonging_to); };

  /** Duplicate this element. */
  virtual ListElement *duplicate () = 0;
  /** Get the list this element belongs to. 
   *  \return The list of NULL if not in a list. */
  List *belonging_to () const { return _belonging_to; }
};


} // namespace Puma

#endif /* __list_element_h__ */
