// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/Unit.h"
#include "Puma/Token.h"
#include "Puma/StrCol.h"
#include <stdlib.h>

namespace Puma {


Unit::~Unit () {
  if (_name) delete[] _name; 
  clear ();
}


void Unit::name (const char *n) {
  if (_name) delete[] _name;
   _name = n ? StrCol::dup (n) : (char*) 0;
}


void Unit::print (ostream &os) const {
  const Token *token = (const Token*)first ();

  while (token) {
    os << *token;
    token = (const Token*)next (token);
  }
}  


} // namespace Puma
