// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __FileUnit__
#define __FileUnit__

// Special Unit for files. Knows its last save location and the
// absolute path of the corresponding file.

#include "Puma/Unit.h"

namespace Puma {


class Project;

class FileUnit : public Unit {
  char *_lastLocation; 
  char *_absolutePath;
  
  Project *_project;
  bool _isBelow;

public:
  FileUnit ();
  FileUnit (Unit &);
  FileUnit (const List &);
  virtual ~FileUnit ();
            
  virtual void name (const char *);        
  void setLocation (const char *);    
        
  char *lastLocation () const;
  char *absolutePath () const;
  bool isFile () const;
  
  // Generates the absolute pathname to the file.
  static char *absolutePath (const char *);
  static char *resolvePath (const char *);
  
  // File belongs to given project?
  bool belongsTo (Project &);
};

inline FileUnit::FileUnit () : 
  Unit (), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (Unit &unit) : 
  Unit (unit), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (const List &list) : 
  Unit (list), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)  
 {}
inline FileUnit::~FileUnit () 
 { if (_lastLocation) delete[] _lastLocation; 
   if (_absolutePath) delete[] _absolutePath; }
            
inline char *FileUnit::lastLocation () const 
 { return _lastLocation; }
inline char *FileUnit::absolutePath () const 
 { return _absolutePath; }
inline bool FileUnit::isFile () const 
 { return true; }


} // namespace Puma

#endif /* __FileUnit__ */
