/*******************************************************************************
 * Copyright (c) 2000, 2018 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
		TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	public final static int
    TokenNameIdentifier = 14,
    TokenNameabstract = 47,
    TokenNameassert = 82,
    TokenNameboolean = 116,
    TokenNamebreak = 83,
    TokenNamebyte = 117,
    TokenNamecase = 93,
    TokenNamecatch = 94,
    TokenNamechar = 118,
    TokenNameclass = 73,
    TokenNamecontinue = 84,
    TokenNameconst = 136,
    TokenNamedefault = 99,
    TokenNamedo = 85,
    TokenNamedouble = 119,
    TokenNameelse = 98,
    TokenNameenum = 86,
    TokenNameextends = 92,
    TokenNamefalse = 48,
    TokenNamefinal = 49,
    TokenNamefinally = 97,
    TokenNamefloat = 120,
    TokenNamefor = 87,
    TokenNamegoto = 137,
    TokenNameif = 88,
    TokenNameimplements = 103,
    TokenNameimport = 95,
    TokenNameinstanceof = 16,
    TokenNameint = 121,
    TokenNameopens = 125,
    TokenNameinterface = 77,
    TokenNamelong = 122,
    TokenNamenative = 50,
    TokenNamenew = 41,
    TokenNamenull = 51,
    TokenNamepackage = 91,
    TokenNameprivate = 52,
    TokenNameprotected = 53,
    TokenNamepublic = 54,
    TokenNamereturn = 89,
    TokenNameshort = 123,
    TokenNamestatic = 45,
    TokenNamestrictfp = 55,
    TokenNamesuper = 43,
    TokenNameswitch = 68,
    TokenNamesynchronized = 46,
    TokenNamethis = 44,
    TokenNamethrow = 80,
    TokenNamethrows = 100,
    TokenNametransient = 56,
    TokenNametrue = 57,
    TokenNametry = 90,
    TokenNamevoid = 124,
    TokenNamevolatile = 58,
    TokenNamewhile = 81,
    TokenNamemodule = 126,
    TokenNameopen = 127,
    TokenNamerequires = 128,
    TokenNametransitive = 132,
    TokenNameexports = 129,
    TokenNameto = 133,
    TokenNameuses = 130,
    TokenNameprovides = 131,
    TokenNamewith = 134,
    TokenNameaspect = 27,
    TokenNamepointcut = 29,
    TokenNamearound = 34,
    TokenNamebefore = 30,
    TokenNameafter = 31,
    TokenNamedeclare = 32,
    TokenNameprivileged = 28,
    TokenNameIntegerLiteral = 59,
    TokenNameLongLiteral = 60,
    TokenNameFloatingPointLiteral = 61,
    TokenNameDoubleLiteral = 62,
    TokenNameCharacterLiteral = 63,
    TokenNameStringLiteral = 64,
    TokenNameTextBlock = 65,
    TokenNamePLUS_PLUS = 3,
    TokenNameMINUS_MINUS = 4,
    TokenNameEQUAL_EQUAL = 23,
    TokenNameLESS_EQUAL = 18,
    TokenNameGREATER_EQUAL = 19,
    TokenNameNOT_EQUAL = 20,
    TokenNameLEFT_SHIFT = 21,
    TokenNameRIGHT_SHIFT = 12,
    TokenNameUNSIGNED_RIGHT_SHIFT = 15,
    TokenNamePLUS_EQUAL = 104,
    TokenNameMINUS_EQUAL = 105,
    TokenNameMULTIPLY_EQUAL = 106,
    TokenNameDIVIDE_EQUAL = 107,
    TokenNameAND_EQUAL = 108,
    TokenNameOR_EQUAL = 109,
    TokenNameXOR_EQUAL = 110,
    TokenNameREMAINDER_EQUAL = 111,
    TokenNameLEFT_SHIFT_EQUAL = 112,
    TokenNameRIGHT_SHIFT_EQUAL = 113,
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 114,
    TokenNameOR_OR = 38,
    TokenNameAND_AND = 37,
    TokenNamePLUS = 2,
    TokenNameMINUS = 6,
    TokenNameNOT = 70,
    TokenNameREMAINDER = 10,
    TokenNameXOR = 33,
    TokenNameAND = 22,
    TokenNameMULTIPLY = 8,
    TokenNameOR = 36,
    TokenNameTWIDDLE = 74,
    TokenNameDIVIDE = 11,
    TokenNameGREATER = 13,
    TokenNameLESS = 7,
    TokenNameLPAREN = 17,
    TokenNameRPAREN = 25,
    TokenNameLBRACE = 66,
    TokenNameRBRACE = 40,
    TokenNameLBRACKET = 5,
    TokenNameRBRACKET = 71,
    TokenNameSEMICOLON = 26,
    TokenNameQUESTION = 35,
    TokenNameCOLON = 67,
    TokenNameCOMMA = 39,
    TokenNameDOT = 1,
    TokenNameEQUAL = 76,
    TokenNameAT = 42,
    TokenNameELLIPSIS = 101,
    TokenNameARROW = 115,
    TokenNameCOLON_COLON = 9,
    TokenNameBeginLambda = 69,
    TokenNameBeginIntersectionCast = 75,
    TokenNameBeginTypeArguments = 96,
    TokenNameElidedSemicolonAndRightBrace = 78,
    TokenNameAT308 = 24,
    TokenNameAT308DOTDOTDOT = 135,
    TokenNameBeginCaseExpr = 79,
    TokenNameRestrictedIdentifierYield = 102,
    TokenNameEOF = 72,
    TokenNameERROR = 138;
}
