/*
 * AI game (sub)tree class
 * Header file
 *
 * $Id$
 */

#ifndef GAMETREE_H
#define GAMETREE_H

#include <list.h>			// MUST be prog/lib/ version!
#include "atom4.h"


struct move_t {
  int x, y;
  inline int operator== (move_t m) { return x==m.x && y==m.y; }
};

class gamenode;				// forward decl
class gameedge {
  move_t m;				// move associated with this edge
  gamenode *dest;			// [O] NULL if not cached
public:
  gameedge(move_t move) : m(move), dest(NULL) {}
  ~gameedge() { if (dest) delete dest; }

  inline int operator== (move_t move) { return m==move; }
  inline gamenode *operator*() { return dest; }	// [R]()
  inline move_t label() { return m; }
};

// Game node value heuristic function accumulator
// - changes = number of color changes caused by move
// - pcreated = number of propagators (ours) created
// - pdestroyed = number of propagators (enemy's) destroyed
// - cluster = cluster factor for propagators we created
// - uncluster = cluster factor for propagators we destroyed
struct hdelta {
  int changes, pcreated, pdestroyed;
  int cluster, uncluster;		// cluster factors

  inline hdelta operator-() {
    hdelta neg = { -changes, -pdestroyed, -pcreated, -uncluster, -cluster };
  }
};

class gamenode {
  elist<gameedge> children;
  elist<boardchange> splash, unsplash;
  int win:1;				// 1 if winning state, else 0
  hdelta heu;				// heuristic function accumulator
public:
  gamenode();
  ~gamenode();
};

class gametree {
  gamenode *root;			// [O]
public:
  gametree();
  ~gametree();
};

#endif //GAMETREE_H
