# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import map_error

from ... import models


class PathOperations:
    """PathOperations async operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar comp: . Constant value: "expiry".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer) -> None:

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self._config = config
        self.comp = "expiry"

    async def create(self, resource=None, continuation=None, mode=None, rename_source=None, source_lease_id=None, properties=None, permissions=None, umask=None, request_id=None, timeout=None, path_http_headers=None, lease_access_conditions=None, modified_access_conditions=None, source_modified_access_conditions=None, *, cls=None, **kwargs):
        """Create File | Create Directory | Rename File | Rename Directory.

        Create or rename a file or directory.    By default, the destination is
        overwritten and if the destination already exists and has a lease the
        lease is broken.  This operation supports conditional HTTP requests.
        For more information, see [Specifying Conditional Headers for Blob
        Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).
        To fail if the destination already exists, use a conditional request
        with If-None-Match: "*".

        :param resource: Required only for Create File and Create Directory.
         The value must be "file" or "directory". Possible values include:
         'directory', 'file'
        :type resource: str or
         ~azure.storage.filedatalake.models.PathResourceType
        :param continuation: Optional.  When deleting a directory, the number
         of paths that are deleted with each invocation is limited.  If the
         number of paths to be deleted exceeds this limit, a continuation token
         is returned in this response header.  When a continuation token is
         returned in the response, it must be specified in a subsequent
         invocation of the delete operation to continue deleting the directory.
        :type continuation: str
        :param mode: Optional. Valid only when namespace is enabled. This
         parameter determines the behavior of the rename operation. The value
         must be "legacy" or "posix", and the default value will be "posix".
         Possible values include: 'legacy', 'posix'
        :type mode: str or ~azure.storage.filedatalake.models.PathRenameMode
        :param rename_source: An optional file or directory to be renamed.
         The value must have the following format: "/{filesystem}/{path}".  If
         "x-ms-properties" is specified, the properties will overwrite the
         existing properties; otherwise, the existing properties will be
         preserved. This value must be a URL percent-encoded string. Note that
         the string may only contain ASCII characters in the ISO-8859-1
         character set.
        :type rename_source: str
        :param source_lease_id: A lease ID for the source path. If specified,
         the source path must have an active lease and the lease ID must match.
        :type source_lease_id: str
        :param properties: Optional. User-defined properties to be stored with
         the filesystem, in the format of a comma-separated list of name and
         value pairs "n1=v1, n2=v2, ...", where each value is a base64 encoded
         string. Note that the string may only contain ASCII characters in the
         ISO-8859-1 character set.  If the filesystem exists, any properties
         not included in the list will be removed.  All properties are removed
         if the header is omitted.  To merge new and existing properties, first
         get all existing properties and the current E-Tag, then make a
         conditional request with the E-Tag and include values for all
         properties.
        :type properties: str
        :param permissions: Optional and only valid if Hierarchical Namespace
         is enabled for the account. Sets POSIX access permissions for the file
         owner, the file owning group, and others. Each class may be granted
         read, write, or execute permission.  The sticky bit is also supported.
         Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are
         supported.
        :type permissions: str
        :param umask: Optional and only valid if Hierarchical Namespace is
         enabled for the account. When creating a file or directory and the
         parent folder does not have a default ACL, the umask restricts the
         permissions of the file or directory to be created.  The resulting
         permission is given by p bitwise and not u, where p is the permission
         and u is the umask.  For example, if p is 0777 and u is 0057, then the
         resulting permission is 0720.  The default permission is 0777 for a
         directory and 0666 for a file.  The default umask is 0027.  The umask
         must be specified in 4-digit octal notation (e.g. 0766).
        :type umask: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param path_http_headers: Additional parameters for the operation
        :type path_http_headers:
         ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param source_modified_access_conditions: Additional parameters for
         the operation
        :type source_modified_access_conditions:
         ~azure.storage.filedatalake.models.SourceModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        cache_control = None
        if path_http_headers is not None:
            cache_control = path_http_headers.cache_control
        content_encoding = None
        if path_http_headers is not None:
            content_encoding = path_http_headers.content_encoding
        content_language = None
        if path_http_headers is not None:
            content_language = path_http_headers.content_language
        content_disposition = None
        if path_http_headers is not None:
            content_disposition = path_http_headers.content_disposition
        content_type = None
        if path_http_headers is not None:
            content_type = path_http_headers.content_type
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since
        source_if_match = None
        if source_modified_access_conditions is not None:
            source_if_match = source_modified_access_conditions.source_if_match
        source_if_none_match = None
        if source_modified_access_conditions is not None:
            source_if_none_match = source_modified_access_conditions.source_if_none_match
        source_if_modified_since = None
        if source_modified_access_conditions is not None:
            source_if_modified_since = source_modified_access_conditions.source_if_modified_since
        source_if_unmodified_since = None
        if source_modified_access_conditions is not None:
            source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since

        # Construct URL
        url = self.create.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if resource is not None:
            query_parameters['resource'] = self._serialize.query("resource", resource, 'PathResourceType')
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        if mode is not None:
            query_parameters['mode'] = self._serialize.query("mode", mode, 'PathRenameMode')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        if rename_source is not None:
            header_parameters['x-ms-rename-source'] = self._serialize.header("rename_source", rename_source, 'str')
        if source_lease_id is not None:
            header_parameters['x-ms-source-lease-id'] = self._serialize.header("source_lease_id", source_lease_id, 'str')
        if properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("properties", properties, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if umask is not None:
            header_parameters['x-ms-umask'] = self._serialize.header("umask", umask, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", cache_control, 'str')
        if content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", content_encoding, 'str')
        if content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", content_language, 'str')
        if content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", content_disposition, 'str')
        if content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", content_type, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')
        if source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", source_if_match, 'str')
        if source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", source_if_none_match, 'str')
        if source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", source_if_modified_since, 'rfc-1123')
        if source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", source_if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-continuation': self._deserialize('str', response.headers.get('x-ms-continuation')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    create.metadata = {'url': '/{filesystem}/{path}'}

    async def update(self, action, mode, body, max_records=None, continuation=None, force_flag=None, position=None, retain_uncommitted_data=None, close=None, content_length=None, properties=None, owner=None, group=None, permissions=None, acl=None, request_id=None, timeout=None, path_http_headers=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Append Data | Flush Data | Set Properties | Set Access Control.

        Uploads data to be appended to a file, flushes (writes) previously
        uploaded data to a file, sets properties for a file or directory, or
        sets access control for a file or directory. Data can only be appended
        to a file. This operation supports conditional HTTP requests. For more
        information, see [Specifying Conditional Headers for Blob Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).

        :param action: The action must be "append" to upload data to be
         appended to a file, "flush" to flush previously uploaded data to a
         file, "setProperties" to set the properties of a file or directory,
         "setAccessControl" to set the owner, group, permissions, or access
         control list for a file or directory, or  "setAccessControlRecursive"
         to set the access control list for a directory recursively. Note that
         Hierarchical Namespace must be enabled for the account in order to use
         access control.  Also note that the Access Control List (ACL) includes
         permissions for the owner, owning group, and others, so the
         x-ms-permissions and x-ms-acl request headers are mutually exclusive.
         Possible values include: 'append', 'flush', 'setProperties',
         'setAccessControl', 'setAccessControlRecursive'
        :type action: str or
         ~azure.storage.filedatalake.models.PathUpdateAction
        :param mode: Mode "set" sets POSIX access control rights on files and
         directories, "modify" modifies one or more POSIX access control rights
         that pre-exist on files and directories, "remove" removes one or more
         POSIX access control rights  that were present earlier on files and
         directories. Possible values include: 'set', 'modify', 'remove'
        :type mode: str or
         ~azure.storage.filedatalake.models.PathSetAccessControlRecursiveMode
        :param body: Initial data
        :type body: Generator
        :param max_records: Optional. Valid for "SetAccessControlRecursive"
         operation. It specifies the maximum number of files or directories on
         which the acl change will be applied. If omitted or greater than
         2,000, the request will process up to 2,000 items
        :type max_records: int
        :param continuation: Optional. The number of paths processed with each
         invocation is limited. If the number of paths to be processed exceeds
         this limit, a continuation token is returned in the response header
         x-ms-continuation. When a continuation token is  returned in the
         response, it must be percent-encoded and specified in a subsequent
         invocation of setAcessControlRecursive operation.
        :type continuation: str
        :param force_flag: Optional. Valid for "SetAccessControlRecursive"
         operation. If set to false, the operation will terminate quickly on
         encountering user errors (4XX). If true, the operation will ignore
         user errors and proceed with the operation on other sub-entities of
         the directory. Continuation token will only be returned when forceFlag
         is true in case of user errors. If not set the default value is false
         for this.
        :type force_flag: bool
        :param position: This parameter allows the caller to upload data in
         parallel and control the order in which it is appended to the file.
         It is required when uploading data to be appended to the file and when
         flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not
         immediately flushed, or written, to the file.  To flush, the
         previously uploaded data must be contiguous, the position parameter
         must be specified and equal to the length of the file after all data
         has been written, and there must not be a request entity body included
         with the request.
        :type position: long
        :param retain_uncommitted_data: Valid only for flush operations.  If
         "true", uncommitted data is retained after the flush operation
         completes; otherwise, the uncommitted data is deleted after the flush
         operation.  The default is false.  Data at offsets less than the
         specified position are written to the file when flush succeeds, but
         this optional parameter allows data after the flush position to be
         retained for a future flush operation.
        :type retain_uncommitted_data: bool
        :param close: Azure Storage Events allow applications to receive
         notifications when files change. When Azure Storage Events are
         enabled, a file changed event is raised. This event has a property
         indicating whether this is the final change to distinguish the
         difference between an intermediate flush to a file stream and the
         final close of a file stream. The close query parameter is valid only
         when the action is "flush" and change notifications are enabled. If
         the value of close is "true" and the flush operation completes
         successfully, the service raises a file change notification with a
         property indicating that this is the final update (the file stream has
         been closed). If "false" a change notification is raised indicating
         the file has changed. The default is false. This query parameter is
         set to true by the Hadoop ABFS driver to indicate that the file stream
         has been closed."
        :type close: bool
        :param content_length: Required for "Append Data" and "Flush Data".
         Must be 0 for "Flush Data".  Must be the length of the request content
         in bytes for "Append Data".
        :type content_length: long
        :param properties: Optional. User-defined properties to be stored with
         the filesystem, in the format of a comma-separated list of name and
         value pairs "n1=v1, n2=v2, ...", where each value is a base64 encoded
         string. Note that the string may only contain ASCII characters in the
         ISO-8859-1 character set.  If the filesystem exists, any properties
         not included in the list will be removed.  All properties are removed
         if the header is omitted.  To merge new and existing properties, first
         get all existing properties and the current E-Tag, then make a
         conditional request with the E-Tag and include values for all
         properties.
        :type properties: str
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param permissions: Optional and only valid if Hierarchical Namespace
         is enabled for the account. Sets POSIX access permissions for the file
         owner, the file owning group, and others. Each class may be granted
         read, write, or execute permission.  The sticky bit is also supported.
         Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are
         supported.
        :type permissions: str
        :param acl: Sets POSIX access control rights on files and directories.
         The value is a comma-separated list of access control entries. Each
         access control entry (ACE) consists of a scope, a type, a user or
         group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param path_http_headers: Additional parameters for the operation
        :type path_http_headers:
         ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SetAccessControlRecursiveResponse or the result of
         cls(response)
        :rtype:
         ~azure.storage.filedatalake.models.SetAccessControlRecursiveResponse
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        content_md5 = None
        if path_http_headers is not None:
            content_md5 = path_http_headers.content_md5
        cache_control = None
        if path_http_headers is not None:
            cache_control = path_http_headers.cache_control
        content_type = None
        if path_http_headers is not None:
            content_type = path_http_headers.content_type
        content_disposition = None
        if path_http_headers is not None:
            content_disposition = path_http_headers.content_disposition
        content_encoding = None
        if path_http_headers is not None:
            content_encoding = path_http_headers.content_encoding
        content_language = None
        if path_http_headers is not None:
            content_language = path_http_headers.content_language
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        # Construct URL
        url = self.update.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['action'] = self._serialize.query("action", action, 'PathUpdateAction')
        if max_records is not None:
            query_parameters['maxRecords'] = self._serialize.query("max_records", max_records, 'int', minimum=1)
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        query_parameters['mode'] = self._serialize.query("mode", mode, 'PathSetAccessControlRecursiveMode')
        if force_flag is not None:
            query_parameters['forceFlag'] = self._serialize.query("force_flag", force_flag, 'bool')
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if retain_uncommitted_data is not None:
            query_parameters['retainUncommittedData'] = self._serialize.query("retain_uncommitted_data", retain_uncommitted_data, 'bool')
        if close is not None:
            query_parameters['close'] = self._serialize.query("close", close, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/octet-stream'
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("properties", properties, 'str')
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("content_md5", content_md5, 'bytearray')
        if cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", cache_control, 'str')
        if content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", content_type, 'str')
        if content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", content_disposition, 'str')
        if content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", content_encoding, 'str')
        if content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", content_language, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, stream_content=body)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SetAccessControlRecursiveResponse', response)
            header_dict = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-MD5': self._deserialize('str', response.headers.get('Content-MD5')),
                'x-ms-properties': self._deserialize('str', response.headers.get('x-ms-properties')),
                'x-ms-continuation': self._deserialize('str', response.headers.get('x-ms-continuation')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    update.metadata = {'url': '/{filesystem}/{path}'}

    async def lease(self, x_ms_lease_action, x_ms_lease_duration=None, x_ms_lease_break_period=None, proposed_lease_id=None, request_id=None, timeout=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Lease Path.

        Create and manage a lease to restrict write and delete access to the
        path. This operation supports conditional HTTP requests.  For more
        information, see [Specifying Conditional Headers for Blob Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).

        :param x_ms_lease_action: There are five lease actions: "acquire",
         "break", "change", "renew", and "release". Use "acquire" and specify
         the "x-ms-proposed-lease-id" and "x-ms-lease-duration" to acquire a
         new lease. Use "break" to break an existing lease. When a lease is
         broken, the lease break period is allowed to elapse, during which time
         no lease operation except break and release can be performed on the
         file. When a lease is successfully broken, the response indicates the
         interval in seconds until a new lease can be acquired. Use "change"
         and specify the current lease ID in "x-ms-lease-id" and the new lease
         ID in "x-ms-proposed-lease-id" to change the lease ID of an active
         lease. Use "renew" and specify the "x-ms-lease-id" to renew an
         existing lease. Use "release" and specify the "x-ms-lease-id" to
         release a lease. Possible values include: 'acquire', 'break',
         'change', 'renew', 'release'
        :type x_ms_lease_action: str or
         ~azure.storage.filedatalake.models.PathLeaseAction
        :param x_ms_lease_duration: The lease duration is required to acquire
         a lease, and specifies the duration of the lease in seconds.  The
         lease duration must be between 15 and 60 seconds or -1 for infinite
         lease.
        :type x_ms_lease_duration: int
        :param x_ms_lease_break_period: The lease break period duration is
         optional to break a lease, and  specifies the break period of the
         lease in seconds.  The lease break  duration must be between 0 and 60
         seconds.
        :type x_ms_lease_break_period: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format.
         The Blob service returns 400 (Invalid request) if the proposed lease
         ID is not in the correct format. See Guid Constructor (String) for a
         list of valid GUID string formats.
        :type proposed_lease_id: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        # Construct URL
        url = self.lease.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-lease-action'] = self._serialize.header("x_ms_lease_action", x_ms_lease_action, 'PathLeaseAction')
        if x_ms_lease_duration is not None:
            header_parameters['x-ms-lease-duration'] = self._serialize.header("x_ms_lease_duration", x_ms_lease_duration, 'int')
        if x_ms_lease_break_period is not None:
            header_parameters['x-ms-lease-break-period'] = self._serialize.header("x_ms_lease_break_period", x_ms_lease_break_period, 'int')
        if proposed_lease_id is not None:
            header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-lease-id': self._deserialize('str', response.headers.get('x-ms-lease-id')),
                'x-ms-lease-time': self._deserialize('str', response.headers.get('x-ms-lease-time')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    lease.metadata = {'url': '/{filesystem}/{path}'}

    async def read(self, range=None, x_ms_range_get_content_md5=None, request_id=None, timeout=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Read File.

        Read the contents of a file.  For read operations, range requests are
        supported. This operation supports conditional HTTP requests.  For more
        information, see [Specifying Conditional Headers for Blob Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).

        :param range: The HTTP Range request header specifies one or more byte
         ranges of the resource to be retrieved.
        :type range: str
        :param x_ms_range_get_content_md5: Optional. When this header is set
         to "true" and specified together with the Range header, the service
         returns the MD5 hash for the range, as long as the range is less than
         or equal to 4MB in size. If this header is specified without the Range
         header, the service returns status code 400 (Bad Request). If this
         header is set to true when the range exceeds 4 MB in size, the service
         returns status code 400 (Bad Request).
        :type x_ms_range_get_content_md5: bool
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: object or the result of cls(response)
        :rtype: Generator
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        # Construct URL
        url = self.read.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if range is not None:
            header_parameters['Range'] = self._serialize.header("range", range, 'str')
        if x_ms_range_get_content_md5 is not None:
            header_parameters['x-ms-range-get-content-md5'] = self._serialize.header("x_ms_range_get_content_md5", x_ms_range_get_content_md5, 'bool')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            await response.load_body()
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline)
            header_dict = {
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-MD5': self._deserialize('str', response.headers.get('Content-MD5')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-resource-type': self._deserialize('str', response.headers.get('x-ms-resource-type')),
                'x-ms-properties': self._deserialize('str', response.headers.get('x-ms-properties')),
                'x-ms-lease-duration': self._deserialize('str', response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize('str', response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize('str', response.headers.get('x-ms-lease-status')),
                'x-ms-content-md5': self._deserialize('str', response.headers.get('x-ms-content-md5')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
        if response.status_code == 206:
            deserialized = response.stream_download(self._client._pipeline)
            header_dict = {
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-MD5': self._deserialize('str', response.headers.get('Content-MD5')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-resource-type': self._deserialize('str', response.headers.get('x-ms-resource-type')),
                'x-ms-properties': self._deserialize('str', response.headers.get('x-ms-properties')),
                'x-ms-lease-duration': self._deserialize('str', response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize('str', response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize('str', response.headers.get('x-ms-lease-status')),
                'x-ms-content-md5': self._deserialize('str', response.headers.get('x-ms-content-md5')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    read.metadata = {'url': '/{filesystem}/{path}'}

    async def get_properties(self, action=None, upn=None, request_id=None, timeout=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Get Properties | Get Status | Get Access Control List.

        Get Properties returns all system and user defined properties for a
        path. Get Status returns all system defined properties for a path. Get
        Access Control List returns the access control list for a path. This
        operation supports conditional HTTP requests.  For more information,
        see [Specifying Conditional Headers for Blob Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).

        :param action: Optional. If the value is "getStatus" only the system
         defined properties for the path are returned. If the value is
         "getAccessControl" the access control list is returned in the response
         headers (Hierarchical Namespace must be enabled for the account),
         otherwise the properties are returned. Possible values include:
         'getAccessControl', 'getStatus'
        :type action: str or
         ~azure.storage.filedatalake.models.PathGetPropertiesAction
        :param upn: Optional. Valid only when Hierarchical Namespace is
         enabled for the account. If "true", the user identity values returned
         in the x-ms-owner, x-ms-group, and x-ms-acl response headers will be
         transformed from Azure Active Directory Object IDs to User Principal
         Names.  If "false", the values will be returned as Azure Active
         Directory Object IDs. The default value is false. Note that group and
         application Object IDs are not translated because they do not have
         unique friendly names.
        :type upn: bool
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        # Construct URL
        url = self.get_properties.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if action is not None:
            query_parameters['action'] = self._serialize.query("action", action, 'PathGetPropertiesAction')
        if upn is not None:
            query_parameters['upn'] = self._serialize.query("upn", upn, 'bool')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-MD5': self._deserialize('str', response.headers.get('Content-MD5')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-resource-type': self._deserialize('str', response.headers.get('x-ms-resource-type')),
                'x-ms-properties': self._deserialize('str', response.headers.get('x-ms-properties')),
                'x-ms-owner': self._deserialize('str', response.headers.get('x-ms-owner')),
                'x-ms-group': self._deserialize('str', response.headers.get('x-ms-group')),
                'x-ms-permissions': self._deserialize('str', response.headers.get('x-ms-permissions')),
                'x-ms-acl': self._deserialize('str', response.headers.get('x-ms-acl')),
                'x-ms-lease-duration': self._deserialize('str', response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize('str', response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize('str', response.headers.get('x-ms-lease-status')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    get_properties.metadata = {'url': '/{filesystem}/{path}'}

    async def delete(self, recursive=None, continuation=None, request_id=None, timeout=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Delete File | Delete Directory.

        Delete the file or directory. This operation supports conditional HTTP
        requests.  For more information, see [Specifying Conditional Headers
        for Blob Service
        Operations](https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations).

        :param recursive: Required
        :type recursive: bool
        :param continuation: Optional.  When deleting a directory, the number
         of paths that are deleted with each invocation is limited.  If the
         number of paths to be deleted exceeds this limit, a continuation token
         is returned in this response header.  When a continuation token is
         returned in the response, it must be specified in a subsequent
         invocation of the delete operation to continue deleting the directory.
        :type continuation: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if recursive is not None:
            query_parameters['recursive'] = self._serialize.query("recursive", recursive, 'bool')
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'x-ms-continuation': self._deserialize('str', response.headers.get('x-ms-continuation')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    delete.metadata = {'url': '/{filesystem}/{path}'}

    async def set_access_control(self, timeout=None, owner=None, group=None, permissions=None, acl=None, request_id=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Set the owner, group, permissions, or access control list for a path.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param permissions: Optional and only valid if Hierarchical Namespace
         is enabled for the account. Sets POSIX access permissions for the file
         owner, the file owning group, and others. Each class may be granted
         read, write, or execute permission.  The sticky bit is also supported.
         Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are
         supported.
        :type permissions: str
        :param acl: Sets POSIX access control rights on files and directories.
         The value is a comma-separated list of access control entries. Each
         access control entry (ACE) consists of a scope, a type, a user or
         group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        action = "setAccessControl"

        # Construct URL
        url = self.set_access_control.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['action'] = self._serialize.query("action", action, 'str')

        # Construct headers
        header_parameters = {}
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
            }
            return cls(response, None, response_headers)
    set_access_control.metadata = {'url': '/{filesystem}/{path}'}

    async def set_access_control_recursive(self, mode, timeout=None, continuation=None, force_flag=None, max_records=None, acl=None, request_id=None, *, cls=None, **kwargs):
        """Set the access control list for a path and subpaths.

        :param mode: Mode "set" sets POSIX access control rights on files and
         directories, "modify" modifies one or more POSIX access control rights
         that pre-exist on files and directories, "remove" removes one or more
         POSIX access control rights  that were present earlier on files and
         directories. Possible values include: 'set', 'modify', 'remove'
        :type mode: str or
         ~azure.storage.filedatalake.models.PathSetAccessControlRecursiveMode
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param continuation: Optional.  When deleting a directory, the number
         of paths that are deleted with each invocation is limited.  If the
         number of paths to be deleted exceeds this limit, a continuation token
         is returned in this response header.  When a continuation token is
         returned in the response, it must be specified in a subsequent
         invocation of the delete operation to continue deleting the directory.
        :type continuation: str
        :param force_flag: Optional. Valid for "SetAccessControlRecursive"
         operation. If set to false, the operation will terminate quickly on
         encountering user errors (4XX). If true, the operation will ignore
         user errors and proceed with the operation on other sub-entities of
         the directory. Continuation token will only be returned when forceFlag
         is true in case of user errors. If not set the default value is false
         for this.
        :type force_flag: bool
        :param max_records: Optional. It specifies the maximum number of files
         or directories on which the acl change will be applied. If omitted or
         greater than 2,000, the request will process up to 2,000 items
        :type max_records: int
        :param acl: Sets POSIX access control rights on files and directories.
         The value is a comma-separated list of access control entries. Each
         access control entry (ACE) consists of a scope, a type, a user or
         group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: SetAccessControlRecursiveResponse or the result of
         cls(response)
        :rtype:
         ~azure.storage.filedatalake.models.SetAccessControlRecursiveResponse
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        action = "setAccessControlRecursive"

        # Construct URL
        url = self.set_access_control_recursive.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        query_parameters['mode'] = self._serialize.query("mode", mode, 'PathSetAccessControlRecursiveMode')
        if force_flag is not None:
            query_parameters['forceFlag'] = self._serialize.query("force_flag", force_flag, 'bool')
        if max_records is not None:
            query_parameters['maxRecords'] = self._serialize.query("max_records", max_records, 'int', minimum=1)
        query_parameters['action'] = self._serialize.query("action", action, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('SetAccessControlRecursiveResponse', response)
            header_dict = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-continuation': self._deserialize('str', response.headers.get('x-ms-continuation')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    set_access_control_recursive.metadata = {'url': '/{filesystem}/{path}'}

    async def flush_data(self, timeout=None, position=None, retain_uncommitted_data=None, close=None, content_length=None, request_id=None, path_http_headers=None, lease_access_conditions=None, modified_access_conditions=None, *, cls=None, **kwargs):
        """Set the owner, group, permissions, or access control list for a path.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param position: This parameter allows the caller to upload data in
         parallel and control the order in which it is appended to the file.
         It is required when uploading data to be appended to the file and when
         flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not
         immediately flushed, or written, to the file.  To flush, the
         previously uploaded data must be contiguous, the position parameter
         must be specified and equal to the length of the file after all data
         has been written, and there must not be a request entity body included
         with the request.
        :type position: long
        :param retain_uncommitted_data: Valid only for flush operations.  If
         "true", uncommitted data is retained after the flush operation
         completes; otherwise, the uncommitted data is deleted after the flush
         operation.  The default is false.  Data at offsets less than the
         specified position are written to the file when flush succeeds, but
         this optional parameter allows data after the flush position to be
         retained for a future flush operation.
        :type retain_uncommitted_data: bool
        :param close: Azure Storage Events allow applications to receive
         notifications when files change. When Azure Storage Events are
         enabled, a file changed event is raised. This event has a property
         indicating whether this is the final change to distinguish the
         difference between an intermediate flush to a file stream and the
         final close of a file stream. The close query parameter is valid only
         when the action is "flush" and change notifications are enabled. If
         the value of close is "true" and the flush operation completes
         successfully, the service raises a file change notification with a
         property indicating that this is the final update (the file stream has
         been closed). If "false" a change notification is raised indicating
         the file has changed. The default is false. This query parameter is
         set to true by the Hadoop ABFS driver to indicate that the file stream
         has been closed."
        :type close: bool
        :param content_length: Required for "Append Data" and "Flush Data".
         Must be 0 for "Flush Data".  Must be the length of the request content
         in bytes for "Append Data".
        :type content_length: long
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param path_http_headers: Additional parameters for the operation
        :type path_http_headers:
         ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Additional parameters for the
         operation
        :type modified_access_conditions:
         ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        content_md5 = None
        if path_http_headers is not None:
            content_md5 = path_http_headers.content_md5
        cache_control = None
        if path_http_headers is not None:
            cache_control = path_http_headers.cache_control
        content_type = None
        if path_http_headers is not None:
            content_type = path_http_headers.content_type
        content_disposition = None
        if path_http_headers is not None:
            content_disposition = path_http_headers.content_disposition
        content_encoding = None
        if path_http_headers is not None:
            content_encoding = path_http_headers.content_encoding
        content_language = None
        if path_http_headers is not None:
            content_language = path_http_headers.content_language
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id
        if_match = None
        if modified_access_conditions is not None:
            if_match = modified_access_conditions.if_match
        if_none_match = None
        if modified_access_conditions is not None:
            if_none_match = modified_access_conditions.if_none_match
        if_modified_since = None
        if modified_access_conditions is not None:
            if_modified_since = modified_access_conditions.if_modified_since
        if_unmodified_since = None
        if modified_access_conditions is not None:
            if_unmodified_since = modified_access_conditions.if_unmodified_since

        action = "flush"

        # Construct URL
        url = self.flush_data.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if retain_uncommitted_data is not None:
            query_parameters['retainUncommittedData'] = self._serialize.query("retain_uncommitted_data", retain_uncommitted_data, 'bool')
        if close is not None:
            query_parameters['close'] = self._serialize.query("close", close, 'bool')
        query_parameters['action'] = self._serialize.query("action", action, 'str')

        # Construct headers
        header_parameters = {}
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("content_md5", content_md5, 'bytearray')
        if cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", cache_control, 'str')
        if content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", content_type, 'str')
        if content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", content_disposition, 'str')
        if content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", content_encoding, 'str')
        if content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", content_language, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
            }
            return cls(response, None, response_headers)
    flush_data.metadata = {'url': '/{filesystem}/{path}'}

    async def append_data(self, body, position=None, timeout=None, content_length=None, transactional_content_crc64=None, request_id=None, path_http_headers=None, lease_access_conditions=None, *, cls=None, **kwargs):
        """Append data to the file.

        :param body: Initial data
        :type body: Generator
        :param position: This parameter allows the caller to upload data in
         parallel and control the order in which it is appended to the file.
         It is required when uploading data to be appended to the file and when
         flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not
         immediately flushed, or written, to the file.  To flush, the
         previously uploaded data must be contiguous, the position parameter
         must be specified and equal to the length of the file after all data
         has been written, and there must not be a request entity body included
         with the request.
        :type position: long
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param content_length: Required for "Append Data" and "Flush Data".
         Must be 0 for "Flush Data".  Must be the length of the request content
         in bytes for "Append Data".
        :type content_length: long
        :param transactional_content_crc64: Specify the transactional crc64
         for the body, to be validated by the service.
        :type transactional_content_crc64: bytearray
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param path_http_headers: Additional parameters for the operation
        :type path_http_headers:
         ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        transactional_content_hash = None
        if path_http_headers is not None:
            transactional_content_hash = path_http_headers.transactional_content_hash
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        action = "append"

        # Construct URL
        url = self.append_data.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['action'] = self._serialize.query("action", action, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if transactional_content_crc64 is not None:
            header_parameters['x-ms-content-crc64'] = self._serialize.header("transactional_content_crc64", transactional_content_crc64, 'bytearray')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if transactional_content_hash is not None:
            header_parameters['Content-MD5'] = self._serialize.header("transactional_content_hash", transactional_content_hash, 'bytearray')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct body

        # Construct and send request
        request = self._client.patch(url, query_parameters, header_parameters, stream_content=body)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Content-MD5': self._deserialize('bytearray', response.headers.get('Content-MD5')),
                'x-ms-content-crc64': self._deserialize('bytearray', response.headers.get('x-ms-content-crc64')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
            }
            return cls(response, None, response_headers)
    append_data.metadata = {'url': '/{filesystem}/{path}'}

    async def set_expiry(self, expiry_options, timeout=None, request_id=None, expires_on=None, *, cls=None, **kwargs):
        """Sets the time a blob will expire and be deleted.

        :param expiry_options: Required. Indicates mode of the expiry time.
         Possible values include: 'NeverExpire', 'RelativeToCreation',
         'RelativeToNow', 'Absolute'
        :type expiry_options: str or
         ~azure.storage.filedatalake.models.PathExpiryOptions
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>
        :type timeout: int
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param expires_on: The time to set the blob to expiry
        :type expires_on: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.filedatalake.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.set_expiry.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("self.comp", self.comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-expiry-option'] = self._serialize.header("expiry_options", expiry_options, 'str')
        if expires_on is not None:
            header_parameters['x-ms-expiry-time'] = self._serialize.header("expires_on", expires_on, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    set_expiry.metadata = {'url': '/{filesystem}/{path}'}
