# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessPolicy(msrest.serialization.Model):
    """An Access policy.

    :param start: the date-time the policy is active.
    :type start: str
    :param expiry: the date-time the policy expires.
    :type expiry: str
    :param permission: the permissions for the acl policy.
    :type permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str'},
        'expiry': {'key': 'Expiry', 'type': 'str'},
        'permission': {'key': 'Permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class CorsRule(msrest.serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access resources in another domain. Web browsers implement a security restriction known as same-origin policy that prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. The origin domains that are permitted to make a request
     against the storage service via CORS. The origin domain is the domain from which the request
     originates. Note that the origin must be an exact case-sensitive match with the origin that the
     user age sends to the service. You can also use the wildcard character '*' to allow all origin
     domains to make requests via CORS.
    :type allowed_origins: str
    :param allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
     use for a CORS request. (comma separated).
    :type allowed_methods: str
    :param allowed_headers: Required. the request headers that the origin domain may specify on the
     CORS request.
    :type allowed_headers: str
    :param exposed_headers: Required. The response headers that may be sent in the response to the
     CORS request and exposed by the browser to the request issuer.
    :type exposed_headers: str
    :param max_age_in_seconds: Required. The maximum amount time that a browser should cache the
     preflight OPTIONS request.
    :type max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str'},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str'},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str'},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str'},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.allowed_methods = kwargs['allowed_methods']
        self.allowed_headers = kwargs['allowed_headers']
        self.exposed_headers = kwargs['exposed_headers']
        self.max_age_in_seconds = kwargs['max_age_in_seconds']


class DequeuedMessageItem(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Get Messages on a Queue.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The Id of the Message.
    :type message_id: str
    :param insertion_time: Required. The time the Message was inserted into the Queue.
    :type insertion_time: ~datetime.datetime
    :param expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :type expiration_time: ~datetime.datetime
    :param pop_receipt: Required. This value is required to delete the Message. If deletion fails
     using this popreceipt then the message has been dequeued by another client.
    :type pop_receipt: str
    :param time_next_visible: Required. The time that the message will again become visible in the
     Queue.
    :type time_next_visible: ~datetime.datetime
    :param dequeue_count: Required. The number of times the message has been dequeued.
    :type dequeue_count: long
    :param message_text: Required. The content of the Message.
    :type message_text: str
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'pop_receipt': {'required': True},
        'time_next_visible': {'required': True},
        'dequeue_count': {'required': True},
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'pop_receipt': {'key': 'PopReceipt', 'type': 'str'},
        'time_next_visible': {'key': 'TimeNextVisible', 'type': 'rfc-1123'},
        'dequeue_count': {'key': 'DequeueCount', 'type': 'long'},
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DequeuedMessageItem, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.pop_receipt = kwargs['pop_receipt']
        self.time_next_visible = kwargs['time_next_visible']
        self.dequeue_count = kwargs['dequeue_count']
        self.message_text = kwargs['message_text']


class EnqueuedMessage(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Put Message on a Queue.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The Id of the Message.
    :type message_id: str
    :param insertion_time: Required. The time the Message was inserted into the Queue.
    :type insertion_time: ~datetime.datetime
    :param expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :type expiration_time: ~datetime.datetime
    :param pop_receipt: Required. This value is required to delete the Message. If deletion fails
     using this popreceipt then the message has been dequeued by another client.
    :type pop_receipt: str
    :param time_next_visible: Required. The time that the message will again become visible in the
     Queue.
    :type time_next_visible: ~datetime.datetime
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'pop_receipt': {'required': True},
        'time_next_visible': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'pop_receipt': {'key': 'PopReceipt', 'type': 'str'},
        'time_next_visible': {'key': 'TimeNextVisible', 'type': 'rfc-1123'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnqueuedMessage, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.pop_receipt = kwargs['pop_receipt']
        self.time_next_visible = kwargs['time_next_visible']


class GeoReplication(msrest.serialization.Model):
    """GeoReplication.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of the secondary location. Possible values include: "live",
     "bootstrap", "unavailable".
    :type status: str or ~azure.storage.queue.models.GeoReplicationStatusType
    :param last_sync_time: Required. A GMT date/time value, to the second. All primary writes
     preceding this value are guaranteed to be available for read operations at the secondary.
     Primary writes after this point in time may or may not be available for reads.
    :type last_sync_time: ~datetime.datetime
    """

    _validation = {
        'status': {'required': True},
        'last_sync_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str'},
        'last_sync_time': {'key': 'LastSyncTime', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoReplication, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.last_sync_time = kwargs['last_sync_time']


class ListQueuesSegmentResponse(msrest.serialization.Model):
    """The object returned when calling List Queues on a Queue Service.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param prefix: Required.
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results: Required.
    :type max_results: int
    :param queue_items:
    :type queue_items: list[~azure.storage.queue.models.QueueItem]
    :param next_marker: Required.
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'prefix': {'required': True},
        'max_results': {'required': True},
        'next_marker': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'queue_items': {'key': 'QueueItems', 'type': '[QueueItem]', 'xml': {'name': 'Queues', 'wrapped': True, 'itemsName': 'Queue'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListQueuesSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.prefix = kwargs['prefix']
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs['max_results']
        self.queue_items = kwargs.get('queue_items', None)
        self.next_marker = kwargs['next_marker']


class Logging(msrest.serialization.Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of Storage Analytics to configure.
    :type version: str
    :param delete: Required. Indicates whether all delete requests should be logged.
    :type delete: bool
    :param read: Required. Indicates whether all read requests should be logged.
    :type read: bool
    :param write: Required. Indicates whether all write requests should be logged.
    :type write: bool
    :param retention_policy: Required. the retention policy.
    :type retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'delete': {'required': True},
        'read': {'required': True},
        'write': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'delete': {'key': 'Delete', 'type': 'bool'},
        'read': {'key': 'Read', 'type': 'bool'},
        'write': {'key': 'Write', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Logging, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.delete = kwargs['delete']
        self.read = kwargs['read']
        self.write = kwargs['write']
        self.retention_policy = kwargs['retention_policy']


class Metrics(msrest.serialization.Model):
    """Metrics.

    All required parameters must be populated in order to send to Azure.

    :param version: The version of Storage Analytics to configure.
    :type version: str
    :param enabled: Required. Indicates whether metrics are enabled for the Queue service.
    :type enabled: bool
    :param include_apis: Indicates whether metrics should generate summary statistics for called
     API operations.
    :type include_apis: bool
    :param retention_policy: the retention policy.
    :type retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Metrics, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.enabled = kwargs['enabled']
        self.include_apis = kwargs.get('include_apis', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class PeekedMessageItem(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Peek Messages on a Queue.

    All required parameters must be populated in order to send to Azure.

    :param message_id: Required. The Id of the Message.
    :type message_id: str
    :param insertion_time: Required. The time the Message was inserted into the Queue.
    :type insertion_time: ~datetime.datetime
    :param expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :type expiration_time: ~datetime.datetime
    :param dequeue_count: Required. The number of times the message has been dequeued.
    :type dequeue_count: long
    :param message_text: Required. The content of the Message.
    :type message_text: str
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'dequeue_count': {'required': True},
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'dequeue_count': {'key': 'DequeueCount', 'type': 'long'},
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PeekedMessageItem, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.dequeue_count = kwargs['dequeue_count']
        self.message_text = kwargs['message_text']


class QueueItem(msrest.serialization.Model):
    """An Azure Storage Queue.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the Queue.
    :type name: str
    :param metadata: Dictionary of :code:`<string>`.
    :type metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }
    _xml_map = {
        'name': 'Queue'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.metadata = kwargs.get('metadata', None)


class QueueMessage(msrest.serialization.Model):
    """A Message object which can be stored in a Queue.

    All required parameters must be populated in order to send to Azure.

    :param message_text: Required. The content of the message.
    :type message_text: str
    """

    _validation = {
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueMessage, self).__init__(**kwargs)
        self.message_text = kwargs['message_text']


class RetentionPolicy(msrest.serialization.Model):
    """the retention policy.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Indicates whether a retention policy is enabled for the storage
     service.
    :type enabled: bool
    :param days: Indicates the number of days that metrics or logging or soft-deleted data should
     be retained. All data older than this value will be deleted.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'days': {'key': 'Days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs.get('days', None)


class SignedIdentifier(msrest.serialization.Model):
    """signed identifier.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. a unique id.
    :type id: str
    :param access_policy: The access policy.
    :type access_policy: ~azure.storage.queue.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.access_policy = kwargs.get('access_policy', None)


class StorageError(msrest.serialization.Model):
    """StorageError.

    :param message:
    :type message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)


class StorageServiceProperties(msrest.serialization.Model):
    """Storage Service Properties.

    :param logging: Azure Analytics Logging settings.
    :type logging: ~azure.storage.queue.models.Logging
    :param hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
     queues.
    :type hour_metrics: ~azure.storage.queue.models.Metrics
    :param minute_metrics: a summary of request statistics grouped by API in minute aggregates for
     queues.
    :type minute_metrics: ~azure.storage.queue.models.Metrics
    :param cors: The set of CORS rules.
    :type cors: list[~azure.storage.queue.models.CorsRule]
    """

    _attribute_map = {
        'logging': {'key': 'Logging', 'type': 'Logging'},
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics'},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics'},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'wrapped': True}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.logging = kwargs.get('logging', None)
        self.hour_metrics = kwargs.get('hour_metrics', None)
        self.minute_metrics = kwargs.get('minute_metrics', None)
        self.cors = kwargs.get('cors', None)


class StorageServiceStats(msrest.serialization.Model):
    """Stats for the storage service.

    :param geo_replication: Geo-Replication information for the Secondary Storage Service.
    :type geo_replication: ~azure.storage.queue.models.GeoReplication
    """

    _attribute_map = {
        'geo_replication': {'key': 'GeoReplication', 'type': 'GeoReplication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageServiceStats, self).__init__(**kwargs)
        self.geo_replication = kwargs.get('geo_replication', None)
