#-------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#--------------------------------------------------------------------------

# Python imports
from enum import Enum
import logging

# C imports
cimport c_amqp_definitions
cimport c_message_receiver
cimport c_cbs
cimport c_xio
cimport c_amqp_management


APACHE = "apache.org"
AMQP_BATCH_MESSAGE_FORMAT = 0x80013700
AMQPS_PORT = 5671
AMQP_WSS_PORT = 443
AUTH_EXPIRATION_SECS = 60 * 60
AUTH_REFRESH_SECS = 48 * 60  # 80% of expiration period
MAX_PARTITION_KEY_LENGTH = 128
MAX_MESSAGE_LENGTH_BYTES = 1024 * 1024
MAX_FRAME_SIZE_BYTES = 64 * 1024


ROLE_SENDER = c_amqp_definitions.role_sender
ROLE_RECEIVER = c_amqp_definitions.role_receiver

SENDER_SETTLE_MODE_UNSETTLED = c_amqp_definitions.sender_settle_mode_unsettled
SENDER_SETTLE_MODE_SETTLED = c_amqp_definitions.sender_settle_mode_settled
SENDER_SETTLE_MODE_MIXED = c_amqp_definitions.sender_settle_mode_mixed

RECEIVER_SETTLE_MODE_RECEIVEANDDELETE = c_amqp_definitions.receiver_settle_mode_first
RECEIVER_SETTLE_MODE_PEEKLOCK = c_amqp_definitions.receiver_settle_mode_second

CBS_OPERATION_RESULT_OK = c_cbs.CBS_OPERATION_RESULT_TAG.CBS_OPERATION_RESULT_OK
CBS_OPERATION_RESULT_CBS_ERROR = c_cbs.CBS_OPERATION_RESULT_TAG.CBS_OPERATION_RESULT_CBS_ERROR
CBS_OPERATION_RESULT_OPERATION_FAILED = c_cbs.CBS_OPERATION_RESULT_TAG.CBS_OPERATION_RESULT_OPERATION_FAILED
CBS_OPERATION_RESULT_INSTANCE_CLOSED = c_cbs.CBS_OPERATION_RESULT_TAG.CBS_OPERATION_RESULT_INSTANCE_CLOSED

CBS_OPEN_COMPLETE_OK = c_cbs.CBS_OPEN_COMPLETE_RESULT_TAG.CBS_OPEN_OK
CBS_OPEN_COMPLETE_ERROR = c_cbs.CBS_OPEN_COMPLETE_RESULT_TAG.CBS_OPEN_ERROR
CBS_OPEN_COMPLETE_CANCELLED = c_cbs.CBS_OPEN_COMPLETE_RESULT_TAG.CBS_OPEN_CANCELLED

MESSAGE_RECEIVER_STATE_IDLE = c_message_receiver.MESSAGE_RECEIVER_STATE_TAG.MESSAGE_RECEIVER_STATE_IDLE
MESSAGE_RECEIVER_STATE_OPENING = c_message_receiver.MESSAGE_RECEIVER_STATE_TAG.MESSAGE_RECEIVER_STATE_OPENING
MESSAGE_RECEIVER_STATE_OPEN = c_message_receiver.MESSAGE_RECEIVER_STATE_TAG.MESSAGE_RECEIVER_STATE_OPEN
MESSAGE_RECEIVER_STATE_CLOSING = c_message_receiver.MESSAGE_RECEIVER_STATE_TAG.MESSAGE_RECEIVER_STATE_CLOSING
MESSAGE_RECEIVER_STATE_ERROR = c_message_receiver.MESSAGE_RECEIVER_STATE_TAG.MESSAGE_RECEIVER_STATE_ERROR

MESSAGE_SEND_OK = c_message_sender.MESSAGE_SEND_RESULT_TAG.MESSAGE_SEND_OK
MESSAGE_SEND_ERROR = c_message_sender.MESSAGE_SEND_RESULT_TAG.MESSAGE_SEND_ERROR
MESSAGE_SEND_TIMEOUT = c_message_sender.MESSAGE_SEND_RESULT_TAG.MESSAGE_SEND_TIMEOUT
MESSAGE_SEND_CANCELLED = c_message_sender.MESSAGE_SEND_RESULT_TAG.MESSAGE_SEND_CANCELLED

MESSAGE_SENDER_STATE_IDLE = c_message_sender.MESSAGE_SENDER_STATE_TAG.MESSAGE_SENDER_STATE_IDLE
MESSAGE_SENDER_STATE_OPENING = c_message_sender.MESSAGE_SENDER_STATE_TAG.MESSAGE_SENDER_STATE_OPENING
MESSAGE_SENDER_STATE_OPEN = c_message_sender.MESSAGE_SENDER_STATE_TAG.MESSAGE_SENDER_STATE_OPEN
MESSAGE_SENDER_STATE_CLOSING = c_message_sender.MESSAGE_SENDER_STATE_TAG.MESSAGE_SENDER_STATE_CLOSING
MESSAGE_SENDER_STATE_ERROR = c_message_sender.MESSAGE_SENDER_STATE_TAG.MESSAGE_SENDER_STATE_ERROR

IO_SEND_RESULT_OK = c_xio.IO_SEND_RESULT_TAG.IO_SEND_OK
IO_SEND_RESULT_ERROR = c_xio.IO_SEND_RESULT_TAG.IO_SEND_ERROR
IO_SEND_RESULT_CANCELLED = c_xio.IO_SEND_RESULT_TAG.IO_SEND_CANCELLED

IO_OPEN_RESULT_OK = c_xio.IO_OPEN_RESULT_TAG.IO_OPEN_OK
IO_OPEN_RESULT_ERROR = c_xio.IO_OPEN_RESULT_TAG.IO_OPEN_ERROR
IO_OPEN_RESULT_CANCELLED = c_xio.IO_OPEN_RESULT_TAG.IO_OPEN_CANCELLED

AMQP_MANAGEMENT_EXECUTE_OPERATION_OK = c_amqp_management.AMQP_MANAGEMENT_EXECUTE_OPERATION_RESULT_TAG.AMQP_MANAGEMENT_EXECUTE_OPERATION_OK
AMQP_MANAGEMENT_EXECUTE_OPERATION_ERROR = c_amqp_management.AMQP_MANAGEMENT_EXECUTE_OPERATION_RESULT_TAG.AMQP_MANAGEMENT_EXECUTE_OPERATION_ERROR
AMQP_MANAGEMENT_EXECUTE_OPERATION_FAILED_BAD_STATUS = c_amqp_management.AMQP_MANAGEMENT_EXECUTE_OPERATION_RESULT_TAG.AMQP_MANAGEMENT_EXECUTE_OPERATION_FAILED_BAD_STATUS
AMQP_MANAGEMENT_EXECUTE_OPERATION_INSTANCE_CLOSED = c_amqp_management.AMQP_MANAGEMENT_EXECUTE_OPERATION_RESULT_TAG.AMQP_MANAGEMENT_EXECUTE_OPERATION_INSTANCE_CLOSED

AMQP_MANAGEMENT_OPEN_OK = c_amqp_management.AMQP_MANAGEMENT_OPEN_RESULT_TAG.AMQP_MANAGEMENT_OPEN_OK
AMQP_MANAGEMENT_OPEN_ERROR = c_amqp_management.AMQP_MANAGEMENT_OPEN_RESULT_TAG.AMQP_MANAGEMENT_OPEN_ERROR
AMQP_MANAGEMENT_OPEN_CANCELLED = c_amqp_management.AMQP_MANAGEMENT_OPEN_RESULT_TAG.AMQP_MANAGEMENT_OPEN_CANCELLED

AUTH_STATUS_OK = c_cbs.AUTH_STATUS.AUTH_STATUS_OK
AUTH_STATUS_IDLE = c_cbs.AUTH_STATUS.AUTH_STATUS_IDLE
AUTH_STATUS_IN_PROGRESS = c_cbs.AUTH_STATUS.AUTH_STATUS_IN_PROGRESS
AUTH_STATUS_TIMEOUT = c_cbs.AUTH_STATUS.AUTH_STATUS_TIMEOUT
AUTH_STATUS_REFRESH_REQUIRED = c_cbs.AUTH_STATUS.AUTH_STATUS_REFRESH_REQUIRED
AUTH_STATUS_EXPIRED = c_cbs.AUTH_STATUS.AUTH_STATUS_EXPIRED
AUTH_STATUS_ERROR = c_cbs.AUTH_STATUS.AUTH_STATUS_ERROR
AUTH_STATUS_FAILURE = c_cbs.AUTH_STATUS.AUTH_STATUS_FAILURE


#### Errors

SESSION_ERROR_WINDOW_VIOLATION = "amqp:session:window-violation"
SESSION_ERROR_ERRANT_LINK = "amqp:session:errant-link"
SESSION_ERROR_HANDLE_IN_USE = "amqp:session:handle-in-use"
SESSION_ERROR_UNATTACHED_HANDLE = "amqp:session:unattached-handle"

LINK_ERROR_DETACH_FORCED = "amqp:link:detach-forced"
LINK_ERROR_TRANSFER_LIMIT_EXCEEDED = "amqp:link:transfer-limit-exceeded"
LINK_ERROR_MESSAGE_SIZE_EXCEEDED = "amqp:link:message-size-exceeded"
LINK_ERROR_REDIRECT = "amqp:link:redirect"
LINK_ERROR_STOLEN = "amqp:link:stolen"

CONNECTION_ERROR_CONNECTION_FORCED = "amqp:connection:forced"
CONNECTION_ERROR_FRAMING_ERROR = "amqp:connection:framing-error"
CONNECTION_ERROR_REDIRECT = "amqp:connection:redirect"

AMQP_ERROR_INTERNAL_ERROR = "amqp:internal-error"
AMQP_ERROR_NOT_FOUND = "amqp:not-found"
AMQP_ERROR_UNAUTHORIZED_ACCESS = "amqp:unauthorized-access"
AMQP_ERROR_DECODE_ERROR = "amqp:decode-error"
AMQP_ERROR_RESOURCE_LIMIT_EXCEEDED = "amqp:resource-limit-exceeded"
AMQP_ERROR_NOT_ALLOWED = "amqp:not-allowed"
AMQP_ERROR_INVALID_FIELD = "amqp:invalid-field"
AMQP_ERROR_NOT_IMPLEMENTED = "amqp:not-implemented"
AMQP_ERROR_RESOURCE_LOCKED = "amqp:resource-locked"
AMQP_ERROR_PRECONDITION_FAILED = "amqp:precondition-failed"
AMQP_ERROR_RESOURCE_DELETED = "amqp:resource-deleted"
AMQP_ERROR_ILLEGAL_STATE = "amqp:illegal-state"
AMQP_ERROR_FRAME_SIZE_TOO_SMALL = "amqp:frame-size-too-small"
