/*
 * File:          sidl_rmi_ServerInfo_Module.c
 * Symbol:        sidl.rmi.ServerInfo-v0.9.17
 * Symbol Type:   interface
 * Babel Version: 1.4.0 (Revision: 6607 release-1-4-0-branch)
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   implement a C extension type for a sidl extendable
 * 
 * Copyright (c) 2000-2002, Lawrence Livermore National Security, LLC.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 */

/*
 * THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL
 * COMPILER. DO NOT EDIT THIS!
 * 
 * This file contains the implementation of a Python C
 * extension type (i.e. a Python type implemented in C).
 * This extension type provides Python interface to the
 * sidl type sidl.rmi.ServerInfo.
 */


/**
 * Symbol "sidl.rmi.ServerInfo" (version 0.9.17)
 * 
 *  
 * ServerInfo is an interface (possibly implemented by the ORB
 * itself) that provides functions to deal with the problems
 * associated with passing local object remotely.  It should be
 * registered with the ServerRegistry for general use.
 */
#include <Python.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#ifndef included_sidl_BaseClass_h
#include "sidl_BaseClass.h"
#endif
#ifndef included_sidl_ClassInfo_h
#include "sidl_ClassInfo.h"
#endif
#ifndef included_sidl_rmi_ProtocolFactory_h
#include "sidl_rmi_ProtocolFactory.h"
#endif
#ifndef included_sidl_rmi_InstanceRegistry_h
#include "sidl_rmi_InstanceRegistry.h"
#endif
#ifndef included_sidl_rmi_InstanceHandle_h
#include "sidl_rmi_InstanceHandle.h"
#endif
#ifndef included_sidl_rmi_Invocation_h
#include "sidl_rmi_Invocation.h"
#endif
#ifndef included_sidl_rmi_Response_h
#include "sidl_rmi_Response.h"
#endif
#ifndef included_sidl_rmi_ServerRegistry_h
#include "sidl_rmi_ServerRegistry.h"
#endif
#ifndef included_sidl_rmi_ConnectRegistry_h
#include "sidl_rmi_ConnectRegistry.h"
#endif
#ifndef included_sidl_io_Serializable_h
#include "sidl_io_Serializable.h"
#endif
#ifndef included_sidl_MemAllocException_h
#include "sidl_MemAllocException.h"
#endif
#ifndef included_sidl_NotImplementedException_h
#include "sidl_NotImplementedException.h"
#endif
#include "sidl_Exception.h"

#ifndef NULL
#define NULL 0
#endif

#include "sidl_thread.h"
#ifdef HAVE_PTHREAD
static struct sidl_recursive_mutex_t sidl_rmi__ServerInfo__mutex= SIDL_RECURSIVE_MUTEX_INITIALIZER;
#define LOCK_STATIC_GLOBALS sidl_recursive_mutex_lock( &sidl_rmi__ServerInfo__mutex )
#define UNLOCK_STATIC_GLOBALS sidl_recursive_mutex_unlock( &sidl_rmi__ServerInfo__mutex )
/* #define HAVE_LOCKED_STATIC_GLOBALS (sidl_recursive_mutex_trylock( &sidl_rmi__ServerInfo__mutex )==EDEADLOCK) */
#else
#define LOCK_STATIC_GLOBALS
#define UNLOCK_STATIC_GLOBALS
/* #define HAVE_LOCKED_STATIC_GLOBALS (1) */
#endif

#define sidl_rmi_ServerInfo_INTERNAL 1
#include "sidl_rmi_ServerInfo_Module.h"
#ifndef included_sidl_rmi_ServerInfo_IOR_h
#include "sidl_rmi_ServerInfo_IOR.h"
#endif
#include "sidlObjA.h"
#include "sidlPyArrays.h"
#ifdef SIDL_HAVE_NUMPY
#include "oldnumeric.h"
#elif defined(SIDL_HAVE_NUMERIC_PYTHON)
#include "Numeric/arrayobject.h"
#else
#error Neither Numeric Python nor NumPy installed
#endif
#ifndef included_sidl_Loader_h
#include "sidl_Loader.h"
#endif
#ifndef included_sidl_header_h
#include "sidl_header.h"
#endif
#ifndef included_sidl_String_h
#include "sidl_String.h"
#endif
#ifndef included_sidl_Python_h
#include "sidl_Python.h"
#endif
#ifndef included_sidl_interface_IOR_h
#include "sidl_interface_IOR.h"
#endif
#include "sidl_rmi_NetworkException_Module.h"
#include "sidl_BaseInterface_Module.h"
#include "sidl_ClassInfo_Module.h"
#include "sidl_RuntimeException_Module.h"
#include "sidl_io_Serializable_Module.h"
#include "sidl_rmi_Call_Module.h"
#include "sidl_rmi_Return_Module.h"
#include "sidl_rmi_Ticket_Module.h"
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

/*
 * lang_inited is a boolean value showing if we have already imported all the nescessary modules
 */

static int lang_inited = 0;

static void _loadDependentMods(void) {
  PyGILState_STATE _gstate;
#if (PY_VERSION_HEX >= 0x02040000)
  _gstate = PyGILState_Ensure();
  sidl_Python_LogGILEnsure(__func__, __FILE__, __LINE__, (int)_gstate);
#endif /* Python 2.4 or later */
  sidl_BaseInterface__import();
  sidl_ClassInfo__import();
  sidl_RuntimeException__import();
  sidl_io_Serializable__import();
  sidl_rmi_ServerInfo__import();
  sidl_rmi_Ticket__import();
#if (PY_VERSION_HEX >= 0x02040000)
  PyGILState_Release(_gstate);
  sidl_Python_LogGILRelease(__func__, __FILE__, __LINE__, (int)_gstate);
#endif /* Python 2.4 or later */
}

#define LANG_SPECIFIC_INIT() if(!lang_inited) { \
  lang_inited = 1; \
  _loadDependentMods(); \
}

#ifdef WITH_RMI

/**
 * RMI connector function for the class. (no addref)
 */
struct sidl_rmi_ServerInfo__object*
sidl_rmi_ServerInfo__connectI(const char * url, sidl_bool ar, struct          \
  sidl_BaseInterface__object **_ex);


#endif /*WITH_RMI*/

/* Static variables to hold version of IOR */
static const int32_t s_IOR_MAJOR_VERSION = 2;
static const int32_t s_IOR_MINOR_VERSION = 0;

/* Static variables for managing EPV initialization. */
static int s_remote_initialized = 0;

static struct sidl_rmi__ServerInfo__epv s_rem_epv__sidl_rmi__serverinfo;

static struct sidl_BaseInterface__epv s_rem_epv__sidl_baseinterface;

static struct sidl_rmi_ServerInfo__epv s_rem_epv__sidl_rmi_serverinfo;

#ifdef WITH_RMI


/* REMOTE CAST: dynamic type casting for remote objects. */
static void* remote_sidl_rmi__ServerInfo__cast(
  struct sidl_rmi__ServerInfo__object* self,
  const char* name, sidl_BaseInterface* _ex)
{
  int cmp;
  void* cast = NULL;
  *_ex = NULL; /* default to no exception */
  cmp = strcmp(name, "sidl.rmi.ServerInfo");
  if (!cmp) {
    (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
    cast = &((*self).d_sidl_rmi_serverinfo);
    return cast;
  }
  else if (cmp < 0) {
    cmp = strcmp(name, "sidl.BaseInterface");
    if (!cmp) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = &((*self).d_sidl_baseinterface);
      return cast;
    }
  }
  else if (cmp > 0) {
    cmp = strcmp(name, "sidl.rmi._ServerInfo");
    if (!cmp) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = ((struct sidl_rmi__ServerInfo__object*)self);
      return cast;
    }
  }
  if ((*self->d_epv->f_isType)(self,name, _ex)) {
    void* (*func)(struct sidl_rmi_InstanceHandle__object*, struct             \
      sidl_BaseInterface__object**) = 
      (void* (*)(struct sidl_rmi_InstanceHandle__object*, struct              \
        sidl_BaseInterface__object**)) 
      sidl_rmi_ConnectRegistry_getConnect(name, _ex);SIDL_CHECK(*_ex);
    cast =  (*func)(((struct                                                  \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih, _ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/* REMOTE DELETE: call the remote destructor for the object. */
static void remote_sidl_rmi__ServerInfo__delete(
  struct sidl_rmi__ServerInfo__object* self,
  struct sidl_BaseInterface__object* *_ex)
{
  *_ex = NULL;
  free((void*) self);
}

/* REMOTE GETURL: call the getURL function for the object. */
static char* remote_sidl_rmi__ServerInfo__getURL(
  struct sidl_rmi__ServerInfo__object* self, struct                           \
    sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi_InstanceHandle__object *conn = ((struct                     \
    sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
  *_ex = NULL;
  if(conn != NULL) {
    return sidl_rmi_InstanceHandle_getObjectURL(conn, _ex);
  }
  return NULL;
}

/* REMOTE ADDREF: For internal babel use only! Remote addRef. */
static void remote_sidl_rmi__ServerInfo__raddRef(
  struct sidl_rmi__ServerInfo__object* self,struct                            \
    sidl_BaseInterface__object* *_ex)
{
  struct sidl_BaseException__object* netex = NULL;
  /* initialize a new invocation */
  struct sidl_BaseInterface__object* _throwaway = NULL;
  struct sidl_rmi_InstanceHandle__object *_conn = ((struct                    \
    sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
  sidl_rmi_Response _rsvp = NULL;
  sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation( _conn, \
    "addRef", _ex ); SIDL_CHECK(*_ex);
  /* send actual RMI request */
  _rsvp = sidl_rmi_Invocation_invokeMethod(_inv,_ex);SIDL_CHECK(*_ex);
  /* Check for exceptions */
  netex = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);
  if(netex != NULL) {
    *_ex = (struct sidl_BaseInterface__object*)netex;
    return;
  }

  /* cleanup and return */
  EXIT:
  if(_inv) { sidl_rmi_Invocation_deleteRef(_inv,&_throwaway); }
  if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp,&_throwaway); }
  return;
}

/* REMOTE ISREMOTE: returns true if this object is Remote (it is). */
static sidl_bool
remote_sidl_rmi__ServerInfo__isRemote(
    struct sidl_rmi__ServerInfo__object* self, 
    struct sidl_BaseInterface__object* *_ex) {
  *_ex = NULL;
  return TRUE;
}

/* REMOTE METHOD STUB:_set_hooks */
static void
remote_sidl_rmi__ServerInfo__set_hooks(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ sidl_bool enable,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_hooks", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "enable", enable, _ex);SIDL_CHECK(    \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo._set_hooks.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* Contract enforcement has not been implemented for remote use. */
/* REMOTE METHOD STUB:_set_contracts */
static void
remote_sidl_rmi__ServerInfo__set_contracts(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ sidl_bool enable,
  /* in */ const char* enfFilename,
  /* in */ sidl_bool resetCounters,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_contracts", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "enable", enable, _ex);SIDL_CHECK(    \
      *_ex);
    sidl_rmi_Invocation_packString( _inv, "enfFilename", enfFilename,         \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packBool( _inv, "resetCounters", resetCounters,       \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo._set_contracts.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* Contract enforcement has not been implemented for remote use. */
/* REMOTE METHOD STUB:_dump_stats */
static void
remote_sidl_rmi__ServerInfo__dump_stats(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ const char* filename,
  /* in */ const char* prefix,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_dump_stats", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "filename", filename,               \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packString( _inv, "prefix", prefix, _ex);SIDL_CHECK(  \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo._dump_stats.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EXEC: call the exec function for the object. */
static void remote_sidl_rmi__ServerInfo__exec(
  struct sidl_rmi__ServerInfo__object* self,const char* methodName,
  sidl_rmi_Call inArgs,
  sidl_rmi_Return outArgs,
  struct sidl_BaseInterface__object* *_ex)
{
  *_ex = NULL;
}

/* REMOTE METHOD STUB:getServerURL */
static char*
remote_sidl_rmi__ServerInfo_getServerURL(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ const char* objID,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getServerURL", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "objID", objID, _ex);SIDL_CHECK(    \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.getServerURL.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:isLocalObject */
static char*
remote_sidl_rmi__ServerInfo_isLocalObject(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ const char* url,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isLocalObject", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "url", url, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.isLocalObject.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getExceptions */
static struct sidl_io_Serializable__array*
remote_sidl_rmi__ServerInfo_getExceptions(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_io_Serializable__array* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getExceptions", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.getExceptions.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackSerializableArray( _rsvp, "_retval", (struct      \
      sidl_io_Serializable__array**)&_retval,0,0,FALSE, _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:addRef */
static void
remote_sidl_rmi__ServerInfo_addRef(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi__ServerInfo__remote* r_obj = (struct                      \
      sidl_rmi__ServerInfo__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount++;
#ifdef SIDL_DEBUG_REFCOUNT
    fprintf(stderr, "babel: addRef %p new count %d (type %s)\n",
      r_obj, r_obj->d_refcount, 
      "sidl.rmi._ServerInfo Remote Stub");
#endif /* SIDL_DEBUG_REFCOUNT */ 
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:deleteRef */
static void
remote_sidl_rmi__ServerInfo_deleteRef(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi__ServerInfo__remote* r_obj = (struct                      \
      sidl_rmi__ServerInfo__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount--;
#ifdef SIDL_DEBUG_REFCOUNT
    fprintf(stderr, "babel: deleteRef %p new count %d (type %s)\n",r_obj, r_obj->d_refcount, "sidl.rmi._ServerInfo Remote Stub");
#endif /* SIDL_DEBUG_REFCOUNT */ 
    if(r_obj->d_refcount == 0) {
      sidl_rmi_InstanceHandle_deleteRef(r_obj->d_ih, _ex);
      free(r_obj);
      free(self);
    }
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:isSame */
static sidl_bool
remote_sidl_rmi__ServerInfo_isSame(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ struct sidl_BaseInterface__object* iobj,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isSame", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(iobj){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)iobj,       \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "iobj", _url, _ex);SIDL_CHECK(    \
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "iobj", NULL, _ex);SIDL_CHECK(    \
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.isSame.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:isType */
static sidl_bool
remote_sidl_rmi__ServerInfo_isType(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* in */ const char* name,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isType", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.isType.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getClassInfo */
static struct sidl_ClassInfo__object*
remote_sidl_rmi__ServerInfo_getClassInfo(
  /* in */ struct sidl_rmi__ServerInfo__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char*_retval_str = NULL;
    struct sidl_ClassInfo__object* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi__ServerInfo__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getClassInfo", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi._ServerInfo.getClassInfo.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval_str,           \
      _ex);SIDL_CHECK(*_ex);
    _retval = sidl_ClassInfo__connectI(_retval_str, FALSE, _ex);SIDL_CHECK(   \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE EPV: create remote entry point vectors (EPVs). */
static void sidl_rmi__ServerInfo__init_remote_epv(void)
{
  /* assert( HAVE_LOCKED_STATIC_GLOBALS ); */
  struct sidl_rmi__ServerInfo__epv* epv = &s_rem_epv__sidl_rmi__serverinfo;
  struct sidl_BaseInterface__epv*   e0  = &s_rem_epv__sidl_baseinterface;
  struct sidl_rmi_ServerInfo__epv*  e1  = &s_rem_epv__sidl_rmi_serverinfo;

  epv->f__cast               = remote_sidl_rmi__ServerInfo__cast;
  epv->f__delete             = remote_sidl_rmi__ServerInfo__delete;
  epv->f__exec               = remote_sidl_rmi__ServerInfo__exec;
  epv->f__getURL             = remote_sidl_rmi__ServerInfo__getURL;
  epv->f__raddRef            = remote_sidl_rmi__ServerInfo__raddRef;
  epv->f__isRemote           = remote_sidl_rmi__ServerInfo__isRemote;
  epv->f__set_hooks          = remote_sidl_rmi__ServerInfo__set_hooks;
  epv->f__set_contracts      = remote_sidl_rmi__ServerInfo__set_contracts;
  epv->f__dump_stats         = remote_sidl_rmi__ServerInfo__dump_stats;
  epv->f__ctor               = NULL;
  epv->f__ctor2              = NULL;
  epv->f__dtor               = NULL;
  epv->f_getServerURL        = remote_sidl_rmi__ServerInfo_getServerURL;
  epv->f_isLocalObject       = remote_sidl_rmi__ServerInfo_isLocalObject;
  epv->f_getExceptions       = remote_sidl_rmi__ServerInfo_getExceptions;
  epv->f_addRef              = remote_sidl_rmi__ServerInfo_addRef;
  epv->f_deleteRef           = remote_sidl_rmi__ServerInfo_deleteRef;
  epv->f_isSame              = remote_sidl_rmi__ServerInfo_isSame;
  epv->f_isType              = remote_sidl_rmi__ServerInfo_isType;
  epv->f_getClassInfo        = remote_sidl_rmi__ServerInfo_getClassInfo;

  e0->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e0->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e0->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e0->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e0->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e0->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e0->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e0->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e0->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e0->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e0->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e0->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e0->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e0->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e1->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e1->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e1->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e1->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e1->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e1->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e1->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e1->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e1->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e1->f_getServerURL   = (char* (*)(void*,const char*,struct                  \
    sidl_BaseInterface__object **)) epv->f_getServerURL;
  e1->f_isLocalObject  = (char* (*)(void*,const char*,struct                  \
    sidl_BaseInterface__object **)) epv->f_isLocalObject;
  e1->f_getExceptions  = (struct sidl_io_Serializable__array* (*)(void*,      \
    struct sidl_BaseInterface__object **)) epv->f_getExceptions;
  e1->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e1->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e1->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e1->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e1->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  s_remote_initialized = 1;
}

/* Create an instance that connects to an existing remote object. */
static struct sidl_rmi_ServerInfo__object*
sidl_rmi_ServerInfo__remoteConnect(const char *url, sidl_bool ar, struct      \
  sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi__ServerInfo__object* self = NULL;

  struct sidl_rmi__ServerInfo__object* s0;

  struct sidl_rmi__ServerInfo__remote* r_obj = NULL;
  sidl_rmi_InstanceHandle instance = NULL;
  struct sidl_rmi_ServerInfo__object* ret_self = NULL;
  char* objectID = NULL;
  objectID = sidl_rmi_ServerRegistry_isLocalObject(url, _ex);
  if(objectID) {
    sidl_BaseInterface bi = (sidl_BaseInterface)                              \
      sidl_rmi_InstanceRegistry_getInstanceByString(objectID, _ex);
    return (struct sidl_rmi_ServerInfo__object*)(*bi->d_epv->f__cast)(        \
      bi->d_object, "sidl.rmi.ServerInfo", _ex);
  }
  instance = sidl_rmi_ProtocolFactory_connectInstance(url,                    \
    "sidl.rmi.ServerInfo", ar, _ex );
  if ( instance == NULL) { return NULL; }
  self =
    (struct sidl_rmi__ServerInfo__object*) malloc(
      sizeof(struct sidl_rmi__ServerInfo__object));

  r_obj =
    (struct sidl_rmi__ServerInfo__remote*) malloc(
      sizeof(struct sidl_rmi__ServerInfo__remote));

  if(!self || !r_obj) {
    sidl_MemAllocException ex = sidl_MemAllocException_getSingletonException( \
      _ex);
    SIDL_CHECK(*_ex);
    sidl_MemAllocException_setNote(ex, "Out of memory.", _ex); SIDL_CHECK(    \
      *_ex);
    sidl_MemAllocException_add(ex, __FILE__, __LINE__,                        \
      "sidl.rmi._ServerInfo.EPVgeneration", _ex);
    SIDL_CHECK(*_ex);
    *_ex = (struct sidl_BaseInterface__object*)ex;
    goto EXIT;
  }

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                self;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi__ServerInfo__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s0->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s0->d_sidl_baseinterface.d_object = (void*) self;

  s0->d_sidl_rmi_serverinfo.d_epv    = &s_rem_epv__sidl_rmi_serverinfo;
  s0->d_sidl_rmi_serverinfo.d_object = (void*) self;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi__serverinfo;

  self->d_data = (void*) r_obj;

  ret_self = (struct sidl_rmi_ServerInfo__object*) (*self->d_epv->f__cast)(   \
    self, "sidl.rmi.ServerInfo", _ex);
  if(*_ex || !ret_self) { goto EXIT; }
  return ret_self;
  EXIT:
  if(self) { free(self); }
  if(r_obj) { free(r_obj); }
  return NULL;
}
/* Create an instance that uses an already existing  */
/* InstanceHandel to connect to an existing remote object. */
static struct sidl_rmi_ServerInfo__object*
sidl_rmi_ServerInfo__IHConnect(sidl_rmi_InstanceHandle instance, struct       \
  sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi__ServerInfo__object* self = NULL;

  struct sidl_rmi__ServerInfo__object* s0;

  struct sidl_rmi__ServerInfo__remote* r_obj = NULL;
  struct sidl_rmi_ServerInfo__object* ret_self = NULL;
  self =
    (struct sidl_rmi__ServerInfo__object*) malloc(
      sizeof(struct sidl_rmi__ServerInfo__object));

  r_obj =
    (struct sidl_rmi__ServerInfo__remote*) malloc(
      sizeof(struct sidl_rmi__ServerInfo__remote));

  if(!self || !r_obj) {
    sidl_MemAllocException ex = sidl_MemAllocException_getSingletonException( \
      _ex);
    SIDL_CHECK(*_ex);
    sidl_MemAllocException_setNote(ex, "Out of memory.", _ex); SIDL_CHECK(    \
      *_ex);
    sidl_MemAllocException_add(ex, __FILE__, __LINE__,                        \
      "sidl.rmi._ServerInfo.EPVgeneration", _ex);
    SIDL_CHECK(*_ex);
    *_ex = (struct sidl_BaseInterface__object*)ex;
    goto EXIT;
  }

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                self;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi__ServerInfo__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s0->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s0->d_sidl_baseinterface.d_object = (void*) self;

  s0->d_sidl_rmi_serverinfo.d_epv    = &s_rem_epv__sidl_rmi_serverinfo;
  s0->d_sidl_rmi_serverinfo.d_object = (void*) self;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi__serverinfo;

  self->d_data = (void*) r_obj;

  sidl_rmi_InstanceHandle_addRef(instance, _ex);

  ret_self = (struct sidl_rmi_ServerInfo__object*) (*self->d_epv->f__cast)(   \
    self, "sidl.rmi.ServerInfo", _ex);
  if(*_ex || !ret_self) { goto EXIT; }
  return ret_self;
  EXIT:
  if(self) { free(self); }
  if(r_obj) { free(r_obj); }
  return NULL;
}
/*
 * RMI connector function for the class.
 */

struct sidl_rmi_ServerInfo__object*
sidl_rmi_ServerInfo__connectI(const char* url, sidl_bool ar, struct           \
  sidl_BaseInterface__object **_ex)
{
  return sidl_rmi_ServerInfo__remoteConnect(url, ar, _ex);
}


#endif /*WITH_RMI*/
#ifdef WITH_RMI

static PyObject *
pStub_ServerInfo__connect(PyObject *_ignored, PyObject *_args, PyObject       \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object* self = NULL;
  char* url = NULL;
  struct sidl_BaseInterface__object *_exception = NULL;
  static char *_kwlist[] = {
    "url",
    NULL
  };
  int _okay;
  sidl_rmi_NetworkException__import();
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "z", _kwlist,
    &url);
  if (_okay) {
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    self = sidl_rmi_ServerInfo__remoteConnect(url,1,&_exception);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    if (_exception) {
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _eargs);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_BEGIN_ALLOW_THREADS
        sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_END_ALLOW_THREADS
        sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
        Py_XDECREF(_eargs);
      }
    }
    else {
      _return_value = Py_BuildValue(
        "O&",
        (void *)sidl_rmi_ServerInfo__wrap, self);
    }
  }
  return _return_value;
}


#endif /*WITH_RMI*/
staticforward PyTypeObject _sidl_rmi_ServerInfoType;

static PyObject *
pStub_ServerInfo__exec(PyObject *_self, PyObject *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    char* methodName = NULL;
    struct sidl_rmi_Call__object* inArgs = NULL;
    struct sidl_rmi_Return__object* outArgs = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "methodName",
      "inArgs",
      "outArgs",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    sidl_rmi_Call__import();
    sidl_rmi_Return__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "zO&O&", _kwlist,
      &methodName,
      (void *)sidl_rmi_Call__convert, &inArgs,
      (void *)sidl_rmi_Return__convert, &outArgs);
    if (_okay) {
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f__exec))(_self_ior->d_object, methodName, inArgs, \
        outArgs, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      sidl_rmi_Call_deref(inArgs);
      sidl_rmi_Return_deref(outArgs);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo__getURL(PyObject *_self, PyObject *_args, PyObject *_kwdict) \
  {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      char* _return = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f__getURL))(_self_ior->d_object,         \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
        free((void *)_return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo__isLocal(PyObject *_self, PyObject *_args, PyObject          \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = !(*(_self_ior->d_epv->f__isRemote))(_self_ior->d_object,      \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo__isRemote(PyObject *_self, PyObject *_args, PyObject         \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f__isRemote))(_self_ior->d_object,       \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo__set_hooks(PyObject *_self, PyObject *_args, PyObject        \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    sidl_bool enable = (sidl_bool) 0;
    struct sidl_BaseInterface__object *_exception = NULL;
    int _proxy_enable;
    static char *_kwlist[] = {
      "enable",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "i", _kwlist,
      &_proxy_enable);
    if (_okay) {
      enable = (_proxy_enable ? (TRUE) : (FALSE));
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f__set_hooks))(_self_ior->d_object, enable,        \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo_getExceptions(PyObject *_self, PyObject *_args, PyObject     \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    sidl_io_Serializable__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      struct sidl_io_Serializable__array* _return = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f_getExceptions))(_self_ior->d_object,   \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "O&",
          (void *)sidl_io_Serializable__convert_sidl_array, _return);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_BEGIN_ALLOW_THREADS
        sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
        sidl_python_deleteRef_array((struct sidl__array *)_return);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_END_ALLOW_THREADS
        sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo_getServerURL(PyObject *_self, PyObject *_args, PyObject      \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    char* objID = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "objID",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "z", _kwlist,
      &objID);
    if (_okay) {
      char* _return = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f_getServerURL))(_self_ior->d_object,    \
        objID, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
        free((void *)_return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static PyObject *
pStub_ServerInfo_isLocalObject(PyObject *_self, PyObject *_args, PyObject     \
  *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ServerInfo__object *_self_ior =
    ((struct sidl_rmi_ServerInfo__object *)
     sidl_Cast(_self, "sidl.rmi.ServerInfo"));
  if (_self_ior) {
    char* url = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "url",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "z", _kwlist,
      &url);
    if (_okay) {
      char* _return = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f_isLocalObject))(_self_ior->d_object,   \
        url, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
        free((void *)_return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior->d_object,                 \
        &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ServerInfo");
  }
  return _return_value;
}

static int
sidl_rmi_ServerInfo_createCast(PyObject *self, PyObject *args, PyObject       \
  *kwds) {
  struct sidl_rmi_ServerInfo__object *optarg = NULL;
  static char *_kwlist[] = { "sobj", NULL };
  int _okay = PyArg_ParseTupleAndKeywords(args, kwds, "O&", _kwlist, (void    \
    *)sidl_rmi_ServerInfo__convert, &optarg);
  if (_okay) {
    return sidl_Object_Init(
      (SPObject *)self,
      (struct sidl_BaseInterface__object *)optarg->d_object,
      sidl_PyStealRef);
  }
  return -1;
}

static PyMethodDef _ServerInfoModuleMethods[] = {

#ifdef WITH_RMI

  { "_connect", (PyCFunction)pStub_ServerInfo__connect,
  (METH_VARARGS | METH_KEYWORDS),
"\
_connect( in string url)\n\
RETURNS\n\
   ( out sidl.rmi.ServerInfo self)\n\
RAISES\n\
    sidl.rmi.NetworkException\n\
"
   },

#endif /*WITH_RMI*/

  { NULL, NULL }
};

static PyMethodDef _ServerInfoObjectMethods[] = {
  { "_exec", (PyCFunction)pStub_ServerInfo__exec,
  (METH_VARARGS | METH_KEYWORDS),
"\
_exec( in string methodName,\n\
       in sidl.rmi.Call inArgs,\n\
       in sidl.rmi.Return outArgs)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Select and execute a method by name"
   },
  { "_getURL", (PyCFunction)pStub_ServerInfo__getURL,
  (METH_VARARGS | METH_KEYWORDS),
"\
_getURL()\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Get the URL of the Implementation of this object (for RMI)"
   },
  { "_isLocal", (PyCFunction)pStub_ServerInfo__isLocal,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isLocal()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is local, false if remote"
   },
  { "_isRemote", (PyCFunction)pStub_ServerInfo__isRemote,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isRemote()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is remote, false if local"
   },
  { "_set_hooks", (PyCFunction)pStub_ServerInfo__set_hooks,
  (METH_VARARGS | METH_KEYWORDS),
"\
_set_hooks( in bool enable)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Method to enable/disable method hooks invocation."
   },
  { "getExceptions", (PyCFunction)pStub_ServerInfo_getExceptions,
  (METH_VARARGS | METH_KEYWORDS),
"\
getExceptions()\n\
RETURNS\n\
   (array<sidl.io.Serializable> _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
 \n\
This gets an array of logged exceptions.  If an exception\n\
can not be thrown back to the caller, we log it with the\n\
Server.  This gets the array of all those exceptions.  THIS\n\
IS SOMETHING OF A TEST! THIS MAY CHANGE!"
   },
  { "getServerURL", (PyCFunction)pStub_ServerInfo_getServerURL,
  (METH_VARARGS | METH_KEYWORDS),
"\
getServerURL( in string objID)\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
"
   },
  { "isLocalObject", (PyCFunction)pStub_ServerInfo_isLocalObject,
  (METH_VARARGS | METH_KEYWORDS),
"\
isLocalObject( in string url)\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
 \n\
For internal Babel use ONLY. Needed by Babel to determine if\n\
a url points to a local or remote object.  Returns the\n\
objectID if is local, Null otherwise."
   },
  { NULL, NULL }
};

static PyTypeObject _sidl_rmi_ServerInfoType = {
  PyObject_HEAD_INIT(NULL)
  0,      /* ob_size */
  "sidl.rmi.ServerInfo.ServerInfo", /* tp_name */
  0,      /* tp_basicsize */
  0,      /* tp_itemsize */
  0,      /* tp_dealloc */
  0,      /* tp_print */
  0,      /* tp_getattr */
  0,      /* tp_setattr */
  0,      /* tp_compare */
  0,      /* tp_repr */
  0,      /* tp_as_number */
  0,      /* tp_as_sequence */
  0,      /* tp_as_mapping */
  0,      /* tp_hash  */
  0,      /* tp_call */
  0,      /* tp_str */
  0,      /* tp_getattro */
  0,      /* tp_setattro */
  0,      /* tp_as_buffer */
  Py_TPFLAGS_DEFAULT, /* tp_flags */
  "\
\
 \n\
ServerInfo is an interface (possibly implemented by the ORB\n\
itself) that provides functions to deal with the problems\n\
associated with passing local object remotely.  It should be\n\
registered with the ServerRegistry for general use.", /* tp_doc */
  0,      /* tp_traverse */
  0,       /* tp_clear */
  0,       /* tp_richcompare */
  0,       /* tp_weaklistoffset */
  0,       /* tp_iter */
  0,       /* tp_iternext */
  _ServerInfoObjectMethods, /* tp_methods */
  0,       /* tp_members */
  0,       /* tp_getset */
  0,       /* tp_base */
  0,       /* tp_dict */
  0,       /* tp_descr_get */
  0,       /* tp_descr_set */
  0,       /* tp_dictoffset */
  sidl_rmi_ServerInfo_createCast,   /* tp_init */
  0,       /* tp_alloc */
  0,       /* tp_new */
};

sidl_rmi_ServerInfo__wrap_RETURN
sidl_rmi_ServerInfo__wrap sidl_rmi_ServerInfo__wrap_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ServerInfoType.tp_new(&_sidl_rmi_ServerInfoType, NULL, \
      NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj->d_object),
        sidl_PyStealRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ServerInfo__weakRef_RETURN
sidl_rmi_ServerInfo__weakRef sidl_rmi_ServerInfo__weakRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ServerInfoType.tp_new(&_sidl_rmi_ServerInfoType, NULL, \
      NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj->d_object),
        sidl_PyWeakRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ServerInfo_deref_RETURN
sidl_rmi_ServerInfo_deref sidl_rmi_ServerInfo_deref_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_deleteRef))(sidlobj->d_object, &throwaway_exception);
  }
}

sidl_rmi_ServerInfo__newRef_RETURN
sidl_rmi_ServerInfo__newRef sidl_rmi_ServerInfo__newRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ServerInfoType.tp_new(&_sidl_rmi_ServerInfoType, NULL, \
      NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj->d_object),
        sidl_PyNewRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ServerInfo__addRef_RETURN
sidl_rmi_ServerInfo__addRef sidl_rmi_ServerInfo__addRef_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_addRef))(sidlobj->d_object, &throwaway_exception);
  }
}

sidl_rmi_ServerInfo_PyType_RETURN
sidl_rmi_ServerInfo_PyType sidl_rmi_ServerInfo_PyType_PROTO {
  Py_INCREF(&_sidl_rmi_ServerInfoType);
  return &_sidl_rmi_ServerInfoType;
}

sidl_rmi_ServerInfo__convert_RETURN
sidl_rmi_ServerInfo__convert sidl_rmi_ServerInfo__convert_PROTO {
  if (*sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    (*((*sidlobj)->d_epv->f_deleteRef))((*sidlobj)->d_object,                 \
      &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
  }
  *sidlobj = sidl_Cast(obj, "sidl.rmi.ServerInfo");
  if ((!(*sidlobj)) && (obj != Py_None)) {
    PyErr_SetString(PyExc_TypeError, 
      "argument is not a(n) sidl.rmi.ServerInfo");
    return 0;
  }
  return 1;
}

static int
_convertPython(void *sidlarray, const int *ind, PyObject *pyobj)
{
  struct sidl_rmi_ServerInfo__object *sidlobj = NULL;
  if (sidl_rmi_ServerInfo__convert(pyobj, &sidlobj)) {
    sidl_interface__array_set((struct sidl_interface__array *)sidlarray,
    ind, (struct sidl_BaseInterface__object *)sidlobj);
    if (sidlobj) {
      struct sidl_BaseInterface__object *asInt = (struct                      \
        sidl_BaseInterface__object *)sidlobj;
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*asInt->d_epv->f_deleteRef)(asInt->d_object, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
    return FALSE;
  }
  return TRUE;
}

sidl_rmi_ServerInfo__convert_python_array_RETURN
sidl_rmi_ServerInfo__convert_python_array                                     \
  sidl_rmi_ServerInfo__convert_python_array_PROTO {
  int result = 0;
  if (*sidlarray) {
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    sidl__array_deleteRef((struct sidl__array *)*sidlarray);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    *sidlarray = NULL;
  }
  if (obj == Py_None) {
    result = TRUE;
  }
  else {
    PyObject *pya = PyArray_FromObject(obj, PyArray_OBJECT, 0, 0);
    if (pya) {
      if (PyArray_OBJECT == ((PyArrayObject *)pya)->descr->type_num) {
        int dimen, lower[SIDL_MAX_ARRAY_DIMENSION],
          upper[SIDL_MAX_ARRAY_DIMENSION],
          stride[SIDL_MAX_ARRAY_DIMENSION];
        if (sidl_array__extract_python_info
          (pya, &dimen, lower, upper, stride))
        {
            *sidlarray = (struct                                              \
              sidl_rmi_ServerInfo__array*)sidl_interface__array_createRow
            (dimen, lower, upper);
          result = sidl_array__convert_python
            (pya, dimen, *sidlarray, _convertPython);
          if (*sidlarray && !result) {
#if (PY_VERSION_HEX >= 0x02040000)
            Py_BEGIN_ALLOW_THREADS
            sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            sidl_interface__array_deleteRef(
              (struct  sidl_interface__array *)*sidlarray);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_END_ALLOW_THREADS
            sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            *sidlarray = NULL;
          }
        }
      }
      Py_DECREF(pya);
    }
  }
  return result;
}

static int
_convertSIDL(void *sidlarray, const int *ind, PyObject **dest)
{
  struct sidl_rmi_ServerInfo__object *sidlobj = (struct                       \
    sidl_rmi_ServerInfo__object*)
  sidl_interface__array_get((struct sidl_interface__array *)
    sidlarray, ind);
  *dest = sidl_rmi_ServerInfo__wrap(sidlobj);
  return (*dest == NULL);
}

sidl_rmi_ServerInfo__convert_sidl_array_RETURN
sidl_rmi_ServerInfo__convert_sidl_array                                       \
  sidl_rmi_ServerInfo__convert_sidl_array_PROTO {
  PyObject *pya = NULL;
  if (sidlarray) {
    const int dimen = sidlArrayDim(sidlarray);
    int numelem[7];
    int32_t start[7];
#if SIZEOF_INT != 4
    int lower[7];
    int upper[7];
    int32_t s_numelem[7];
#else
    int * const lower = (int *)(sidlarray->d_lower);
    int * const upper = (int *)(sidlarray->d_upper);
    int32_t * const s_numelem = numelem;
#endif
    int i;
    for(i = 0; i < dimen; ++i) {
      start[i] = sidlLower(sidlarray, i);
#if SIZEOF_INT != 4
      lower[i] = sidlLower(sidlarray, i);
      upper[i] = sidlUpper(sidlarray, i);
      s_numelem[i] = sidlLength(sidlarray, i);
#endif
      numelem[i] = 1 + upper[i] - lower[i];
    }
    pya = PyArray_FromDims(dimen, numelem, PyArray_OBJECT);
    if (pya) {
      if (!sidl_array__convert_sidl(pya, dimen, start,
        sidlarray->d_upper,
        s_numelem, sidlarray, _convertSIDL))
      {
        Py_DECREF(pya);
        pya = NULL;
      }
    }
  }
  else {
    Py_INCREF(Py_None);
    pya = Py_None;
  }
  return pya;
}

void
initServerInfo(void) {
  PyObject *module, *dict, *c_api;
  static void *ExternalAPI[sidl_rmi_ServerInfo__API_NUM];
  struct sidl_BaseInterface__object *throwaway_exception;
  module = Py_InitModule3("ServerInfo", _ServerInfoModuleMethods, "\
\
 \n\
ServerInfo is an interface (possibly implemented by the ORB\n\
itself) that provides functions to deal with the problems\n\
associated with passing local object remotely.  It should be\n\
registered with the ServerRegistry for general use."
  );
  dict = PyModule_GetDict(module);
  ExternalAPI[sidl_rmi_ServerInfo__wrap_NUM] = (                              \
    void*)sidl_rmi_ServerInfo__wrap;
  ExternalAPI[sidl_rmi_ServerInfo__convert_NUM] = (                           \
    void*)sidl_rmi_ServerInfo__convert;
  ExternalAPI[sidl_rmi_ServerInfo__convert_python_array_NUM] = (              \
    void*)sidl_rmi_ServerInfo__convert_python_array;
  ExternalAPI[sidl_rmi_ServerInfo__convert_sidl_array_NUM] = (                \
    void*)sidl_rmi_ServerInfo__convert_sidl_array;
  ExternalAPI[sidl_rmi_ServerInfo__weakRef_NUM] = (                           \
    void*)sidl_rmi_ServerInfo__weakRef;
  ExternalAPI[sidl_rmi_ServerInfo_deref_NUM] = (                              \
    void*)sidl_rmi_ServerInfo_deref;
  ExternalAPI[sidl_rmi_ServerInfo__newRef_NUM] = (                            \
    void*)sidl_rmi_ServerInfo__newRef;
  ExternalAPI[sidl_rmi_ServerInfo__addRef_NUM] = (                            \
    void*)sidl_rmi_ServerInfo__addRef;
  ExternalAPI[sidl_rmi_ServerInfo_PyType_NUM] = (                             \
    void*)sidl_rmi_ServerInfo_PyType;
#ifdef WITH_RMI
  ExternalAPI[sidl_rmi_ServerInfo__connectI_NUM] = (                          \
    void*)sidl_rmi_ServerInfo__connectI;
#endif /*WITH_RMI*/
  import_SIDLObjA();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlObjA module.");
  }
  c_api = PyCObject_FromVoidPtr((void *)ExternalAPI, NULL);
  PyDict_SetItemString(dict, "_C_API", c_api);
  Py_XDECREF(c_api);
  import_SIDLPyArrays();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlPyArrays module.");
  }
  import_array();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing Numeric Python module.");
  }
  sidl_BaseInterface__import();
  _sidl_rmi_ServerInfoType.tp_base = sidl_BaseInterface_PyType();
  _sidl_rmi_ServerInfoType.tp_bases = PyTuple_New(1);
  PyTuple_SetItem(_sidl_rmi_ServerInfoType.tp_bases,0, (PyObject              \
    *)sidl_BaseInterface_PyType());
  if (PyType_Ready(&_sidl_rmi_ServerInfoType) < 0) {
    PyErr_Print();
    fprintf(stderr, "PyType_Ready on sidl.rmi.ServerInfo failed.\n");
    return;
  }
  Py_INCREF(&_sidl_rmi_ServerInfoType);
  PyDict_SetItemString(dict, "ServerInfo", (PyObject                          \
    *)&_sidl_rmi_ServerInfoType);

#ifdef WITH_RMI


  sidl_rmi_ConnectRegistry_registerConnect("sidl.rmi.ServerInfo", (           \
    void*)sidl_rmi_ServerInfo__IHConnect, &throwaway_exception);

#endif /*WITH_RMI*/

}
