/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-09-24 20:09
 */

#ifndef _BITSTORM_H_
#define _BITSTORM_H_

#include <stdint.h> 
#include <string>
#include <list>
#include <map>
 //#include <ext/hash_map>
 
 class IBTTask;
 
 class IBTTaskModule
 {
 public:
 	virtual ~IBTTaskModule() {};
 	
 	virtual void setBTTask(IBTTask* task) = 0;
	virtual IBTTask* getBTTask() = 0;
 };
 
class ITrackerManager :
	public IBTTaskModule
{
 public:	
	virtual ~ITrackerManager() {};
	
	virtual bool start() = 0;
	virtual void stop() = 0;	
	virtual int getSeedCount() = 0;
	virtual int getPeerCount() = 0;	
};

#define NONE_PIECE_INDEX ((unsigned int)-1)
class IBitSet
{
public:	
	virtual ~IBitSet() {};
	
	virtual void alloc(unsigned int size) = 0;
	virtual void alloc(std::string& stream, unsigned int size) = 0;
	virtual bool isSet(unsigned int index) = 0;
	virtual void set(unsigned int index, bool set) = 0;	
	virtual bool isAllSet() = 0;
	virtual bool isEmpty() = 0;
	virtual unsigned int getSetedCount() = 0;
	virtual std::string& getStream() = 0;
	virtual unsigned int getSize() = 0;
};

class TFileInfo
{
public:
	off64_t offset;
	int64_t size;
	std::string path;
	std::string name;
	std::string pathUTF8;
	std::string nameUTF8;	
};

class ITorrentFile :
	public IBTTaskModule
{
public:
	virtual ~ITorrentFile() {};
	
	virtual bool load(const char* filePath) = 0;
	virtual void setCharacterEncoding(const char* enc) = 0;
	virtual bool IsUTF8Valid() = 0;
	virtual unsigned int getAnnounceCount() = 0;
	virtual const char* getAnnounce(unsigned int index) = 0;
	virtual int getCreationDate() = 0;
	virtual const char* getComment() = 0;
	virtual const char* getCreator() = 0;
	virtual std::string getName() = 0;
	virtual std::string getTopDir() = 0;
	virtual const char* getCommentUTF8() = 0;
	virtual const char* getCreatorUTF8() = 0;
	virtual std::string getNameUTF8() = 0;
	virtual std::string getTopDirUTF8() = 0;	
	virtual unsigned int getPieceLength() = 0;
	virtual unsigned int getPieceCount() = 0;
	virtual std::string getPieceHash(unsigned int pieceIndex) = 0;
	virtual unsigned int getFileCount() = 0;
	virtual TFileInfo getFileInfo(unsigned int index) = 0;
	virtual int64_t getTotalSize() = 0;
	virtual const unsigned char* getInfoHash() = 0;
};


typedef enum {
	TS_INIT,
	TS_CONNECTING,
	TS_REQUESTING,
	TS_ERROR,
	TS_OK
} TTrackerState;

typedef enum {
	TE_START,
	TE_STOP,
	TE_COMPLETE,
	TE_NONE
} TTrackerEvent;

class ITracker
{
public:	
	virtual ~ITracker() {};
	
	virtual void setTrackerManager(ITrackerManager* trackerManager) = 0;
	virtual bool isProtocolSupported(const char* protocolName) = 0;
	virtual void setUrl(const char* url) = 0;
	virtual void update() = 0;
	virtual void stop() = 0;
	virtual TTrackerState getState() = 0;
	virtual const std::string& getStateStr() = 0;
	virtual unsigned int getSeedCount() = 0;
	virtual unsigned int getPeerCount() = 0;
	virtual unsigned int getInterval() = 0;
	virtual unsigned int getNextUpdateTick() = 0;
};

class IRateMeasureClient
{
public:
	virtual ~IRateMeasureClient() {};

	virtual void blockWrite(bool block) = 0;
	virtual void blockRead(bool block) = 0;
	
	virtual void setWritePriority(unsigned int Priority) = 0;
	virtual unsigned int getWritePriority() = 0;
	virtual void setReadPriority(unsigned int Priority) = 0;
	virtual unsigned int getReadPriority() = 0;	
	
	virtual bool canWrite() = 0;
	virtual bool canRead() = 0;
	
	virtual int doWrite(unsigned int count) = 0;
	virtual int doRead(unsigned int count) = 0;
};

class IRateMeasure
{
public:
	virtual ~IRateMeasure() {};
	static const unsigned int NoLimitedSpeed = 0xFFFFFFFF;
	
	virtual void addClient(IRateMeasureClient* client) = 0;
	virtual void removeClient(IRateMeasureClient* client) = 0;	
	
	virtual void update() = 0;
	
	virtual void setUploadSpeed(unsigned int sp) = 0;
	virtual void setDownloadSpeed(unsigned int sp) = 0;
	virtual unsigned int getUploadSpeed() = 0;
	virtual unsigned int getDownloadSpeed() = 0;
};

class ISocketReactor;

class ISocket
{
public:
	virtual ~ISocket() {};
	
	virtual void setReactor(ISocketReactor* reactor) = 0;
	virtual ISocketReactor* getReactor() = 0;
	
	virtual void createTCPSocket() = 0;
	virtual void createUDPSocket() = 0;
	virtual void close() = 0;
	virtual void attach(int fd) = 0;
	virtual int getHandle() = 0;
	
	virtual bool bind(const char* ip, unsigned short port) = 0;
	virtual void listen() = 0;
	virtual void connect(const char* ip, unsigned short port) = 0;	
	virtual int accept(std::string& ip, unsigned short& port) = 0;
	
	virtual void maskRead(bool mask) = 0;
	virtual void maskWrite(bool mask) = 0;
	virtual bool maskRead() = 0;
	virtual bool maskWrite() = 0;	
	
	virtual int handleRead() = 0;
	virtual int handleWrite() = 0;
	virtual void handleClose() = 0;	
};

class ITimerCallback
{
public:
	virtual ~ITimerCallback() {};
	
	virtual void onTimer(unsigned int id) = 0;
};	

class ISocketReactor
{
public:
	 virtual ~ISocketReactor() {};
	 
	 virtual bool addSocket(ISocket* socket) = 0;
	 virtual void removeSocket(ISocket* socket) = 0;
	 virtual void updateMask(ISocket* socket) = 0;
	 
	 virtual unsigned int addTimer(ITimerCallback* callback, unsigned int interval,  bool oneShot) = 0;
	 virtual void removeTimer(unsigned int id) = 0;
	 
	 virtual bool start() = 0;
	 virtual void update() = 0;
	 virtual void stop() = 0;
};

class IPeerAcceptor :
	public IBTTaskModule
{
public:	
	virtual ~IPeerAcceptor() {};
	
	virtual bool start() = 0;
	virtual void stop() = 0;	
	
	virtual unsigned short getPort() = 0;
};

class IPeerManager :
	public IBTTaskModule
{
public:
	virtual ~IPeerManager() {};
	
	virtual bool start() = 0;
	virtual void stop() = 0;		
	virtual void addPeerInfoWithoutID(const char* ip, unsigned short port) = 0;
	virtual bool addAcceptedPeer(int handle, const char* ip, unsigned short port) = 0;
	virtual void broadcastHave(unsigned int pieceIndex) = 0;
	virtual void cancelPieceRequest(unsigned int pieceIndex) = 0;
	virtual unsigned int getConnectedPeerCount() = 0;
	virtual void onDownloadComplete() = 0;
};

typedef enum
{
	PS_INIT,
	PS_CONNECTING,
	PS_CONNECTFAILED,
	PS_ESTABLISHED,	
	PS_CLOSED
} TPeerState;

class IPeerLink
{
public:
	virtual ~IPeerLink() {};
	
	virtual void setPeerManager(IPeerManager* manager) = 0;
	virtual TPeerState getState() = 0;
	
	virtual void connect(const char* ip, unsigned short port) = 0;
	virtual void attach(int handle, const char* ip, unsigned short port, IPeerManager* manager) = 0;
	virtual bool isAccepted() = 0;
	virtual void closeLink() = 0;

	virtual const char* getIP() = 0;
	virtual unsigned short getPort() = 0;
	
	virtual void notifyHavePiece(unsigned int pieceIndex) = 0;
	virtual void cancelPieceRequest(unsigned int pieceIndex) = 0;
	virtual bool peerChoked() = 0;
	virtual bool peerInterested() = 0;
	virtual void chokePeer(bool choke) = 0;
	virtual unsigned int getDownloadCount() = 0;
	virtual unsigned int getUploadCount() = 0;
	virtual void countSpeed() = 0;
	virtual bool checkNeedClose() = 0;
	virtual unsigned int getUploadSpeed() = 0;
	virtual unsigned int getDownloadSpeed() = 0;
	virtual void onDownloadComplete() = 0;
};

typedef struct
{
	std::string linkID;
	std::string ip;
	unsigned short port;
	unsigned short connectFailedCount;
	IPeerLink* peerLink;
} TPeerInfo;

typedef std::list<TPeerInfo> TPeerInfoList;
/*
struct HashString {
  std::size_t operator()(const std::string& s) const {
    return __gnu_cxx::__stl_hash_string(s.c_str());
  }
};
typedef __gnu_cxx::hash_map<std::string, TPeerInfo, HashString> TPeerInfoMap;	
*/
typedef std::map<std::string, TPeerInfo> TPeerInfoMap;
typedef std::list<unsigned int> TBanedFileList; 

class IStorage :
	public IBTTaskModule
{
public:
	virtual ~IStorage() {};
	
	virtual bool start() = 0;
	virtual void stop() = 0;
	virtual void setBanedFileList(TBanedFileList bandFileList) = 0;
	virtual bool finished() = 0;
	virtual std::string getBitfield() = 0;
	virtual IBitSet* getBitSet() = 0;
	virtual IBitSet* getBanedBitSet() = 0;
	virtual unsigned int getPieceLength(unsigned int pieceIndex) = 0;
	virtual unsigned int getPieceTask(IBitSet* bitSet) = 0;
	virtual void abandonPieceTask(unsigned int pieceIndex) = 0;
	virtual void writePiece(unsigned int pieceIndex,std::string& data) = 0;
	virtual std::string readData(unsigned int pieceIndex, unsigned int offset, unsigned int len) = 0;
	virtual std::string readPiece(unsigned int pieceIndex) = 0;
	virtual float getFinishedPercent() = 0;
	virtual int64_t getLeftCount() = 0;
	virtual int64_t getSelectedCount() = 0;
	virtual int64_t getBanedCount() = 0;
};

typedef enum {NS_INIT, NS_DISCOVER, NS_GETDESCRIPTION, NS_OK, NS_ERROR} TUPnpNATState;

class IUPnpNAT
{
public:
	virtual ~IUPnpNAT() {};
	
	virtual void setReactor(ISocketReactor* reactor) = 0;
	virtual void start() = 0;
	virtual void stop() = 0;
	virtual TUPnpNATState getState() = 0;
	virtual void addPortMapping(unsigned int port,const char* protocol) = 0;
	virtual void removePortMapping(unsigned int port,const char* protocol) = 0;
};

class IBTTask
{
public:
	virtual ~IBTTask() {};
	
	virtual void setTorrentFilePath(const char* path) = 0;
	virtual void setDestPath(const char* path) = 0;
	virtual std::string getDestPath() = 0;
	virtual std::string getTaskName() = 0;
	virtual bool start() = 0;
	virtual void stop() = 0;
	virtual std::string getErrorMessage() = 0;
	virtual std::string getPeerID() = 0;
	
	virtual bool loadTorrentFile() = 0;
	virtual ITorrentFile* getTorrentFile() = 0;
	virtual void setBanedFileList(TBanedFileList bandFileList) = 0;
	virtual ITrackerManager* getTrackerManager() = 0;
	virtual ISocketReactor* getSocketReactor() = 0;
	virtual IRateMeasure* getRateMeasure() = 0;
	virtual IPeerManager* getPeerManager() = 0;
	virtual IStorage* getStorage() = 0;
	virtual IPeerAcceptor* getAcceptor() = 0;
	virtual IUPnpNAT* getUPnpNat() = 0;
	
	virtual void incDownlaodCount(unsigned int count) = 0;
	virtual void incUploadCount(unsigned int count) = 0;
	virtual int64_t getDownlaodCount() = 0;
	virtual int64_t getUploadCount() = 0;	
	
	virtual unsigned int getPeerLinkMax() = 0;
	virtual void setPeerLinkMax(unsigned int count) = 0;
	virtual unsigned int getUploadPeerLinkMax() = 0;
	virtual void setUploadPeerLinkMax(unsigned int count) = 0;
	virtual unsigned int getCacheSize() = 0;
	virtual void setCacheSize(unsigned int count) = 0;
	virtual unsigned int getConnectingPeerLinkMax() = 0;
	virtual unsigned int getUploadSpeed() = 0;
	virtual unsigned int getDownloadSpeed() = 0;
};

 
#endif
