#!/usr/bin/perl
#
# This script reads BLD dump files and prints statistics about the number
# of currently blacklisted IPs and the number of IPs added in the last 5
# minutes.  The default output is MRTG-friendly.
#
# Olivier Beyssac <obld@r14.freenix.org>
#

use strict;

# If you don't use BLD default value for blacklist expiration (-e option
# or blacklist_expiration parameter in bld.conf(5)), change this
my $expiration = 900;

# If you don't run MRTG every 5 minutes, change this
my $rate = 300;

my $dump = "/var/run/bld/bld_blacklist.dump";
my $state = "/var/run/bld-mrtg.state";
my $current_time = time();
my $count = 0;
my $total = 0;

open(BLD, "bldread $dump |");
while (<BLD>) {
        if (/^(\d+\.\d+\.\d+\.\d+;\d+;(\d+);/) {
                my $ip = $1;
                my $time = $2;
                $total++ if ($time > $current_time - $expiration);
                if ($time > $current_time - $rate) {
                        $count++;
                }
        }
}
close(BLD);

print "$count\n$total\n\n\n";
