// String.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002.2003,2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef BSTRING_H
#define BSTRING_H

#include <iostream>
#include <string>

class String {

  std::string my_string;

public:
  String();
  String(const char *);
  String(const String &);
  String(const std::string &);
  String(long);
  String(char);
  
  String & operator=(const char *);
  String & operator=(const String &);
  String & operator=(const std::string &);
  
  ~String();

  int length() const;
  int find(char);
  void fill(char);
  String pad(int);

  String subString(int);
  String subString(int, int);
  
  String substr(int);
  String substr(int, int);

  String toLower();
  String toUpper();
  String trim();
  int indexOf(char);

  char & operator[](int);
  const char & operator[](int) const;

  bool operator==(const char *) const;
  bool operator==(const String &) const;
  bool operator==(const std::string &) const;
  
  bool operator!=(const char *) const;
  bool operator!=(const String &) const;
  bool operator!=(const std::string &) const;
  
  bool operator<(const String &) const;
  bool operator>(const String &) const;
  bool operator<(const std::string &) const;

  bool operator<=(const String &) const;
  bool operator<=(const std::string &) const;
  bool operator>=(const String &) const;
  bool operator>=(const std::string &) const;
  
  String operator+(const char *);
  String operator+(const String &);
  String operator+(const std::string &);

  friend std::string operator+(const std::string &, const String &);
  
  operator const char *() const;
  operator std::string () const;

  friend std::ostream & operator<<(std::ostream &, const String &);
  friend std::istream & operator>>(std::istream &, String &);
};

bool operator==(const std::string &, const String &);
bool operator!=(const std::string &, const String &);
bool operator>(const std::string &, const String &);
bool operator<(const std::string &, const String &);
bool operator<=(const std::string &, const String &);
bool operator>=(const std::string &, const String &);

#endif
