//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 4>, 400> assoc_legendre_p = {{
      {{ SC_(3.755727291107177734375), SC_(-3), SC_(0.264718532562255859375), SC_(0.018682285998021253444483874168352748715136623066073) }}, 
      {{ SC_(3.755727291107177734375), SC_(-3), SC_(0.67001712322235107421875), SC_(0.0085227010576716344744906184676725516467064196759033) }}, 
      {{ SC_(3.755727291107177734375), SC_(-3), SC_(0.91501367092132568359375), SC_(0.0013678553914178941694232605088191864494205442141689) }}, 
      {{ SC_(3.755727291107177734375), SC_(-3), SC_(0.93538987636566162109375), SC_(0.00092121779437596438014780141399846622556782069609554) }}, 
      {{ SC_(3.755727291107177734375), SC_(-2), SC_(-0.804919183254241943359375), SC_(-0.035427019537072229468317544697039851719910785732282) }}, 
      {{ SC_(3.755727291107177734375), SC_(-2), SC_(-0.62323606014251708984375), SC_(-0.047644590452413896385001513687947050090798484234256) }}, 
      {{ SC_(3.755727291107177734375), SC_(-2), SC_(0.62944734096527099609375), SC_(0.047507226872528274797147731134568104938153965122183) }}, 
      {{ SC_(3.755727291107177734375), SC_(-2), SC_(0.92977702617645263671875), SC_(0.015749804707019642230489140711548190498803023729124) }}, 
      {{ SC_(3.755727291107177734375), SC_(-2), SC_(0.98576259613037109375), SC_(0.0034836978383022116191949923980075709550874307751656) }}, 
      {{ SC_(3.755727291107177734375), SC_(-1), SC_(0.09376299381256103515625), SC_(-0.11897883801786023759113449248494493928619190467444) }}, 
      {{ SC_(3.755727291107177734375), SC_(0), SC_(-0.72904598712921142578125), SC_(0.12483445078630286253952851342405305778981983166886) }}, 
      {{ SC_(3.755727291107177734375), SC_(0), SC_(0.0944411754608154296875), SC_(-0.13955592906053357908142302859499928047171124489978) }}, 
      {{ SC_(3.755727291107177734375), SC_(0), SC_(0.826751708984375), SC_(0.1726224256643575927228084765374660491943359375) }}, 
      {{ SC_(3.755727291107177734375), SC_(0), SC_(0.99292266368865966796875), SC_(0.95791076106518834501582130387317692843396343960194) }}, 
      {{ SC_(3.755727291107177734375), SC_(1), SC_(-0.5579319000244140625), SC_(-0.69267329476836900305232758748436796165065650726706) }}, 
      {{ SC_(3.755727291107177734375), SC_(1), SC_(-0.38366591930389404296875), SC_(0.36569809882896106974883774476288881583212189972924) }}, 
      {{ SC_(3.755727291107177734375), SC_(2), SC_(-0.74602639675140380859375), SC_(-4.9623208282269009166469230084559050020232007227605) }}, 
      {{ SC_(3.755727291107177734375), SC_(2), SC_(-0.44300353527069091796875), SC_(-5.340947203111010720410977109344485835862315070699) }}, 
      {{ SC_(3.755727291107177734375), SC_(2), SC_(0.81158387660980224609375), SC_(4.1552884837362426955817673026802316904593226354336) }}, 
      {{ SC_(3.755727291107177734375), SC_(2), SC_(0.93773555755615234375), SC_(1.6970953962729668417983019956807311245938763022423) }}, 
      {{ SC_(4.285762786865234375), SC_(-4), SC_(0.0944411754608154296875), SC_(0.0025579199993109637443137263005669146428545187165902) }}, 
      {{ SC_(4.285762786865234375), SC_(-4), SC_(0.67001712322235107421875), SC_(0.00079084875024561627663099583678188315474519799498067) }}, 
      {{ SC_(4.285762786865234375), SC_(-3), SC_(-0.74602639675140380859375), SC_(-0.0045895703969571628891682136050294568676142831603226) }}, 
      {{ SC_(4.285762786865234375), SC_(-2), SC_(-0.62323606014251708984375), SC_(0.021901614369568242657323933337327101674854041794065) }}, 
      {{ SC_(4.285762786865234375), SC_(-2), SC_(0.62944734096527099609375), SC_(0.022308096300309799048219090710479861660073888191704) }}, 
      {{ SC_(4.285762786865234375), SC_(-2), SC_(0.93538987636566162109375), SC_(0.013350407227053037260147784930747976172856146131701) }}, 
      {{ SC_(4.285762786865234375), SC_(-1), SC_(0.91501367092132568359375), SC_(0.13200123550282267507521242420636682233158093275439) }}, 
      {{ SC_(4.285762786865234375), SC_(-1), SC_(0.98576259613037109375), SC_(0.07877427388685735435597041845896354141179322010808) }}, 
      {{ SC_(4.285762786865234375), SC_(0), SC_(-0.38366591930389404296875), SC_(-0.082202061657178565574671344721658600769778582062621) }}, 
      {{ SC_(4.285762786865234375), SC_(1), SC_(0.09376299381256103515625), SC_(0.68576243868873072515243076289551241703397054367008) }}, 
      {{ SC_(4.285762786865234375), SC_(1), SC_(0.264718532562255859375), SC_(1.6015108598580622790613880161520031562290080195803) }}, 
      {{ SC_(4.285762786865234375), SC_(1), SC_(0.826751708984375), SC_(-2.075091388628511047552411495370343087881224878243) }}, 
      {{ SC_(4.285762786865234375), SC_(1), SC_(0.92977702617645263671875), SC_(-2.6110232658679238686101145865940662146504977908866) }}, 
      {{ SC_(4.285762786865234375), SC_(1), SC_(0.99292266368865966796875), SC_(-1.1501152124516827856720730990547167000673318754544) }}, 
      {{ SC_(4.285762786865234375), SC_(3), SC_(-0.804919183254241943359375), SC_(17.658347776050435476592152301745513462355419797644) }}, 
      {{ SC_(4.285762786865234375), SC_(3), SC_(-0.72904598712921142578125), SC_(24.546943351788936569134344357322020563417724549234) }}, 
      {{ SC_(4.285762786865234375), SC_(3), SC_(-0.5579319000244140625), SC_(33.483200432942805434592337100676821594014587089232) }}, 
      {{ SC_(4.285762786865234375), SC_(4), SC_(-0.44300353527069091796875), SC_(67.831116663749312786686560206270714301013197988912) }}, 
      {{ SC_(4.285762786865234375), SC_(4), SC_(0.81158387660980224609375), SC_(12.23326322639646526677027003435192961976317891902) }}, 
      {{ SC_(4.285762786865234375), SC_(4), SC_(0.93773555755615234375), SC_(1.5284756464094009019523190775027909687425881068989) }}, 
      {{ SC_(4.43858623504638671875), SC_(-4), SC_(0.09376299381256103515625), SC_(0.0025585788865558103020054987182935328386974024573462) }}, 
      {{ SC_(4.43858623504638671875), SC_(-4), SC_(0.81158387660980224609375), SC_(0.00030340434589276947586235788775674428620444392160269) }}, 
      {{ SC_(4.43858623504638671875), SC_(-4), SC_(0.826751708984375), SC_(0.00026083492327811402025075290800337768359895562753081) }}, 
      {{ SC_(4.43858623504638671875), SC_(-4), SC_(0.92977702617645263671875), SC_(0.47823512832424889615550406883421003863012687163716e-4) }}, 
      {{ SC_(4.43858623504638671875), SC_(-3), SC_(-0.804919183254241943359375), SC_(-0.0035036404317560387850381254566955383853879801185802) }}, 
      {{ SC_(4.43858623504638671875), SC_(-3), SC_(-0.72904598712921142578125), SC_(-0.0048704252682120905891139572137543691594082786804035) }}, 
      {{ SC_(4.43858623504638671875), SC_(-3), SC_(-0.62323606014251708984375), SC_(-0.0062099464278749790063643151908339184429802189273533) }}, 
      {{ SC_(4.43858623504638671875), SC_(-3), SC_(0.93538987636566162109375), SC_(0.00086169779878718081099879281321850193219169946462828) }}, 
      {{ SC_(4.43858623504638671875), SC_(-2), SC_(-0.5579319000244140625), SC_(0.016916718454958990171262790356133102641009169353481) }}, 
      {{ SC_(4.43858623504638671875), SC_(-2), SC_(-0.44300353527069091796875), SC_(0.0062585992120013346073049856968548291009012658140108) }}, 
      {{ SC_(4.43858623504638671875), SC_(-2), SC_(0.91501367092132568359375), SC_(0.016480979075286992096829450389735978618066029926915) }}, 
      {{ SC_(4.43858623504638671875), SC_(-1), SC_(0.62944734096527099609375), SC_(-0.013852284088400384102197697049644481796357180917995) }}, 
      {{ SC_(4.43858623504638671875), SC_(0), SC_(-0.38366591930389404296875), SC_(-0.082202061657178565574671344721658600769778582062621) }}, 
      {{ SC_(4.43858623504638671875), SC_(0), SC_(0.0944411754608154296875), SC_(0.3419012769545217228869883142677928817338726938716) }}, 
      {{ SC_(4.43858623504638671875), SC_(0), SC_(0.67001712322235107421875), SC_(-0.42675937253158873957266351661277594541380955593248) }}, 
      {{ SC_(4.43858623504638671875), SC_(1), SC_(-0.74602639675140380859375), SC_(1.1126727867403958433914301847632907446425470781145) }}, 
      {{ SC_(4.43858623504638671875), SC_(1), SC_(0.93773555755615234375), SC_(-2.5694907092758592654019226620729417580286717814693) }}, 
      {{ SC_(4.43858623504638671875), SC_(2), SC_(0.264718532562255859375), SC_(-3.5532540894315570371583179746027713002035183960381) }}, 
      {{ SC_(4.43858623504638671875), SC_(2), SC_(0.99292266368865966796875), SC_(0.62426196438718111041026481024591411942721351148618) }}, 
      {{ SC_(4.43858623504638671875), SC_(4), SC_(0.98576259613037109375), SC_(0.083927746199061397527375080044175506771911288161903) }}, 
      {{ SC_(5.390875339508056640625), SC_(-5), SC_(0.0944411754608154296875), SC_(0.0002546487231919752178607492517299512129462633725364) }}, 
      {{ SC_(5.390875339508056640625), SC_(-5), SC_(0.264718532562255859375), SC_(0.00021716384956208715694799696662224323122616129459559) }}, 
      {{ SC_(5.390875339508056640625), SC_(-5), SC_(0.67001712322235107421875), SC_(0.58708312450036459613075249881849855560840725857318e-4) }}, 
      {{ SC_(5.390875339508056640625), SC_(-5), SC_(0.91501367092132568359375), SC_(0.27827305046113328781834314319875323548924440626817e-5) }}, 
      {{ SC_(5.390875339508056640625), SC_(-3), SC_(0.92977702617645263671875), SC_(0.00088084918348099199582932467310763476850348538284308) }}, 
      {{ SC_(5.390875339508056640625), SC_(-2), SC_(0.62944734096527099609375), SC_(0.0044802133341411818740038475673044511324305084281699) }}, 
      {{ SC_(5.390875339508056640625), SC_(-2), SC_(0.826751708984375), SC_(0.017179972428025654957727173029455910568258358850358) }}, 
      {{ SC_(5.390875339508056640625), SC_(-2), SC_(0.93773555755615234375), SC_(0.011582986702578200018657376926081178305253584288072) }}, 
      {{ SC_(5.390875339508056640625), SC_(-1), SC_(-0.804919183254241943359375), SC_(0.027614447937383812923403611365941023696827330290191) }}, 
      {{ SC_(5.390875339508056640625), SC_(-1), SC_(-0.74602639675140380859375), SC_(-0.011942526133146833219086796223309547055717483576189) }}, 
      {{ SC_(5.390875339508056640625), SC_(-1), SC_(-0.44300353527069091796875), SC_(-0.052598650339880048670991840817375710928478745804392) }}, 
      {{ SC_(5.390875339508056640625), SC_(-1), SC_(0.81158387660980224609375), SC_(0.032475028650926011657602131247192442876513897830463) }}, 
      {{ SC_(5.390875339508056640625), SC_(-1), SC_(0.98576259613037109375), SC_(0.075928872430285790876424723398166177311286253675933) }}, 
      {{ SC_(5.390875339508056640625), SC_(1), SC_(-0.5579319000244140625), SC_(2.0588360348849268576901634118752070496134490686058) }}, 
      {{ SC_(5.390875339508056640625), SC_(1), SC_(-0.38366591930389404296875), SC_(1.0488997903645254423314161051388628455007799361763) }}, 
      {{ SC_(5.390875339508056640625), SC_(1), SC_(0.99292266368865966796875), SC_(-1.694428428045302980695459253870012855657911579182) }}, 
      {{ SC_(5.390875339508056640625), SC_(3), SC_(0.09376299381256103515625), SC_(47.709869098409296824126378544766494005231382182091) }}, 
      {{ SC_(5.390875339508056640625), SC_(5), SC_(-0.72904598712921142578125), SC_(-141.96691257606284385923672899667345613424951478332) }}, 
      {{ SC_(5.390875339508056640625), SC_(5), SC_(-0.62323606014251708984375), SC_(-276.41355575741464167724815651046032240942755898478) }}, 
      {{ SC_(5.390875339508056640625), SC_(5), SC_(0.93538987636566162109375), SC_(-5.2252178435591148637339332297779102344828532461685) }}, 
      {{ SC_(5.9786128997802734375), SC_(-5), SC_(-0.72904598712921142578125), SC_(0.39122275291022609088193543043615921553750417433674e-4) }}, 
      {{ SC_(5.9786128997802734375), SC_(-5), SC_(-0.38366591930389404296875), SC_(0.00017489900689655423627775194820998979395800601640731) }}, 
      {{ SC_(5.9786128997802734375), SC_(-5), SC_(0.93538987636566162109375), SC_(0.14399299612982569620078078785763641519187756961443e-5) }}, 
      {{ SC_(5.9786128997802734375), SC_(-4), SC_(-0.62323606014251708984375), SC_(-0.00060704847503506154620171592993567892964928692547447) }}, 
      {{ SC_(5.9786128997802734375), SC_(-4), SC_(0.264718532562255859375), SC_(0.00059613981311034434030663336977459595577939813266618) }}, 
      {{ SC_(5.9786128997802734375), SC_(-3), SC_(0.62944734096527099609375), SC_(0.0031349671707415505384457022694976904859365129000026) }}, 
      {{ SC_(5.9786128997802734375), SC_(-3), SC_(0.67001712322235107421875), SC_(0.0032389529371683531093138459783060646462307543487447) }}, 
      {{ SC_(5.9786128997802734375), SC_(-2), SC_(0.91501367092132568359375), SC_(0.014070467978894087845837622000095287182388864142753) }}, 
      {{ SC_(5.9786128997802734375), SC_(-2), SC_(0.99292266368865966796875), SC_(0.0017135580072319634875733505499327690870804859765117) }}, 
      {{ SC_(5.9786128997802734375), SC_(-1), SC_(-0.74602639675140380859375), SC_(-0.011942526133146833219086796223309547055717483576189) }}, 
      {{ SC_(5.9786128997802734375), SC_(-1), SC_(0.93773555755615234375), SC_(0.10697160990790480346676465130193776610937898528547) }}, 
      {{ SC_(5.9786128997802734375), SC_(0), SC_(-0.5579319000244140625), SC_(0.047804048918209109846499488120279081448233535491368) }}, 
      {{ SC_(5.9786128997802734375), SC_(0), SC_(-0.44300353527069091796875), SC_(-0.20426834340719068505951661242682923196540890996203) }}, 
      {{ SC_(5.9786128997802734375), SC_(0), SC_(0.98576259613037109375), SC_(0.79688047965898906667942422168075865228912496237335) }}, 
      {{ SC_(5.9786128997802734375), SC_(2), SC_(-0.804919183254241943359375), SC_(-14.041412871300637007325237563186908954938502617465) }}, 
      {{ SC_(5.9786128997802734375), SC_(3), SC_(0.09376299381256103515625), SC_(47.709869098409296824126378544766494005231382182091) }}, 
      {{ SC_(5.9786128997802734375), SC_(3), SC_(0.0944411754608154296875), SC_(47.641150834624152676066344832804794889226504703822) }}, 
      {{ SC_(5.9786128997802734375), SC_(3), SC_(0.826751708984375), SC_(-48.15370209637736090987750799064280741291078069631) }}, 
      {{ SC_(5.9786128997802734375), SC_(4), SC_(0.92977702617645263671875), SC_(16.135533061554449755055362055976172128279602633683) }}, 
      {{ SC_(5.9786128997802734375), SC_(5), SC_(0.81158387660980224609375), SC_(-64.324006256133565068416408251533490438742435471623) }}, 
      {{ SC_(7.0129680633544921875), SC_(-6), SC_(-0.44300353527069091796875), SC_(-0.49917660497843442012283615070189075267419679644049e-5) }}, 
      {{ SC_(7.0129680633544921875), SC_(-6), SC_(0.62944734096527099609375), SC_(0.3006891273213370799141727869232359504461493153624e-5) }}, 
      {{ SC_(7.0129680633544921875), SC_(-6), SC_(0.81158387660980224609375), SC_(0.70040699133541810527562096226330143819869790187691e-6) }}, 
      {{ SC_(7.0129680633544921875), SC_(-6), SC_(0.98576259613037109375), SC_(0.48343073413896634965208304544121619980890063725753e-9) }}, 
      {{ SC_(7.0129680633544921875), SC_(-3), SC_(0.67001712322235107421875), SC_(0.000233323277056834438037424623276038206336990557194) }}, 
      {{ SC_(7.0129680633544921875), SC_(-2), SC_(-0.804919183254241943359375), SC_(-0.0027739031343697825991513090446807124968690478954398) }}, 
      {{ SC_(7.0129680633544921875), SC_(-1), SC_(-0.38366591930389404296875), SC_(0.039786558334548825835304799167391994654559424625062) }}, 
      {{ SC_(7.0129680633544921875), SC_(-1), SC_(0.92977702617645263671875), SC_(0.054454932483310305073733979576928070746123404332102) }}, 
      {{ SC_(7.0129680633544921875), SC_(0), SC_(0.0944411754608154296875), SC_(-0.19033023284194947443250862014615331274337558869229) }}, 
      {{ SC_(7.0129680633544921875), SC_(0), SC_(0.264718532562255859375), SC_(-0.26772197626528608005754891383945733780088489487847) }}, 
      {{ SC_(7.0129680633544921875), SC_(2), SC_(-0.72904598712921142578125), SC_(8.2527975846199234989599916055568828159236433321317) }}, 
      {{ SC_(7.0129680633544921875), SC_(3), SC_(-0.74602639675140380859375), SC_(-122.8095242453750885154728218467647225016581694455) }}, 
      {{ SC_(7.0129680633544921875), SC_(3), SC_(0.826751708984375), SC_(-173.13613361264811344425400070610320025380148250632) }}, 
      {{ SC_(7.0129680633544921875), SC_(3), SC_(0.93773555755615234375), SC_(-91.646151026938230226355468598656579455999111879645) }}, 
      {{ SC_(7.0129680633544921875), SC_(4), SC_(-0.62323606014251708984375), SC_(-827.70592695642797610122284647665024797997991160461) }}, 
      {{ SC_(7.0129680633544921875), SC_(5), SC_(0.09376299381256103515625), SC_(4502.9678134547254406291563962805504284132872177258) }}, 
      {{ SC_(7.0129680633544921875), SC_(5), SC_(0.93538987636566162109375), SC_(-298.14688995091627351489747457308624963260602452294) }}, 
      {{ SC_(7.0129680633544921875), SC_(5), SC_(0.99292266368865966796875), SC_(-1.4510728508951063559765139003152953353215769586589) }}, 
      {{ SC_(7.0129680633544921875), SC_(6), SC_(-0.5579319000244140625), SC_(-24629.862077522287552037887727378221479137335921999) }}, 
      {{ SC_(7.0129680633544921875), SC_(7), SC_(0.91501367092132568359375), SC_(-235.01261148836072843323648254407718400683198946966) }}, 
      {{ SC_(7.5470066070556640625), SC_(-7), SC_(0.92977702617645263671875), SC_(0.14200764177428564541660357501288113217936324682596e-8) }}, 
      {{ SC_(7.5470066070556640625), SC_(-6), SC_(0.99292266368865966796875), SC_(0.60462178621145526495587961093028377048346906917799e-10) }}, 
      {{ SC_(7.5470066070556640625), SC_(-5), SC_(-0.804919183254241943359375), SC_(0.11850218745680660327856845487252042020489012451249e-4) }}, 
      {{ SC_(7.5470066070556640625), SC_(-5), SC_(-0.62323606014251708984375), SC_(0.25704941219612768652057044997952103565531823264833e-4) }}, 
      {{ SC_(7.5470066070556640625), SC_(-5), SC_(-0.5579319000244140625), SC_(0.26026610986949895591456820667931397644373911708617e-4) }}, 
      {{ SC_(7.5470066070556640625), SC_(-5), SC_(0.826751708984375), SC_(0.96427550556555556215914278478645893071540865408665e-5) }}, 
      {{ SC_(7.5470066070556640625), SC_(-4), SC_(-0.74602639675140380859375), SC_(-0.00016179970162846142544637619599296898839695649488055) }}, 
      {{ SC_(7.5470066070556640625), SC_(-3), SC_(0.0944411754608154296875), SC_(0.00062249282910339912813465170017929282035995863532522) }}, 
      {{ SC_(7.5470066070556640625), SC_(-3), SC_(0.98576259613037109375), SC_(0.91478224428475023051355182182258959654080836058826e-4) }}, 
      {{ SC_(7.5470066070556640625), SC_(-1), SC_(0.81158387660980224609375), SC_(-0.037618428130799583340460729445204508575236956259112) }}, 
      {{ SC_(7.5470066070556640625), SC_(1), SC_(0.264718532562255859375), SC_(-0.91850641031589001426851910351654966807086201315901) }}, 
      {{ SC_(7.5470066070556640625), SC_(2), SC_(-0.72904598712921142578125), SC_(8.2527975846199234989599916055568828159236433321317) }}, 
      {{ SC_(7.5470066070556640625), SC_(2), SC_(0.67001712322235107421875), SC_(-16.173978727715922835573941646676954402245624210885) }}, 
      {{ SC_(7.5470066070556640625), SC_(3), SC_(-0.44300353527069091796875), SC_(126.11683720173836113693183279288501512543793837078) }}, 
      {{ SC_(7.5470066070556640625), SC_(3), SC_(0.09376299381256103515625), SC_(-94.453868860737087182332484196906419229893511255424) }}, 
      {{ SC_(7.5470066070556640625), SC_(4), SC_(0.93538987636566162109375), SC_(212.20613541117306294339745645140997922163474736004) }}, 
      {{ SC_(7.5470066070556640625), SC_(5), SC_(0.91501367092132568359375), SC_(-548.9598762946375491746161334341209970192082722327) }}, 
      {{ SC_(7.5470066070556640625), SC_(5), SC_(0.93773555755615234375), SC_(-274.14402002956226658985353133565183129456133307216) }}, 
      {{ SC_(7.5470066070556640625), SC_(6), SC_(-0.38366591930389404296875), SC_(-32156.098501462924236706288755730053796038774016275) }}, 
      {{ SC_(7.5470066070556640625), SC_(7), SC_(0.62944734096527099609375), SC_(-23114.460949600096071941383702301168401607047211818) }}, 
      {{ SC_(11.84386730194091796875), SC_(-10), SC_(-0.5579319000244140625), SC_(-0.23265181140053135802487825748454722380866646014593e-10) }}, 
      {{ SC_(11.84386730194091796875), SC_(-10), SC_(0.81158387660980224609375), SC_(0.10119358336421199432244908899725952448132738655445e-11) }}, 
      {{ SC_(11.84386730194091796875), SC_(-8), SC_(-0.74602639675140380859375), SC_(-0.13489060836825107052053300247017803661743299618615e-8) }}, 
      {{ SC_(11.84386730194091796875), SC_(-8), SC_(-0.72904598712921142578125), SC_(-0.1542799319087398107549162488097441554465286352303e-8) }}, 
      {{ SC_(11.84386730194091796875), SC_(-8), SC_(0.98576259613037109375), SC_(0.59003527302236484992801818528316725899144008941385e-13) }}, 
      {{ SC_(11.84386730194091796875), SC_(-4), SC_(0.62944734096527099609375), SC_(-0.14472251039785768408474263876593046823350434589546e-4) }}, 
      {{ SC_(11.84386730194091796875), SC_(-4), SC_(0.92977702617645263671875), SC_(0.19881213267841126683103644232724033001739468923731e-4) }}, 
      {{ SC_(11.84386730194091796875), SC_(-3), SC_(0.67001712322235107421875), SC_(-0.45829620024586356030414844243050192126649872258431e-4) }}, 
      {{ SC_(11.84386730194091796875), SC_(-2), SC_(0.826751708984375), SC_(-0.0024475865536336790697122592507802550191969717760944) }}, 
      {{ SC_(11.84386730194091796875), SC_(-2), SC_(0.99292266368865966796875), SC_(0.001514584725634246672093061231008807294812673049418) }}, 
      {{ SC_(11.84386730194091796875), SC_(-1), SC_(-0.38366591930389404296875), SC_(0.0041910765987207082014873224726632429468869952557846) }}, 
      {{ SC_(11.84386730194091796875), SC_(2), SC_(-0.44300353527069091796875), SC_(29.060140543929646372953199229138943547599341368473) }}, 
      {{ SC_(11.84386730194091796875), SC_(3), SC_(0.09376299381256103515625), SC_(-177.48133935035592847836648194577534007151999415785) }}, 
      {{ SC_(11.84386730194091796875), SC_(6), SC_(0.264718532562255859375), SC_(222813.62228852691558610355161450613259901923040526) }}, 
      {{ SC_(11.84386730194091796875), SC_(7), SC_(-0.62323606014251708984375), SC_(-4859018.4455751267400897075639214816266256959868333) }}, 
      {{ SC_(11.84386730194091796875), SC_(8), SC_(0.91501367092132568359375), SC_(1021518.66801184216282417981301458120258320370794) }}, 
      {{ SC_(11.84386730194091796875), SC_(8), SC_(0.93538987636566162109375), SC_(383678.2307827682389868079425774985048635406198118) }}, 
      {{ SC_(11.84386730194091796875), SC_(8), SC_(0.93773555755615234375), SC_(335363.54374210707806874319418081514539985485964623) }}, 
      {{ SC_(11.84386730194091796875), SC_(9), SC_(-0.804919183254241943359375), SC_(-37638062.605176743043545621659726706224449118828276) }}, 
      {{ SC_(11.84386730194091796875), SC_(11), SC_(0.0944411754608154296875), SC_(-13088230119.354593487821768373557740001331594792884) }}, 
      {{ SC_(11.84997081756591796875), SC_(-11), SC_(0.09376299381256103515625), SC_(0.11652575593644221485023460761015831090267033800858e-10) }}, 
      {{ SC_(11.84997081756591796875), SC_(-11), SC_(0.92977702617645263671875), SC_(0.20579709935439231465251633890295859136590924726116e-15) }}, 
      {{ SC_(11.84997081756591796875), SC_(-11), SC_(0.93538987636566162109375), SC_(0.13224949845586789337687366145892296658666301182813e-15) }}, 
      {{ SC_(11.84997081756591796875), SC_(-8), SC_(-0.74602639675140380859375), SC_(-0.13489060836825107052053300247017803661743299618615e-8) }}, 
      {{ SC_(11.84997081756591796875), SC_(-7), SC_(0.93773555755615234375), SC_(0.69374698116005068370241223092303295509213455690462e-9) }}, 
      {{ SC_(11.84997081756591796875), SC_(-6), SC_(0.264718532562255859375), SC_(0.75171716970009817274765988454793518932645912441686e-7) }}, 
      {{ SC_(11.84997081756591796875), SC_(-5), SC_(0.67001712322235107421875), SC_(-0.74962894159760082832011679326967274680513990227673e-6) }}, 
      {{ SC_(11.84997081756591796875), SC_(-4), SC_(-0.62323606014251708984375), SC_(0.13562168617539220725057252182518517591360727530937e-4) }}, 
      {{ SC_(11.84997081756591796875), SC_(-3), SC_(0.0944411754608154296875), SC_(0.81018496059627083036058461166125860043982866987277e-4) }}, 
      {{ SC_(11.84997081756591796875), SC_(-3), SC_(0.81158387660980224609375), SC_(-0.00013226110423271619374803791001430283951730245350595) }}, 
      {{ SC_(11.84997081756591796875), SC_(-1), SC_(0.826751708984375), SC_(-0.0040979297572913890790531337178784142062844908280042) }}, 
      {{ SC_(11.84997081756591796875), SC_(0), SC_(-0.804919183254241943359375), SC_(-0.29753322859260680967406878028841522576050347782121) }}, 
      {{ SC_(11.84997081756591796875), SC_(0), SC_(-0.44300353527069091796875), SC_(-0.20897102536739270748155301914422564587637993175572) }}, 
      {{ SC_(11.84997081756591796875), SC_(0), SC_(0.98576259613037109375), SC_(0.25718519997355322934845056525480032969786078351821) }}, 
      {{ SC_(11.84997081756591796875), SC_(2), SC_(-0.38366591930389404296875), SC_(31.321494899202229629503730871768387574032327364668) }}, 
      {{ SC_(11.84997081756591796875), SC_(3), SC_(0.62944734096527099609375), SC_(-133.45273880919003222397159296712531292386296841578) }}, 
      {{ SC_(11.84997081756591796875), SC_(4), SC_(0.99292266368865966796875), SC_(124.0791430575599930695018428639543182491862135452) }}, 
      {{ SC_(11.84997081756591796875), SC_(8), SC_(-0.72904598712921142578125), SC_(-31278996.346844030458961294814400214328489738408282) }}, 
      {{ SC_(11.84997081756591796875), SC_(9), SC_(-0.5579319000244140625), SC_(-338438171.1910644879479672790426918021710482022825) }}, 
      {{ SC_(11.84997081756591796875), SC_(10), SC_(0.91501367092132568359375), SC_(1436525.2077063817917494317507659803096843830478934) }}, 
      {{ SC_(13.3824672698974609375), SC_(-13), SC_(-0.804919183254241943359375), SC_(0.22166639523051638106418604328947911924875738037195e-16) }}, 
      {{ SC_(13.3824672698974609375), SC_(-13), SC_(0.92977702617645263671875), SC_(0.44693154474481435928082063045813863131262403955661e-19) }}, 
      {{ SC_(13.3824672698974609375), SC_(-12), SC_(-0.62323606014251708984375), SC_(-0.16621175359968221829687634726523126274572535451776e-13) }}, 
      {{ SC_(13.3824672698974609375), SC_(-11), SC_(-0.5579319000244140625), SC_(0.44450919253842863629215666338932968470668430070296e-12) }}, 
      {{ SC_(13.3824672698974609375), SC_(-10), SC_(0.93773555755615234375), SC_(0.55673512583170756101841118590153351963256527278471e-14) }}, 
      {{ SC_(13.3824672698974609375), SC_(-9), SC_(0.81158387660980224609375), SC_(0.15673048027086770934389940776395437140646071715598e-10) }}, 
      {{ SC_(13.3824672698974609375), SC_(-7), SC_(0.09376299381256103515625), SC_(-0.18900830818056138997299707029920201032855688227972e-8) }}, 
      {{ SC_(13.3824672698974609375), SC_(-7), SC_(0.93538987636566162109375), SC_(0.62398829036318924421682890093652108111426929160992e-9) }}, 
      {{ SC_(13.3824672698974609375), SC_(-6), SC_(-0.74602639675140380859375), SC_(-0.21723575516243262421798797023094100622452296975193e-7) }}, 
      {{ SC_(13.3824672698974609375), SC_(2), SC_(0.264718532562255859375), SC_(17.034455941674013494369196837130404278802967075785) }}, 
      {{ SC_(13.3824672698974609375), SC_(2), SC_(0.98576259613037109375), SC_(74.199869740310278546928044799483142489006719811421) }}, 
      {{ SC_(13.3824672698974609375), SC_(4), SC_(0.826751708984375), SC_(-2970.4202769206060544252953563327031335250923271111) }}, 
      {{ SC_(13.3824672698974609375), SC_(6), SC_(-0.72904598712921142578125), SC_(-142653.18426864739894657986914209617064658696817064) }}, 
      {{ SC_(13.3824672698974609375), SC_(6), SC_(-0.44300353527069091796875), SC_(-847125.49020389136626193373354682614784551391911727) }}, 
      {{ SC_(13.3824672698974609375), SC_(6), SC_(0.67001712322235107421875), SC_(-973179.19295459124004349072652615957844656182701482) }}, 
      {{ SC_(13.3824672698974609375), SC_(7), SC_(0.0944411754608154296875), SC_(6291587.8396040891190619719705059087867165445493) }}, 
      {{ SC_(13.3824672698974609375), SC_(8), SC_(-0.38366591930389404296875), SC_(148736140.90353794537277725465559178875001451292523) }}, 
      {{ SC_(13.3824672698974609375), SC_(8), SC_(0.99292266368865966796875), SC_(1562.9986080941304055581037380248889804054119356879) }}, 
      {{ SC_(13.3824672698974609375), SC_(9), SC_(0.62944734096527099609375), SC_(-2282996099.0744102550139909067331966860804173216966) }}, 
      {{ SC_(13.3824672698974609375), SC_(9), SC_(0.91501367092132568359375), SC_(-47108686.442640842883533859076465535279340150282202) }}, 
      {{ SC_(16.6650257110595703125), SC_(-16), SC_(-0.5579319000244140625), SC_(0.36914896153983860669619753805966665027048352841086e-19) }}, 
      {{ SC_(16.6650257110595703125), SC_(-15), SC_(-0.804919183254241943359375), SC_(-0.74790282995655983775531645052438536118228838933368e-20) }}, 
      {{ SC_(16.6650257110595703125), SC_(-15), SC_(-0.62323606014251708984375), SC_(-0.36398678387957337085009611234034932395493463191661e-18) }}, 
      {{ SC_(16.6650257110595703125), SC_(-14), SC_(0.93773555755615234375), SC_(0.22807828690216376785976940239028828932632169446174e-21) }}, 
      {{ SC_(16.6650257110595703125), SC_(-13), SC_(0.92977702617645263671875), SC_(0.35320050515977865959614707894521274040624190465647e-19) }}, 
      {{ SC_(16.6650257110595703125), SC_(-12), SC_(0.81158387660980224609375), SC_(0.3082671873049785091792439153346921827065397800962e-15) }}, 
      {{ SC_(16.6650257110595703125), SC_(-4), SC_(0.93538987636566162109375), SC_(0.52291298347581562621901072563414165417626206009583e-5) }}, 
      {{ SC_(16.6650257110595703125), SC_(-2), SC_(0.99292266368865966796875), SC_(0.0012698575294388484883534762618017745047909786068378) }}, 
      {{ SC_(16.6650257110595703125), SC_(-1), SC_(0.0944411754608154296875), SC_(-0.011944140876262027507943894873016233264464123175583) }}, 
      {{ SC_(16.6650257110595703125), SC_(-1), SC_(0.91501367092132568359375), SC_(-0.0031076083789904422712562161725068777570567479833285) }}, 
      {{ SC_(16.6650257110595703125), SC_(4), SC_(-0.44300353527069091796875), SC_(7489.7232452416344466185434844943197669989737666647) }}, 
      {{ SC_(16.6650257110595703125), SC_(5), SC_(0.67001712322235107421875), SC_(-245785.37315952021732160039445469928096897296200858) }}, 
      {{ SC_(16.6650257110595703125), SC_(7), SC_(-0.72904598712921142578125), SC_(-49207050.468316885335102250704228071597639131505993) }}, 
      {{ SC_(16.6650257110595703125), SC_(7), SC_(0.264718532562255859375), SC_(42453247.952851458881163464731595954318082047470875) }}, 
      {{ SC_(16.6650257110595703125), SC_(8), SC_(0.62944734096527099609375), SC_(-979230421.06039761780739880450853659640100219735369) }}, 
      {{ SC_(16.6650257110595703125), SC_(10), SC_(-0.38366591930389404296875), SC_(-65484300474.651994691389202076648539080316522513276) }}, 
      {{ SC_(16.6650257110595703125), SC_(11), SC_(0.826751708984375), SC_(-621994593400.85818284286708477331063639042478826259) }}, 
      {{ SC_(16.6650257110595703125), SC_(13), SC_(0.98576259613037109375), SC_(-2368679.116056950972031807234328493387762603085367) }}, 
      {{ SC_(16.6650257110595703125), SC_(16), SC_(-0.74602639675140380859375), SC_(286937498915109.72391794972691070626807358288824491) }}, 
      {{ SC_(16.6650257110595703125), SC_(16), SC_(0.09376299381256103515625), SC_(178810232213386344.75148306627111836848013903472344) }}, 
      {{ SC_(17.0301532745361328125), SC_(-17), SC_(0.81158387660980224609375), SC_(0.23089891934552557492903571788866976069269398034636e-23) }}, 
      {{ SC_(17.0301532745361328125), SC_(-16), SC_(0.92977702617645263671875), SC_(0.77120542993546838080187693618711944669104877784798e-25) }}, 
      {{ SC_(17.0301532745361328125), SC_(-14), SC_(-0.38366591930389404296875), SC_(-0.54561248812503755335991908931944825672149594319331e-17) }}, 
      {{ SC_(17.0301532745361328125), SC_(-14), SC_(0.264718532562255859375), SC_(-0.25540948412416548331728930347103911513122873387648e-17) }}, 
      {{ SC_(17.0301532745361328125), SC_(-12), SC_(0.62944734096527099609375), SC_(0.11267232505246190944593673014733244504856527347217e-14) }}, 
      {{ SC_(17.0301532745361328125), SC_(-11), SC_(0.93538987636566162109375), SC_(0.8080068473692047289701190290402825999134033774326e-16) }}, 
      {{ SC_(17.0301532745361328125), SC_(-8), SC_(-0.44300353527069091796875), SC_(-0.23668950399843099002326915537352916668711085164683e-10) }}, 
      {{ SC_(17.0301532745361328125), SC_(-4), SC_(-0.62323606014251708984375), SC_(0.22257178074585895343804673994496661297003034593049e-5) }}, 
      {{ SC_(17.0301532745361328125), SC_(-4), SC_(-0.5579319000244140625), SC_(0.13825468678287818487268474508564732013727903072802e-5) }}, 
      {{ SC_(17.0301532745361328125), SC_(-2), SC_(0.98576259613037109375), SC_(0.0015940113463464718894604985317013703396900221174161) }}, 
      {{ SC_(17.0301532745361328125), SC_(-1), SC_(-0.72904598712921142578125), SC_(-0.00179298507080800413716717496074397930291963387428) }}, 
      {{ SC_(17.0301532745361328125), SC_(2), SC_(-0.74602639675140380859375), SC_(63.703534657883034459738823553326354020852528298334) }}, 
      {{ SC_(17.0301532745361328125), SC_(4), SC_(0.91501367092132568359375), SC_(9578.4486235254777894217041455902077880056968913822) }}, 
      {{ SC_(17.0301532745361328125), SC_(6), SC_(0.09376299381256103515625), SC_(-5017339.216196783919233944407631270205095529788784) }}, 
      {{ SC_(17.0301532745361328125), SC_(6), SC_(0.0944411754608154296875), SC_(-5018698.5341072323277278971254008046714224679259579) }}, 
      {{ SC_(17.0301532745361328125), SC_(7), SC_(0.99292266368865966796875), SC_(-78992.039209423422657071913321786385052597355213482) }}, 
      {{ SC_(17.0301532745361328125), SC_(8), SC_(0.826751708984375), SC_(2125458172.4081600001165033646972051069773553913414) }}, 
      {{ SC_(17.0301532745361328125), SC_(11), SC_(-0.804919183254241943359375), SC_(-3083182177646.0814083741337604451869998939540761478) }}, 
      {{ SC_(17.0301532745361328125), SC_(16), SC_(0.93773555755615234375), SC_(266651139531.32384929509372467284346479362567522913) }}, 
      {{ SC_(17.0301532745361328125), SC_(17), SC_(0.67001712322235107421875), SC_(-39984434200097046.063642477455323422467024142361322) }}, 
      {{ SC_(18.3042545318603515625), SC_(-16), SC_(0.91501367092132568359375), SC_(0.29883615646300452729116273431746068354341463393245e-24) }}, 
      {{ SC_(18.3042545318603515625), SC_(-15), SC_(-0.5579319000244140625), SC_(-0.19593885482631020055319069838825786355264001980923e-18) }}, 
      {{ SC_(18.3042545318603515625), SC_(-13), SC_(0.93538987636566162109375), SC_(0.18015893170629159643302327598927935673211915247379e-19) }}, 
      {{ SC_(18.3042545318603515625), SC_(-9), SC_(0.09376299381256103515625), SC_(0.11469696889070244336893177339905362355047054202956e-11) }}, 
      {{ SC_(18.3042545318603515625), SC_(-8), SC_(-0.38366591930389404296875), SC_(-0.1887440538785176364549309437756617748819077392573e-10) }}, 
      {{ SC_(18.3042545318603515625), SC_(-6), SC_(0.62944734096527099609375), SC_(0.43674982083323422168372530118149718931490233301677e-8) }}, 
      {{ SC_(18.3042545318603515625), SC_(-4), SC_(-0.44300353527069091796875), SC_(0.7202196497255920924428859123626553791826086042503e-6) }}, 
      {{ SC_(18.3042545318603515625), SC_(-2), SC_(-0.804919183254241943359375), SC_(-0.77283649068875750938251183253775363894689287493389e-4) }}, 
      {{ SC_(18.3042545318603515625), SC_(1), SC_(-0.74602639675140380859375), SC_(0.63828710585725175676940885969260056847792325179648) }}, 
      {{ SC_(18.3042545318603515625), SC_(2), SC_(0.98576259613037109375), SC_(166.08676681462310504060036212332710646394263847909) }}, 
      {{ SC_(18.3042545318603515625), SC_(4), SC_(0.99292266368865966796875), SC_(5290.5406072371351692027633069511734187279679177777) }}, 
      {{ SC_(18.3042545318603515625), SC_(5), SC_(0.264718532562255859375), SC_(392113.36345354167041874035916897478682871001810603) }}, 
      {{ SC_(18.3042545318603515625), SC_(5), SC_(0.826751708984375), SC_(515813.36159934241989083840875835833434313742166124) }}, 
      {{ SC_(18.3042545318603515625), SC_(10), SC_(0.81158387660980224609375), SC_(786203092993.54293624662825003360911583842842889743) }}, 
      {{ SC_(18.3042545318603515625), SC_(11), SC_(0.67001712322235107421875), SC_(-8261729884863.6657373747045319640816334012239447799) }}, 
      {{ SC_(18.3042545318603515625), SC_(12), SC_(0.0944411754608154296875), SC_(-30579050031328.838999922313096299251374259570555362) }}, 
      {{ SC_(18.3042545318603515625), SC_(13), SC_(-0.62323606014251708984375), SC_(2490927774952003.541834741685697258166307532119113) }}, 
      {{ SC_(18.3042545318603515625), SC_(14), SC_(-0.72904598712921142578125), SC_(8874022800651066.6502918671748924861977690946025867) }}, 
      {{ SC_(18.3042545318603515625), SC_(15), SC_(0.93773555755615234375), SC_(-3553964025785.9966811637710283958451213589141162289) }}, 
      {{ SC_(18.3042545318603515625), SC_(18), SC_(0.92977702617645263671875), SC_(3416106077482.7264856872784871760461910378746573151) }}, 
      {{ SC_(18.440765380859375), SC_(-17), SC_(-0.5579319000244140625), SC_(-0.50271604952920343300607472787502048319360871188692e-21) }}, 
      {{ SC_(18.440765380859375), SC_(-16), SC_(-0.804919183254241943359375), SC_(0.10984637871249881776444510537426108537817137259055e-21) }}, 
      {{ SC_(18.440765380859375), SC_(-12), SC_(-0.74602639675140380859375), SC_(0.38699810971215052589513068420573917306170228310572e-15) }}, 
      {{ SC_(18.440765380859375), SC_(-12), SC_(0.93773555755615234375), SC_(0.98565761862632574513933033426583440815341731508199e-18) }}, 
      {{ SC_(18.440765380859375), SC_(-6), SC_(0.264718532562255859375), SC_(-0.15283288108259116456399654021918348895173752216729e-9) }}, 
      {{ SC_(18.440765380859375), SC_(-5), SC_(0.67001712322235107421875), SC_(0.42663862212707289150211045881623824679654531468886e-7) }}, 
      {{ SC_(18.440765380859375), SC_(-5), SC_(0.98576259613037109375), SC_(0.23861087627268731000356265059002054846394077572679e-7) }}, 
      {{ SC_(18.440765380859375), SC_(-4), SC_(0.91501367092132568359375), SC_(-0.80543753849626232167758105932861113884499338011562e-7) }}, 
      {{ SC_(18.440765380859375), SC_(-2), SC_(0.09376299381256103515625), SC_(-0.85382295357652349741567303582030854482898935914125e-4) }}, 
      {{ SC_(18.440765380859375), SC_(-1), SC_(0.99292266368865966796875), SC_(0.030086983815468676149299012036109061540059539271355) }}, 
      {{ SC_(18.440765380859375), SC_(0), SC_(-0.72904598712921142578125), SC_(0.18653718888369370131458265584018026946159296567964) }}, 
      {{ SC_(18.440765380859375), SC_(0), SC_(0.62944734096527099609375), SC_(-0.21025192720175270695719746239016794207250758550671) }}, 
      {{ SC_(18.440765380859375), SC_(5), SC_(-0.38366591930389404296875), SC_(264699.84731638138429900882287246208183148022742781) }}, 
      {{ SC_(18.440765380859375), SC_(5), SC_(0.92977702617645263671875), SC_(-736319.88814289375666669784796756264581839709032387) }}, 
      {{ SC_(18.440765380859375), SC_(7), SC_(0.826751708984375), SC_(-42543004.889913803417064413390657862883996054044383) }}, 
      {{ SC_(18.440765380859375), SC_(11), SC_(-0.62323606014251708984375), SC_(838990229190.95540426631634358776581787814066606189) }}, 
      {{ SC_(18.440765380859375), SC_(13), SC_(0.81158387660980224609375), SC_(-358219758017025.29646048607070742930527995349756931) }}, 
      {{ SC_(18.440765380859375), SC_(15), SC_(0.0944411754608154296875), SC_(250504952280779402.4459453389974592578734995999658) }}, 
      {{ SC_(18.440765380859375), SC_(17), SC_(0.93538987636566162109375), SC_(-4382618700190.530435650666874966527218631896635012) }}, 
      {{ SC_(18.440765380859375), SC_(18), SC_(-0.44300353527069091796875), SC_(31026494575738330367.158321747018911852847647134982) }}, 
      {{ SC_(19.2351226806640625), SC_(-19), SC_(0.826751708984375), SC_(0.28096099754174757639142988313052093117069710820259e-27) }}, 
      {{ SC_(19.2351226806640625), SC_(-15), SC_(0.93773555755615234375), SC_(0.22729284127735589054255258668317884253291919419305e-23) }}, 
      {{ SC_(19.2351226806640625), SC_(-13), SC_(0.99292266368865966796875), SC_(0.1743121215871876802557328668088468943943263194911e-25) }}, 
      {{ SC_(19.2351226806640625), SC_(-10), SC_(-0.38366591930389404296875), SC_(-0.10293684623854104934250449760096572176156444372122e-13) }}, 
      {{ SC_(19.2351226806640625), SC_(-10), SC_(0.264718532562255859375), SC_(-0.39291909511632775673453848171264487384306556380656e-13) }}, 
      {{ SC_(19.2351226806640625), SC_(1), SC_(0.92977702617645263671875), SC_(-1.8928597921982751461985041697534535744382441623969) }}, 
      {{ SC_(19.2351226806640625), SC_(1), SC_(0.93538987636566162109375), SC_(-0.17753066615543550750253798142286628228408488271265) }}, 
      {{ SC_(19.2351226806640625), SC_(3), SC_(-0.62323606014251708984375), SC_(-1406.8551161661961787833668743464163883272950430824) }}, 
      {{ SC_(19.2351226806640625), SC_(3), SC_(0.81158387660980224609375), SC_(-1349.1692552830459195981604712085505043997296160725) }}, 
      {{ SC_(19.2351226806640625), SC_(4), SC_(-0.74602639675140380859375), SC_(-8037.6658264469123963393087477071904706108915347975) }}, 
      {{ SC_(19.2351226806640625), SC_(4), SC_(0.0944411754608154296875), SC_(-25028.145293006716172962519105923296460758908547618) }}, 
      {{ SC_(19.2351226806640625), SC_(4), SC_(0.67001712322235107421875), SC_(-29534.257011785190165176788825355970943316250224702) }}, 
      {{ SC_(19.2351226806640625), SC_(4), SC_(0.91501367092132568359375), SC_(-16392.232356669543132626194808379585805064546084349) }}, 
      {{ SC_(19.2351226806640625), SC_(4), SC_(0.98576259613037109375), SC_(23971.132007029558069016801023045608495969275263064) }}, 
      {{ SC_(19.2351226806640625), SC_(6), SC_(-0.72904598712921142578125), SC_(-8140834.1324089639935519173978872996653658919863967) }}, 
      {{ SC_(19.2351226806640625), SC_(6), SC_(-0.44300353527069091796875), SC_(-7930928.2397986661163007545526813521615562150281197) }}, 
      {{ SC_(19.2351226806640625), SC_(9), SC_(-0.804919183254241943359375), SC_(-72379113476.352796377305937996940747985952066128593) }}, 
      {{ SC_(19.2351226806640625), SC_(13), SC_(0.62944734096527099609375), SC_(-5134369678377531.0833016268690600215514053304023389) }}, 
      {{ SC_(19.2351226806640625), SC_(15), SC_(-0.5579319000244140625), SC_(-1015762016510443869.6327233053169209347494734043869) }}, 
      {{ SC_(19.2351226806640625), SC_(18), SC_(0.09376299381256103515625), SC_(710186740012925626467.73942195603474203745449828018) }}, 
      {{ SC_(19.367992401123046875), SC_(-17), SC_(0.62944734096527099609375), SC_(0.11171785200806076601510755896553721227874614231315e-21) }}, 
      {{ SC_(19.367992401123046875), SC_(-15), SC_(0.67001712322235107421875), SC_(0.41708170484402827993195327851962176229050519214935e-19) }}, 
      {{ SC_(19.367992401123046875), SC_(-11), SC_(0.91501367092132568359375), SC_(0.21756446987184863754567940655540650014788217090708e-15) }}, 
      {{ SC_(19.367992401123046875), SC_(-10), SC_(0.264718532562255859375), SC_(-0.39291909511632775673453848171264487384306556380656e-13) }}, 
      {{ SC_(19.367992401123046875), SC_(-10), SC_(0.93538987636566162109375), SC_(0.35203386148632068895108168682763476328178687031646e-14) }}, 
      {{ SC_(19.367992401123046875), SC_(-8), SC_(0.09376299381256103515625), SC_(-0.11426052789780942300532608169075547762937997222756e-10) }}, 
      {{ SC_(19.367992401123046875), SC_(-3), SC_(0.0944411754608154296875), SC_(-0.62009805308781525829391269462790209708034571751975e-5) }}, 
      {{ SC_(19.367992401123046875), SC_(-3), SC_(0.98576259613037109375), SC_(0.48683625637537837402773720121195220847472881885636e-4) }}, 
      {{ SC_(19.367992401123046875), SC_(-1), SC_(-0.5579319000244140625), SC_(-0.0051771830750291213227283927254523671758223103225019) }}, 
      {{ SC_(19.367992401123046875), SC_(4), SC_(-0.804919183254241943359375), SC_(-31206.872941793395251553296530119153550183252786295) }}, 
      {{ SC_(19.367992401123046875), SC_(4), SC_(-0.44300353527069091796875), SC_(17028.045702509925174397449943279294145247295355527) }}, 
      {{ SC_(19.367992401123046875), SC_(9), SC_(-0.72904598712921142578125), SC_(40963049161.840563921749109759131967640623017931928) }}, 
      {{ SC_(19.367992401123046875), SC_(10), SC_(0.81158387660980224609375), SC_(1539232549071.2403439978796189170963046987864230162) }}, 
      {{ SC_(19.367992401123046875), SC_(12), SC_(-0.38366591930389404296875), SC_(-88775931893030.570776909560322117125028614222504249) }}, 
      {{ SC_(19.367992401123046875), SC_(13), SC_(0.99292266368865966796875), SC_(-6370402.0056839501875375385352467787059666973045593) }}, 
      {{ SC_(19.367992401123046875), SC_(14), SC_(-0.74602639675140380859375), SC_(-29382493955027210.900261178223964994850616622296376) }}, 
      {{ SC_(19.367992401123046875), SC_(14), SC_(-0.62323606014251708984375), SC_(-78338179480735275.385980722705110901752445891864321) }}, 
      {{ SC_(19.367992401123046875), SC_(15), SC_(0.826751708984375), SC_(-21925888030419983.923456036187293901038296511900498) }}, 
      {{ SC_(19.367992401123046875), SC_(15), SC_(0.92977702617645263671875), SC_(-64341448614367.513605394800667731791476692010324668) }}, 
      {{ SC_(19.367992401123046875), SC_(18), SC_(0.93773555755615234375), SC_(41662739626590.703682551951618167157234877634542544) }}, 
      {{ SC_(19.4185085296630859375), SC_(-18), SC_(0.0944411754608154296875), SC_(0.51911342450084606006498960540691516909936454811191e-22) }}, 
      {{ SC_(19.4185085296630859375), SC_(-17), SC_(-0.5579319000244140625), SC_(0.26324372445835333986291229819511043236130501244613e-21) }}, 
      {{ SC_(19.4185085296630859375), SC_(-13), SC_(-0.74602639675140380859375), SC_(0.1038530509609787824487836468215661897944095895319e-16) }}, 
      {{ SC_(19.4185085296630859375), SC_(-13), SC_(-0.44300353527069091796875), SC_(-0.11954326307657381817424475791045577141774274614215e-16) }}, 
      {{ SC_(19.4185085296630859375), SC_(-11), SC_(0.98576259613037109375), SC_(0.32010533648064664252568315383909193374387441919969e-19) }}, 
      {{ SC_(19.4185085296630859375), SC_(-8), SC_(0.93538987636566162109375), SC_(0.70096078678514191093666708376458847827858161562235e-11) }}, 
      {{ SC_(19.4185085296630859375), SC_(-6), SC_(0.826751708984375), SC_(-0.50239978245173340481994943923797004708278735544008e-8) }}, 
      {{ SC_(19.4185085296630859375), SC_(-6), SC_(0.91501367092132568359375), SC_(0.69080326024780067300862626196534340743493983872007e-8) }}, 
      {{ SC_(19.4185085296630859375), SC_(-5), SC_(-0.38366591930389404296875), SC_(-0.30848661309469795756336369771506539897303178512343e-7) }}, 
      {{ SC_(19.4185085296630859375), SC_(-2), SC_(-0.72904598712921142578125), SC_(0.6914266105284580609485581648675886651787722622556e-4) }}, 
      {{ SC_(19.4185085296630859375), SC_(-2), SC_(0.93773555755615234375), SC_(-0.00082097977947824531306568828914325965998735309386971) }}, 
      {{ SC_(19.4185085296630859375), SC_(1), SC_(0.81158387660980224609375), SC_(4.2277096876026264281609013898703823312548839649606) }}, 
      {{ SC_(19.4185085296630859375), SC_(3), SC_(-0.804919183254241943359375), SC_(-1069.4488089252507695912869014570583577070805013318) }}, 
      {{ SC_(19.4185085296630859375), SC_(8), SC_(-0.62323606014251708984375), SC_(-2666091237.1634788661326592401910351174873913360323) }}, 
      {{ SC_(19.4185085296630859375), SC_(8), SC_(0.99292266368865966796875), SC_(925591.97999902651810095119605577620595541436584718) }}, 
      {{ SC_(19.4185085296630859375), SC_(9), SC_(0.264718532562255859375), SC_(-5122686380.6946779314572422174331586519139555025857) }}, 
      {{ SC_(19.4185085296630859375), SC_(10), SC_(0.09376299381256103515625), SC_(965104740093.56545540804916275928148739799548313534) }}, 
      {{ SC_(19.4185085296630859375), SC_(11), SC_(0.92977702617645263671875), SC_(-624047483227.59396674703988209346984924810845031782) }}, 
      {{ SC_(19.4185085296630859375), SC_(15), SC_(0.62944734096527099609375), SC_(-738329845534139238.31589929078368480078587395312756) }}, 
      {{ SC_(19.4185085296630859375), SC_(18), SC_(0.67001712322235107421875), SC_(25754480226319677835.76098992722595983871287263485) }}, 
      {{ SC_(19.4396209716796875), SC_(-19), SC_(0.826751708984375), SC_(0.28096099754174757639142988313052093117069710820259e-27) }}, 
      {{ SC_(19.4396209716796875), SC_(-19), SC_(0.99292266368865966796875), SC_(0.41139415501798503182620662065024377889890717413858e-40) }}, 
      {{ SC_(19.4396209716796875), SC_(-16), SC_(0.92977702617645263671875), SC_(0.65747433121722074118768922518726326206091216387016e-25) }}, 
      {{ SC_(19.4396209716796875), SC_(-14), SC_(0.0944411754608154296875), SC_(0.7750508585662675010738068913765041007697196976154e-18) }}, 
      {{ SC_(19.4396209716796875), SC_(-10), SC_(0.93538987636566162109375), SC_(0.35203386148632068895108168682763476328178687031646e-14) }}, 
      {{ SC_(19.4396209716796875), SC_(-9), SC_(-0.804919183254241943359375), SC_(0.861460700695142273465894246225707493326360379112e-12) }}, 
      {{ SC_(19.4396209716796875), SC_(-9), SC_(0.09376299381256103515625), SC_(0.35797340830762850114741224311803714456251087097646e-13) }}, 
      {{ SC_(19.4396209716796875), SC_(-9), SC_(0.264718532562255859375), SC_(0.60970531234766811023858960941339345617424038691191e-13) }}, 
      {{ SC_(19.4396209716796875), SC_(-4), SC_(0.81158387660980224609375), SC_(0.14162438520800722165613785588526894318263591840579e-5) }}, 
      {{ SC_(19.4396209716796875), SC_(0), SC_(0.93773555755615234375), SC_(0.30185089350015097041813236342216465473811492066808) }}, 
      {{ SC_(19.4396209716796875), SC_(1), SC_(-0.74602639675140380859375), SC_(-3.3298125144104874439554986012917200328078041284076) }}, 
      {{ SC_(19.4396209716796875), SC_(6), SC_(-0.62323606014251708984375), SC_(2070223.0689771828593384049574788254082161424782151) }}, 
      {{ SC_(19.4396209716796875), SC_(9), SC_(-0.72904598712921142578125), SC_(40963049161.840563921749109759131967640623017931928) }}, 
      {{ SC_(19.4396209716796875), SC_(12), SC_(0.91501367092132568359375), SC_(7040751124453.4488884066354472049044671577945030141) }}, 
      {{ SC_(19.4396209716796875), SC_(13), SC_(0.67001712322235107421875), SC_(-5687940021302887.6451945681691475411327830115702795) }}, 
      {{ SC_(19.4396209716796875), SC_(14), SC_(0.98576259613037109375), SC_(674245566.99025968816472030671195432637133872627082) }}, 
      {{ SC_(19.4396209716796875), SC_(17), SC_(-0.38366591930389404296875), SC_(-127301699165359197878.79551348556848810793872324273) }}, 
      {{ SC_(19.4396209716796875), SC_(18), SC_(-0.5579319000244140625), SC_(-159505604178383717077.46533923481855803222244671133) }}, 
      {{ SC_(19.4396209716796875), SC_(19), SC_(-0.44300353527069091796875), SC_(-1029187142567780884281.5753644645077933758833454754) }}, 
      {{ SC_(19.4396209716796875), SC_(19), SC_(0.62944734096527099609375), SC_(-67969400336711244635.100926182757403393151023891505) }}, 
      {{ SC_(19.87186431884765625), SC_(-18), SC_(0.0944411754608154296875), SC_(0.51911342450084606006498960540691516909936454811191e-22) }}, 
      {{ SC_(19.87186431884765625), SC_(-17), SC_(0.67001712322235107421875), SC_(0.58726064536889576863720153513076020150678343992132e-22) }}, 
      {{ SC_(19.87186431884765625), SC_(-14), SC_(0.09376299381256103515625), SC_(0.77286264421078668095197950811355859649633390890055e-18) }}, 
      {{ SC_(19.87186431884765625), SC_(-13), SC_(0.98576259613037109375), SC_(0.15205096913859731930591097244177400726284058187231e-23) }}, 
      {{ SC_(19.87186431884765625), SC_(-12), SC_(0.62944734096527099609375), SC_(0.84179594974630947109160535195453410788993007175736e-16) }}, 
      {{ SC_(19.87186431884765625), SC_(-6), SC_(0.93773555755615234375), SC_(0.66088259609398732039730419153668689085254808488491e-8) }}, 
      {{ SC_(19.87186431884765625), SC_(-3), SC_(0.92977702617645263671875), SC_(-0.3202584859446750447001544695075271493418238924369e-4) }}, 
      {{ SC_(19.87186431884765625), SC_(2), SC_(0.93538987636566162109375), SC_(-114.29504330922803764479417554506839061453574689078) }}, 
      {{ SC_(19.87186431884765625), SC_(3), SC_(0.264718532562255859375), SC_(-590.31121404357419718511991159003397861067922712095) }}, 
      {{ SC_(19.87186431884765625), SC_(4), SC_(-0.804919183254241943359375), SC_(-31206.872941793395251553296530119153550183252786295) }}, 
      {{ SC_(19.87186431884765625), SC_(4), SC_(0.81158387660980224609375), SC_(27998.376863739953480856174913557597864204862111517) }}, 
      {{ SC_(19.87186431884765625), SC_(6), SC_(-0.74602639675140380859375), SC_(-3988947.6757273109841392288902418535673497942678044) }}, 
      {{ SC_(19.87186431884765625), SC_(6), SC_(0.91501367092132568359375), SC_(17207577.76868430351907141387711761936487111245407) }}, 
      {{ SC_(19.87186431884765625), SC_(8), SC_(-0.5579319000244140625), SC_(-2880999408.1753053515439782739761895146097466930431) }}, 
      {{ SC_(19.87186431884765625), SC_(10), SC_(-0.38366591930389404296875), SC_(-250811038036.64016980933046385373956183195852302589) }}, 
      {{ SC_(19.87186431884765625), SC_(11), SC_(0.99292266368865966796875), SC_(-4956548.0008289171017772512361059049573500136580832) }}, 
      {{ SC_(19.87186431884765625), SC_(12), SC_(-0.62323606014251708984375), SC_(-106590833899905.54371031227921841065877625515491286) }}, 
      {{ SC_(19.87186431884765625), SC_(12), SC_(-0.44300353527069091796875), SC_(164377317484172.780269767864581766622776515649156) }}, 
      {{ SC_(19.87186431884765625), SC_(18), SC_(-0.72904598712921142578125), SC_(-6500249695425848422.6994934374150447524907522260626) }}, 
      {{ SC_(19.87186431884765625), SC_(18), SC_(0.826751708984375), SC_(215957040146103710.43752878136972484271174243226819) }}, 
      {{ SC_(19.9363040924072265625), SC_(-19), SC_(-0.5579319000244140625), SC_(0.4536209533748046856223356436528310434693264815516e-24) }}, 
      {{ SC_(19.9363040924072265625), SC_(-19), SC_(0.264718532562255859375), SC_(0.78629720841879126459468443827603688509992408472136e-23) }}, 
      {{ SC_(19.9363040924072265625), SC_(-17), SC_(-0.44300353527069091796875), SC_(0.58251104165678394898744857711146365095314417691743e-21) }}, 
      {{ SC_(19.9363040924072265625), SC_(-16), SC_(-0.62323606014251708984375), SC_(-0.29751304424052425636113962115386812591456175870573e-20) }}, 
      {{ SC_(19.9363040924072265625), SC_(-14), SC_(0.91501367092132568359375), SC_(0.12709748787166211089363084338252308414817659872819e-20) }}, 
      {{ SC_(19.9363040924072265625), SC_(-14), SC_(0.92977702617645263671875), SC_(0.3871138758064428596131493508699859591733838577277e-21) }}, 
      {{ SC_(19.9363040924072265625), SC_(-12), SC_(0.93773555755615234375), SC_(0.89408958662499196674261505271428146255253342324884e-18) }}, 
      {{ SC_(19.9363040924072265625), SC_(-11), SC_(-0.38366591930389404296875), SC_(0.26026063256932547239295328669255586707226242612148e-14) }}, 
      {{ SC_(19.9363040924072265625), SC_(-10), SC_(-0.74602639675140380859375), SC_(-0.34765506905243672613499520824866410956137457719745e-13) }}, 
      {{ SC_(19.9363040924072265625), SC_(-10), SC_(0.81158387660980224609375), SC_(0.63172556307492864748930303721096827403984649074523e-13) }}, 
      {{ SC_(19.9363040924072265625), SC_(-4), SC_(0.0944411754608154296875), SC_(-0.12660004211205826580535251463738122438007427377005e-5) }}, 
      {{ SC_(19.9363040924072265625), SC_(-4), SC_(0.62944734096527099609375), SC_(-0.54962149013781842129875877015678395599272910286725e-6) }}, 
      {{ SC_(19.9363040924072265625), SC_(2), SC_(0.09376299381256103515625), SC_(66.642893417106666543810431512449143935500286088633) }}, 
      {{ SC_(19.9363040924072265625), SC_(3), SC_(0.99292266368865966796875), SC_(-1337.0443049910513329145515282976202263100750256813) }}, 
      {{ SC_(19.9363040924072265625), SC_(8), SC_(0.826751708984375), SC_(3010989900.8893375803525358367041329372033717978545) }}, 
      {{ SC_(19.9363040924072265625), SC_(10), SC_(-0.72904598712921142578125), SC_(-451944141173.12209414901560544187498153708108846852) }}, 
      {{ SC_(19.9363040924072265625), SC_(11), SC_(0.67001712322235107421875), SC_(-3818836562168.0063397346459855637481748033411304683) }}, 
      {{ SC_(19.9363040924072265625), SC_(13), SC_(0.98576259613037109375), SC_(-555684705.08358775884287423663622045616768375133224) }}, 
      {{ SC_(19.9363040924072265625), SC_(15), SC_(-0.804919183254241943359375), SC_(-43129486142739936.248977475359797313525493031517393) }}, 
      {{ SC_(19.9363040924072265625), SC_(19), SC_(0.93538987636566162109375), SC_(-21677629202869.188161110548407561929925083445523615) }}
   }};

