/* === This file is part of Calamares - <https://github.com/calamares> ===
 *
 *   Copyright 2019-2020, Adriaan de Groot <groot@kde.org>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UTILS_ENTROPY_H
#define UTILS_ENTROPY_H

#include "DllMacro.h"

#include <QByteArray>

namespace CalamaresUtils
{
/// @brief Which entropy source was actually used for the entropy.
enum class EntropySource
{
    None,  ///< Buffer is empty, no random data
    URandom,  ///< Read from /dev/urandom
    Twister  ///< Generated by pseudo-random
};

/** @brief Fill buffer @p b with exactly @p size random bytes
 *
 * The array is cleared and resized, then filled with 0xcb
 * "just in case", after which it is filled with random
 * bytes from a suitable source. Returns which source was used.
 */
DLLEXPORT EntropySource getEntropy( int size, QByteArray& b );

/** @brief Fill string @p s with exactly @p size random printable ASCII characters
 *
 * The characters are picked from a set of 64 (2^6). The string
 * contains 6 * size bits of entropy. * Returns which source was used.
 * @see getEntropy
 */
DLLEXPORT EntropySource getPrintableEntropy( int size, QString& s );
}  // namespace CalamaresUtils

#endif
