/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2014 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <stdlib.h>

#include "cdw_digest.h"
#include "cdw_string.h"
#include "cdw_thread.h"
#include "cdw_debug.h"



cdw_rv_t cdw_digest_run_task(cdw_task_t *task)
{
	cdw_assert (task->calculate_digest.tool.label != (char *) NULL, "ERROR: tool fullpath is NULL\n");
	char *command = cdw_string_concat(task->calculate_digest.tool.label, " - ", (char *) NULL);
	if (command == (char *) NULL) {
		cdw_vdm ("ERROR: failed to allocate memory for command (1)\n");
		return CDW_ERROR;
	} else {
		cdw_vdm ("INFO: command for calculating digest: \"%s\"\n", command);
	}


	int rv = cdw_thread_run_command(command, task);
	free(command);
	command = (char *) NULL;

	if (rv == 0) {
		return CDW_OK;
	} else {
		return CDW_ERROR;
	}
}
