// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "XMLSerializer.pypp.hpp"

namespace bp = boost::python;

void register_XMLSerializer_class(){

    { //::CEGUI::XMLSerializer
        typedef bp::class_< CEGUI::XMLSerializer, boost::noncopyable > XMLSerializer_exposer_t;
        XMLSerializer_exposer_t XMLSerializer_exposer = XMLSerializer_exposer_t( "XMLSerializer", "*!\n\
             \n\
                 Class used to create XML Document. \n\
        \n\
            This class hides the complexity of formatting valid XML files. The\n\
            class provides automatic substitution of entities, XML indenting\n\
            in respect of the spaces. It does not contains any codes specific\n\
            to CEGUI taking appart the CEGUI.String class. The following\n\
            example show the code needed to exports parts of an XML document\n\
            similar to what can be found in a layout.\n\
            \n\
            . \n\
            #include <iostream>\n\
            #include <CEGUIXMLSerializer.h> \n\
            \n\
            int main() \n\
            {\n\
                Create an encoder that outputs its result on standard output \n\
               XMLSerializer xml(std.cout, 4);\n\
               xml.openTag(Window)\n\
                  .attribute(Type, TaharezLookStaticText)\n\
                  .attribute(Name, Test)\n\
                  .openTag(Property)\n\
                  .attribute(Name, Text)\n\
                  .text(This is the static text to be displayed)\n\
                  .closeTag()\n\
                  .openTag(Window)\n\
                  .attribute(Name, Button)\n\
                  .attribute(Type, VanillaButton)\n\
                  .openTag(Property)\n\
                  .attribute(Name, Text)\n\
                  .attribute(Value, Push me)\n\
                  .closeTag()\n\
                  .closeTag()\n\
                  .closeTag();\n\
                  \n\
               if (xml)\n\
               {\n\
                   std.cout << XML Exported successfully << std.endl;\n\
               }\n\
               return 0;\n\
            }\n\
            @endcode\n\
            *\n", bp::init< CEGUI::OutStream &, bp::optional< size_t > >(( bp::arg("out"), bp::arg("indentSpace")=(::size_t)(4) ), "*!\n\
         XMLSerializer constructor \n\
         \n\
        @param out The stream to use to export the result \n\
         \n\
         \n\
        @param indentSpace The indentation level (0 to disable indentation)\n\
        *\n") );
        bp::scope XMLSerializer_scope( XMLSerializer_exposer );
        bp::implicitly_convertible< CEGUI::OutStream &, CEGUI::XMLSerializer >();
        { //::CEGUI::XMLSerializer::attribute
        
            typedef ::CEGUI::XMLSerializer & ( ::CEGUI::XMLSerializer::*attribute_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            XMLSerializer_exposer.def( 
                "attribute"
                , attribute_function_type( &::CEGUI::XMLSerializer::attribute )
                , ( bp::arg("name"), bp::arg("value") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
             Close the current tag. \n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n\
            *!\n\
             After an opening tag you can populate attribute list with this function \n\
            \n\
            @param name The name of the attribute \n\
            \n\
            @param value The value of the attribute\n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n" );
        
        }
        { //::CEGUI::XMLSerializer::closeTag
        
            typedef ::CEGUI::XMLSerializer & ( ::CEGUI::XMLSerializer::*closeTag_function_type )(  ) ;
            
            XMLSerializer_exposer.def( 
                "closeTag"
                , closeTag_function_type( &::CEGUI::XMLSerializer::closeTag )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
             Start a new tag in the xml document.  \n\
            \n\
            @param name The name of the tag \n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n\
            *!\n\
             Close the current tag. \n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n" );
        
        }
        { //::CEGUI::XMLSerializer::getTagCount
        
            typedef unsigned int ( ::CEGUI::XMLSerializer::*getTagCount_function_type )(  ) const;
            
            XMLSerializer_exposer.def( 
                "getTagCount"
                , getTagCount_function_type( &::CEGUI::XMLSerializer::getTagCount )
                , "*! \n\
                     \n\
                    report the nimber of tags created in the document \n\
            \n\
                    @return \n\
                        return the number of tag created in the document \n\
                    *\n" );
        
        }
        { //::CEGUI::XMLSerializer::openTag
        
            typedef ::CEGUI::XMLSerializer & ( ::CEGUI::XMLSerializer::*openTag_function_type )( ::CEGUI::String const & ) ;
            
            XMLSerializer_exposer.def( 
                "openTag"
                , openTag_function_type( &::CEGUI::XMLSerializer::openTag )
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
             Start a new tag in the xml document.  \n\
            \n\
            @param name The name of the tag \n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n" );
        
        }
        XMLSerializer_exposer.def( "__int__", &CEGUI::XMLSerializer::operator bool , "*! \n\
                 \n\
                report the nimber of tags created in the document \n\
        \n\
                @return \n\
                    return the number of tag created in the document \n\
                *\n\
                *!\n\
                 Check wether the XML Serializer status is valid \n\
                \n\
                @return \n\
                    True if all previous operations where successfull \n\
                *\n" );
        XMLSerializer_exposer.def( !bp::self );
        { //::CEGUI::XMLSerializer::text
        
            typedef ::CEGUI::XMLSerializer & ( ::CEGUI::XMLSerializer::*text_function_type )( ::CEGUI::String const & ) ;
            
            XMLSerializer_exposer.def( 
                "text"
                , text_function_type( &::CEGUI::XMLSerializer::text )
                , ( bp::arg("text") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
             After an opening tag you can populate attribute list with this function \n\
            \n\
            @param name The name of the attribute \n\
            \n\
            @param value The value of the attribute\n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n\
            *! \n\
             Create a text node \n\
            \n\
            @param text the content of the node \n\
            \n\
            @return \n\
                A reference to the current object for chaining operation \n\
            *\n" );
        
        }
    }

}
