/***************************************************************************
 *   (C) 2005 Marius Roets <roets.marius@gmail.com>                        *
 *   (C) 2006-2009 Michal Rudolf <mrudolf@kdewebdev.org>                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __RAND64_H__
#define __RAND64_H__

#define MAX_PIECES 12
#define MAX_SQUARES 64
#define MAX_EN_PASSANT_SQUARES 16
const quint64 RAND_VALUES[MAX_PIECES][MAX_SQUARES] =
{
    {
        Q_UINT64_C(0x1ec62f17201666a9),
        Q_UINT64_C(0xbbfacfa8b9cedc99),
        Q_UINT64_C(0xd52582ca4006e48d),
        Q_UINT64_C(0xbe5cc29389b0a011),
        Q_UINT64_C(0x70b7b299fa084b79),
        Q_UINT64_C(0x31fc91d4b888aac6),
        Q_UINT64_C(0x953d8d65f16a27f5),
        Q_UINT64_C(0xa9e1894a083988a6),
        Q_UINT64_C(0x21454de44a9c3b61),
        Q_UINT64_C(0x5f8b1149ed761b1d),
        Q_UINT64_C(0x175d8e3320bc756e),
        Q_UINT64_C(0xdf290612a1c03992),
        Q_UINT64_C(0xe8eb7e4dd25319a8),
        Q_UINT64_C(0xaf4b12ca66fd9c4),
        Q_UINT64_C(0xbc7a46849f1ecb92),
        Q_UINT64_C(0x3176f59e6d590325),
        Q_UINT64_C(0xba1dd7cef5e19864),
        Q_UINT64_C(0x66354050f7debe97),
        Q_UINT64_C(0xa9bf0a169bacd362),
        Q_UINT64_C(0x6fbcab3c9569da6c),
        Q_UINT64_C(0xf776879f9737354a),
        Q_UINT64_C(0x1bb627864a4de101),
        Q_UINT64_C(0x7e0e89ff7ed651a4),
        Q_UINT64_C(0xd60fbbffa2bc218e),
        Q_UINT64_C(0x9fae83ea899cdc65),
        Q_UINT64_C(0xe968a74b29e28a00),
        Q_UINT64_C(0x7441d6653deb9005),
        Q_UINT64_C(0x114e67f4d201286),
        Q_UINT64_C(0xb570a88f1bb4a04f),
        Q_UINT64_C(0x979a9ed22e05d8f5),
        Q_UINT64_C(0x5c07b95482adfa30),
        Q_UINT64_C(0x895a9ebc0f0425f9),
        Q_UINT64_C(0xeb9c39059e157744),
        Q_UINT64_C(0x56eaba15345d2d3f),
        Q_UINT64_C(0xe16e06e1d7ecc810),
        Q_UINT64_C(0x36e6163492b22bd2),
        Q_UINT64_C(0xb16091b81a2e4d3f),
        Q_UINT64_C(0x457ccde451eb1bc7),
        Q_UINT64_C(0x84d57d447975de25),
        Q_UINT64_C(0x9f9e74faa2ad3bd3),
        Q_UINT64_C(0x24c7ae8acd3ad30d),
        Q_UINT64_C(0xa3cbda8eb6cd6d17),
        Q_UINT64_C(0x92d9ee42cbfa4f52),
        Q_UINT64_C(0x438f893e666ffa6b),
        Q_UINT64_C(0x3ccc5d24464f62b1),
        Q_UINT64_C(0xcfa9275812d9e5db),
        Q_UINT64_C(0xbbf17284897c0f48),
        Q_UINT64_C(0xa077f2f8f190127b),
        Q_UINT64_C(0x5fdeec8850464c2b),
        Q_UINT64_C(0x9429d7f4c15885f4),
        Q_UINT64_C(0x4dcac2831e23e842),
        Q_UINT64_C(0x4e109f15c27a18bf),
        Q_UINT64_C(0x8999f31dcc6fe7a9),
        Q_UINT64_C(0x38d5a8a6044dd9ee),
        Q_UINT64_C(0xa744dd883d5c7225),
        Q_UINT64_C(0xeeb12aaf9f92ef25),
        Q_UINT64_C(0xb1b218b1bb67cf61),
        Q_UINT64_C(0xe83e436e7362d9de),
        Q_UINT64_C(0x537512d7cdb2153b),
        Q_UINT64_C(0xd6483b5692e687aa),
        Q_UINT64_C(0x6b0a45a3318c51d5),
        Q_UINT64_C(0x226771aa9189c198),
        Q_UINT64_C(0x53235ce529bfd016),
        Q_UINT64_C(0x5ca80b4f2d5e1eb6)
    } ,
    {
        Q_UINT64_C(0x53245edcd60cf397),
        Q_UINT64_C(0x7f6a708b5e8c84a4),
        Q_UINT64_C(0x325e8b4fb9a1aa4),
        Q_UINT64_C(0x14887c78f2a09203),
        Q_UINT64_C(0xc2bb16d21c0bc8cc),
        Q_UINT64_C(0xe055caaa118766fc),
        Q_UINT64_C(0x359748cb791ec67d),
        Q_UINT64_C(0x3b61d875ea2b7561),
        Q_UINT64_C(0x2a1b6c8960df15e0),
        Q_UINT64_C(0x9bf0d7a44740e32f),
        Q_UINT64_C(0xc22bf6c21eee246f),
        Q_UINT64_C(0xc020519cb401d072),
        Q_UINT64_C(0xf0968c3468e10e2),
        Q_UINT64_C(0xac96e408328061cb),
        Q_UINT64_C(0x7f7777aa95130c9b),
        Q_UINT64_C(0x6ce2af6150e0495a),
        Q_UINT64_C(0xabf54956d8e7b2ae),
        Q_UINT64_C(0x5d61b62788db096f),
        Q_UINT64_C(0x1dd0995e3a3833f6),
        Q_UINT64_C(0x4830b9ec0a52efea),
        Q_UINT64_C(0x4b6deac9ba54aed7),
        Q_UINT64_C(0xd8a5b2d82eb070ef),
        Q_UINT64_C(0xc78f51efd50a99d),
        Q_UINT64_C(0xb2d750e4cc381595),
        Q_UINT64_C(0xcc5a3d6cc8412cf9),
        Q_UINT64_C(0x716449e782e7c15e),
        Q_UINT64_C(0x60971d4c2dd8a2de),
        Q_UINT64_C(0xd181dae3d9e17d00),
        Q_UINT64_C(0xa51553f160a644a),
        Q_UINT64_C(0x33c2e7d569cfe4ff),
        Q_UINT64_C(0xf5463eadaa35d7b1),
        Q_UINT64_C(0x8597d849d5df0697),
        Q_UINT64_C(0x54673596ef45e29f),
        Q_UINT64_C(0x2753a9185702bdec),
        Q_UINT64_C(0x68edde16eb851e87),
        Q_UINT64_C(0xe63abaa5324431d8),
        Q_UINT64_C(0x238e3822a5480bbf),
        Q_UINT64_C(0x569dfbff9e7a3228),
        Q_UINT64_C(0x583d319124ecc023),
        Q_UINT64_C(0x174c93c203e706ca),
        Q_UINT64_C(0x75515b06b221631f),
        Q_UINT64_C(0xa3c0046d21d3937a),
        Q_UINT64_C(0x786176c17d7255e2),
        Q_UINT64_C(0x7fe7b6e3fee8447b),
        Q_UINT64_C(0x36b33d94116aa3d6),
        Q_UINT64_C(0xa540f2adc881ad04),
        Q_UINT64_C(0xc8e77cabc847bb78),
        Q_UINT64_C(0x3bb391ff43276713),
        Q_UINT64_C(0x9195bbff45b7f7e2),
        Q_UINT64_C(0x79019d67f09cbcc8),
        Q_UINT64_C(0xa8f17ad8e5ff080e),
        Q_UINT64_C(0x345b6fbbb3a98cd3),
        Q_UINT64_C(0x280ec7eb3f29a129),
        Q_UINT64_C(0x8cf0d5580efabe5e),
        Q_UINT64_C(0xd74514789ff96be4),
        Q_UINT64_C(0xaf51af61e09dcf72),
        Q_UINT64_C(0x2d886dba5494feb9),
        Q_UINT64_C(0x47847fb8831e9742),
        Q_UINT64_C(0x9c4645caf979f848),
        Q_UINT64_C(0xbdcb1b461cbac0bb),
        Q_UINT64_C(0xe0f76bfdabb9f044),
        Q_UINT64_C(0x452df2be09d5455a),
        Q_UINT64_C(0x6360e134cb41175a),
        Q_UINT64_C(0xedf28a4ba7818d3b)
    } ,
    {
        Q_UINT64_C(0xcadac8d042c2659d),
        Q_UINT64_C(0x454389d89b0bf801),
        Q_UINT64_C(0xec352b4584ab0ba2),
        Q_UINT64_C(0x7d109cb245e59d87),
        Q_UINT64_C(0x68a74d8f67ac0998),
        Q_UINT64_C(0x2da1d772e2672337),
        Q_UINT64_C(0x95c65d9f325a81a9),
        Q_UINT64_C(0x35c69e246ea2a2a),
        Q_UINT64_C(0x7b2584588863292a),
        Q_UINT64_C(0x3e7d05d5e89afde4),
        Q_UINT64_C(0x58171422cfdfec83),
        Q_UINT64_C(0xd9a2075d95f868da),
        Q_UINT64_C(0x1da8afd77bdee29b),
        Q_UINT64_C(0x8d25e865fa5d1f41),
        Q_UINT64_C(0x5cad8f0581b90560),
        Q_UINT64_C(0xb8723d6f3e47b827),
        Q_UINT64_C(0xe1e4abe6712a85f9),
        Q_UINT64_C(0x8f0c5a1f19477a43),
        Q_UINT64_C(0x9407dd91b7023406),
        Q_UINT64_C(0x570a67babc5dffa8),
        Q_UINT64_C(0x965a6a2c6308a099),
        Q_UINT64_C(0x7e873487004f9484),
        Q_UINT64_C(0xac9ef8359380d43a),
        Q_UINT64_C(0xaff31969a6d0e11f),
        Q_UINT64_C(0xe4b3607a61f4ebf2),
        Q_UINT64_C(0xd30d436ce815daa6),
        Q_UINT64_C(0xf2ec127dd9b24bc0),
        Q_UINT64_C(0x29d24cc261e39f76),
        Q_UINT64_C(0xfdf4d684c0def5a4),
        Q_UINT64_C(0x3a91401a9f01288d),
        Q_UINT64_C(0x3d8f6a35d8bc4aaf),
        Q_UINT64_C(0x125dd19b7b757b2c),
        Q_UINT64_C(0xbe494ce02ed6499d),
        Q_UINT64_C(0x1880774dacc00e63),
        Q_UINT64_C(0x440f9561070c655),
        Q_UINT64_C(0xac5d0be114b6a229),
        Q_UINT64_C(0xdb3375c59bf08566),
        Q_UINT64_C(0xa10ced9c93388160),
        Q_UINT64_C(0x54a4dad59cc2c007),
        Q_UINT64_C(0x559408bc146bbebd),
        Q_UINT64_C(0xb8bad0664b209c79),
        Q_UINT64_C(0xbf586f0e24fefe87),
        Q_UINT64_C(0xec6d94b7a39286d1),
        Q_UINT64_C(0xed7c1459a5dc2519),
        Q_UINT64_C(0x4978282330d42273),
        Q_UINT64_C(0xff3fd26a98417ca),
        Q_UINT64_C(0xf26c9f7ae2b230b5),
        Q_UINT64_C(0x8c94dbd31f38dfbf),
        Q_UINT64_C(0xd5a3e7288ebf4c96),
        Q_UINT64_C(0x6e3944a9cd85a4c5),
        Q_UINT64_C(0xba9c4bc7e7b5c9d9),
        Q_UINT64_C(0x33e8ebb8ab9dca03),
        Q_UINT64_C(0xaa2c2de0783569d0),
        Q_UINT64_C(0x2b85abd021bf9d89),
        Q_UINT64_C(0xa439c8d9600cd247),
        Q_UINT64_C(0x622af17e71ccf035),
        Q_UINT64_C(0x2d5461656222a132),
        Q_UINT64_C(0x757de25d90c312b2),
        Q_UINT64_C(0x5bf4142296887e24),
        Q_UINT64_C(0x1f57f40b682dfae4),
        Q_UINT64_C(0x5900905f7327b2fa),
        Q_UINT64_C(0x55d3cee7500a070a),
        Q_UINT64_C(0x28431e31c56377f6),
        Q_UINT64_C(0xf2bac6ac56be5bd0)
    } ,
    {
        Q_UINT64_C(0xdf46c89083b67e29),
        Q_UINT64_C(0xa79e77d5e82473b),
        Q_UINT64_C(0x1acf90d006f2a77f),
        Q_UINT64_C(0x161a43fe951ed4e),
        Q_UINT64_C(0x684fe4624c50d017),
        Q_UINT64_C(0x9d56130f929b7b28),
        Q_UINT64_C(0x5612e8d14194e557),
        Q_UINT64_C(0x8317bf19e7c0ec61),
        Q_UINT64_C(0x4bed0c56e8ae7c16),
        Q_UINT64_C(0x6524d908ba6fd75a),
        Q_UINT64_C(0xef1a4afc64d2dec2),
        Q_UINT64_C(0xcc91a06a6aed0e5b),
        Q_UINT64_C(0xe8caf25e2e3131f),
        Q_UINT64_C(0xc682ff6ccc7fbce9),
        Q_UINT64_C(0xb90a317118687ab2),
        Q_UINT64_C(0x483fdd9d5943b01b),
        Q_UINT64_C(0xd9ab9bfdcab982e4),
        Q_UINT64_C(0x8c36670af77644c3),
        Q_UINT64_C(0xbeec4e0f0681b526),
        Q_UINT64_C(0xeba28e747d18b8f0),
        Q_UINT64_C(0x2e101a99326fea47),
        Q_UINT64_C(0xddda32425f702ea0),
        Q_UINT64_C(0xc0b14cad105e3672),
        Q_UINT64_C(0x359cd242522f1563),
        Q_UINT64_C(0xd6affd6dc37876be),
        Q_UINT64_C(0x35bda8df5ead1224),
        Q_UINT64_C(0xc20e838ad96bba45),
        Q_UINT64_C(0x92291e135d8e98f1),
        Q_UINT64_C(0xd4d628339ae65ffc),
        Q_UINT64_C(0xfeccbee630743e10),
        Q_UINT64_C(0x58e92ff7f6be6df2),
        Q_UINT64_C(0x1e57637797590664),
        Q_UINT64_C(0x7203145c2f63a685),
        Q_UINT64_C(0x8fec2a2b0bead59d),
        Q_UINT64_C(0xdd56487be5b8c600),
        Q_UINT64_C(0x8b11513f987dc92c),
        Q_UINT64_C(0x1594970f9cab8f30),
        Q_UINT64_C(0x1bb5f0ea58bfeff2),
        Q_UINT64_C(0x42ff96fc97d2ebd4),
        Q_UINT64_C(0x7cb5664988b73c3f),
        Q_UINT64_C(0xf27eb6647cd62c13),
        Q_UINT64_C(0x30a27ac7b6107567),
        Q_UINT64_C(0xeaf3b797f5e00eba),
        Q_UINT64_C(0xd35e513359631e1f),
        Q_UINT64_C(0xc9f7f89c795c345c),
        Q_UINT64_C(0xf400f0cb9df71b18),
        Q_UINT64_C(0xc82d0a7de2b8c037),
        Q_UINT64_C(0xf79bf08329ee7b74),
        Q_UINT64_C(0xcf53f738e1b27b1f),
        Q_UINT64_C(0x949207eb00202221),
        Q_UINT64_C(0xb0aac2d90efef7a7),
        Q_UINT64_C(0x67144a43ef08d0ab),
        Q_UINT64_C(0xb58a58edfc076d67),
        Q_UINT64_C(0xc18306361a8ae880),
        Q_UINT64_C(0x900136708271a8d7),
        Q_UINT64_C(0x4c62781522d048eb),
        Q_UINT64_C(0x62f096438e887dee),
        Q_UINT64_C(0xf35dd72cab848b30),
        Q_UINT64_C(0x94e3a6cdb64a1d46),
        Q_UINT64_C(0x38a2d0bfa0bbcb49),
        Q_UINT64_C(0x1e2e21c184b7a78d),
        Q_UINT64_C(0xcaabdc94b883b7c4),
        Q_UINT64_C(0xe730d8e63586e008),
        Q_UINT64_C(0x9b46fc7effbf9fac)
    } ,
    {
        Q_UINT64_C(0xf3c9da6687146357),
        Q_UINT64_C(0xbc0fc65dbeb389bc),
        Q_UINT64_C(0x9be6bbd61f09bf49),
        Q_UINT64_C(0x2140339ed7c11b99),
        Q_UINT64_C(0x6fc48df6290562cd),
        Q_UINT64_C(0x380b4bff46db1f22),
        Q_UINT64_C(0x1ada26b72231ccb5),
        Q_UINT64_C(0x705a1f7bdedaa01e),
        Q_UINT64_C(0xa2d620ab9407e5d0),
        Q_UINT64_C(0x67ab1673e4980aea),
        Q_UINT64_C(0xafc2252962d550a4),
        Q_UINT64_C(0xf3dfaf76b775c562),
        Q_UINT64_C(0x5ccbef3d0397c662),
        Q_UINT64_C(0x1b3b57a62eeae95),
        Q_UINT64_C(0xaec1518190e067c5),
        Q_UINT64_C(0x37488a3d36314db2),
        Q_UINT64_C(0x961eff8f15d8504a),
        Q_UINT64_C(0x64ff8e2e721a603c),
        Q_UINT64_C(0x681143138be3ec55),
        Q_UINT64_C(0x5ecbdb18d4c08510),
        Q_UINT64_C(0xd2c8dd0b141f60b8),
        Q_UINT64_C(0x90906cc9ba81725f),
        Q_UINT64_C(0x6e6ceecf99b39cda),
        Q_UINT64_C(0x3833b12c83573c84),
        Q_UINT64_C(0x77d6cce0c53d35c6),
        Q_UINT64_C(0xeaec84bd94c7a906),
        Q_UINT64_C(0x4e438c6201dfe450),
        Q_UINT64_C(0xe01676f81ef373d3),
        Q_UINT64_C(0x90b2023a3ee105ae),
        Q_UINT64_C(0x6d8598e2dc2a22cb),
        Q_UINT64_C(0x7aec68a3a3616522),
        Q_UINT64_C(0xd2751bc8535dcec1),
        Q_UINT64_C(0x5220c84bb8c51285),
        Q_UINT64_C(0x57810a9091810fbd),
        Q_UINT64_C(0x71a46e32f4e57778),
        Q_UINT64_C(0x4b44d5b5d146bfc),
        Q_UINT64_C(0x2943475171c4730c),
        Q_UINT64_C(0x422be94e746cea55),
        Q_UINT64_C(0x2696be9f46720f2f),
        Q_UINT64_C(0x34588bcf5b61c2bc),
        Q_UINT64_C(0xdcd4a8018a685369),
        Q_UINT64_C(0x59e93e1485a41634),
        Q_UINT64_C(0xc31571199e9eb91b),
        Q_UINT64_C(0x4ffe620332c7095b),
        Q_UINT64_C(0x4bac0fa0a2cf284d),
        Q_UINT64_C(0x1c035a2a33cefe8f),
        Q_UINT64_C(0xd6ae8360e511267),
        Q_UINT64_C(0xc9cc8849a2a35773),
        Q_UINT64_C(0xc880c44800e4b171),
        Q_UINT64_C(0x4657625b07c46cba),
        Q_UINT64_C(0x9e9cae5ad99cf4bd),
        Q_UINT64_C(0xbcda94886adc4193),
        Q_UINT64_C(0x969c91aed057979e),
        Q_UINT64_C(0x45f618b5564b7b33),
        Q_UINT64_C(0x8e7c8c99777ef253),
        Q_UINT64_C(0x8e9e9771832e577d),
        Q_UINT64_C(0x91dde22a9480b4bd),
        Q_UINT64_C(0x70ddf3148befa451),
        Q_UINT64_C(0x10b84400fa414520),
        Q_UINT64_C(0xbc5a066b606baf65),
        Q_UINT64_C(0x514dd10b07527017),
        Q_UINT64_C(0xcbab54a0ff2c2a98),
        Q_UINT64_C(0xfd7421297472cf1b),
        Q_UINT64_C(0x59f1839342ef0fb7)
    } ,
    {
        Q_UINT64_C(0xc75866298a6e4bac),
        Q_UINT64_C(0xc8ee38b2898619e0),
        Q_UINT64_C(0x7f979c89244eb074),
        Q_UINT64_C(0x6dfe79552a503ae7),
        Q_UINT64_C(0x84e2657e2ef4ea59),
        Q_UINT64_C(0x5212c47457504706),
        Q_UINT64_C(0xc2d6c23f1ff0fbd8),
        Q_UINT64_C(0xead331b5f2fbe7cc),
        Q_UINT64_C(0x196b78ae8fab6cec),
        Q_UINT64_C(0x82e9b89e64e183d4),
        Q_UINT64_C(0xedf8a811a8525983),
        Q_UINT64_C(0x81401e0a707f4a2a),
        Q_UINT64_C(0xe97db9ef64670a17),
        Q_UINT64_C(0xdca4e599aa2b2046),
        Q_UINT64_C(0x55997b5728384a93),
        Q_UINT64_C(0xefea3f38b47dc02),
        Q_UINT64_C(0xf7715d0117066b50),
        Q_UINT64_C(0x202f640d407c7784),
        Q_UINT64_C(0x41fc2d1db8d2c58a),
        Q_UINT64_C(0xf1aea04995261294),
        Q_UINT64_C(0x1b97ca9b94818e5c),
        Q_UINT64_C(0x1a604d81c6832882),
        Q_UINT64_C(0x29de3de90ec4b09c),
        Q_UINT64_C(0x833b362a95d350cc),
        Q_UINT64_C(0x92bb628c33d0c1a6),
        Q_UINT64_C(0x17b218339404dff9),
        Q_UINT64_C(0x8ecc53ee80c128fd),
        Q_UINT64_C(0xde322a7a6d6d0b7f),
        Q_UINT64_C(0x9a1bf2c58b17b96d),
        Q_UINT64_C(0x46841b0080569274),
        Q_UINT64_C(0x175635b631158926),
        Q_UINT64_C(0x97e00b81c49f16a7),
        Q_UINT64_C(0xb0b7c04c7b91bbf),
        Q_UINT64_C(0x7b6f44fe486244c),
        Q_UINT64_C(0x6e3abe3d9168fa01),
        Q_UINT64_C(0xb8e6064f060e9848),
        Q_UINT64_C(0x9a7407276634a98f),
        Q_UINT64_C(0x8dddb9a33d0af4c),
        Q_UINT64_C(0xf48074674a428565),
        Q_UINT64_C(0x4c42426a115ca77c),
        Q_UINT64_C(0x2e476b77c7666bad),
        Q_UINT64_C(0x3ff12da796160fa8),
        Q_UINT64_C(0xb6b1986a2ecba623),
        Q_UINT64_C(0x1e5bf26bac6a2cc8),
        Q_UINT64_C(0xe854e404456189d7),
        Q_UINT64_C(0xa6bc5714b0e06a85),
        Q_UINT64_C(0xd94634b1c5575759),
        Q_UINT64_C(0x22edb1d386f7a76b),
        Q_UINT64_C(0x5425da975aa39f5),
        Q_UINT64_C(0x6ad785b5f1cb9ba3),
        Q_UINT64_C(0x92f67a06e954aa6c),
        Q_UINT64_C(0x808537a95a748260),
        Q_UINT64_C(0x6cf997acd7762b1c),
        Q_UINT64_C(0x61bb904dbec76cc7),
        Q_UINT64_C(0xd3646f8af70ef000),
        Q_UINT64_C(0xdcff1f6ef367b6ea),
        Q_UINT64_C(0xf66e9417cc7b0cae),
        Q_UINT64_C(0x8399ddcbbcc6a55c),
        Q_UINT64_C(0xb3f777be95923c1c),
        Q_UINT64_C(0x6386d01553c46e6d),
        Q_UINT64_C(0x1d342f505e226825),
        Q_UINT64_C(0x8c484323c0c0c008),
        Q_UINT64_C(0x7a7acbc76ac93bdc),
        Q_UINT64_C(0x5c61d0590ea1a132)
    } ,
    {
        Q_UINT64_C(0x2f64bef8708ccc76),
        Q_UINT64_C(0x8f69cb123b86b473),
        Q_UINT64_C(0x14629d43439b0b9a),
        Q_UINT64_C(0xb51615b61addd932),
        Q_UINT64_C(0x56083fb3f25972d2),
        Q_UINT64_C(0x5824911f1514af24),
        Q_UINT64_C(0xcc31f9a300cd86fb),
        Q_UINT64_C(0x106f10489953b0f0),
        Q_UINT64_C(0x4e0da08ed53e3f42),
        Q_UINT64_C(0x861454c96e778a89),
        Q_UINT64_C(0x85fa8e9cb37aebe4),
        Q_UINT64_C(0x185f7b31ecc2b80f),
        Q_UINT64_C(0x77b4840c225dba24),
        Q_UINT64_C(0x21f3044fd95b9644),
        Q_UINT64_C(0xb10b52c194b80c12),
        Q_UINT64_C(0xd3511042b3dc6e17),
        Q_UINT64_C(0x127c6a623e7a8096),
        Q_UINT64_C(0xac40b42d23979b50),
        Q_UINT64_C(0x24eaf6e4d79f81dd),
        Q_UINT64_C(0xc188cff8736251b9),
        Q_UINT64_C(0x12392eb101fe558e),
        Q_UINT64_C(0x2e402c80d947c34),
        Q_UINT64_C(0x8b9d039619325a97),
        Q_UINT64_C(0x5d9b0636b0704c83),
        Q_UINT64_C(0x8a94b7d08b8d601d),
        Q_UINT64_C(0x5733a1895681c0aa),
        Q_UINT64_C(0xdd5a40d653d15e74),
        Q_UINT64_C(0xbb054e3cf7ccbacd),
        Q_UINT64_C(0x6e4b27ff19f158fb),
        Q_UINT64_C(0x41e3901659df0572),
        Q_UINT64_C(0xf6e26bfacb2b1d27),
        Q_UINT64_C(0x4fefc0f2472ecd13),
        Q_UINT64_C(0x3e27d9ba892b921e),
        Q_UINT64_C(0x948f060bc89c832a),
        Q_UINT64_C(0x8baa3f0efc1c2af2),
        Q_UINT64_C(0x2381a923ba396109),
        Q_UINT64_C(0xd3b06958774253f0),
        Q_UINT64_C(0xb445b670f7c832e),
        Q_UINT64_C(0xa2be518eb068da7c),
        Q_UINT64_C(0x3bbb38d5b2cdd554),
        Q_UINT64_C(0x1da3d990a138c7b6),
        Q_UINT64_C(0xc8e233f9accae801),
        Q_UINT64_C(0xa05e74f15d3eeef5),
        Q_UINT64_C(0xfea7f74d1c9bcaff),
        Q_UINT64_C(0xae0b4bfcf6a32afa),
        Q_UINT64_C(0x6be0332e6af8a0cf),
        Q_UINT64_C(0x943177446ddd6775),
        Q_UINT64_C(0xba0da641f019b36e),
        Q_UINT64_C(0x384025f9ab18fbba),
        Q_UINT64_C(0x1939888bb6674ce0),
        Q_UINT64_C(0x59e11e6d2f07fa4b),
        Q_UINT64_C(0xa596f492bd8f9bca),
        Q_UINT64_C(0xe939068dd320fec1),
        Q_UINT64_C(0xdcc4c3618c975c),
        Q_UINT64_C(0x486fcb60f496caa),
        Q_UINT64_C(0xcd6e638cc3106b1a),
        Q_UINT64_C(0x28b8c5a56fc98845),
        Q_UINT64_C(0x349ddc52f07e66d6),
        Q_UINT64_C(0xdc5b17f35598ab96),
        Q_UINT64_C(0x536c255baf56d4ec),
        Q_UINT64_C(0x7d58b9aa06d26aa3),
        Q_UINT64_C(0xc479e0c6ddbc2a4e),
        Q_UINT64_C(0x668cbed0f5dcbea),
        Q_UINT64_C(0x751054ba6613a289)
    } ,
    {
        Q_UINT64_C(0x3c7280b077d6d7a),
        Q_UINT64_C(0xe12382c91253cda1),
        Q_UINT64_C(0xbefda033140e3cb7),
        Q_UINT64_C(0x1b6f806491b094b5),
        Q_UINT64_C(0x1e98babfcc965316),
        Q_UINT64_C(0x57d2ade56704a531),
        Q_UINT64_C(0xd54fc0a170ffd7aa),
        Q_UINT64_C(0x354ead717998c00d),
        Q_UINT64_C(0xeae96f6e4b1508c1),
        Q_UINT64_C(0x7c0dc22bf8632b40),
        Q_UINT64_C(0x83bc6818b369f89a),
        Q_UINT64_C(0x4efc4febd26e4b42),
        Q_UINT64_C(0xf8ceefc9feb1874f),
        Q_UINT64_C(0xf845bec6c1ccf8a0),
        Q_UINT64_C(0x3e2b5a324714c3bb),
        Q_UINT64_C(0x1d9eab2892b42859),
        Q_UINT64_C(0xb25280c92f83b2a2),
        Q_UINT64_C(0xeff78ea70b1c5e36),
        Q_UINT64_C(0x6d4de2bb930efe72),
        Q_UINT64_C(0x64b95da4f88ca989),
        Q_UINT64_C(0xfac373fc552add76),
        Q_UINT64_C(0x3c841f46705e8b18),
        Q_UINT64_C(0xc32fb541343401f9),
        Q_UINT64_C(0xf2c11cce7a469839),
        Q_UINT64_C(0xb817729006c14c65),
        Q_UINT64_C(0x1071ec724569f6af),
        Q_UINT64_C(0x621edfa9de9439e7),
        Q_UINT64_C(0x1a22c4d5150f2baa),
        Q_UINT64_C(0x75cca15a55258a3d),
        Q_UINT64_C(0x24f570d7d46087f1),
        Q_UINT64_C(0x73a8a9518592ea87),
        Q_UINT64_C(0x925f5b9e52691f97),
        Q_UINT64_C(0xb9b2c60211b8ee24),
        Q_UINT64_C(0x4308bc03f750dbc6),
        Q_UINT64_C(0xfc913f36d178361f),
        Q_UINT64_C(0x63322686eb9ad5fa),
        Q_UINT64_C(0x58a258ad8bfe49ce),
        Q_UINT64_C(0x6e58e93d4969b576),
        Q_UINT64_C(0x4cfdeb892f7103d9),
        Q_UINT64_C(0xe6d396b7019b60fa),
        Q_UINT64_C(0x891d9d8a680b0fe9),
        Q_UINT64_C(0x3af29f54df3c8952),
        Q_UINT64_C(0x4e4ab77a442734fe),
        Q_UINT64_C(0x6e9ee2c78557d228),
        Q_UINT64_C(0x39205e41d0b4f1bd),
        Q_UINT64_C(0x2d7afbfd5b402083),
        Q_UINT64_C(0xefaaa35cfcb13cd3),
        Q_UINT64_C(0xd5eb1dcb6c10d071),
        Q_UINT64_C(0xec6670a35fef81f5),
        Q_UINT64_C(0xec28f44e30a9996c),
        Q_UINT64_C(0x20f1adb9f2960c1e),
        Q_UINT64_C(0x6d0d8e411f5845a6),
        Q_UINT64_C(0xa15d0c9740e3a337),
        Q_UINT64_C(0x7e2d2c54bff916f2),
        Q_UINT64_C(0x2af10716e9691641),
        Q_UINT64_C(0x1dadd22c12ff5b22),
        Q_UINT64_C(0x6ba5819a9948d2c1),
        Q_UINT64_C(0x415fc03a15510c4d),
        Q_UINT64_C(0x40a4b22bdc58b560),
        Q_UINT64_C(0x6b94dc456fc3dca1),
        Q_UINT64_C(0xbc04ae725dca44cd),
        Q_UINT64_C(0x851229741d509353),
        Q_UINT64_C(0xdfa93ba511ed67a5),
        Q_UINT64_C(0x9930157fc5022cce)
    } ,
    {
        Q_UINT64_C(0xa14f64e7e2a08adf),
        Q_UINT64_C(0x6b642680b3befe04),
        Q_UINT64_C(0xa5cec9da49db1e5b),
        Q_UINT64_C(0xc8a4791b8796b72b),
        Q_UINT64_C(0x96dcda1732dac346),
        Q_UINT64_C(0xdd6a468b90154135),
        Q_UINT64_C(0xc92cf06b2f7cec8b),
        Q_UINT64_C(0x49fdd61b76fb21c1),
        Q_UINT64_C(0x952d68a7d37cbdd1),
        Q_UINT64_C(0x1d02dca5ecce6696),
        Q_UINT64_C(0x7947464767cc4eb1),
        Q_UINT64_C(0xbc5690e29707fd78),
        Q_UINT64_C(0x1b77de938eb37a92),
        Q_UINT64_C(0x82a0316874d3f3b4),
        Q_UINT64_C(0x438b0002bc65e99),
        Q_UINT64_C(0xf7165ab04168fe6d),
        Q_UINT64_C(0x333d75259eefcd14),
        Q_UINT64_C(0x8906c3ac02d0bea4),
        Q_UINT64_C(0xffd91e4fe65f12e9),
        Q_UINT64_C(0xc14b1bf2982e4aed),
        Q_UINT64_C(0x35d83daf48cfe68f),
        Q_UINT64_C(0x9ec31949cd275677),
        Q_UINT64_C(0x2c3ee7e34b57d352),
        Q_UINT64_C(0x94660b0b00324807),
        Q_UINT64_C(0x3f7e45098859afce),
        Q_UINT64_C(0x69a26300773711d6),
        Q_UINT64_C(0xfcf669991e52df6b),
        Q_UINT64_C(0xe9fe0aec1acf55b5),
        Q_UINT64_C(0x6a22ade2d0520453),
        Q_UINT64_C(0x79b4957bf7ad0aaa),
        Q_UINT64_C(0x10bd4cdb980db736),
        Q_UINT64_C(0xf851ceac6b23657f),
        Q_UINT64_C(0xad9451efea678535),
        Q_UINT64_C(0x5646fc2f7a3ccca8),
        Q_UINT64_C(0x12501485c46afe0b),
        Q_UINT64_C(0xe44bf524b8fe2551),
        Q_UINT64_C(0xc7b072886b0fd978),
        Q_UINT64_C(0x2c29835d87188eeb),
        Q_UINT64_C(0xebd902fb34841eca),
        Q_UINT64_C(0xbc8da25aafd4c949),
        Q_UINT64_C(0xe8e2f478103c805c),
        Q_UINT64_C(0xf4bfa9cbd7ed9c07),
        Q_UINT64_C(0xac7f6a4adad8b297),
        Q_UINT64_C(0xbd209ad1b5f145ba),
        Q_UINT64_C(0x4f9d4c0a69871173),
        Q_UINT64_C(0xf6e28f3f8b89aebc),
        Q_UINT64_C(0x4b13bc67fe616132),
        Q_UINT64_C(0xcfe6c79ca07bb7bc),
        Q_UINT64_C(0x80a3f66f2c6a0eff),
        Q_UINT64_C(0xe3afb253772a75fc),
        Q_UINT64_C(0xf40c5da6637f1c4d),
        Q_UINT64_C(0x29002c86cc15c154),
        Q_UINT64_C(0x4dfe86a1b23ee0d9),
        Q_UINT64_C(0x65622cdf439dec74),
        Q_UINT64_C(0x30fda6a5933ffba0),
        Q_UINT64_C(0x960092fd4722f32b),
        Q_UINT64_C(0x4ab30ab6a72584cb),
        Q_UINT64_C(0xc74a9ae8575cdeeb),
        Q_UINT64_C(0x2e04317419a09c84),
        Q_UINT64_C(0x49c487bc3b339189),
        Q_UINT64_C(0xf1e89841c5586c04),
        Q_UINT64_C(0x618a5d4557a060db),
        Q_UINT64_C(0x67b1f2b29381993c),
        Q_UINT64_C(0xdac343bda84599fd)
    } ,
    {
        Q_UINT64_C(0xebff8b8df3c83a0a),
        Q_UINT64_C(0xf9942b8463438981),
        Q_UINT64_C(0x6c2f8a36722bbac5),
        Q_UINT64_C(0xa7cae83f1120ef53),
        Q_UINT64_C(0x6be91f12cdd0ca04),
        Q_UINT64_C(0xc441e4b94cecfb40),
        Q_UINT64_C(0xcadae4afd1198c20),
        Q_UINT64_C(0x47d6c333e59f0d9b),
        Q_UINT64_C(0x1c7fe4e60648c3bd),
        Q_UINT64_C(0xf61d326de86eab61),
        Q_UINT64_C(0x71ea832569a032f7),
        Q_UINT64_C(0x27b805c6b65ae940),
        Q_UINT64_C(0x4ab0f7d8436b08dc),
        Q_UINT64_C(0xd7709084e3c83ba6),
        Q_UINT64_C(0xeda91d50da13848d),
        Q_UINT64_C(0x8540270732c408e0),
        Q_UINT64_C(0x35efdcdef2789841),
        Q_UINT64_C(0xf937151d7d7be252),
        Q_UINT64_C(0xe95c415b888c8aec),
        Q_UINT64_C(0x171a6366a0e1271b),
        Q_UINT64_C(0x9149c05e04f7036c),
        Q_UINT64_C(0x414f8230851b4649),
        Q_UINT64_C(0xfb51808713dc84ba),
        Q_UINT64_C(0xf933e08fb5dfaebc),
        Q_UINT64_C(0x28254a305cc7753f),
        Q_UINT64_C(0x6e9300d69c44cb1b),
        Q_UINT64_C(0x1fed087462b8e3c9),
        Q_UINT64_C(0x311931c6cc9d371f),
        Q_UINT64_C(0xab3c7d461118dc9),
        Q_UINT64_C(0x9f67ffd0d3815586),
        Q_UINT64_C(0x8586a78a5a5d0daa),
        Q_UINT64_C(0xc35e56c16ad732e8),
        Q_UINT64_C(0x5dec4f660f327eb4),
        Q_UINT64_C(0xbeca79c300886406),
        Q_UINT64_C(0xaad304bb2ea3f914),
        Q_UINT64_C(0x4f6aec0ed980ff6f),
        Q_UINT64_C(0x1ddf22d9fbb4a2f0),
        Q_UINT64_C(0xa5faf84525bab3e),
        Q_UINT64_C(0xb2f339ac1074ead),
        Q_UINT64_C(0xceeb55e80a6a92c2),
        Q_UINT64_C(0x8a439d961671da6f),
        Q_UINT64_C(0x66467b94b6de5d2f),
        Q_UINT64_C(0x21505ba132d4907d),
        Q_UINT64_C(0x34c443b890fac25f),
        Q_UINT64_C(0x48c89fd2e655cdf9),
        Q_UINT64_C(0x15897d714819c7e6),
        Q_UINT64_C(0xf7a8f3d223780746),
        Q_UINT64_C(0x6778549c3bbb486b),
        Q_UINT64_C(0x889aeb3bf2632b9a),
        Q_UINT64_C(0xcb8fb06abda385ff),
        Q_UINT64_C(0x502d1ab72f606c48),
        Q_UINT64_C(0x29b34ae2ff2c21a9),
        Q_UINT64_C(0x5f6942a552a43ba1),
        Q_UINT64_C(0xd9b44265023be3d7),
        Q_UINT64_C(0x29081045ed355455),
        Q_UINT64_C(0x2f915936359af5a0),
        Q_UINT64_C(0x6c3889068abe571c),
        Q_UINT64_C(0x97b66c46539aa106),
        Q_UINT64_C(0xec346e6de2e3f311),
        Q_UINT64_C(0x6aadba9193ad40f6),
        Q_UINT64_C(0xd835cf0ef3a71198),
        Q_UINT64_C(0x10e62386c249b3fc),
        Q_UINT64_C(0x1cd290d68761f8e2),
        Q_UINT64_C(0xb8337434d4e694e1)
    } ,
    {
        Q_UINT64_C(0xbd77a59f1d361ebb),
        Q_UINT64_C(0x3fd63cdae63a60cf),
        Q_UINT64_C(0xabbde3878f5d3ddc),
        Q_UINT64_C(0x7bd30af727464ee0),
        Q_UINT64_C(0xc54b2e6fd776f8ec),
        Q_UINT64_C(0x87536cc23efddac8),
        Q_UINT64_C(0xa673f8fea0989c7a),
        Q_UINT64_C(0x7079efe6a0393e1),
        Q_UINT64_C(0xd59ef63e8c0a3f87),
        Q_UINT64_C(0x275f3761c2b39d86),
        Q_UINT64_C(0xabb109a58d81d722),
        Q_UINT64_C(0x6fa8223d3df3b5a3),
        Q_UINT64_C(0xc21d3f51d871af26),
        Q_UINT64_C(0x9d5c9fc29803819),
        Q_UINT64_C(0x866d72e99c8219c0),
        Q_UINT64_C(0xf903690329ec9854),
        Q_UINT64_C(0x463c5862fd725e53),
        Q_UINT64_C(0xfaa2e3b9009c23ff),
        Q_UINT64_C(0x51ed3fa38b3e32e1),
        Q_UINT64_C(0x3fdd054ae621b7a9),
        Q_UINT64_C(0x63422f3c0fcdb872),
        Q_UINT64_C(0xdb599cddb7ba5bb7),
        Q_UINT64_C(0x29d821145131732f),
        Q_UINT64_C(0xa768e7bd756f318c),
        Q_UINT64_C(0x6c499d80db10e3f2),
        Q_UINT64_C(0x1ccb5e0f3dfd948e),
        Q_UINT64_C(0xe59cdfdfde9ae15f),
        Q_UINT64_C(0x9d490cddfef6d223),
        Q_UINT64_C(0xb8985e20b3c308b5),
        Q_UINT64_C(0xca4145a21a50a82a),
        Q_UINT64_C(0xefa50915dbc7e668),
        Q_UINT64_C(0x66c706d2ddde9849),
        Q_UINT64_C(0x9ce9a5932d0364d2),
        Q_UINT64_C(0x9686b7e5e8901ff7),
        Q_UINT64_C(0xa9a42437501eaad7),
        Q_UINT64_C(0x20679ed4ada474e1),
        Q_UINT64_C(0x367a3bbc6c11bba2),
        Q_UINT64_C(0xe4cfc9c30e06a14d),
        Q_UINT64_C(0xc589b195c383ecfd),
        Q_UINT64_C(0x841ce907bbb6a61c),
        Q_UINT64_C(0x3d731ef371ea6132),
        Q_UINT64_C(0xab7a347deeedc48a),
        Q_UINT64_C(0xa5ba154bec151ef8),
        Q_UINT64_C(0x17726f865e2ee581),
        Q_UINT64_C(0xdbca0e729ac306f2),
        Q_UINT64_C(0xf7ee9f7dbf54f4d7),
        Q_UINT64_C(0x6c10670c9169452e),
        Q_UINT64_C(0x5a49ee9a2bc1486f),
        Q_UINT64_C(0x23630d9bff542959),
        Q_UINT64_C(0xdcb2d15124939ab9),
        Q_UINT64_C(0xa5de1bef76950515),
        Q_UINT64_C(0x730f408f5dc85968),
        Q_UINT64_C(0xd8c24e6721021521),
        Q_UINT64_C(0xe61242e7661ab160),
        Q_UINT64_C(0xceb3901956105e41),
        Q_UINT64_C(0x9a56e7a2a9b7040),
        Q_UINT64_C(0x6dddfaced358af91),
        Q_UINT64_C(0x6d597db8d1caf88d),
        Q_UINT64_C(0x7dfa62e1b1760d84),
        Q_UINT64_C(0x8e19fa60dfeb1bf),
        Q_UINT64_C(0xa34875d78b045e7e),
        Q_UINT64_C(0xa294952e7727e87),
        Q_UINT64_C(0xac7d17ef5e7b791a),
        Q_UINT64_C(0x51d95a618d846d91)
    } ,
    {
        Q_UINT64_C(0xc58896c783248e00),
        Q_UINT64_C(0xb28c400d0e64ade8),
        Q_UINT64_C(0xc41ecb9b99a69765),
        Q_UINT64_C(0xa1bcd8aae00885c1),
        Q_UINT64_C(0xd66f8316f2155659),
        Q_UINT64_C(0x8eeb7bcc71816ad0),
        Q_UINT64_C(0xc0fd3c6163d7ca66),
        Q_UINT64_C(0x3483cad9e03c498e),
        Q_UINT64_C(0x797e845514e40aec),
        Q_UINT64_C(0x9213f80bf739746d),
        Q_UINT64_C(0x6effa9a6b1ea0966),
        Q_UINT64_C(0xecf7c1c9d0e33dba),
        Q_UINT64_C(0x244b3a0a6a1914d3),
        Q_UINT64_C(0x6ff19fb917323431),
        Q_UINT64_C(0x1fed9c34d7fa3bfe),
        Q_UINT64_C(0xc374c9f28e32936a),
        Q_UINT64_C(0x82e29126f964e26e),
        Q_UINT64_C(0x5e19b04bcae033ab),
        Q_UINT64_C(0x8e843603dbe6f7c4),
        Q_UINT64_C(0xa69036d38dc44fa7),
        Q_UINT64_C(0xdc8900d3ffe9bb33),
        Q_UINT64_C(0x7df691fb44c14455),
        Q_UINT64_C(0x8db41acc4e059813),
        Q_UINT64_C(0x9b2d3d0de5b20868),
        Q_UINT64_C(0x4b39506de2dc33e8),
        Q_UINT64_C(0x497fa4ddbb3b07ce),
        Q_UINT64_C(0x6c5debfda2c4ba40),
        Q_UINT64_C(0x8fdbde6d48bf1975),
        Q_UINT64_C(0xff2f49b04059933f),
        Q_UINT64_C(0xecbe4f65b27376f4),
        Q_UINT64_C(0x2721d3581a8b968c),
        Q_UINT64_C(0x1a24f47aac88d68b),
        Q_UINT64_C(0x789e285d63687859),
        Q_UINT64_C(0x90d51721750bfb72),
        Q_UINT64_C(0x6ec71da00ade928f),
        Q_UINT64_C(0xf30d9e21516cb984),
        Q_UINT64_C(0x26e15240e445a13b),
        Q_UINT64_C(0x1f2c3c30333f106d),
        Q_UINT64_C(0xc112f0277a1d8d9e),
        Q_UINT64_C(0xb8ded447d7ac9df4),
        Q_UINT64_C(0xec3468c53d70f8e2),
        Q_UINT64_C(0xc2762a9062b4fd52),
        Q_UINT64_C(0x125a697ea5c928fc),
        Q_UINT64_C(0x699ccbae2e951159),
        Q_UINT64_C(0xb84b2eebee507f54),
        Q_UINT64_C(0x3f758e5dc86257e0),
        Q_UINT64_C(0x98cce7a224a0ec87),
        Q_UINT64_C(0x9c664fde6084eb02),
        Q_UINT64_C(0xd0fc175ca6c00b3f),
        Q_UINT64_C(0xab97afa35e0176ee),
        Q_UINT64_C(0xc33d3e3c9d339042),
        Q_UINT64_C(0xdb4d05320bec3d50),
        Q_UINT64_C(0x39be4f2ea598bb3),
        Q_UINT64_C(0x82f71649af9e5b54),
        Q_UINT64_C(0xa314e81e7bdd8915),
        Q_UINT64_C(0xef47b0e2d07c4d8e),
        Q_UINT64_C(0xc95b40effdb0f22f),
        Q_UINT64_C(0xc388499302f30a22),
        Q_UINT64_C(0xff906154a95d03a7),
        Q_UINT64_C(0x9d33ff38637e7a05),
        Q_UINT64_C(0x2552ea8ad2b403cd),
        Q_UINT64_C(0x5e613aa2d28e5a87),
        Q_UINT64_C(0x4ec1298ccbd07a),
        Q_UINT64_C(0x8315aeb53c3d81ce)
    }
};
const quint64 RAND_WHITE_CASTLING_KS = Q_UINT64_C(0x60c5f1b38762756d);
const quint64 RAND_WHITE_CASTLING_QS = Q_UINT64_C(0x38918d25eac93e11);
const quint64 RAND_BLACK_CASTLING_KS = Q_UINT64_C(0xfed940d4bb964ecb);
const quint64 RAND_BLACK_CASTLING_QS = Q_UINT64_C(0x4a2da478101f9d64);
const quint64 RAND_EN_PASSANT[MAX_EN_PASSANT_SQUARES] =
{
    Q_UINT64_C(0xbc5e6419e34ab321),
    Q_UINT64_C(0x3513a06b02fc5132),
    Q_UINT64_C(0xb83ea9358f46207b),
    Q_UINT64_C(0xe575a233ac88fbf0),
    Q_UINT64_C(0x64c8173b165c69ac),
    Q_UINT64_C(0xe361ef6d97725e14),
    Q_UINT64_C(0x1ad0d77aa083746f),
    Q_UINT64_C(0x29a2f875cbc5f61a),
    Q_UINT64_C(0xd929e0170d1eda7),
    Q_UINT64_C(0xd13dda118259fd9f),
    Q_UINT64_C(0xe8cb491492468f4b),
    Q_UINT64_C(0x9c49ffc0f1b05f16),
    Q_UINT64_C(0xb76ca00d646c4009),
    Q_UINT64_C(0x99d8482b93ac2334),
    Q_UINT64_C(0x9d8a11eda9fe0d09),
    Q_UINT64_C(0x21f507b5b6d8771)
};
const quint64 RAND_TO_MOVE = Q_UINT64_C(0xb1aac26e1c3caa9d);
const quint64 RAND_VALUES2[MAX_PIECES][MAX_SQUARES] =
{
    {
        Q_UINT64_C(0x2a5417a98307b2da),
        Q_UINT64_C(0x5ac95aaf5b5a0a8c),
        Q_UINT64_C(0x4242b999ccb11fd),
        Q_UINT64_C(0xa37501fe898e0e78),
        Q_UINT64_C(0x9a94bcea9e2da76b),
        Q_UINT64_C(0xc7ce19cc5e802f83),
        Q_UINT64_C(0x45eeced5b680b2cb),
        Q_UINT64_C(0xadb6adad23017434),
        Q_UINT64_C(0x80800ecc4d2b87a9),
        Q_UINT64_C(0x642f6c3b25f7815),
        Q_UINT64_C(0x36bee3949859adc4),
        Q_UINT64_C(0xbf7edddd305cd3e4),
        Q_UINT64_C(0xdc832abd4ffa5cb6),
        Q_UINT64_C(0x93633b3bfd69c313),
        Q_UINT64_C(0xace24bbc5c3b597),
        Q_UINT64_C(0x15b724f37500f32b),
        Q_UINT64_C(0xf8757ae36e0f7ad7),
        Q_UINT64_C(0x61ad06851f14a2d2),
        Q_UINT64_C(0x71305111983c5848),
        Q_UINT64_C(0x2312fe7b04ecc10e),
        Q_UINT64_C(0xa83a7e4426b47c5c),
        Q_UINT64_C(0x57273697f8db1fe1),
        Q_UINT64_C(0x1ba0df2ee5b42a5f),
        Q_UINT64_C(0xad7c2a49bc87d869),
        Q_UINT64_C(0xa0c2390e8cb1f3b),
        Q_UINT64_C(0xc88205c839aa498d),
        Q_UINT64_C(0xb0d939c06b5cb858),
        Q_UINT64_C(0xe07cec7f3264f226),
        Q_UINT64_C(0x6e33f7d923c0732b),
        Q_UINT64_C(0xe8203d23af991c54),
        Q_UINT64_C(0x1c99f6b4cf6f670c),
        Q_UINT64_C(0x44e4ec3c02e0a04b),
        Q_UINT64_C(0xc6ae9553cc99e7c0),
        Q_UINT64_C(0x449b73fe112a976a),
        Q_UINT64_C(0x5c3102046f66a5da),
        Q_UINT64_C(0xce6ab6643d315942),
        Q_UINT64_C(0x2522da9df2455649),
        Q_UINT64_C(0xa353599c1a2e0548),
        Q_UINT64_C(0x47a81c545e59e8a9),
        Q_UINT64_C(0xd20c18c91d0c7da0),
        Q_UINT64_C(0xa7947c53ce8dd184),
        Q_UINT64_C(0x524a385ac5da3912),
        Q_UINT64_C(0x877c13873f329da6),
        Q_UINT64_C(0x16f6860b1bfacd8f),
        Q_UINT64_C(0xe4c71662637278c3),
        Q_UINT64_C(0xaf4505840b228ab5),
        Q_UINT64_C(0x7cf5f4dd43e540e4),
        Q_UINT64_C(0x19d1b3bfcbd55a13),
        Q_UINT64_C(0x5f0e500c0e9d63db),
        Q_UINT64_C(0xdc76fab4b7b3ba9d),
        Q_UINT64_C(0x759ffa59e9523a66),
        Q_UINT64_C(0x9d7cc9cf7b2e1f05),
        Q_UINT64_C(0xf5614ae6f8970008),
        Q_UINT64_C(0x7987f955c2371b60),
        Q_UINT64_C(0x6ca454ef2c36b0b8),
        Q_UINT64_C(0xbf2d843f0342bc09),
        Q_UINT64_C(0x35ea28b097912aeb),
        Q_UINT64_C(0x41e7fb83df8e4c64),
        Q_UINT64_C(0x77db59b0f6e384ca),
        Q_UINT64_C(0xd6e3c5690790b6b8),
        Q_UINT64_C(0x776de83e838ab515),
        Q_UINT64_C(0x6118c9ee6248fe51),
        Q_UINT64_C(0x43111ed3b71e7d0f),
        Q_UINT64_C(0xf10630451923e6ab)
    } ,
    {
        Q_UINT64_C(0x565ab14f492f71b4),
        Q_UINT64_C(0x3a76f59247731e03),
        Q_UINT64_C(0xa358e41c85134db),
        Q_UINT64_C(0x2aa4cf9149d3eeee),
        Q_UINT64_C(0x4b1a708bcd67571c),
        Q_UINT64_C(0x960b91658e4256a5),
        Q_UINT64_C(0xe92d20cc7b215cd1),
        Q_UINT64_C(0x6a17c2b1ff6d49a4),
        Q_UINT64_C(0xc280f23c9628ed6b),
        Q_UINT64_C(0xf5f3babb8223baf5),
        Q_UINT64_C(0xc00174f43aad425c),
        Q_UINT64_C(0x212624c4251f7393),
        Q_UINT64_C(0x209de09fd3e84346),
        Q_UINT64_C(0xa1adb8f309027c7),
        Q_UINT64_C(0xf5bdfed74bbbe2b5),
        Q_UINT64_C(0xb4a5c1446224e203),
        Q_UINT64_C(0x189b35d7180fefb5),
        Q_UINT64_C(0x8b2c72f8150e4587),
        Q_UINT64_C(0x1196c5cb9e797a9b),
        Q_UINT64_C(0x27b584dae8b2e940),
        Q_UINT64_C(0x79364f768b360ae0),
        Q_UINT64_C(0x171cc6787742c0ad),
        Q_UINT64_C(0xab538219f3d49a73),
        Q_UINT64_C(0xcc82e6842ac5486b),
        Q_UINT64_C(0x8eb33ec2c84c5894),
        Q_UINT64_C(0xc90f46cacfc0229b),
        Q_UINT64_C(0x80ed6a306da6b300),
        Q_UINT64_C(0x566ea1f3681bc906),
        Q_UINT64_C(0xa1dd6add546b62fd),
        Q_UINT64_C(0x4b4e3e160e17a039),
        Q_UINT64_C(0xf5fec0afe974790e),
        Q_UINT64_C(0x6206b04ec9a5be39),
        Q_UINT64_C(0xd1686b1c476e8ee1),
        Q_UINT64_C(0x3e05d0a857bb0b79),
        Q_UINT64_C(0xf861f0b941963817),
        Q_UINT64_C(0xa3bd04a8ae26f2ea),
        Q_UINT64_C(0xb9ef8e89213e0019),
        Q_UINT64_C(0x80496d52af615a37),
        Q_UINT64_C(0xb1bc75fdc72f0dd4),
        Q_UINT64_C(0x6aaf5289dbe9e7a),
        Q_UINT64_C(0x2034b6428849acf8),
        Q_UINT64_C(0x214b79e32484ffd1),
        Q_UINT64_C(0xed8b807ba1d0ba7f),
        Q_UINT64_C(0xb146c7ef65dc112b),
        Q_UINT64_C(0x29273be71456bbf),
        Q_UINT64_C(0xb0c321a881b2978b),
        Q_UINT64_C(0x97e80e566ba19dcf),
        Q_UINT64_C(0xdb8130cd436270bf),
        Q_UINT64_C(0x8390455b1d03ebd4),
        Q_UINT64_C(0x67d87a40f489f971),
        Q_UINT64_C(0x11371562ed0cd5ad),
        Q_UINT64_C(0xc78fc67ea384d066),
        Q_UINT64_C(0xa2c0b78e4160c607),
        Q_UINT64_C(0xec157db9f45f65b8),
        Q_UINT64_C(0x11a23a808020842d),
        Q_UINT64_C(0xf4870065c7cb9058),
        Q_UINT64_C(0xb688f87f37be9f10),
        Q_UINT64_C(0x523904f08e3a1db5),
        Q_UINT64_C(0x6d5547d362630207),
        Q_UINT64_C(0xbe377a2ee9614959),
        Q_UINT64_C(0xa74767500f61e91a),
        Q_UINT64_C(0x59f4428131dfe82b),
        Q_UINT64_C(0xbee2763074345495),
        Q_UINT64_C(0x924a98bc2c03faa3)
    } ,
    {
        Q_UINT64_C(0xa3f278a8ea3800d6),
        Q_UINT64_C(0x8f95861dc9e88f9c),
        Q_UINT64_C(0xb016c7a699f29eec),
        Q_UINT64_C(0x4f871a0da97bd86d),
        Q_UINT64_C(0x6d70153d9c3926e9),
        Q_UINT64_C(0xf626a9275c8edca7),
        Q_UINT64_C(0xa37b001c2aa636af),
        Q_UINT64_C(0x50552a8f13bf4b67),
        Q_UINT64_C(0x7f506ef8d7583d2d),
        Q_UINT64_C(0x2e1f50f49c4fcb4c),
        Q_UINT64_C(0xfc174306518aadaf),
        Q_UINT64_C(0xa96e138bbaf3b99c),
        Q_UINT64_C(0x26d2537610a1428a),
        Q_UINT64_C(0x5d34b24783e87351),
        Q_UINT64_C(0xbdae7bbc576baf7d),
        Q_UINT64_C(0xa7386b52075119e),
        Q_UINT64_C(0x902f3d3f11b71bea),
        Q_UINT64_C(0xd6551d6cbd316ebb),
        Q_UINT64_C(0xe22c47438ea26697),
        Q_UINT64_C(0x812ad25de614fc1e),
        Q_UINT64_C(0xd6a0f0961820f99f),
        Q_UINT64_C(0x9213716d4bef80ca),
        Q_UINT64_C(0x978883dde343df7d),
        Q_UINT64_C(0x5c88103619aa30c6),
        Q_UINT64_C(0xfa9cbcc1c7aa786f),
        Q_UINT64_C(0xa4c270ecbe8278b3),
        Q_UINT64_C(0x31ac3dd2c0abd738),
        Q_UINT64_C(0x37774370702023be),
        Q_UINT64_C(0x7df4cf76ade1ef4d),
        Q_UINT64_C(0x25396a494516dec2),
        Q_UINT64_C(0x69fe023ce81dda44),
        Q_UINT64_C(0x9bfa45df4de43313),
        Q_UINT64_C(0x7eb578e49c1b5591),
        Q_UINT64_C(0x33d3f3069234c23a),
        Q_UINT64_C(0x730fe0250e55b1d9),
        Q_UINT64_C(0x683e70b476db9c72),
        Q_UINT64_C(0xe628af7287eb7b22),
        Q_UINT64_C(0x5cc9a853f739944),
        Q_UINT64_C(0x33b1091a8d9831c),
        Q_UINT64_C(0xbcb444793c9aa442),
        Q_UINT64_C(0x610301f6a75e25d6),
        Q_UINT64_C(0xcee84a19312ab772),
        Q_UINT64_C(0xca84e80ce1fb32a0),
        Q_UINT64_C(0x246a9b91d8c018cc),
        Q_UINT64_C(0x262c8dbef351b7a),
        Q_UINT64_C(0xfb1ff9f4c31a9f26),
        Q_UINT64_C(0xf0792a527dd73b63),
        Q_UINT64_C(0xf44f0208aff4ebdb),
        Q_UINT64_C(0x209bacbad03a0e47),
        Q_UINT64_C(0x976cae0727bcdd47),
        Q_UINT64_C(0xc6268f2a65b666ba),
        Q_UINT64_C(0x9ac2e7adb3078fd1),
        Q_UINT64_C(0x391b492cc69d3d90),
        Q_UINT64_C(0x731b43a7cb531413),
        Q_UINT64_C(0x25fd672d91f1910a),
        Q_UINT64_C(0x6b9f1577ed191584),
        Q_UINT64_C(0x9e98198a9b435198),
        Q_UINT64_C(0xf9211bec7f67b9b6),
        Q_UINT64_C(0x7184259d9eca2d52),
        Q_UINT64_C(0x89b34a0107893fe8),
        Q_UINT64_C(0xb31a7b5beb798123),
        Q_UINT64_C(0xae28248f42709eed),
        Q_UINT64_C(0x5dd7c34ab7d1d05e),
        Q_UINT64_C(0xc993fe8499e8729f)
    } ,
    {
        Q_UINT64_C(0x8af2cf20821b1ed6),
        Q_UINT64_C(0xb3d45a42c1eba0b4),
        Q_UINT64_C(0xdab6b5908ca7b6a2),
        Q_UINT64_C(0x1877a332f18884e2),
        Q_UINT64_C(0x9efc385d3fc3f4fc),
        Q_UINT64_C(0xebf16323d388b3e),
        Q_UINT64_C(0x97b696a1e4ad73e),
        Q_UINT64_C(0x9ac23b1823568ae),
        Q_UINT64_C(0x370ed86a19d5269e),
        Q_UINT64_C(0x73339a44eb64246e),
        Q_UINT64_C(0xe3004dc320fe9fac),
        Q_UINT64_C(0x4c416001629dde1),
        Q_UINT64_C(0x929c2b1daef7a4c2),
        Q_UINT64_C(0xe084b4b411de4dec),
        Q_UINT64_C(0x7fd8093ccf4f057),
        Q_UINT64_C(0x87f63c8ce96ad1c5),
        Q_UINT64_C(0x7354e0263d16bdcb),
        Q_UINT64_C(0xe6383a502b96c3a6),
        Q_UINT64_C(0x7f2fffb963dca025),
        Q_UINT64_C(0x81fe69658e1c281e),
        Q_UINT64_C(0x54fad66539b919ac),
        Q_UINT64_C(0x881a8e64df80dd01),
        Q_UINT64_C(0x23aec86c61190a69),
        Q_UINT64_C(0x31e87ce13389adde),
        Q_UINT64_C(0xee8e6d85bb237cfc),
        Q_UINT64_C(0x709e7ad92346f2b0),
        Q_UINT64_C(0x4df70546f77dfdd6),
        Q_UINT64_C(0xbf3f90b542d637e1),
        Q_UINT64_C(0x333505b3d67af4c),
        Q_UINT64_C(0xe1e53fa45bc1f6cc),
        Q_UINT64_C(0xb50331b42af6890d),
        Q_UINT64_C(0xadbdac6c3be7eb14),
        Q_UINT64_C(0xb599a56d460c4819),
        Q_UINT64_C(0x90e68ce5334a496),
        Q_UINT64_C(0xde5a36b0ca29d6e),
        Q_UINT64_C(0xe1d83f7011b5495),
        Q_UINT64_C(0xb806b49cde676d1f),
        Q_UINT64_C(0x596415bff969e5ac),
        Q_UINT64_C(0x4ecb33f92391a99d),
        Q_UINT64_C(0x978b3cf87693394c),
        Q_UINT64_C(0x47b7f5d55b0c1b2f),
        Q_UINT64_C(0xadbda5d618bf4fc1),
        Q_UINT64_C(0xd50bc780121a16c6),
        Q_UINT64_C(0xc01c8629fc0b5906),
        Q_UINT64_C(0xc2e96408c1170dac),
        Q_UINT64_C(0xd00268c3c112dd6d),
        Q_UINT64_C(0xb44a2f9833b112b2),
        Q_UINT64_C(0x4ad98b014e331b82),
        Q_UINT64_C(0x960f27e9ca01dffb),
        Q_UINT64_C(0x2c87d28ce4ab8ce),
        Q_UINT64_C(0x1913e6fa55592377),
        Q_UINT64_C(0xb3fc07fd633094c5),
        Q_UINT64_C(0x28d8f3bc1149659),
        Q_UINT64_C(0x17e47e9fcaa101ab),
        Q_UINT64_C(0xec7c64d3f35a93a0),
        Q_UINT64_C(0xa5579af4ef028d6f),
        Q_UINT64_C(0xe866dfd47419c9e9),
        Q_UINT64_C(0x12a90901fd4c1c61),
        Q_UINT64_C(0x4613bfbb58c63015),
        Q_UINT64_C(0x42e4466423c4f286),
        Q_UINT64_C(0x92f6746ca2e50366),
        Q_UINT64_C(0x93002fb08d04a982),
        Q_UINT64_C(0xa7bc2dc031876fe3),
        Q_UINT64_C(0x621169ba9c39dc2b)
    } ,
    {
        Q_UINT64_C(0x85a5c445a8c4baf5),
        Q_UINT64_C(0xee64b9c6584a9de8),
        Q_UINT64_C(0xdaa1ed0eba35645a),
        Q_UINT64_C(0x8f5910048cbca322),
        Q_UINT64_C(0xe570d3024996c3f),
        Q_UINT64_C(0xba4ad47b280f9de7),
        Q_UINT64_C(0x336b7645ac7d0244),
        Q_UINT64_C(0x74c46e492a70974c),
        Q_UINT64_C(0x3352c2984e263343),
        Q_UINT64_C(0xb13d1482d3318812),
        Q_UINT64_C(0xd8f384157b12b62d),
        Q_UINT64_C(0xde5eb19a00393c01),
        Q_UINT64_C(0xd882afd8cf70261a),
        Q_UINT64_C(0xa3c47c92d627ce3c),
        Q_UINT64_C(0xb53c09a30bab17c4),
        Q_UINT64_C(0xaec14792f9613a68),
        Q_UINT64_C(0xb06f91968cfc4f70),
        Q_UINT64_C(0xe577859b7affd561),
        Q_UINT64_C(0x61cc445d91fed085),
        Q_UINT64_C(0x2c43b923c3b6193c),
        Q_UINT64_C(0x9c3d4b4945169e8f),
        Q_UINT64_C(0xbdb629528c1fa4e3),
        Q_UINT64_C(0x765764f75e136a25),
        Q_UINT64_C(0x9d6876cc28c40323),
        Q_UINT64_C(0x4f6710cb56ff4e1d),
        Q_UINT64_C(0x67c4537ad1694c9e),
        Q_UINT64_C(0x2a398547bae7973c),
        Q_UINT64_C(0xa9a31125194853b4),
        Q_UINT64_C(0x481484b747893358),
        Q_UINT64_C(0x7159a6b0047670ff),
        Q_UINT64_C(0x2a20f6513c4c6164),
        Q_UINT64_C(0x8e4f9f6826a7d069),
        Q_UINT64_C(0xa8986bbb3a03b4be),
        Q_UINT64_C(0x2897848201586d82),
        Q_UINT64_C(0x4a350cfdbf731566),
        Q_UINT64_C(0xda2a5d4fcf86b91),
        Q_UINT64_C(0xc906ebab5484492b),
        Q_UINT64_C(0x15873698e510c12d),
        Q_UINT64_C(0x4d782314d1071fdd),
        Q_UINT64_C(0x3b33e279a51cda42),
        Q_UINT64_C(0x7316ba05e94a2760),
        Q_UINT64_C(0x2947dbd72b62eeee),
        Q_UINT64_C(0x994ee8778f5bb403),
        Q_UINT64_C(0x65ba34e9f6e6a886),
        Q_UINT64_C(0xf7048c8aaafeb0fb),
        Q_UINT64_C(0xdb6facf385a67bf9),
        Q_UINT64_C(0x55387477c8566d6b),
        Q_UINT64_C(0x8c73d9a9b40a182d),
        Q_UINT64_C(0x621dd5fb126b5231),
        Q_UINT64_C(0xcb57d791aa28cab4),
        Q_UINT64_C(0xd9c89d3f4662edaf),
        Q_UINT64_C(0xe41ee971856c1ad6),
        Q_UINT64_C(0x1e9842a9f9682f21),
        Q_UINT64_C(0x657435bd92007385),
        Q_UINT64_C(0x76ee8c371bb5adfe),
        Q_UINT64_C(0x457d2ebeb1b7bc3a),
        Q_UINT64_C(0x5ced48c3073d82ae),
        Q_UINT64_C(0x5009cd7eac1805f1),
        Q_UINT64_C(0xd58efb58cb715c37),
        Q_UINT64_C(0xe1c8c503ec7e1592),
        Q_UINT64_C(0x932b5eebaea84148),
        Q_UINT64_C(0x477dd65b75fec5a4),
        Q_UINT64_C(0xc1f70dbb2324b11d),
        Q_UINT64_C(0x840bec343f01db29)
    } ,
    {
        Q_UINT64_C(0xc9154a3054cb7ed7),
        Q_UINT64_C(0x4094ac226115302),
        Q_UINT64_C(0x40a17b1b3a996c03),
        Q_UINT64_C(0x6b075c0b979ef1e0),
        Q_UINT64_C(0x71944990ac67d03f),
        Q_UINT64_C(0x963bec4af2a26b43),
        Q_UINT64_C(0x26ff8b7968bc4c68),
        Q_UINT64_C(0x5b9e4399852cf357),
        Q_UINT64_C(0x44c8e4f80f6729ac),
        Q_UINT64_C(0x93fe2302cd9550e1),
        Q_UINT64_C(0xd1f2e2ff8960943),
        Q_UINT64_C(0x25eb08709be821f6),
        Q_UINT64_C(0x9ab982fcd9f28104),
        Q_UINT64_C(0xcdd1ec49e9360804),
        Q_UINT64_C(0x79ad756ecb367f06),
        Q_UINT64_C(0x89eb5e0836cf62b0),
        Q_UINT64_C(0x4ac95d9764704e3),
        Q_UINT64_C(0xf7882147c928a4c4),
        Q_UINT64_C(0xc7ce5faa50675679),
        Q_UINT64_C(0x7e4c3e3103de876d),
        Q_UINT64_C(0x35ae2a6974cacdad),
        Q_UINT64_C(0xaf67df6b23302a45),
        Q_UINT64_C(0x8d8dd335451b7a47),
        Q_UINT64_C(0x44beddf622d3b188),
        Q_UINT64_C(0xf5b6409a9f699b45),
        Q_UINT64_C(0x9f5188f178ebc7ed),
        Q_UINT64_C(0x8ceb2ff434d23c0e),
        Q_UINT64_C(0x83f25956f402e601),
        Q_UINT64_C(0x6f4d13a4f0cf30b6),
        Q_UINT64_C(0xb1c0502c328b514e),
        Q_UINT64_C(0x7a8a8ebd4ab58aa6),
        Q_UINT64_C(0xec0573d9d6a20975),
        Q_UINT64_C(0x11e38f6467dbfe67),
        Q_UINT64_C(0xfc4e5be49eead763),
        Q_UINT64_C(0x858cd5c130a8fc51),
        Q_UINT64_C(0x4465d21d7b916424),
        Q_UINT64_C(0xd92bf4909d34330f),
        Q_UINT64_C(0x74cb5f744b0122d0),
        Q_UINT64_C(0x6a3b845be9db821c),
        Q_UINT64_C(0x5afff0e881a8f107),
        Q_UINT64_C(0x4b4249fb7ba7423d),
        Q_UINT64_C(0x3ad9f8d8e8eed5),
        Q_UINT64_C(0xeb1c98f6e09750de),
        Q_UINT64_C(0x9daf6ca66119a894),
        Q_UINT64_C(0x848380da2cdc0a2),
        Q_UINT64_C(0x2e1af306216802d4),
        Q_UINT64_C(0x19abddf45e5b7ea4),
        Q_UINT64_C(0xb6c53281ef196767),
        Q_UINT64_C(0xc54c385bed2ce3b2),
        Q_UINT64_C(0xa817979decc2b27c),
        Q_UINT64_C(0x5a2a2096cae78195),
        Q_UINT64_C(0xa7ebee9dbf8345f6),
        Q_UINT64_C(0x65d51a6270c4c3dc),
        Q_UINT64_C(0x7da039225b9ac0e8),
        Q_UINT64_C(0x178f6351e8aae464),
        Q_UINT64_C(0xfdb1a3f8f880811b),
        Q_UINT64_C(0xbba52f982ead6dee),
        Q_UINT64_C(0x522d6eabb42098c3),
        Q_UINT64_C(0xd2d67588acc60fd2),
        Q_UINT64_C(0xab6184a29a26d467),
        Q_UINT64_C(0xfb2ce53d12eec200),
        Q_UINT64_C(0x1edcde41da3b9182),
        Q_UINT64_C(0x4529c0b5807e70a5),
        Q_UINT64_C(0x6177b11b182a5b83)
    } ,
    {
        Q_UINT64_C(0xf4f8f7cc3a55fa7f),
        Q_UINT64_C(0xbcc30e2a1ae5a6c4),
        Q_UINT64_C(0x3a8b696603dfdd12),
        Q_UINT64_C(0xc51390eed137f8dc),
        Q_UINT64_C(0xdf897bf74b7fefb6),
        Q_UINT64_C(0x616e5b1d937170b3),
        Q_UINT64_C(0xe10f9783e6a1f315),
        Q_UINT64_C(0x81c9dceb7b9f923),
        Q_UINT64_C(0xed8ad207fa403596),
        Q_UINT64_C(0x9bce7c7d0ab97518),
        Q_UINT64_C(0xfc06351ced68604),
        Q_UINT64_C(0xc9e6273f2ec6e763),
        Q_UINT64_C(0xead5ef41ca0957b4),
        Q_UINT64_C(0xdf6f1fe61c62a293),
        Q_UINT64_C(0xf3995f29904bc412),
        Q_UINT64_C(0xf83305440895793b),
        Q_UINT64_C(0x32b29c3f5467e863),
        Q_UINT64_C(0x3ed4bf86f70fc4fa),
        Q_UINT64_C(0x886f78f6d8ccf859),
        Q_UINT64_C(0x14b4408582991ee0),
        Q_UINT64_C(0x2ff64d5a20bafe98),
        Q_UINT64_C(0x2c6a9f5a5b152675),
        Q_UINT64_C(0x749d77156c4a125f),
        Q_UINT64_C(0xa18c8f52fef0a2d7),
        Q_UINT64_C(0xf4a189bca3c87ac0),
        Q_UINT64_C(0xb95bffaf868dbdff),
        Q_UINT64_C(0xc88c3b3e52bf009c),
        Q_UINT64_C(0x5733f812439ad9c),
        Q_UINT64_C(0x169b0070baec77aa),
        Q_UINT64_C(0x49744d1aa6badab1),
        Q_UINT64_C(0xbf05ed4f17ea10d3),
        Q_UINT64_C(0x4b85feb634951e17),
        Q_UINT64_C(0xe4e039fc6cde7a5b),
        Q_UINT64_C(0x2a3e9b8d701289ab),
        Q_UINT64_C(0x3e18795e13a27dad),
        Q_UINT64_C(0xd75fc174992fc789),
        Q_UINT64_C(0x73d2fb3f725c060f),
        Q_UINT64_C(0x57f60d1c5c2403b8),
        Q_UINT64_C(0xdec6b7f4069dc977),
        Q_UINT64_C(0x7f31ea307d83b668),
        Q_UINT64_C(0xec7a56b5d3763edf),
        Q_UINT64_C(0x30199b8d81721c1c),
        Q_UINT64_C(0xef54d9d354deb3c5),
        Q_UINT64_C(0xe86119665f61c11d),
        Q_UINT64_C(0x572a32643122fb1c),
        Q_UINT64_C(0x6ba9658c371e003b),
        Q_UINT64_C(0xad015a0f08f4a9cb),
        Q_UINT64_C(0xd26728ca51cbccb6),
        Q_UINT64_C(0xa3865b917a21bee1),
        Q_UINT64_C(0x6d35946ba6b03017),
        Q_UINT64_C(0x4fc223cf3e1cd5a2),
        Q_UINT64_C(0xb3f2237cd7833832),
        Q_UINT64_C(0x86ab980f57a8df5),
        Q_UINT64_C(0x9a58e0c0091f362e),
        Q_UINT64_C(0x757cd2e0e53ba4b9),
        Q_UINT64_C(0xaf111d5fabce6a6f),
        Q_UINT64_C(0x1465f4f274997b15),
        Q_UINT64_C(0x3462e23246eb0d12),
        Q_UINT64_C(0x726452adff1006fd),
        Q_UINT64_C(0xac499e66fd93b059),
        Q_UINT64_C(0x4ecbaf6b99a2e56a),
        Q_UINT64_C(0x1041c97f21469fbf),
        Q_UINT64_C(0x6dda538750a36a56),
        Q_UINT64_C(0x94dca9a98cc1d99f)
    } ,
    {
        Q_UINT64_C(0x77a211638cd87dcd),
        Q_UINT64_C(0xa6a31bd50991eaf4),
        Q_UINT64_C(0x11bfa3ec8c026b3),
        Q_UINT64_C(0x2cb470f801cbddfe),
        Q_UINT64_C(0x98dbad4e585644f2),
        Q_UINT64_C(0x46290af12fdc6634),
        Q_UINT64_C(0x9b247c6a5a0a2d77),
        Q_UINT64_C(0xd6bebbf2b9869edf),
        Q_UINT64_C(0xa4aae898140b992c),
        Q_UINT64_C(0x9d8a5a9cb6029dec),
        Q_UINT64_C(0x2d2ad61b40e30884),
        Q_UINT64_C(0xa90247f82bd087fa),
        Q_UINT64_C(0x96bf2d094e665fca),
        Q_UINT64_C(0xe2a49eae6dc4add),
        Q_UINT64_C(0x36bcf9022326df31),
        Q_UINT64_C(0x3d2c88e91a86b1b9),
        Q_UINT64_C(0x3e8841055bc756c2),
        Q_UINT64_C(0x4812d804754aa522),
        Q_UINT64_C(0xc09a37b9b5a60a6c),
        Q_UINT64_C(0x86b3acf3725828ce),
        Q_UINT64_C(0xab73f4897f4edcc1),
        Q_UINT64_C(0xcd0599eb02c15a3b),
        Q_UINT64_C(0x122c3fb7f17f1693),
        Q_UINT64_C(0x3efa1a3de765fe3),
        Q_UINT64_C(0x3c744c64f6cd0fd0),
        Q_UINT64_C(0xffb8a18a638c32df),
        Q_UINT64_C(0xce2d709075b56496),
        Q_UINT64_C(0xec13bd7bb907c28d),
        Q_UINT64_C(0x1e9cbb46ed2b79f8),
        Q_UINT64_C(0x6150e6c619d03a47),
        Q_UINT64_C(0xf8b24b23e5bba1e9),
        Q_UINT64_C(0x5b23491415c5731),
        Q_UINT64_C(0xac6fdf0b875d6f4d),
        Q_UINT64_C(0x9a53e5fefae9bf64),
        Q_UINT64_C(0x4550a6a211125ad8),
        Q_UINT64_C(0xc85dc7123cd9c63f),
        Q_UINT64_C(0xc859f0a16091cef6),
        Q_UINT64_C(0xf1f596bb7fcbeb58),
        Q_UINT64_C(0x9a97173efcf08eaf),
        Q_UINT64_C(0x1b02983108490082),
        Q_UINT64_C(0x97d4a8c6501481ed),
        Q_UINT64_C(0x39e16a2ee1cf0a8e),
        Q_UINT64_C(0x60928f452edff88a),
        Q_UINT64_C(0x8c5d5ddcaf147682),
        Q_UINT64_C(0x514eab759624319c),
        Q_UINT64_C(0x282d95ee564bbc7d),
        Q_UINT64_C(0x30c4098a2c0ea9b7),
        Q_UINT64_C(0x8d4be2f3c4e2c7ed),
        Q_UINT64_C(0xca08aa88874dc7c5),
        Q_UINT64_C(0xef5770f56f23ab3f),
        Q_UINT64_C(0xb86cc826b8a4f483),
        Q_UINT64_C(0xcef35fd1ba58fbf1),
        Q_UINT64_C(0x1c4c4d5225c6a03c),
        Q_UINT64_C(0x540ae3e26cd6f2e3),
        Q_UINT64_C(0x73c6f2e85dc5791),
        Q_UINT64_C(0x5a7c921272b60cd6),
        Q_UINT64_C(0x51e77f35b26b0f65),
        Q_UINT64_C(0x7873076f894c1741),
        Q_UINT64_C(0x58bb95f718869463),
        Q_UINT64_C(0x98d2c3df1b1057e9),
        Q_UINT64_C(0xcd1b5c04053b94f1),
        Q_UINT64_C(0x520ef737974a25a),
        Q_UINT64_C(0xb04004966560cda8),
        Q_UINT64_C(0xd9c460639fff593a)
    } ,
    {
        Q_UINT64_C(0x8f84cf5e9c63a4e4),
        Q_UINT64_C(0x9f9cdb21e4265481),
        Q_UINT64_C(0xae76dce90166fcb1),
        Q_UINT64_C(0x2c00978be7e946e1),
        Q_UINT64_C(0x3edb6548e399ea23),
        Q_UINT64_C(0x9a2eab067b1d6389),
        Q_UINT64_C(0x3368d04265078033),
        Q_UINT64_C(0x16c8657810cb31be),
        Q_UINT64_C(0x8152a38826988196),
        Q_UINT64_C(0xff09a25603bc3685),
        Q_UINT64_C(0x9da9a95a084ada86),
        Q_UINT64_C(0x686d71730d08a5f5),
        Q_UINT64_C(0x9b7122f7a659c196),
        Q_UINT64_C(0x79cafe1cfd745ce9),
        Q_UINT64_C(0x450fcd2b936b21ba),
        Q_UINT64_C(0x65e176d0f1faaba0),
        Q_UINT64_C(0x9defe22c226a2937),
        Q_UINT64_C(0x312d522443582b81),
        Q_UINT64_C(0x27fd7d290abc8791),
        Q_UINT64_C(0x9cb424b4689b1085),
        Q_UINT64_C(0xb1ee7d9bc7ed638),
        Q_UINT64_C(0x8c4a47129f11b13e),
        Q_UINT64_C(0x81f99bd9881ec40d),
        Q_UINT64_C(0x18ca6862cc295b36),
        Q_UINT64_C(0xd3a012a193a0670e),
        Q_UINT64_C(0x38f322136e477422),
        Q_UINT64_C(0xd57c9805da53f9b),
        Q_UINT64_C(0x7c719d808b472f38),
        Q_UINT64_C(0xd2ebb0c1c120fd43),
        Q_UINT64_C(0xbafd25ccacada6b9),
        Q_UINT64_C(0x7a3b210b35402d94),
        Q_UINT64_C(0x798eecdce02da12),
        Q_UINT64_C(0xf7dc1295b2fdacf2),
        Q_UINT64_C(0x72676a76edc34f5e),
        Q_UINT64_C(0x2e7ab868cb80bd96),
        Q_UINT64_C(0xe6472bce9a471812),
        Q_UINT64_C(0x6dabeca8ff13c4ab),
        Q_UINT64_C(0x49a6a9802cf4c7e6),
        Q_UINT64_C(0x488851cea3bc5b56),
        Q_UINT64_C(0xa0036e7d09b73710),
        Q_UINT64_C(0x2bebc5c27d8b5075),
        Q_UINT64_C(0x787f3e77a964398a),
        Q_UINT64_C(0x1ce33aa448409dbe),
        Q_UINT64_C(0x905631255b7dd08f),
        Q_UINT64_C(0x197ec96e161d61b7),
        Q_UINT64_C(0xf3ee87a872c7b156),
        Q_UINT64_C(0x6496ab32fb360802),
        Q_UINT64_C(0xf7bd02665d4b2833),
        Q_UINT64_C(0xbf1dd354e1c16673),
        Q_UINT64_C(0xab7a42f389c21b59),
        Q_UINT64_C(0xfeeaf54f69f2c5dd),
        Q_UINT64_C(0xb2805d02045d2527),
        Q_UINT64_C(0x428f1491b65296fc),
        Q_UINT64_C(0xc458fec8573b6b2f),
        Q_UINT64_C(0x191695de290ddef8),
        Q_UINT64_C(0x59384d05101a51f9),
        Q_UINT64_C(0xb5e5973e3e6c271b),
        Q_UINT64_C(0xd374d2d6d48885fb),
        Q_UINT64_C(0x750ed047a2910e3b),
        Q_UINT64_C(0x23c4d2f89df98083),
        Q_UINT64_C(0x82ccb3a7fbd0d688),
        Q_UINT64_C(0x8e3055837bd395ab),
        Q_UINT64_C(0xe9862968513801e4),
        Q_UINT64_C(0xf30e1f7924b5059f)
    } ,
    {
        Q_UINT64_C(0xaef9214a3dafaebb),
        Q_UINT64_C(0x595359d437555f11),
        Q_UINT64_C(0x864b460c3542867d),
        Q_UINT64_C(0xcfef6cc115b6c581),
        Q_UINT64_C(0x5dad64e511cef43a),
        Q_UINT64_C(0x87a312b6c386ccdf),
        Q_UINT64_C(0x316c5cf705464792),
        Q_UINT64_C(0xc86136ea872d8560),
        Q_UINT64_C(0x8a3df4dc1a5f51e8),
        Q_UINT64_C(0x9bae5a4593329914),
        Q_UINT64_C(0xaa371c7ee343e4ef),
        Q_UINT64_C(0xc4c973438fac7798),
        Q_UINT64_C(0x8e1c4f7ca8b63684),
        Q_UINT64_C(0x201cbdb1165441ca),
        Q_UINT64_C(0x96b26b38b840a691),
        Q_UINT64_C(0x68979d345cbe4394),
        Q_UINT64_C(0xf4ea3459a936a89),
        Q_UINT64_C(0xfb1adf39decbe51c),
        Q_UINT64_C(0x6675f542d506b2b7),
        Q_UINT64_C(0xffd179dc8b371e03),
        Q_UINT64_C(0xb26babad603cda4c),
        Q_UINT64_C(0xd85321c6d903fb5c),
        Q_UINT64_C(0x98f47c174e79a448),
        Q_UINT64_C(0x5eea28cf3254b050),
        Q_UINT64_C(0x24aa86493ee408ed),
        Q_UINT64_C(0x6e7f7f59139f0ef1),
        Q_UINT64_C(0x45a7fff92512be7c),
        Q_UINT64_C(0x4020cd989e2ad493),
        Q_UINT64_C(0x38e3864a180f2c82),
        Q_UINT64_C(0x3cd439786f924cf1),
        Q_UINT64_C(0x43be37dd084d404c),
        Q_UINT64_C(0xf661aac05df616fd),
        Q_UINT64_C(0x18a8112595332b81),
        Q_UINT64_C(0xfa38986fcce991c4),
        Q_UINT64_C(0x3fd06f80d4faabed),
        Q_UINT64_C(0xf5d2da68b6e592f6),
        Q_UINT64_C(0x559cfcb55d4d4495),
        Q_UINT64_C(0xe8e8e2b3c886ef82),
        Q_UINT64_C(0x8056a673a349f583),
        Q_UINT64_C(0x30233c3671d552fe),
        Q_UINT64_C(0xa6f0f430cb09b065),
        Q_UINT64_C(0xd359b10c11bc1b48),
        Q_UINT64_C(0xe05e58bd2e1cd9dd),
        Q_UINT64_C(0xf392cce8c43c2c9b),
        Q_UINT64_C(0x137f2f231cf7dd04),
        Q_UINT64_C(0x1b4d78fcc9f30645),
        Q_UINT64_C(0xae3f8cfecaec81cb),
        Q_UINT64_C(0x1e09828827d73bb),
        Q_UINT64_C(0x124ef86cea170d67),
        Q_UINT64_C(0xf3187a792ae2a11b),
        Q_UINT64_C(0x2592985dee9a14bc),
        Q_UINT64_C(0x10232632e736552f),
        Q_UINT64_C(0x8b83551daa92ef94),
        Q_UINT64_C(0xf75a50e2e509d038),
        Q_UINT64_C(0x3e19775a722b635),
        Q_UINT64_C(0x6687bda454e55cc2),
        Q_UINT64_C(0x88f6ba2fc53221b0),
        Q_UINT64_C(0x86a8fb4ef53fc628),
        Q_UINT64_C(0xc26d0e5f1dea6150),
        Q_UINT64_C(0xa0d2a833e75ff7a),
        Q_UINT64_C(0x5dedefd219e31d97),
        Q_UINT64_C(0x1639521ac79f991c),
        Q_UINT64_C(0xb693309c5a6696a1),
        Q_UINT64_C(0xb34ef308c176dacd)
    } ,
    {
        Q_UINT64_C(0x8c0e48d578d0c62e),
        Q_UINT64_C(0xefb595c2274f8e7),
        Q_UINT64_C(0xb99a38710cca949f),
        Q_UINT64_C(0xcd2bcb6a1ce8939),
        Q_UINT64_C(0xc36c1bcef3b7132e),
        Q_UINT64_C(0xd98f8098e57c3ade),
        Q_UINT64_C(0x8d60d26082cc5e66),
        Q_UINT64_C(0x6ed67083a0986432),
        Q_UINT64_C(0xf0c691588aea09a4),
        Q_UINT64_C(0xf278dfa798343aa5),
        Q_UINT64_C(0x4251301408454553),
        Q_UINT64_C(0xc13f48761eae2cdf),
        Q_UINT64_C(0x1db502b921181744),
        Q_UINT64_C(0x51ae72db5efb5369),
        Q_UINT64_C(0x603ba05f5f23e864),
        Q_UINT64_C(0x18fa1e0c10916b38),
        Q_UINT64_C(0xb72dc2d7ed91b4bc),
        Q_UINT64_C(0x749741fd44ab2ec),
        Q_UINT64_C(0x598332aeab692676),
        Q_UINT64_C(0x2ba658fd0178969b),
        Q_UINT64_C(0x7604714f9a9fa83d),
        Q_UINT64_C(0x406b825f315fb561),
        Q_UINT64_C(0x48e0c576ec9ac891),
        Q_UINT64_C(0x96dc2caa168b8d80),
        Q_UINT64_C(0xfc02936de85bc77e),
        Q_UINT64_C(0xc9d8d730a2282b25),
        Q_UINT64_C(0x42ef1929d997a68b),
        Q_UINT64_C(0x6d4be421a819f8ea),
        Q_UINT64_C(0x7243d531e9d6d82f),
        Q_UINT64_C(0x8a45d102af05a8e9),
        Q_UINT64_C(0x5a46dffe3305cd02),
        Q_UINT64_C(0xaf414fd9b8d3e493),
        Q_UINT64_C(0x5fac96743afe163d),
        Q_UINT64_C(0x2ecbfb6e3ee6f398),
        Q_UINT64_C(0x53246a06bda62a84),
        Q_UINT64_C(0x46751f92ef74413f),
        Q_UINT64_C(0xf4df091448d0e5ad),
        Q_UINT64_C(0xb98a823a9e7d850c),
        Q_UINT64_C(0x4d2cb5bab4fa993e),
        Q_UINT64_C(0xd227213a8457a9d9),
        Q_UINT64_C(0x63930e3593b0083c),
        Q_UINT64_C(0x1f71bd25c753a781),
        Q_UINT64_C(0x18fe4194dad76930),
        Q_UINT64_C(0x34aa4e5ef625b84),
        Q_UINT64_C(0x8da56b3f5da4c701),
        Q_UINT64_C(0x1dcc1864dc2d55a2),
        Q_UINT64_C(0x48abe8723804b87),
        Q_UINT64_C(0xc9f6b7240f58cb84),
        Q_UINT64_C(0x1852e3c6c798c31a),
        Q_UINT64_C(0xccfb12a58600ff6f),
        Q_UINT64_C(0xdf2463ed1e69c6cf),
        Q_UINT64_C(0xf392029cd6251877),
        Q_UINT64_C(0xa584d536566f1d65),
        Q_UINT64_C(0x66e3156dd8742bc6),
        Q_UINT64_C(0x571f051721c6de3b),
        Q_UINT64_C(0x4c4bf4e34fa92df6),
        Q_UINT64_C(0xe0e5fee5152a5265),
        Q_UINT64_C(0xe4776589d3e12ad2),
        Q_UINT64_C(0x11f3605f0f87408b),
        Q_UINT64_C(0x2936cf11d29a4153),
        Q_UINT64_C(0x51c95b7f0e953cda),
        Q_UINT64_C(0xa44c3656302546a5),
        Q_UINT64_C(0x240fcfb80ee8671b),
        Q_UINT64_C(0x5b9f78b47b5e17e9)
    } ,
    {
        Q_UINT64_C(0xb259769216954272),
        Q_UINT64_C(0x6aa6880f1589864a),
        Q_UINT64_C(0x4affebf5b942a96f),
        Q_UINT64_C(0x8b50441a2ee48136),
        Q_UINT64_C(0x185d0f5bfcdc8890),
        Q_UINT64_C(0x75448f1782032637),
        Q_UINT64_C(0x233ec58165e74b46),
        Q_UINT64_C(0xd17539644d0e1301),
        Q_UINT64_C(0xbde253c57e9bac3a),
        Q_UINT64_C(0x527f20a177e0ed4b),
        Q_UINT64_C(0xcdab268776e292ac),
        Q_UINT64_C(0x409f72f4d38b7948),
        Q_UINT64_C(0x7922923f76d74c7d),
        Q_UINT64_C(0x6b9f4d13d48832f7),
        Q_UINT64_C(0x6415c44d69a95b9c),
        Q_UINT64_C(0xf30b1c2bf0173d68),
        Q_UINT64_C(0x16300ca2f823614c),
        Q_UINT64_C(0x866eefbda718e04c),
        Q_UINT64_C(0xc88b32d088f799ca),
        Q_UINT64_C(0x113017b991c45d50),
        Q_UINT64_C(0x64d6fd22d032a91c),
        Q_UINT64_C(0x35bff9b98443df5),
        Q_UINT64_C(0x73626b81adb788b4),
        Q_UINT64_C(0x58a324553f1d5a4f),
        Q_UINT64_C(0x879cd6e046d5199e),
        Q_UINT64_C(0x844b95c1b35a886),
        Q_UINT64_C(0x32fe6062572b1af6),
        Q_UINT64_C(0x7ba66b270783da0a),
        Q_UINT64_C(0x724a9c4e4f2d0511),
        Q_UINT64_C(0x33641c19cdefa364),
        Q_UINT64_C(0x5f2dbe6cbbf4f98d),
        Q_UINT64_C(0xa2feb5bd2f354d51),
        Q_UINT64_C(0xe25e7dbb6f55080),
        Q_UINT64_C(0x3c955a6b617a923c),
        Q_UINT64_C(0xeaee6919b1a77668),
        Q_UINT64_C(0xbfc8c5bc72fe4f32),
        Q_UINT64_C(0x2bb960a249094616),
        Q_UINT64_C(0x7d101382b9dbf1ff),
        Q_UINT64_C(0x1fa79e3d05328128),
        Q_UINT64_C(0x56fb686c927681ef),
        Q_UINT64_C(0x522d3bb761678d90),
        Q_UINT64_C(0x1e37a31517264bd7),
        Q_UINT64_C(0xbf5bf9f64805e9ca),
        Q_UINT64_C(0xabaa35e4d8fc7b29),
        Q_UINT64_C(0x564a1669e374d841),
        Q_UINT64_C(0xf3894a340ca98b83),
        Q_UINT64_C(0xa4aec17e5565f07),
        Q_UINT64_C(0xa4546e38d3257fe7),
        Q_UINT64_C(0x29ff24bb8ee83a4),
        Q_UINT64_C(0x6cc60098585c2ef0),
        Q_UINT64_C(0x9c3bfbddb7432847),
        Q_UINT64_C(0x28935c25e5e93c39),
        Q_UINT64_C(0xfc006fa76f71e429),
        Q_UINT64_C(0x2e596b5a1fa162ba),
        Q_UINT64_C(0xe6419045dcc9a8c8),
        Q_UINT64_C(0x6b766b5fc1e2ab4d),
        Q_UINT64_C(0x8a1ad6a33fb25cf0),
        Q_UINT64_C(0xf232c4fa12425059),
        Q_UINT64_C(0xf2756284b64195a9),
        Q_UINT64_C(0x88a0aee4198a2795),
        Q_UINT64_C(0x781e9e741c2fc4f6),
        Q_UINT64_C(0x57a8ea4b4c76573),
        Q_UINT64_C(0xabea748efb8faf25),
        Q_UINT64_C(0xedb2d1cd3e3452df)
    }
};
const quint64 RAND_WHITE_CASTLING_KS2 = Q_UINT64_C(0x41309eb017971c28);
const quint64 RAND_WHITE_CASTLING_QS2 = Q_UINT64_C(0xd7924133b5f3c9e4);
const quint64 RAND_BLACK_CASTLING_KS2 = Q_UINT64_C(0x6a61312ab2c41723);
const quint64 RAND_BLACK_CASTLING_QS2 = Q_UINT64_C(0x23831c2de80baebf);
const quint64 RAND_EN_PASSANT2[MAX_EN_PASSANT_SQUARES] =
{
    Q_UINT64_C(0xdf435687057f4e6d),
    Q_UINT64_C(0x26024cbae9663f9d),
    Q_UINT64_C(0xbc9d578c9dde4f01),
    Q_UINT64_C(0x6a35051a173b7c2e),
    Q_UINT64_C(0x9bd04da145b2e7e4),
    Q_UINT64_C(0x44c1b954602c8d4f),
    Q_UINT64_C(0xb6ac54b27a14dd46),
    Q_UINT64_C(0x1d612c4a46c15365),
    Q_UINT64_C(0x3084d5ff1a7e2c10),
    Q_UINT64_C(0x85cac611ba340e15),
    Q_UINT64_C(0x15110f44ab651ff8),
    Q_UINT64_C(0x422a43a9d2417495),
    Q_UINT64_C(0xced6af0eae46e908),
    Q_UINT64_C(0x90a7ba36946b98d9),
    Q_UINT64_C(0x73a093d169724196),
    Q_UINT64_C(0xcb51354722fb743b)
};
const quint64 RAND_TO_MOVE2 = Q_UINT64_C(0xaaed59a913f77582);
const quint64 RAND_ECO_SQUARE[MAX_SQUARES] =
{
    Q_UINT64_C(0x85c5df427ee97b66),
    Q_UINT64_C(0x8b08f0ba914f433b),
    Q_UINT64_C(0xc550169d3baf1bd0),
    Q_UINT64_C(0xc9e0d79a7ae18874),
    Q_UINT64_C(0xb8f5baef849cf8f3),
    Q_UINT64_C(0x9f543f73fdc3a0c6),
    Q_UINT64_C(0xf96811b98c36b78f),
    Q_UINT64_C(0x2eb88c6b12f5f076),
    Q_UINT64_C(0xb54536a38c33ae1b),
    Q_UINT64_C(0x49a8c7c27199d109),
    Q_UINT64_C(0x8ad6d839bd5fa5ff),
    Q_UINT64_C(0xc41dfc777cd078eb),
    Q_UINT64_C(0x26b95baa2629ff66),
    Q_UINT64_C(0xd6ba43a96f82e6fc),
    Q_UINT64_C(0x1b0b625e82c3b78d),
    Q_UINT64_C(0x55a429fb2efec7df),
    Q_UINT64_C(0x5ce3407a0e1eb8e7),
    Q_UINT64_C(0x40c40f1c019ffb71),
    Q_UINT64_C(0xf0d832a2c9d1a233),
    Q_UINT64_C(0x8476df43a961757a),
    Q_UINT64_C(0x61278190b7beee35),
    Q_UINT64_C(0x59c7eef14f15d557),
    Q_UINT64_C(0x5c76f4e6cbbe8cb1),
    Q_UINT64_C(0xd92014806ee5afe6),
    Q_UINT64_C(0x8d26aed794473561),
    Q_UINT64_C(0xaeab0f68699bc452),
    Q_UINT64_C(0xc2741575ba367181),
    Q_UINT64_C(0xd93525d8a810ed7b),
    Q_UINT64_C(0x2e514d22825b10d7),
    Q_UINT64_C(0x7d0ad041082c5eec),
    Q_UINT64_C(0x102771aee550e66d),
    Q_UINT64_C(0x397cef95642a6d30),
    Q_UINT64_C(0x56b8ae76234634b3),
    Q_UINT64_C(0x46ad9a921630b961),
    Q_UINT64_C(0x73fdf3f5f2bb9bb4),
    Q_UINT64_C(0xad7dc93026363c7f),
    Q_UINT64_C(0x10c17d77783547f3),
    Q_UINT64_C(0xc32038a65f19e4d4),
    Q_UINT64_C(0x106029125ba81485),
    Q_UINT64_C(0xef43147b10c5b783),
    Q_UINT64_C(0x9a25da8b7b3d02ac),
    Q_UINT64_C(0xdb0a4386ffcb973e),
    Q_UINT64_C(0xdea7acea1c0ff0cb),
    Q_UINT64_C(0xc0807f57db0a5b50),
    Q_UINT64_C(0xfd5d58bb8e7c7d26),
    Q_UINT64_C(0x54dc6b07e854d475),
    Q_UINT64_C(0x6c7da143dae253b9),
    Q_UINT64_C(0xf2267b971d787309),
    Q_UINT64_C(0x417407cdbf7fff86),
    Q_UINT64_C(0x8a9cb857e122219c),
    Q_UINT64_C(0x8e6c3444862bebed),
    Q_UINT64_C(0x17b4c866f02e3bee),
    Q_UINT64_C(0x7d21fbbcfa260d11),
    Q_UINT64_C(0x4ce19a879a1f0288),
    Q_UINT64_C(0x7c792043e58017be),
    Q_UINT64_C(0xe80476db133e01e2),
    Q_UINT64_C(0x70a20639306414e1),
    Q_UINT64_C(0x2aab26e0a7eb2dcf),
    Q_UINT64_C(0x300d23b842a58bf6),
    Q_UINT64_C(0x84804ddd113e164d),
    Q_UINT64_C(0xce912ec49285fb5f),
    Q_UINT64_C(0x73965253e568362e),
    Q_UINT64_C(0x137f60642df2b0ca),
    Q_UINT64_C(0xd5eec3fd4c28d85a)
};


#endif
