use strict;
use warnings;
use Module::Build;
use version; our $VERSION = qv('3.4.0.5');

my $builder = Module::Build->new(
    module_name  => 'CipUX::Object',
    license      => 'gpl2',
    dist_author  => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version => "$VERSION",
    installdirs  => 'vendor',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic'  => 0,
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {
        'Test::More'      => 0,
        'Test::Pod'       => '1.14',
        'Test::Refcount'  => 0,
        'Test::LeakTrace' => 0,

    },

    requires => {
        'Carp'           => 0,
        'CipUX'          => '3.4.0.11',
        'CipUX::Storage' => '3.4.0.0',
        'Class::Std'     => '0.0.9',
        'Crypt::SmbHash' => 0,
        'Data::Dumper'   => 0,
        'Getopt::Long'   => 0,
        'Hash::Merge'    => 0,
        'Log::Log4perl'  => 0,
        'Pod::Usage'     => 0,
        'Readonly'       => 0,
        'version'        => 0,
    },
    perl_files => {
        'usr/share/cipux/etc/cipux-object.perl' => 'myetc/cipux-object.perl',
    },
    install_path => { 'myetc' => '/usr/share/cipux/etc' },

    add_to_cleanup => ['CipUX-Object-*'],
);

# Only to uncomment, if you changed the BUILD target
# $builder->add_build_element('dat');
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->add_build_element('perl');
$builder->create_build_script();

