<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/ActionLog.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:4ef96df03630ecc884c881b79a40818f)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_ActionLog constructor.
 */
class CRM_Core_DAO_ActionLog extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_action_log';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = false;
  /**
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to Contact ID
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * FK to id of the entity that the action was performed on. Pseudo - FK.
   *
   * @var int unsigned
   */
  public $entity_id;
  /**
   * name of the entity table for the above id, e.g. civicrm_activity, civicrm_participant
   *
   * @var string
   */
  public $entity_table;
  /**
   * FK to the action schedule that this action originated from.
   *
   * @var int unsigned
   */
  public $action_schedule_id;
  /**
   * date time that the action was performed on.
   *
   * @var datetime
   */
  public $action_date_time;
  /**
   * Was there any error sending the reminder?
   *
   * @var boolean
   */
  public $is_error;
  /**
   * Description / text in case there was an error encountered.
   *
   * @var text
   */
  public $message;
  /**
   * Keeps track of the sequence number of this repetition.
   *
   * @var int unsigned
   */
  public $repetition_number;
  /**
   * Stores the date from the entity which triggered this reminder action (e.g. membership.end_date for most membership renewal reminders)
   *
   * @var date
   */
  public $reference_date;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_action_log';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'action_schedule_id', 'civicrm_action_schedule', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Dynamic(self::getTableName() , 'entity_id', NULL, 'id', 'entity_table');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Action Schedule ID') ,
          'required' => true,
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Action Schedule Contact ID') ,
          'description' => 'FK to Contact ID',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'entity_id' => array(
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Entity ID') ,
          'description' => 'FK to id of the entity that the action was performed on. Pseudo - FK.',
          'required' => true,
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'entity_table' => array(
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Entity Table') ,
          'description' => 'name of the entity table for the above id, e.g. civicrm_activity, civicrm_participant',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'action_schedule_id' => array(
          'name' => 'action_schedule_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Schedule') ,
          'description' => 'FK to the action schedule that this action originated from.',
          'required' => true,
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_ActionSchedule',
        ) ,
        'action_date_time' => array(
          'name' => 'action_date_time',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Action Date And Time') ,
          'description' => 'date time that the action was performed on.',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'is_error' => array(
          'name' => 'is_error',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Error?') ,
          'description' => 'Was there any error sending the reminder?',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'message' => array(
          'name' => 'message',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Message') ,
          'description' => 'Description / text in case there was an error encountered.',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'repetition_number' => array(
          'name' => 'repetition_number',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Repetition Number') ,
          'description' => 'Keeps track of the sequence number of this repetition.',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
        'reference_date' => array(
          'name' => 'reference_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Reference Date') ,
          'description' => 'Stores the date from the entity which triggered this reminder action (e.g. membership.end_date for most membership renewal reminders)',
          'default' => 'NULL',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'action_log', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'action_log', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
