# CiviCRM 5.13.0

Released May 1, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Configurable menubar color
  ([13996](https://github.com/civicrm/civicrm-core/pull/13996))**

  v5.12 introduced a new menu bar. The change also revised the default color
  scheme (applying a more contemporary palette), but this created stress for
  some users who were trained to recognize the old menu color. This exposes a
  new setting for customizing the color scheme, and it changes the default to
  match previous scheme (be black instead of beige).

- **Menu config screen improvements
  ([14002](https://github.com/civicrm/civicrm-core/pull/14002))**

  Improves the Menu configuration screen by: making changes to the menu (adding
  or editing menu items) on the admin screen be reflected immediately, adding
  links to the related settings pages to reduce confusion about how to configure
  various aspects of the menu bar and fixing the broken icon picker and missing
  CiviCRM icon.

- **What to do with the merge screen
  ([dev/core#824](https://lab.civicrm.org/dev/core/issues/824):
  [13898](https://github.com/civicrm/civicrm-core/pull/13898) and
  [13895](https://github.com/civicrm/civicrm-core/pull/13895)) CONTINUES WORK**

  Continues work to clean up the Merge screen by moving toward
  using contact type icons in a standard way instead of the contact type names
  and cleaning up alignment.

- **Mutliple activity type filters on activity tab on contact records
  ([13873](https://github.com/civicrm/civicrm-core/pull/13873))**

  Change include/exclude activity type filters to be multiple select2 widgets so
  that users can filter my multiple activity types rather than only permitting
  users to select one activity type with a traditional select field.

- **Added a DB check to prevent deleting exisiting CiviCRM data from database.
  ([13944](https://github.com/civicrm/civicrm-core/pull/13944))**

  When installing CiviCRM this change adds a check to see if there are existing
  CiviCRM tables and requires users to manually remove any CiviCRM tables
  before continuing to prevent users from accidentally deleting tables.

- **Encourage developers to use .then instead of .done
  ([13982](https://github.com/civicrm/civicrm-core/pull/13982))**

  This change makes it so the Api Explorer generates js code using `.then()`
  (instead of `.done`) and demonstrates proper errQor handling to encourage
  developers to use `.then()`.

- **Replace jcalendar instances with datepicker
  ([dev/core#561](https://lab.civicrm.org/dev/core/issues/561):
  [13919](https://github.com/civicrm/civicrm-core/pull/13919),
  [13855](https://github.com/civicrm/civicrm-core/pull/13855),
  [13965](https://github.com/civicrm/civicrm-core/pull/13965),
  [13950](https://github.com/civicrm/civicrm-core/pull/13950) and
  [13918](https://github.com/civicrm/civicrm-core/pull/13918)) CONTINUES WORK**

  Moves from jcalendar to datepicker in the following places: the fulfilled date
  on the premium tab on back end contribution add/edit screens, the activity
  tab, the receive_date and the renewal_date fields in Membership forms and the
  transaction date field on the update pending status task. And updates tests to
  reflect progress getting rid of jcalendar.

- **Expose sort_name as a dedupe-matchable field
  ([13864](https://github.com/civicrm/civicrm-core/pull/13864))**

  Allow sort_name to be used in dedupe rules.

- **Standardise setTitle method on forms
  ([13781](https://github.com/civicrm/civicrm-core/pull/13781))**

  Makes the title of a form available in the buildForm hook.

- **Send action links on any page that extends CRM_Core_Page_Basic thru
  hook_civicrm_links
  ([13068](https://github.com/civicrm/civicrm-core/pull/13068))**

  Makes it so extension developers can use hook_civicrm_links to add or remove
  links from the Relationship Types Administration Page (CiviCRM Navigation
  Menu->Administer->Customize Data and Screens->Relationship Types) and any
  other page that extends CRM_Core_Page_Basic.

- **Improve lock handling for mysql 5.7.5+
  ([CRM-18011](https://issues.civicrm.org/jira/browse/CRM-18011):
  [13854](https://github.com/civicrm/civicrm-core/pull/13854))**

  Ensures mysql locks are supported on mysql 5.7.5+ and MariaDB '10.0.2'+.

- **Deploy PEAR Log package and upgrade to latest version in the process
  ([13835](https://github.com/civicrm/civicrm-core/pull/13835))**

  Upgrades the PEAR Log package version and deploys it via
  composer.

- **Make cacheCode optional in CRM.loadScript
  ([13824](https://github.com/civicrm/civicrm-core/pull/13824))**

  A cacheCode was recently added to script urls fetched by CRM.getScript(). This
  is not always desirable e.g. for scripts fetched from an external source, this
  change makes it so the cacheCode is added by default but can be disabled.

- **Load hooks during upgrade mode
  ([13551](https://github.com/civicrm/civicrm-core/pull/13551))**

  Allow extensions to load hooks during an upgrade.

- **Checkbox to explicitly change employer when sharing address
  ([CRM-21008](https://issues.civicrm.org/jira/browse/CRM-21008):
  [13700](https://github.com/civicrm/civicrm-core/pull/13700))**

  Before this change when an individual was set to share an address with an
  organization, that organization was set as its current employer. This change
  adds a checkbox that allows users to explicitly tell civicrm whether the
  organization is the current employer or not when sharing an address.

- **Report improvements
  ([CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677):
  [13792](https://github.com/civicrm/civicrm-core/pull/13792),
  [13790](https://github.com/civicrm/civicrm-core/pull/13790) and
  [13780](https://github.com/civicrm/civicrm-core/pull/13780))**

  These changes improve reports by removing redundant birth date and gender
  evaluation code.

- **Contact Subtype field at Reports does not support contacts with multiple
  subtypes ([dev/core/544](https://lab.civicrm.org/dev/core/issues/544):
  [13158](https://github.com/civicrm/civicrm-core/pull/13158) and
  [13908](https://github.com/civicrm/civicrm-core/pull/13908))**

  Makes reports support filtering on multiple contact subtypes.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  ([dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [13850](https://github.com/civicrm/civicrm-core/pull/13850)) CONTINUES WORK**

  Updates Cancel Billing & Update Billing screens to use status bounce rather
  than throw a fatal error.

- **Activity tab performance fix - switch to faster getActivities &
  getActivitiesCount
  ([13768](https://github.com/civicrm/civicrm-core/pull/13768))**

  Performance improvement when loading the activity tab for a contact.

- **Add hook findDuplicates
  ([13234](https://github.com/civicrm/civicrm-core/pull/13234))**

  Adds the hook findDuplicates which provides the ability for extensions to
  intercept and/or override core duplicate checking when
  registering/contributing.

- **Deadlocks and performance issues when using smartgroups / ACLs extensively
  ([dev/core#748](https://lab.civicrm.org/dev/core/issues/748):
  [13772](https://github.com/civicrm/civicrm-core/pull/13772)) CONTINUES WORK**

  Improves performance by switching the alphabetQuery to use new
  getSearchSQLParts() function.

- **Improve data when known time-dependent-failing test fails
  ([13964](https://github.com/civicrm/civicrm-core/pull/13964))**

  Improves output data when time dependent tests fail.

- **Use TempTable methods.
  ([13880](https://github.com/civicrm/civicrm-core/pull/13880),
  [13865](https://github.com/civicrm/civicrm-core/pull/13865),
  [13819](https://github.com/civicrm/civicrm-core/pull/13819),
  [13848](https://github.com/civicrm/civicrm-core/pull/13848),
  [13847](https://github.com/civicrm/civicrm-core/pull/13847) and
  [13703](https://github.com/civicrm/civicrm-core/pull/13703))**

  These changes move towards using the TempTable class to improve
  naming standards, including but not limited to the following places: when
  creating the dedupe table, on the contribution detail report, on the
  bookkeeping report and when debugging.

- **Allow extensions to enable validate.tpl
  ([13961](https://github.com/civicrm/civicrm-core/pull/13961))**

  This change makes it possible for extensions to add a validate.tpl which
  provides front end javascript validation, which improves user experience by
  making it so users do not have to refresh the page to see validation issues.

- **Promise polyfill for older browsers
  ([13955](https://github.com/civicrm/civicrm-core/pull/13955))**

  Loads a polyfill for IE aQnd other outdated browsers so developers can use
  native js Promises in our code.

### CiviCase

- **Case Activity Assignment Restriction
  ([dev/core#641](https://lab.civicrm.org/dev/core/issues/641):
  [13541](https://github.com/civicrm/civicrm-core/pull/13541))**

  Makes it possible to restrict the assignment of case activities to
  a group or to contacts having user accounts.

### CiviContribute

- **Add cancel_reason field to civicrm_contribution_recur table
  ([dev/core#830](https://lab.civicrm.org/dev/core/issues/830):
  [13930](https://github.com/civicrm/civicrm-core/pull/13930),
  [13999](https://github.com/civicrm/civicrm-core/pull/13999), and
  [14164](https://github.com/civicrm/civicrm-core/pull/14164))**

  Adds a recur cancel reason field `civicrm_contribution_recur.cancel_reason
  field`.

- **Add ID / Test ID for payment processors to list - makes setup of IPNs much
  easier! ([13869](https://github.com/civicrm/civicrm-core/pull/13869))**

  Adds a column for payment processor id and test payment processor id to the
  table of "Settings - Payment Processors" page so that users can more easily
  access these ids.

- **Add payment_processor column/filter to recurring contribution report
  ([13699](https://github.com/civicrm/civicrm-core/pull/13699))**

  On the "Recurring Contribution" report, this adds "Payment Processor" as an
  option to the Column and Filter tabs enabling users to filter this report by
  "Payment Processor" and/or include a column for "Payment Processor".

- **Payment processor names: separate internal and external usage
  ([dev/financial#2](https://lab.civicrm.org/dev/financial/issues/2):
  [13995](https://github.com/civicrm/civicrm-core/pull/13995) and
  [13954](https://github.com/civicrm/civicrm-core/pull/13954))**

  Adds the field `payment_processor.title` to the schema and makes it
  translatable.

- **Support paying refunds
  ([dev/financial#38](https://lab.civicrm.org/dev/financial/issues/38):
  [13952](https://github.com/civicrm/civicrm-core/pull/13952)) BEGINS WORK**

  Adds a PaymentProcessor.refund API which makes it possible for payment
  processor extension authors to have their extensions issue refund payments.

- **Add minimal PaymentProcessor.pay api
  ([13953](https://github.com/civicrm/civicrm-core/pull/13953))**

  Adds a new api PaymentProcessor.pay.

- **Include lower level data when throwing an exception on payment processor.pay
  ([14006](https://github.com/civicrm/civicrm-core/pull/14006))**

  Improves error processing when using the PaymentProcessor.pay api.

- **Add billingblock region to event registration thankyou to match contribution
  thankyou ([13762](https://github.com/civicrm/civicrm-core/pull/13762))**

  This change makes it so one can use the same method to
  replace billingblock for both event and contribution thankyou workflows.

- **CQ: Refactor Recurring Contribution Forms
  ([dev/core#846](https://lab.civicrm.org/dev/core/issues/846):
  [13940](https://github.com/civicrm/civicrm-core/pull/13940)) BEGINS WORK**

  Begins work to refactor recurring contribution forms specifically by
  rationalizing url variables into shared parent for recurring contribution
  forms.

- **Use label not name for payment processor type
  ([13885](https://github.com/civicrm/civicrm-core/pull/13885))**

  On the "Settings - Payment Processor" page changes the "Processor Type" column
  to use the label instead of the name.

- **Improve ContributionPage.validate api
  ([13798](https://github.com/civicrm/civicrm-core/pull/13798))**

  Makes it so that one can use the ContributionPage validate api on POST, for
  example when using Paypal Checkout which calls a Promise, the
  ContributionPage.validate api could be called to determine whether to proceed
  after the button is pushed.

- **Add pseudoconstant support for payment_processor_id on ContributionRecur
  ([13698](https://github.com/civicrm/civicrm-core/pull/13698))**

- **Allow payment processor to determine the text around 'continue'
  ([13787](https://github.com/civicrm/civicrm-core/pull/13787))**


### CiviEvent

- **Expose Registered by Participant Name field to participant report
  ([dev/core#835](https://lab.civicrm.org/dev/core/issues/835):
  [13936](https://github.com/civicrm/civicrm-core/pull/13936))**

  Exposes "Registered by Participant Name" field to participant reports.

### CiviMail

- **Report results don't show inactive campaigns
  ([dev/core#491](https://lab.civicrm.org/dev/core/issues/491):
  [13383](https://github.com/civicrm/civicrm-core/pull/13383))**

  Standardizes the way campaign fields are added to the "Mailing Summary"
  report.

- **Use Mailing.preview API to display mailing in browser
  ([14163](https://github.com/civicrm/civicrm-core/pull/14163))**

  This resolves an error on sites with Flexmailer when an anonymous visitor
  views a mailing in the browser.

### CiviMember

- **Membership form address fields for payment processors
  ([13802](https://github.com/civicrm/civicrm-core/pull/13802))**

  Standardizes processing and validating address parameters on the
  Membership form.

### Wordpress Integration

- **Cleaner front-end URLs
  ([144](https://github.com/civicrm/civicrm-wordpress/pull/144))**

  Makes Wordpress URLs have the same structure as Drupal URLs ex:
  `https://domain.tld/civicrm/contribute/transact/?reset=1&id=1 as opposed to
  old` Wordpress URLs that looked like
  `https://domain.tld/civicrm/?page=CiviCRM&q=civicrm/contribute/transact&reset=1&id=1`

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Add a test matrix for E2E tests on each CMS
  ([infra/ops#878](https://lab.civicrm.org/infra/ops/issues/878):
  [13810](https://github.com/civicrm/civicrm-core/pull/13810),
  [13826](https://github.com/civicrm/civicrm-core/pull/13826) and
  [13811](https://github.com/civicrm/civicrm-core/pull/13811)) CONTINUES WORK**

  These changes resolve bugs when running E2E tests on WordPress moving the
  project towards the goal of having a test matrix for E2E tests for each CMS
  that CiviCRM is compatible with.

- **Use the correct membership date for the notification that appear after
  completing the membership payment in case pre hook is used
  ([dev/core#288](https://lab.civicrm.org/dev/core/issues/288):
  [12583](https://github.com/civicrm/civicrm-core/pull/12583))**

  This change ensures that any changes made to the membership dates using
  hook_civicrm_pre are taken into account when generating the membership payment
  notification.

- **Custom Field checkbox value renders empty if the values are randomly sorted
  ([dev/core#499](https://lab.civicrm.org/dev/core/issues/499):
  [13051](https://github.com/civicrm/civicrm-core/pull/13051))**

  This change ensures that the values selected by a user for alphanumeric
  checkbox custom fields render properly in view mode.

- **New Organisation: "Check For Matching Contact (S)" button does not find
  matching records ([dev/core#570](https://lab.civicrm.org/dev/core/issues/570):
  [13398](https://github.com/civicrm/civicrm-core/pull/13398))**

  This change ensures that "Check For Matching Contact(s)" retrieves
  contacts for users with limited permissions.

- **Soft Credits Multiply GIft Amount in Contribution Detail Report
  ([dev/core#655](https://lab.civicrm.org/dev/core/issues/655):
  [13906](https://github.com/civicrm/civicrm-core/pull/13906))**

  This change updates the Contribution Detail report so that the "Total Amount"
  field is not summed because the summing of the "Total Amount" field was
  leading to the "Total Amount" field for contributions with multiple soft
  credits to be multiplied by the number of soft credits.

- **Add new indexes when updating log table schema regardless of engine change
  ([dev/core#664](https://lab.civicrm.org/dev/core/issues/664):
  [13462](https://github.com/civicrm/civicrm-core/pull/13462))**

  This change makes it so that when the alterLogTables hook defines a new index
  it is applied regardless of the engine.

- **Contacts -> New Email give Unknown Error in Smarty when Allow Mail to be
  sent from logged in contact's email address disabled
  ([dev/core#688](https://lab.civicrm.org/dev/core/issues/688):
  [13508](https://github.com/civicrm/civicrm-core/pull/13508))**

  This change fixes an error "Warning: Smarty error" when attempting to send an
  email from Contacts -> New Email for sites with "Allow Mail to be sent from
  logged in user" disabled.

- **Edit contribution : wrong decimal separator on total_amount for
  participant(s) ([dev/core#706](https://lab.civicrm.org/dev/core/issues/706):
  [13554](https://github.com/civicrm/civicrm-core/pull/13554))**

  This change ensures that the decimal separator on total_amount field for
  participant(s) is displayed as it is configured on the site.

- **Contact Report: The filter by the custom datetime field with "Today" option
  doesn't find matching contacts
  ([dev/core#709](https://lab.civicrm.org/dev/core/issues/709):
  [13567](https://github.com/civicrm/civicrm-core/pull/13567))**

  This change ensures that on the Contact Report, when using a filter for a
  custom datetime field the "Today" option properly filters results.

- **Address API incorrectly sets state_province_id if multiple countries have
  same state name / abbreviation
  ([dev/core#725](https://lab.civicrm.org/dev/core/issues/725):
  [13938](https://github.com/civicrm/civicrm-core/pull/13938))**

  This change fixes a regression so that the Address API country_id parameter
  works with an abbreviation or numeric id.

- **Advanced Search: There is an Internal Server Error (500) when the user tries
  to search by the "Mailing List" group type
  ([dev/core#726](https://lab.civicrm.org/dev/core/issues/726):
  [13603](https://github.com/civicrm/civicrm-core/pull/13603) and
  [13888](https://github.com/civicrm/civicrm-core/pull/13888))**

  Fixes a bug where searching by a group type (ex: Mailing List) on the Advanced
  Search form would result in a fatal error so that this search runs as
  expected.

- **Notes: It isn't possible to edit note if the user uploaded an image larger
  than 3 MByte(s) ([dev/core#740](https://lab.civicrm.org/dev/core/issues/740):
  [13640](https://github.com/civicrm/civicrm-core/pull/13640))**

  This change makes it so that it is possible to edit a note field
  that includes images larger than  3 MByte(s).

- **Custom field caching is not group-specific
  ([dev/core#755](https://lab.civicrm.org/dev/core/issues/755):
  [13900](https://github.com/civicrm/civicrm-core/pull/13900))**

  Adds the $groupTitle parameter to the cache key for custom fields, so field
  names that exist in multiple groups will be cached separately.

- **Warning: A non-numeric value encountered in ...
  ([dev/core#788](https://lab.civicrm.org/dev/core/issues/788):
  [13795](https://github.com/civicrm/civicrm-core/pull/13795))**

  This change fixes several warnings "Warning: A non-numeric value encountered
  in ..." on contribution pages & event registrations forms.

- **PHP Warning "explode() expects parameter 2 to be string, array given" for
  multi-value country fields
  ([dev/core#795](https://lab.civicrm.org/dev/core/issues/795):
  [13858](https://github.com/civicrm/civicrm-core/pull/13858))**

  Fixes a PHP warning when updating a multiselect country field.

- **Prefix/suffix select2 renders oddly on public-facing pages
  ([dev/core#798](https://lab.civicrm.org/dev/core/issues/798):
  [13816](https://github.com/civicrm/civicrm-core/pull/13816))**

  This change makes the Prefix/suffix select2's render full height (as opposed
  to squished) in contribution/event profiles.

- **DB Error:: Already exists during renewing membership automatically
  ([dev/core#806](https://lab.civicrm.org/dev/core/issues/806):
  [13852](https://github.com/civicrm/civicrm-core/pull/13852))**

  Fixes a DB error "already exists" when recording recurring payments with taxes
  enabled.

- **Autocomplete select list disabled options
  ([dev/core#811](https://lab.civicrm.org/dev/core/issues/811):
  [13859](https://github.com/civicrm/civicrm-core/pull/13859))**

  This change ensures that for select fields with autocomplete, only enabled
  options autocomplete.

- **Search results: Actions: Export contacts: DB Error: Syntax error occurs when
  not all necessary fields are selected
  ([dev/core#819](https://lab.civicrm.org/dev/core/issues/819):
  [13889](https://github.com/civicrm/civicrm-core/pull/13889))**

  Resolves a fatal database error when attempting to export contacts without
  selecting any fields to be exported.

- **Value in the "Contact Type" field disappears when the user tries to edit
  Contact Details ([dev/core#823](https://lab.civicrm.org/dev/core/issues/823):
  [13945](https://github.com/civicrm/civicrm-core/pull/13945))**

  Ensures that when a user uses a profile with a contact sub type field to
  update a contact that the contact sub type field pre-populates as expected.

- **Notice error while creating smart group using Contribution Aggregate custom
  search ([dev/core#837](https://lab.civicrm.org/dev/core/issues/837):
  [13921](https://github.com/civicrm/civicrm-core/pull/13921))**

  Resolves "Notice: Undefined index:" errors when creating a smart group using
  Contribution Aggregate custom search.

- **Notice error when deleting profile
  ([dev/core#840](https://lab.civicrm.org/dev/core/issues/840):
  [13926](https://github.com/civicrm/civicrm-core/pull/13926))**

  Resolves a "Undefined property" notice when deleting a profile.

- **CQ: Use Guzzle as our preferred way to retrieve via http
  ([dev/core#849](https://lab.civicrm.org/dev/core/issues/849):
  [13946](https://github.com/civicrm/civicrm-core/pull/13946))**

  Replaces get_headers functions call with Guzzle HTTP request to prevent timing
  out.

- **Queries combining multiple text labels using REGEXP do not escape regular
  expression metacharacters
  ([dev/core#433](https://lab.civicrm.org/dev/core/issues/433):
  [12998](https://github.com/civicrm/civicrm-core/pull/12998))**

  Ensures that querying for fee levels that contain regex metacharacters will
  match.

- **Fix status type (error, not fail) for CRM_Core_Session::setStatus
  ([13943](https://github.com/civicrm/civicrm-core/pull/13943))**

  Fixes an incorrect status for setMessage which was using 'fail' (which is not
  a valid status) instead of 'error'.

- **Covert the CRM_Core_Error::fatal calls to exceptions when trying to access
  Contact Photos ([13917](https://github.com/civicrm/civicrm-core/pull/13917))**

  Cleaner errors when attempting to access contact photos fails.

- **CiviCRM API, lookup state_province_id options based on country parameter if
  present, or default country
  ([13596](https://github.com/civicrm/civicrm-core/pull/13596))**

  Ensures the CiviCRM Address API correctly sets state_province_id for states
  whose name/abbreviation exist in multiple countries.

- **Fix php 7.2 count notice
  ([13877](https://github.com/civicrm/civicrm-core/pull/13877))**

  Fixes a "Warning: count()" error on the "Import Contacts" Summary step screen.

- **New Organisation: "Contact Type" dropdown disappears when fields validation
  occurs ([dev/core#699](https://lab.civicrm.org/dev/core/issues/699):
  [13545](https://github.com/civicrm/civicrm-core/pull/13545))**

  Fixes a bug where when creating a new organization, if the form fails
  validation the "Contact Sub Type" dropdown disappears.

- **Fix contact.merge api to pass check_permissions parameter through to the
  deeper layer ([13807](https://github.com/civicrm/civicrm-core/pull/13807))**

  Fixes a bug where calling Contact.merge from php will leave the merged contact
  unmerged if the logged in user does not have the delete contacts permission

- **checkEditInboundEmailsPermissions should be a static function
  ([13805](https://github.com/civicrm/civicrm-core/pull/13805))**

- **DB error "no such field" when executing actions on a sorted contact search
  result with search profile
  ([dev/core#502](https://lab.civicrm.org/dev/core/issues/502):
  [13884](https://github.com/civicrm/civicrm-core/pull/13884))**

- **Transfer picks up the deleted contact ID basically transferring to the wrong
  contact ([dev/core#314](https://lab.civicrm.org/dev/core/issues/314):
  [12639](https://github.com/civicrm/civicrm-core/pull/12639))**

- **Fix bug whereby sorting by state province gives an error in search builder
  ([13748](https://github.com/civicrm/civicrm-core/pull/13748))**

- **Fix Contact.create calls to respect passed in variables & variables set via
  hook for sort_name & display_name
  ([13863](https://github.com/civicrm/civicrm-core/pull/13863))**

- **Do not cause a fatal error if no contact_id field for a note is filled in
  when viewing contact notes
  ([13910](https://github.com/civicrm/civicrm-core/pull/13910))**

- **Disable phpcs checking in the Crypt files where mcrypt functions are
  ([14031](https://github.com/civicrm/civicrm-core/pull/14031))**

- **Fix 4.7.31 Upgrade in multilingual mode
  ([14003](https://github.com/civicrm/civicrm-core/pull/14003))**

- **Optimise the loading of the CiviCRM Deduplication Exception page
  ([13435](https://github.com/civicrm/civicrm-core/pull/13435))**

- **Unfork Zetacomponents mail and use patch to apply differences
  ([13934](https://github.com/civicrm/civicrm-core/pull/13934))**

- **Update lockfile to take into account of civicrm/zetacomponents-mail#4 being
  merged ([13822](https://github.com/civicrm/civicrm-core/pull/13822))**

- **Upgrade zetacomponents/base and zetacomponents/mail
  ([13799](https://github.com/civicrm/civicrm-core/pull/13799))**

- **Smart group with uf_group_id does not load contacts with same search profile
  ([dev/core#771](https://lab.civicrm.org/dev/core/issues/771):
  [13742](https://github.com/civicrm/civicrm-core/pull/13742))**

- **Fix Deprecation notice for use of `while` in PHP7.2 in bin/cli.class.php
  ([dev/core#907](https://lab.civicrm.org/dev/core/issues/907):
  [14155](https://github.com/civicrm/civicrm-core/pull/14155))**

### CiviCase

- **PR 13333 breaks the Save and New button on a new case
  ([dev/core#904](https://lab.civicrm.org/dev/core/issues/904):
  [14145](https://github.com/civicrm/civicrm-core/pull/14145))**

  This reverts a change making the Save and New button `submitOnce`, as that
  prevented the button from opening a new case form after saving.

- **Creating a new relationship type while editing case type definition adds a
  blank row in the roles section
  ([dev/core#784](https://lab.civicrm.org/dev/core/issues/784):
  [13785](https://github.com/civicrm/civicrm-core/pull/13785))**

- **PHP warnings on Case Dashboard and Find Cases
  ([13998](https://github.com/civicrm/civicrm-core/pull/13998))**

### CiviContribute

- **Can't self-service cancel a recurring contribution made while you're logged
  in ([dev/core#571](https://lab.civicrm.org/dev/core/issues/571):
  [13237](https://github.com/civicrm/civicrm-core/pull/13237))**

  This change makes it so that users without "edit contributions" permission can
  edit their own recurring contribution subscriptions if they are logged in,
  before this change they could only edit their own contribution subscriptions
  thru a checksum link.

- **Possible paypal fix to avoid sending 500 errors from ipn triggerred by
  one-off payment
  ([13867](https://github.com/civicrm/civicrm-core/pull/13867))**

  Fixes paypal system sending a warning email when there is a failed IPN call
  (500 errors from ipn triggered by non-recurring payment).

- **Missing links to cancel recurring payments (regression .. sorta)
  ([dev/core#704](https://lab.civicrm.org/dev/core/issues/704):
  [13935](https://github.com/civicrm/civicrm-core/pull/13935))**

  Fixes a 5.8 regression where the cancel link became unavailable on recurring
  contributions with no attached payment processor id.

- **Improve flushing after creating a processor so it can be used for a
  recurring in the same run
  ([14009](https://github.com/civicrm/civicrm-core/pull/14009))**

  This change ensures tests run properly by flushing caches when creating a
  payment processor.

- **Flush ContributionRecur static cache when flushing processors
  ([13962](https://github.com/civicrm/civicrm-core/pull/13962))**

  Ensures a (new) static cache is flushed when creating a processor, mostly
  useful for unit testing.

- **Display test contributions when viewing contributions related to a test
  recurring contribution
  ([13779](https://github.com/civicrm/civicrm-core/pull/13779))**

### CiviEvent

- **Cancelling or An Error during event registration payment should cancel all
  additional participates
  ([dev/core#253](https://lab.civicrm.org/dev/core/issues/253):
  [12457](https://github.com/civicrm/civicrm-core/pull/12457))**

  This fixes a bug where if a user was registering for an event with additional
  participants, and for some reason the payment failed or the user decided to
  cancel the payment, only the main user participant record was set to
  "canceled", the rest of the additional participants would have the status
  "pending incomplete transaction" so that all participant statuses are changed
  to "canceled".

- **Event Cart: Fix PHP 7.2 fatal error (pass by ref)
  ([13927](https://github.com/civicrm/civicrm-core/pull/13927))**

  Fixes a Fatal error when using Event cart and PHP 7.2, specifically when
  checking out.

- **CRM/Event - Fix participant note search parameter being ignored
  ([13697](https://github.com/civicrm/civicrm-core/pull/13697))**

  This change ensures that when searching by "Participant Note" on the "Search
  Builder form the filter is applied.

- **BAO_Participant - Use default status if not specified for create
  ([13875](https://github.com/civicrm/civicrm-core/pull/13875))**

  This change fixes a api4 test failure by ensuring that the default value of
  'status_id' is respected by the Participant BAO. Before this change the
  'status_id' had a default value and thus was not required but the BAO would
  not work correctly if a 'status_id' was not supplied. After this change the
  'status_id' default is respected and the BAO works regardless of whether the
  'status_id' is supplied.

### CiviGrant

- **PHP Error on Grant Detail Report
  ([13883](https://github.com/civicrm/civicrm-core/pull/13883))**

  Fixes a PHP error when viewing the "Grant Detail Report" for sites running PHP
  7.2.

### CiviMail

- **Do not track CSS URLs
  ([dev/core#836](https://lab.civicrm.org/dev/core/issues/836):
  [13920](https://github.com/civicrm/civicrm-core/pull/13920))**

  Ensures CiviMail does not convert css URLs into trackable URLs.

- **Restore support for preview of "mailing"/"action" tokens via
  TokenProcessor/Flexmailer
  ([14156](https://github.com/civicrm/civicrm-core/pull/14156))**

### CiviMember

- **Disabling or deleting Expired status breaks membership status update
  ([13259](https://github.com/civicrm/civicrm-core/pull/13259))**

  This change ensures that deleting, disabling or renaming the "Expired"
  membership status does not cause issues when running the "Membership status
  processor" scheduled job. Before this change deleting, disabling or renaming
  the "Expired" membership status would result in the  "Membership status
  processor" scheduled job failing with the message `Finished execution of
  Membership status processor with result: Failure, Error message: A fatal error
  was triggered: One of parameters (value: ) is not of the type Integer`.

- **Fatal error to exception on Membership BAO
  ([13774](https://github.com/civicrm/civicrm-core/pull/13774))**

  This change improves experience by throwing an exception instead of a fatal
  error.

### Backdrop Integration

- **civicrm/admin/setting/uf - Fix advice about Backdrop Views
  ($database_prefix)
  ([13803](https://github.com/civicrm/civicrm-core/pull/13803))**

  This change updates the advice for configuring views on the
  `civicrm/admin/setting/uf` form so that it works for Backdrop sites.

### Drupal Integration

- **Drupal8: Can't upload images via CKEditor/kcfinder
  ([dev/drupal#42](https://lab.civicrm.org/dev/drupal/issues/42):
  [242](https://github.com/civicrm/civicrm-packages/pull/242))**

   Makes it so on Drupal 8 sites users can upload and browse images in KCFinder.

## <a name="misc"></a>Miscellany

- **Fix e-notice in IDS
  ([247](https://github.com/civicrm/civicrm-packages/pull/247))**

- **Update 7.x Drupal code to be that of the new coder style
  ([571](https://github.com/civicrm/civicrm-drupal/pull/571))**

- **Fix up to newer coder style
  ([69](https://github.com/civicrm/civicrm-backdrop/pull/69))**

- **Remove now-obsolete additionalFromClause parameter from prepareOrderBy
  ([13874](https://github.com/civicrm/civicrm-core/pull/13874))**

- **Remove switch statement that no longer switches
  ([13886](https://github.com/civicrm/civicrm-core/pull/13886))**

- **Add unit test for exporting with incomplete data
  ([13904](https://github.com/civicrm/civicrm-core/pull/13904))**

- **Delete webtests
  ([13861](https://github.com/civicrm/civicrm-core/pull/13861))**

- **Add a class to handle test entities consistently
  ([13814](https://github.com/civicrm/civicrm-core/pull/13814))**

- **Fix up composer for composer 2.0 compatibility
  ([13872](https://github.com/civicrm/civicrm-core/pull/13872))**

- **Remove log files as now supplied by composer
  ([244](https://github.com/civicrm/civicrm-packages/pull/244), [245](https://github.com/civicrm/civicrm-packages/pull/245))**

- **Remove htmlpurifier from within the IDS to facilitate it being provided by
  composer ([246](https://github.com/civicrm/civicrm-packages/pull/246))**

- **Remove Log.php require_once statements
  ([13842](https://github.com/civicrm/civicrm-core/pull/13842))**
  
- **Remove amavisd now that it is removed from the packages repository
  ([243](https://github.com/civicrm/civicrm-packages/pull/243), [13841](https://github.com/civicrm/civicrm-core/pull/13841))**

- **Upgrade htmlpurifier to 4.10 to support PHP7.2 and install via composer
  ([13840](https://github.com/civicrm/civicrm-core/pull/13840))**

- **Refactor CRM_Contact_Form_Task_PDFLetterCommon
  ([13892](https://github.com/civicrm/civicrm-core/pull/13892))**

- **Reformat test files for array format
  ([13862](https://github.com/civicrm/civicrm-core/pull/13862))**

- **Logging - attempt to fix tests
  ([13832](https://github.com/civicrm/civicrm-core/pull/13832))**

- **Try Reverting commit removing require once to see if it fixes the problem
  for api4 ([13870](https://github.com/civicrm/civicrm-core/pull/13870))**

- **Import date test
  ([13823](https://github.com/civicrm/civicrm-core/pull/13823))**

- **Add shared parent for ContributionRecur forms
  ([13931](https://github.com/civicrm/civicrm-core/pull/13931))**

- **Update PHPWord Patches to match the latest versions of their code
  ([13923](https://github.com/civicrm/civicrm-core/pull/13923))**

- **Extract assignPaymentFields
  ([13957](https://github.com/civicrm/civicrm-core/pull/13957))**

- **Move code to assign tax information into shared parent
  ([13899](https://github.com/civicrm/civicrm-core/pull/13899))**

- **Update test to reflect recently merged PR lower permission to access
  dedupecheck ([13866](https://github.com/civicrm/civicrm-core/pull/13866))**

- **Test fix ([13856](https://github.com/civicrm/civicrm-core/pull/13856))**

- **Add unit testing for activity creation when cancelling a recurring, related
  cleanup ([14000](https://github.com/civicrm/civicrm-core/pull/14000))**

- **Improve test coverage for CRM_Utils_Color::getRgb()
  ([14007](https://github.com/civicrm/civicrm-core/pull/14007))**

- **Add in tests of purifying HTML output
  ([13845](https://github.com/civicrm/civicrm-core/pull/13845))**

- **Remove more instances of ->free()
  ([dev/core#562](https://lab.civicrm.org/dev/core/issues/562):
  [13786](https://github.com/civicrm/civicrm-core/pull/13786)) CONTINUES WORK**

- **(NFC) Ensure phpcs ignores eval notice in these files as it is required
  ([14032](https://github.com/civicrm/civicrm-core/pull/14032))**

- **(NFC) Lint additional php files up to the new coder standard
  ([14025](https://github.com/civicrm/civicrm-core/pull/14025))**

- **Port code style fixes to 5.13 from master
  ([14026](https://github.com/civicrm/civicrm-core/pull/14026))**

- **(NFC) Update CRM/Core CRM/Custom CRM/Dedupe to match the new coder style
  ([14023](https://github.com/civicrm/civicrm-core/pull/14023))**

- **(NFC) Update CRM/Event folder for the new coder style
  ([14019](https://github.com/civicrm/civicrm-core/pull/14019))**

- **(NFC) update CRM/Contribute to be the new coder standard
  ([14021](https://github.com/civicrm/civicrm-core/pull/14021))**

- **(NFC) Update CRM/Friend CRM/Grant CRM/Group CRM/Mailing to be up to d…
  ([14016](https://github.com/civicrm/civicrm-core/pull/14016))**

- **(NFC) Update CRM/Badge CRM/Campaign CRM/Case to be up to date with a …
  ([14017](https://github.com/civicrm/civicrm-core/pull/14017))**

- **(NFC) Update CRM/Cxn CRM/Dashlet CRM/Export CRM/Extension and CRM/Fin…
  ([14018](https://github.com/civicrm/civicrm-core/pull/14018))**

- **[NFC] Short array syntax - auto convert settings dir
  ([14005](https://github.com/civicrm/civicrm-core/pull/14005))**

- **(NFC) SchemaStructure.php - Fix up mismatch between stored+generated code
  ([14046](https://github.com/civicrm/civicrm-core/pull/14046))**

- **Arg I put these fixes in 5.12 & master while trying for 5.13
  ([14036](https://github.com/civicrm/civicrm-core/pull/14036))**

- **(NFC) Update CRM/Member CRM/Note CRM/Logging CRM/Import and CRM/Price…
  ([13992](https://github.com/civicrm/civicrm-core/pull/13992))**

- **(REF) CRM_Core_Resources - Move hook declaration from addCoreResources() to
  Container.php ([14008](https://github.com/civicrm/civicrm-core/pull/14008))**

- **(NFC) Update CRM/Activity CRM/Admin and CRM/Batch folders to be the f…
  ([13990](https://github.com/civicrm/civicrm-core/pull/13990))**

- **(NFC) Update coding style in PCP, Pledge, Profile, Queue, Report folders
  ([13987](https://github.com/civicrm/civicrm-core/pull/13987))**

- **(NFC) Update CRM/SMS/ CRM/UF/ CRM/Upgrade/ CRM/Tag/ to be up to speed…
  ([13986](https://github.com/civicrm/civicrm-core/pull/13986))**

- **(NFC) Bring CRM/Utils folder up to future coder standards
  ([13985](https://github.com/civicrm/civicrm-core/pull/13985))**

- **(NFC) Set _log and _tableName variables to be public
  ([13988](https://github.com/civicrm/civicrm-core/pull/13988))**

- **Grammar fixes
  ([13960](https://github.com/civicrm/civicrm-core/pull/13960))**

- **Update Unit test styling to cover the future coder version
  ([13983](https://github.com/civicrm/civicrm-core/pull/13983))**

- **(NFC) Fix location of comment to match future coder version
  ([13984](https://github.com/civicrm/civicrm-core/pull/13984))**

- **(NFC) Bring up API folder to style of future coder checker
  ([13980](https://github.com/civicrm/civicrm-core/pull/13980))**

- **(NFC) Upgrade Civi Folder to the new coder version
  ([13981](https://github.com/civicrm/civicrm-core/pull/13981))**

- **(NFC) Update various files to pass future civicrm/coder ruleset
  ([13979](https://github.com/civicrm/civicrm-core/pull/13979))**

- **(NFC) Update various files to pass current phpcs
  ([13978](https://github.com/civicrm/civicrm-core/pull/13978))**

- **[NFC] Reformat tricksy file CRM_Mailing_BAO_Mailing
  ([13973](https://github.com/civicrm/civicrm-core/pull/13973))**

- **[NFC] Reformat tricksy file CRM/Contribute/Import/Form/MapField
  ([13974](https://github.com/civicrm/civicrm-core/pull/13974))**

- **[NFC] short array syntax Autoformat - just  the tricksy bits of CRM/Activity
  ([13969](https://github.com/civicrm/civicrm-core/pull/13969))**

- **[NFC] array format tricksie file  CRM/Admin/Form/MessageTemplates
  ([13970](https://github.com/civicrm/civicrm-core/pull/13970))**

- **[NFC] array format tricksie file CRM_Utils_Rest
  ([13971](https://github.com/civicrm/civicrm-core/pull/13971))**

- **[NFC] array formatting tricksy tricksie file (another CRM/UF/Form/Group.php)
  ([13972](https://github.com/civicrm/civicrm-core/pull/13972))**

- **[NFC] short array syntax Autoformat - just CRM/ACL dir
  ([13968](https://github.com/civicrm/civicrm-core/pull/13968))**

- **[NFC] Short array syntax - auto-format CRM directory
  ([13915](https://github.com/civicrm/civicrm-core/pull/13915))**

- **[REF] extract token functions
  ([13967](https://github.com/civicrm/civicrm-core/pull/13967))**

- **Test fix ([13949](https://github.com/civicrm/civicrm-core/pull/13949))**

- **Payment test cleanup
  ([13924](https://github.com/civicrm/civicrm-core/pull/13924))**

- **(NFC) Fix mode on files
  ([13933](https://github.com/civicrm/civicrm-core/pull/13933))**

- **[NFC] Cleanup DAO factory classes for code standards
  ([13922](https://github.com/civicrm/civicrm-core/pull/13922))**

- **NFC - Short array syntax - auto-convert ang dir
  ([13912](https://github.com/civicrm/civicrm-core/pull/13912))**

- **NFC - Short array syntax - auto-convert Civi dir
  ([13911](https://github.com/civicrm/civicrm-core/pull/13911))**

- **[NFC] Short array syntax - auto-convert api dir
  ([13909](https://github.com/civicrm/civicrm-core/pull/13909))**

- **Minor code cleanup
  ([13839](https://github.com/civicrm/civicrm-core/pull/13839))**

- **Minor code cleanup - remove unnecessary ids declaration
  ([13838](https://github.com/civicrm/civicrm-core/pull/13838))**

- **Code cleanup on membership block loop
  ([13851](https://github.com/civicrm/civicrm-core/pull/13851))**

- **[NFC] IDE formatting only
  ([13896](https://github.com/civicrm/civicrm-core/pull/13896))**

- **Minor code cleanups around invoicing assignment
  ([13857](https://github.com/civicrm/civicrm-core/pull/13857))**

- **[nfc] Reset entire session object between tests
  ([13878](https://github.com/civicrm/civicrm-core/pull/13878))**

- **Fixing formatting of contributors section
  ([13860](https://github.com/civicrm/civicrm-core/pull/13860))**

- **[NFC] code formatting only
  ([13846](https://github.com/civicrm/civicrm-core/pull/13846))**

- **[NFC] Code reformatting
  ([13849](https://github.com/civicrm/civicrm-core/pull/13849))**

- **Add comments about usage for doPayment() function
  ([13812](https://github.com/civicrm/civicrm-core/pull/13812))**

- **[nfc] Attempt to improve false negatives on Logging test
  ([13829](https://github.com/civicrm/civicrm-core/pull/13829))**

- **[NFC] remove unnecessary variable
  ([13836](https://github.com/civicrm/civicrm-core/pull/13836))**

- **REF Extract case action links into a separate function to facilitate
  refactoring ([13793](https://github.com/civicrm/civicrm-core/pull/13793))**

- **NFC Whitespace cleanup MembershipBlock.tpl
  ([13830](https://github.com/civicrm/civicrm-core/pull/13830))**

- **Further cleanup on getRelatedMemberships - just get them with the api
  ([13797](https://github.com/civicrm/civicrm-core/pull/13797))**

- **[REF] small cleanups on payment.create flow.
  ([13778](https://github.com/civicrm/civicrm-core/pull/13778))**

- **[NFC] reformat Contact api file to switch to new array formatting
  ([13806](https://github.com/civicrm/civicrm-core/pull/13806))**

- **[REF] minor code simplification - remove over-handling of amount comp with
  zero ([13783](https://github.com/civicrm/civicrm-core/pull/13783))**

- **Attempted test fix
  ([13791](https://github.com/civicrm/civicrm-core/pull/13791))**

- **Remove reference to google checkout
  ([13784](https://github.com/civicrm/civicrm-core/pull/13784))**

- **[NFC] template whitespace cleanup
  ([13782](https://github.com/civicrm/civicrm-core/pull/13782))**

- **(NFC) Update for compliance with next phpcs standard
  ([577](https://github.com/civicrm/civicrm-drupal/pull/577))**

- **Lint .inc files in Drupal module folder to match newer coder standard
  ([574](https://github.com/civicrm/civicrm-drupal/pull/574))**

- **(NFC) Get phpcs to ignore the use of eval in this file as it is required
  ([575](https://github.com/civicrm/civicrm-drupal/pull/575))**

- **(NFC) Update for compliance with next phpcs standard
  ([72](https://github.com/civicrm/civicrm-backdrop/pull/72))**

- **(NFC) Lint .inc files and ensure that the eval usage in tests/phpunit…
  ([71](https://github.com/civicrm/civicrm-backdrop/pull/71))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt, Eli Lisseck; Agileware - Alok Patel,
Francis Whittle; Australian Greens - Seamus Lee; calibrate - Wouter Hechtermans;
Christian Wach; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
CompuCorp - Omar Abu Hussein; Coop SymbioTIC - Mathieu Lutfy; Dave D; Electronic
Frontier Foundation - Mark Burdett; Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit; GreenPeace Central and Eastern Europe - Patrick
Figel; JMA Consulting - Monish Deb; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Pradeep Nayak; Skvare - Mark Hanna;
Squiffle Consulting - Aidan Saunders; Stephen Palmstrom; Timbsoft Technologies -
Tunbola Ogunwande; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Aniessh Sethh; Artful Robot - Rich Lott; British
Humanist Association - Andrew West; Circle Interactive - Dave Jenkins; Shitij
Gugnani; Coop SymbioTIC - Samuel Vanhove; GValFr35; JMA Consulting - Joe Murray;
Joinery - Allen Shaw; Aivars; Korlon - Stuart Gaston; Lighthouse Design and
Consulting - Brian Shaughnessy; mcuradoc; Onyemenam Ndubuisi; Tadpole
Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
