include(Compiler/Clang)
__compiler_clang(OBJCXX)

if("x${CMAKE_OBJCXX_COMPILER_FRONTEND_VARIANT}" STREQUAL "xGNU")
  if(NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 2.1)
    set(CMAKE_OBJCXX98_STANDARD_COMPILE_OPTION "-std=c++98")
    set(CMAKE_OBJCXX98_EXTENSION_COMPILE_OPTION "-std=gnu++98")
  endif()

  if(NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 3.1)
    set(CMAKE_OBJCXX98_STANDARD__HAS_FULL_SUPPORT ON)
    set(CMAKE_OBJCXX11_STANDARD_COMPILE_OPTION "-std=c++11")
    set(CMAKE_OBJCXX11_EXTENSION_COMPILE_OPTION "-std=gnu++11")
    set(CMAKE_OBJCXX11_STANDARD__HAS_FULL_SUPPORT ON)
  elseif(NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 2.1)
    set(CMAKE_OBJCXX11_STANDARD_COMPILE_OPTION "-std=c++0x")
    set(CMAKE_OBJCXX11_EXTENSION_COMPILE_OPTION "-std=gnu++0x")
  endif()

  if(NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 3.5)
    set(CMAKE_OBJCXX14_STANDARD_COMPILE_OPTION "-std=c++14")
    set(CMAKE_OBJCXX14_EXTENSION_COMPILE_OPTION "-std=gnu++14")
    set(CMAKE_OBJCXX14_STANDARD__HAS_FULL_SUPPORT ON)
  elseif(NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 3.4)
    set(CMAKE_OBJCXX14_STANDARD_COMPILE_OPTION "-std=c++1y")
    set(CMAKE_OBJCXX14_EXTENSION_COMPILE_OPTION "-std=gnu++1y")
    set(CMAKE_OBJCXX14_STANDARD__HAS_FULL_SUPPORT ON)
  endif()

  set(_clang_version_std17 5.0)

  if (NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS "${_clang_version_std17}")
    set(CMAKE_OBJCXX17_STANDARD_COMPILE_OPTION "-std=c++17")
    set(CMAKE_OBJCXX17_EXTENSION_COMPILE_OPTION "-std=gnu++17")
  elseif (NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS 3.5)
    set(CMAKE_OBJCXX17_STANDARD_COMPILE_OPTION "-std=c++1z")
    set(CMAKE_OBJCXX17_EXTENSION_COMPILE_OPTION "-std=gnu++1z")
  endif()

  if (NOT CMAKE_OBJCXX_COMPILER_VERSION VERSION_LESS "${_clang_version_std17}")
    set(CMAKE_OBJCXX20_STANDARD_COMPILE_OPTION "-std=c++2a")
    set(CMAKE_OBJCXX20_EXTENSION_COMPILE_OPTION "-std=gnu++2a")
  endif()

  unset(_clang_version_std17)

  __compiler_check_default_language_standard(OBJCXX 2.1 98)
elseif(CMAKE_OBJCXX_COMPILER_VERSION VERSION_GREATER_EQUAL 3.9
    AND CMAKE_OBJCXX_SIMULATE_VERSION VERSION_GREATER_EQUAL 19.0)
  # This version of clang-cl and the MSVC version it simulates have
  # support for -std: flags.
  set(CMAKE_OBJCXX98_STANDARD_COMPILE_OPTION "")
  set(CMAKE_OBJCXX98_EXTENSION_COMPILE_OPTION "")
  set(CMAKE_OBJCXX98_STANDARD__HAS_FULL_SUPPORT ON)
  set(CMAKE_OBJCXX11_STANDARD_COMPILE_OPTION "")
  set(CMAKE_OBJCXX11_EXTENSION_COMPILE_OPTION "")
  set(CMAKE_OBJCXX14_STANDARD_COMPILE_OPTION "-std:c++14")
  set(CMAKE_OBJCXX14_EXTENSION_COMPILE_OPTION "-std:c++14")
  if (CMAKE_OBJCXX_COMPILER_VERSION VERSION_GREATER_EQUAL 6.0)
    set(CMAKE_OBJCXX17_STANDARD_COMPILE_OPTION "-std:c++17")
    set(CMAKE_OBJCXX17_EXTENSION_COMPILE_OPTION "-std:c++17")
    set(CMAKE_OBJCXX20_STANDARD_COMPILE_OPTION "-std:c++latest")
    set(CMAKE_OBJCXX20_EXTENSION_COMPILE_OPTION "-std:c++latest")
  else()
    set(CMAKE_OBJCXX17_STANDARD_COMPILE_OPTION "-std:c++latest")
    set(CMAKE_OBJCXX17_EXTENSION_COMPILE_OPTION "-std:c++latest")
  endif()

  __compiler_check_default_language_standard(OBJCXX 3.9 14)
endif()
