/****************************************************************************
 *    lib/c/FluentDefinition.cpp - This file is part of coala				*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "FluentDefinition.h"

using namespace C;

FluentDefinition::FluentDefinition(int line, Formula* fluent_list, Types* types) : Statement(line, types) {
	F_ = fluent_list;
}

FluentDefinition::~FluentDefinition ( ) { }

void FluentDefinition::print(Printer* p, bool ltl=false) {
	string idle = "idle("+p->T+"-1) :- ";

	for(vector<Formula*>::iterator n = F_->begin(); n != F_->end(); ++n) {
		FluentAction* f = (FluentAction*) *n;

		p->setSection('b');
		
		string fluent = f->print(p, "0");
		set<Variable*>* vars = f->getVariables();
		
		if(p->no_direct_enc) {
			p->add("fluent(" + fluent + ")");
			if(!vars->empty()) {
				p->add(" :- ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
		}
		else {
			// fluent_f(0) :- not -fluent_f(0)
			p->add(fluent + " :- not " + p->neg + fluent);
			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
			
			// -fluent_f(0) :- not fluent_f(0).
			p->add(p->neg + fluent + " :- not " + fluent);
			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");
		
			if(p->debug > 0) {
				p->add("#show fluent_" + f->getName() + "(" + createTempArgs(vars->size()) + ").\n");
			}
	
			// :- f1_fluent(T-1), neg_f1_fluent(T-1).
			if(p->fake_neg) {
				string T;
				
				// print constraint twice: for T=0 and T>0
				for(int i = 1; i <= 2; ++i) {
					if(i == 1) {
							p->setSection('b');
						T = "0";
					}
						else {
						p->setSection('c');
						T = p->T;
					}
					
						p->add(":- " + f->print(p, T) + ", " + p->neg + f->print(p, T));
					if(!vars->empty()) {
						p->add(", ");
						types_.print(p, vars, line_);
						}
					p->add(".\n");
				}
				if(p->debug > 1) {
					p->setSection('b');
					p->add("#show " + p->neg + "fluent_" + f->getName() + "(" + createTempArgs(vars->size()) + ").\n");
				}
			}
			
			p->setSection('c');
			
			// completeness condition
			p->add(":- not " + f->print(p, p->T) + ", not " + p->neg + f->print(p, p->T));
			if(!vars->empty()) {
				p->add(", ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");

			// print LTL idle condition
			if(ltl) {
				// % idle if no fluents changed
				p->add("idle("+ f->getNameWithArgs() +","+p->T+"-1) :- ");
				p->add(f->print(p, p->T+"-1") + ", ");
				p->add(f->print(p, p->T));
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");

				p->add("idle("+ f->getNameWithArgs() +","+p->T+"-1) :- ");
				p->add(p->neg + f->print(p, p->T+"-1") + ", ");
				p->add(p->neg + f->print(p, p->T));
				if(!vars->empty()) {
					p->add(", ");
					types_.print(p, vars, line_);
				}
				p->add(".\n");

				if(idle != "idle("+p->T+"-1) :- ") idle += ", ";
				idle += "idle(" + f->getNameWithArgs() + ","+p->T+"-1)";
				if(!vars->empty()) {
					idle += " : " + types_.getAsString(p, vars, line_);
				}
			}
			
		} // end else: direct encoding
		delete vars;
	}
	if(!p->no_direct_enc && ltl) p->add(idle + ".\n");
}
