/****************************************************************************
 *    lib/c/Statement.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Statement.h"

using namespace C;

Statement::Statement(int line, Types* types) {
	if(types) {
		types_ = *types;
		//delete types;
	}
	else types_ = Types();
	
	line_ = line;
}

Statement::~Statement() { }


void Statement::print ( )
{
}

template <class T>
void Statement::printIdentifiers(Printer* p, T* I, set<Variable*>* vars) {
	if(I->empty()) {
		p->add("\"true\"");
	}
	else if(I->size() == 1) {
		p->add(I->at(0)->print(p, p->T));
		
		// get the vars
		set<Variable*>* tmp_vars = I->at(0)->getVariables();
		if(!tmp_vars->empty())
			vars->insert(tmp_vars->begin(), tmp_vars->end());
	}
	else {
		p->add("and(");
		for(typename T::iterator n = I->begin(); n != I->end(); ++n) {
			p->add((*n)->print(p, p->T));
			if(n != I->end()-1) p->add(",");
			
			// get the vars
			set<Variable*>* tmp_vars = (*n)->getVariables();
			if(!tmp_vars->empty())
				vars->insert(tmp_vars->begin(), tmp_vars->end());
		}
		p->add(")");
	}
}

template void Statement::printIdentifiers< vector<FluentAction*> >(Printer* p, vector<FluentAction*>* I, set<Variable*>* vars);

string Statement::createTempArgs(int num) {
	string result = "";

	for(int i = 1; i <= num; i++) {
		stringstream i_str;
		
		i_str << i;
		
		result += "X" + i_str.str() + ",";
	}
	
	return result + "T";
}
