/****************************************************************************
 *    lib/c_taid/compiler.cpp - This file is part of coala					*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "compiler.h"

namespace C_taid {

Compiler::Compiler(Coala::CompilerOptions* options) : CtaidParser(options) {
	change_input(options->getInputStream());
}

Compiler::~Compiler() {
}

int Compiler::compile() {
	return yyparse();
}

int Compiler::yylex() {
	int token = lexer.yylex();

	if(token == IDENTIFIER)	yylval.istring = new string(lexer.YYText());
	else {
		if(token == NEG_IDENTI)	{
			// remove leading negation sign '-' from fluent
			string *tmp_str = new string(lexer.YYText());
			tmp_str->erase(0,1); 
			
			yylval.istring = tmp_str;
		}
		else {
			if(token == NUMBER)	yylval.number  = atoi(lexer.YYText());
		}
	}
	
	yylloc.first_line = lexer.lineno();
	yylloc.last_line = lexer.lineno();
	yylloc.text = (char *)lexer.YYText();

	return token;
}

void Compiler::yyerror(char *m) {
    if(strcmp(yylloc.text, "\n") == 0) yylloc.text = (char*)"[newline]";
	cerr << "\n\ncoala: Error: Syntax error in line "<<yylloc.first_line<<" before token '"<<yylloc.text<<"'.\n";
	yyparse();
}

void Compiler::change_input(std::istream *new_in) {
	lexer.switch_streams(new_in, 0);
}

}
