#!/bin/sh
#
# Copyright (c) 2008, 2011, 2017  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'

echo '1..11'

# First, make sure '-q features' reports 'BASE=...'
all="$($CONFGET -q features)"
if [ -n "$all" ]; then
	echo 'ok 1'
else
	echo 'not ok 1 -q features did not output anything'
fi

if [ "${all%%=*}" = 'BASE' ]; then
	base_and_all="${all#BASE=}"
else
	base_and_all="${all#* BASE=}"
fi
if [ "$base_and_all" != "$all" ]; then
	echo 'ok 2'
else
	echo "not ok 2 -q features did not contain 'BASE=': $all"
fi

just_base="${base_and_all%% *}"
if [ -n "$just_base" ]; then
	echo 'ok 3'
else
	echo "not ok 3 -q features contained an empty 'BASE=': $all"
fi

second_base="${base_and_all#* BASE=}"
if [ "$base_and_all" = "$second_base" ]; then
	echo 'ok 4'
else
	echo "not ok 4 -q features contained more than one 'BASE=': $all"
fi

# Now check that '-q feature BASE' outputs BASE
base="$($CONFGET -q feature BASE)"
if [ "$base" = "$just_base" ]; then
	echo 'ok 5'
else
	echo "not ok 5 -q feature BASE did not return the same string as in -q features: '$just_base' vs '$base'"
fi

# Now for some failure cases...
res=0
out="$($CONFGET -q features something 2>/dev/null)" || res="$?"
if [ "$res" -ne 0 ]; then
	echo 'ok 6'
else
	echo "not ok 6 '-q features' with an argument succeeded"
fi
if [ "$out" = '' ]; then
	echo 'ok 7'
else
	echo "not ok 7 '-q features' with an argument output something: $out"
fi

res=0
out="$($CONFGET -q feature 2>/dev/null)" || res="$?"
if [ "$res" -ne 0 ]; then
	echo 'ok 8'
else
	echo "not ok 8 '-q feature' with no argument succeeded"
fi
if [ "$out" = '' ]; then
	echo 'ok 9'
else
	echo "not ok 9 '-q feature' with no argument output something: $out"
fi

res=0
out="$($CONFGET -q feature BASE something 2>/dev/null)" || res="$?"
if [ "$res" -ne 0 ]; then
	echo 'ok 10'
else
	echo "not ok 10 '-q feature' with two arguments succeeded"
fi
if [ "$out" = '' ]; then
	echo 'ok 11'
else
	echo "not ok 11 '-q feature' with two arguments output something: $out"
fi
