/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <rbtcollins@hotmail.com>
 *
 */

#ifndef   _FILESYSTEMCOMPOSITE_H_
#define   _FILESYSTEMCOMPOSITE_H_

#include <string>
#include <sys/stat.h>
using namespace std;

class FileSystemVisitor;

class Path;
/* An aggregate representing all the files and folders in a given directory */
class FileSystemComposite
{
public:
  static FileSystemComposite *CreateFromPath (string const &path);
  static bool Exists(string const &aPath);
  virtual ~FileSystemComposite (){}
  virtual void visit (FileSystemVisitor &) = 0;
  virtual Path const &path() const = 0;
private:
};

#endif // _FILESYSTEMCOMPOSITE_H_
