/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef _FSP_EXT_MEMORY_PPR_HOB_H_
#define _FSP_EXT_MEMORY_PPR_HOB_H_

#include "FspGlobals.h"

#define FSP_EXT_MEMORY_PPR_HOB_GUID   { 0x3956C6DA, 0x35B6, 0x4036, { 0x93, 0xE4, 0xB1, 0x51, 0x38, 0x60, 0x21, 0x1E } }

#pragma pack(1)

typedef struct FspExtPprAddr {
  UINT8               Status;
  UINT8               ErrorType;
  UINT8               Socket;
  UINT8               MemoryController;
  UINT8               Channel;
  UINT8               Dimm;
  UINT8               Bank;
  UINT32              Row;
  UINT8               Rank;
} FSP_EXT_PPR_ADDR;

typedef struct FspExtPprDdrInfo {
  UINT8               Count;
  FSP_EXT_PPR_ADDR    PprAddresses[FSP_MAX_PPR_ADDR_ENTRIES_DDR];
} FSP_EXT_DDR_PPR_INFO;

typedef struct FspExtMemoryPprData {
  FSP_EXT_DDR_PPR_INFO          DdrPprInfo;
} FSP_EXT_MEMORY_PPR_DATA;

typedef struct FspExtMemoryPprHob {
  FSP_EXT_HEADER                Header;
  FSP_EXT_MEMORY_PPR_DATA       Data;
} FSP_EXT_MEMORY_PPR_HOB;

#pragma pack()

#endif // _FSP_EXT_MEMORY_PPR_HOB_H_
