/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class KeyFn
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext = null;
    private int keyFingerprint = -1;
    private transient boolean checked = false;
    private transient boolean internal = false;

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        try {
            return super.typeCheck(staticContext, itemType);
        }
        catch (XPathException xPathException) {
            if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                DynamicError dynamicError = new DynamicError("Cannot call the key() function when there is no context node");
                dynamicError.setErrorCode("XTDE1270");
                throw dynamicError;
            }
            throw xPathException;
        }
    }

    public static KeyFn internalKeyCall(NamePool namePool, int n, String string, Expression expression, Expression expression2) {
        KeyFn keyFn = new KeyFn();
        Expression[] expressionArray = new Expression[]{new StringValue(string), expression, expression2};
        keyFn.argument = expressionArray;
        keyFn.keyFingerprint = n;
        keyFn.checked = true;
        keyFn.internal = true;
        keyFn.setDetails(StandardFunction.getFunction("key", 3));
        keyFn.setFunctionNameCode(namePool.allocate("fn", "http://www.w3.org/2005/xpath-functions", "key"));
        keyFn.adoptChildExpression(expression);
        keyFn.adoptChildExpression(expression2);
        return keyFn;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (!this.internal && !(staticContext instanceof ExpressionContext)) {
            throw new StaticError("The key() function is available only in XPath expressions within an XSLT stylesheet");
        }
        KeyFn keyFn = (KeyFn)super.simplify(staticContext);
        if (this.argument.length == 2) {
            keyFn.addContextDocumentArgument(2, "key");
        }
        return keyFn;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[1] = ExpressionTool.unsorted(optimizer, this.argument[1], false);
        if (this.argument[0] instanceof StringValue) {
            try {
                this.keyFingerprint = ((ExpressionContext)staticContext).getFingerprint(((StringValue)this.argument[0]).getStringValue(), false);
            }
            catch (XPathException xPathException) {
                StaticError staticError = new StaticError("Error in key name " + ((StringValue)this.argument[0]).getStringValue() + ": " + xPathException.getMessage());
                staticError.setLocator(this);
                staticError.setErrorCode("XTDE1260");
                throw staticError;
            }
            if (this.keyFingerprint == -1) {
                StaticError staticError = new StaticError("Key " + ((StringValue)this.argument[0]).getStringValue() + " has not been defined");
                staticError.setLocator(this);
                staticError.setErrorCode("XTDE1260");
                throw staticError;
            }
        } else {
            this.nsContext = staticContext.getNamespaceResolver();
        }
    }

    public int computeSpecialProperties() {
        int n = 0xC20000;
        if (this.getNumberOfArguments() == 2 || (this.argument[2].getSpecialProperties() & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator;
        Object object;
        Object object2;
        Item item;
        Controller controller = xPathContext.getController();
        try {
            item = this.argument[2].evaluateItem(xPathContext);
        }
        catch (XPathException xPathException) {
            if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                this.dynamicError("Cannot call the key() function when there is no context item", "XTDE1270", xPathContext);
                return null;
            }
            if ("XPDY0050".equals(xPathException.getErrorCodeLocalPart())) {
                this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", xPathContext);
                return null;
            }
            if ("XPTY0020".equals(xPathException.getErrorCodeLocalPart())) {
                this.dynamicError("Cannot call the key() function when the context item is an atomic value", "XTDE1270", xPathContext);
                return null;
            }
            throw xPathException;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        NodeInfo nodeInfo2 = nodeInfo.getRoot();
        if (nodeInfo2.getNodeKind() != 9) {
            this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", xPathContext);
            return null;
        }
        DocumentInfo documentInfo = (DocumentInfo)nodeInfo2;
        int n = this.keyFingerprint;
        if (n == -1) {
            object2 = this.argument[0].evaluateItem(xPathContext).getStringValue();
            try {
                n = controller.getNamePool().allocateLexicalQName((CharSequence)object2, false, this.nsContext, controller.getConfiguration().getNameChecker()) & 0xFFFFF;
            }
            catch (XPathException xPathException) {
                this.dynamicError("Invalid key name: " + xPathException.getMessage(), "XTDE1260", xPathContext);
            }
            if (n == -1) {
                this.dynamicError("Key '" + (String)object2 + "' has not been defined", "XTDE1260", xPathContext);
                return null;
            }
        }
        if (Cardinality.allowsMany((object2 = this.argument[1]).getCardinality())) {
            object = xPathContext;
            final DocumentInfo documentInfo2 = documentInfo;
            final KeyManager keyManager = controller.getKeyManager();
            MappingFunction mappingFunction = new MappingFunction((XPathContext)object){
                private final /* synthetic */ XPathContext val$keyContext;
                {
                    this.val$keyContext = xPathContext;
                }

                public Object map(Item item) throws XPathException {
                    return keyManager.selectByKey(KeyFn.this.keyFingerprint, documentInfo2, (AtomicValue)item, this.val$keyContext);
                }
            };
            SequenceIterator sequenceIterator2 = this.argument[1].iterate(xPathContext);
            MappingIterator mappingIterator = new MappingIterator(sequenceIterator2, mappingFunction);
            sequenceIterator = new DocumentOrderIterator(mappingIterator, LocalOrderComparer.getInstance());
        } else {
            try {
                object = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
                if (object == null) {
                    return EmptyIterator.getInstance();
                }
                KeyManager keyManager = controller.getKeyManager();
                sequenceIterator = keyManager.selectByKey(n, documentInfo, (AtomicValue)object, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
        if (nodeInfo == documentInfo) {
            return sequenceIterator;
        }
        object = new SubtreeFilter();
        ((SubtreeFilter)object).origin = nodeInfo;
        return new ItemMappingIterator(sequenceIterator, (ItemMappingFunction)object);
    }

    private static class SubtreeFilter
    implements ItemMappingFunction {
        public NodeInfo origin;

        private SubtreeFilter() {
        }

        public Item map(Item item) throws XPathException {
            if (Navigator.isAncestorOrSelf(this.origin, (NodeInfo)item)) {
                return item;
            }
            return null;
        }
    }
}

