/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.Err;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private boolean ignoreNaN = false;

    public void setIgnoreNaN(boolean bl) {
        this.ignoreNaN = bl;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression != this) {
            return expression;
        }
        if (this.getNumberOfArguments() == 1) {
            int n = this.argument[0].getCardinality();
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            if (!Cardinality.allowsMany(n) && typeHierarchy.isSubType(this.argument[0].getItemType(typeHierarchy), Type.NUMBER_TYPE)) {
                ComputedExpression.setParentExpression(this.argument[0], this.getParentExpression());
                return this.argument[0];
            }
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        AtomicValue atomicValue2;
        AtomicValue atomicValue3;
        SequenceIterator sequenceIterator;
        boolean bl;
        boolean bl2;
        boolean bl3;
        TypeHierarchy typeHierarchy;
        Serializable serializable;
        block32: {
            block31: {
                serializable = this.getAtomicComparer(1, xPathContext);
                typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
                bl3 = false;
                bl2 = false;
                bl = false;
                if (this.operation == 3) {
                    serializable = new DescendingComparer((Comparator)((Object)serializable));
                }
                sequenceIterator = this.argument[0].iterate(xPathContext);
                do {
                    if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                        return null;
                    }
                    atomicValue2 = atomicValue3.getPrimitiveValue();
                    if (atomicValue3 instanceof UntypedAtomicValue) {
                        try {
                            atomicValue2 = atomicValue3 = new DoubleValue(Value.stringToNumber(atomicValue3.getStringValueCS()));
                            bl3 = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.dynamicError("Failure converting " + Err.wrap(atomicValue3.getStringValueCS()) + " to a number", "FORG0001", xPathContext);
                        }
                    } else if (atomicValue2 instanceof DoubleValue) {
                        bl3 = true;
                    } else if (atomicValue2 instanceof FloatValue) {
                        bl2 = true;
                    }
                    if (!(atomicValue2 instanceof NumericValue) || !((NumericValue)atomicValue2).isNaN()) break block31;
                } while (this.ignoreNaN);
                if (atomicValue2 instanceof DoubleValue) {
                    return atomicValue3;
                }
                bl = true;
                atomicValue3 = FloatValue.NaN;
                break block32;
            }
            int n = atomicValue2.getItemType(typeHierarchy).getPrimitiveType();
            if (!Type.isOrdered(n)) {
                this.typeError("Type " + atomicValue3.getItemType(typeHierarchy) + " is not an ordered type", "FORG0006", xPathContext);
                return null;
            }
        }
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            AtomicValue atomicValue4 = atomicValue;
            atomicValue2 = atomicValue4.getPrimitiveValue();
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue4 = new DoubleValue(Value.stringToNumber(atomicValue.getStringValueCS()));
                    if (bl) {
                        return DoubleValue.NaN;
                    }
                    atomicValue2 = atomicValue4;
                    bl3 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    this.dynamicError("Failure converting " + Err.wrap(atomicValue.getStringValueCS()) + " to a number", "FORG0001", xPathContext);
                }
            } else if (atomicValue2 instanceof DoubleValue) {
                if (bl) {
                    return DoubleValue.NaN;
                }
                bl3 = true;
            } else if (atomicValue2 instanceof FloatValue) {
                bl2 = true;
            }
            if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
                if (this.ignoreNaN) continue;
                if (bl3) {
                    return DoubleValue.NaN;
                }
                bl = true;
                continue;
            }
            try {
                if (serializable.compare(atomicValue2, atomicValue3) >= 0) continue;
                atomicValue3 = atomicValue4;
            }
            catch (ClassCastException classCastException) {
                this.typeError("Cannot compare " + atomicValue3.getItemType(typeHierarchy) + " with " + atomicValue4.getItemType(typeHierarchy), "FORG0006", xPathContext);
                return null;
            }
        }
        if (bl) {
            return FloatValue.NaN;
        }
        if (bl3) {
            if (!(atomicValue3 instanceof DoubleValue)) {
                atomicValue3 = atomicValue3.convert(517, xPathContext);
            }
        } else if (bl2 && !(atomicValue3 instanceof FloatValue)) {
            atomicValue3 = atomicValue3.convert(516, xPathContext);
        }
        return atomicValue3;
    }
}

