/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class FixedElement
extends ElementCreator {
    private int nameCode;
    protected int[] namespaceCodes = null;
    private ItemType itemType;

    public FixedElement(int n, int[] nArray, boolean bl, SchemaType schemaType, int n2) {
        this.nameCode = n;
        this.namespaceCodes = nArray;
        this.inheritNamespaces = bl;
        this.setSchemaType(schemaType);
        this.validation = n2;
        this.validating = schemaType != null || n2 != 3;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setConstructType(2006);
        instructionDetails.setObjectNameCode(this.nameCode);
        return instructionDetails;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Configuration configuration = staticContext.getConfiguration();
        this.setLazyConstruction(configuration.isLazyConstructionMode());
        this.validating &= configuration.isSchemaAware(52);
        this.itemType = this.computeFixedElementItemType(this, staticContext, this.validation, this.getSchemaType(), this.nameCode, this.content);
        return super.simplify(staticContext);
    }

    private ItemType computeFixedElementItemType(FixedElement fixedElement, StaticContext staticContext, int n, SchemaType schemaType, int n2, Expression expression) throws XPathException {
        CombinedNodeTest combinedNodeTest;
        Configuration configuration = staticContext.getConfiguration();
        if (schemaType == null) {
            if (n == 1) {
                SchemaDeclaration schemaDeclaration = configuration.getElementDeclaration(n2 & 0xFFFFF);
                if (schemaDeclaration == null) {
                    StaticError staticError = new StaticError("There is no global element declaration for " + staticContext.getNamePool().getDisplayName(n2) + ", so strict validation will fail");
                    staticError.setErrorCode(fixedElement.isXSLT() ? "XTTE1512" : "XQDY0027");
                    staticError.setIsTypeError(true);
                    staticError.setLocator(fixedElement);
                    throw staticError;
                }
                schemaType = schemaDeclaration.getType();
                fixedElement.setSchemaType(schemaType);
                combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, schemaType, configuration));
                try {
                    schemaType.analyzeContentExpression(expression, 1, staticContext);
                }
                catch (XPathException xPathException) {
                    xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1510" : "XQDY0027");
                    xPathException.setLocator(fixedElement);
                    throw xPathException;
                }
                SchemaType schemaType2 = fixedElement.getXSIType(staticContext);
                if (schemaType2 != null) {
                    schemaType2.analyzeContentExpression(expression, 1, staticContext);
                    try {
                        configuration.checkTypeDerivationIsOK(schemaType2, schemaType, 0);
                    }
                    catch (SchemaException schemaException) {
                        throw new StaticError("The specified xsi:type " + schemaType2.getDescription() + " is not validly derived from the required type " + schemaType.getDescription());
                    }
                }
            } else if (n == 2) {
                SchemaDeclaration schemaDeclaration = configuration.getElementDeclaration(n2 & 0xFFFFF);
                if (schemaDeclaration == null) {
                    staticContext.issueWarning("There is no global element declaration for " + staticContext.getNamePool().getDisplayName(n2) + ", so lax validation has no effect", fixedElement);
                    combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(641), configuration));
                } else {
                    schemaType = schemaDeclaration.getType();
                    fixedElement.setSchemaType(schemaType);
                    combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, fixedElement.getSchemaType(), configuration));
                    try {
                        schemaType.analyzeContentExpression(expression, 1, staticContext);
                    }
                    catch (XPathException xPathException) {
                        xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1515" : "XQDY0027");
                        xPathException.setLocator(fixedElement);
                        throw xPathException;
                    }
                }
            } else {
                combinedNodeTest = n == 3 ? new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(572), configuration)) : new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, BuiltInSchemaFactory.getSchemaType(641), configuration));
            }
        } else {
            combinedNodeTest = new CombinedNodeTest(new NameTest(1, n2, staticContext.getNamePool()), 23, new ContentTypeTest(1, schemaType, configuration));
            try {
                schemaType.analyzeContentExpression(expression, 1, staticContext);
            }
            catch (XPathException xPathException) {
                xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1540" : "XQDY0027");
                xPathException.setLocator(fixedElement);
                throw xPathException;
            }
        }
        return combinedNodeTest;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType == null) {
            return super.getItemType(typeHierarchy);
        }
        return this.itemType;
    }

    public int getNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    public String getNewBaseURI(XPathContext xPathContext) {
        return this.getBaseURI();
    }

    private SchemaType getXSIType(StaticContext staticContext) throws XPathException {
        if (this.content instanceof FixedAttribute) {
            return this.testForXSIType((FixedAttribute)this.content, staticContext);
        }
        if (this.content instanceof Block) {
            Iterator iterator = this.content.iterateSubExpressions();
            while (iterator.hasNext()) {
                SchemaType schemaType;
                Expression expression = (Expression)iterator.next();
                if (!(expression instanceof FixedAttribute) || (schemaType = this.testForXSIType((FixedAttribute)expression, staticContext)) == null) continue;
                return schemaType;
            }
            return null;
        }
        return null;
    }

    private SchemaType testForXSIType(FixedAttribute fixedAttribute, StaticContext staticContext) throws XPathException {
        Expression expression;
        int n = fixedAttribute.evaluateNameCode(null) & 0xFFFFF;
        if (n == 769 && (expression = fixedAttribute.getSelect()) instanceof StringValue) {
            try {
                NamePool namePool = staticContext.getNamePool();
                String[] stringArray = staticContext.getConfiguration().getNameChecker().getQNameParts(((StringValue)expression).getStringValue());
                int n2 = -1;
                for (int i = 0; i < this.namespaceCodes.length; ++i) {
                    String string = namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]);
                    if (!string.equals(stringArray[0])) continue;
                    n2 = this.namespaceCodes[i] & 0xFFFF;
                    break;
                }
                if (n2 == -1) {
                    return null;
                }
                String string = namePool.getURIFromURICode((short)n2);
                int n3 = namePool.allocate(stringArray[0], string, stringArray[1]) & 0xFFFFF;
                SchemaType schemaType = staticContext.getConfiguration().getSchemaType(n3);
                return schemaType;
            }
            catch (QNameException qNameException) {
                throw new StaticError(qNameException.getMessage());
            }
        }
        return null;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        SchemaType schemaType2;
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element is of simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        if (((ComplexType)schemaType).isSimpleContent()) {
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element has a complex type with simple content");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        try {
            schemaType2 = ((ComplexType)schemaType).getElementParticleType(this.nameCode & 0xFFFFF);
        }
        catch (SchemaException schemaException) {
            throw new StaticError(schemaException);
        }
        if (schemaType2 == null) {
            StaticError staticError = new StaticError("Element " + staticContext.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            staticError.setErrorCode(this.isXSLT() ? "XTTE1510" : "XQDY0027");
            throw staticError;
        }
        if (schemaType2 instanceof AnyType) {
            return;
        }
        try {
            this.content.checkPermittedContents(schemaType2, staticContext, true);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator() == xPathException) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.namespaceCodes != null) {
            for (int i = 0; i < this.namespaceCodes.length; ++i) {
                receiver.namespace(this.namespaceCodes[i], 0);
            }
        }
    }

    public int[] getActiveNamespaces() {
        return this.namespaceCodes;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "element ");
        printStream.println(ExpressionTool.indent(n + 1) + "name " + (configuration == null ? this.nameCode + "" : configuration.getNamePool().getDisplayName(this.nameCode)));
        printStream.println(ExpressionTool.indent(n + 1) + "content");
        this.content.display(n + 1, printStream, configuration);
    }
}

