/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class TraceWrapper
extends Instruction {
    Expression child;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.child = this.child.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.child = this.child.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.child = this.child.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.child);
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = this.child.promote(promotionOffer);
        if (expression != this.child) {
            this.child = expression;
            this.adoptChildExpression(this.child);
            return this;
        }
        return this;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        TraceListener traceListener = controller.getTraceListener();
        if (controller.isTracing()) {
            traceListener.enter(this.getInstructionInfo(), xPathContext);
        }
        this.child.process(xPathContext);
        if (controller.isTracing()) {
            traceListener.leave(this.getInstructionInfo());
        }
        return null;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.child.getItemType(typeHierarchy);
    }

    public int getCardinality() {
        return this.child.getCardinality();
    }

    public int getDependencies() {
        return this.child.getDependencies();
    }

    public final boolean createsNewNodes() {
        return (this.child.getSpecialProperties() & 0x400000) == 0;
    }

    public int computeDependencies() {
        if (this.child instanceof ComputedExpression) {
            return ((ComputedExpression)this.child).computeDependencies();
        }
        return 0;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        Item item = this.child.evaluateItem(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        SequenceIterator sequenceIterator = this.child.iterate(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return sequenceIterator;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.child);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.child == expression) {
            this.child = expression2;
            bl = true;
        }
        return bl;
    }

    public int getInstructionNameCode() {
        if (this.child instanceof Instruction) {
            return ((Instruction)this.child).getInstructionNameCode();
        }
        return -1;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        this.child.display(n, printStream, configuration);
    }
}

