/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CodepointCollatingComparer
implements AtomicComparer {
    private static CodepointCollator collator = CodepointCollator.getInstance();
    private static CodepointCollatingComparer THE_INSTANCE = new CodepointCollatingComparer();

    public static CodepointCollatingComparer getInstance() {
        return THE_INSTANCE;
    }

    private CodepointCollatingComparer() {
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        StringValue stringValue = (StringValue)((AtomicValue)object).getPrimitiveValue();
        StringValue stringValue2 = (StringValue)((AtomicValue)object2).getPrimitiveValue();
        if (stringValue.containsSurrogatePairs() || stringValue2.containsSurrogatePairs()) {
            return collator.compareCS(stringValue.getStringValueCS(), stringValue2.getStringValueCS());
        }
        return stringValue.getStringValue().compareTo(stringValue2.getStringValue());
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
        StringValue stringValue2 = (StringValue)atomicValue2.getPrimitiveValue();
        return stringValue.codepointEquals(stringValue2);
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
        return new ComparisonKey(513, stringValue.getStringValue());
    }
}

