/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;

public class UseWhenStaticContext
implements XSLTStaticContext {
    public Configuration config;
    public NamespaceResolver namespaceContext;
    public FunctionLibrary functionLibrary;
    public LocationMap locationMap;
    public StyleNodeFactory nodeFactory;
    public String baseURI;
    public short defaultXPathNamespace;

    public UseWhenStaticContext(Configuration configuration, NamespaceResolver namespaceResolver) {
        this.config = configuration;
        this.namespaceContext = namespaceResolver;
        this.locationMap = new LocationMap();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(2));
        functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        if (configuration.isAllowExternalFunctions()) {
            configuration.getPlatform().addFunctionLibraries(functionLibraryList, configuration);
        }
        this.functionLibrary = functionLibraryList;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), new CollationMap(this.getConfiguration()));
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        StaticError staticError = new StaticError(string);
        staticError.setLocator(sourceLocator);
        try {
            this.config.getErrorListener().warning(staticError);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.namespaceContext.getURIForPrefix(string, false);
        if (string2 == null) {
            StaticError staticError = new StaticError("Namespace prefix '" + string + "' has not been declared");
            staticError.setErrorCode("XTDE0290");
            throw staticError;
        }
        return string2;
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public VariableReference bindVariable(int n) throws StaticError {
        StaticError staticError = new StaticError("Variables cannot be used in a use-when expression");
        staticError.setErrorCode("XPST0008");
        throw staticError;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public Comparator getCollation(String string) {
        return null;
    }

    public String getDefaultCollationName() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public short getDefaultElementNamespace() {
        return this.defaultXPathNamespace;
    }

    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isImportedSchema(String string) {
        return false;
    }

    public Set getImportedSchemaNamespaces() {
        return Collections.EMPTY_SET;
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        if (this.getConfiguration().isSchemaAware(50)) {
            return true;
        }
        if (atomicType instanceof BuiltInAtomicType) {
            return ((BuiltInAtomicType)atomicType).isAllowedInBasicXSLT();
        }
        return false;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceContext;
    }

    public boolean isElementAvailable(String string) throws XPathException {
        try {
            String[] stringArray = this.getConfiguration().getNameChecker().getQNameParts(string);
            String string2 = stringArray[0].equals("") ? this.getNamePool().getURIFromURICode(this.getDefaultElementNamespace()) : this.getURIForPrefix(stringArray[0]);
            if (this.nodeFactory == null) {
                this.nodeFactory = new StyleNodeFactory(this.config, this.config.getErrorListener());
            }
            return this.nodeFactory.isElementAvailable(string2, stringArray[1]);
        }
        catch (QNameException qNameException) {
            StaticError staticError = new StaticError("Invalid element name. " + qNameException.getMessage());
            staticError.setErrorCode("XTDE1440");
            throw staticError;
        }
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setDefaultElementNamespace(short s) {
        this.defaultXPathNamespace = s;
    }
}

