'\"
'\" Generated from file 'critcl_cutil\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2018 Andreas Kupries
'\"
.TH "critcl::cutil" n 0\&.2 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl::cutil \- CriTcl C-level Utilities
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcritcl  ?2\&.1?\fR
.sp
package require \fBcritcl::cutil  ?0\&.2?\fR
.sp
\fB::critcl::cutil::alloc\fR
.sp
\fB::critcl::cutil::assertions\fR ?\fIenable\fR?
.sp
\fB::critcl::cutil::tracer\fR ?\fIenable\fR?
.sp
\fBtype* ALLOC (type)\fR
.sp
\fBtype* ALLOC_PLUS (type, int n)\fR
.sp
\fBtype* NALLOC (type, int n)\fR
.sp
\fBtype* REALLOC (type* var, type, int n)\fR
.sp
\fBvoid FREE (type* var)\fR
.sp
\fBvoid STREP (Tcl_Obj* o, char* s, int len)\fR
.sp
\fBvoid STREP_DS (Tcl_Obj* o, Tcl_DString* ds)\fR
.sp
\fBvoid STRDUP (varname, char* str)\fR
.sp
\fBvoid ASSERT (expression, char* message\fR
.sp
\fBvoid ASSERT_BOUNDS (int index, int size)\fR
.sp
\fBvoid STOPAFTER(n)\fR
.sp
\fBTRACE_ON\fR
.sp
\fBTRACE_OFF\fR
.sp
\fBTRACE_TAG_ON  (identifier)\fR
.sp
\fBTRACE_TAG_OFF (identifier)\fR
.sp
\fBvoid TRACE_FUNC\fR
.sp
\fBvoid TRACE_TAG_FUNC (tag)\fR
.sp
\fBvoid TRACE_FUNC_VOID\fR
.sp
\fBvoid TRACE_TAG_FUNC_VOID (tag)\fR
.sp
\fBvoid TRACE_RETURN_VOID\fR
.sp
\fBvoid TRACE_TAG_RETURN_VOID (tag)\fR
.sp
\fBany TRACE_RETURN     (     char* format, any x)\fR
.sp
\fBany TRACE_TAG_RETURN (tag, char* format, any x)\fR
.sp
\fBvoid TRACE     (     char* format, \&.\&.\&.)\fR
.sp
\fBvoid TRACE_TAG (tag, char* format, \&.\&.\&.)\fR
.sp
\fBvoid TRACE_HEADER (int indent)\fR
.sp
\fBvoid TRACE_TAG_HEADER (tag, int indent)\fR
.sp
\fBvoid TRACE_CLOSER\fR
.sp
\fBvoid TRACE_TAG_CLOSER (tag)\fR
.sp
\fBvoid TRACE_ADD          (const char* format, \&.\&.\&.)\fR
.sp
\fBvoid TRACE_TAG_ADD (tag, const char* format, \&.\&.\&.)\fR
.sp
\fBvoid TRACE_PUSH_SCOPE (const char* name)\fR
.sp
\fBvoid TRACE_PUSH_FUNC\fR
.sp
\fBvoid TRACE_PUSH_POP\fR
.sp
\fBTRACE_TAG_VAR (tag)\fR
.sp
\fBTRACE_RUN (code);\fR
.sp
\fBTRACE_DO (code);\fR
.sp
\fBTRACE_TAG_DO (tag, code);\fR
.sp
.BE
.SH DESCRIPTION
.PP
\fIC Runtime In Tcl\fR, or \fICriTcl\fR , is a system for compiling C code
embedded in Tcl on the fly and either loading the resulting objects into Tcl for
immediate use or packaging them for distribution\&.  Use \fICriTcl\fR to improve
performance by rewriting in C those routines that are performance bottlenecks\&.
.PP
This document is the reference manpage for the \fBcritcl::cutil\fR
package\&. This package encapsulates a number of C-level utilites for
easier writing of memory allocations, assertions, and narrative tracing
and provides convenience commands to make these utilities accessible
to critcl projects\&.
Its intended audience are mainly developers wishing to write Tcl
packages with embedded C code\&.
.PP
This package resides in the Core Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

*================*
|Core Packages   |
| critcl         |
| critcl::util   |
*================*

+----------------+
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
+----------------+

.fi
.PE
.PP
The reason for this is that the main \fBcritcl\fR package makes
use of the facilities for narrative tracing when
\fBcritcl::config trace\fR is set, to instrument commands and
procedures\&.
.SH API
.TP
\fB::critcl::cutil::alloc\fR
This command provides a number C-preprocessor macros which make the
writing of memory allocations for structures and arrays of structures
easier\&.
.sp
When run the header file "\fIcritcl_alloc\&.h\fR" is directly made
available to the "\fI\&.critcl\fR" file containing the command, and
becomes available for use in \fB#include\fR directives of companion
C code declared via \fBcritcl::csources\fR\&.
.sp
The macros definitions and their signatures are:
.CS


    type* ALLOC (type)
    type* ALLOC_PLUS (type, int n)
    type* NALLOC (type, int n)
    type* REALLOC (type* var, type, int n)
    void  FREE (type* var)

    void STREP    (Tcl_Obj* o, char* s, int len);
    void STREP_DS (Tcl_Obj* o, Tcl_DString* ds);
    void STRDUP   (varname, char* str);

.CE
.sp
The details of the semantics are explained in section
\fBAllocation\fR\&.
.sp
The result of the command is an empty string\&.
.TP
\fB::critcl::cutil::assertions\fR ?\fIenable\fR?
This command provides a number C-preprocessor macros for the writing
of assertions in C code\&.
.sp
When invoked the header file "\fIcritcl_assert\&.h\fR" is directly
made available to the "\fI\&.critcl\fR" file containing the command, and
becomes available for use in \fB#include\fR directives of companion
C code declared via \fBcritcl::csources\fR\&.
.sp
The macro definitions and their signatures are
.CS


    void ASSERT (expression, char* message);
    void ASSERT_BOUNDS (int index, int size);

    void STOPAFTER (int n);

.CE
.sp
Note that these definitions are conditional on the existence of
the macro \fBCRITCL_ASSERT\fR\&.
Without a \fBcritcl::cflags -DCRITCL_ASSERT\fR all assertions in the
C code are quiescent and not compiled into the object file\&. In other
words, assertions can be (de)activated at will during build time, as
needed by the user\&.
.sp
For convenience this is controlled by \fIenable\fR\&. By default
(\fBfalse\fR) the facility available, but not active\&.
Using \fBtrue\fR not only makes it available, but activates it as
well\&.
.sp
The details of the semantics are explained in section
\fBAssertions\fR\&.
.sp
The result of the command is an empty string\&.
.TP
\fB::critcl::cutil::tracer\fR ?\fIenable\fR?
This command provides a number C-preprocessor macros for tracing
C-level internals\&.
.sp
When invoked the header file "\fIcritcl_trace\&.h\fR" is directly
made available to the "\fI\&.critcl\fR" file containing the command, and
becomes available for use in \fB#include\fR directives of companion
C code declared via \fBcritcl::csources\fR\&. Furthermore the "\fI\&.c\fR"
file containing the runtime support is added to the set of C companion
files
.sp
The macro definitions and their signatures are
.CS


    /* (de)activation of named logical streams\&.
     * These are declarators, not statements\&.
     */

    TRACE_ON;
    TRACE_OFF;
    TRACE_TAG_ON  (tag_identifier);
    TRACE_TAG_OFF (tag_identifier);

    /*
     * Higher level trace statements (convenience commands)
     */

    void TRACE_FUNC   (const char* format, \&.\&.\&.);
    void TRACE_FUNC_VOID;
    any  TRACE_RETURN (const char* format, any x);
    void TRACE_RETURN_VOID;
    void TRACE (const char* format, \&.\&.\&.);

    /*
     * Low-level trace statements the higher level ones above
     * are composed from\&. Scope management and output management\&.
     */

    void TRACE_PUSH_SCOPE (const char* scope);
    void TRACE_PUSH_FUNC;
    void TRACE_POP;

    void TRACE_HEADER (int indent);
    void TRACE_ADD (const char* format, \&.\&.\&.);
    void TRACE_CLOSER;

    /*
     * Convert tag to the underlying status variable\&.
     */

    TRACE_TAG_VAR (tag)

    /*
     * Conditional use of arbitrary code\&.
     */

    TRACE_RUN (code);
    TRACE_DO (code);
    TRACE_TAG_DO (code);

.CE
.sp
Note that these definitions are conditional on the existence of
the macro \fBCRITCL_TRACER\fR\&.
Without a \fBcritcl::cflags -DCRITCL_TRACER\fR all trace
functionality in the C code is quiescent and not compiled into the
object file\&. In other words, tracing can be (de)activated at will
during build time, as needed by the user\&.
.sp
For convenience this is controlled by \fIenable\fR\&. By default
(\fBfalse\fR) the facility available, but not active\&.
Using \fBtrue\fR not only makes it available, but activates it as
well\&.
Further note that the command \fBcritcl::config\fR now accepts a
boolean option \fBtrace\fR\&. Setting it activates enter/exit tracing
in all commands based on \fBcritcl::cproc\fR, with proper printing of
arguments and results\&. This implicitly activates the tracing facility
in general\&.
.sp
The details of the semantics are explained in section
\fBTracing\fR
.sp
The result of the command is an empty string\&.
.PP
.SH ALLOCATION
.TP
\fBtype* ALLOC (type)\fR
This macro allocates a single element of the given \fItype\fR and
returns a pointer to that memory\&.
.TP
\fBtype* ALLOC_PLUS (type, int n)\fR
This macro allocates a single element of the given \fItype\fR, plus an
additional \fIn\fR bytes after the structure and returns a pointer to
that memory\&.
.sp
This is for variable-sized structures of\&. An example of such
could be a generic list element structure which stores management
information in the structure itself, and the value/payload immediately
after, in the same memory block\&.
.TP
\fBtype* NALLOC (type, int n)\fR
This macro allocates \fIn\fR elements of the given \fItype\fR and
returns a pointer to that memory\&.
.TP
\fBtype* REALLOC (type* var, type, int n)\fR
This macro expands or shrinks the memory associated with the C
variable \fIvar\fR of type \fItype\fR to hold \fIn\fR elements of the
type\&. It returns a pointer to that memory\&.
Remember, a reallocation may move the data to a new location in memory
to satisfy the request\&. Returning a pointer instead of immediately
assigning it to the \fIvar\fR allows the user to validate the new
pointer before trying to use it\&.
.TP
\fBvoid FREE (type* var)\fR
This macro releases the memory referenced by the pointer variable
\fIvar\fR\&.
.TP
\fBvoid STREP (Tcl_Obj* o, char* s, int len)\fR
This macro properly sets the string representation of the Tcl object
\fIo\fR to a copy of the string \fIs\fR, expected to be of length
\fIlen\fR\&.
.TP
\fBvoid STREP_DS (Tcl_Obj* o, Tcl_DString* ds)\fR
This macro properly sets the string representation of the Tcl object
\fIo\fR to a copy of the string held by the \fBDString\fR \fIds\fR\&.
.TP
\fBvoid STRDUP (varname, char* str)\fR
This macro duplicates the string \fIstr\fR into the heap and stores
the result into the named \fBchar*\fR variable \fIvar\fR\&.
.PP
.SH ASSERTIONS
.TP
\fBvoid ASSERT (expression, char* message\fR
This macro tests the \fIexpression\fR and panics if it does not hold\&.
The specified \fImessage\fR is used as part of the panic\&.
The \fImessage\fR has to be a static string, it cannot be a variable\&.
.TP
\fBvoid ASSERT_BOUNDS (int index, int size)\fR
This macro ensures that the \fIindex\fR is in the
range \fB0\fR to \fBsize-1\fR\&.
.TP
\fBvoid STOPAFTER(n)\fR
This macro throws a panic after it is called \fIn\fR times\&.
Note, each separate instance of the macro has its own counter\&.
.PP
.SH TRACING
All output is printed to \fBstdout\fR\&.
.TP
\fBTRACE_ON\fR
.TP
\fBTRACE_OFF\fR
.TP
\fBTRACE_TAG_ON  (identifier)\fR
.TP
\fBTRACE_TAG_OFF (identifier)\fR
These "commands" are actually declarators, for use outside of
functions\&. They (de)activate specific logical streams, named either
explicitly by the user, or implicitly, refering to the current file\&.
.sp
For example:
.sp
.CS


    TRACE_TAG_ON (lexer_in);

.CE
.sp
All high- and low-level trace commands producing output have
the controlling tag as an implicit argument\&. The scope management
commands do not take tags\&.
.TP
\fBvoid TRACE_FUNC\fR
.TP
\fBvoid TRACE_TAG_FUNC (tag)\fR
.TP
\fBvoid TRACE_FUNC_VOID\fR
.TP
\fBvoid TRACE_TAG_FUNC_VOID (tag)\fR
Use these macros at the beginning of a C function to record entry into
it\&. The name of the entered function is an implicit argument
(\fB__func__\fR), forcing users to have a C99 compiler\&.\&.
.sp
The tracer's runtime maintains a stack of active functions and
expects that function return is signaled by either \fBTRACE_RETURN\fR,
\fBTRACE_RETURN_VOID\fR, or the equivalent forms taking a tag\&.
.TP
\fBvoid TRACE_RETURN_VOID\fR
.TP
\fBvoid TRACE_TAG_RETURN_VOID (tag)\fR
Use these macros instead of
.CS

return
.CE
.IP to return from a void
function\&. Beyond returning from the function this also signals the
same to the tracer's runtime, popping the last entered function from
its stack of active functions\&.
.TP
\fBany TRACE_RETURN     (     char* format, any x)\fR
.TP
\fBany TRACE_TAG_RETURN (tag, char* format, any x)\fR
Use this macro instead of
.CS

return x
.CE
.IP to return from a
non-void function\&.
Beyond returning from the function with value \fIx\fR this also
signals the same to the tracer's runtime, popping the last entered
function from its stack of active functions\&.
The \fIformat\fR is expected to be a proper formatting string for
\fBprintf\fR and analogues, able to stringify \fIx\fR\&.
.TP
\fBvoid TRACE     (     char* format, \&.\&.\&.)\fR
.TP
\fBvoid TRACE_TAG (tag, char* format, \&.\&.\&.)\fR
This macro is the trace facilities' equivalent of \fBprintf\fR,
printing arbitrary data under the control of the \fIformat\fR\&.
.sp
The printed text is closed with a newline, and indented as per
the stack of active functions\&.
.TP
\fBvoid TRACE_HEADER (int indent)\fR
.TP
\fBvoid TRACE_TAG_HEADER (tag, int indent)\fR
This is the low-level macro which prints the beginning of a trace
line\&. This prefix consists of physical location (file name and line
number), if available, indentation as per the stack of active scopes
(if activated), and the name of the active scope\&.
.TP
\fBvoid TRACE_CLOSER\fR
.TP
\fBvoid TRACE_TAG_CLOSER (tag)\fR
This is the low-level macro which prints the end of a trace
line\&.
.TP
\fBvoid TRACE_ADD          (const char* format, \&.\&.\&.)\fR
.TP
\fBvoid TRACE_TAG_ADD (tag, const char* format, \&.\&.\&.)\fR
This is the low-level macro which adds formatted data to the line\&.
.TP
\fBvoid TRACE_PUSH_SCOPE (const char* name)\fR
.TP
\fBvoid TRACE_PUSH_FUNC\fR
.TP
\fBvoid TRACE_PUSH_POP\fR
These are the low-level macros for scope management\&. The first two
forms push a new scope on the stack of active scopes, and the last
forms pops the last scope pushed\&.
.TP
\fBTRACE_TAG_VAR (tag)\fR
Helper macro converting from a tag identifier to the name of the
underlying status variable\&.
.TP
\fBTRACE_RUN (code);\fR
Conditionally insert the \fIcode\fR at compile time when the tracing
facility is activated\&.
.TP
\fBTRACE_DO (code);\fR
.TP
\fBTRACE_TAG_DO (tag, code);\fR
Insert the \fIcode\fR at compile time when the tracing facility is
activated, and execute the same when either the implicit tag for the
file or the user-specified tag is active\&.
.PP
.SH AUTHORS
Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such at \fIhttps://github\&.com/andreas-kupries/critcl\fR\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
C code, Embedded C Code, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) 2011-2018 Andreas Kupries

.fi
