/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_dnr.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:07p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:06 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_dnr.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:07p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DNR_H__
#define BCHP_DNR_H__

/***************************************************************************
 *DNR - Digital Noise Reduction Registers
 ***************************************************************************/
#define BCHP_DNR_REVISION                        0x00540400 /* Digital Noise Reduction (DNR) Revision ID */
#define BCHP_DNR_DNR_TOP_CTRL                    0x00540404 /* DNR Top Level Control */
#define BCHP_DNR_LINE_STORE_CONFIG               0x00540408 /* Line Store Configuration */
#define BCHP_DNR_SRC_PIC_SIZE                    0x0054040c /* Source Picture Size */
#define BCHP_DNR_SRC_SCAN_SETTING                0x00540410 /* Source Scan Setting */
#define BCHP_DNR_BNR_CTRL                        0x00540414 /* Block Noise Reduction Control */
#define BCHP_DNR_VBNR_CONFIG                     0x00540418 /* Vertical Block Noise Reduction Configuration */
#define BCHP_DNR_HBNR_CONFIG                     0x0054041c /* Horizontal Block Noise Reduction Configuration */
#define BCHP_DNR_MNR_CTRL                        0x00540420 /* Mosquito Noise Reduction Control */
#define BCHP_DNR_MNR_CONFIG                      0x00540424 /* Mosquito Noise Reduction Configuration */
#define BCHP_DNR_EXT_FILT_CTRL                   0x00540428 /* Extreme Filter Control */
#define BCHP_DNR_EXT_FILT_CONFIG                 0x0054042c /* Extreme Filter Configuration */
#define BCHP_DNR_FILT_EFFECT_STATUS              0x00540430 /* DNR Filters Effect Status */
#define BCHP_DNR_BVB_IN_STATUS                   0x00540434 /* DNR BVB Input Status */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR             0x00540438 /* DNR BVB Input Status Clear */
#define BCHP_DNR_SCRATCH_REGISTER                0x0054043c /* DNR Scratch Register */
#define BCHP_DNR_DNR_DEMO_SETTING                0x00540440 /* DNR Demo Setting */
#define BCHP_DNR_DCR_CTRL                        0x00540480 /* Digital Contour Removal Control */
#define BCHP_DNR_DCR_FILT_LIMIT                  0x00540484 /* DCR Filtering Limits */
#define BCHP_DNR_DCR_FILT_CONFIG                 0x00540488 /* DCR Filtering Configuration */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN          0x00540490 /* DCR Ordered Dither Pattern Control */
#define BCHP_DNR_DCR_DITH_ORDER_VALUE            0x00540494 /* DCR Ordered Dither Value */
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN         0x00540498 /* DCR Random Dither Pattern Control */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE           0x0054049c /* DCR Random Dither Values */
#define BCHP_DNR_DCR_DITH_OUT_CTRL               0x005404a0 /* DCR Dither Output Control */

/***************************************************************************
 *REVISION - Digital Noise Reduction (DNR) Revision ID
 ***************************************************************************/
/* DNR :: REVISION :: reserved0 [31:16] */
#define BCHP_DNR_REVISION_reserved0_MASK                           0xffff0000
#define BCHP_DNR_REVISION_reserved0_SHIFT                          16

/* DNR :: REVISION :: MAJOR [15:08] */
#define BCHP_DNR_REVISION_MAJOR_MASK                               0x0000ff00
#define BCHP_DNR_REVISION_MAJOR_SHIFT                              8

/* DNR :: REVISION :: MINOR [07:00] */
#define BCHP_DNR_REVISION_MINOR_MASK                               0x000000ff
#define BCHP_DNR_REVISION_MINOR_SHIFT                              0

/***************************************************************************
 *DNR_TOP_CTRL - DNR Top Level Control
 ***************************************************************************/
/* DNR :: DNR_TOP_CTRL :: reserved0 [31:02] */
#define BCHP_DNR_DNR_TOP_CTRL_reserved0_MASK                       0xfffffffc
#define BCHP_DNR_DNR_TOP_CTRL_reserved0_SHIFT                      2

/* DNR :: DNR_TOP_CTRL :: DNR_DEMO_ENABLE [01:01] */
#define BCHP_DNR_DNR_TOP_CTRL_DNR_DEMO_ENABLE_MASK                 0x00000002
#define BCHP_DNR_DNR_TOP_CTRL_DNR_DEMO_ENABLE_SHIFT                1

/* DNR :: DNR_TOP_CTRL :: DNR_ENABLE [00:00] */
#define BCHP_DNR_DNR_TOP_CTRL_DNR_ENABLE_MASK                      0x00000001
#define BCHP_DNR_DNR_TOP_CTRL_DNR_ENABLE_SHIFT                     0
#define BCHP_DNR_DNR_TOP_CTRL_DNR_ENABLE_DISABLE                   0
#define BCHP_DNR_DNR_TOP_CTRL_DNR_ENABLE_ENABLE                    1

/***************************************************************************
 *LINE_STORE_CONFIG - Line Store Configuration
 ***************************************************************************/
/* DNR :: LINE_STORE_CONFIG :: reserved0 [31:17] */
#define BCHP_DNR_LINE_STORE_CONFIG_reserved0_MASK                  0xfffe0000
#define BCHP_DNR_LINE_STORE_CONFIG_reserved0_SHIFT                 17

/* DNR :: LINE_STORE_CONFIG :: LS_MODE [16:16] */
#define BCHP_DNR_LINE_STORE_CONFIG_LS_MODE_MASK                    0x00010000
#define BCHP_DNR_LINE_STORE_CONFIG_LS_MODE_SHIFT                   16
#define BCHP_DNR_LINE_STORE_CONFIG_LS_MODE_SD                      0
#define BCHP_DNR_LINE_STORE_CONFIG_LS_MODE_HD                      1

/* DNR :: LINE_STORE_CONFIG :: reserved1 [15:00] */
#define BCHP_DNR_LINE_STORE_CONFIG_reserved1_MASK                  0x0000ffff
#define BCHP_DNR_LINE_STORE_CONFIG_reserved1_SHIFT                 0

/***************************************************************************
 *SRC_PIC_SIZE - Source Picture Size
 ***************************************************************************/
/* DNR :: SRC_PIC_SIZE :: reserved0 [31:27] */
#define BCHP_DNR_SRC_PIC_SIZE_reserved0_MASK                       0xf8000000
#define BCHP_DNR_SRC_PIC_SIZE_reserved0_SHIFT                      27

/* DNR :: SRC_PIC_SIZE :: HSIZE [26:16] */
#define BCHP_DNR_SRC_PIC_SIZE_HSIZE_MASK                           0x07ff0000
#define BCHP_DNR_SRC_PIC_SIZE_HSIZE_SHIFT                          16

/* DNR :: SRC_PIC_SIZE :: reserved1 [15:11] */
#define BCHP_DNR_SRC_PIC_SIZE_reserved1_MASK                       0x0000f800
#define BCHP_DNR_SRC_PIC_SIZE_reserved1_SHIFT                      11

/* DNR :: SRC_PIC_SIZE :: VSIZE [10:00] */
#define BCHP_DNR_SRC_PIC_SIZE_VSIZE_MASK                           0x000007ff
#define BCHP_DNR_SRC_PIC_SIZE_VSIZE_SHIFT                          0

/***************************************************************************
 *SRC_SCAN_SETTING - Source Scan Setting
 ***************************************************************************/
/* DNR :: SRC_SCAN_SETTING :: reserved0 [31:19] */
#define BCHP_DNR_SRC_SCAN_SETTING_reserved0_MASK                   0xfff80000
#define BCHP_DNR_SRC_SCAN_SETTING_reserved0_SHIFT                  19

/* DNR :: SRC_SCAN_SETTING :: H_OFFSET [18:16] */
#define BCHP_DNR_SRC_SCAN_SETTING_H_OFFSET_MASK                    0x00070000
#define BCHP_DNR_SRC_SCAN_SETTING_H_OFFSET_SHIFT                   16

/* DNR :: SRC_SCAN_SETTING :: reserved1 [15:11] */
#define BCHP_DNR_SRC_SCAN_SETTING_reserved1_MASK                   0x0000f800
#define BCHP_DNR_SRC_SCAN_SETTING_reserved1_SHIFT                  11

/* DNR :: SRC_SCAN_SETTING :: V_OFFSET [10:08] */
#define BCHP_DNR_SRC_SCAN_SETTING_V_OFFSET_MASK                    0x00000700
#define BCHP_DNR_SRC_SCAN_SETTING_V_OFFSET_SHIFT                   8

/* DNR :: SRC_SCAN_SETTING :: reserved2 [07:02] */
#define BCHP_DNR_SRC_SCAN_SETTING_reserved2_MASK                   0x000000fc
#define BCHP_DNR_SRC_SCAN_SETTING_reserved2_SHIFT                  2

/* DNR :: SRC_SCAN_SETTING :: SRC_FORMAT [01:01] */
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FORMAT_MASK                  0x00000002
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FORMAT_SHIFT                 1
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FORMAT_FIELD                 0
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FORMAT_FRAME                 1

/* DNR :: SRC_SCAN_SETTING :: SRC_FIELD_ID [00:00] */
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FIELD_ID_MASK                0x00000001
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FIELD_ID_SHIFT               0
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FIELD_ID_TOP                 0
#define BCHP_DNR_SRC_SCAN_SETTING_SRC_FIELD_ID_BOTTOM              1

/***************************************************************************
 *BNR_CTRL - Block Noise Reduction Control
 ***************************************************************************/
/* DNR :: BNR_CTRL :: reserved0 [31:02] */
#define BCHP_DNR_BNR_CTRL_reserved0_MASK                           0xfffffffc
#define BCHP_DNR_BNR_CTRL_reserved0_SHIFT                          2

/* DNR :: BNR_CTRL :: HBNR_ENABLE [01:01] */
#define BCHP_DNR_BNR_CTRL_HBNR_ENABLE_MASK                         0x00000002
#define BCHP_DNR_BNR_CTRL_HBNR_ENABLE_SHIFT                        1
#define BCHP_DNR_BNR_CTRL_HBNR_ENABLE_DISABLE                      0
#define BCHP_DNR_BNR_CTRL_HBNR_ENABLE_ENABLE                       1

/* DNR :: BNR_CTRL :: VBNR_ENABLE [00:00] */
#define BCHP_DNR_BNR_CTRL_VBNR_ENABLE_MASK                         0x00000001
#define BCHP_DNR_BNR_CTRL_VBNR_ENABLE_SHIFT                        0
#define BCHP_DNR_BNR_CTRL_VBNR_ENABLE_DISABLE                      0
#define BCHP_DNR_BNR_CTRL_VBNR_ENABLE_ENABLE                       1

/***************************************************************************
 *VBNR_CONFIG - Vertical Block Noise Reduction Configuration
 ***************************************************************************/
/* DNR :: VBNR_CONFIG :: reserved0 [31:30] */
#define BCHP_DNR_VBNR_CONFIG_reserved0_MASK                        0xc0000000
#define BCHP_DNR_VBNR_CONFIG_reserved0_SHIFT                       30

/* DNR :: VBNR_CONFIG :: VBNR_LR_LIMIT [29:24] */
#define BCHP_DNR_VBNR_CONFIG_VBNR_LR_LIMIT_MASK                    0x3f000000
#define BCHP_DNR_VBNR_CONFIG_VBNR_LR_LIMIT_SHIFT                   24

/* DNR :: VBNR_CONFIG :: reserved1 [23:20] */
#define BCHP_DNR_VBNR_CONFIG_reserved1_MASK                        0x00f00000
#define BCHP_DNR_VBNR_CONFIG_reserved1_SHIFT                       20

/* DNR :: VBNR_CONFIG :: VBNR_REL [19:16] */
#define BCHP_DNR_VBNR_CONFIG_VBNR_REL_MASK                         0x000f0000
#define BCHP_DNR_VBNR_CONFIG_VBNR_REL_SHIFT                        16

/* DNR :: VBNR_CONFIG :: reserved2 [15:09] */
#define BCHP_DNR_VBNR_CONFIG_reserved2_MASK                        0x0000fe00
#define BCHP_DNR_VBNR_CONFIG_reserved2_SHIFT                       9

/* DNR :: VBNR_CONFIG :: VBNR_LIMIT [08:00] */
#define BCHP_DNR_VBNR_CONFIG_VBNR_LIMIT_MASK                       0x000001ff
#define BCHP_DNR_VBNR_CONFIG_VBNR_LIMIT_SHIFT                      0

/***************************************************************************
 *HBNR_CONFIG - Horizontal Block Noise Reduction Configuration
 ***************************************************************************/
/* DNR :: HBNR_CONFIG :: HBNR_SMALL_GRID [31:31] */
#define BCHP_DNR_HBNR_CONFIG_HBNR_SMALL_GRID_MASK                  0x80000000
#define BCHP_DNR_HBNR_CONFIG_HBNR_SMALL_GRID_SHIFT                 31

/* DNR :: HBNR_CONFIG :: reserved0 [30:20] */
#define BCHP_DNR_HBNR_CONFIG_reserved0_MASK                        0x7ff00000
#define BCHP_DNR_HBNR_CONFIG_reserved0_SHIFT                       20

/* DNR :: HBNR_CONFIG :: HBNR_REL [19:16] */
#define BCHP_DNR_HBNR_CONFIG_HBNR_REL_MASK                         0x000f0000
#define BCHP_DNR_HBNR_CONFIG_HBNR_REL_SHIFT                        16

/* DNR :: HBNR_CONFIG :: reserved1 [15:09] */
#define BCHP_DNR_HBNR_CONFIG_reserved1_MASK                        0x0000fe00
#define BCHP_DNR_HBNR_CONFIG_reserved1_SHIFT                       9

/* DNR :: HBNR_CONFIG :: HBNR_LIMIT [08:00] */
#define BCHP_DNR_HBNR_CONFIG_HBNR_LIMIT_MASK                       0x000001ff
#define BCHP_DNR_HBNR_CONFIG_HBNR_LIMIT_SHIFT                      0

/***************************************************************************
 *MNR_CTRL - Mosquito Noise Reduction Control
 ***************************************************************************/
/* DNR :: MNR_CTRL :: reserved0 [31:01] */
#define BCHP_DNR_MNR_CTRL_reserved0_MASK                           0xfffffffe
#define BCHP_DNR_MNR_CTRL_reserved0_SHIFT                          1

/* DNR :: MNR_CTRL :: MNR_ENABLE [00:00] */
#define BCHP_DNR_MNR_CTRL_MNR_ENABLE_MASK                          0x00000001
#define BCHP_DNR_MNR_CTRL_MNR_ENABLE_SHIFT                         0
#define BCHP_DNR_MNR_CTRL_MNR_ENABLE_DISABLE                       0
#define BCHP_DNR_MNR_CTRL_MNR_ENABLE_ENABLE                        1

/***************************************************************************
 *MNR_CONFIG - Mosquito Noise Reduction Configuration
 ***************************************************************************/
/* DNR :: MNR_CONFIG :: MNR_SPOT [31:31] */
#define BCHP_DNR_MNR_CONFIG_MNR_SPOT_MASK                          0x80000000
#define BCHP_DNR_MNR_CONFIG_MNR_SPOT_SHIFT                         31

/* DNR :: MNR_CONFIG :: reserved0 [30:27] */
#define BCHP_DNR_MNR_CONFIG_reserved0_MASK                         0x78000000
#define BCHP_DNR_MNR_CONFIG_reserved0_SHIFT                        27

/* DNR :: MNR_CONFIG :: MNR_MERGE [26:24] */
#define BCHP_DNR_MNR_CONFIG_MNR_MERGE_MASK                         0x07000000
#define BCHP_DNR_MNR_CONFIG_MNR_MERGE_SHIFT                        24

/* DNR :: MNR_CONFIG :: reserved1 [23:23] */
#define BCHP_DNR_MNR_CONFIG_reserved1_MASK                         0x00800000
#define BCHP_DNR_MNR_CONFIG_reserved1_SHIFT                        23

/* DNR :: MNR_CONFIG :: MNR_REL [22:16] */
#define BCHP_DNR_MNR_CONFIG_MNR_REL_MASK                           0x007f0000
#define BCHP_DNR_MNR_CONFIG_MNR_REL_SHIFT                          16

/* DNR :: MNR_CONFIG :: MNR_BLOCK_BOUND [15:15] */
#define BCHP_DNR_MNR_CONFIG_MNR_BLOCK_BOUND_MASK                   0x00008000
#define BCHP_DNR_MNR_CONFIG_MNR_BLOCK_BOUND_SHIFT                  15

/* DNR :: MNR_CONFIG :: reserved2 [14:09] */
#define BCHP_DNR_MNR_CONFIG_reserved2_MASK                         0x00007e00
#define BCHP_DNR_MNR_CONFIG_reserved2_SHIFT                        9

/* DNR :: MNR_CONFIG :: MNR_LIMIT [08:00] */
#define BCHP_DNR_MNR_CONFIG_MNR_LIMIT_MASK                         0x000001ff
#define BCHP_DNR_MNR_CONFIG_MNR_LIMIT_SHIFT                        0

/***************************************************************************
 *EXT_FILT_CTRL - Extreme Filter Control
 ***************************************************************************/
/* DNR :: EXT_FILT_CTRL :: reserved0 [31:01] */
#define BCHP_DNR_EXT_FILT_CTRL_reserved0_MASK                      0xfffffffe
#define BCHP_DNR_EXT_FILT_CTRL_reserved0_SHIFT                     1

/* DNR :: EXT_FILT_CTRL :: ENABLE [00:00] */
#define BCHP_DNR_EXT_FILT_CTRL_ENABLE_MASK                         0x00000001
#define BCHP_DNR_EXT_FILT_CTRL_ENABLE_SHIFT                        0
#define BCHP_DNR_EXT_FILT_CTRL_ENABLE_DISABLE                      0
#define BCHP_DNR_EXT_FILT_CTRL_ENABLE_ENABLE                       1

/***************************************************************************
 *EXT_FILT_CONFIG - Extreme Filter Configuration
 ***************************************************************************/
/* DNR :: EXT_FILT_CONFIG :: reserved0 [31:01] */
#define BCHP_DNR_EXT_FILT_CONFIG_reserved0_MASK                    0xfffffffe
#define BCHP_DNR_EXT_FILT_CONFIG_reserved0_SHIFT                   1

/* DNR :: EXT_FILT_CONFIG :: CONFIG [00:00] */
#define BCHP_DNR_EXT_FILT_CONFIG_CONFIG_MASK                       0x00000001
#define BCHP_DNR_EXT_FILT_CONFIG_CONFIG_SHIFT                      0

/***************************************************************************
 *FILT_EFFECT_STATUS - DNR Filters Effect Status
 ***************************************************************************/
/* DNR :: FILT_EFFECT_STATUS :: FILT_EFFECT [31:00] */
#define BCHP_DNR_FILT_EFFECT_STATUS_FILT_EFFECT_MASK               0xffffffff
#define BCHP_DNR_FILT_EFFECT_STATUS_FILT_EFFECT_SHIFT              0

/***************************************************************************
 *BVB_IN_STATUS - DNR BVB Input Status
 ***************************************************************************/
/* DNR :: BVB_IN_STATUS :: reserved0 [31:05] */
#define BCHP_DNR_BVB_IN_STATUS_reserved0_MASK                      0xffffffe0
#define BCHP_DNR_BVB_IN_STATUS_reserved0_SHIFT                     5

/* DNR :: BVB_IN_STATUS :: MISSING_SYNC [04:04] */
#define BCHP_DNR_BVB_IN_STATUS_MISSING_SYNC_MASK                   0x00000010
#define BCHP_DNR_BVB_IN_STATUS_MISSING_SYNC_SHIFT                  4

/* DNR :: BVB_IN_STATUS :: LONG_SOURCE [03:03] */
#define BCHP_DNR_BVB_IN_STATUS_LONG_SOURCE_MASK                    0x00000008
#define BCHP_DNR_BVB_IN_STATUS_LONG_SOURCE_SHIFT                   3

/* DNR :: BVB_IN_STATUS :: SHORT_SOURCE [02:02] */
#define BCHP_DNR_BVB_IN_STATUS_SHORT_SOURCE_MASK                   0x00000004
#define BCHP_DNR_BVB_IN_STATUS_SHORT_SOURCE_SHIFT                  2

/* DNR :: BVB_IN_STATUS :: LONG_LINE [01:01] */
#define BCHP_DNR_BVB_IN_STATUS_LONG_LINE_MASK                      0x00000002
#define BCHP_DNR_BVB_IN_STATUS_LONG_LINE_SHIFT                     1

/* DNR :: BVB_IN_STATUS :: SHORT_LINE [00:00] */
#define BCHP_DNR_BVB_IN_STATUS_SHORT_LINE_MASK                     0x00000001
#define BCHP_DNR_BVB_IN_STATUS_SHORT_LINE_SHIFT                    0

/***************************************************************************
 *BVB_IN_STATUS_CLEAR - DNR BVB Input Status Clear
 ***************************************************************************/
/* DNR :: BVB_IN_STATUS_CLEAR :: reserved0 [31:05] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_reserved0_MASK                0xffffffe0
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_reserved0_SHIFT               5

/* DNR :: BVB_IN_STATUS_CLEAR :: MISSING_SYNC [04:04] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_MISSING_SYNC_MASK             0x00000010
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_MISSING_SYNC_SHIFT            4

/* DNR :: BVB_IN_STATUS_CLEAR :: LONG_SOURCE [03:03] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_LONG_SOURCE_MASK              0x00000008
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_LONG_SOURCE_SHIFT             3

/* DNR :: BVB_IN_STATUS_CLEAR :: SHORT_SOURCE [02:02] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_SHORT_SOURCE_MASK             0x00000004
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_SHORT_SOURCE_SHIFT            2

/* DNR :: BVB_IN_STATUS_CLEAR :: LONG_LINE [01:01] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_LONG_LINE_MASK                0x00000002
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_LONG_LINE_SHIFT               1

/* DNR :: BVB_IN_STATUS_CLEAR :: SHORT_LINE [00:00] */
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_SHORT_LINE_MASK               0x00000001
#define BCHP_DNR_BVB_IN_STATUS_CLEAR_SHORT_LINE_SHIFT              0

/***************************************************************************
 *SCRATCH_REGISTER - DNR Scratch Register
 ***************************************************************************/
/* DNR :: SCRATCH_REGISTER :: reserved0 [31:16] */
#define BCHP_DNR_SCRATCH_REGISTER_reserved0_MASK                   0xffff0000
#define BCHP_DNR_SCRATCH_REGISTER_reserved0_SHIFT                  16

/* DNR :: SCRATCH_REGISTER :: VALUE [15:00] */
#define BCHP_DNR_SCRATCH_REGISTER_VALUE_MASK                       0x0000ffff
#define BCHP_DNR_SCRATCH_REGISTER_VALUE_SHIFT                      0

/***************************************************************************
 *DNR_DEMO_SETTING - DNR Demo Setting
 ***************************************************************************/
/* DNR :: DNR_DEMO_SETTING :: reserved0 [31:17] */
#define BCHP_DNR_DNR_DEMO_SETTING_reserved0_MASK                   0xfffe0000
#define BCHP_DNR_DNR_DEMO_SETTING_reserved0_SHIFT                  17

/* DNR :: DNR_DEMO_SETTING :: DEMO_L_R [16:16] */
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_L_R_MASK                    0x00010000
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_L_R_SHIFT                   16
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_L_R_LEFT                    1
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_L_R_RIGHT                   0

/* DNR :: DNR_DEMO_SETTING :: reserved1 [15:11] */
#define BCHP_DNR_DNR_DEMO_SETTING_reserved1_MASK                   0x0000f800
#define BCHP_DNR_DNR_DEMO_SETTING_reserved1_SHIFT                  11

/* DNR :: DNR_DEMO_SETTING :: DEMO_BOUNDARY [10:00] */
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_BOUNDARY_MASK               0x000007ff
#define BCHP_DNR_DNR_DEMO_SETTING_DEMO_BOUNDARY_SHIFT              0

/***************************************************************************
 *DCR_CTRL - Digital Contour Removal Control
 ***************************************************************************/
/* DNR :: DCR_CTRL :: reserved0 [31:02] */
#define BCHP_DNR_DCR_CTRL_reserved0_MASK                           0xfffffffc
#define BCHP_DNR_DCR_CTRL_reserved0_SHIFT                          2

/* DNR :: DCR_CTRL :: DITH_ENABLE [01:01] */
#define BCHP_DNR_DCR_CTRL_DITH_ENABLE_MASK                         0x00000002
#define BCHP_DNR_DCR_CTRL_DITH_ENABLE_SHIFT                        1
#define BCHP_DNR_DCR_CTRL_DITH_ENABLE_DISABLE                      0
#define BCHP_DNR_DCR_CTRL_DITH_ENABLE_ENABLE                       1

/* DNR :: DCR_CTRL :: FILT_ENABLE [00:00] */
#define BCHP_DNR_DCR_CTRL_FILT_ENABLE_MASK                         0x00000001
#define BCHP_DNR_DCR_CTRL_FILT_ENABLE_SHIFT                        0
#define BCHP_DNR_DCR_CTRL_FILT_ENABLE_DISABLE                      0
#define BCHP_DNR_DCR_CTRL_FILT_ENABLE_ENABLE                       1

/***************************************************************************
 *DCR_FILT_LIMIT - DCR Filtering Limits
 ***************************************************************************/
/* DNR :: DCR_FILT_LIMIT :: reserved0 [31:28] */
#define BCHP_DNR_DCR_FILT_LIMIT_reserved0_MASK                     0xf0000000
#define BCHP_DNR_DCR_FILT_LIMIT_reserved0_SHIFT                    28

/* DNR :: DCR_FILT_LIMIT :: FILT_3_LIMIT [27:24] */
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_3_LIMIT_MASK                  0x0f000000
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_3_LIMIT_SHIFT                 24

/* DNR :: DCR_FILT_LIMIT :: reserved1 [23:20] */
#define BCHP_DNR_DCR_FILT_LIMIT_reserved1_MASK                     0x00f00000
#define BCHP_DNR_DCR_FILT_LIMIT_reserved1_SHIFT                    20

/* DNR :: DCR_FILT_LIMIT :: FILT_2_LIMIT [19:16] */
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_2_LIMIT_MASK                  0x000f0000
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_2_LIMIT_SHIFT                 16

/* DNR :: DCR_FILT_LIMIT :: reserved2 [15:12] */
#define BCHP_DNR_DCR_FILT_LIMIT_reserved2_MASK                     0x0000f000
#define BCHP_DNR_DCR_FILT_LIMIT_reserved2_SHIFT                    12

/* DNR :: DCR_FILT_LIMIT :: FILT_1_LIMIT [11:08] */
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_1_LIMIT_MASK                  0x00000f00
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_1_LIMIT_SHIFT                 8

/* DNR :: DCR_FILT_LIMIT :: reserved3 [07:04] */
#define BCHP_DNR_DCR_FILT_LIMIT_reserved3_MASK                     0x000000f0
#define BCHP_DNR_DCR_FILT_LIMIT_reserved3_SHIFT                    4

/* DNR :: DCR_FILT_LIMIT :: FILT_0_LIMIT [03:00] */
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_0_LIMIT_MASK                  0x0000000f
#define BCHP_DNR_DCR_FILT_LIMIT_FILT_0_LIMIT_SHIFT                 0

/***************************************************************************
 *DCR_FILT_CONFIG - DCR Filtering Configuration
 ***************************************************************************/
/* DNR :: DCR_FILT_CONFIG :: reserved0 [31:11] */
#define BCHP_DNR_DCR_FILT_CONFIG_reserved0_MASK                    0xfffff800
#define BCHP_DNR_DCR_FILT_CONFIG_reserved0_SHIFT                   11

/* DNR :: DCR_FILT_CONFIG :: BRIGHT_2 [10:10] */
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_2_MASK                     0x00000400
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_2_SHIFT                    10

/* DNR :: DCR_FILT_CONFIG :: BRIGHT_1 [09:09] */
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_1_MASK                     0x00000200
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_1_SHIFT                    9

/* DNR :: DCR_FILT_CONFIG :: BRIGHT_0 [08:08] */
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_0_MASK                     0x00000100
#define BCHP_DNR_DCR_FILT_CONFIG_BRIGHT_0_SHIFT                    8

/* DNR :: DCR_FILT_CONFIG :: reserved1 [07:07] */
#define BCHP_DNR_DCR_FILT_CONFIG_reserved1_MASK                    0x00000080
#define BCHP_DNR_DCR_FILT_CONFIG_reserved1_SHIFT                   7

/* DNR :: DCR_FILT_CONFIG :: FILT_CLAMP [06:00] */
#define BCHP_DNR_DCR_FILT_CONFIG_FILT_CLAMP_MASK                   0x0000007f
#define BCHP_DNR_DCR_FILT_CONFIG_FILT_CLAMP_SHIFT                  0

/***************************************************************************
 *DCR_DITH_ORDER_PATTERN - DCR Ordered Dither Pattern Control
 ***************************************************************************/
/* DNR :: DCR_DITH_ORDER_PATTERN :: reserved0 [31:05] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_reserved0_MASK             0xffffffe0
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_reserved0_SHIFT            5

/* DNR :: DCR_DITH_ORDER_PATTERN :: ALTERNATE_Y [04:04] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_ALTERNATE_Y_MASK           0x00000010
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_ALTERNATE_Y_SHIFT          4

/* DNR :: DCR_DITH_ORDER_PATTERN :: ALTERNATE_X [03:03] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_ALTERNATE_X_MASK           0x00000008
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_ALTERNATE_X_SHIFT          3

/* DNR :: DCR_DITH_ORDER_PATTERN :: INVERT_Y [02:02] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_INVERT_Y_MASK              0x00000004
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_INVERT_Y_SHIFT             2

/* DNR :: DCR_DITH_ORDER_PATTERN :: INVERT_X [01:01] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_INVERT_X_MASK              0x00000002
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_INVERT_X_SHIFT             1

/* DNR :: DCR_DITH_ORDER_PATTERN :: AUTO_DITH [00:00] */
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_AUTO_DITH_MASK             0x00000001
#define BCHP_DNR_DCR_DITH_ORDER_PATTERN_AUTO_DITH_SHIFT            0

/***************************************************************************
 *DCR_DITH_ORDER_VALUE - DCR Ordered Dither Value
 ***************************************************************************/
/* DNR :: DCR_DITH_ORDER_VALUE :: reserved0 [31:15] */
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_reserved0_MASK               0xffff8000
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_reserved0_SHIFT              15

/* DNR :: DCR_DITH_ORDER_VALUE :: ORDER_B [14:08] */
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_ORDER_B_MASK                 0x00007f00
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_ORDER_B_SHIFT                8

/* DNR :: DCR_DITH_ORDER_VALUE :: reserved1 [07:07] */
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_reserved1_MASK               0x00000080
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_reserved1_SHIFT              7

/* DNR :: DCR_DITH_ORDER_VALUE :: ORDER_A [06:00] */
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_ORDER_A_MASK                 0x0000007f
#define BCHP_DNR_DCR_DITH_ORDER_VALUE_ORDER_A_SHIFT                0

/***************************************************************************
 *DCR_DITH_RANDOM_PATTERN - DCR Random Dither Pattern Control
 ***************************************************************************/
/* DNR :: DCR_DITH_RANDOM_PATTERN :: reserved0 [31:18] */
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_reserved0_MASK            0xfffc0000
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_reserved0_SHIFT           18

/* DNR :: DCR_DITH_RANDOM_PATTERN :: RNG_MODE [17:16] */
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_MODE_MASK             0x00030000
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_MODE_SHIFT            16
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_MODE_RUN              0
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_MODE_RNG_FIELD        1
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_MODE_RNG_FRAME        2

/* DNR :: DCR_DITH_RANDOM_PATTERN :: RNG_SEED [15:00] */
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_SEED_MASK             0x0000ffff
#define BCHP_DNR_DCR_DITH_RANDOM_PATTERN_RNG_SEED_SHIFT            0

/***************************************************************************
 *DCR_DITH_RANDOM_VALUE - DCR Random Dither Values
 ***************************************************************************/
/* DNR :: DCR_DITH_RANDOM_VALUE :: reserved0 [31:31] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved0_MASK              0x80000000
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved0_SHIFT             31

/* DNR :: DCR_DITH_RANDOM_VALUE :: RANDOM_D [30:24] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_D_MASK               0x7f000000
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_D_SHIFT              24

/* DNR :: DCR_DITH_RANDOM_VALUE :: reserved1 [23:23] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved1_MASK              0x00800000
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved1_SHIFT             23

/* DNR :: DCR_DITH_RANDOM_VALUE :: RANDOM_C [22:16] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_C_MASK               0x007f0000
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_C_SHIFT              16

/* DNR :: DCR_DITH_RANDOM_VALUE :: reserved2 [15:15] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved2_MASK              0x00008000
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved2_SHIFT             15

/* DNR :: DCR_DITH_RANDOM_VALUE :: RANDOM_B [14:08] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_B_MASK               0x00007f00
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_B_SHIFT              8

/* DNR :: DCR_DITH_RANDOM_VALUE :: reserved3 [07:07] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved3_MASK              0x00000080
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_reserved3_SHIFT             7

/* DNR :: DCR_DITH_RANDOM_VALUE :: RANDOM_A [06:00] */
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_A_MASK               0x0000007f
#define BCHP_DNR_DCR_DITH_RANDOM_VALUE_RANDOM_A_SHIFT              0

/***************************************************************************
 *DCR_DITH_OUT_CTRL - DCR Dither Output Control
 ***************************************************************************/
/* DNR :: DCR_DITH_OUT_CTRL :: reserved0 [31:08] */
#define BCHP_DNR_DCR_DITH_OUT_CTRL_reserved0_MASK                  0xffffff00
#define BCHP_DNR_DCR_DITH_OUT_CTRL_reserved0_SHIFT                 8

/* DNR :: DCR_DITH_OUT_CTRL :: DITH_CLAMP [07:00] */
#define BCHP_DNR_DCR_DITH_OUT_CTRL_DITH_CLAMP_MASK                 0x000000ff
#define BCHP_DNR_DCR_DITH_OUT_CTRL_DITH_CLAMP_SHIFT                0

#endif /* #ifndef BCHP_DNR_H__ */

/* End of File */
