/// autogenerated analytical inverse kinematics code from ikfast program part of
/// OpenRAVE \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 71 generated on 2016-04-05 16:09:02.982560
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need
/// -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared
///     -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "dart/external/ikfast/ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION == 71);

#include <algorithm>
#include <cmath>
#include <complex>
#include <limits>
#include <vector>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
  #include <iostream>
  #include <sstream>
  #include <stdexcept>

  #ifdef _MSC_VER
    #ifndef __PRETTY_FUNCTION__
      #define __PRETTY_FUNCTION__ __FUNCDNAME__
    #endif
  #endif

  #ifndef __PRETTY_FUNCTION__
    #define __PRETTY_FUNCTION__ __func__
  #endif

  #define IKFAST_ASSERT(b)                                                     \
    {                                                                          \
      if (!(b))                                                                \
      {                                                                        \
        std::stringstream ss;                                                  \
        ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": "      \
           << __PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed";      \
        throw std::runtime_error(ss.str());                                    \
      }                                                                        \
    }

#endif

#if defined(_MSC_VER)
  #define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
  #define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI ((IkReal)6.28318530717959)
#define IKPI ((IkReal)3.14159265358979)
#define IKPI_2 ((IkReal)1.57079632679490)

// lapack routines
extern "C" {
void dgetrf_(
    const int* m,
    const int* n,
    double* a,
    const int* lda,
    int* ipiv,
    int* info);
void zgetrf_(
    const int* m,
    const int* n,
    std::complex<double>* a,
    const int* lda,
    int* ipiv,
    int* info);
void dgetri_(
    const int* n,
    const double* a,
    const int* lda,
    int* ipiv,
    double* work,
    const int* lwork,
    int* info);
void dgesv_(
    const int* n,
    const int* nrhs,
    double* a,
    const int* lda,
    int* ipiv,
    double* b,
    const int* ldb,
    int* info);
void dgetrs_(
    const char* trans,
    const int* n,
    const int* nrhs,
    double* a,
    const int* lda,
    int* ipiv,
    double* b,
    const int* ldb,
    int* info);
void dgeev_(
    const char* jobvl,
    const char* jobvr,
    const int* n,
    double* a,
    const int* lda,
    double* wr,
    double* wi,
    double* vl,
    const int* ldvl,
    double* vr,
    const int* ldvr,
    double* work,
    const int* lwork,
    int* info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f)
{
  return fabsf(f);
}
inline double IKabs(double f)
{
  return fabs(f);
}

inline float IKsqr(float f)
{
  return f * f;
}
inline double IKsqr(double f)
{
  return f * f;
}

inline float IKlog(float f)
{
  return logf(f);
}
inline double IKlog(double f)
{
  return log(f);
}

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
  #define IKFAST_SINCOS_THRESH ((IkReal)2e-6)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
  #define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
  #define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0.
// This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
  #define IKFAST_EVALCOND_THRESH ((IkReal)0.000005)
#endif

inline float IKasin(float f)
{
  IKFAST_ASSERT(
      f > -1 - IKFAST_SINCOS_THRESH
      && f < 1 + IKFAST_SINCOS_THRESH); // any more error implies something is
                                        // wrong with the solver
  if (f <= -1)
    return float(-IKPI_2);
  else if (f >= 1)
    return float(IKPI_2);
  return asinf(f);
}
inline double IKasin(double f)
{
  IKFAST_ASSERT(
      f > -1 - IKFAST_SINCOS_THRESH
      && f < 1 + IKFAST_SINCOS_THRESH); // any more error implies something is
                                        // wrong with the solver
  if (f <= -1)
    return -IKPI_2;
  else if (f >= 1)
    return IKPI_2;
  return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
  while (x < 0)
  {
    x += y;
  }
  return fmodf(x, y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
  while (x < 0)
  {
    x += y;
  }
  return fmod(x, y);
}

inline float IKacos(float f)
{
  IKFAST_ASSERT(
      f > -1 - IKFAST_SINCOS_THRESH
      && f < 1 + IKFAST_SINCOS_THRESH); // any more error implies something is
                                        // wrong with the solver
  if (f <= -1)
    return float(IKPI);
  else if (f >= 1)
    return float(0);
  return acosf(f);
}
inline double IKacos(double f)
{
  IKFAST_ASSERT(
      f > -1 - IKFAST_SINCOS_THRESH
      && f < 1 + IKFAST_SINCOS_THRESH); // any more error implies something is
                                        // wrong with the solver
  if (f <= -1)
    return IKPI;
  else if (f >= 1)
    return 0;
  return acos(f);
}
inline float IKsin(float f)
{
  return sinf(f);
}
inline double IKsin(double f)
{
  return sin(f);
}
inline float IKcos(float f)
{
  return cosf(f);
}
inline double IKcos(double f)
{
  return cos(f);
}
inline float IKtan(float f)
{
  return tanf(f);
}
inline double IKtan(double f)
{
  return tan(f);
}
inline float IKsqrt(float f)
{
  if (f <= 0.0f)
    return 0.0f;
  return sqrtf(f);
}
inline double IKsqrt(double f)
{
  if (f <= 0.0)
    return 0.0;
  return sqrt(f);
}
inline float IKatan2Simple(float fy, float fx)
{
  return atan2f(fy, fx);
}
inline float IKatan2(float fy, float fx)
{
  if (isnan(fy))
  {
    IKFAST_ASSERT(
        !isnan(fx)); // if both are nan, probably wrong value will be returned
    return float(IKPI_2);
  }
  else if (isnan(fx))
  {
    return 0;
  }
  return atan2f(fy, fx);
}
inline double IKatan2Simple(double fy, double fx)
{
  return atan2(fy, fx);
}
inline double IKatan2(double fy, double fx)
{
  if (std::isnan(fy))
  {
    IKFAST_ASSERT(!std::isnan(
        fx)); // if both are nan, probably wrong value will be returned
    return IKPI_2;
  }
  else if (std::isnan(fx))
  {
    return 0;
  }
  return atan2(fy, fx);
}

template <typename T>
struct CheckValue
{
  T value;
  bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
  CheckValue<T> ret;
  ret.valid = false;
  ret.value = 0;
  if (!std::isnan(fy) && !std::isnan(fx))
  {
    if (IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH
        || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH)
    {
      ret.value = IKatan2Simple(fy, fx);
      ret.valid = true;
    }
  }
  return ret;
}

inline float IKsign(float f)
{
  if (f > 0)
  {
    return float(1);
  }
  else if (f < 0)
  {
    return float(-1);
  }
  return 0;
}

inline double IKsign(double f)
{
  if (f > 0)
  {
    return 1.0;
  }
  else if (f < 0)
  {
    return -1.0;
  }
  return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
  CheckValue<T> ret;
  ret.valid = true;
  if (n == 0)
  {
    ret.value = 1.0;
    return ret;
  }
  else if (n == 1)
  {
    ret.value = f;
    return ret;
  }
  else if (n < 0)
  {
    if (f == 0)
    {
      ret.valid = false;
      ret.value = (T)1.0e30;
      return ret;
    }
    if (n == -1)
    {
      ret.value = T(1.0) / f;
      return ret;
    }
  }

  int num = n > 0 ? n : -n;
  if (num == 2)
  {
    ret.value = f * f;
  }
  else if (num == 3)
  {
    ret.value = f * f * f;
  }
  else
  {
    ret.value = 1.0;
    while (num > 0)
    {
      if (num & 1)
      {
        ret.value *= f;
      }
      num >>= 1;
      f *= f;
    }
  }

  if (n < 0)
  {
    ret.value = T(1.0) / ret.value;
  }
  return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot)
{
  IkReal x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15,
      x16, x17, x18, x19, x20, x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
      x31, x32, x33, x34, x35, x36, x37, x38, x39, x40, x41, x42, x43, x44, x45,
      x46, x47, x48, x49, x50, x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
      x61, x62, x63;
  x0 = IKsin(j[6]);
  x1 = IKcos(j[4]);
  x2 = IKsin(j[0]);
  x3 = IKcos(j[2]);
  x4 = (x2 * x3);
  x5 = ((1.0) * x4);
  x6 = IKcos(j[1]);
  x7 = IKsin(j[2]);
  x8 = IKcos(j[0]);
  x9 = (x7 * x8);
  x10 = ((1.0) * x9);
  x11 = ((((-1.0) * (1.0) * x5)) + (((-1.0) * (1.0) * x10 * x6)));
  x12 = IKsin(j[4]);
  x13 = IKsin(j[1]);
  x14 = IKsin(j[3]);
  x15 = (x13 * x14 * x8);
  x16 = ((1.0) * x15);
  x17 = IKcos(j[3]);
  x18 = ((1.0) * x17);
  x19 = (x2 * x7);
  x20 = ((1.0) * x19);
  x21 = (x3 * x8);
  x22 = (x21 * x6);
  x23 = (x22 + (((-1.0) * (1.0) * x20)));
  x24 = (((x12 * (((((-1.0) * (1.0) * x18 * x23)) + x16)))) + ((x1 * x11)));
  x25 = IKcos(j[6]);
  x26 = IKsin(j[5]);
  x27 = (x13 * x17 * x8);
  x28 = ((1.0) * x27);
  x29 = (x14 * ((x20 + (((-1.0) * (1.0) * x22)))));
  x30 = (x26 * ((x29 + (((-1.0) * (1.0) * x28)))));
  x31 = IKcos(j[5]);
  x32 = (((x11 * x12)) + ((x1 * (((((-1.0) * (1.0) * x16)) + ((x17 * x23)))))));
  x33 = (x31 * x32);
  x34 = ((0.045) * x19);
  x35 = ((0.55) * x13);
  x36 = ((0.045) * x22);
  x37 = ((((-1.0) * (1.0) * x20 * x6)) + x21);
  x38 = (x13 * x14 * x2);
  x39 = ((1.0) * x38);
  x40 = (x4 * x6);
  x41 = (x9 + x40);
  x42 = (((x12 * ((x39 + (((-1.0) * (1.0) * x18 * x41)))))) + ((x1 * x37)));
  x43 = (x13 * x17 * x2);
  x44 = ((1.0) * x43);
  x45 = (x14 * (((((-1.0) * (1.0) * x10)) + (((-1.0) * (1.0) * x5 * x6)))));
  x46 = (x26 * (((((-1.0) * (1.0) * x44)) + x45)));
  x47 = (((x1 * (((((-1.0) * (1.0) * x39)) + ((x17 * x41)))))) + ((x12 * x37)));
  x48 = (x31 * x47);
  x49 = ((0.045) * x9);
  x50 = ((0.045) * x40);
  x51 = (x13 * x7);
  x52 = (x14 * x6);
  x53 = ((1.0) * x52);
  x54 = (x13 * x3);
  x55 = (x18 * x54);
  x56 = (((x1 * x51)) + ((x12 * ((x55 + x53)))));
  x57 = (x17 * x6);
  x58 = ((1.0) * x57);
  x59 = (x14 * x54);
  x60 = (x26 * (((((-1.0) * (1.0) * x58)) + x59)));
  x61
      = (((x1 * (((((-1.0) * (1.0) * x55)) + (((-1.0) * (1.0) * x53))))))
         + ((x12 * x51)));
  x62 = (x31 * x61);
  x63 = ((0.045) * x54);
  eerot[0] = (((x0 * x24)) + ((x25 * ((x30 + x33)))));
  eerot[1]
      = (((x0 * (((((-1.0) * (1.0) * x30)) + (((-1.0) * (1.0) * x33))))))
         + ((x24 * x25)));
  eerot[2] = (((x26 * x32)) + ((x31 * ((x28 + (((-1.0) * (1.0) * x29)))))));
  eetrans[0]
      = ((0.22) + ((x17 * ((x34 + (((-1.0) * (1.0) * x36)))))) + x36
         + (((0.045) * x15))
         + ((x14 * (((((0.3) * x22)) + (((-1.0) * (0.3) * x19))))))
         + (((0.3) * x27)) + (((-1.0) * (1.0) * x34)) + ((x35 * x8)));
  eerot[3] = (((x25 * ((x48 + x46)))) + ((x0 * x42)));
  eerot[4]
      = (((x0 * (((((-1.0) * (1.0) * x48)) + (((-1.0) * (1.0) * x46))))))
         + ((x25 * x42)));
  eerot[5] = (((x26 * x47)) + ((x31 * (((((-1.0) * (1.0) * x45)) + x44)))));
  eetrans[1]
      = ((0.14) + ((x2 * x35)) + (((0.3) * x43)) + (((0.045) * x38))
         + ((x17 * (((((-1.0) * (1.0) * x49)) + (((-1.0) * (1.0) * x50))))))
         + x49 + x50 + ((x14 * (((((0.3) * x40)) + (((0.3) * x9)))))));
  eerot[6] = (((x0 * x56)) + ((x25 * ((x60 + x62)))));
  eerot[7]
      = (((x0 * (((((-1.0) * (1.0) * x60)) + (((-1.0) * (1.0) * x62))))))
         + ((x25 * x56)));
  eerot[8] = (((x26 * x61)) + ((x31 * (((((-1.0) * (1.0) * x59)) + x58)))));
  eetrans[2]
      = ((0.346) + (((0.045) * x52)) + (((-1.0) * (0.3) * x59))
         + (((0.55) * x6)) + (((0.3) * x57)) + (((-1.0) * (1.0) * x63))
         + ((x17 * x63)));
}

IKFAST_API int GetNumFreeParameters()
{
  return 1;
}
IKFAST_API int* GetFreeParameters()
{
  static int freeparams[] = {2};
  return freeparams;
}
IKFAST_API int GetNumJoints()
{
  return 7;
}

IKFAST_API int GetIkRealSize()
{
  return sizeof(IkReal);
}

IKFAST_API int GetIkType()
{
  return 0x67000001;
}

class IKSolver
{
public:
  IkReal j4, cj4, sj4, htj4, j4mul, j6, cj6, sj6, htj6, j6mul, j9, cj9, sj9,
      htj9, j9mul, j10, cj10, sj10, htj10, j10mul, j11, cj11, sj11, htj11,
      j11mul, j12, cj12, sj12, htj12, j12mul, j8, cj8, sj8, htj8, new_r00, r00,
      rxp0_0, new_r01, r01, rxp0_1, new_r02, r02, rxp0_2, new_r10, r10, rxp1_0,
      new_r11, r11, rxp1_1, new_r12, r12, rxp1_2, new_r20, r20, rxp2_0, new_r21,
      r21, rxp2_1, new_r22, r22, rxp2_2, new_px, px, npx, new_py, py, npy,
      new_pz, pz, npz, pp;
  unsigned char _ij4[2], _nj4, _ij6[2], _nj6, _ij9[2], _nj9, _ij10[2], _nj10,
      _ij11[2], _nj11, _ij12[2], _nj12, _ij8[2], _nj8;

  IkReal j100, cj100, sj100;
  unsigned char _ij100[2], _nj100;
  bool ComputeIk(
      const IkReal* eetrans,
      const IkReal* eerot,
      const IkReal* pfree,
      IkSolutionListBase<IkReal>& solutions)
  {
    j4 = numeric_limits<IkReal>::quiet_NaN();
    _ij4[0] = -1;
    _ij4[1] = -1;
    _nj4 = -1;
    j6 = numeric_limits<IkReal>::quiet_NaN();
    _ij6[0] = -1;
    _ij6[1] = -1;
    _nj6 = -1;
    j9 = numeric_limits<IkReal>::quiet_NaN();
    _ij9[0] = -1;
    _ij9[1] = -1;
    _nj9 = -1;
    j10 = numeric_limits<IkReal>::quiet_NaN();
    _ij10[0] = -1;
    _ij10[1] = -1;
    _nj10 = -1;
    j11 = numeric_limits<IkReal>::quiet_NaN();
    _ij11[0] = -1;
    _ij11[1] = -1;
    _nj11 = -1;
    j12 = numeric_limits<IkReal>::quiet_NaN();
    _ij12[0] = -1;
    _ij12[1] = -1;
    _nj12 = -1;
    _ij8[0] = -1;
    _ij8[1] = -1;
    _nj8 = 0;
    for (int dummyiter = 0; dummyiter < 1; ++dummyiter)
    {
      solutions.Clear();
      j8 = pfree[0];
      cj8 = cos(pfree[0]);
      sj8 = sin(pfree[0]), htj8 = tan(pfree[0] * 0.5);
      r00 = eerot[0 * 3 + 0];
      r01 = eerot[0 * 3 + 1];
      r02 = eerot[0 * 3 + 2];
      r10 = eerot[1 * 3 + 0];
      r11 = eerot[1 * 3 + 1];
      r12 = eerot[1 * 3 + 2];
      r20 = eerot[2 * 3 + 0];
      r21 = eerot[2 * 3 + 1];
      r22 = eerot[2 * 3 + 2];
      px = eetrans[0];
      py = eetrans[1];
      pz = eetrans[2];

      new_r00 = r00;
      new_r01 = r01;
      new_r02 = r02;
      new_px = ((-0.22) + px);
      new_r10 = r10;
      new_r11 = r11;
      new_r12 = r12;
      new_py = ((-0.14) + py);
      new_r20 = r20;
      new_r21 = r21;
      new_r22 = r22;
      new_pz = ((-0.346) + pz);
      r00 = new_r00;
      r01 = new_r01;
      r02 = new_r02;
      r10 = new_r10;
      r11 = new_r11;
      r12 = new_r12;
      r20 = new_r20;
      r21 = new_r21;
      r22 = new_r22;
      px = new_px;
      py = new_py;
      pz = new_pz;
      IkReal x64 = ((1.0) * py);
      IkReal x65 = ((1.0) * pz);
      IkReal x66 = ((1.0) * px);
      pp = ((pz * pz) + (py * py) + (px * px));
      npx = (((pz * r20)) + ((py * r10)) + ((px * r00)));
      npy = (((pz * r21)) + ((py * r11)) + ((px * r01)));
      npz = (((px * r02)) + ((pz * r22)) + ((py * r12)));
      rxp0_0 = (((pz * r10)) + (((-1.0) * r20 * x64)));
      rxp0_1 = (((px * r20)) + (((-1.0) * r00 * x65)));
      rxp0_2 = (((py * r00)) + (((-1.0) * r10 * x66)));
      rxp1_0 = ((((-1.0) * r21 * x64)) + ((pz * r11)));
      rxp1_1 = (((px * r21)) + (((-1.0) * r01 * x65)));
      rxp1_2 = ((((-1.0) * r11 * x66)) + ((py * r01)));
      rxp2_0 = ((((-1.0) * r22 * x64)) + ((pz * r12)));
      rxp2_1 = ((((-1.0) * r02 * x65)) + ((px * r22)));
      rxp2_2 = (((py * r02)) + (((-1.0) * r12 * x66)));
      {
        IkReal j9array[2], cj9array[2], sj9array[2];
        bool j9valid[2] = {false};
        _nj9 = 2;
        if ((((-1.18441410190393) + (((2.9867963734811) * pp))))
                < -1 - IKFAST_SINCOS_THRESH
            || (((-1.18441410190393) + (((2.9867963734811) * pp))))
                   > 1 + IKFAST_SINCOS_THRESH)
          continue;
        IkReal x67 = IKasin(((-1.18441410190393) + (((2.9867963734811) * pp))));
        j9array[0] = ((-1.34027003705633) + (((1.0) * x67)));
        sj9array[0] = IKsin(j9array[0]);
        cj9array[0] = IKcos(j9array[0]);
        j9array[1] = ((1.80132261653346) + (((-1.0) * x67)));
        sj9array[1] = IKsin(j9array[1]);
        cj9array[1] = IKcos(j9array[1]);
        if (j9array[0] > IKPI)
        {
          j9array[0] -= IK2PI;
        }
        else if (j9array[0] < -IKPI)
        {
          j9array[0] += IK2PI;
        }
        j9valid[0] = true;
        if (j9array[1] > IKPI)
        {
          j9array[1] -= IK2PI;
        }
        else if (j9array[1] < -IKPI)
        {
          j9array[1] += IK2PI;
        }
        j9valid[1] = true;
        for (int ij9 = 0; ij9 < 2; ++ij9)
        {
          if (!j9valid[ij9])
          {
            continue;
          }
          _ij9[0] = ij9;
          _ij9[1] = -1;
          for (int iij9 = ij9 + 1; iij9 < 2; ++iij9)
          {
            if (j9valid[iij9]
                && IKabs(cj9array[ij9] - cj9array[iij9])
                       < IKFAST_SOLUTION_THRESH
                && IKabs(sj9array[ij9] - sj9array[iij9])
                       < IKFAST_SOLUTION_THRESH)
            {
              j9valid[iij9] = false;
              _ij9[1] = iij9;
              break;
            }
          }
          j9 = j9array[ij9];
          cj9 = cj9array[ij9];
          sj9 = sj9array[ij9];

          {
            IkReal j4eval[2];
            j4eval[0] = ((IKabs(py)) + (IKabs(px)));
            j4eval[1] = ((py * py) + (px * px));
            if (IKabs(j4eval[0]) < 0.0000010000000000
                || IKabs(j4eval[1]) < 0.0000010000000000)
            {
              {
                IkReal j6eval[2];
                IkReal x68 = cj8 * cj8;
                IkReal x69 = sj9 * sj9;
                IkReal x70 = ((13.3333333333333) * sj9);
                IkReal x71 = (cj9 * x70);
                IkReal x72 = cj9 * cj9;
                IkReal x73 = ((3.0) * cj8);
                j6eval[0]
                    = ((149.382716049383) + (((-2.0) * cj9 * x68))
                       + ((x68 * x72)) + (((44.4444444444444) * x68 * x69))
                       + (((44.4444444444444) * x72)) + x68 + x69
                       + (((24.4444444444444) * sj9))
                       + (((162.962962962963) * cj9)) + x71
                       + (((-1.0) * x68 * x71)) + ((x68 * x70)));
                j6eval[1]
                    = ((((66.6666666666667)
                         * (IKabs(
                             ((-0.55) + (((-1.0) * (0.3) * cj9))
                              + (((-1.0) * (0.045) * sj9)))))))
                       + (IKabs(
                           ((((-1.0) * cj9 * x73)) + x73
                            + (((20.0) * cj8 * sj9))))));
                if (IKabs(j6eval[0]) < 0.0000010000000000
                    || IKabs(j6eval[1]) < 0.0000010000000000)
                {
                  {
                    IkReal j4eval[2];
                    IkReal x74 = cj8 * cj8 * cj8 * cj8;
                    IkReal x75 = py * py * py * py;
                    IkReal x76 = sj8 * sj8 * sj8 * sj8;
                    IkReal x77 = px * px;
                    IkReal x78 = py * py;
                    IkReal x79 = (x77 * x78);
                    IkReal x80 = sj8 * sj8;
                    IkReal x81 = ((2.0) * x80);
                    IkReal x82 = cj8 * cj8;
                    IkReal x83 = (px * py);
                    j4eval[0]
                        = (((x75 * x76)) + ((x74 * x75)) + ((x76 * x79))
                           + ((x74 * x79)) + ((x75 * x81 * x82))
                           + ((x77 * x78 * x81 * x82)));
                    j4eval[1]
                        = ((IKabs((((x80 * x83)) + ((x82 * x83)))))
                           + (IKabs((((x78 * x82)) + ((x78 * x80))))));
                    if (IKabs(j4eval[0]) < 0.0000010000000000
                        || IKabs(j4eval[1]) < 0.0000010000000000)
                    {
                      continue; // no branches [j4, j6]
                    }
                    else
                    {
                      {
                        IkReal j4array[2], cj4array[2], sj4array[2];
                        bool j4valid[2] = {false};
                        _nj4 = 2;
                        IkReal x84 = cj8 * cj8;
                        IkReal x85 = py * py;
                        IkReal x86 = sj8 * sj8;
                        IkReal x87 = (((x85 * x86)) + ((x84 * x85)));
                        IkReal x88 = ((1.0) * px * py);
                        IkReal x89
                            = ((((-1.0) * x86 * x88)) + (((-1.0) * x84 * x88)));
                        CheckValue<IkReal> x93 = IKatan2WithCheck(
                            IkReal(x87), x89, IKFAST_ATAN2_MAGTHRESH);
                        if (!x93.valid)
                        {
                          continue;
                        }
                        IkReal x90 = ((-1.0) * (x93.value));
                        IkReal x91 = ((0.045) * py * sj8);
                        if ((((x87 * x87) + (x89 * x89))) < -0.00001)
                          continue;
                        CheckValue<IkReal> x94 = IKPowWithIntegerCheck(
                            IKabs(IKsqrt(((x87 * x87) + (x89 * x89)))), -1);
                        if (!x94.valid)
                        {
                          continue;
                        }
                        if ((((x94.value)
                              * ((((cj9 * x91)) + (((-1.0) * x91))
                                  + (((-1.0) * (0.3) * py * sj8 * sj9))))))
                                < -1 - IKFAST_SINCOS_THRESH
                            || (((x94.value)
                                 * ((((cj9 * x91)) + (((-1.0) * x91))
                                     + (((-1.0) * (0.3) * py * sj8 * sj9))))))
                                   > 1 + IKFAST_SINCOS_THRESH)
                          continue;
                        IkReal x92 = IKasin(
                            ((x94.value)
                             * ((((cj9 * x91)) + (((-1.0) * x91))
                                 + (((-1.0) * (0.3) * py * sj8 * sj9))))));
                        j4array[0] = (x90 + (((-1.0) * x92)));
                        sj4array[0] = IKsin(j4array[0]);
                        cj4array[0] = IKcos(j4array[0]);
                        j4array[1] = ((3.14159265358979) + x92 + x90);
                        sj4array[1] = IKsin(j4array[1]);
                        cj4array[1] = IKcos(j4array[1]);
                        if (j4array[0] > IKPI)
                        {
                          j4array[0] -= IK2PI;
                        }
                        else if (j4array[0] < -IKPI)
                        {
                          j4array[0] += IK2PI;
                        }
                        j4valid[0] = true;
                        if (j4array[1] > IKPI)
                        {
                          j4array[1] -= IK2PI;
                        }
                        else if (j4array[1] < -IKPI)
                        {
                          j4array[1] += IK2PI;
                        }
                        j4valid[1] = true;
                        for (int ij4 = 0; ij4 < 2; ++ij4)
                        {
                          if (!j4valid[ij4])
                          {
                            continue;
                          }
                          _ij4[0] = ij4;
                          _ij4[1] = -1;
                          for (int iij4 = ij4 + 1; iij4 < 2; ++iij4)
                          {
                            if (j4valid[iij4]
                                && IKabs(cj4array[ij4] - cj4array[iij4])
                                       < IKFAST_SOLUTION_THRESH
                                && IKabs(sj4array[ij4] - sj4array[iij4])
                                       < IKFAST_SOLUTION_THRESH)
                            {
                              j4valid[iij4] = false;
                              _ij4[1] = iij4;
                              break;
                            }
                          }
                          j4 = j4array[ij4];
                          cj4 = cj4array[ij4];
                          sj4 = sj4array[ij4];
                          {
                            IkReal evalcond[2];
                            IkReal x95 = ((0.045) * sj8);
                            IkReal x96 = (cj9 * x95);
                            IkReal x97 = ((0.3) * sj8 * sj9);
                            IkReal x98 = IKcos(j4);
                            IkReal x99 = cj8 * cj8;
                            IkReal x100 = (px * py);
                            IkReal x101 = sj8 * sj8;
                            IkReal x102 = IKsin(j4);
                            IkReal x103 = ((1.0) * (px * px));
                            evalcond[0]
                                = ((((-1.0) * px * x95)) + ((px * x96))
                                   + ((x98
                                       * ((((x100 * x101)) + ((x100 * x99))))))
                                   + (((-1.0) * px * x97))
                                   + ((x102
                                       * (((((-1.0) * x101 * x103))
                                           + (((-1.0) * x103 * x99)))))));
                            evalcond[1]
                                = (x95 + x97 + ((px * x102)) + (((-1.0) * x96))
                                   + (((-1.0) * py * x98)));
                            if (IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH
                                || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH)
                            {
                              continue;
                            }
                          }

                          {
                            IkReal j6eval[2];
                            IkReal x104 = (cj4 * px);
                            IkReal x105 = (cj8 * pz);
                            IkReal x106 = (py * sj4);
                            IkReal x107 = (cj4 * cj9 * px);
                            IkReal x108 = (cj4 * px * sj9);
                            IkReal x109 = (cj8 * pz * sj9);
                            IkReal x110 = (cj9 * py * sj4);
                            IkReal x111 = (py * sj4 * sj9);
                            IkReal x112 = ((0.045) * x105);
                            j6eval[0]
                                = ((((-1.0) * x111)) + (((-1.0) * x108))
                                   + (((-12.2222222222222) * x106))
                                   + (((-6.66666666666667) * x109))
                                   + ((cj9 * x105))
                                   + (((-12.2222222222222) * x104))
                                   + (((-1.0) * x105))
                                   + (((-6.66666666666667) * x110))
                                   + (((-6.66666666666667) * x107)));
                            j6eval[1] = IKsign(
                                ((((-1.0) * x112)) + (((-0.045) * x108))
                                 + (((-0.55) * x106)) + (((-0.55) * x104))
                                 + ((cj9 * x112)) + (((-0.3) * x107))
                                 + (((-0.045) * x111)) + (((-0.3) * x110))
                                 + (((-0.3) * x109))));
                            if (IKabs(j6eval[0]) < 0.0000010000000000
                                || IKabs(j6eval[1]) < 0.0000010000000000)
                            {
                              {
                                IkReal j6eval[2];
                                IkReal x113 = (sj8 * (py * py));
                                IkReal x114 = cj4 * cj4;
                                IkReal x115
                                    = (((sj8 * x114 * (px * px)))
                                       + ((sj8 * (pz * pz)))
                                       + (((-1.0) * x113 * x114))
                                       + (((2.0) * cj4 * px * py * sj4 * sj8))
                                       + x113);
                                j6eval[0] = x115;
                                j6eval[1] = IKsign(x115);
                                if (IKabs(j6eval[0]) < 0.0000010000000000
                                    || IKabs(j6eval[1]) < 0.0000010000000000)
                                {
                                  {
                                    IkReal j6eval[2];
                                    IkReal x116 = (pz * sj8);
                                    IkReal x117 = (cj9 * pz * sj8);
                                    IkReal x118 = (pz * sj8 * sj9);
                                    IkReal x119 = (cj8 * sj8);
                                    IkReal x120 = (cj4 * px * x119);
                                    IkReal x121 = (py * sj4 * x119);
                                    IkReal x122 = ((1.0) * cj9);
                                    IkReal x123 = (cj4 * cj8 * px * sj8 * sj9);
                                    IkReal x124 = (cj8 * py * sj4 * sj8 * sj9);
                                    IkReal x125 = ((0.045) * x120);
                                    IkReal x126 = ((0.045) * x121);
                                    j6eval[0]
                                        = ((((6.66666666666667) * x123))
                                           + (((-1.0) * x121 * x122)) + x120
                                           + x121
                                           + (((-12.2222222222222) * x116))
                                           + (((-1.0) * x120 * x122))
                                           + (((6.66666666666667) * x124))
                                           + (((-6.66666666666667) * x117))
                                           + (((-1.0) * x118)));
                                    j6eval[1] = IKsign((
                                        (((-1.0) * cj9 * x126)) + x125 + x126
                                        + (((-0.55) * x116)) + (((0.3) * x123))
                                        + (((0.3) * x124)) + (((-0.045) * x118))
                                        + (((-0.3) * x117))
                                        + (((-1.0) * cj9 * x125))));
                                    if (IKabs(j6eval[0]) < 0.0000010000000000
                                        || IKabs(j6eval[1])
                                               < 0.0000010000000000)
                                    {
                                      {
                                        IkReal evalcond[4];
                                        bool bgotonextstatement = true;
                                        do
                                        {
                                          IkReal x127
                                              = (((px * sj4))
                                                 + (((-1.0) * (1.0) * cj4
                                                     * py)));
                                          evalcond[0]
                                              = ((-3.14159265358979)
                                                 + (IKfmod(
                                                     ((3.14159265358979)
                                                      + (IKabs(j8))),
                                                     6.28318530717959)));
                                          evalcond[1]
                                              = ((0.39655) + (((0.0765) * sj9))
                                                 + (((0.32595) * cj9))
                                                 + (((-1.0) * (1.0) * pp)));
                                          evalcond[2] = x127;
                                          evalcond[3] = x127;
                                          if (IKabs(evalcond[0])
                                                  < 0.0000010000000000
                                              && IKabs(evalcond[1])
                                                     < 0.0000010000000000
                                              && IKabs(evalcond[2])
                                                     < 0.0000010000000000
                                              && IKabs(evalcond[3])
                                                     < 0.0000010000000000)
                                          {
                                            bgotonextstatement = false;
                                            {
                                              IkReal j6eval[2];
                                              sj8 = 0;
                                              cj8 = 1.0;
                                              j8 = 0;
                                              IkReal x128 = (cj9 * pz);
                                              IkReal x129 = (cj4 * px);
                                              IkReal x130 = (pp * pz);
                                              IkReal x131 = (py * sj4);
                                              IkReal x132 = (cj4 * cj9 * px);
                                              IkReal x133 = (cj4 * pp * px);
                                              IkReal x134 = (cj9 * py * sj4);
                                              IkReal x135 = (pp * py * sj4);
                                              j6eval[0]
                                                  = (x128
                                                     + (((5.4333061668025)
                                                         * x130))
                                                     + (((13.9482024812098)
                                                         * x129))
                                                     + (((12.2222222222222)
                                                         * x134))
                                                     + (((2.92556370551481)
                                                         * pz))
                                                     + (((12.2222222222222)
                                                         * x132))
                                                     + (((-36.2220411120167)
                                                         * x135))
                                                     + (((13.9482024812098)
                                                         * x131))
                                                     + (((-36.2220411120167)
                                                         * x133)));
                                              j6eval[1] = IKsign((
                                                  (((1.32323529411765) * x132))
                                                  + (((0.316735294117647) * pz))
                                                  + (((0.108264705882353)
                                                      * x128))
                                                  + (((-3.92156862745098)
                                                      * x135))
                                                  + (((1.32323529411765)
                                                      * x134))
                                                  + (((1.51009803921569)
                                                      * x131))
                                                  + (((1.51009803921569)
                                                      * x129))
                                                  + (((0.588235294117647)
                                                      * x130))
                                                  + (((-3.92156862745098)
                                                      * x133))));
                                              if (IKabs(j6eval[0])
                                                      < 0.0000010000000000
                                                  || IKabs(j6eval[1])
                                                         < 0.0000010000000000)
                                              {
                                                {
                                                  IkReal j6eval[2];
                                                  sj8 = 0;
                                                  cj8 = 1.0;
                                                  j8 = 0;
                                                  IkReal x136 = (cj4 * px);
                                                  IkReal x137 = (py * sj4);
                                                  IkReal x138 = (cj9 * pz);
                                                  IkReal x139 = (pz * sj9);
                                                  IkReal x140 = ((1.0) * cj9);
                                                  IkReal x141
                                                      = (cj4 * px * sj9);
                                                  IkReal x142
                                                      = (py * sj4 * sj9);
                                                  IkReal x143
                                                      = ((0.045) * x136);
                                                  IkReal x144
                                                      = ((0.045) * x137);
                                                  j6eval[0]
                                                      = (x137 + x136
                                                         + (((-1.0)
                                                             * (12.2222222222222)
                                                             * pz))
                                                         + (((6.66666666666667)
                                                             * x141))
                                                         + (((-1.0) * x136
                                                             * x140))
                                                         + (((6.66666666666667)
                                                             * x142))
                                                         + (((-6.66666666666667)
                                                             * x138))
                                                         + (((-1.0) * x139))
                                                         + (((-1.0) * x137
                                                             * x140)));
                                                  j6eval[1] = IKsign((
                                                      (((-0.3) * x138))
                                                      + (((-1.0) * (0.55) * pz))
                                                      + (((0.3) * x142)) + x143
                                                      + x144 + (((0.3) * x141))
                                                      + (((-0.045) * x139))
                                                      + (((-1.0) * cj9 * x143))
                                                      + (((-1.0) * cj9
                                                          * x144))));
                                                  if (IKabs(j6eval[0])
                                                          < 0.0000010000000000
                                                      || IKabs(j6eval[1])
                                                             < 0.0000010000000000)
                                                  {
                                                    {
                                                      IkReal j6eval[2];
                                                      sj8 = 0;
                                                      cj8 = 1.0;
                                                      j8 = 0;
                                                      IkReal x145 = (cj4 * px);
                                                      IkReal x146 = (cj9 * pz);
                                                      IkReal x147 = (pp * pz);
                                                      IkReal x148 = (py * sj4);
                                                      IkReal x149
                                                          = (cj4 * cj9 * px);
                                                      IkReal x150
                                                          = (cj4 * pp * px);
                                                      IkReal x151
                                                          = (cj9 * py * sj4);
                                                      IkReal x152
                                                          = (pp * py * sj4);
                                                      j6eval[0]
                                                          = ((((-1.0) * x151))
                                                             + (((-5.4333061668025)
                                                                 * x150))
                                                             + (((-1.0) * x149))
                                                             + (((-5.4333061668025)
                                                                 * x152))
                                                             + (((12.2222222222222)
                                                                 * x146))
                                                             + (((13.9482024812098)
                                                                 * pz))
                                                             + (((-2.92556370551481)
                                                                 * x148))
                                                             + (((-2.92556370551481)
                                                                 * x145))
                                                             + (((-36.2220411120167)
                                                                 * x147)));
                                                      j6eval[1] = IKsign((
                                                          (((-0.108264705882353)
                                                            * x151))
                                                          + (((1.51009803921569)
                                                              * pz))
                                                          + (((-0.588235294117647)
                                                              * x152))
                                                          + (((-0.316735294117647)
                                                              * x148))
                                                          + (((-0.588235294117647)
                                                              * x150))
                                                          + (((-0.108264705882353)
                                                              * x149))
                                                          + (((1.32323529411765)
                                                              * x146))
                                                          + (((-3.92156862745098)
                                                              * x147))
                                                          + (((-0.316735294117647)
                                                              * x145))));
                                                      if (IKabs(j6eval[0])
                                                              < 0.0000010000000000
                                                          || IKabs(j6eval[1])
                                                                 < 0.0000010000000000)
                                                      {
                                                        {
                                                          IkReal evalcond[1];
                                                          bool
                                                              bgotonextstatement
                                                              = true;
                                                          do
                                                          {
                                                            evalcond[0]
                                                                = ((IKabs((
                                                                       (-3.14159265358979)
                                                                       + (IKfmod(
                                                                           ((3.14159265358979)
                                                                            + j9),
                                                                           6.28318530717959)))))
                                                                   + (IKabs(
                                                                       pz)));
                                                            if (IKabs(
                                                                    evalcond[0])
                                                                < 0.0000010000000000)
                                                            {
                                                              bgotonextstatement
                                                                  = false;
                                                              {
                                                                IkReal
                                                                    j6eval[1];
                                                                IkReal x153
                                                                    = ((1.0)
                                                                       * py);
                                                                sj8 = 0;
                                                                cj8 = 1.0;
                                                                j8 = 0;
                                                                pz = 0;
                                                                j9 = 0;
                                                                sj9 = 0;
                                                                cj9 = 1.0;
                                                                pp
                                                                    = ((py * py)
                                                                       + (px
                                                                          * px));
                                                                npx
                                                                    = (((py
                                                                         * r10))
                                                                       + ((px
                                                                           * r00)));
                                                                npy
                                                                    = (((py
                                                                         * r11))
                                                                       + ((px
                                                                           * r01)));
                                                                npz
                                                                    = (((px
                                                                         * r02))
                                                                       + ((py
                                                                           * r12)));
                                                                rxp0_0
                                                                    = ((-1.0)
                                                                       * r20
                                                                       * x153);
                                                                rxp0_1
                                                                    = (px
                                                                       * r20);
                                                                rxp1_0
                                                                    = ((-1.0)
                                                                       * r21
                                                                       * x153);
                                                                rxp1_1
                                                                    = (px
                                                                       * r21);
                                                                rxp2_0
                                                                    = ((-1.0)
                                                                       * r22
                                                                       * x153);
                                                                rxp2_1
                                                                    = (px
                                                                       * r22);
                                                                j6eval[0]
                                                                    = (((py
                                                                         * sj4))
                                                                       + ((cj4
                                                                           * px)));
                                                                if (IKabs(
                                                                        j6eval
                                                                            [0])
                                                                    < 0.0000010000000000)
                                                                {
                                                                  {
                                                                    IkReal
                                                                        j6eval
                                                                            [1];
                                                                    IkReal x154
                                                                        = ((1.0)
                                                                           * py);
                                                                    sj8 = 0;
                                                                    cj8 = 1.0;
                                                                    j8 = 0;
                                                                    pz = 0;
                                                                    j9 = 0;
                                                                    sj9 = 0;
                                                                    cj9 = 1.0;
                                                                    pp
                                                                        = ((py
                                                                            * py)
                                                                           + (px
                                                                              * px));
                                                                    npx
                                                                        = (((py
                                                                             * r10))
                                                                           + ((px
                                                                               * r00)));
                                                                    npy
                                                                        = (((py
                                                                             * r11))
                                                                           + ((px
                                                                               * r01)));
                                                                    npz
                                                                        = (((px
                                                                             * r02))
                                                                           + ((py
                                                                               * r12)));
                                                                    rxp0_0
                                                                        = ((-1.0)
                                                                           * r20
                                                                           * x154);
                                                                    rxp0_1
                                                                        = (px
                                                                           * r20);
                                                                    rxp1_0
                                                                        = ((-1.0)
                                                                           * r21
                                                                           * x154);
                                                                    rxp1_1
                                                                        = (px
                                                                           * r21);
                                                                    rxp2_0
                                                                        = ((-1.0)
                                                                           * r22
                                                                           * x154);
                                                                    rxp2_1
                                                                        = (px
                                                                           * r22);
                                                                    j6eval[0]
                                                                        = ((-1.0)
                                                                           + (((-1.0)
                                                                               * (1.3840830449827)
                                                                               * (px
                                                                                  * px)))
                                                                           + (((-1.0)
                                                                               * (1.3840830449827)
                                                                               * (py
                                                                                  * py))));
                                                                    if (IKabs(
                                                                            j6eval
                                                                                [0])
                                                                        < 0.0000010000000000)
                                                                    {
                                                                      {
                                                                        IkReal j6eval
                                                                            [2];
                                                                        IkReal
                                                                            x155
                                                                            = ((1.0)
                                                                               * py);
                                                                        sj8 = 0;
                                                                        cj8 = 1.0;
                                                                        j8 = 0;
                                                                        pz = 0;
                                                                        j9 = 0;
                                                                        sj9 = 0;
                                                                        cj9 = 1.0;
                                                                        pp
                                                                            = ((py
                                                                                * py)
                                                                               + (px
                                                                                  * px));
                                                                        npx
                                                                            = (((py
                                                                                 * r10))
                                                                               + ((px
                                                                                   * r00)));
                                                                        npy
                                                                            = (((py
                                                                                 * r11))
                                                                               + ((px
                                                                                   * r01)));
                                                                        npz
                                                                            = (((px
                                                                                 * r02))
                                                                               + ((py
                                                                                   * r12)));
                                                                        rxp0_0
                                                                            = ((-1.0)
                                                                               * r20
                                                                               * x155);
                                                                        rxp0_1
                                                                            = (px
                                                                               * r20);
                                                                        rxp1_0
                                                                            = ((-1.0)
                                                                               * r21
                                                                               * x155);
                                                                        rxp1_1
                                                                            = (px
                                                                               * r21);
                                                                        rxp2_0
                                                                            = ((-1.0)
                                                                               * r22
                                                                               * x155);
                                                                        rxp2_1
                                                                            = (px
                                                                               * r22);
                                                                        IkReal
                                                                            x156
                                                                            = (cj4
                                                                               * px);
                                                                        IkReal
                                                                            x157
                                                                            = (py
                                                                               * sj4);
                                                                        j6eval
                                                                            [0]
                                                                            = (x156
                                                                               + x157);
                                                                        j6eval
                                                                            [1]
                                                                            = ((((-1.0)
                                                                                 * (1.3840830449827)
                                                                                 * cj4
                                                                                 * (px
                                                                                    * px
                                                                                    * px)))
                                                                               + (((-1.0)
                                                                                   * x157))
                                                                               + (((-1.3840830449827)
                                                                                   * x157
                                                                                   * (px
                                                                                      * px)))
                                                                               + (((-1.3840830449827)
                                                                                   * x156
                                                                                   * (py
                                                                                      * py)))
                                                                               + (((-1.0)
                                                                                   * x156))
                                                                               + (((-1.0)
                                                                                   * (1.3840830449827)
                                                                                   * sj4
                                                                                   * (py
                                                                                      * py
                                                                                      * py))));
                                                                        if (IKabs(
                                                                                j6eval
                                                                                    [0])
                                                                                < 0.0000010000000000
                                                                            || IKabs(
                                                                                   j6eval
                                                                                       [1])
                                                                                   < 0.0000010000000000)
                                                                        {
                                                                          {
                                                                            IkReal evalcond
                                                                                [4];
                                                                            bool
                                                                                bgotonextstatement
                                                                                = true;
                                                                            do
                                                                            {
                                                                              evalcond
                                                                                  [0]
                                                                                  = ((IKabs(
                                                                                         py))
                                                                                     + (IKabs(
                                                                                         px)));
                                                                              evalcond
                                                                                  [1]
                                                                                  = -0.85;
                                                                              evalcond
                                                                                  [2]
                                                                                  = 0;
                                                                              evalcond
                                                                                  [3]
                                                                                  = -0.2125;
                                                                              if (IKabs(
                                                                                      evalcond
                                                                                          [0])
                                                                                      < 0.0000010000000000
                                                                                  && IKabs(
                                                                                         evalcond
                                                                                             [1])
                                                                                         < 0.0000010000000000
                                                                                  && IKabs(
                                                                                         evalcond
                                                                                             [2])
                                                                                         < 0.0000010000000000
                                                                                  && IKabs(
                                                                                         evalcond
                                                                                             [3])
                                                                                         < 0.0000010000000000)
                                                                              {
                                                                                bgotonextstatement
                                                                                    = false;
                                                                                {
                                                                                  IkReal j6array
                                                                                      [2],
                                                                                      cj6array
                                                                                          [2],
                                                                                      sj6array
                                                                                          [2];
                                                                                  bool j6valid
                                                                                      [2]
                                                                                      = {false};
                                                                                  _nj6
                                                                                      = 2;
                                                                                  j6array
                                                                                      [0]
                                                                                      = 2.9927027059803;
                                                                                  sj6array
                                                                                      [0]
                                                                                      = IKsin(
                                                                                          j6array
                                                                                              [0]);
                                                                                  cj6array
                                                                                      [0]
                                                                                      = IKcos(
                                                                                          j6array
                                                                                              [0]);
                                                                                  j6array
                                                                                      [1]
                                                                                      = 6.13429535957009;
                                                                                  sj6array
                                                                                      [1]
                                                                                      = IKsin(
                                                                                          j6array
                                                                                              [1]);
                                                                                  cj6array
                                                                                      [1]
                                                                                      = IKcos(
                                                                                          j6array
                                                                                              [1]);
                                                                                  if (j6array
                                                                                          [0]
                                                                                      > IKPI)
                                                                                  {
                                                                                    j6array
                                                                                        [0]
                                                                                        -= IK2PI;
                                                                                  }
                                                                                  else if (
                                                                                      j6array
                                                                                          [0]
                                                                                      < -IKPI)
                                                                                  {
                                                                                    j6array
                                                                                        [0]
                                                                                        += IK2PI;
                                                                                  }
                                                                                  j6valid
                                                                                      [0]
                                                                                      = true;
                                                                                  if (j6array
                                                                                          [1]
                                                                                      > IKPI)
                                                                                  {
                                                                                    j6array
                                                                                        [1]
                                                                                        -= IK2PI;
                                                                                  }
                                                                                  else if (
                                                                                      j6array
                                                                                          [1]
                                                                                      < -IKPI)
                                                                                  {
                                                                                    j6array
                                                                                        [1]
                                                                                        += IK2PI;
                                                                                  }
                                                                                  j6valid
                                                                                      [1]
                                                                                      = true;
                                                                                  for (
                                                                                      int ij6
                                                                                      = 0;
                                                                                      ij6
                                                                                      < 2;
                                                                                      ++ij6)
                                                                                  {
                                                                                    if (!j6valid
                                                                                            [ij6])
                                                                                    {
                                                                                      continue;
                                                                                    }
                                                                                    _ij6[0]
                                                                                        = ij6;
                                                                                    _ij6[1]
                                                                                        = -1;
                                                                                    for (
                                                                                        int iij6
                                                                                        = ij6
                                                                                          + 1;
                                                                                        iij6
                                                                                        < 2;
                                                                                        ++iij6)
                                                                                    {
                                                                                      if (j6valid
                                                                                              [iij6]
                                                                                          && IKabs(
                                                                                                 cj6array
                                                                                                     [ij6]
                                                                                                 - cj6array
                                                                                                     [iij6])
                                                                                                 < IKFAST_SOLUTION_THRESH
                                                                                          && IKabs(
                                                                                                 sj6array
                                                                                                     [ij6]
                                                                                                 - sj6array
                                                                                                     [iij6])
                                                                                                 < IKFAST_SOLUTION_THRESH)
                                                                                      {
                                                                                        j6valid
                                                                                            [iij6]
                                                                                            = false;
                                                                                        _ij6[1]
                                                                                            = iij6;
                                                                                        break;
                                                                                      }
                                                                                    }
                                                                                    j6 = j6array
                                                                                        [ij6];
                                                                                    cj6 = cj6array
                                                                                        [ij6];
                                                                                    sj6 = sj6array
                                                                                        [ij6];
                                                                                    {
                                                                                      IkReal evalcond
                                                                                          [1];
                                                                                      evalcond
                                                                                          [0]
                                                                                          = ((0.85)
                                                                                             * (IKsin(
                                                                                                 j6)));
                                                                                      if (IKabs(
                                                                                              evalcond
                                                                                                  [0])
                                                                                          > IKFAST_EVALCOND_THRESH)
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                    }

                                                                                    rotationfunction0(
                                                                                        solutions);
                                                                                  }
                                                                                }
                                                                              }
                                                                            } while (
                                                                                0);
                                                                            if (bgotonextstatement)
                                                                            {
                                                                              bool
                                                                                  bgotonextstatement
                                                                                  = true;
                                                                              do
                                                                              {
                                                                                evalcond
                                                                                    [0]
                                                                                    = ((IKabs((
                                                                                           (-3.14159265358979)
                                                                                           + (IKfmod(
                                                                                               ((3.14159265358979)
                                                                                                + j4),
                                                                                               6.28318530717959)))))
                                                                                       + (IKabs(
                                                                                           px)));
                                                                                evalcond
                                                                                    [1]
                                                                                    = -0.85;
                                                                                evalcond
                                                                                    [2]
                                                                                    = 0;
                                                                                evalcond
                                                                                    [3]
                                                                                    = ((-0.2125)
                                                                                       + (((-1.0)
                                                                                           * (1.0)
                                                                                           * (py
                                                                                              * py))));
                                                                                if (IKabs(
                                                                                        evalcond
                                                                                            [0])
                                                                                        < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [1])
                                                                                           < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [2])
                                                                                           < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [3])
                                                                                           < 0.0000010000000000)
                                                                                {
                                                                                  bgotonextstatement
                                                                                      = false;
                                                                                  {
                                                                                    IkReal j6eval
                                                                                        [1];
                                                                                    IkReal
                                                                                        x606
                                                                                        = ((1.0)
                                                                                           * py);
                                                                                    sj8 = 0;
                                                                                    cj8 = 1.0;
                                                                                    j8 = 0;
                                                                                    pz = 0;
                                                                                    j9 = 0;
                                                                                    sj9 = 0;
                                                                                    cj9 = 1.0;
                                                                                    pp = py
                                                                                         * py;
                                                                                    npx
                                                                                        = (py
                                                                                           * r10);
                                                                                    npy
                                                                                        = (py
                                                                                           * r11);
                                                                                    npz
                                                                                        = (py
                                                                                           * r12);
                                                                                    rxp0_0
                                                                                        = ((-1.0)
                                                                                           * r20
                                                                                           * x606);
                                                                                    rxp0_1
                                                                                        = 0;
                                                                                    rxp1_0
                                                                                        = ((-1.0)
                                                                                           * r21
                                                                                           * x606);
                                                                                    rxp1_1
                                                                                        = 0;
                                                                                    rxp2_0
                                                                                        = ((-1.0)
                                                                                           * r22
                                                                                           * x606);
                                                                                    rxp2_1
                                                                                        = 0;
                                                                                    px = 0;
                                                                                    j4 = 0;
                                                                                    sj4 = 0;
                                                                                    cj4 = 1.0;
                                                                                    rxp0_2
                                                                                        = (py
                                                                                           * r00);
                                                                                    rxp1_2
                                                                                        = (py
                                                                                           * r01);
                                                                                    rxp2_2
                                                                                        = (py
                                                                                           * r02);
                                                                                    j6eval
                                                                                        [0]
                                                                                        = ((1.0)
                                                                                           + (((1.91568587540858)
                                                                                               * (py
                                                                                                  * py
                                                                                                  * py
                                                                                                  * py)))
                                                                                           + (((-1.0)
                                                                                               * (2.64633970947792)
                                                                                               * (py
                                                                                                  * py))));
                                                                                    if (IKabs(
                                                                                            j6eval
                                                                                                [0])
                                                                                        < 0.0000010000000000)
                                                                                    {
                                                                                      continue; // no branches [j6]
                                                                                    }
                                                                                    else
                                                                                    {
                                                                                      {
                                                                                        IkReal j6array
                                                                                            [2],
                                                                                            cj6array
                                                                                                [2],
                                                                                            sj6array
                                                                                                [2];
                                                                                        bool j6valid
                                                                                            [2]
                                                                                            = {false};
                                                                                        _nj6
                                                                                            = 2;
                                                                                        IkReal
                                                                                            x607
                                                                                            = py
                                                                                              * py;
                                                                                        CheckValue<IkReal> x609 = IKatan2WithCheck(
                                                                                            IkReal((
                                                                                                (-0.425)
                                                                                                + (((-0.588235294117647)
                                                                                                    * x607)))),
                                                                                            ((-2.83333333333333)
                                                                                             + (((3.92156862745098)
                                                                                                 * x607))),
                                                                                            IKFAST_ATAN2_MAGTHRESH);
                                                                                        if (!x609.valid)
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                        IkReal
                                                                                            x608
                                                                                            = ((-1.0)
                                                                                               * (x609.value));
                                                                                        j6array
                                                                                            [0]
                                                                                            = x608;
                                                                                        sj6array
                                                                                            [0]
                                                                                            = IKsin(
                                                                                                j6array
                                                                                                    [0]);
                                                                                        cj6array
                                                                                            [0]
                                                                                            = IKcos(
                                                                                                j6array
                                                                                                    [0]);
                                                                                        j6array
                                                                                            [1]
                                                                                            = ((3.14159265358979)
                                                                                               + x608);
                                                                                        sj6array
                                                                                            [1]
                                                                                            = IKsin(
                                                                                                j6array
                                                                                                    [1]);
                                                                                        cj6array
                                                                                            [1]
                                                                                            = IKcos(
                                                                                                j6array
                                                                                                    [1]);
                                                                                        if (j6array
                                                                                                [0]
                                                                                            > IKPI)
                                                                                        {
                                                                                          j6array
                                                                                              [0]
                                                                                              -= IK2PI;
                                                                                        }
                                                                                        else if (
                                                                                            j6array
                                                                                                [0]
                                                                                            < -IKPI)
                                                                                        {
                                                                                          j6array
                                                                                              [0]
                                                                                              += IK2PI;
                                                                                        }
                                                                                        j6valid
                                                                                            [0]
                                                                                            = true;
                                                                                        if (j6array
                                                                                                [1]
                                                                                            > IKPI)
                                                                                        {
                                                                                          j6array
                                                                                              [1]
                                                                                              -= IK2PI;
                                                                                        }
                                                                                        else if (
                                                                                            j6array
                                                                                                [1]
                                                                                            < -IKPI)
                                                                                        {
                                                                                          j6array
                                                                                              [1]
                                                                                              += IK2PI;
                                                                                        }
                                                                                        j6valid
                                                                                            [1]
                                                                                            = true;
                                                                                        for (
                                                                                            int ij6
                                                                                            = 0;
                                                                                            ij6
                                                                                            < 2;
                                                                                            ++ij6)
                                                                                        {
                                                                                          if (!j6valid
                                                                                                  [ij6])
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          _ij6[0]
                                                                                              = ij6;
                                                                                          _ij6[1]
                                                                                              = -1;
                                                                                          for (
                                                                                              int iij6
                                                                                              = ij6
                                                                                                + 1;
                                                                                              iij6
                                                                                              < 2;
                                                                                              ++iij6)
                                                                                          {
                                                                                            if (j6valid
                                                                                                    [iij6]
                                                                                                && IKabs(
                                                                                                       cj6array
                                                                                                           [ij6]
                                                                                                       - cj6array
                                                                                                           [iij6])
                                                                                                       < IKFAST_SOLUTION_THRESH
                                                                                                && IKabs(
                                                                                                       sj6array
                                                                                                           [ij6]
                                                                                                       - sj6array
                                                                                                           [iij6])
                                                                                                       < IKFAST_SOLUTION_THRESH)
                                                                                            {
                                                                                              j6valid
                                                                                                  [iij6]
                                                                                                  = false;
                                                                                              _ij6[1]
                                                                                                  = iij6;
                                                                                              break;
                                                                                            }
                                                                                          }
                                                                                          j6 = j6array
                                                                                              [ij6];
                                                                                          cj6 = cj6array
                                                                                              [ij6];
                                                                                          sj6 = sj6array
                                                                                              [ij6];
                                                                                          {
                                                                                            IkReal evalcond
                                                                                                [1];
                                                                                            evalcond
                                                                                                [0]
                                                                                                = ((0.85)
                                                                                                   * (IKsin(
                                                                                                       j6)));
                                                                                            if (IKabs(
                                                                                                    evalcond
                                                                                                        [0])
                                                                                                > IKFAST_EVALCOND_THRESH)
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                          }

                                                                                          rotationfunction0(
                                                                                              solutions);
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              } while (
                                                                                  0);
                                                                              if (bgotonextstatement)
                                                                              {
                                                                                bool
                                                                                    bgotonextstatement
                                                                                    = true;
                                                                                do
                                                                                {
                                                                                  evalcond
                                                                                      [0]
                                                                                      = ((IKabs((
                                                                                             (-3.14159265358979)
                                                                                             + (IKfmod(
                                                                                                 j4,
                                                                                                 6.28318530717959)))))
                                                                                         + (IKabs(
                                                                                             px)));
                                                                                  evalcond
                                                                                      [1]
                                                                                      = -0.85;
                                                                                  evalcond
                                                                                      [2]
                                                                                      = 0;
                                                                                  evalcond
                                                                                      [3]
                                                                                      = ((-0.2125)
                                                                                         + (((-1.0)
                                                                                             * (1.0)
                                                                                             * (py
                                                                                                * py))));
                                                                                  if (IKabs(
                                                                                          evalcond
                                                                                              [0])
                                                                                          < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [1])
                                                                                             < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [2])
                                                                                             < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [3])
                                                                                             < 0.0000010000000000)
                                                                                  {
                                                                                    bgotonextstatement
                                                                                        = false;
                                                                                    {
                                                                                      IkReal j6eval
                                                                                          [1];
                                                                                      IkReal
                                                                                          x610
                                                                                          = ((1.0)
                                                                                             * py);
                                                                                      sj8 = 0;
                                                                                      cj8 = 1.0;
                                                                                      j8 = 0;
                                                                                      pz = 0;
                                                                                      j9 = 0;
                                                                                      sj9 = 0;
                                                                                      cj9 = 1.0;
                                                                                      pp = py
                                                                                           * py;
                                                                                      npx
                                                                                          = (py
                                                                                             * r10);
                                                                                      npy
                                                                                          = (py
                                                                                             * r11);
                                                                                      npz
                                                                                          = (py
                                                                                             * r12);
                                                                                      rxp0_0
                                                                                          = ((-1.0)
                                                                                             * r20
                                                                                             * x610);
                                                                                      rxp0_1
                                                                                          = 0;
                                                                                      rxp1_0
                                                                                          = ((-1.0)
                                                                                             * r21
                                                                                             * x610);
                                                                                      rxp1_1
                                                                                          = 0;
                                                                                      rxp2_0
                                                                                          = ((-1.0)
                                                                                             * r22
                                                                                             * x610);
                                                                                      rxp2_1
                                                                                          = 0;
                                                                                      px = 0;
                                                                                      j4 = 3.14159265358979;
                                                                                      sj4 = 0;
                                                                                      cj4 = -1.0;
                                                                                      rxp0_2
                                                                                          = (py
                                                                                             * r00);
                                                                                      rxp1_2
                                                                                          = (py
                                                                                             * r01);
                                                                                      rxp2_2
                                                                                          = (py
                                                                                             * r02);
                                                                                      j6eval
                                                                                          [0]
                                                                                          = ((1.0)
                                                                                             + (((1.91568587540858)
                                                                                                 * (py
                                                                                                    * py
                                                                                                    * py
                                                                                                    * py)))
                                                                                             + (((-1.0)
                                                                                                 * (2.64633970947792)
                                                                                                 * (py
                                                                                                    * py))));
                                                                                      if (IKabs(
                                                                                              j6eval
                                                                                                  [0])
                                                                                          < 0.0000010000000000)
                                                                                      {
                                                                                        continue; // no branches [j6]
                                                                                      }
                                                                                      else
                                                                                      {
                                                                                        {
                                                                                          IkReal j6array
                                                                                              [2],
                                                                                              cj6array
                                                                                                  [2],
                                                                                              sj6array
                                                                                                  [2];
                                                                                          bool j6valid
                                                                                              [2]
                                                                                              = {false};
                                                                                          _nj6
                                                                                              = 2;
                                                                                          IkReal
                                                                                              x611
                                                                                              = py
                                                                                                * py;
                                                                                          CheckValue<IkReal> x613 = IKatan2WithCheck(
                                                                                              IkReal((
                                                                                                  (-0.425)
                                                                                                  + (((-0.588235294117647)
                                                                                                      * x611)))),
                                                                                              ((-2.83333333333333)
                                                                                               + (((3.92156862745098)
                                                                                                   * x611))),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                          if (!x613.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          IkReal
                                                                                              x612
                                                                                              = ((-1.0)
                                                                                                 * (x613.value));
                                                                                          j6array
                                                                                              [0]
                                                                                              = x612;
                                                                                          sj6array
                                                                                              [0]
                                                                                              = IKsin(
                                                                                                  j6array
                                                                                                      [0]);
                                                                                          cj6array
                                                                                              [0]
                                                                                              = IKcos(
                                                                                                  j6array
                                                                                                      [0]);
                                                                                          j6array
                                                                                              [1]
                                                                                              = ((3.14159265358979)
                                                                                                 + x612);
                                                                                          sj6array
                                                                                              [1]
                                                                                              = IKsin(
                                                                                                  j6array
                                                                                                      [1]);
                                                                                          cj6array
                                                                                              [1]
                                                                                              = IKcos(
                                                                                                  j6array
                                                                                                      [1]);
                                                                                          if (j6array
                                                                                                  [0]
                                                                                              > IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [0]
                                                                                                -= IK2PI;
                                                                                          }
                                                                                          else if (
                                                                                              j6array
                                                                                                  [0]
                                                                                              < -IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [0]
                                                                                                += IK2PI;
                                                                                          }
                                                                                          j6valid
                                                                                              [0]
                                                                                              = true;
                                                                                          if (j6array
                                                                                                  [1]
                                                                                              > IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [1]
                                                                                                -= IK2PI;
                                                                                          }
                                                                                          else if (
                                                                                              j6array
                                                                                                  [1]
                                                                                              < -IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [1]
                                                                                                += IK2PI;
                                                                                          }
                                                                                          j6valid
                                                                                              [1]
                                                                                              = true;
                                                                                          for (
                                                                                              int ij6
                                                                                              = 0;
                                                                                              ij6
                                                                                              < 2;
                                                                                              ++ij6)
                                                                                          {
                                                                                            if (!j6valid
                                                                                                    [ij6])
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            _ij6[0]
                                                                                                = ij6;
                                                                                            _ij6[1]
                                                                                                = -1;
                                                                                            for (
                                                                                                int iij6
                                                                                                = ij6
                                                                                                  + 1;
                                                                                                iij6
                                                                                                < 2;
                                                                                                ++iij6)
                                                                                            {
                                                                                              if (j6valid
                                                                                                      [iij6]
                                                                                                  && IKabs(
                                                                                                         cj6array
                                                                                                             [ij6]
                                                                                                         - cj6array
                                                                                                             [iij6])
                                                                                                         < IKFAST_SOLUTION_THRESH
                                                                                                  && IKabs(
                                                                                                         sj6array
                                                                                                             [ij6]
                                                                                                         - sj6array
                                                                                                             [iij6])
                                                                                                         < IKFAST_SOLUTION_THRESH)
                                                                                              {
                                                                                                j6valid
                                                                                                    [iij6]
                                                                                                    = false;
                                                                                                _ij6[1]
                                                                                                    = iij6;
                                                                                                break;
                                                                                              }
                                                                                            }
                                                                                            j6 = j6array
                                                                                                [ij6];
                                                                                            cj6 = cj6array
                                                                                                [ij6];
                                                                                            sj6 = sj6array
                                                                                                [ij6];
                                                                                            {
                                                                                              IkReal evalcond
                                                                                                  [1];
                                                                                              evalcond
                                                                                                  [0]
                                                                                                  = ((0.85)
                                                                                                     * (IKsin(
                                                                                                         j6)));
                                                                                              if (IKabs(
                                                                                                      evalcond
                                                                                                          [0])
                                                                                                  > IKFAST_EVALCOND_THRESH)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                            }

                                                                                            rotationfunction0(
                                                                                                solutions);
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                } while (
                                                                                    0);
                                                                                if (bgotonextstatement)
                                                                                {
                                                                                  bool
                                                                                      bgotonextstatement
                                                                                      = true;
                                                                                  do
                                                                                  {
                                                                                    evalcond
                                                                                        [0]
                                                                                        = ((IKabs((
                                                                                               (-3.14159265358979)
                                                                                               + (IKfmod(
                                                                                                   ((1.5707963267949)
                                                                                                    + j4),
                                                                                                   6.28318530717959)))))
                                                                                           + (IKabs(
                                                                                               py)));
                                                                                    evalcond
                                                                                        [1]
                                                                                        = -0.85;
                                                                                    evalcond
                                                                                        [2]
                                                                                        = 0;
                                                                                    evalcond
                                                                                        [3]
                                                                                        = ((-0.2125)
                                                                                           + (((-1.0)
                                                                                               * (1.0)
                                                                                               * (px
                                                                                                  * px))));
                                                                                    if (IKabs(
                                                                                            evalcond
                                                                                                [0])
                                                                                            < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [1])
                                                                                               < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [2])
                                                                                               < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [3])
                                                                                               < 0.0000010000000000)
                                                                                    {
                                                                                      bgotonextstatement
                                                                                          = false;
                                                                                      {
                                                                                        IkReal j6eval
                                                                                            [1];
                                                                                        IkReal
                                                                                            x614
                                                                                            = ((1.0)
                                                                                               * px);
                                                                                        sj8 = 0;
                                                                                        cj8 = 1.0;
                                                                                        j8 = 0;
                                                                                        pz = 0;
                                                                                        j9 = 0;
                                                                                        sj9 = 0;
                                                                                        cj9 = 1.0;
                                                                                        pp = px
                                                                                             * px;
                                                                                        npx
                                                                                            = (px
                                                                                               * r00);
                                                                                        npy
                                                                                            = (px
                                                                                               * r01);
                                                                                        npz
                                                                                            = (px
                                                                                               * r02);
                                                                                        rxp0_0
                                                                                            = 0;
                                                                                        rxp0_1
                                                                                            = (px
                                                                                               * r20);
                                                                                        rxp1_0
                                                                                            = 0;
                                                                                        rxp1_1
                                                                                            = (px
                                                                                               * r21);
                                                                                        rxp2_0
                                                                                            = 0;
                                                                                        rxp2_1
                                                                                            = (px
                                                                                               * r22);
                                                                                        py = 0;
                                                                                        j4 = 1.5707963267949;
                                                                                        sj4 = 1.0;
                                                                                        cj4 = 0;
                                                                                        rxp0_2
                                                                                            = ((-1.0)
                                                                                               * r10
                                                                                               * x614);
                                                                                        rxp1_2
                                                                                            = ((-1.0)
                                                                                               * r11
                                                                                               * x614);
                                                                                        rxp2_2
                                                                                            = ((-1.0)
                                                                                               * r12
                                                                                               * x614);
                                                                                        j6eval
                                                                                            [0]
                                                                                            = ((1.0)
                                                                                               + (((1.91568587540858)
                                                                                                   * (px
                                                                                                      * px
                                                                                                      * px
                                                                                                      * px)))
                                                                                               + (((-1.0)
                                                                                                   * (2.64633970947792)
                                                                                                   * (px
                                                                                                      * px))));
                                                                                        if (IKabs(
                                                                                                j6eval
                                                                                                    [0])
                                                                                            < 0.0000010000000000)
                                                                                        {
                                                                                          continue; // no branches [j6]
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                          {
                                                                                            IkReal j6array
                                                                                                [2],
                                                                                                cj6array
                                                                                                    [2],
                                                                                                sj6array
                                                                                                    [2];
                                                                                            bool j6valid
                                                                                                [2]
                                                                                                = {false};
                                                                                            _nj6
                                                                                                = 2;
                                                                                            IkReal
                                                                                                x615
                                                                                                = px
                                                                                                  * px;
                                                                                            CheckValue<IkReal> x617 = IKatan2WithCheck(
                                                                                                IkReal((
                                                                                                    (-0.425)
                                                                                                    + (((-0.588235294117647)
                                                                                                        * x615)))),
                                                                                                ((-2.83333333333333)
                                                                                                 + (((3.92156862745098)
                                                                                                     * x615))),
                                                                                                IKFAST_ATAN2_MAGTHRESH);
                                                                                            if (!x617.valid)
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            IkReal
                                                                                                x616
                                                                                                = ((-1.0)
                                                                                                   * (x617.value));
                                                                                            j6array
                                                                                                [0]
                                                                                                = x616;
                                                                                            sj6array
                                                                                                [0]
                                                                                                = IKsin(
                                                                                                    j6array
                                                                                                        [0]);
                                                                                            cj6array
                                                                                                [0]
                                                                                                = IKcos(
                                                                                                    j6array
                                                                                                        [0]);
                                                                                            j6array
                                                                                                [1]
                                                                                                = ((3.14159265358979)
                                                                                                   + x616);
                                                                                            sj6array
                                                                                                [1]
                                                                                                = IKsin(
                                                                                                    j6array
                                                                                                        [1]);
                                                                                            cj6array
                                                                                                [1]
                                                                                                = IKcos(
                                                                                                    j6array
                                                                                                        [1]);
                                                                                            if (j6array
                                                                                                    [0]
                                                                                                > IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [0]
                                                                                                  -= IK2PI;
                                                                                            }
                                                                                            else if (
                                                                                                j6array
                                                                                                    [0]
                                                                                                < -IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [0]
                                                                                                  += IK2PI;
                                                                                            }
                                                                                            j6valid
                                                                                                [0]
                                                                                                = true;
                                                                                            if (j6array
                                                                                                    [1]
                                                                                                > IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [1]
                                                                                                  -= IK2PI;
                                                                                            }
                                                                                            else if (
                                                                                                j6array
                                                                                                    [1]
                                                                                                < -IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [1]
                                                                                                  += IK2PI;
                                                                                            }
                                                                                            j6valid
                                                                                                [1]
                                                                                                = true;
                                                                                            for (
                                                                                                int ij6
                                                                                                = 0;
                                                                                                ij6
                                                                                                < 2;
                                                                                                ++ij6)
                                                                                            {
                                                                                              if (!j6valid
                                                                                                      [ij6])
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              _ij6[0]
                                                                                                  = ij6;
                                                                                              _ij6[1]
                                                                                                  = -1;
                                                                                              for (
                                                                                                  int iij6
                                                                                                  = ij6
                                                                                                    + 1;
                                                                                                  iij6
                                                                                                  < 2;
                                                                                                  ++iij6)
                                                                                              {
                                                                                                if (j6valid
                                                                                                        [iij6]
                                                                                                    && IKabs(
                                                                                                           cj6array
                                                                                                               [ij6]
                                                                                                           - cj6array
                                                                                                               [iij6])
                                                                                                           < IKFAST_SOLUTION_THRESH
                                                                                                    && IKabs(
                                                                                                           sj6array
                                                                                                               [ij6]
                                                                                                           - sj6array
                                                                                                               [iij6])
                                                                                                           < IKFAST_SOLUTION_THRESH)
                                                                                                {
                                                                                                  j6valid
                                                                                                      [iij6]
                                                                                                      = false;
                                                                                                  _ij6[1]
                                                                                                      = iij6;
                                                                                                  break;
                                                                                                }
                                                                                              }
                                                                                              j6 = j6array
                                                                                                  [ij6];
                                                                                              cj6 = cj6array
                                                                                                  [ij6];
                                                                                              sj6 = sj6array
                                                                                                  [ij6];
                                                                                              {
                                                                                                IkReal evalcond
                                                                                                    [1];
                                                                                                evalcond
                                                                                                    [0]
                                                                                                    = ((0.85)
                                                                                                       * (IKsin(
                                                                                                           j6)));
                                                                                                if (IKabs(
                                                                                                        evalcond
                                                                                                            [0])
                                                                                                    > IKFAST_EVALCOND_THRESH)
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                              }

                                                                                              rotationfunction0(
                                                                                                  solutions);
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  } while (
                                                                                      0);
                                                                                  if (bgotonextstatement)
                                                                                  {
                                                                                    bool
                                                                                        bgotonextstatement
                                                                                        = true;
                                                                                    do
                                                                                    {
                                                                                      evalcond
                                                                                          [0]
                                                                                          = ((IKabs(
                                                                                                 py))
                                                                                             + (IKabs((
                                                                                                 (-3.14159265358979)
                                                                                                 + (IKfmod(
                                                                                                     ((4.71238898038469)
                                                                                                      + j4),
                                                                                                     6.28318530717959))))));
                                                                                      evalcond
                                                                                          [1]
                                                                                          = -0.85;
                                                                                      evalcond
                                                                                          [2]
                                                                                          = 0;
                                                                                      evalcond
                                                                                          [3]
                                                                                          = ((-0.2125)
                                                                                             + (((-1.0)
                                                                                                 * (1.0)
                                                                                                 * (px
                                                                                                    * px))));
                                                                                      if (IKabs(
                                                                                              evalcond
                                                                                                  [0])
                                                                                              < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [1])
                                                                                                 < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [2])
                                                                                                 < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [3])
                                                                                                 < 0.0000010000000000)
                                                                                      {
                                                                                        bgotonextstatement
                                                                                            = false;
                                                                                        {
                                                                                          IkReal j6eval
                                                                                              [1];
                                                                                          IkReal
                                                                                              x618
                                                                                              = ((1.0)
                                                                                                 * px);
                                                                                          sj8 = 0;
                                                                                          cj8 = 1.0;
                                                                                          j8 = 0;
                                                                                          pz = 0;
                                                                                          j9 = 0;
                                                                                          sj9 = 0;
                                                                                          cj9 = 1.0;
                                                                                          pp = px
                                                                                               * px;
                                                                                          npx
                                                                                              = (px
                                                                                                 * r00);
                                                                                          npy
                                                                                              = (px
                                                                                                 * r01);
                                                                                          npz
                                                                                              = (px
                                                                                                 * r02);
                                                                                          rxp0_0
                                                                                              = 0;
                                                                                          rxp0_1
                                                                                              = (px
                                                                                                 * r20);
                                                                                          rxp1_0
                                                                                              = 0;
                                                                                          rxp1_1
                                                                                              = (px
                                                                                                 * r21);
                                                                                          rxp2_0
                                                                                              = 0;
                                                                                          rxp2_1
                                                                                              = (px
                                                                                                 * r22);
                                                                                          py = 0;
                                                                                          j4 = -1.5707963267949;
                                                                                          sj4 = -1.0;
                                                                                          cj4 = 0;
                                                                                          rxp0_2
                                                                                              = ((-1.0)
                                                                                                 * r10
                                                                                                 * x618);
                                                                                          rxp1_2
                                                                                              = ((-1.0)
                                                                                                 * r11
                                                                                                 * x618);
                                                                                          rxp2_2
                                                                                              = ((-1.0)
                                                                                                 * r12
                                                                                                 * x618);
                                                                                          j6eval
                                                                                              [0]
                                                                                              = ((1.0)
                                                                                                 + (((1.91568587540858)
                                                                                                     * (px
                                                                                                        * px
                                                                                                        * px
                                                                                                        * px)))
                                                                                                 + (((-1.0)
                                                                                                     * (2.64633970947792)
                                                                                                     * (px
                                                                                                        * px))));
                                                                                          if (IKabs(
                                                                                                  j6eval
                                                                                                      [0])
                                                                                              < 0.0000010000000000)
                                                                                          {
                                                                                            continue; // no branches [j6]
                                                                                          }
                                                                                          else
                                                                                          {
                                                                                            {
                                                                                              IkReal j6array
                                                                                                  [2],
                                                                                                  cj6array
                                                                                                      [2],
                                                                                                  sj6array
                                                                                                      [2];
                                                                                              bool j6valid
                                                                                                  [2]
                                                                                                  = {false};
                                                                                              _nj6
                                                                                                  = 2;
                                                                                              IkReal
                                                                                                  x619
                                                                                                  = px
                                                                                                    * px;
                                                                                              CheckValue<IkReal> x621 = IKatan2WithCheck(
                                                                                                  IkReal((
                                                                                                      (-0.425)
                                                                                                      + (((-0.588235294117647)
                                                                                                          * x619)))),
                                                                                                  ((-2.83333333333333)
                                                                                                   + (((3.92156862745098)
                                                                                                       * x619))),
                                                                                                  IKFAST_ATAN2_MAGTHRESH);
                                                                                              if (!x621.valid)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              IkReal
                                                                                                  x620
                                                                                                  = ((-1.0)
                                                                                                     * (x621.value));
                                                                                              j6array
                                                                                                  [0]
                                                                                                  = x620;
                                                                                              sj6array
                                                                                                  [0]
                                                                                                  = IKsin(
                                                                                                      j6array
                                                                                                          [0]);
                                                                                              cj6array
                                                                                                  [0]
                                                                                                  = IKcos(
                                                                                                      j6array
                                                                                                          [0]);
                                                                                              j6array
                                                                                                  [1]
                                                                                                  = ((3.14159265358979)
                                                                                                     + x620);
                                                                                              sj6array
                                                                                                  [1]
                                                                                                  = IKsin(
                                                                                                      j6array
                                                                                                          [1]);
                                                                                              cj6array
                                                                                                  [1]
                                                                                                  = IKcos(
                                                                                                      j6array
                                                                                                          [1]);
                                                                                              if (j6array
                                                                                                      [0]
                                                                                                  > IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [0]
                                                                                                    -= IK2PI;
                                                                                              }
                                                                                              else if (
                                                                                                  j6array
                                                                                                      [0]
                                                                                                  < -IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [0]
                                                                                                    += IK2PI;
                                                                                              }
                                                                                              j6valid
                                                                                                  [0]
                                                                                                  = true;
                                                                                              if (j6array
                                                                                                      [1]
                                                                                                  > IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [1]
                                                                                                    -= IK2PI;
                                                                                              }
                                                                                              else if (
                                                                                                  j6array
                                                                                                      [1]
                                                                                                  < -IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [1]
                                                                                                    += IK2PI;
                                                                                              }
                                                                                              j6valid
                                                                                                  [1]
                                                                                                  = true;
                                                                                              for (
                                                                                                  int ij6
                                                                                                  = 0;
                                                                                                  ij6
                                                                                                  < 2;
                                                                                                  ++ij6)
                                                                                              {
                                                                                                if (!j6valid
                                                                                                        [ij6])
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                _ij6[0]
                                                                                                    = ij6;
                                                                                                _ij6[1]
                                                                                                    = -1;
                                                                                                for (
                                                                                                    int iij6
                                                                                                    = ij6
                                                                                                      + 1;
                                                                                                    iij6
                                                                                                    < 2;
                                                                                                    ++iij6)
                                                                                                {
                                                                                                  if (j6valid
                                                                                                          [iij6]
                                                                                                      && IKabs(
                                                                                                             cj6array
                                                                                                                 [ij6]
                                                                                                             - cj6array
                                                                                                                 [iij6])
                                                                                                             < IKFAST_SOLUTION_THRESH
                                                                                                      && IKabs(
                                                                                                             sj6array
                                                                                                                 [ij6]
                                                                                                             - sj6array
                                                                                                                 [iij6])
                                                                                                             < IKFAST_SOLUTION_THRESH)
                                                                                                  {
                                                                                                    j6valid
                                                                                                        [iij6]
                                                                                                        = false;
                                                                                                    _ij6[1]
                                                                                                        = iij6;
                                                                                                    break;
                                                                                                  }
                                                                                                }
                                                                                                j6 = j6array
                                                                                                    [ij6];
                                                                                                cj6 = cj6array
                                                                                                    [ij6];
                                                                                                sj6 = sj6array
                                                                                                    [ij6];
                                                                                                {
                                                                                                  IkReal evalcond
                                                                                                      [1];
                                                                                                  evalcond
                                                                                                      [0]
                                                                                                      = ((0.85)
                                                                                                         * (IKsin(
                                                                                                             j6)));
                                                                                                  if (IKabs(
                                                                                                          evalcond
                                                                                                              [0])
                                                                                                      > IKFAST_EVALCOND_THRESH)
                                                                                                  {
                                                                                                    continue;
                                                                                                  }
                                                                                                }

                                                                                                rotationfunction0(
                                                                                                    solutions);
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    } while (
                                                                                        0);
                                                                                    if (bgotonextstatement)
                                                                                    {
                                                                                      bool
                                                                                          bgotonextstatement
                                                                                          = true;
                                                                                      do
                                                                                      {
                                                                                        if (1)
                                                                                        {
                                                                                          bgotonextstatement
                                                                                              = false;
                                                                                          continue; // branch miss [j6]
                                                                                        }
                                                                                      } while (
                                                                                          0);
                                                                                      if (bgotonextstatement)
                                                                                      {
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                        else
                                                                        {
                                                                          {
                                                                            IkReal j6array
                                                                                [1],
                                                                                cj6array
                                                                                    [1],
                                                                                sj6array
                                                                                    [1];
                                                                            bool j6valid
                                                                                [1]
                                                                                = {false};
                                                                            _nj6
                                                                                = 1;
                                                                            IkReal
                                                                                x622
                                                                                = (cj4
                                                                                   * px);
                                                                            IkReal
                                                                                x623
                                                                                = (py
                                                                                   * sj4);
                                                                            IkReal
                                                                                x624
                                                                                = px
                                                                                  * px;
                                                                            IkReal
                                                                                x625
                                                                                = py
                                                                                  * py;
                                                                            CheckValue<IkReal> x626 = IKPowWithIntegerCheck(
                                                                                ((((20.0)
                                                                                   * x622))
                                                                                 + (((20.0)
                                                                                     * x623))),
                                                                                -1);
                                                                            if (!x626.valid)
                                                                            {
                                                                              continue;
                                                                            }
                                                                            CheckValue<IkReal> x627 = IKPowWithIntegerCheck(
                                                                                ((((-1.0)
                                                                                   * (11.7647058823529)
                                                                                   * cj4
                                                                                   * (px
                                                                                      * px
                                                                                      * px)))
                                                                                 + (((-8.5)
                                                                                     * x623))
                                                                                 + (((-11.7647058823529)
                                                                                     * x623
                                                                                     * x624))
                                                                                 + (((-11.7647058823529)
                                                                                     * x622
                                                                                     * x625))
                                                                                 + (((-8.5)
                                                                                     * x622))
                                                                                 + (((-1.0)
                                                                                     * (11.7647058823529)
                                                                                     * sj4
                                                                                     * (py
                                                                                        * py
                                                                                        * py)))),
                                                                                -1);
                                                                            if (!x627.valid)
                                                                            {
                                                                              continue;
                                                                            }
                                                                            if (IKabs((
                                                                                    (17.0)
                                                                                    * (x626.value)))
                                                                                    < IKFAST_ATAN2_MAGTHRESH
                                                                                && IKabs((
                                                                                       (x627.value)
                                                                                       * (((48.1666666666667)
                                                                                           + (((-66.6666666666667)
                                                                                               * x625))
                                                                                           + (((-66.6666666666667)
                                                                                               * x624))))))
                                                                                       < IKFAST_ATAN2_MAGTHRESH
                                                                                && IKabs(
                                                                                       IKsqr((
                                                                                           (17.0)
                                                                                           * (x626.value)))
                                                                                       + IKsqr((
                                                                                           (x627.value)
                                                                                           * (((48.1666666666667)
                                                                                               + (((-66.6666666666667)
                                                                                                   * x625))
                                                                                               + (((-66.6666666666667)
                                                                                                   * x624))))))
                                                                                       - 1)
                                                                                       <= IKFAST_SINCOS_THRESH)
                                                                              continue;
                                                                            j6array[0] = IKatan2(
                                                                                ((17.0)
                                                                                 * (x626.value)),
                                                                                ((x627.value)
                                                                                 * (((48.1666666666667)
                                                                                     + (((-66.6666666666667)
                                                                                         * x625))
                                                                                     + (((-66.6666666666667)
                                                                                         * x624))))));
                                                                            sj6array
                                                                                [0]
                                                                                = IKsin(
                                                                                    j6array
                                                                                        [0]);
                                                                            cj6array
                                                                                [0]
                                                                                = IKcos(
                                                                                    j6array
                                                                                        [0]);
                                                                            if (j6array
                                                                                    [0]
                                                                                > IKPI)
                                                                            {
                                                                              j6array
                                                                                  [0]
                                                                                  -= IK2PI;
                                                                            }
                                                                            else if (
                                                                                j6array
                                                                                    [0]
                                                                                < -IKPI)
                                                                            {
                                                                              j6array
                                                                                  [0]
                                                                                  += IK2PI;
                                                                            }
                                                                            j6valid
                                                                                [0]
                                                                                = true;
                                                                            for (
                                                                                int ij6
                                                                                = 0;
                                                                                ij6
                                                                                < 1;
                                                                                ++ij6)
                                                                            {
                                                                              if (!j6valid
                                                                                      [ij6])
                                                                              {
                                                                                continue;
                                                                              }
                                                                              _ij6[0]
                                                                                  = ij6;
                                                                              _ij6[1]
                                                                                  = -1;
                                                                              for (
                                                                                  int iij6
                                                                                  = ij6
                                                                                    + 1;
                                                                                  iij6
                                                                                  < 1;
                                                                                  ++iij6)
                                                                              {
                                                                                if (j6valid
                                                                                        [iij6]
                                                                                    && IKabs(
                                                                                           cj6array
                                                                                               [ij6]
                                                                                           - cj6array
                                                                                               [iij6])
                                                                                           < IKFAST_SOLUTION_THRESH
                                                                                    && IKabs(
                                                                                           sj6array
                                                                                               [ij6]
                                                                                           - sj6array
                                                                                               [iij6])
                                                                                           < IKFAST_SOLUTION_THRESH)
                                                                                {
                                                                                  j6valid
                                                                                      [iij6]
                                                                                      = false;
                                                                                  _ij6[1]
                                                                                      = iij6;
                                                                                  break;
                                                                                }
                                                                              }
                                                                              j6 = j6array
                                                                                  [ij6];
                                                                              cj6 = cj6array
                                                                                  [ij6];
                                                                              sj6 = sj6array
                                                                                  [ij6];
                                                                              {
                                                                                IkReal evalcond
                                                                                    [5];
                                                                                IkReal
                                                                                    x628
                                                                                    = IKsin(
                                                                                        j6);
                                                                                IkReal
                                                                                    x629
                                                                                    = (cj4
                                                                                       * px);
                                                                                IkReal
                                                                                    x630
                                                                                    = (x628
                                                                                       * x629);
                                                                                IkReal
                                                                                    x631
                                                                                    = (py
                                                                                       * sj4);
                                                                                IkReal
                                                                                    x632
                                                                                    = (x628
                                                                                       * x631);
                                                                                IkReal
                                                                                    x633
                                                                                    = ((1.0)
                                                                                       * x629);
                                                                                IkReal
                                                                                    x634
                                                                                    = ((1.0)
                                                                                       * x631);
                                                                                IkReal
                                                                                    x635
                                                                                    = IKcos(
                                                                                        j6);
                                                                                IkReal
                                                                                    x636
                                                                                    = px
                                                                                      * px;
                                                                                IkReal
                                                                                    x637
                                                                                    = ((3.92156862745098)
                                                                                       * x628);
                                                                                IkReal
                                                                                    x638
                                                                                    = ((0.588235294117647)
                                                                                       * x635);
                                                                                IkReal
                                                                                    x639
                                                                                    = py
                                                                                      * py;
                                                                                IkReal
                                                                                    x640
                                                                                    = ((0.09)
                                                                                       * x635);
                                                                                evalcond
                                                                                    [0]
                                                                                    = ((-0.85)
                                                                                       + x630
                                                                                       + x632);
                                                                                evalcond
                                                                                    [1]
                                                                                    = ((((-1.0)
                                                                                         * x634))
                                                                                       + (((0.85)
                                                                                           * x628))
                                                                                       + (((-1.0)
                                                                                           * x633)));
                                                                                evalcond
                                                                                    [2]
                                                                                    = ((((-1.0)
                                                                                         * x634
                                                                                         * x635))
                                                                                       + (((-1.0)
                                                                                           * x633
                                                                                           * x635)));
                                                                                evalcond
                                                                                    [3]
                                                                                    = (((x637
                                                                                         * x639))
                                                                                       + ((x636
                                                                                           * x637))
                                                                                       + (((-1.0)
                                                                                           * x638
                                                                                           * x639))
                                                                                       + (((-0.425)
                                                                                           * x635))
                                                                                       + (((-2.83333333333333)
                                                                                           * x628))
                                                                                       + (((-1.0)
                                                                                           * x636
                                                                                           * x638)));
                                                                                evalcond
                                                                                    [4]
                                                                                    = ((-0.2125)
                                                                                       + (((-1.0)
                                                                                           * x639))
                                                                                       + ((x631
                                                                                           * x640))
                                                                                       + (((-1.0)
                                                                                           * x636))
                                                                                       + ((x629
                                                                                           * x640))
                                                                                       + (((1.1)
                                                                                           * x632))
                                                                                       + (((1.1)
                                                                                           * x630)));
                                                                                if (IKabs(
                                                                                        evalcond
                                                                                            [0])
                                                                                        > IKFAST_EVALCOND_THRESH
                                                                                    || IKabs(
                                                                                           evalcond
                                                                                               [1])
                                                                                           > IKFAST_EVALCOND_THRESH
                                                                                    || IKabs(
                                                                                           evalcond
                                                                                               [2])
                                                                                           > IKFAST_EVALCOND_THRESH
                                                                                    || IKabs(
                                                                                           evalcond
                                                                                               [3])
                                                                                           > IKFAST_EVALCOND_THRESH
                                                                                    || IKabs(
                                                                                           evalcond
                                                                                               [4])
                                                                                           > IKFAST_EVALCOND_THRESH)
                                                                                {
                                                                                  continue;
                                                                                }
                                                                              }

                                                                              rotationfunction0(
                                                                                  solutions);
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                    else
                                                                    {
                                                                      {
                                                                        IkReal j6array
                                                                            [1],
                                                                            cj6array
                                                                                [1],
                                                                            sj6array
                                                                                [1];
                                                                        bool j6valid
                                                                            [1]
                                                                            = {false};
                                                                        _nj6
                                                                            = 1;
                                                                        IkReal
                                                                            x641
                                                                            = (cj4
                                                                               * px);
                                                                        IkReal
                                                                            x642
                                                                            = (py
                                                                               * sj4);
                                                                        IkReal
                                                                            x643
                                                                            = px
                                                                              * px;
                                                                        IkReal
                                                                            x644
                                                                            = py
                                                                              * py;
                                                                        CheckValue<IkReal> x645 = IKPowWithIntegerCheck(
                                                                            ((-7.225)
                                                                             + (((-10.0)
                                                                                 * x643))
                                                                             + (((-10.0)
                                                                                 * x644))),
                                                                            -1);
                                                                        if (!x645.valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        if (IKabs((
                                                                                (((1.17647058823529)
                                                                                  * x642))
                                                                                + (((1.17647058823529)
                                                                                    * x641))))
                                                                                < IKFAST_ATAN2_MAGTHRESH
                                                                            && IKabs((
                                                                                   (x645.value)
                                                                                   * (((((-1.0)
                                                                                         * (78.4313725490196)
                                                                                         * sj4
                                                                                         * (py
                                                                                            * py
                                                                                            * py)))
                                                                                       + (((-78.4313725490196)
                                                                                           * x641
                                                                                           * x644))
                                                                                       + (((-78.4313725490196)
                                                                                           * x642
                                                                                           * x643))
                                                                                       + (((-1.0)
                                                                                           * (78.4313725490196)
                                                                                           * cj4
                                                                                           * (px
                                                                                              * px
                                                                                              * px)))
                                                                                       + (((56.6666666666667)
                                                                                           * x642))
                                                                                       + (((56.6666666666667)
                                                                                           * x641))))))
                                                                                   < IKFAST_ATAN2_MAGTHRESH
                                                                            && IKabs(
                                                                                   IKsqr((
                                                                                       (((1.17647058823529)
                                                                                         * x642))
                                                                                       + (((1.17647058823529)
                                                                                           * x641))))
                                                                                   + IKsqr((
                                                                                       (x645.value)
                                                                                       * (((((-1.0)
                                                                                             * (78.4313725490196)
                                                                                             * sj4
                                                                                             * (py
                                                                                                * py
                                                                                                * py)))
                                                                                           + (((-78.4313725490196)
                                                                                               * x641
                                                                                               * x644))
                                                                                           + (((-78.4313725490196) * x642 * x643)) + (((-1.0) * (78.4313725490196) * cj4 * (px * px * px))) + (((56.6666666666667) * x642)) + (((56.6666666666667) * x641))))))
                                                                                   - 1)
                                                                                   <= IKFAST_SINCOS_THRESH)
                                                                          continue;
                                                                        j6array[0] = IKatan2(
                                                                            ((((1.17647058823529)
                                                                               * x642))
                                                                             + (((1.17647058823529)
                                                                                 * x641))),
                                                                            ((x645.value)
                                                                             * (((((-1.0)
                                                                                   * (78.4313725490196)
                                                                                   * sj4
                                                                                   * (py
                                                                                      * py
                                                                                      * py)))
                                                                                 + (((-78.4313725490196)
                                                                                     * x641
                                                                                     * x644))
                                                                                 + (((-78.4313725490196)
                                                                                     * x642
                                                                                     * x643))
                                                                                 + (((-1.0)
                                                                                     * (78.4313725490196)
                                                                                     * cj4
                                                                                     * (px
                                                                                        * px
                                                                                        * px)))
                                                                                 + (((56.6666666666667)
                                                                                     * x642))
                                                                                 + (((56.6666666666667)
                                                                                     * x641))))));
                                                                        sj6array
                                                                            [0]
                                                                            = IKsin(
                                                                                j6array
                                                                                    [0]);
                                                                        cj6array
                                                                            [0]
                                                                            = IKcos(
                                                                                j6array
                                                                                    [0]);
                                                                        if (j6array
                                                                                [0]
                                                                            > IKPI)
                                                                        {
                                                                          j6array
                                                                              [0]
                                                                              -= IK2PI;
                                                                        }
                                                                        else if (
                                                                            j6array
                                                                                [0]
                                                                            < -IKPI)
                                                                        {
                                                                          j6array
                                                                              [0]
                                                                              += IK2PI;
                                                                        }
                                                                        j6valid
                                                                            [0]
                                                                            = true;
                                                                        for (
                                                                            int ij6
                                                                            = 0;
                                                                            ij6
                                                                            < 1;
                                                                            ++ij6)
                                                                        {
                                                                          if (!j6valid
                                                                                  [ij6])
                                                                          {
                                                                            continue;
                                                                          }
                                                                          _ij6[0]
                                                                              = ij6;
                                                                          _ij6[1]
                                                                              = -1;
                                                                          for (
                                                                              int iij6
                                                                              = ij6
                                                                                + 1;
                                                                              iij6
                                                                              < 1;
                                                                              ++iij6)
                                                                          {
                                                                            if (j6valid
                                                                                    [iij6]
                                                                                && IKabs(
                                                                                       cj6array
                                                                                           [ij6]
                                                                                       - cj6array
                                                                                           [iij6])
                                                                                       < IKFAST_SOLUTION_THRESH
                                                                                && IKabs(
                                                                                       sj6array
                                                                                           [ij6]
                                                                                       - sj6array
                                                                                           [iij6])
                                                                                       < IKFAST_SOLUTION_THRESH)
                                                                            {
                                                                              j6valid
                                                                                  [iij6]
                                                                                  = false;
                                                                              _ij6[1]
                                                                                  = iij6;
                                                                              break;
                                                                            }
                                                                          }
                                                                          j6 = j6array
                                                                              [ij6];
                                                                          cj6 = cj6array
                                                                              [ij6];
                                                                          sj6 = sj6array
                                                                              [ij6];
                                                                          {
                                                                            IkReal evalcond
                                                                                [5];
                                                                            IkReal
                                                                                x646
                                                                                = IKsin(
                                                                                    j6);
                                                                            IkReal
                                                                                x647
                                                                                = (cj4
                                                                                   * px);
                                                                            IkReal
                                                                                x648
                                                                                = (x646
                                                                                   * x647);
                                                                            IkReal
                                                                                x649
                                                                                = (py
                                                                                   * sj4);
                                                                            IkReal
                                                                                x650
                                                                                = (x646
                                                                                   * x649);
                                                                            IkReal
                                                                                x651
                                                                                = ((1.0)
                                                                                   * x647);
                                                                            IkReal
                                                                                x652
                                                                                = ((1.0)
                                                                                   * x649);
                                                                            IkReal
                                                                                x653
                                                                                = IKcos(
                                                                                    j6);
                                                                            IkReal
                                                                                x654
                                                                                = px
                                                                                  * px;
                                                                            IkReal
                                                                                x655
                                                                                = ((3.92156862745098)
                                                                                   * x646);
                                                                            IkReal
                                                                                x656
                                                                                = ((0.588235294117647)
                                                                                   * x653);
                                                                            IkReal
                                                                                x657
                                                                                = py
                                                                                  * py;
                                                                            IkReal
                                                                                x658
                                                                                = ((0.09)
                                                                                   * x653);
                                                                            evalcond
                                                                                [0]
                                                                                = ((-0.85)
                                                                                   + x650
                                                                                   + x648);
                                                                            evalcond
                                                                                [1]
                                                                                = ((((-1.0)
                                                                                     * x652))
                                                                                   + (((-1.0)
                                                                                       * x651))
                                                                                   + (((0.85)
                                                                                       * x646)));
                                                                            evalcond
                                                                                [2]
                                                                                = ((((-1.0)
                                                                                     * x652
                                                                                     * x653))
                                                                                   + (((-1.0)
                                                                                       * x651
                                                                                       * x653)));
                                                                            evalcond
                                                                                [3]
                                                                                = (((x654
                                                                                     * x655))
                                                                                   + ((x655
                                                                                       * x657))
                                                                                   + (((-1.0)
                                                                                       * x654
                                                                                       * x656))
                                                                                   + (((-0.425)
                                                                                       * x653))
                                                                                   + (((-1.0)
                                                                                       * x656
                                                                                       * x657))
                                                                                   + (((-2.83333333333333)
                                                                                       * x646)));
                                                                            evalcond
                                                                                [4]
                                                                                = ((-0.2125)
                                                                                   + (((1.1)
                                                                                       * x648))
                                                                                   + (((1.1)
                                                                                       * x650))
                                                                                   + ((x649
                                                                                       * x658))
                                                                                   + (((-1.0)
                                                                                       * x657))
                                                                                   + ((x647
                                                                                       * x658))
                                                                                   + (((-1.0)
                                                                                       * x654)));
                                                                            if (IKabs(
                                                                                    evalcond
                                                                                        [0])
                                                                                    > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [1])
                                                                                       > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [2])
                                                                                       > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [3])
                                                                                       > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [4])
                                                                                       > IKFAST_EVALCOND_THRESH)
                                                                            {
                                                                              continue;
                                                                            }
                                                                          }

                                                                          rotationfunction0(
                                                                              solutions);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal
                                                                        j6array
                                                                            [1],
                                                                        cj6array
                                                                            [1],
                                                                        sj6array
                                                                            [1];
                                                                    bool j6valid
                                                                        [1]
                                                                        = {false};
                                                                    _nj6 = 1;
                                                                    IkReal x659
                                                                        = (cj4
                                                                           * px);
                                                                    IkReal x660
                                                                        = (py
                                                                           * sj4);
                                                                    IkReal x661
                                                                        = px
                                                                          * px;
                                                                    IkReal x662
                                                                        = py
                                                                          * py;
                                                                    IkReal x663
                                                                        = ((1.29411764705882)
                                                                           * (cj4
                                                                              * cj4));
                                                                    CheckValue<
                                                                        IkReal>
                                                                        x664
                                                                        = IKPowWithIntegerCheck(
                                                                            ((((0.09)
                                                                               * x659))
                                                                             + (((0.09)
                                                                                 * x660))),
                                                                            -1);
                                                                    if (!x664.valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    if (IKabs((
                                                                            (((1.17647058823529)
                                                                              * x660))
                                                                            + (((1.17647058823529)
                                                                                * x659))))
                                                                            < IKFAST_ATAN2_MAGTHRESH
                                                                        && IKabs((
                                                                               (x664.value)
                                                                               * (((0.2125)
                                                                                   + (((-2.58823529411765)
                                                                                       * cj4
                                                                                       * px
                                                                                       * x660))
                                                                                   + (((-0.294117647058824)
                                                                                       * x662))
                                                                                   + (((-1.0)
                                                                                       * x661
                                                                                       * x663))
                                                                                   + ((x662
                                                                                       * x663))
                                                                                   + x661))))
                                                                               < IKFAST_ATAN2_MAGTHRESH
                                                                        && IKabs(
                                                                               IKsqr((
                                                                                   (((1.17647058823529)
                                                                                     * x660))
                                                                                   + (((1.17647058823529)
                                                                                       * x659))))
                                                                               + IKsqr((
                                                                                   (x664.value)
                                                                                   * (((0.2125)
                                                                                       + (((-2.58823529411765)
                                                                                           * cj4
                                                                                           * px
                                                                                           * x660))
                                                                                       + (((-0.294117647058824)
                                                                                           * x662))
                                                                                       + (((-1.0)
                                                                                           * x661
                                                                                           * x663))
                                                                                       + ((x662
                                                                                           * x663))
                                                                                       + x661))))
                                                                               - 1)
                                                                               <= IKFAST_SINCOS_THRESH)
                                                                      continue;
                                                                    j6array[0] = IKatan2(
                                                                        ((((1.17647058823529)
                                                                           * x660))
                                                                         + (((1.17647058823529)
                                                                             * x659))),
                                                                        ((x664.value)
                                                                         * (((0.2125)
                                                                             + (((-2.58823529411765)
                                                                                 * cj4
                                                                                 * px
                                                                                 * x660))
                                                                             + (((-0.294117647058824)
                                                                                 * x662))
                                                                             + (((-1.0)
                                                                                 * x661
                                                                                 * x663))
                                                                             + ((x662
                                                                                 * x663))
                                                                             + x661))));
                                                                    sj6array[0] = IKsin(
                                                                        j6array
                                                                            [0]);
                                                                    cj6array[0] = IKcos(
                                                                        j6array
                                                                            [0]);
                                                                    if (j6array
                                                                            [0]
                                                                        > IKPI)
                                                                    {
                                                                      j6array[0]
                                                                          -= IK2PI;
                                                                    }
                                                                    else if (
                                                                        j6array
                                                                            [0]
                                                                        < -IKPI)
                                                                    {
                                                                      j6array[0]
                                                                          += IK2PI;
                                                                    }
                                                                    j6valid[0]
                                                                        = true;
                                                                    for (int ij6
                                                                         = 0;
                                                                         ij6
                                                                         < 1;
                                                                         ++ij6)
                                                                    {
                                                                      if (!j6valid
                                                                              [ij6])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij6[0]
                                                                          = ij6;
                                                                      _ij6[1]
                                                                          = -1;
                                                                      for (
                                                                          int iij6
                                                                          = ij6
                                                                            + 1;
                                                                          iij6
                                                                          < 1;
                                                                          ++iij6)
                                                                      {
                                                                        if (j6valid
                                                                                [iij6]
                                                                            && IKabs(
                                                                                   cj6array
                                                                                       [ij6]
                                                                                   - cj6array
                                                                                       [iij6])
                                                                                   < IKFAST_SOLUTION_THRESH
                                                                            && IKabs(
                                                                                   sj6array
                                                                                       [ij6]
                                                                                   - sj6array
                                                                                       [iij6])
                                                                                   < IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j6valid
                                                                              [iij6]
                                                                              = false;
                                                                          _ij6[1]
                                                                              = iij6;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j6 = j6array
                                                                          [ij6];
                                                                      cj6 = cj6array
                                                                          [ij6];
                                                                      sj6 = sj6array
                                                                          [ij6];
                                                                      {
                                                                        IkReal evalcond
                                                                            [5];
                                                                        IkReal
                                                                            x665
                                                                            = IKsin(
                                                                                j6);
                                                                        IkReal
                                                                            x666
                                                                            = (cj4
                                                                               * px);
                                                                        IkReal
                                                                            x667
                                                                            = (x665
                                                                               * x666);
                                                                        IkReal
                                                                            x668
                                                                            = (py
                                                                               * sj4);
                                                                        IkReal
                                                                            x669
                                                                            = (x665
                                                                               * x668);
                                                                        IkReal
                                                                            x670
                                                                            = ((1.0)
                                                                               * x666);
                                                                        IkReal
                                                                            x671
                                                                            = ((1.0)
                                                                               * x668);
                                                                        IkReal
                                                                            x672
                                                                            = IKcos(
                                                                                j6);
                                                                        IkReal
                                                                            x673
                                                                            = px
                                                                              * px;
                                                                        IkReal
                                                                            x674
                                                                            = ((3.92156862745098)
                                                                               * x665);
                                                                        IkReal
                                                                            x675
                                                                            = ((0.588235294117647)
                                                                               * x672);
                                                                        IkReal
                                                                            x676
                                                                            = py
                                                                              * py;
                                                                        IkReal
                                                                            x677
                                                                            = ((0.09)
                                                                               * x672);
                                                                        evalcond
                                                                            [0]
                                                                            = ((-0.85)
                                                                               + x667
                                                                               + x669);
                                                                        evalcond
                                                                            [1]
                                                                            = ((((0.85)
                                                                                 * x665))
                                                                               + (((-1.0)
                                                                                   * x670))
                                                                               + (((-1.0)
                                                                                   * x671)));
                                                                        evalcond
                                                                            [2]
                                                                            = ((((-1.0)
                                                                                 * x671
                                                                                 * x672))
                                                                               + (((-1.0)
                                                                                   * x670
                                                                                   * x672)));
                                                                        evalcond
                                                                            [3]
                                                                            = ((((-2.83333333333333)
                                                                                 * x665))
                                                                               + (((-0.425)
                                                                                   * x672))
                                                                               + ((x673
                                                                                   * x674))
                                                                               + (((-1.0)
                                                                                   * x675
                                                                                   * x676))
                                                                               + ((x674
                                                                                   * x676))
                                                                               + (((-1.0)
                                                                                   * x673
                                                                                   * x675)));
                                                                        evalcond
                                                                            [4]
                                                                            = ((-0.2125)
                                                                               + ((x668
                                                                                   * x677))
                                                                               + (((-1.0)
                                                                                   * x676))
                                                                               + ((x666
                                                                                   * x677))
                                                                               + (((1.1)
                                                                                   * x667))
                                                                               + (((-1.0)
                                                                                   * x673))
                                                                               + (((1.1)
                                                                                   * x669)));
                                                                        if (IKabs(
                                                                                evalcond
                                                                                    [0])
                                                                                > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [1])
                                                                                   > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [2])
                                                                                   > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [3])
                                                                                   > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [4])
                                                                                   > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      rotationfunction0(
                                                                          solutions);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          } while (0);
                                                          if (bgotonextstatement)
                                                          {
                                                            bool
                                                                bgotonextstatement
                                                                = true;
                                                            do
                                                            {
                                                              if (1)
                                                              {
                                                                bgotonextstatement
                                                                    = false;
                                                                continue; // branch
                                                                          // miss
                                                                          // [j6]
                                                              }
                                                            } while (0);
                                                            if (bgotonextstatement)
                                                            {
                                                            }
                                                          }
                                                        }
                                                      }
                                                      else
                                                      {
                                                        {
                                                          IkReal j6array[1],
                                                              cj6array[1],
                                                              sj6array[1];
                                                          bool j6valid[1]
                                                              = {false};
                                                          _nj6 = 1;
                                                          IkReal x678
                                                              = (cj4 * px);
                                                          IkReal x679
                                                              = (py * sj4);
                                                          IkReal x680
                                                              = ((0.108264705882353)
                                                                 * cj9);
                                                          IkReal x681
                                                              = ((0.588235294117647)
                                                                 * pp);
                                                          IkReal x682
                                                              = (cj9 * pp);
                                                          IkReal x683
                                                              = (cj9 * sj9);
                                                          IkReal x684
                                                              = (pp * sj9);
                                                          IkReal x685
                                                              = cj9 * cj9;
                                                          IkReal x686
                                                              = ((1.0) * pz);
                                                          CheckValue<IkReal> x687 = IKPowWithIntegerCheck(
                                                              IKsign((
                                                                  (((-1.0)
                                                                    * x678
                                                                    * x681))
                                                                  + (((-1.0)
                                                                      * x679
                                                                      * x680))
                                                                  + (((1.51009803921569)
                                                                      * pz))
                                                                  + (((1.32323529411765)
                                                                      * cj9
                                                                      * pz))
                                                                  + (((-1.0)
                                                                      * (3.92156862745098)
                                                                      * pp
                                                                      * pz))
                                                                  + (((-1.0)
                                                                      * x678
                                                                      * x680))
                                                                  + (((-0.316735294117647)
                                                                      * x679))
                                                                  + (((-0.316735294117647)
                                                                      * x678))
                                                                  + (((-1.0)
                                                                      * x679
                                                                      * x681)))),
                                                              -1);
                                                          if (!x687.valid)
                                                          {
                                                            continue;
                                                          }
                                                          CheckValue<IkReal> x688 = IKatan2WithCheck(
                                                              IkReal((
                                                                  (-0.174204411764706)
                                                                  + (((-0.0264705882352941)
                                                                      * x684))
                                                                  + (((-0.00487191176470588)
                                                                      * x683))
                                                                  + (pz * pz)
                                                                  + (((-0.0324794117647059)
                                                                      * x685))
                                                                  + (((-1.0)
                                                                      * (0.154566176470588)
                                                                      * cj9))
                                                                  + (((-0.176470588235294)
                                                                      * x682))
                                                                  + (((-1.0)
                                                                      * (0.323529411764706)
                                                                      * pp))
                                                                  + (((-1.0)
                                                                      * (0.0142530882352941)
                                                                      * sj9)))),
                                                              ((0.830553921568627)
                                                               + (((-1.17647058823529)
                                                                   * x682))
                                                               + (((0.396970588235294)
                                                                   * x685))
                                                               + (((1.18080882352941)
                                                                   * cj9))
                                                               + (((0.0595455882352941)
                                                                   * x683))
                                                               + (((-1.0)
                                                                   * (2.15686274509804)
                                                                   * pp))
                                                               + (((-1.0) * x678
                                                                   * x686))
                                                               + (((-1.0) * x679
                                                                   * x686))
                                                               + (((-0.176470588235294)
                                                                   * x684))
                                                               + (((0.0679544117647059)
                                                                   * sj9))),
                                                              IKFAST_ATAN2_MAGTHRESH);
                                                          if (!x688.valid)
                                                          {
                                                            continue;
                                                          }
                                                          j6array[0]
                                                              = ((-1.5707963267949)
                                                                 + (((1.5707963267949)
                                                                     * (x687.value)))
                                                                 + (x688.value));
                                                          sj6array[0] = IKsin(
                                                              j6array[0]);
                                                          cj6array[0] = IKcos(
                                                              j6array[0]);
                                                          if (j6array[0] > IKPI)
                                                          {
                                                            j6array[0] -= IK2PI;
                                                          }
                                                          else if (
                                                              j6array[0]
                                                              < -IKPI)
                                                          {
                                                            j6array[0] += IK2PI;
                                                          }
                                                          j6valid[0] = true;
                                                          for (int ij6 = 0;
                                                               ij6 < 1;
                                                               ++ij6)
                                                          {
                                                            if (!j6valid[ij6])
                                                            {
                                                              continue;
                                                            }
                                                            _ij6[0] = ij6;
                                                            _ij6[1] = -1;
                                                            for (int iij6
                                                                 = ij6 + 1;
                                                                 iij6 < 1;
                                                                 ++iij6)
                                                            {
                                                              if (j6valid[iij6]
                                                                  && IKabs(
                                                                         cj6array
                                                                             [ij6]
                                                                         - cj6array
                                                                             [iij6])
                                                                         < IKFAST_SOLUTION_THRESH
                                                                  && IKabs(
                                                                         sj6array
                                                                             [ij6]
                                                                         - sj6array
                                                                             [iij6])
                                                                         < IKFAST_SOLUTION_THRESH)
                                                              {
                                                                j6valid[iij6]
                                                                    = false;
                                                                _ij6[1] = iij6;
                                                                break;
                                                              }
                                                            }
                                                            j6 = j6array[ij6];
                                                            cj6 = cj6array[ij6];
                                                            sj6 = sj6array[ij6];
                                                            {
                                                              IkReal
                                                                  evalcond[5];
                                                              IkReal x689
                                                                  = ((0.3)
                                                                     * cj9);
                                                              IkReal x690
                                                                  = ((0.045)
                                                                     * sj9);
                                                              IkReal x691
                                                                  = IKcos(j6);
                                                              IkReal x692
                                                                  = (pz * x691);
                                                              IkReal x693
                                                                  = IKsin(j6);
                                                              IkReal x694
                                                                  = (cj4 * px);
                                                              IkReal x695
                                                                  = (x693
                                                                     * x694);
                                                              IkReal x696
                                                                  = (py * sj4);
                                                              IkReal x697
                                                                  = (x693
                                                                     * x696);
                                                              IkReal x698
                                                                  = ((0.045)
                                                                     * cj9);
                                                              IkReal x699
                                                                  = ((0.3)
                                                                     * sj9);
                                                              IkReal x700
                                                                  = (pz * x693);
                                                              IkReal x701
                                                                  = ((1.0)
                                                                     * x694);
                                                              IkReal x702
                                                                  = ((1.0)
                                                                     * x696);
                                                              IkReal x703
                                                                  = ((0.09)
                                                                     * x691);
                                                              evalcond[0]
                                                                  = ((-0.55)
                                                                     + (((-1.0)
                                                                         * x689))
                                                                     + (((-1.0)
                                                                         * x690))
                                                                     + x692
                                                                     + x695
                                                                     + x697);
                                                              evalcond[1]
                                                                  = ((0.045)
                                                                     + x700
                                                                     + (((-1.0)
                                                                         * x691
                                                                         * x701))
                                                                     + (((-1.0)
                                                                         * x698))
                                                                     + x699
                                                                     + (((-1.0)
                                                                         * x691
                                                                         * x702)));
                                                              evalcond[2]
                                                                  = ((((-1.51009803921569)
                                                                       * x693))
                                                                     + (((-0.588235294117647)
                                                                         * pp
                                                                         * x691))
                                                                     + (((3.92156862745098)
                                                                         * pp
                                                                         * x693))
                                                                     + pz
                                                                     + (((-1.32323529411765)
                                                                         * cj9
                                                                         * x693))
                                                                     + (((-0.316735294117647)
                                                                         * x691))
                                                                     + (((-0.108264705882353)
                                                                         * cj9
                                                                         * x691)));
                                                              evalcond[3]
                                                                  = ((((-1.0)
                                                                       * x691
                                                                       * x698))
                                                                     + (((-1.0)
                                                                         * x702))
                                                                     + ((x690
                                                                         * x693))
                                                                     + ((x691
                                                                         * x699))
                                                                     + (((0.55)
                                                                         * x693))
                                                                     + (((0.045)
                                                                         * x691))
                                                                     + ((x689
                                                                         * x693))
                                                                     + (((-1.0)
                                                                         * x701)));
                                                              evalcond[4]
                                                                  = ((-0.2125)
                                                                     + ((x696
                                                                         * x703))
                                                                     + (((1.1)
                                                                         * x695))
                                                                     + (((-0.09)
                                                                         * x700))
                                                                     + (((1.1)
                                                                         * x692))
                                                                     + (((1.1)
                                                                         * x697))
                                                                     + ((x694
                                                                         * x703))
                                                                     + (((-1.0)
                                                                         * (1.0)
                                                                         * pp)));
                                                              if (IKabs(evalcond
                                                                            [0])
                                                                      > IKFAST_EVALCOND_THRESH
                                                                  || IKabs(
                                                                         evalcond
                                                                             [1])
                                                                         > IKFAST_EVALCOND_THRESH
                                                                  || IKabs(
                                                                         evalcond
                                                                             [2])
                                                                         > IKFAST_EVALCOND_THRESH
                                                                  || IKabs(
                                                                         evalcond
                                                                             [3])
                                                                         > IKFAST_EVALCOND_THRESH
                                                                  || IKabs(
                                                                         evalcond
                                                                             [4])
                                                                         > IKFAST_EVALCOND_THRESH)
                                                              {
                                                                continue;
                                                              }
                                                            }

                                                            rotationfunction0(
                                                                solutions);
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                  else
                                                  {
                                                    {
                                                      IkReal j6array[1],
                                                          cj6array[1],
                                                          sj6array[1];
                                                      bool j6valid[1] = {false};
                                                      _nj6 = 1;
                                                      IkReal x704
                                                          = ((0.045) * cj4
                                                             * px);
                                                      IkReal x705
                                                          = ((0.045) * py
                                                             * sj4);
                                                      IkReal x706
                                                          = ((0.3) * sj9);
                                                      IkReal x707 = (cj4 * px);
                                                      IkReal x708 = (py * sj4);
                                                      IkReal x709 = (cj9 * sj9);
                                                      IkReal x710 = cj9 * cj9;
                                                      IkReal x711
                                                          = ((1.0) * pz);
                                                      IkReal x712 = py * py;
                                                      IkReal x713 = cj4 * cj4;
                                                      CheckValue<IkReal> x714
                                                          = IKatan2WithCheck(
                                                              IkReal((
                                                                  (0.03825)
                                                                  + (((0.087975)
                                                                      * x709))
                                                                  + (((-0.027)
                                                                      * x710))
                                                                  + (((-1.0)
                                                                      * x707
                                                                      * x711))
                                                                  + (((0.167025)
                                                                      * sj9))
                                                                  + (((-1.0)
                                                                      * (0.01125)
                                                                      * cj9))
                                                                  + (((-1.0)
                                                                      * x708
                                                                      * x711)))),
                                                              ((-0.304525)
                                                               + (((-1.0)
                                                                   * (0.0495)
                                                                   * sj9))
                                                               + (((-0.087975)
                                                                   * x710))
                                                               + (((2.0) * cj4
                                                                   * px * x708))
                                                               + x712
                                                               + (((-1.0) * x712
                                                                   * x713))
                                                               + (((-1.0)
                                                                   * (0.33)
                                                                   * cj9))
                                                               + ((x713
                                                                   * (px * px)))
                                                               + (((-0.027)
                                                                   * x709))),
                                                              IKFAST_ATAN2_MAGTHRESH);
                                                      if (!x714.valid)
                                                      {
                                                        continue;
                                                      }
                                                      CheckValue<IkReal> x715
                                                          = IKPowWithIntegerCheck(
                                                              IKsign((
                                                                  (((-1.0) * cj9
                                                                    * x704))
                                                                  + (((-1.0)
                                                                      * (0.55)
                                                                      * pz))
                                                                  + ((x706
                                                                      * x708))
                                                                  + ((x706
                                                                      * x707))
                                                                  + x705 + x704
                                                                  + (((-1.0)
                                                                      * cj9
                                                                      * x705))
                                                                  + (((-1.0)
                                                                      * (0.045)
                                                                      * pz
                                                                      * sj9))
                                                                  + (((-1.0)
                                                                      * (0.3)
                                                                      * cj9
                                                                      * pz)))),
                                                              -1);
                                                      if (!x715.valid)
                                                      {
                                                        continue;
                                                      }
                                                      j6array[0]
                                                          = ((-1.5707963267949)
                                                             + (x714.value)
                                                             + (((1.5707963267949)
                                                                 * (x715.value))));
                                                      sj6array[0]
                                                          = IKsin(j6array[0]);
                                                      cj6array[0]
                                                          = IKcos(j6array[0]);
                                                      if (j6array[0] > IKPI)
                                                      {
                                                        j6array[0] -= IK2PI;
                                                      }
                                                      else if (
                                                          j6array[0] < -IKPI)
                                                      {
                                                        j6array[0] += IK2PI;
                                                      }
                                                      j6valid[0] = true;
                                                      for (int ij6 = 0; ij6 < 1;
                                                           ++ij6)
                                                      {
                                                        if (!j6valid[ij6])
                                                        {
                                                          continue;
                                                        }
                                                        _ij6[0] = ij6;
                                                        _ij6[1] = -1;
                                                        for (int iij6 = ij6 + 1;
                                                             iij6 < 1;
                                                             ++iij6)
                                                        {
                                                          if (j6valid[iij6]
                                                              && IKabs(
                                                                     cj6array
                                                                         [ij6]
                                                                     - cj6array
                                                                         [iij6])
                                                                     < IKFAST_SOLUTION_THRESH
                                                              && IKabs(
                                                                     sj6array
                                                                         [ij6]
                                                                     - sj6array
                                                                         [iij6])
                                                                     < IKFAST_SOLUTION_THRESH)
                                                          {
                                                            j6valid[iij6]
                                                                = false;
                                                            _ij6[1] = iij6;
                                                            break;
                                                          }
                                                        }
                                                        j6 = j6array[ij6];
                                                        cj6 = cj6array[ij6];
                                                        sj6 = sj6array[ij6];
                                                        {
                                                          IkReal evalcond[5];
                                                          IkReal x716
                                                              = ((0.3) * cj9);
                                                          IkReal x717
                                                              = ((0.045) * sj9);
                                                          IkReal x718
                                                              = IKcos(j6);
                                                          IkReal x719
                                                              = (pz * x718);
                                                          IkReal x720
                                                              = IKsin(j6);
                                                          IkReal x721
                                                              = (cj4 * px);
                                                          IkReal x722
                                                              = (x720 * x721);
                                                          IkReal x723
                                                              = (py * sj4);
                                                          IkReal x724
                                                              = (x720 * x723);
                                                          IkReal x725
                                                              = ((0.045) * cj9);
                                                          IkReal x726
                                                              = ((0.3) * sj9);
                                                          IkReal x727
                                                              = (pz * x720);
                                                          IkReal x728
                                                              = ((1.0) * x721);
                                                          IkReal x729
                                                              = ((1.0) * x723);
                                                          IkReal x730
                                                              = ((0.09) * x718);
                                                          evalcond[0]
                                                              = ((-0.55) + x719
                                                                 + (((-1.0)
                                                                     * x716))
                                                                 + (((-1.0)
                                                                     * x717))
                                                                 + x724 + x722);
                                                          evalcond[1]
                                                              = ((0.045)
                                                                 + (((-1.0)
                                                                     * x718
                                                                     * x729))
                                                                 + (((-1.0)
                                                                     * x725))
                                                                 + (((-1.0)
                                                                     * x718
                                                                     * x728))
                                                                 + x727 + x726);
                                                          evalcond[2]
                                                              = ((((3.92156862745098)
                                                                   * pp * x720))
                                                                 + (((-1.32323529411765)
                                                                     * cj9
                                                                     * x720))
                                                                 + (((-0.108264705882353)
                                                                     * cj9
                                                                     * x718))
                                                                 + (((-1.51009803921569)
                                                                     * x720))
                                                                 + pz
                                                                 + (((-0.588235294117647)
                                                                     * pp
                                                                     * x718))
                                                                 + (((-0.316735294117647)
                                                                     * x718)));
                                                          evalcond[3]
                                                              = (((x717 * x720))
                                                                 + (((-1.0)
                                                                     * x718
                                                                     * x725))
                                                                 + (((0.045)
                                                                     * x718))
                                                                 + ((x716
                                                                     * x720))
                                                                 + (((-1.0)
                                                                     * x728))
                                                                 + (((0.55)
                                                                     * x720))
                                                                 + (((-1.0)
                                                                     * x729))
                                                                 + ((x718
                                                                     * x726)));
                                                          evalcond[4]
                                                              = ((-0.2125)
                                                                 + (((1.1)
                                                                     * x722))
                                                                 + (((-0.09)
                                                                     * x727))
                                                                 + (((1.1)
                                                                     * x719))
                                                                 + ((x723
                                                                     * x730))
                                                                 + (((1.1)
                                                                     * x724))
                                                                 + (((-1.0)
                                                                     * (1.0)
                                                                     * pp))
                                                                 + ((x721
                                                                     * x730)));
                                                          if (IKabs(evalcond[0])
                                                                  > IKFAST_EVALCOND_THRESH
                                                              || IKabs(evalcond
                                                                           [1])
                                                                     > IKFAST_EVALCOND_THRESH
                                                              || IKabs(evalcond
                                                                           [2])
                                                                     > IKFAST_EVALCOND_THRESH
                                                              || IKabs(evalcond
                                                                           [3])
                                                                     > IKFAST_EVALCOND_THRESH
                                                              || IKabs(evalcond
                                                                           [4])
                                                                     > IKFAST_EVALCOND_THRESH)
                                                          {
                                                            continue;
                                                          }
                                                        }

                                                        rotationfunction0(
                                                            solutions);
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                              else
                                              {
                                                {
                                                  IkReal j6array[1],
                                                      cj6array[1], sj6array[1];
                                                  bool j6valid[1] = {false};
                                                  _nj6 = 1;
                                                  IkReal x731 = (cj4 * px);
                                                  IkReal x732 = (py * sj4);
                                                  IkReal x733
                                                      = ((1.32323529411765)
                                                         * cj9);
                                                  IkReal x734
                                                      = ((3.92156862745098)
                                                         * pp);
                                                  IkReal x735
                                                      = ((0.0264705882352941)
                                                         * pp);
                                                  IkReal x736 = (cj9 * sj9);
                                                  IkReal x737
                                                      = ((0.176470588235294)
                                                         * pp);
                                                  IkReal x738 = cj9 * cj9;
                                                  CheckValue<IkReal> x739 = IKatan2WithCheck(
                                                      IkReal((
                                                          (-0.0142530882352941)
                                                          + (((-0.0324794117647059)
                                                              * x736))
                                                          + (((0.00938117647058823)
                                                              * cj9))
                                                          + ((pz * x732))
                                                          + ((pz * x731))
                                                          + (((-1.0) * x735))
                                                          + (((0.00487191176470588)
                                                              * x738))
                                                          + (((-1.0)
                                                              * (0.0950205882352941)
                                                              * sj9))
                                                          + ((cj9 * x735))
                                                          + (((-1.0) * sj9
                                                              * x737)))),
                                                      ((0.0679544117647059)
                                                       + (((-1.0) * x737))
                                                       + ((cj9 * x737))
                                                       + (pz * pz)
                                                       + (((-1.0)
                                                           * (0.00840882352941177)
                                                           * cj9))
                                                       + (((-0.0595455882352941)
                                                           * x738))
                                                       + (((0.453029411764706)
                                                           * sj9))
                                                       + (((0.396970588235294)
                                                           * x736))
                                                       + (((-1.0)
                                                           * (1.17647058823529)
                                                           * pp * sj9))),
                                                      IKFAST_ATAN2_MAGTHRESH);
                                                  if (!x739.valid)
                                                  {
                                                    continue;
                                                  }
                                                  CheckValue<IkReal> x740 = IKPowWithIntegerCheck(
                                                      IKsign((
                                                          (((0.316735294117647)
                                                            * pz))
                                                          + (((0.108264705882353)
                                                              * cj9 * pz))
                                                          + (((0.588235294117647)
                                                              * pp * pz))
                                                          + ((x732 * x733))
                                                          + (((-1.0) * x732
                                                              * x734))
                                                          + (((1.51009803921569)
                                                              * x731))
                                                          + (((1.51009803921569)
                                                              * x732))
                                                          + ((x731 * x733))
                                                          + (((-1.0) * x731
                                                              * x734)))),
                                                      -1);
                                                  if (!x740.valid)
                                                  {
                                                    continue;
                                                  }
                                                  j6array[0]
                                                      = ((-1.5707963267949)
                                                         + (x739.value)
                                                         + (((1.5707963267949)
                                                             * (x740.value))));
                                                  sj6array[0]
                                                      = IKsin(j6array[0]);
                                                  cj6array[0]
                                                      = IKcos(j6array[0]);
                                                  if (j6array[0] > IKPI)
                                                  {
                                                    j6array[0] -= IK2PI;
                                                  }
                                                  else if (j6array[0] < -IKPI)
                                                  {
                                                    j6array[0] += IK2PI;
                                                  }
                                                  j6valid[0] = true;
                                                  for (int ij6 = 0; ij6 < 1;
                                                       ++ij6)
                                                  {
                                                    if (!j6valid[ij6])
                                                    {
                                                      continue;
                                                    }
                                                    _ij6[0] = ij6;
                                                    _ij6[1] = -1;
                                                    for (int iij6 = ij6 + 1;
                                                         iij6 < 1;
                                                         ++iij6)
                                                    {
                                                      if (j6valid[iij6]
                                                          && IKabs(
                                                                 cj6array[ij6]
                                                                 - cj6array
                                                                     [iij6])
                                                                 < IKFAST_SOLUTION_THRESH
                                                          && IKabs(
                                                                 sj6array[ij6]
                                                                 - sj6array
                                                                     [iij6])
                                                                 < IKFAST_SOLUTION_THRESH)
                                                      {
                                                        j6valid[iij6] = false;
                                                        _ij6[1] = iij6;
                                                        break;
                                                      }
                                                    }
                                                    j6 = j6array[ij6];
                                                    cj6 = cj6array[ij6];
                                                    sj6 = sj6array[ij6];
                                                    {
                                                      IkReal evalcond[5];
                                                      IkReal x741
                                                          = ((0.3) * cj9);
                                                      IkReal x742
                                                          = ((0.045) * sj9);
                                                      IkReal x743 = IKcos(j6);
                                                      IkReal x744 = (pz * x743);
                                                      IkReal x745 = IKsin(j6);
                                                      IkReal x746 = (cj4 * px);
                                                      IkReal x747
                                                          = (x745 * x746);
                                                      IkReal x748 = (py * sj4);
                                                      IkReal x749
                                                          = (x745 * x748);
                                                      IkReal x750
                                                          = ((0.045) * cj9);
                                                      IkReal x751
                                                          = ((0.3) * sj9);
                                                      IkReal x752 = (pz * x745);
                                                      IkReal x753
                                                          = ((1.0) * x746);
                                                      IkReal x754
                                                          = ((1.0) * x748);
                                                      IkReal x755
                                                          = ((0.09) * x743);
                                                      evalcond[0]
                                                          = ((-0.55)
                                                             + (((-1.0) * x741))
                                                             + x749 + x744
                                                             + x747
                                                             + (((-1.0)
                                                                 * x742)));
                                                      evalcond[1]
                                                          = ((0.045)
                                                             + (((-1.0) * x743
                                                                 * x753))
                                                             + (((-1.0) * x743
                                                                 * x754))
                                                             + x752 + x751
                                                             + (((-1.0)
                                                                 * x750)));
                                                      evalcond[2]
                                                          = ((((-0.316735294117647)
                                                               * x743))
                                                             + (((-1.32323529411765)
                                                                 * cj9 * x745))
                                                             + pz
                                                             + (((-0.108264705882353)
                                                                 * cj9 * x743))
                                                             + (((-1.51009803921569)
                                                                 * x745))
                                                             + (((-0.588235294117647)
                                                                 * pp * x743))
                                                             + (((3.92156862745098)
                                                                 * pp * x745)));
                                                      evalcond[3]
                                                          = ((((-1.0) * x753))
                                                             + (((0.55) * x745))
                                                             + (((0.045)
                                                                 * x743))
                                                             + ((x741 * x745))
                                                             + ((x743 * x751))
                                                             + (((-1.0) * x743
                                                                 * x750))
                                                             + (((-1.0) * x754))
                                                             + ((x742 * x745)));
                                                      evalcond[4]
                                                          = ((-0.2125)
                                                             + (((1.1) * x749))
                                                             + (((-0.09)
                                                                 * x752))
                                                             + ((x748 * x755))
                                                             + (((1.1) * x744))
                                                             + (((-1.0) * (1.0)
                                                                 * pp))
                                                             + ((x746 * x755))
                                                             + (((1.1)
                                                                 * x747)));
                                                      if (IKabs(evalcond[0])
                                                              > IKFAST_EVALCOND_THRESH
                                                          || IKabs(evalcond[1])
                                                                 > IKFAST_EVALCOND_THRESH
                                                          || IKabs(evalcond[2])
                                                                 > IKFAST_EVALCOND_THRESH
                                                          || IKabs(evalcond[3])
                                                                 > IKFAST_EVALCOND_THRESH
                                                          || IKabs(evalcond[4])
                                                                 > IKFAST_EVALCOND_THRESH)
                                                      {
                                                        continue;
                                                      }
                                                    }

                                                    rotationfunction0(
                                                        solutions);
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        } while (0);
                                        if (bgotonextstatement)
                                        {
                                          bool bgotonextstatement = true;
                                          do
                                          {
                                            IkReal x756 = (px * sj4);
                                            IkReal x757 = (cj4 * py);
                                            evalcond[0]
                                                = ((-3.14159265358979)
                                                   + (IKfmod(
                                                       ((3.14159265358979)
                                                        + (IKabs(
                                                            ((-3.14159265358979)
                                                             + j8)))),
                                                       6.28318530717959)));
                                            evalcond[1]
                                                = ((0.39655)
                                                   + (((0.0765) * sj9))
                                                   + (((0.32595) * cj9))
                                                   + (((-1.0) * (1.0) * pp)));
                                            evalcond[2]
                                                = ((((-1.0) * x757)) + x756);
                                            evalcond[3]
                                                = ((((-1.0) * x756)) + x757);
                                            if (IKabs(evalcond[0])
                                                    < 0.0000010000000000
                                                && IKabs(evalcond[1])
                                                       < 0.0000010000000000
                                                && IKabs(evalcond[2])
                                                       < 0.0000010000000000
                                                && IKabs(evalcond[3])
                                                       < 0.0000010000000000)
                                            {
                                              bgotonextstatement = false;
                                              {
                                                IkReal j6eval[2];
                                                sj8 = 0;
                                                cj8 = -1.0;
                                                j8 = 3.14159265358979;
                                                IkReal x758 = py * py;
                                                IkReal x759 = cj4 * cj4;
                                                IkReal x760
                                                    = ((pz * pz)
                                                       + ((x759 * (px * px)))
                                                       + (((2.0) * cj4 * px * py
                                                           * sj4))
                                                       + x758
                                                       + (((-1.0) * x758
                                                           * x759)));
                                                j6eval[0] = x760;
                                                j6eval[1] = IKsign(x760);
                                                if (IKabs(j6eval[0])
                                                        < 0.0000010000000000
                                                    || IKabs(j6eval[1])
                                                           < 0.0000010000000000)
                                                {
                                                  {
                                                    IkReal j6eval[2];
                                                    sj8 = 0;
                                                    cj8 = -1.0;
                                                    j8 = 3.14159265358979;
                                                    IkReal x761 = (cj4 * px);
                                                    IkReal x762 = (cj9 * pz);
                                                    IkReal x763 = (py * sj4);
                                                    IkReal x764 = (pz * sj9);
                                                    IkReal x765
                                                        = (cj4 * px * sj9);
                                                    IkReal x766
                                                        = (py * sj4 * sj9);
                                                    IkReal x767
                                                        = ((0.045) * x761);
                                                    IkReal x768
                                                        = ((0.045) * x763);
                                                    j6eval[0]
                                                        = (((cj9 * x761))
                                                           + (((-1.0)
                                                               * (12.2222222222222)
                                                               * pz))
                                                           + (((-1.0) * x764))
                                                           + (((-6.66666666666667)
                                                               * x765))
                                                           + (((-1.0) * x763))
                                                           + (((-6.66666666666667)
                                                               * x766))
                                                           + ((cj9 * x763))
                                                           + (((-6.66666666666667)
                                                               * x762))
                                                           + (((-1.0) * x761)));
                                                    j6eval[1] = IKsign(
                                                        ((((-0.3) * x766))
                                                         + (((-1.0) * x767))
                                                         + (((-1.0) * (0.55)
                                                             * pz))
                                                         + ((cj9 * x768))
                                                         + (((-0.3) * x765))
                                                         + (((-1.0) * x768))
                                                         + (((-0.3) * x762))
                                                         + (((-0.045) * x764))
                                                         + ((cj9 * x767))));
                                                    if (IKabs(j6eval[0])
                                                            < 0.0000010000000000
                                                        || IKabs(j6eval[1])
                                                               < 0.0000010000000000)
                                                    {
                                                      {
                                                        IkReal j6eval[2];
                                                        sj8 = 0;
                                                        cj8 = -1.0;
                                                        j8 = 3.14159265358979;
                                                        IkReal x769
                                                            = (cj4 * px);
                                                        IkReal x770
                                                            = (cj9 * pz);
                                                        IkReal x771 = (pp * pz);
                                                        IkReal x772
                                                            = (py * sj4);
                                                        IkReal x773
                                                            = (cj4 * cj9 * px);
                                                        IkReal x774
                                                            = (cj4 * pp * px);
                                                        IkReal x775
                                                            = (cj9 * py * sj4);
                                                        IkReal x776
                                                            = (pp * py * sj4);
                                                        j6eval[0]
                                                            = ((((-1.0) * x775))
                                                               + (((-1.0)
                                                                   * (13.9482024812098)
                                                                   * pz))
                                                               + (((-2.92556370551481)
                                                                   * x772))
                                                               + (((-12.2222222222222)
                                                                   * x770))
                                                               + (((-5.4333061668025)
                                                                   * x776))
                                                               + (((-1.0)
                                                                   * x773))
                                                               + (((-5.4333061668025)
                                                                   * x774))
                                                               + (((-2.92556370551481)
                                                                   * x769))
                                                               + (((36.2220411120167)
                                                                   * x771)));
                                                        j6eval[1] = IKsign((
                                                            (((-0.588235294117647)
                                                              * x776))
                                                            + (((-0.108264705882353)
                                                                * x773))
                                                            + (((3.92156862745098)
                                                                * x771))
                                                            + (((-0.316735294117647)
                                                                * x772))
                                                            + (((-1.0)
                                                                * (1.51009803921569)
                                                                * pz))
                                                            + (((-0.316735294117647)
                                                                * x769))
                                                            + (((-1.32323529411765)
                                                                * x770))
                                                            + (((-0.588235294117647)
                                                                * x774))
                                                            + (((-0.108264705882353)
                                                                * x775))));
                                                        if (IKabs(j6eval[0])
                                                                < 0.0000010000000000
                                                            || IKabs(j6eval[1])
                                                                   < 0.0000010000000000)
                                                        {
                                                          {
                                                            IkReal evalcond[1];
                                                            bool
                                                                bgotonextstatement
                                                                = true;
                                                            do
                                                            {
                                                              evalcond[0]
                                                                  = ((IKabs((
                                                                         (-3.14159265358979)
                                                                         + (IKfmod(
                                                                             ((3.14159265358979)
                                                                              + j9),
                                                                             6.28318530717959)))))
                                                                     + (IKabs(
                                                                         pz)));
                                                              if (IKabs(evalcond
                                                                            [0])
                                                                  < 0.0000010000000000)
                                                              {
                                                                bgotonextstatement
                                                                    = false;
                                                                {
                                                                  IkReal
                                                                      j6eval[1];
                                                                  IkReal x777
                                                                      = ((1.0)
                                                                         * py);
                                                                  sj8 = 0;
                                                                  cj8 = -1.0;
                                                                  j8 = 3.14159265358979;
                                                                  pz = 0;
                                                                  j9 = 0;
                                                                  sj9 = 0;
                                                                  cj9 = 1.0;
                                                                  pp
                                                                      = ((py
                                                                          * py)
                                                                         + (px
                                                                            * px));
                                                                  npx
                                                                      = (((py
                                                                           * r10))
                                                                         + ((px
                                                                             * r00)));
                                                                  npy
                                                                      = (((py
                                                                           * r11))
                                                                         + ((px
                                                                             * r01)));
                                                                  npz
                                                                      = (((px
                                                                           * r02))
                                                                         + ((py
                                                                             * r12)));
                                                                  rxp0_0
                                                                      = ((-1.0)
                                                                         * r20
                                                                         * x777);
                                                                  rxp0_1
                                                                      = (px
                                                                         * r20);
                                                                  rxp1_0
                                                                      = ((-1.0)
                                                                         * r21
                                                                         * x777);
                                                                  rxp1_1
                                                                      = (px
                                                                         * r21);
                                                                  rxp2_0
                                                                      = ((-1.0)
                                                                         * r22
                                                                         * x777);
                                                                  rxp2_1
                                                                      = (px
                                                                         * r22);
                                                                  j6eval[0]
                                                                      = ((((-1.0)
                                                                           * (1.0)
                                                                           * cj4
                                                                           * px))
                                                                         + (((-1.0)
                                                                             * (1.0)
                                                                             * py
                                                                             * sj4)));
                                                                  if (IKabs(
                                                                          j6eval
                                                                              [0])
                                                                      < 0.0000010000000000)
                                                                  {
                                                                    {
                                                                      IkReal j6eval
                                                                          [1];
                                                                      IkReal
                                                                          x778
                                                                          = ((1.0)
                                                                             * py);
                                                                      sj8 = 0;
                                                                      cj8 = -1.0;
                                                                      j8 = 3.14159265358979;
                                                                      pz = 0;
                                                                      j9 = 0;
                                                                      sj9 = 0;
                                                                      cj9 = 1.0;
                                                                      pp
                                                                          = ((py
                                                                              * py)
                                                                             + (px
                                                                                * px));
                                                                      npx
                                                                          = (((py
                                                                               * r10))
                                                                             + ((px
                                                                                 * r00)));
                                                                      npy
                                                                          = (((py
                                                                               * r11))
                                                                             + ((px
                                                                                 * r01)));
                                                                      npz
                                                                          = (((px
                                                                               * r02))
                                                                             + ((py
                                                                                 * r12)));
                                                                      rxp0_0
                                                                          = ((-1.0)
                                                                             * r20
                                                                             * x778);
                                                                      rxp0_1
                                                                          = (px
                                                                             * r20);
                                                                      rxp1_0
                                                                          = ((-1.0)
                                                                             * r21
                                                                             * x778);
                                                                      rxp1_1
                                                                          = (px
                                                                             * r21);
                                                                      rxp2_0
                                                                          = ((-1.0)
                                                                             * r22
                                                                             * x778);
                                                                      rxp2_1
                                                                          = (px
                                                                             * r22);
                                                                      j6eval[0]
                                                                          = ((-1.0)
                                                                             + (((-1.0)
                                                                                 * (1.3840830449827)
                                                                                 * (px
                                                                                    * px)))
                                                                             + (((-1.0)
                                                                                 * (1.3840830449827)
                                                                                 * (py
                                                                                    * py))));
                                                                      if (IKabs(
                                                                              j6eval
                                                                                  [0])
                                                                          < 0.0000010000000000)
                                                                      {
                                                                        {
                                                                          IkReal j6eval
                                                                              [2];
                                                                          IkReal
                                                                              x779
                                                                              = ((1.0)
                                                                                 * py);
                                                                          sj8 = 0;
                                                                          cj8 = -1.0;
                                                                          j8 = 3.14159265358979;
                                                                          pz = 0;
                                                                          j9 = 0;
                                                                          sj9 = 0;
                                                                          cj9 = 1.0;
                                                                          pp
                                                                              = ((py
                                                                                  * py)
                                                                                 + (px
                                                                                    * px));
                                                                          npx
                                                                              = (((py
                                                                                   * r10))
                                                                                 + ((px
                                                                                     * r00)));
                                                                          npy
                                                                              = (((py
                                                                                   * r11))
                                                                                 + ((px
                                                                                     * r01)));
                                                                          npz
                                                                              = (((px
                                                                                   * r02))
                                                                                 + ((py
                                                                                     * r12)));
                                                                          rxp0_0
                                                                              = ((-1.0)
                                                                                 * r20
                                                                                 * x779);
                                                                          rxp0_1
                                                                              = (px
                                                                                 * r20);
                                                                          rxp1_0
                                                                              = ((-1.0)
                                                                                 * r21
                                                                                 * x779);
                                                                          rxp1_1
                                                                              = (px
                                                                                 * r21);
                                                                          rxp2_0
                                                                              = ((-1.0)
                                                                                 * r22
                                                                                 * x779);
                                                                          rxp2_1
                                                                              = (px
                                                                                 * r22);
                                                                          IkReal
                                                                              x780
                                                                              = (cj4
                                                                                 * px);
                                                                          IkReal
                                                                              x781
                                                                              = (py
                                                                                 * sj4);
                                                                          j6eval
                                                                              [0]
                                                                              = (x780
                                                                                 + x781);
                                                                          j6eval
                                                                              [1]
                                                                              = ((((-1.0)
                                                                                   * (1.3840830449827)
                                                                                   * cj4
                                                                                   * (px
                                                                                      * px
                                                                                      * px)))
                                                                                 + (((-1.0)
                                                                                     * x780))
                                                                                 + (((-1.3840830449827)
                                                                                     * x780
                                                                                     * (py
                                                                                        * py)))
                                                                                 + (((-1.0)
                                                                                     * x781))
                                                                                 + (((-1.0)
                                                                                     * (1.3840830449827)
                                                                                     * sj4
                                                                                     * (py
                                                                                        * py
                                                                                        * py)))
                                                                                 + (((-1.3840830449827)
                                                                                     * x781
                                                                                     * (px
                                                                                        * px))));
                                                                          if (IKabs(
                                                                                  j6eval
                                                                                      [0])
                                                                                  < 0.0000010000000000
                                                                              || IKabs(
                                                                                     j6eval
                                                                                         [1])
                                                                                     < 0.0000010000000000)
                                                                          {
                                                                            {
                                                                              IkReal evalcond
                                                                                  [4];
                                                                              bool
                                                                                  bgotonextstatement
                                                                                  = true;
                                                                              do
                                                                              {
                                                                                evalcond
                                                                                    [0]
                                                                                    = ((IKabs(
                                                                                           py))
                                                                                       + (IKabs(
                                                                                           px)));
                                                                                evalcond
                                                                                    [1]
                                                                                    = -0.85;
                                                                                evalcond
                                                                                    [2]
                                                                                    = 0;
                                                                                evalcond
                                                                                    [3]
                                                                                    = -0.2125;
                                                                                if (IKabs(
                                                                                        evalcond
                                                                                            [0])
                                                                                        < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [1])
                                                                                           < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [2])
                                                                                           < 0.0000010000000000
                                                                                    && IKabs(
                                                                                           evalcond
                                                                                               [3])
                                                                                           < 0.0000010000000000)
                                                                                {
                                                                                  bgotonextstatement
                                                                                      = false;
                                                                                  {
                                                                                    IkReal j6array
                                                                                        [2],
                                                                                        cj6array
                                                                                            [2],
                                                                                        sj6array
                                                                                            [2];
                                                                                    bool j6valid
                                                                                        [2]
                                                                                        = {false};
                                                                                    _nj6
                                                                                        = 2;
                                                                                    j6array
                                                                                        [0]
                                                                                        = 0.148889947609497;
                                                                                    sj6array
                                                                                        [0]
                                                                                        = IKsin(
                                                                                            j6array
                                                                                                [0]);
                                                                                    cj6array
                                                                                        [0]
                                                                                        = IKcos(
                                                                                            j6array
                                                                                                [0]);
                                                                                    j6array
                                                                                        [1]
                                                                                        = 3.29048260119929;
                                                                                    sj6array
                                                                                        [1]
                                                                                        = IKsin(
                                                                                            j6array
                                                                                                [1]);
                                                                                    cj6array
                                                                                        [1]
                                                                                        = IKcos(
                                                                                            j6array
                                                                                                [1]);
                                                                                    if (j6array
                                                                                            [0]
                                                                                        > IKPI)
                                                                                    {
                                                                                      j6array
                                                                                          [0]
                                                                                          -= IK2PI;
                                                                                    }
                                                                                    else if (
                                                                                        j6array
                                                                                            [0]
                                                                                        < -IKPI)
                                                                                    {
                                                                                      j6array
                                                                                          [0]
                                                                                          += IK2PI;
                                                                                    }
                                                                                    j6valid
                                                                                        [0]
                                                                                        = true;
                                                                                    if (j6array
                                                                                            [1]
                                                                                        > IKPI)
                                                                                    {
                                                                                      j6array
                                                                                          [1]
                                                                                          -= IK2PI;
                                                                                    }
                                                                                    else if (
                                                                                        j6array
                                                                                            [1]
                                                                                        < -IKPI)
                                                                                    {
                                                                                      j6array
                                                                                          [1]
                                                                                          += IK2PI;
                                                                                    }
                                                                                    j6valid
                                                                                        [1]
                                                                                        = true;
                                                                                    for (
                                                                                        int ij6
                                                                                        = 0;
                                                                                        ij6
                                                                                        < 2;
                                                                                        ++ij6)
                                                                                    {
                                                                                      if (!j6valid
                                                                                              [ij6])
                                                                                      {
                                                                                        continue;
                                                                                      }
                                                                                      _ij6[0]
                                                                                          = ij6;
                                                                                      _ij6[1]
                                                                                          = -1;
                                                                                      for (
                                                                                          int iij6
                                                                                          = ij6
                                                                                            + 1;
                                                                                          iij6
                                                                                          < 2;
                                                                                          ++iij6)
                                                                                      {
                                                                                        if (j6valid
                                                                                                [iij6]
                                                                                            && IKabs(
                                                                                                   cj6array
                                                                                                       [ij6]
                                                                                                   - cj6array
                                                                                                       [iij6])
                                                                                                   < IKFAST_SOLUTION_THRESH
                                                                                            && IKabs(
                                                                                                   sj6array
                                                                                                       [ij6]
                                                                                                   - sj6array
                                                                                                       [iij6])
                                                                                                   < IKFAST_SOLUTION_THRESH)
                                                                                        {
                                                                                          j6valid
                                                                                              [iij6]
                                                                                              = false;
                                                                                          _ij6[1]
                                                                                              = iij6;
                                                                                          break;
                                                                                        }
                                                                                      }
                                                                                      j6 = j6array
                                                                                          [ij6];
                                                                                      cj6 = cj6array
                                                                                          [ij6];
                                                                                      sj6 = sj6array
                                                                                          [ij6];
                                                                                      {
                                                                                        IkReal evalcond
                                                                                            [1];
                                                                                        evalcond
                                                                                            [0]
                                                                                            = ((0.85)
                                                                                               * (IKsin(
                                                                                                   j6)));
                                                                                        if (IKabs(
                                                                                                evalcond
                                                                                                    [0])
                                                                                            > IKFAST_EVALCOND_THRESH)
                                                                                        {
                                                                                          continue;
                                                                                        }
                                                                                      }

                                                                                      rotationfunction0(
                                                                                          solutions);
                                                                                    }
                                                                                  }
                                                                                }
                                                                              } while (
                                                                                  0);
                                                                              if (bgotonextstatement)
                                                                              {
                                                                                bool
                                                                                    bgotonextstatement
                                                                                    = true;
                                                                                do
                                                                                {
                                                                                  evalcond
                                                                                      [0]
                                                                                      = ((IKabs((
                                                                                             (-3.14159265358979)
                                                                                             + (IKfmod(
                                                                                                 ((3.14159265358979)
                                                                                                  + j4),
                                                                                                 6.28318530717959)))))
                                                                                         + (IKabs(
                                                                                             px)));
                                                                                  evalcond
                                                                                      [1]
                                                                                      = -0.85;
                                                                                  evalcond
                                                                                      [2]
                                                                                      = 0;
                                                                                  evalcond
                                                                                      [3]
                                                                                      = ((-0.2125)
                                                                                         + (((-1.0)
                                                                                             * (1.0)
                                                                                             * (py
                                                                                                * py))));
                                                                                  if (IKabs(
                                                                                          evalcond
                                                                                              [0])
                                                                                          < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [1])
                                                                                             < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [2])
                                                                                             < 0.0000010000000000
                                                                                      && IKabs(
                                                                                             evalcond
                                                                                                 [3])
                                                                                             < 0.0000010000000000)
                                                                                  {
                                                                                    bgotonextstatement
                                                                                        = false;
                                                                                    {
                                                                                      IkReal j6eval
                                                                                          [1];
                                                                                      IkReal
                                                                                          x782
                                                                                          = ((1.0)
                                                                                             * py);
                                                                                      sj8 = 0;
                                                                                      cj8 = -1.0;
                                                                                      j8 = 3.14159265358979;
                                                                                      pz = 0;
                                                                                      j9 = 0;
                                                                                      sj9 = 0;
                                                                                      cj9 = 1.0;
                                                                                      pp = py
                                                                                           * py;
                                                                                      npx
                                                                                          = (py
                                                                                             * r10);
                                                                                      npy
                                                                                          = (py
                                                                                             * r11);
                                                                                      npz
                                                                                          = (py
                                                                                             * r12);
                                                                                      rxp0_0
                                                                                          = ((-1.0)
                                                                                             * r20
                                                                                             * x782);
                                                                                      rxp0_1
                                                                                          = 0;
                                                                                      rxp1_0
                                                                                          = ((-1.0)
                                                                                             * r21
                                                                                             * x782);
                                                                                      rxp1_1
                                                                                          = 0;
                                                                                      rxp2_0
                                                                                          = ((-1.0)
                                                                                             * r22
                                                                                             * x782);
                                                                                      rxp2_1
                                                                                          = 0;
                                                                                      px = 0;
                                                                                      j4 = 0;
                                                                                      sj4 = 0;
                                                                                      cj4 = 1.0;
                                                                                      rxp0_2
                                                                                          = (py
                                                                                             * r00);
                                                                                      rxp1_2
                                                                                          = (py
                                                                                             * r01);
                                                                                      rxp2_2
                                                                                          = (py
                                                                                             * r02);
                                                                                      j6eval
                                                                                          [0]
                                                                                          = ((1.0)
                                                                                             + (((1.91568587540858)
                                                                                                 * (py
                                                                                                    * py
                                                                                                    * py
                                                                                                    * py)))
                                                                                             + (((-1.0)
                                                                                                 * (2.64633970947792)
                                                                                                 * (py
                                                                                                    * py))));
                                                                                      if (IKabs(
                                                                                              j6eval
                                                                                                  [0])
                                                                                          < 0.0000010000000000)
                                                                                      {
                                                                                        continue; // no branches [j6]
                                                                                      }
                                                                                      else
                                                                                      {
                                                                                        {
                                                                                          IkReal j6array
                                                                                              [2],
                                                                                              cj6array
                                                                                                  [2],
                                                                                              sj6array
                                                                                                  [2];
                                                                                          bool j6valid
                                                                                              [2]
                                                                                              = {false};
                                                                                          _nj6
                                                                                              = 2;
                                                                                          IkReal
                                                                                              x783
                                                                                              = py
                                                                                                * py;
                                                                                          CheckValue<IkReal> x785 = IKatan2WithCheck(
                                                                                              IkReal((
                                                                                                  (-0.425)
                                                                                                  + (((-0.588235294117647)
                                                                                                      * x783)))),
                                                                                              ((2.83333333333333)
                                                                                               + (((-3.92156862745098)
                                                                                                   * x783))),
                                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                                          if (!x785.valid)
                                                                                          {
                                                                                            continue;
                                                                                          }
                                                                                          IkReal
                                                                                              x784
                                                                                              = ((-1.0)
                                                                                                 * (x785.value));
                                                                                          j6array
                                                                                              [0]
                                                                                              = x784;
                                                                                          sj6array
                                                                                              [0]
                                                                                              = IKsin(
                                                                                                  j6array
                                                                                                      [0]);
                                                                                          cj6array
                                                                                              [0]
                                                                                              = IKcos(
                                                                                                  j6array
                                                                                                      [0]);
                                                                                          j6array
                                                                                              [1]
                                                                                              = ((3.14159265358979)
                                                                                                 + x784);
                                                                                          sj6array
                                                                                              [1]
                                                                                              = IKsin(
                                                                                                  j6array
                                                                                                      [1]);
                                                                                          cj6array
                                                                                              [1]
                                                                                              = IKcos(
                                                                                                  j6array
                                                                                                      [1]);
                                                                                          if (j6array
                                                                                                  [0]
                                                                                              > IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [0]
                                                                                                -= IK2PI;
                                                                                          }
                                                                                          else if (
                                                                                              j6array
                                                                                                  [0]
                                                                                              < -IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [0]
                                                                                                += IK2PI;
                                                                                          }
                                                                                          j6valid
                                                                                              [0]
                                                                                              = true;
                                                                                          if (j6array
                                                                                                  [1]
                                                                                              > IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [1]
                                                                                                -= IK2PI;
                                                                                          }
                                                                                          else if (
                                                                                              j6array
                                                                                                  [1]
                                                                                              < -IKPI)
                                                                                          {
                                                                                            j6array
                                                                                                [1]
                                                                                                += IK2PI;
                                                                                          }
                                                                                          j6valid
                                                                                              [1]
                                                                                              = true;
                                                                                          for (
                                                                                              int ij6
                                                                                              = 0;
                                                                                              ij6
                                                                                              < 2;
                                                                                              ++ij6)
                                                                                          {
                                                                                            if (!j6valid
                                                                                                    [ij6])
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            _ij6[0]
                                                                                                = ij6;
                                                                                            _ij6[1]
                                                                                                = -1;
                                                                                            for (
                                                                                                int iij6
                                                                                                = ij6
                                                                                                  + 1;
                                                                                                iij6
                                                                                                < 2;
                                                                                                ++iij6)
                                                                                            {
                                                                                              if (j6valid
                                                                                                      [iij6]
                                                                                                  && IKabs(
                                                                                                         cj6array
                                                                                                             [ij6]
                                                                                                         - cj6array
                                                                                                             [iij6])
                                                                                                         < IKFAST_SOLUTION_THRESH
                                                                                                  && IKabs(
                                                                                                         sj6array
                                                                                                             [ij6]
                                                                                                         - sj6array
                                                                                                             [iij6])
                                                                                                         < IKFAST_SOLUTION_THRESH)
                                                                                              {
                                                                                                j6valid
                                                                                                    [iij6]
                                                                                                    = false;
                                                                                                _ij6[1]
                                                                                                    = iij6;
                                                                                                break;
                                                                                              }
                                                                                            }
                                                                                            j6 = j6array
                                                                                                [ij6];
                                                                                            cj6 = cj6array
                                                                                                [ij6];
                                                                                            sj6 = sj6array
                                                                                                [ij6];
                                                                                            {
                                                                                              IkReal evalcond
                                                                                                  [1];
                                                                                              evalcond
                                                                                                  [0]
                                                                                                  = ((0.85)
                                                                                                     * (IKsin(
                                                                                                         j6)));
                                                                                              if (IKabs(
                                                                                                      evalcond
                                                                                                          [0])
                                                                                                  > IKFAST_EVALCOND_THRESH)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                            }

                                                                                            rotationfunction0(
                                                                                                solutions);
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                } while (
                                                                                    0);
                                                                                if (bgotonextstatement)
                                                                                {
                                                                                  bool
                                                                                      bgotonextstatement
                                                                                      = true;
                                                                                  do
                                                                                  {
                                                                                    evalcond
                                                                                        [0]
                                                                                        = ((IKabs((
                                                                                               (-3.14159265358979)
                                                                                               + (IKfmod(
                                                                                                   j4,
                                                                                                   6.28318530717959)))))
                                                                                           + (IKabs(
                                                                                               px)));
                                                                                    evalcond
                                                                                        [1]
                                                                                        = -0.85;
                                                                                    evalcond
                                                                                        [2]
                                                                                        = 0;
                                                                                    evalcond
                                                                                        [3]
                                                                                        = ((-0.2125)
                                                                                           + (((-1.0)
                                                                                               * (1.0)
                                                                                               * (py
                                                                                                  * py))));
                                                                                    if (IKabs(
                                                                                            evalcond
                                                                                                [0])
                                                                                            < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [1])
                                                                                               < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [2])
                                                                                               < 0.0000010000000000
                                                                                        && IKabs(
                                                                                               evalcond
                                                                                                   [3])
                                                                                               < 0.0000010000000000)
                                                                                    {
                                                                                      bgotonextstatement
                                                                                          = false;
                                                                                      {
                                                                                        IkReal j6eval
                                                                                            [1];
                                                                                        IkReal
                                                                                            x786
                                                                                            = ((1.0)
                                                                                               * py);
                                                                                        sj8 = 0;
                                                                                        cj8 = -1.0;
                                                                                        j8 = 3.14159265358979;
                                                                                        pz = 0;
                                                                                        j9 = 0;
                                                                                        sj9 = 0;
                                                                                        cj9 = 1.0;
                                                                                        pp = py
                                                                                             * py;
                                                                                        npx
                                                                                            = (py
                                                                                               * r10);
                                                                                        npy
                                                                                            = (py
                                                                                               * r11);
                                                                                        npz
                                                                                            = (py
                                                                                               * r12);
                                                                                        rxp0_0
                                                                                            = ((-1.0)
                                                                                               * r20
                                                                                               * x786);
                                                                                        rxp0_1
                                                                                            = 0;
                                                                                        rxp1_0
                                                                                            = ((-1.0)
                                                                                               * r21
                                                                                               * x786);
                                                                                        rxp1_1
                                                                                            = 0;
                                                                                        rxp2_0
                                                                                            = ((-1.0)
                                                                                               * r22
                                                                                               * x786);
                                                                                        rxp2_1
                                                                                            = 0;
                                                                                        px = 0;
                                                                                        j4 = 3.14159265358979;
                                                                                        sj4 = 0;
                                                                                        cj4 = -1.0;
                                                                                        rxp0_2
                                                                                            = (py
                                                                                               * r00);
                                                                                        rxp1_2
                                                                                            = (py
                                                                                               * r01);
                                                                                        rxp2_2
                                                                                            = (py
                                                                                               * r02);
                                                                                        j6eval
                                                                                            [0]
                                                                                            = ((1.0)
                                                                                               + (((1.91568587540858)
                                                                                                   * (py
                                                                                                      * py
                                                                                                      * py
                                                                                                      * py)))
                                                                                               + (((-1.0)
                                                                                                   * (2.64633970947792)
                                                                                                   * (py
                                                                                                      * py))));
                                                                                        if (IKabs(
                                                                                                j6eval
                                                                                                    [0])
                                                                                            < 0.0000010000000000)
                                                                                        {
                                                                                          continue; // no branches [j6]
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                          {
                                                                                            IkReal j6array
                                                                                                [2],
                                                                                                cj6array
                                                                                                    [2],
                                                                                                sj6array
                                                                                                    [2];
                                                                                            bool j6valid
                                                                                                [2]
                                                                                                = {false};
                                                                                            _nj6
                                                                                                = 2;
                                                                                            IkReal
                                                                                                x787
                                                                                                = py
                                                                                                  * py;
                                                                                            CheckValue<IkReal> x789 = IKatan2WithCheck(
                                                                                                IkReal((
                                                                                                    (-0.425)
                                                                                                    + (((-0.588235294117647)
                                                                                                        * x787)))),
                                                                                                ((2.83333333333333)
                                                                                                 + (((-3.92156862745098)
                                                                                                     * x787))),
                                                                                                IKFAST_ATAN2_MAGTHRESH);
                                                                                            if (!x789.valid)
                                                                                            {
                                                                                              continue;
                                                                                            }
                                                                                            IkReal
                                                                                                x788
                                                                                                = ((-1.0)
                                                                                                   * (x789.value));
                                                                                            j6array
                                                                                                [0]
                                                                                                = x788;
                                                                                            sj6array
                                                                                                [0]
                                                                                                = IKsin(
                                                                                                    j6array
                                                                                                        [0]);
                                                                                            cj6array
                                                                                                [0]
                                                                                                = IKcos(
                                                                                                    j6array
                                                                                                        [0]);
                                                                                            j6array
                                                                                                [1]
                                                                                                = ((3.14159265358979)
                                                                                                   + x788);
                                                                                            sj6array
                                                                                                [1]
                                                                                                = IKsin(
                                                                                                    j6array
                                                                                                        [1]);
                                                                                            cj6array
                                                                                                [1]
                                                                                                = IKcos(
                                                                                                    j6array
                                                                                                        [1]);
                                                                                            if (j6array
                                                                                                    [0]
                                                                                                > IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [0]
                                                                                                  -= IK2PI;
                                                                                            }
                                                                                            else if (
                                                                                                j6array
                                                                                                    [0]
                                                                                                < -IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [0]
                                                                                                  += IK2PI;
                                                                                            }
                                                                                            j6valid
                                                                                                [0]
                                                                                                = true;
                                                                                            if (j6array
                                                                                                    [1]
                                                                                                > IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [1]
                                                                                                  -= IK2PI;
                                                                                            }
                                                                                            else if (
                                                                                                j6array
                                                                                                    [1]
                                                                                                < -IKPI)
                                                                                            {
                                                                                              j6array
                                                                                                  [1]
                                                                                                  += IK2PI;
                                                                                            }
                                                                                            j6valid
                                                                                                [1]
                                                                                                = true;
                                                                                            for (
                                                                                                int ij6
                                                                                                = 0;
                                                                                                ij6
                                                                                                < 2;
                                                                                                ++ij6)
                                                                                            {
                                                                                              if (!j6valid
                                                                                                      [ij6])
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              _ij6[0]
                                                                                                  = ij6;
                                                                                              _ij6[1]
                                                                                                  = -1;
                                                                                              for (
                                                                                                  int iij6
                                                                                                  = ij6
                                                                                                    + 1;
                                                                                                  iij6
                                                                                                  < 2;
                                                                                                  ++iij6)
                                                                                              {
                                                                                                if (j6valid
                                                                                                        [iij6]
                                                                                                    && IKabs(
                                                                                                           cj6array
                                                                                                               [ij6]
                                                                                                           - cj6array
                                                                                                               [iij6])
                                                                                                           < IKFAST_SOLUTION_THRESH
                                                                                                    && IKabs(
                                                                                                           sj6array
                                                                                                               [ij6]
                                                                                                           - sj6array
                                                                                                               [iij6])
                                                                                                           < IKFAST_SOLUTION_THRESH)
                                                                                                {
                                                                                                  j6valid
                                                                                                      [iij6]
                                                                                                      = false;
                                                                                                  _ij6[1]
                                                                                                      = iij6;
                                                                                                  break;
                                                                                                }
                                                                                              }
                                                                                              j6 = j6array
                                                                                                  [ij6];
                                                                                              cj6 = cj6array
                                                                                                  [ij6];
                                                                                              sj6 = sj6array
                                                                                                  [ij6];
                                                                                              {
                                                                                                IkReal evalcond
                                                                                                    [1];
                                                                                                evalcond
                                                                                                    [0]
                                                                                                    = ((0.85)
                                                                                                       * (IKsin(
                                                                                                           j6)));
                                                                                                if (IKabs(
                                                                                                        evalcond
                                                                                                            [0])
                                                                                                    > IKFAST_EVALCOND_THRESH)
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                              }

                                                                                              rotationfunction0(
                                                                                                  solutions);
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  } while (
                                                                                      0);
                                                                                  if (bgotonextstatement)
                                                                                  {
                                                                                    bool
                                                                                        bgotonextstatement
                                                                                        = true;
                                                                                    do
                                                                                    {
                                                                                      evalcond
                                                                                          [0]
                                                                                          = ((IKabs((
                                                                                                 (-3.14159265358979)
                                                                                                 + (IKfmod(
                                                                                                     ((1.5707963267949)
                                                                                                      + j4),
                                                                                                     6.28318530717959)))))
                                                                                             + (IKabs(
                                                                                                 py)));
                                                                                      evalcond
                                                                                          [1]
                                                                                          = -0.85;
                                                                                      evalcond
                                                                                          [2]
                                                                                          = 0;
                                                                                      evalcond
                                                                                          [3]
                                                                                          = ((-0.2125)
                                                                                             + (((-1.0)
                                                                                                 * (1.0)
                                                                                                 * (px
                                                                                                    * px))));
                                                                                      if (IKabs(
                                                                                              evalcond
                                                                                                  [0])
                                                                                              < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [1])
                                                                                                 < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [2])
                                                                                                 < 0.0000010000000000
                                                                                          && IKabs(
                                                                                                 evalcond
                                                                                                     [3])
                                                                                                 < 0.0000010000000000)
                                                                                      {
                                                                                        bgotonextstatement
                                                                                            = false;
                                                                                        {
                                                                                          IkReal j6eval
                                                                                              [1];
                                                                                          IkReal
                                                                                              x790
                                                                                              = ((1.0)
                                                                                                 * px);
                                                                                          sj8 = 0;
                                                                                          cj8 = -1.0;
                                                                                          j8 = 3.14159265358979;
                                                                                          pz = 0;
                                                                                          j9 = 0;
                                                                                          sj9 = 0;
                                                                                          cj9 = 1.0;
                                                                                          pp = px
                                                                                               * px;
                                                                                          npx
                                                                                              = (px
                                                                                                 * r00);
                                                                                          npy
                                                                                              = (px
                                                                                                 * r01);
                                                                                          npz
                                                                                              = (px
                                                                                                 * r02);
                                                                                          rxp0_0
                                                                                              = 0;
                                                                                          rxp0_1
                                                                                              = (px
                                                                                                 * r20);
                                                                                          rxp1_0
                                                                                              = 0;
                                                                                          rxp1_1
                                                                                              = (px
                                                                                                 * r21);
                                                                                          rxp2_0
                                                                                              = 0;
                                                                                          rxp2_1
                                                                                              = (px
                                                                                                 * r22);
                                                                                          py = 0;
                                                                                          j4 = 1.5707963267949;
                                                                                          sj4 = 1.0;
                                                                                          cj4 = 0;
                                                                                          rxp0_2
                                                                                              = ((-1.0)
                                                                                                 * r10
                                                                                                 * x790);
                                                                                          rxp1_2
                                                                                              = ((-1.0)
                                                                                                 * r11
                                                                                                 * x790);
                                                                                          rxp2_2
                                                                                              = ((-1.0)
                                                                                                 * r12
                                                                                                 * x790);
                                                                                          j6eval
                                                                                              [0]
                                                                                              = ((1.0)
                                                                                                 + (((1.91568587540858)
                                                                                                     * (px
                                                                                                        * px
                                                                                                        * px
                                                                                                        * px)))
                                                                                                 + (((-1.0)
                                                                                                     * (2.64633970947792)
                                                                                                     * (px
                                                                                                        * px))));
                                                                                          if (IKabs(
                                                                                                  j6eval
                                                                                                      [0])
                                                                                              < 0.0000010000000000)
                                                                                          {
                                                                                            continue; // no branches [j6]
                                                                                          }
                                                                                          else
                                                                                          {
                                                                                            {
                                                                                              IkReal j6array
                                                                                                  [2],
                                                                                                  cj6array
                                                                                                      [2],
                                                                                                  sj6array
                                                                                                      [2];
                                                                                              bool j6valid
                                                                                                  [2]
                                                                                                  = {false};
                                                                                              _nj6
                                                                                                  = 2;
                                                                                              IkReal
                                                                                                  x791
                                                                                                  = px
                                                                                                    * px;
                                                                                              CheckValue<IkReal> x793 = IKatan2WithCheck(
                                                                                                  IkReal((
                                                                                                      (-0.425)
                                                                                                      + (((-0.588235294117647)
                                                                                                          * x791)))),
                                                                                                  ((2.83333333333333)
                                                                                                   + (((-3.92156862745098)
                                                                                                       * x791))),
                                                                                                  IKFAST_ATAN2_MAGTHRESH);
                                                                                              if (!x793.valid)
                                                                                              {
                                                                                                continue;
                                                                                              }
                                                                                              IkReal
                                                                                                  x792
                                                                                                  = ((-1.0)
                                                                                                     * (x793.value));
                                                                                              j6array
                                                                                                  [0]
                                                                                                  = x792;
                                                                                              sj6array
                                                                                                  [0]
                                                                                                  = IKsin(
                                                                                                      j6array
                                                                                                          [0]);
                                                                                              cj6array
                                                                                                  [0]
                                                                                                  = IKcos(
                                                                                                      j6array
                                                                                                          [0]);
                                                                                              j6array
                                                                                                  [1]
                                                                                                  = ((3.14159265358979)
                                                                                                     + x792);
                                                                                              sj6array
                                                                                                  [1]
                                                                                                  = IKsin(
                                                                                                      j6array
                                                                                                          [1]);
                                                                                              cj6array
                                                                                                  [1]
                                                                                                  = IKcos(
                                                                                                      j6array
                                                                                                          [1]);
                                                                                              if (j6array
                                                                                                      [0]
                                                                                                  > IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [0]
                                                                                                    -= IK2PI;
                                                                                              }
                                                                                              else if (
                                                                                                  j6array
                                                                                                      [0]
                                                                                                  < -IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [0]
                                                                                                    += IK2PI;
                                                                                              }
                                                                                              j6valid
                                                                                                  [0]
                                                                                                  = true;
                                                                                              if (j6array
                                                                                                      [1]
                                                                                                  > IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [1]
                                                                                                    -= IK2PI;
                                                                                              }
                                                                                              else if (
                                                                                                  j6array
                                                                                                      [1]
                                                                                                  < -IKPI)
                                                                                              {
                                                                                                j6array
                                                                                                    [1]
                                                                                                    += IK2PI;
                                                                                              }
                                                                                              j6valid
                                                                                                  [1]
                                                                                                  = true;
                                                                                              for (
                                                                                                  int ij6
                                                                                                  = 0;
                                                                                                  ij6
                                                                                                  < 2;
                                                                                                  ++ij6)
                                                                                              {
                                                                                                if (!j6valid
                                                                                                        [ij6])
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                _ij6[0]
                                                                                                    = ij6;
                                                                                                _ij6[1]
                                                                                                    = -1;
                                                                                                for (
                                                                                                    int iij6
                                                                                                    = ij6
                                                                                                      + 1;
                                                                                                    iij6
                                                                                                    < 2;
                                                                                                    ++iij6)
                                                                                                {
                                                                                                  if (j6valid
                                                                                                          [iij6]
                                                                                                      && IKabs(
                                                                                                             cj6array
                                                                                                                 [ij6]
                                                                                                             - cj6array
                                                                                                                 [iij6])
                                                                                                             < IKFAST_SOLUTION_THRESH
                                                                                                      && IKabs(
                                                                                                             sj6array
                                                                                                                 [ij6]
                                                                                                             - sj6array
                                                                                                                 [iij6])
                                                                                                             < IKFAST_SOLUTION_THRESH)
                                                                                                  {
                                                                                                    j6valid
                                                                                                        [iij6]
                                                                                                        = false;
                                                                                                    _ij6[1]
                                                                                                        = iij6;
                                                                                                    break;
                                                                                                  }
                                                                                                }
                                                                                                j6 = j6array
                                                                                                    [ij6];
                                                                                                cj6 = cj6array
                                                                                                    [ij6];
                                                                                                sj6 = sj6array
                                                                                                    [ij6];
                                                                                                {
                                                                                                  IkReal evalcond
                                                                                                      [1];
                                                                                                  evalcond
                                                                                                      [0]
                                                                                                      = ((0.85)
                                                                                                         * (IKsin(
                                                                                                             j6)));
                                                                                                  if (IKabs(
                                                                                                          evalcond
                                                                                                              [0])
                                                                                                      > IKFAST_EVALCOND_THRESH)
                                                                                                  {
                                                                                                    continue;
                                                                                                  }
                                                                                                }

                                                                                                rotationfunction0(
                                                                                                    solutions);
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    } while (
                                                                                        0);
                                                                                    if (bgotonextstatement)
                                                                                    {
                                                                                      bool
                                                                                          bgotonextstatement
                                                                                          = true;
                                                                                      do
                                                                                      {
                                                                                        evalcond
                                                                                            [0]
                                                                                            = ((IKabs(
                                                                                                   py))
                                                                                               + (IKabs((
                                                                                                   (-3.14159265358979)
                                                                                                   + (IKfmod(
                                                                                                       ((4.71238898038469)
                                                                                                        + j4),
                                                                                                       6.28318530717959))))));
                                                                                        evalcond
                                                                                            [1]
                                                                                            = -0.85;
                                                                                        evalcond
                                                                                            [2]
                                                                                            = 0;
                                                                                        evalcond
                                                                                            [3]
                                                                                            = ((-0.2125)
                                                                                               + (((-1.0)
                                                                                                   * (1.0)
                                                                                                   * (px
                                                                                                      * px))));
                                                                                        if (IKabs(
                                                                                                evalcond
                                                                                                    [0])
                                                                                                < 0.0000010000000000
                                                                                            && IKabs(
                                                                                                   evalcond
                                                                                                       [1])
                                                                                                   < 0.0000010000000000
                                                                                            && IKabs(
                                                                                                   evalcond
                                                                                                       [2])
                                                                                                   < 0.0000010000000000
                                                                                            && IKabs(
                                                                                                   evalcond
                                                                                                       [3])
                                                                                                   < 0.0000010000000000)
                                                                                        {
                                                                                          bgotonextstatement
                                                                                              = false;
                                                                                          {
                                                                                            IkReal j6eval
                                                                                                [1];
                                                                                            IkReal
                                                                                                x794
                                                                                                = ((1.0)
                                                                                                   * px);
                                                                                            sj8 = 0;
                                                                                            cj8 = -1.0;
                                                                                            j8 = 3.14159265358979;
                                                                                            pz = 0;
                                                                                            j9 = 0;
                                                                                            sj9 = 0;
                                                                                            cj9 = 1.0;
                                                                                            pp = px
                                                                                                 * px;
                                                                                            npx
                                                                                                = (px
                                                                                                   * r00);
                                                                                            npy
                                                                                                = (px
                                                                                                   * r01);
                                                                                            npz
                                                                                                = (px
                                                                                                   * r02);
                                                                                            rxp0_0
                                                                                                = 0;
                                                                                            rxp0_1
                                                                                                = (px
                                                                                                   * r20);
                                                                                            rxp1_0
                                                                                                = 0;
                                                                                            rxp1_1
                                                                                                = (px
                                                                                                   * r21);
                                                                                            rxp2_0
                                                                                                = 0;
                                                                                            rxp2_1
                                                                                                = (px
                                                                                                   * r22);
                                                                                            py = 0;
                                                                                            j4 = -1.5707963267949;
                                                                                            sj4 = -1.0;
                                                                                            cj4 = 0;
                                                                                            rxp0_2
                                                                                                = ((-1.0)
                                                                                                   * r10
                                                                                                   * x794);
                                                                                            rxp1_2
                                                                                                = ((-1.0)
                                                                                                   * r11
                                                                                                   * x794);
                                                                                            rxp2_2
                                                                                                = ((-1.0)
                                                                                                   * r12
                                                                                                   * x794);
                                                                                            j6eval
                                                                                                [0]
                                                                                                = ((1.0)
                                                                                                   + (((1.91568587540858)
                                                                                                       * (px
                                                                                                          * px
                                                                                                          * px
                                                                                                          * px)))
                                                                                                   + (((-1.0)
                                                                                                       * (2.64633970947792)
                                                                                                       * (px
                                                                                                          * px))));
                                                                                            if (IKabs(
                                                                                                    j6eval
                                                                                                        [0])
                                                                                                < 0.0000010000000000)
                                                                                            {
                                                                                              continue; // no branches [j6]
                                                                                            }
                                                                                            else
                                                                                            {
                                                                                              {
                                                                                                IkReal j6array
                                                                                                    [2],
                                                                                                    cj6array
                                                                                                        [2],
                                                                                                    sj6array
                                                                                                        [2];
                                                                                                bool j6valid
                                                                                                    [2]
                                                                                                    = {false};
                                                                                                _nj6
                                                                                                    = 2;
                                                                                                IkReal
                                                                                                    x795
                                                                                                    = px
                                                                                                      * px;
                                                                                                CheckValue<IkReal> x797 = IKatan2WithCheck(
                                                                                                    IkReal((
                                                                                                        (-0.425)
                                                                                                        + (((-0.588235294117647)
                                                                                                            * x795)))),
                                                                                                    ((2.83333333333333)
                                                                                                     + (((-3.92156862745098)
                                                                                                         * x795))),
                                                                                                    IKFAST_ATAN2_MAGTHRESH);
                                                                                                if (!x797.valid)
                                                                                                {
                                                                                                  continue;
                                                                                                }
                                                                                                IkReal
                                                                                                    x796
                                                                                                    = ((-1.0)
                                                                                                       * (x797.value));
                                                                                                j6array
                                                                                                    [0]
                                                                                                    = x796;
                                                                                                sj6array
                                                                                                    [0]
                                                                                                    = IKsin(
                                                                                                        j6array
                                                                                                            [0]);
                                                                                                cj6array
                                                                                                    [0]
                                                                                                    = IKcos(
                                                                                                        j6array
                                                                                                            [0]);
                                                                                                j6array
                                                                                                    [1]
                                                                                                    = ((3.14159265358979)
                                                                                                       + x796);
                                                                                                sj6array
                                                                                                    [1]
                                                                                                    = IKsin(
                                                                                                        j6array
                                                                                                            [1]);
                                                                                                cj6array
                                                                                                    [1]
                                                                                                    = IKcos(
                                                                                                        j6array
                                                                                                            [1]);
                                                                                                if (j6array
                                                                                                        [0]
                                                                                                    > IKPI)
                                                                                                {
                                                                                                  j6array
                                                                                                      [0]
                                                                                                      -= IK2PI;
                                                                                                }
                                                                                                else if (
                                                                                                    j6array
                                                                                                        [0]
                                                                                                    < -IKPI)
                                                                                                {
                                                                                                  j6array
                                                                                                      [0]
                                                                                                      += IK2PI;
                                                                                                }
                                                                                                j6valid
                                                                                                    [0]
                                                                                                    = true;
                                                                                                if (j6array
                                                                                                        [1]
                                                                                                    > IKPI)
                                                                                                {
                                                                                                  j6array
                                                                                                      [1]
                                                                                                      -= IK2PI;
                                                                                                }
                                                                                                else if (
                                                                                                    j6array
                                                                                                        [1]
                                                                                                    < -IKPI)
                                                                                                {
                                                                                                  j6array
                                                                                                      [1]
                                                                                                      += IK2PI;
                                                                                                }
                                                                                                j6valid
                                                                                                    [1]
                                                                                                    = true;
                                                                                                for (
                                                                                                    int ij6
                                                                                                    = 0;
                                                                                                    ij6
                                                                                                    < 2;
                                                                                                    ++ij6)
                                                                                                {
                                                                                                  if (!j6valid
                                                                                                          [ij6])
                                                                                                  {
                                                                                                    continue;
                                                                                                  }
                                                                                                  _ij6[0]
                                                                                                      = ij6;
                                                                                                  _ij6[1]
                                                                                                      = -1;
                                                                                                  for (
                                                                                                      int iij6
                                                                                                      = ij6
                                                                                                        + 1;
                                                                                                      iij6
                                                                                                      < 2;
                                                                                                      ++iij6)
                                                                                                  {
                                                                                                    if (j6valid
                                                                                                            [iij6]
                                                                                                        && IKabs(
                                                                                                               cj6array
                                                                                                                   [ij6]
                                                                                                               - cj6array
                                                                                                                   [iij6])
                                                                                                               < IKFAST_SOLUTION_THRESH
                                                                                                        && IKabs(
                                                                                                               sj6array
                                                                                                                   [ij6]
                                                                                                               - sj6array
                                                                                                                   [iij6])
                                                                                                               < IKFAST_SOLUTION_THRESH)
                                                                                                    {
                                                                                                      j6valid
                                                                                                          [iij6]
                                                                                                          = false;
                                                                                                      _ij6[1]
                                                                                                          = iij6;
                                                                                                      break;
                                                                                                    }
                                                                                                  }
                                                                                                  j6 = j6array
                                                                                                      [ij6];
                                                                                                  cj6 = cj6array
                                                                                                      [ij6];
                                                                                                  sj6 = sj6array
                                                                                                      [ij6];
                                                                                                  {
                                                                                                    IkReal evalcond
                                                                                                        [1];
                                                                                                    evalcond
                                                                                                        [0]
                                                                                                        = ((0.85)
                                                                                                           * (IKsin(
                                                                                                               j6)));
                                                                                                    if (IKabs(
                                                                                                            evalcond
                                                                                                                [0])
                                                                                                        > IKFAST_EVALCOND_THRESH)
                                                                                                    {
                                                                                                      continue;
                                                                                                    }
                                                                                                  }

                                                                                                  rotationfunction0(
                                                                                                      solutions);
                                                                                                }
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      } while (
                                                                                          0);
                                                                                      if (bgotonextstatement)
                                                                                      {
                                                                                        bool
                                                                                            bgotonextstatement
                                                                                            = true;
                                                                                        do
                                                                                        {
                                                                                          if (1)
                                                                                          {
                                                                                            bgotonextstatement
                                                                                                = false;
                                                                                            continue; // branch miss [j6]
                                                                                          }
                                                                                        } while (
                                                                                            0);
                                                                                        if (bgotonextstatement)
                                                                                        {
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                          else
                                                                          {
                                                                            {
                                                                              IkReal j6array
                                                                                  [1],
                                                                                  cj6array
                                                                                      [1],
                                                                                  sj6array
                                                                                      [1];
                                                                              bool j6valid
                                                                                  [1]
                                                                                  = {false};
                                                                              _nj6
                                                                                  = 1;
                                                                              IkReal
                                                                                  x798
                                                                                  = (cj4
                                                                                     * px);
                                                                              IkReal
                                                                                  x799
                                                                                  = (py
                                                                                     * sj4);
                                                                              IkReal
                                                                                  x800
                                                                                  = px
                                                                                    * px;
                                                                              IkReal
                                                                                  x801
                                                                                  = py
                                                                                    * py;
                                                                              CheckValue<IkReal> x802 = IKPowWithIntegerCheck(
                                                                                  ((((20.0)
                                                                                     * x799))
                                                                                   + (((20.0)
                                                                                       * x798))),
                                                                                  -1);
                                                                              if (!x802.valid)
                                                                              {
                                                                                continue;
                                                                              }
                                                                              CheckValue<IkReal> x803 = IKPowWithIntegerCheck(
                                                                                  ((((-8.5)
                                                                                     * x798))
                                                                                   + (((-1.0)
                                                                                       * (11.7647058823529)
                                                                                       * cj4
                                                                                       * (px
                                                                                          * px
                                                                                          * px)))
                                                                                   + (((-11.7647058823529)
                                                                                       * x798
                                                                                       * x801))
                                                                                   + (((-11.7647058823529)
                                                                                       * x799
                                                                                       * x800))
                                                                                   + (((-8.5)
                                                                                       * x799))
                                                                                   + (((-1.0)
                                                                                       * (11.7647058823529)
                                                                                       * sj4
                                                                                       * (py
                                                                                          * py
                                                                                          * py)))),
                                                                                  -1);
                                                                              if (!x803.valid)
                                                                              {
                                                                                continue;
                                                                              }
                                                                              if (IKabs((
                                                                                      (17.0)
                                                                                      * (x802.value)))
                                                                                      < IKFAST_ATAN2_MAGTHRESH
                                                                                  && IKabs((
                                                                                         (x803.value)
                                                                                         * (((-48.1666666666667)
                                                                                             + (((66.6666666666667)
                                                                                                 * x800))
                                                                                             + (((66.6666666666667)
                                                                                                 * x801))))))
                                                                                         < IKFAST_ATAN2_MAGTHRESH
                                                                                  && IKabs(
                                                                                         IKsqr((
                                                                                             (17.0)
                                                                                             * (x802.value)))
                                                                                         + IKsqr((
                                                                                             (x803.value)
                                                                                             * (((-48.1666666666667)
                                                                                                 + (((66.6666666666667)
                                                                                                     * x800))
                                                                                                 + (((66.6666666666667)
                                                                                                     * x801))))))
                                                                                         - 1)
                                                                                         <= IKFAST_SINCOS_THRESH)
                                                                                continue;
                                                                              j6array[0] = IKatan2(
                                                                                  ((17.0)
                                                                                   * (x802.value)),
                                                                                  ((x803.value)
                                                                                   * (((-48.1666666666667)
                                                                                       + (((66.6666666666667)
                                                                                           * x800))
                                                                                       + (((66.6666666666667)
                                                                                           * x801))))));
                                                                              sj6array
                                                                                  [0]
                                                                                  = IKsin(
                                                                                      j6array
                                                                                          [0]);
                                                                              cj6array
                                                                                  [0]
                                                                                  = IKcos(
                                                                                      j6array
                                                                                          [0]);
                                                                              if (j6array
                                                                                      [0]
                                                                                  > IKPI)
                                                                              {
                                                                                j6array
                                                                                    [0]
                                                                                    -= IK2PI;
                                                                              }
                                                                              else if (
                                                                                  j6array
                                                                                      [0]
                                                                                  < -IKPI)
                                                                              {
                                                                                j6array
                                                                                    [0]
                                                                                    += IK2PI;
                                                                              }
                                                                              j6valid
                                                                                  [0]
                                                                                  = true;
                                                                              for (
                                                                                  int ij6
                                                                                  = 0;
                                                                                  ij6
                                                                                  < 1;
                                                                                  ++ij6)
                                                                              {
                                                                                if (!j6valid
                                                                                        [ij6])
                                                                                {
                                                                                  continue;
                                                                                }
                                                                                _ij6[0]
                                                                                    = ij6;
                                                                                _ij6[1]
                                                                                    = -1;
                                                                                for (
                                                                                    int iij6
                                                                                    = ij6
                                                                                      + 1;
                                                                                    iij6
                                                                                    < 1;
                                                                                    ++iij6)
                                                                                {
                                                                                  if (j6valid
                                                                                          [iij6]
                                                                                      && IKabs(
                                                                                             cj6array
                                                                                                 [ij6]
                                                                                             - cj6array
                                                                                                 [iij6])
                                                                                             < IKFAST_SOLUTION_THRESH
                                                                                      && IKabs(
                                                                                             sj6array
                                                                                                 [ij6]
                                                                                             - sj6array
                                                                                                 [iij6])
                                                                                             < IKFAST_SOLUTION_THRESH)
                                                                                  {
                                                                                    j6valid
                                                                                        [iij6]
                                                                                        = false;
                                                                                    _ij6[1]
                                                                                        = iij6;
                                                                                    break;
                                                                                  }
                                                                                }
                                                                                j6 = j6array
                                                                                    [ij6];
                                                                                cj6 = cj6array
                                                                                    [ij6];
                                                                                sj6 = sj6array
                                                                                    [ij6];
                                                                                {
                                                                                  IkReal evalcond
                                                                                      [5];
                                                                                  IkReal
                                                                                      x804
                                                                                      = IKcos(
                                                                                          j6);
                                                                                  IkReal
                                                                                      x805
                                                                                      = (cj4
                                                                                         * px);
                                                                                  IkReal
                                                                                      x806
                                                                                      = (x804
                                                                                         * x805);
                                                                                  IkReal
                                                                                      x807
                                                                                      = (py
                                                                                         * sj4);
                                                                                  IkReal
                                                                                      x808
                                                                                      = (x804
                                                                                         * x807);
                                                                                  IkReal
                                                                                      x809
                                                                                      = IKsin(
                                                                                          j6);
                                                                                  IkReal
                                                                                      x810
                                                                                      = (x805
                                                                                         * x809);
                                                                                  IkReal
                                                                                      x811
                                                                                      = (x807
                                                                                         * x809);
                                                                                  IkReal
                                                                                      x812
                                                                                      = px
                                                                                        * px;
                                                                                  IkReal
                                                                                      x813
                                                                                      = ((3.92156862745098)
                                                                                         * x809);
                                                                                  IkReal
                                                                                      x814
                                                                                      = ((0.588235294117647)
                                                                                         * x804);
                                                                                  IkReal
                                                                                      x815
                                                                                      = py
                                                                                        * py;
                                                                                  evalcond
                                                                                      [0]
                                                                                      = (x806
                                                                                         + x808);
                                                                                  evalcond
                                                                                      [1]
                                                                                      = ((-0.85)
                                                                                         + x811
                                                                                         + x810);
                                                                                  evalcond
                                                                                      [2]
                                                                                      = ((((-1.0)
                                                                                           * x807))
                                                                                         + (((0.85)
                                                                                             * x809))
                                                                                         + (((-1.0)
                                                                                             * x805)));
                                                                                  evalcond
                                                                                      [3]
                                                                                      = ((((-1.0)
                                                                                           * x812
                                                                                           * x814))
                                                                                         + (((-1.0)
                                                                                             * x814
                                                                                             * x815))
                                                                                         + (((-1.0)
                                                                                             * x812
                                                                                             * x813))
                                                                                         + (((2.83333333333333)
                                                                                             * x809))
                                                                                         + (((-0.425)
                                                                                             * x804))
                                                                                         + (((-1.0)
                                                                                             * x813
                                                                                             * x815)));
                                                                                  evalcond
                                                                                      [4]
                                                                                      = ((-0.2125)
                                                                                         + (((1.1)
                                                                                             * x810))
                                                                                         + (((-0.09)
                                                                                             * x808))
                                                                                         + (((-1.0)
                                                                                             * x815))
                                                                                         + (((1.1)
                                                                                             * x811))
                                                                                         + (((-1.0)
                                                                                             * x812))
                                                                                         + (((-0.09)
                                                                                             * x806)));
                                                                                  if (IKabs(
                                                                                          evalcond
                                                                                              [0])
                                                                                          > IKFAST_EVALCOND_THRESH
                                                                                      || IKabs(
                                                                                             evalcond
                                                                                                 [1])
                                                                                             > IKFAST_EVALCOND_THRESH
                                                                                      || IKabs(
                                                                                             evalcond
                                                                                                 [2])
                                                                                             > IKFAST_EVALCOND_THRESH
                                                                                      || IKabs(
                                                                                             evalcond
                                                                                                 [3])
                                                                                             > IKFAST_EVALCOND_THRESH
                                                                                      || IKabs(
                                                                                             evalcond
                                                                                                 [4])
                                                                                             > IKFAST_EVALCOND_THRESH)
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                }

                                                                                rotationfunction0(
                                                                                    solutions);
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                      else
                                                                      {
                                                                        {
                                                                          IkReal j6array
                                                                              [1],
                                                                              cj6array
                                                                                  [1],
                                                                              sj6array
                                                                                  [1];
                                                                          bool j6valid
                                                                              [1]
                                                                              = {false};
                                                                          _nj6
                                                                              = 1;
                                                                          IkReal
                                                                              x816
                                                                              = (cj4
                                                                                 * px);
                                                                          IkReal
                                                                              x817
                                                                              = (py
                                                                                 * sj4);
                                                                          IkReal
                                                                              x818
                                                                              = px
                                                                                * px;
                                                                          IkReal
                                                                              x819
                                                                              = py
                                                                                * py;
                                                                          CheckValue<IkReal> x820 = IKPowWithIntegerCheck(
                                                                              ((-7.225)
                                                                               + (((-10.0)
                                                                                   * x818))
                                                                               + (((-10.0)
                                                                                   * x819))),
                                                                              -1);
                                                                          if (!x820.valid)
                                                                          {
                                                                            continue;
                                                                          }
                                                                          if (IKabs((
                                                                                  (((1.17647058823529)
                                                                                    * x816))
                                                                                  + (((1.17647058823529)
                                                                                      * x817))))
                                                                                  < IKFAST_ATAN2_MAGTHRESH
                                                                              && IKabs((
                                                                                     (x820.value)
                                                                                     * (((((78.4313725490196)
                                                                                           * x817
                                                                                           * x818))
                                                                                         + (((78.4313725490196)
                                                                                             * sj4
                                                                                             * (py
                                                                                                * py
                                                                                                * py)))
                                                                                         + (((78.4313725490196)
                                                                                             * cj4
                                                                                             * (px
                                                                                                * px
                                                                                                * px)))
                                                                                         + (((-56.6666666666667)
                                                                                             * x816))
                                                                                         + (((-56.6666666666667)
                                                                                             * x817))
                                                                                         + (((78.4313725490196)
                                                                                             * x816
                                                                                             * x819))))))
                                                                                     < IKFAST_ATAN2_MAGTHRESH
                                                                              && IKabs(
                                                                                     IKsqr((
                                                                                         (((1.17647058823529)
                                                                                           * x816))
                                                                                         + (((1.17647058823529)
                                                                                             * x817))))
                                                                                     + IKsqr((
                                                                                         (x820.value) * (((((78.4313725490196) * x817 * x818)) + (((78.4313725490196) * sj4 * (py * py * py))) + (((78.4313725490196) * cj4 * (px * px * px))) + (((-56.6666666666667) * x816)) + (((-56.6666666666667) * x817)) + (((78.4313725490196) * x816 * x819))))))
                                                                                     - 1)
                                                                                     <= IKFAST_SINCOS_THRESH)
                                                                            continue;
                                                                          j6array[0] = IKatan2(
                                                                              ((((1.17647058823529)
                                                                                 * x816))
                                                                               + (((1.17647058823529)
                                                                                   * x817))),
                                                                              ((x820.value)
                                                                               * (((((78.4313725490196)
                                                                                     * x817
                                                                                     * x818))
                                                                                   + (((78.4313725490196)
                                                                                       * sj4
                                                                                       * (py
                                                                                          * py
                                                                                          * py)))
                                                                                   + (((78.4313725490196)
                                                                                       * cj4
                                                                                       * (px
                                                                                          * px
                                                                                          * px)))
                                                                                   + (((-56.6666666666667)
                                                                                       * x816))
                                                                                   + (((-56.6666666666667)
                                                                                       * x817))
                                                                                   + (((78.4313725490196)
                                                                                       * x816
                                                                                       * x819))))));
                                                                          sj6array
                                                                              [0]
                                                                              = IKsin(
                                                                                  j6array
                                                                                      [0]);
                                                                          cj6array
                                                                              [0]
                                                                              = IKcos(
                                                                                  j6array
                                                                                      [0]);
                                                                          if (j6array
                                                                                  [0]
                                                                              > IKPI)
                                                                          {
                                                                            j6array
                                                                                [0]
                                                                                -= IK2PI;
                                                                          }
                                                                          else if (
                                                                              j6array
                                                                                  [0]
                                                                              < -IKPI)
                                                                          {
                                                                            j6array
                                                                                [0]
                                                                                += IK2PI;
                                                                          }
                                                                          j6valid
                                                                              [0]
                                                                              = true;
                                                                          for (
                                                                              int ij6
                                                                              = 0;
                                                                              ij6
                                                                              < 1;
                                                                              ++ij6)
                                                                          {
                                                                            if (!j6valid
                                                                                    [ij6])
                                                                            {
                                                                              continue;
                                                                            }
                                                                            _ij6[0]
                                                                                = ij6;
                                                                            _ij6[1]
                                                                                = -1;
                                                                            for (
                                                                                int iij6
                                                                                = ij6
                                                                                  + 1;
                                                                                iij6
                                                                                < 1;
                                                                                ++iij6)
                                                                            {
                                                                              if (j6valid
                                                                                      [iij6]
                                                                                  && IKabs(
                                                                                         cj6array
                                                                                             [ij6]
                                                                                         - cj6array
                                                                                             [iij6])
                                                                                         < IKFAST_SOLUTION_THRESH
                                                                                  && IKabs(
                                                                                         sj6array
                                                                                             [ij6]
                                                                                         - sj6array
                                                                                             [iij6])
                                                                                         < IKFAST_SOLUTION_THRESH)
                                                                              {
                                                                                j6valid
                                                                                    [iij6]
                                                                                    = false;
                                                                                _ij6[1]
                                                                                    = iij6;
                                                                                break;
                                                                              }
                                                                            }
                                                                            j6 = j6array
                                                                                [ij6];
                                                                            cj6 = cj6array
                                                                                [ij6];
                                                                            sj6 = sj6array
                                                                                [ij6];
                                                                            {
                                                                              IkReal evalcond
                                                                                  [5];
                                                                              IkReal
                                                                                  x821
                                                                                  = IKcos(
                                                                                      j6);
                                                                              IkReal
                                                                                  x822
                                                                                  = (cj4
                                                                                     * px);
                                                                              IkReal
                                                                                  x823
                                                                                  = (x821
                                                                                     * x822);
                                                                              IkReal
                                                                                  x824
                                                                                  = (py
                                                                                     * sj4);
                                                                              IkReal
                                                                                  x825
                                                                                  = (x821
                                                                                     * x824);
                                                                              IkReal
                                                                                  x826
                                                                                  = IKsin(
                                                                                      j6);
                                                                              IkReal
                                                                                  x827
                                                                                  = (x822
                                                                                     * x826);
                                                                              IkReal
                                                                                  x828
                                                                                  = (x824
                                                                                     * x826);
                                                                              IkReal
                                                                                  x829
                                                                                  = px
                                                                                    * px;
                                                                              IkReal
                                                                                  x830
                                                                                  = ((3.92156862745098)
                                                                                     * x826);
                                                                              IkReal
                                                                                  x831
                                                                                  = ((0.588235294117647)
                                                                                     * x821);
                                                                              IkReal
                                                                                  x832
                                                                                  = py
                                                                                    * py;
                                                                              evalcond
                                                                                  [0]
                                                                                  = (x825
                                                                                     + x823);
                                                                              evalcond
                                                                                  [1]
                                                                                  = ((-0.85)
                                                                                     + x827
                                                                                     + x828);
                                                                              evalcond
                                                                                  [2]
                                                                                  = ((((0.85)
                                                                                       * x826))
                                                                                     + (((-1.0)
                                                                                         * x822))
                                                                                     + (((-1.0)
                                                                                         * x824)));
                                                                              evalcond
                                                                                  [3]
                                                                                  = ((((-1.0)
                                                                                       * x830
                                                                                       * x832))
                                                                                     + (((2.83333333333333)
                                                                                         * x826))
                                                                                     + (((-1.0)
                                                                                         * x829
                                                                                         * x831))
                                                                                     + (((-1.0)
                                                                                         * x831
                                                                                         * x832))
                                                                                     + (((-1.0)
                                                                                         * x829
                                                                                         * x830))
                                                                                     + (((-0.425)
                                                                                         * x821)));
                                                                              evalcond
                                                                                  [4]
                                                                                  = ((-0.2125)
                                                                                     + (((1.1)
                                                                                         * x828))
                                                                                     + (((-0.09)
                                                                                         * x825))
                                                                                     + (((1.1)
                                                                                         * x827))
                                                                                     + (((-0.09)
                                                                                         * x823))
                                                                                     + (((-1.0)
                                                                                         * x832))
                                                                                     + (((-1.0)
                                                                                         * x829)));
                                                                              if (IKabs(
                                                                                      evalcond
                                                                                          [0])
                                                                                      > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [1])
                                                                                         > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [2])
                                                                                         > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [3])
                                                                                         > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [4])
                                                                                         > IKFAST_EVALCOND_THRESH)
                                                                              {
                                                                                continue;
                                                                              }
                                                                            }

                                                                            rotationfunction0(
                                                                                solutions);
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j6array
                                                                          [1],
                                                                          cj6array
                                                                              [1],
                                                                          sj6array
                                                                              [1];
                                                                      bool j6valid
                                                                          [1]
                                                                          = {false};
                                                                      _nj6 = 1;
                                                                      IkReal
                                                                          x833
                                                                          = (cj4
                                                                             * px);
                                                                      IkReal
                                                                          x834
                                                                          = (py
                                                                             * sj4);
                                                                      IkReal
                                                                          x835
                                                                          = px
                                                                            * px;
                                                                      IkReal
                                                                          x836
                                                                          = py
                                                                            * py;
                                                                      IkReal
                                                                          x837
                                                                          = ((1.29411764705882)
                                                                             * (cj4
                                                                                * cj4));
                                                                      CheckValue<
                                                                          IkReal>
                                                                          x838
                                                                          = IKPowWithIntegerCheck(
                                                                              ((((-0.09)
                                                                                 * x834))
                                                                               + (((-0.09)
                                                                                   * x833))),
                                                                              -1);
                                                                      if (!x838.valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      if (IKabs((
                                                                              (((1.17647058823529)
                                                                                * x833))
                                                                              + (((1.17647058823529)
                                                                                  * x834))))
                                                                              < IKFAST_ATAN2_MAGTHRESH
                                                                          && IKabs((
                                                                                 (x838.value)
                                                                                 * (((0.2125)
                                                                                     + (((-0.294117647058824)
                                                                                         * x836))
                                                                                     + x835
                                                                                     + (((-2.58823529411765)
                                                                                         * cj4
                                                                                         * px
                                                                                         * x834))
                                                                                     + ((x836
                                                                                         * x837))
                                                                                     + (((-1.0)
                                                                                         * x835
                                                                                         * x837))))))
                                                                                 < IKFAST_ATAN2_MAGTHRESH
                                                                          && IKabs(
                                                                                 IKsqr((
                                                                                     (((1.17647058823529)
                                                                                       * x833))
                                                                                     + (((1.17647058823529)
                                                                                         * x834))))
                                                                                 + IKsqr((
                                                                                     (x838.value)
                                                                                     * (((0.2125)
                                                                                         + (((-0.294117647058824)
                                                                                             * x836))
                                                                                         + x835
                                                                                         + (((-2.58823529411765)
                                                                                             * cj4
                                                                                             * px
                                                                                             * x834))
                                                                                         + ((x836
                                                                                             * x837))
                                                                                         + (((-1.0)
                                                                                             * x835
                                                                                             * x837))))))
                                                                                 - 1)
                                                                                 <= IKFAST_SINCOS_THRESH)
                                                                        continue;
                                                                      j6array[0] = IKatan2(
                                                                          ((((1.17647058823529)
                                                                             * x833))
                                                                           + (((1.17647058823529)
                                                                               * x834))),
                                                                          ((x838.value)
                                                                           * (((0.2125)
                                                                               + (((-0.294117647058824)
                                                                                   * x836))
                                                                               + x835
                                                                               + (((-2.58823529411765)
                                                                                   * cj4
                                                                                   * px
                                                                                   * x834))
                                                                               + ((x836
                                                                                   * x837))
                                                                               + (((-1.0)
                                                                                   * x835
                                                                                   * x837))))));
                                                                      sj6array[0] = IKsin(
                                                                          j6array
                                                                              [0]);
                                                                      cj6array[0] = IKcos(
                                                                          j6array
                                                                              [0]);
                                                                      if (j6array
                                                                              [0]
                                                                          > IKPI)
                                                                      {
                                                                        j6array
                                                                            [0]
                                                                            -= IK2PI;
                                                                      }
                                                                      else if (
                                                                          j6array
                                                                              [0]
                                                                          < -IKPI)
                                                                      {
                                                                        j6array
                                                                            [0]
                                                                            += IK2PI;
                                                                      }
                                                                      j6valid[0]
                                                                          = true;
                                                                      for (
                                                                          int ij6
                                                                          = 0;
                                                                          ij6
                                                                          < 1;
                                                                          ++ij6)
                                                                      {
                                                                        if (!j6valid
                                                                                [ij6])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij6[0]
                                                                            = ij6;
                                                                        _ij6[1]
                                                                            = -1;
                                                                        for (
                                                                            int iij6
                                                                            = ij6
                                                                              + 1;
                                                                            iij6
                                                                            < 1;
                                                                            ++iij6)
                                                                        {
                                                                          if (j6valid
                                                                                  [iij6]
                                                                              && IKabs(
                                                                                     cj6array
                                                                                         [ij6]
                                                                                     - cj6array
                                                                                         [iij6])
                                                                                     < IKFAST_SOLUTION_THRESH
                                                                              && IKabs(
                                                                                     sj6array
                                                                                         [ij6]
                                                                                     - sj6array
                                                                                         [iij6])
                                                                                     < IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j6valid
                                                                                [iij6]
                                                                                = false;
                                                                            _ij6[1]
                                                                                = iij6;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j6 = j6array
                                                                            [ij6];
                                                                        cj6 = cj6array
                                                                            [ij6];
                                                                        sj6 = sj6array
                                                                            [ij6];
                                                                        {
                                                                          IkReal evalcond
                                                                              [5];
                                                                          IkReal
                                                                              x839
                                                                              = IKcos(
                                                                                  j6);
                                                                          IkReal
                                                                              x840
                                                                              = (cj4
                                                                                 * px);
                                                                          IkReal
                                                                              x841
                                                                              = (x839
                                                                                 * x840);
                                                                          IkReal
                                                                              x842
                                                                              = (py
                                                                                 * sj4);
                                                                          IkReal
                                                                              x843
                                                                              = (x839
                                                                                 * x842);
                                                                          IkReal
                                                                              x844
                                                                              = IKsin(
                                                                                  j6);
                                                                          IkReal
                                                                              x845
                                                                              = (x840
                                                                                 * x844);
                                                                          IkReal
                                                                              x846
                                                                              = (x842
                                                                                 * x844);
                                                                          IkReal
                                                                              x847
                                                                              = px
                                                                                * px;
                                                                          IkReal
                                                                              x848
                                                                              = ((3.92156862745098)
                                                                                 * x844);
                                                                          IkReal
                                                                              x849
                                                                              = ((0.588235294117647)
                                                                                 * x839);
                                                                          IkReal
                                                                              x850
                                                                              = py
                                                                                * py;
                                                                          evalcond
                                                                              [0]
                                                                              = (x843
                                                                                 + x841);
                                                                          evalcond
                                                                              [1]
                                                                              = ((-0.85)
                                                                                 + x846
                                                                                 + x845);
                                                                          evalcond
                                                                              [2]
                                                                              = ((((0.85)
                                                                                   * x844))
                                                                                 + (((-1.0)
                                                                                     * x842))
                                                                                 + (((-1.0)
                                                                                     * x840)));
                                                                          evalcond
                                                                              [3]
                                                                              = ((((-1.0)
                                                                                   * x847
                                                                                   * x849))
                                                                                 + (((-1.0)
                                                                                     * x847
                                                                                     * x848))
                                                                                 + (((-0.425)
                                                                                     * x839))
                                                                                 + (((-1.0)
                                                                                     * x848
                                                                                     * x850))
                                                                                 + (((-1.0)
                                                                                     * x849
                                                                                     * x850))
                                                                                 + (((2.83333333333333)
                                                                                     * x844)));
                                                                          evalcond
                                                                              [4]
                                                                              = ((-0.2125)
                                                                                 + (((-1.0)
                                                                                     * x850))
                                                                                 + (((-0.09)
                                                                                     * x843))
                                                                                 + (((1.1)
                                                                                     * x846))
                                                                                 + (((1.1)
                                                                                     * x845))
                                                                                 + (((-1.0)
                                                                                     * x847))
                                                                                 + (((-0.09)
                                                                                     * x841)));
                                                                          if (IKabs(
                                                                                  evalcond
                                                                                      [0])
                                                                                  > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [1])
                                                                                     > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [2])
                                                                                     > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [3])
                                                                                     > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [4])
                                                                                     > IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        rotationfunction0(
                                                                            solutions);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            } while (0);
                                                            if (bgotonextstatement)
                                                            {
                                                              bool
                                                                  bgotonextstatement
                                                                  = true;
                                                              do
                                                              {
                                                                if (1)
                                                                {
                                                                  bgotonextstatement
                                                                      = false;
                                                                  continue; // branch miss [j6]
                                                                }
                                                              } while (0);
                                                              if (bgotonextstatement)
                                                              {
                                                              }
                                                            }
                                                          }
                                                        }
                                                        else
                                                        {
                                                          {
                                                            IkReal j6array[1],
                                                                cj6array[1],
                                                                sj6array[1];
                                                            bool j6valid[1]
                                                                = {false};
                                                            _nj6 = 1;
                                                            IkReal x851
                                                                = (cj4 * px);
                                                            IkReal x852
                                                                = (py * sj4);
                                                            IkReal x853
                                                                = ((0.108264705882353)
                                                                   * cj9);
                                                            IkReal x854
                                                                = ((0.588235294117647)
                                                                   * pp);
                                                            IkReal x855
                                                                = (cj9 * pp);
                                                            IkReal x856
                                                                = (cj9 * sj9);
                                                            IkReal x857
                                                                = (pp * sj9);
                                                            IkReal x858
                                                                = cj9 * cj9;
                                                            IkReal x859
                                                                = ((1.0) * pz);
                                                            CheckValue<IkReal> x860 = IKatan2WithCheck(
                                                                IkReal((
                                                                    (-0.174204411764706)
                                                                    + (pz * pz)
                                                                    + (((-0.176470588235294)
                                                                        * x855))
                                                                    + (((-1.0)
                                                                        * (0.154566176470588)
                                                                        * cj9))
                                                                    + (((-1.0)
                                                                        * (0.323529411764706)
                                                                        * pp))
                                                                    + (((-0.0264705882352941)
                                                                        * x857))
                                                                    + (((-0.00487191176470588)
                                                                        * x856))
                                                                    + (((-1.0)
                                                                        * (0.0142530882352941)
                                                                        * sj9))
                                                                    + (((-0.0324794117647059)
                                                                        * x858)))),
                                                                ((-0.830553921568627)
                                                                 + (((-0.396970588235294)
                                                                     * x858))
                                                                 + (((-1.0)
                                                                     * (0.0679544117647059)
                                                                     * sj9))
                                                                 + (((-1.0)
                                                                     * (1.18080882352941)
                                                                     * cj9))
                                                                 + (((0.176470588235294)
                                                                     * x857))
                                                                 + (((-1.0)
                                                                     * x852
                                                                     * x859))
                                                                 + (((2.15686274509804)
                                                                     * pp))
                                                                 + (((1.17647058823529)
                                                                     * x855))
                                                                 + (((-1.0)
                                                                     * x851
                                                                     * x859))
                                                                 + (((-0.0595455882352941)
                                                                     * x856))),
                                                                IKFAST_ATAN2_MAGTHRESH);
                                                            if (!x860.valid)
                                                            {
                                                              continue;
                                                            }
                                                            CheckValue<IkReal> x861 = IKPowWithIntegerCheck(
                                                                IKsign((
                                                                    (((-1.0)
                                                                      * x851
                                                                      * x854))
                                                                    + (((-1.0)
                                                                        * (1.32323529411765)
                                                                        * cj9
                                                                        * pz))
                                                                    + (((3.92156862745098)
                                                                        * pp
                                                                        * pz))
                                                                    + (((-1.0)
                                                                        * (1.51009803921569)
                                                                        * pz))
                                                                    + (((-0.316735294117647)
                                                                        * x852))
                                                                    + (((-1.0)
                                                                        * x852
                                                                        * x853))
                                                                    + (((-0.316735294117647)
                                                                        * x851))
                                                                    + (((-1.0)
                                                                        * x851
                                                                        * x853))
                                                                    + (((-1.0)
                                                                        * x852
                                                                        * x854)))),
                                                                -1);
                                                            if (!x861.valid)
                                                            {
                                                              continue;
                                                            }
                                                            j6array[0]
                                                                = ((-1.5707963267949)
                                                                   + (x860.value)
                                                                   + (((1.5707963267949)
                                                                       * (x861.value))));
                                                            sj6array[0] = IKsin(
                                                                j6array[0]);
                                                            cj6array[0] = IKcos(
                                                                j6array[0]);
                                                            if (j6array[0]
                                                                > IKPI)
                                                            {
                                                              j6array[0]
                                                                  -= IK2PI;
                                                            }
                                                            else if (
                                                                j6array[0]
                                                                < -IKPI)
                                                            {
                                                              j6array[0]
                                                                  += IK2PI;
                                                            }
                                                            j6valid[0] = true;
                                                            for (int ij6 = 0;
                                                                 ij6 < 1;
                                                                 ++ij6)
                                                            {
                                                              if (!j6valid[ij6])
                                                              {
                                                                continue;
                                                              }
                                                              _ij6[0] = ij6;
                                                              _ij6[1] = -1;
                                                              for (int iij6
                                                                   = ij6 + 1;
                                                                   iij6 < 1;
                                                                   ++iij6)
                                                              {
                                                                if (j6valid
                                                                        [iij6]
                                                                    && IKabs(
                                                                           cj6array
                                                                               [ij6]
                                                                           - cj6array
                                                                               [iij6])
                                                                           < IKFAST_SOLUTION_THRESH
                                                                    && IKabs(
                                                                           sj6array
                                                                               [ij6]
                                                                           - sj6array
                                                                               [iij6])
                                                                           < IKFAST_SOLUTION_THRESH)
                                                                {
                                                                  j6valid[iij6]
                                                                      = false;
                                                                  _ij6[1]
                                                                      = iij6;
                                                                  break;
                                                                }
                                                              }
                                                              j6 = j6array[ij6];
                                                              cj6 = cj6array
                                                                  [ij6];
                                                              sj6 = sj6array
                                                                  [ij6];
                                                              {
                                                                IkReal
                                                                    evalcond[5];
                                                                IkReal x862
                                                                    = ((0.3)
                                                                       * cj9);
                                                                IkReal x863
                                                                    = ((0.045)
                                                                       * sj9);
                                                                IkReal x864
                                                                    = IKcos(j6);
                                                                IkReal x865
                                                                    = (pz
                                                                       * x864);
                                                                IkReal x866
                                                                    = IKsin(j6);
                                                                IkReal x867
                                                                    = (cj4
                                                                       * px);
                                                                IkReal x868
                                                                    = (x866
                                                                       * x867);
                                                                IkReal x869
                                                                    = (py
                                                                       * sj4);
                                                                IkReal x870
                                                                    = (x866
                                                                       * x869);
                                                                IkReal x871
                                                                    = ((0.045)
                                                                       * cj9);
                                                                IkReal x872
                                                                    = ((0.3)
                                                                       * sj9);
                                                                IkReal x873
                                                                    = (pz
                                                                       * x866);
                                                                IkReal x874
                                                                    = (x864
                                                                       * x867);
                                                                IkReal x875
                                                                    = (x864
                                                                       * x869);
                                                                evalcond[0]
                                                                    = ((-0.55)
                                                                       + (((-1.0)
                                                                           * x862))
                                                                       + x868
                                                                       + x865
                                                                       + x870
                                                                       + (((-1.0)
                                                                           * x863)));
                                                                evalcond[1]
                                                                    = ((0.045)
                                                                       + (((-1.0)
                                                                           * x873))
                                                                       + x872
                                                                       + x874
                                                                       + x875
                                                                       + (((-1.0)
                                                                           * x871)));
                                                                evalcond[2]
                                                                    = ((((1.51009803921569)
                                                                         * x866))
                                                                       + (((-0.316735294117647)
                                                                           * x864))
                                                                       + pz
                                                                       + (((-3.92156862745098)
                                                                           * pp
                                                                           * x866))
                                                                       + (((-0.108264705882353)
                                                                           * cj9
                                                                           * x864))
                                                                       + (((-0.588235294117647)
                                                                           * pp
                                                                           * x864))
                                                                       + (((1.32323529411765)
                                                                           * cj9
                                                                           * x866)));
                                                                evalcond[3]
                                                                    = ((((0.55)
                                                                         * x866))
                                                                       + (((-1.0)
                                                                           * x869))
                                                                       + (((-0.045)
                                                                           * x864))
                                                                       + (((-1.0)
                                                                           * x867))
                                                                       + (((-1.0)
                                                                           * x864
                                                                           * x872))
                                                                       + ((x862
                                                                           * x866))
                                                                       + ((x864
                                                                           * x871))
                                                                       + ((x863
                                                                           * x866)));
                                                                evalcond[4]
                                                                    = ((-0.2125)
                                                                       + (((-0.09)
                                                                           * x875))
                                                                       + (((1.1)
                                                                           * x865))
                                                                       + (((0.09)
                                                                           * x873))
                                                                       + (((-0.09)
                                                                           * x874))
                                                                       + (((1.1)
                                                                           * x870))
                                                                       + (((1.1)
                                                                           * x868))
                                                                       + (((-1.0)
                                                                           * (1.0)
                                                                           * pp)));
                                                                if (IKabs(
                                                                        evalcond
                                                                            [0])
                                                                        > IKFAST_EVALCOND_THRESH
                                                                    || IKabs(
                                                                           evalcond
                                                                               [1])
                                                                           > IKFAST_EVALCOND_THRESH
                                                                    || IKabs(
                                                                           evalcond
                                                                               [2])
                                                                           > IKFAST_EVALCOND_THRESH
                                                                    || IKabs(
                                                                           evalcond
                                                                               [3])
                                                                           > IKFAST_EVALCOND_THRESH
                                                                    || IKabs(
                                                                           evalcond
                                                                               [4])
                                                                           > IKFAST_EVALCOND_THRESH)
                                                                {
                                                                  continue;
                                                                }
                                                              }

                                                              rotationfunction0(
                                                                  solutions);
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                    else
                                                    {
                                                      {
                                                        IkReal j6array[1],
                                                            cj6array[1],
                                                            sj6array[1];
                                                        bool j6valid[1]
                                                            = {false};
                                                        _nj6 = 1;
                                                        IkReal x876
                                                            = ((0.045) * cj4
                                                               * px);
                                                        IkReal x877
                                                            = ((0.045) * py
                                                               * sj4);
                                                        IkReal x878
                                                            = ((0.3) * sj9);
                                                        IkReal x879
                                                            = (cj4 * px);
                                                        IkReal x880
                                                            = (py * sj4);
                                                        IkReal x881
                                                            = (cj9 * sj9);
                                                        IkReal x882 = cj9 * cj9;
                                                        IkReal x883
                                                            = ((1.0) * pz);
                                                        IkReal x884 = py * py;
                                                        IkReal x885 = cj4 * cj4;
                                                        CheckValue<IkReal> x886
                                                            = IKatan2WithCheck(
                                                                IkReal((
                                                                    (-0.03825)
                                                                    + (((0.027)
                                                                        * x882))
                                                                    + (((-0.087975)
                                                                        * x881))
                                                                    + (((-1.0)
                                                                        * (0.167025)
                                                                        * sj9))
                                                                    + (((-1.0)
                                                                        * x879
                                                                        * x883))
                                                                    + (((-1.0)
                                                                        * x880
                                                                        * x883))
                                                                    + (((0.01125)
                                                                        * cj9)))),
                                                                ((-0.304525)
                                                                 + (((-1.0)
                                                                     * x884
                                                                     * x885))
                                                                 + (((2.0) * cj4
                                                                     * px
                                                                     * x880))
                                                                 + (((-1.0)
                                                                     * (0.0495)
                                                                     * sj9))
                                                                 + (((-0.087975)
                                                                     * x882))
                                                                 + ((x885
                                                                     * (px
                                                                        * px)))
                                                                 + x884
                                                                 + (((-1.0)
                                                                     * (0.33)
                                                                     * cj9))
                                                                 + (((-0.027)
                                                                     * x881))),
                                                                IKFAST_ATAN2_MAGTHRESH);
                                                        if (!x886.valid)
                                                        {
                                                          continue;
                                                        }
                                                        CheckValue<IkReal> x887
                                                            = IKPowWithIntegerCheck(
                                                                IKsign((
                                                                    (((-1.0)
                                                                      * x878
                                                                      * x879))
                                                                    + (((-1.0)
                                                                        * (0.55)
                                                                        * pz))
                                                                    + (((-1.0)
                                                                        * x877))
                                                                    + (((-1.0)
                                                                        * x876))
                                                                    + (((-1.0)
                                                                        * x878
                                                                        * x880))
                                                                    + ((cj9
                                                                        * x877))
                                                                    + ((cj9
                                                                        * x876))
                                                                    + (((-1.0)
                                                                        * (0.045)
                                                                        * pz
                                                                        * sj9))
                                                                    + (((-1.0)
                                                                        * (0.3)
                                                                        * cj9
                                                                        * pz)))),
                                                                -1);
                                                        if (!x887.valid)
                                                        {
                                                          continue;
                                                        }
                                                        j6array[0]
                                                            = ((-1.5707963267949)
                                                               + (x886.value)
                                                               + (((1.5707963267949)
                                                                   * (x887.value))));
                                                        sj6array[0]
                                                            = IKsin(j6array[0]);
                                                        cj6array[0]
                                                            = IKcos(j6array[0]);
                                                        if (j6array[0] > IKPI)
                                                        {
                                                          j6array[0] -= IK2PI;
                                                        }
                                                        else if (
                                                            j6array[0] < -IKPI)
                                                        {
                                                          j6array[0] += IK2PI;
                                                        }
                                                        j6valid[0] = true;
                                                        for (int ij6 = 0;
                                                             ij6 < 1;
                                                             ++ij6)
                                                        {
                                                          if (!j6valid[ij6])
                                                          {
                                                            continue;
                                                          }
                                                          _ij6[0] = ij6;
                                                          _ij6[1] = -1;
                                                          for (int iij6
                                                               = ij6 + 1;
                                                               iij6 < 1;
                                                               ++iij6)
                                                          {
                                                            if (j6valid[iij6]
                                                                && IKabs(
                                                                       cj6array
                                                                           [ij6]
                                                                       - cj6array
                                                                           [iij6])
                                                                       < IKFAST_SOLUTION_THRESH
                                                                && IKabs(
                                                                       sj6array
                                                                           [ij6]
                                                                       - sj6array
                                                                           [iij6])
                                                                       < IKFAST_SOLUTION_THRESH)
                                                            {
                                                              j6valid[iij6]
                                                                  = false;
                                                              _ij6[1] = iij6;
                                                              break;
                                                            }
                                                          }
                                                          j6 = j6array[ij6];
                                                          cj6 = cj6array[ij6];
                                                          sj6 = sj6array[ij6];
                                                          {
                                                            IkReal evalcond[5];
                                                            IkReal x888
                                                                = ((0.3) * cj9);
                                                            IkReal x889
                                                                = ((0.045)
                                                                   * sj9);
                                                            IkReal x890
                                                                = IKcos(j6);
                                                            IkReal x891
                                                                = (pz * x890);
                                                            IkReal x892
                                                                = IKsin(j6);
                                                            IkReal x893
                                                                = (cj4 * px);
                                                            IkReal x894
                                                                = (x892 * x893);
                                                            IkReal x895
                                                                = (py * sj4);
                                                            IkReal x896
                                                                = (x892 * x895);
                                                            IkReal x897
                                                                = ((0.045)
                                                                   * cj9);
                                                            IkReal x898
                                                                = ((0.3) * sj9);
                                                            IkReal x899
                                                                = (pz * x892);
                                                            IkReal x900
                                                                = (x890 * x893);
                                                            IkReal x901
                                                                = (x890 * x895);
                                                            evalcond[0]
                                                                = ((-0.55)
                                                                   + (((-1.0)
                                                                       * x888))
                                                                   + x894 + x896
                                                                   + x891
                                                                   + (((-1.0)
                                                                       * x889)));
                                                            evalcond[1]
                                                                = ((0.045)
                                                                   + (((-1.0)
                                                                       * x897))
                                                                   + x900 + x901
                                                                   + x898
                                                                   + (((-1.0)
                                                                       * x899)));
                                                            evalcond[2]
                                                                = ((((-0.588235294117647)
                                                                     * pp
                                                                     * x890))
                                                                   + (((-0.316735294117647)
                                                                       * x890))
                                                                   + (((1.32323529411765)
                                                                       * cj9
                                                                       * x892))
                                                                   + pz
                                                                   + (((-0.108264705882353)
                                                                       * cj9
                                                                       * x890))
                                                                   + (((-3.92156862745098)
                                                                       * pp
                                                                       * x892))
                                                                   + (((1.51009803921569)
                                                                       * x892)));
                                                            evalcond[3]
                                                                = ((((-1.0)
                                                                     * x893))
                                                                   + ((x890
                                                                       * x897))
                                                                   + (((0.55)
                                                                       * x892))
                                                                   + ((x888
                                                                       * x892))
                                                                   + (((-1.0)
                                                                       * x890
                                                                       * x898))
                                                                   + ((x889
                                                                       * x892))
                                                                   + (((-1.0)
                                                                       * x895))
                                                                   + (((-0.045)
                                                                       * x890)));
                                                            evalcond[4]
                                                                = ((-0.2125)
                                                                   + (((-0.09)
                                                                       * x900))
                                                                   + (((1.1)
                                                                       * x891))
                                                                   + (((0.09)
                                                                       * x899))
                                                                   + (((-0.09)
                                                                       * x901))
                                                                   + (((1.1)
                                                                       * x896))
                                                                   + (((-1.0)
                                                                       * (1.0)
                                                                       * pp))
                                                                   + (((1.1)
                                                                       * x894)));
                                                            if (IKabs(
                                                                    evalcond[0])
                                                                    > IKFAST_EVALCOND_THRESH
                                                                || IKabs(
                                                                       evalcond
                                                                           [1])
                                                                       > IKFAST_EVALCOND_THRESH
                                                                || IKabs(
                                                                       evalcond
                                                                           [2])
                                                                       > IKFAST_EVALCOND_THRESH
                                                                || IKabs(
                                                                       evalcond
                                                                           [3])
                                                                       > IKFAST_EVALCOND_THRESH
                                                                || IKabs(
                                                                       evalcond
                                                                           [4])
                                                                       > IKFAST_EVALCOND_THRESH)
                                                            {
                                                              continue;
                                                            }
                                                          }

                                                          rotationfunction0(
                                                              solutions);
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                                else
                                                {
                                                  {
                                                    IkReal j6array[1],
                                                        cj6array[1],
                                                        sj6array[1];
                                                    bool j6valid[1] = {false};
                                                    _nj6 = 1;
                                                    IkReal x902 = py * py;
                                                    IkReal x903 = (py * sj4);
                                                    IkReal x904 = cj4 * cj4;
                                                    IkReal x905
                                                        = ((0.045) * pz);
                                                    IkReal x906 = (cj4 * px);
                                                    IkReal x907 = ((0.3) * pz);
                                                    IkReal x908
                                                        = ((0.3) * cj4 * px);
                                                    IkReal x909
                                                        = ((0.045) * x906);
                                                    IkReal x910
                                                        = ((0.3) * py * sj4);
                                                    IkReal x911
                                                        = ((0.045) * x903);
                                                    CheckValue<IkReal> x912
                                                        = IKatan2WithCheck(
                                                            IkReal((
                                                                ((sj9 * x911))
                                                                + ((sj9 * x909))
                                                                + ((cj9 * x910))
                                                                + ((sj9 * x907))
                                                                + x905
                                                                + (((0.55)
                                                                    * x906))
                                                                + (((0.55)
                                                                    * x903))
                                                                + ((cj9 * x908))
                                                                + (((-1.0) * cj9
                                                                    * x905)))),
                                                            ((((-1.0) * x911))
                                                             + ((cj9 * x907))
                                                             + ((cj9 * x911))
                                                             + ((cj9 * x909))
                                                             + (((-1.0) * sj9
                                                                 * x910))
                                                             + (((0.55) * pz))
                                                             + (((-1.0) * sj9
                                                                 * x908))
                                                             + (((-1.0) * x909))
                                                             + ((sj9 * x905))),
                                                            IKFAST_ATAN2_MAGTHRESH);
                                                    if (!x912.valid)
                                                    {
                                                      continue;
                                                    }
                                                    CheckValue<IkReal> x913
                                                        = IKPowWithIntegerCheck(
                                                            IKsign(
                                                                ((((2.0) * cj4
                                                                   * px * x903))
                                                                 + (pz * pz)
                                                                 + x902
                                                                 + ((x904
                                                                     * (px
                                                                        * px)))
                                                                 + (((-1.0)
                                                                     * x902
                                                                     * x904)))),
                                                            -1);
                                                    if (!x913.valid)
                                                    {
                                                      continue;
                                                    }
                                                    j6array[0]
                                                        = ((-1.5707963267949)
                                                           + (x912.value)
                                                           + (((1.5707963267949)
                                                               * (x913.value))));
                                                    sj6array[0]
                                                        = IKsin(j6array[0]);
                                                    cj6array[0]
                                                        = IKcos(j6array[0]);
                                                    if (j6array[0] > IKPI)
                                                    {
                                                      j6array[0] -= IK2PI;
                                                    }
                                                    else if (j6array[0] < -IKPI)
                                                    {
                                                      j6array[0] += IK2PI;
                                                    }
                                                    j6valid[0] = true;
                                                    for (int ij6 = 0; ij6 < 1;
                                                         ++ij6)
                                                    {
                                                      if (!j6valid[ij6])
                                                      {
                                                        continue;
                                                      }
                                                      _ij6[0] = ij6;
                                                      _ij6[1] = -1;
                                                      for (int iij6 = ij6 + 1;
                                                           iij6 < 1;
                                                           ++iij6)
                                                      {
                                                        if (j6valid[iij6]
                                                            && IKabs(
                                                                   cj6array[ij6]
                                                                   - cj6array
                                                                       [iij6])
                                                                   < IKFAST_SOLUTION_THRESH
                                                            && IKabs(
                                                                   sj6array[ij6]
                                                                   - sj6array
                                                                       [iij6])
                                                                   < IKFAST_SOLUTION_THRESH)
                                                        {
                                                          j6valid[iij6] = false;
                                                          _ij6[1] = iij6;
                                                          break;
                                                        }
                                                      }
                                                      j6 = j6array[ij6];
                                                      cj6 = cj6array[ij6];
                                                      sj6 = sj6array[ij6];
                                                      {
                                                        IkReal evalcond[5];
                                                        IkReal x914
                                                            = ((0.3) * cj9);
                                                        IkReal x915
                                                            = ((0.045) * sj9);
                                                        IkReal x916 = IKcos(j6);
                                                        IkReal x917
                                                            = (pz * x916);
                                                        IkReal x918 = IKsin(j6);
                                                        IkReal x919
                                                            = (cj4 * px);
                                                        IkReal x920
                                                            = (x918 * x919);
                                                        IkReal x921
                                                            = (py * sj4);
                                                        IkReal x922
                                                            = (x918 * x921);
                                                        IkReal x923
                                                            = ((0.045) * cj9);
                                                        IkReal x924
                                                            = ((0.3) * sj9);
                                                        IkReal x925
                                                            = (pz * x918);
                                                        IkReal x926
                                                            = (x916 * x919);
                                                        IkReal x927
                                                            = (x916 * x921);
                                                        evalcond[0]
                                                            = ((-0.55)
                                                               + (((-1.0)
                                                                   * x914))
                                                               + x917
                                                               + (((-1.0)
                                                                   * x915))
                                                               + x922 + x920);
                                                        evalcond[1]
                                                            = ((0.045)
                                                               + (((-1.0)
                                                                   * x925))
                                                               + (((-1.0)
                                                                   * x923))
                                                               + x927 + x924
                                                               + x926);
                                                        evalcond[2]
                                                            = ((((-0.316735294117647)
                                                                 * x916))
                                                               + (((-3.92156862745098)
                                                                   * pp * x918))
                                                               + (((-0.588235294117647)
                                                                   * pp * x916))
                                                               + pz
                                                               + (((-0.108264705882353)
                                                                   * cj9
                                                                   * x916))
                                                               + (((1.32323529411765)
                                                                   * cj9
                                                                   * x918))
                                                               + (((1.51009803921569)
                                                                   * x918)));
                                                        evalcond[3]
                                                            = ((((0.55) * x918))
                                                               + (((-0.045)
                                                                   * x916))
                                                               + ((x914 * x918))
                                                               + ((x915 * x918))
                                                               + (((-1.0)
                                                                   * x921))
                                                               + ((x916 * x923))
                                                               + (((-1.0)
                                                                   * x919))
                                                               + (((-1.0) * x916
                                                                   * x924)));
                                                        evalcond[4]
                                                            = ((-0.2125)
                                                               + (((-0.09)
                                                                   * x927))
                                                               + (((1.1)
                                                                   * x920))
                                                               + (((0.09)
                                                                   * x925))
                                                               + (((-0.09)
                                                                   * x926))
                                                               + (((1.1)
                                                                   * x917))
                                                               + (((1.1)
                                                                   * x922))
                                                               + (((-1.0)
                                                                   * (1.0)
                                                                   * pp)));
                                                        if (IKabs(evalcond[0])
                                                                > IKFAST_EVALCOND_THRESH
                                                            || IKabs(
                                                                   evalcond[1])
                                                                   > IKFAST_EVALCOND_THRESH
                                                            || IKabs(
                                                                   evalcond[2])
                                                                   > IKFAST_EVALCOND_THRESH
                                                            || IKabs(
                                                                   evalcond[3])
                                                                   > IKFAST_EVALCOND_THRESH
                                                            || IKabs(
                                                                   evalcond[4])
                                                                   > IKFAST_EVALCOND_THRESH)
                                                        {
                                                          continue;
                                                        }
                                                      }

                                                      rotationfunction0(
                                                          solutions);
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          } while (0);
                                          if (bgotonextstatement)
                                          {
                                            bool bgotonextstatement = true;
                                            do
                                            {
                                              if (1)
                                              {
                                                bgotonextstatement = false;
                                                continue; // branch miss [j6]
                                              }
                                            } while (0);
                                            if (bgotonextstatement)
                                            {
                                            }
                                          }
                                        }
                                      }
                                    }
                                    else
                                    {
                                      {
                                        IkReal j6array[1], cj6array[1],
                                            sj6array[1];
                                        bool j6valid[1] = {false};
                                        _nj6 = 1;
                                        IkReal x928 = (pz * sj8);
                                        IkReal x929 = ((0.3) * cj9);
                                        IkReal x930 = ((0.045) * sj9);
                                        IkReal x931 = (cj4 * px);
                                        IkReal x932 = ((0.045) * cj8 * sj8);
                                        IkReal x933 = (x931 * x932);
                                        IkReal x934 = (py * sj4);
                                        IkReal x935 = (x932 * x934);
                                        IkReal x936 = ((0.3) * cj8 * sj8 * sj9);
                                        IkReal x937 = ((0.55) * cj8);
                                        IkReal x938 = (cj4 * py);
                                        IkReal x939 = (px * sj4);
                                        IkReal x940 = (cj4 * cj8 * py);
                                        IkReal x941 = ((1.0) * pz * sj8);
                                        IkReal x942 = (cj8 * px * sj4);
                                        IkReal x943 = cj8 * cj8;
                                        IkReal x944 = ((0.045) * x943);
                                        IkReal x945 = (x938 * x944);
                                        IkReal x946 = (x939 * x944);
                                        IkReal x947 = ((0.3) * sj9 * x943);
                                        CheckValue<IkReal> x948
                                            = IKPowWithIntegerCheck(
                                                IKsign(
                                                    ((((-0.55) * x928))
                                                     + (((-1.0) * cj9 * x933))
                                                     + (((-1.0) * cj9 * x935))
                                                     + (((-1.0) * x928 * x929))
                                                     + ((x931 * x936))
                                                     + (((-1.0) * x928 * x930))
                                                     + x933 + x935
                                                     + ((x934 * x936)))),
                                                -1);
                                        if (!x948.valid)
                                        {
                                          continue;
                                        }
                                        CheckValue<IkReal> x949
                                            = IKatan2WithCheck(
                                                IkReal(
                                                    ((((-1.0) * x937 * x939))
                                                     + ((x937 * x938))
                                                     + ((x930 * x940))
                                                     + (((-1.0) * x930 * x942))
                                                     + (((-1.0) * x931 * x941))
                                                     + (((-1.0) * x934 * x941))
                                                     + (((-1.0) * x929 * x942))
                                                     + ((x929 * x940)))),
                                                (((cj9 * x946))
                                                 + (((-1.0) * (1.0) * sj8
                                                     * (pz * pz)))
                                                 + ((x938 * x947))
                                                 + (((-1.0) * x939 * x947))
                                                 + (((-1.0) * cj9 * x945))
                                                 + (((-1.0) * x946)) + x945),
                                                IKFAST_ATAN2_MAGTHRESH);
                                        if (!x949.valid)
                                        {
                                          continue;
                                        }
                                        j6array[0]
                                            = ((-1.5707963267949)
                                               + (((1.5707963267949)
                                                   * (x948.value)))
                                               + (x949.value));
                                        sj6array[0] = IKsin(j6array[0]);
                                        cj6array[0] = IKcos(j6array[0]);
                                        if (j6array[0] > IKPI)
                                        {
                                          j6array[0] -= IK2PI;
                                        }
                                        else if (j6array[0] < -IKPI)
                                        {
                                          j6array[0] += IK2PI;
                                        }
                                        j6valid[0] = true;
                                        for (int ij6 = 0; ij6 < 1; ++ij6)
                                        {
                                          if (!j6valid[ij6])
                                          {
                                            continue;
                                          }
                                          _ij6[0] = ij6;
                                          _ij6[1] = -1;
                                          for (int iij6 = ij6 + 1; iij6 < 1;
                                               ++iij6)
                                          {
                                            if (j6valid[iij6]
                                                && IKabs(
                                                       cj6array[ij6]
                                                       - cj6array[iij6])
                                                       < IKFAST_SOLUTION_THRESH
                                                && IKabs(
                                                       sj6array[ij6]
                                                       - sj6array[iij6])
                                                       < IKFAST_SOLUTION_THRESH)
                                            {
                                              j6valid[iij6] = false;
                                              _ij6[1] = iij6;
                                              break;
                                            }
                                          }
                                          j6 = j6array[ij6];
                                          cj6 = cj6array[ij6];
                                          sj6 = sj6array[ij6];
                                          {
                                            IkReal evalcond[6];
                                            IkReal x950 = ((0.3) * cj9);
                                            IkReal x951 = ((0.045) * sj9);
                                            IkReal x952 = IKcos(j6);
                                            IkReal x953 = (pz * x952);
                                            IkReal x954 = IKsin(j6);
                                            IkReal x955 = (cj4 * px * x954);
                                            IkReal x956 = (py * sj4);
                                            IkReal x957 = (x954 * x956);
                                            IkReal x958 = (px * sj4);
                                            IkReal x959 = ((1.0) * cj4 * py);
                                            IkReal x960 = (cj4 * sj8);
                                            IkReal x961 = ((0.045) * cj8);
                                            IkReal x962 = ((0.045) * cj9);
                                            IkReal x963 = (cj8 * x954);
                                            IkReal x964 = ((0.3) * sj9);
                                            IkReal x965 = (sj8 * x958);
                                            IkReal x966 = (pz * x963);
                                            IkReal x967
                                                = (px * (((1.0) * cj4)));
                                            IkReal x968 = (cj8 * x952);
                                            IkReal x969 = ((1.0) * x956);
                                            IkReal x970 = ((0.09) * cj8 * x952);
                                            evalcond[0]
                                                = ((-0.55) + x953 + x955 + x957
                                                   + (((-1.0) * x951))
                                                   + (((-1.0) * x950)));
                                            evalcond[1]
                                                = ((((-1.0) * cj8 * x959))
                                                   + ((cj8 * x958))
                                                   + (((-1.0) * pz * sj8
                                                       * x954))
                                                   + ((sj8 * x952 * x956))
                                                   + ((px * x952 * x960)));
                                            evalcond[2]
                                                = ((((-0.55) * x952)) + pz
                                                   + (((-1.0) * x962 * x963))
                                                   + (((-1.0) * x951 * x952))
                                                   + ((x954 * x961))
                                                   + ((x963 * x964))
                                                   + (((-1.0) * x950 * x952)));
                                            evalcond[3]
                                                = ((0.045)
                                                   + (((-1.0) * x968 * x969))
                                                   + (((-1.0) * sj8 * x959))
                                                   + x966 + x964 + x965
                                                   + (((-1.0) * x962))
                                                   + (((-1.0) * x967 * x968)));
                                            evalcond[4]
                                                = (((x952 * x961))
                                                   + ((x964 * x968))
                                                   + (((0.55) * x954))
                                                   + (((-1.0) * x962 * x968))
                                                   + (((-1.0) * x969))
                                                   + ((x951 * x954))
                                                   + ((x950 * x954))
                                                   + (((-1.0) * x967)));
                                            evalcond[5]
                                                = ((-0.2125) + (((1.1) * x957))
                                                   + (((1.1) * x953))
                                                   + (((-0.09) * x965))
                                                   + (((1.1) * x955))
                                                   + (((0.09) * py * x960))
                                                   + ((cj4 * px * x970))
                                                   + ((x956 * x970))
                                                   + (((-0.09) * x966))
                                                   + (((-1.0) * (1.0) * pp)));
                                            if (IKabs(evalcond[0])
                                                    > IKFAST_EVALCOND_THRESH
                                                || IKabs(evalcond[1])
                                                       > IKFAST_EVALCOND_THRESH
                                                || IKabs(evalcond[2])
                                                       > IKFAST_EVALCOND_THRESH
                                                || IKabs(evalcond[3])
                                                       > IKFAST_EVALCOND_THRESH
                                                || IKabs(evalcond[4])
                                                       > IKFAST_EVALCOND_THRESH
                                                || IKabs(evalcond[5])
                                                       > IKFAST_EVALCOND_THRESH)
                                            {
                                              continue;
                                            }
                                          }

                                          rotationfunction0(solutions);
                                        }
                                      }
                                    }
                                  }
                                }
                                else
                                {
                                  {
                                    IkReal j6array[1], cj6array[1], sj6array[1];
                                    bool j6valid[1] = {false};
                                    _nj6 = 1;
                                    IkReal x971 = py * py;
                                    IkReal x972 = (sj8 * x971);
                                    IkReal x973 = (cj4 * px * sj8);
                                    IkReal x974 = cj4 * cj4;
                                    IkReal x975 = px * px;
                                    IkReal x976 = ((0.55) * sj8);
                                    IkReal x977 = (cj8 * px);
                                    IkReal x978 = ((0.3) * cj9);
                                    IkReal x979 = ((0.045) * sj9);
                                    IkReal x980 = (py * sj4 * sj8);
                                    IkReal x981 = (pz * sj8);
                                    IkReal x982 = (cj4 * cj8 * sj4);
                                    CheckValue<IkReal> x983 = IKatan2WithCheck(
                                        IkReal(
                                            (((x973 * x978)) + ((x973 * x979))
                                             + ((pz * sj4 * x977))
                                             + (((-1.0) * cj4 * cj8 * py * pz))
                                             + ((cj4 * px * x976))
                                             + ((x979 * x980)) + ((x978 * x980))
                                             + ((py * sj4 * x976)))),
                                        (((pz * x976))
                                         + (((2.0) * py * x974 * x977))
                                         + ((x979 * x981)) + ((x971 * x982))
                                         + (((-1.0) * py * x977))
                                         + ((x978 * x981))
                                         + (((-1.0) * x975 * x982))),
                                        IKFAST_ATAN2_MAGTHRESH);
                                    if (!x983.valid)
                                    {
                                      continue;
                                    }
                                    CheckValue<IkReal> x984
                                        = IKPowWithIntegerCheck(
                                            IKsign(
                                                ((((2.0) * py * sj4 * x973))
                                                 + ((sj8 * (pz * pz))) + x972
                                                 + (((-1.0) * x972 * x974))
                                                 + ((sj8 * x974 * x975)))),
                                            -1);
                                    if (!x984.valid)
                                    {
                                      continue;
                                    }
                                    j6array[0]
                                        = ((-1.5707963267949) + (x983.value)
                                           + (((1.5707963267949)
                                               * (x984.value))));
                                    sj6array[0] = IKsin(j6array[0]);
                                    cj6array[0] = IKcos(j6array[0]);
                                    if (j6array[0] > IKPI)
                                    {
                                      j6array[0] -= IK2PI;
                                    }
                                    else if (j6array[0] < -IKPI)
                                    {
                                      j6array[0] += IK2PI;
                                    }
                                    j6valid[0] = true;
                                    for (int ij6 = 0; ij6 < 1; ++ij6)
                                    {
                                      if (!j6valid[ij6])
                                      {
                                        continue;
                                      }
                                      _ij6[0] = ij6;
                                      _ij6[1] = -1;
                                      for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                      {
                                        if (j6valid[iij6]
                                            && IKabs(
                                                   cj6array[ij6]
                                                   - cj6array[iij6])
                                                   < IKFAST_SOLUTION_THRESH
                                            && IKabs(
                                                   sj6array[ij6]
                                                   - sj6array[iij6])
                                                   < IKFAST_SOLUTION_THRESH)
                                        {
                                          j6valid[iij6] = false;
                                          _ij6[1] = iij6;
                                          break;
                                        }
                                      }
                                      j6 = j6array[ij6];
                                      cj6 = cj6array[ij6];
                                      sj6 = sj6array[ij6];
                                      {
                                        IkReal evalcond[6];
                                        IkReal x985 = ((0.3) * cj9);
                                        IkReal x986 = ((0.045) * sj9);
                                        IkReal x987 = IKcos(j6);
                                        IkReal x988 = (pz * x987);
                                        IkReal x989 = IKsin(j6);
                                        IkReal x990 = (cj4 * px * x989);
                                        IkReal x991 = (py * sj4);
                                        IkReal x992 = (x989 * x991);
                                        IkReal x993 = (px * sj4);
                                        IkReal x994 = ((1.0) * cj4 * py);
                                        IkReal x995 = (cj4 * sj8);
                                        IkReal x996 = ((0.045) * cj8);
                                        IkReal x997 = ((0.045) * cj9);
                                        IkReal x998 = (cj8 * x989);
                                        IkReal x999 = ((0.3) * sj9);
                                        IkReal x1000 = (sj8 * x993);
                                        IkReal x1001 = (pz * x998);
                                        IkReal x1002 = (px * (((1.0) * cj4)));
                                        IkReal x1003 = (cj8 * x987);
                                        IkReal x1004 = ((1.0) * x991);
                                        IkReal x1005 = ((0.09) * cj8 * x987);
                                        evalcond[0]
                                            = ((-0.55) + (((-1.0) * x985))
                                               + (((-1.0) * x986)) + x988 + x990
                                               + x992);
                                        evalcond[1]
                                            = ((((-1.0) * cj8 * x994))
                                               + (((-1.0) * pz * sj8 * x989))
                                               + ((px * x987 * x995))
                                               + ((sj8 * x987 * x991))
                                               + ((cj8 * x993)));
                                        evalcond[2]
                                            = ((((-1.0) * x986 * x987)) + pz
                                               + (((-0.55) * x987))
                                               + (((-1.0) * x997 * x998))
                                               + ((x998 * x999))
                                               + (((-1.0) * x985 * x987))
                                               + ((x989 * x996)));
                                        evalcond[3]
                                            = ((0.045) + (((-1.0) * sj8 * x994))
                                               + (((-1.0) * x997)) + x1000
                                               + x1001
                                               + (((-1.0) * x1002 * x1003))
                                               + (((-1.0) * x1003 * x1004))
                                               + x999);
                                        evalcond[4]
                                            = ((((-1.0) * x1003 * x997))
                                               + ((x985 * x989))
                                               + ((x1003 * x999))
                                               + (((0.55) * x989))
                                               + (((-1.0) * x1004))
                                               + (((-1.0) * x1002))
                                               + ((x986 * x989))
                                               + ((x987 * x996)));
                                        evalcond[5]
                                            = ((-0.2125) + (((1.1) * x990))
                                               + ((cj4 * px * x1005))
                                               + ((x1005 * x991))
                                               + (((-0.09) * x1001))
                                               + (((0.09) * py * x995))
                                               + (((-0.09) * x1000))
                                               + (((-1.0) * (1.0) * pp))
                                               + (((1.1) * x988))
                                               + (((1.1) * x992)));
                                        if (IKabs(evalcond[0])
                                                > IKFAST_EVALCOND_THRESH
                                            || IKabs(evalcond[1])
                                                   > IKFAST_EVALCOND_THRESH
                                            || IKabs(evalcond[2])
                                                   > IKFAST_EVALCOND_THRESH
                                            || IKabs(evalcond[3])
                                                   > IKFAST_EVALCOND_THRESH
                                            || IKabs(evalcond[4])
                                                   > IKFAST_EVALCOND_THRESH
                                            || IKabs(evalcond[5])
                                                   > IKFAST_EVALCOND_THRESH)
                                        {
                                          continue;
                                        }
                                      }

                                      rotationfunction0(solutions);
                                    }
                                  }
                                }
                              }
                            }
                            else
                            {
                              {
                                IkReal j6array[1], cj6array[1], sj6array[1];
                                bool j6valid[1] = {false};
                                _nj6 = 1;
                                IkReal x1006 = (cj4 * px);
                                IkReal x1007 = ((0.045) * pz);
                                IkReal x1008 = (py * sj4);
                                IkReal x1009 = ((0.3) * cj9);
                                IkReal x1010 = ((0.045) * sj9);
                                IkReal x1011 = (cj8 * cj9);
                                IkReal x1012 = (cj8 * sj9);
                                IkReal x1013 = cj9 * cj9;
                                IkReal x1014 = ((1.0) * pz);
                                CheckValue<IkReal> x1015 = IKatan2WithCheck(
                                    IkReal(
                                        ((-0.304525)
                                         + (((-1.0) * (0.027) * cj9 * sj9))
                                         + (((-1.0) * (0.0495) * sj9))
                                         + (pz * pz) + (((-0.087975) * x1013))
                                         + (((-1.0) * (0.33) * cj9)))),
                                    ((((-0.087975) * sj9 * x1011))
                                     + (((-1.0) * x1008 * x1014))
                                     + (((-1.0) * x1006 * x1014))
                                     + (((0.027) * cj8 * x1013))
                                     + (((0.01125) * x1011))
                                     + (((-0.167025) * x1012))
                                     + (((-1.0) * (0.03825) * cj8))),
                                    IKFAST_ATAN2_MAGTHRESH);
                                if (!x1015.valid)
                                {
                                  continue;
                                }
                                CheckValue<IkReal> x1016
                                    = IKPowWithIntegerCheck(
                                        IKsign(
                                            ((((-1.0) * cj8 * x1007))
                                             + ((x1007 * x1011))
                                             + (((-0.3) * pz * x1012))
                                             + (((-0.55) * x1008))
                                             + (((-1.0) * x1008 * x1010))
                                             + (((-0.55) * x1006))
                                             + (((-1.0) * x1008 * x1009))
                                             + (((-1.0) * x1006 * x1009))
                                             + (((-1.0) * x1006 * x1010)))),
                                        -1);
                                if (!x1016.valid)
                                {
                                  continue;
                                }
                                j6array[0]
                                    = ((-1.5707963267949) + (x1015.value)
                                       + (((1.5707963267949) * (x1016.value))));
                                sj6array[0] = IKsin(j6array[0]);
                                cj6array[0] = IKcos(j6array[0]);
                                if (j6array[0] > IKPI)
                                {
                                  j6array[0] -= IK2PI;
                                }
                                else if (j6array[0] < -IKPI)
                                {
                                  j6array[0] += IK2PI;
                                }
                                j6valid[0] = true;
                                for (int ij6 = 0; ij6 < 1; ++ij6)
                                {
                                  if (!j6valid[ij6])
                                  {
                                    continue;
                                  }
                                  _ij6[0] = ij6;
                                  _ij6[1] = -1;
                                  for (int iij6 = ij6 + 1; iij6 < 1; ++iij6)
                                  {
                                    if (j6valid[iij6]
                                        && IKabs(cj6array[ij6] - cj6array[iij6])
                                               < IKFAST_SOLUTION_THRESH
                                        && IKabs(sj6array[ij6] - sj6array[iij6])
                                               < IKFAST_SOLUTION_THRESH)
                                    {
                                      j6valid[iij6] = false;
                                      _ij6[1] = iij6;
                                      break;
                                    }
                                  }
                                  j6 = j6array[ij6];
                                  cj6 = cj6array[ij6];
                                  sj6 = sj6array[ij6];
                                  {
                                    IkReal evalcond[6];
                                    IkReal x1017 = ((0.3) * cj9);
                                    IkReal x1018 = ((0.045) * sj9);
                                    IkReal x1019 = IKcos(j6);
                                    IkReal x1020 = (pz * x1019);
                                    IkReal x1021 = IKsin(j6);
                                    IkReal x1022 = (cj4 * px * x1021);
                                    IkReal x1023 = (py * sj4);
                                    IkReal x1024 = (x1021 * x1023);
                                    IkReal x1025 = (px * sj4);
                                    IkReal x1026 = ((1.0) * cj4 * py);
                                    IkReal x1027 = (cj4 * sj8);
                                    IkReal x1028 = ((0.045) * cj8);
                                    IkReal x1029 = ((0.045) * cj9);
                                    IkReal x1030 = (cj8 * x1021);
                                    IkReal x1031 = ((0.3) * sj9);
                                    IkReal x1032 = (sj8 * x1025);
                                    IkReal x1033 = (pz * x1030);
                                    IkReal x1034 = (px * (((1.0) * cj4)));
                                    IkReal x1035 = (cj8 * x1019);
                                    IkReal x1036 = ((1.0) * x1023);
                                    IkReal x1037 = ((0.09) * cj8 * x1019);
                                    evalcond[0]
                                        = ((-0.55) + x1020 + x1022 + x1024
                                           + (((-1.0) * x1018))
                                           + (((-1.0) * x1017)));
                                    evalcond[1]
                                        = ((((-1.0) * cj8 * x1026))
                                           + (((-1.0) * pz * sj8 * x1021))
                                           + ((px * x1019 * x1027))
                                           + ((cj8 * x1025))
                                           + ((sj8 * x1019 * x1023)));
                                    evalcond[2]
                                        = ((((-1.0) * x1018 * x1019))
                                           + (((-1.0) * x1029 * x1030))
                                           + ((x1030 * x1031))
                                           + ((x1021 * x1028))
                                           + (((-0.55) * x1019)) + pz
                                           + (((-1.0) * x1017 * x1019)));
                                    evalcond[3]
                                        = ((0.045) + (((-1.0) * x1029))
                                           + (((-1.0) * x1035 * x1036))
                                           + (((-1.0) * x1034 * x1035)) + x1031
                                           + x1033 + x1032
                                           + (((-1.0) * sj8 * x1026)));
                                    evalcond[4]
                                        = (((x1031 * x1035))
                                           + (((0.55) * x1021))
                                           + (((-1.0) * x1036))
                                           + ((x1019 * x1028))
                                           + ((x1017 * x1021))
                                           + ((x1018 * x1021))
                                           + (((-1.0) * x1029 * x1035))
                                           + (((-1.0) * x1034)));
                                    evalcond[5]
                                        = ((-0.2125) + ((cj4 * px * x1037))
                                           + ((x1023 * x1037))
                                           + (((1.1) * x1024))
                                           + (((-0.09) * x1032))
                                           + (((0.09) * py * x1027))
                                           + (((1.1) * x1020))
                                           + (((-1.0) * (1.0) * pp))
                                           + (((1.1) * x1022))
                                           + (((-0.09) * x1033)));
                                    if (IKabs(evalcond[0])
                                            > IKFAST_EVALCOND_THRESH
                                        || IKabs(evalcond[1])
                                               > IKFAST_EVALCOND_THRESH
                                        || IKabs(evalcond[2])
                                               > IKFAST_EVALCOND_THRESH
                                        || IKabs(evalcond[3])
                                               > IKFAST_EVALCOND_THRESH
                                        || IKabs(evalcond[4])
                                               > IKFAST_EVALCOND_THRESH
                                        || IKabs(evalcond[5])
                                               > IKFAST_EVALCOND_THRESH)
                                    {
                                      continue;
                                    }
                                  }

                                  rotationfunction0(solutions);
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
                else
                {
                  {
                    IkReal j6array[2], cj6array[2], sj6array[2];
                    bool j6valid[2] = {false};
                    _nj6 = 2;
                    IkReal x1038
                        = ((-0.55) + (((-1.0) * (0.3) * cj9))
                           + (((-1.0) * (0.045) * sj9)));
                    IkReal x1039 = ((0.045) * cj8);
                    IkReal x1040
                        = ((((-1.0) * cj9 * x1039)) + x1039
                           + (((0.3) * cj8 * sj9)));
                    CheckValue<IkReal> x1043 = IKatan2WithCheck(
                        IkReal(x1038), x1040, IKFAST_ATAN2_MAGTHRESH);
                    if (!x1043.valid)
                    {
                      continue;
                    }
                    IkReal x1041 = ((-1.0) * (x1043.value));
                    if ((((x1040 * x1040) + (x1038 * x1038))) < -0.00001)
                      continue;
                    CheckValue<IkReal> x1044 = IKPowWithIntegerCheck(
                        IKabs(IKsqrt(((x1040 * x1040) + (x1038 * x1038)))), -1);
                    if (!x1044.valid)
                    {
                      continue;
                    }
                    if (((pz * (x1044.value))) < -1 - IKFAST_SINCOS_THRESH
                        || ((pz * (x1044.value))) > 1 + IKFAST_SINCOS_THRESH)
                      continue;
                    IkReal x1042 = IKasin((pz * (x1044.value)));
                    j6array[0] = ((((-1.0) * x1042)) + x1041);
                    sj6array[0] = IKsin(j6array[0]);
                    cj6array[0] = IKcos(j6array[0]);
                    j6array[1] = ((3.14159265358979) + x1042 + x1041);
                    sj6array[1] = IKsin(j6array[1]);
                    cj6array[1] = IKcos(j6array[1]);
                    if (j6array[0] > IKPI)
                    {
                      j6array[0] -= IK2PI;
                    }
                    else if (j6array[0] < -IKPI)
                    {
                      j6array[0] += IK2PI;
                    }
                    j6valid[0] = true;
                    if (j6array[1] > IKPI)
                    {
                      j6array[1] -= IK2PI;
                    }
                    else if (j6array[1] < -IKPI)
                    {
                      j6array[1] += IK2PI;
                    }
                    j6valid[1] = true;
                    for (int ij6 = 0; ij6 < 2; ++ij6)
                    {
                      if (!j6valid[ij6])
                      {
                        continue;
                      }
                      _ij6[0] = ij6;
                      _ij6[1] = -1;
                      for (int iij6 = ij6 + 1; iij6 < 2; ++iij6)
                      {
                        if (j6valid[iij6]
                            && IKabs(cj6array[ij6] - cj6array[iij6])
                                   < IKFAST_SOLUTION_THRESH
                            && IKabs(sj6array[ij6] - sj6array[iij6])
                                   < IKFAST_SOLUTION_THRESH)
                        {
                          j6valid[iij6] = false;
                          _ij6[1] = iij6;
                          break;
                        }
                      }
                      j6 = j6array[ij6];
                      cj6 = cj6array[ij6];
                      sj6 = sj6array[ij6];

                      {
                        IkReal j4eval[2];
                        IkReal x1045
                            = ((((-1.0) * (1.0) * sj6 * (pz * pz)))
                               + ((pp * sj6)));
                        j4eval[0] = x1045;
                        j4eval[1] = IKsign(x1045);
                        if (IKabs(j4eval[0]) < 0.0000010000000000
                            || IKabs(j4eval[1]) < 0.0000010000000000)
                        {
                          {
                            IkReal j4eval[2];
                            IkReal x1046 = (cj8 * sj6);
                            IkReal x1047
                                = (((x1046 * (pz * pz)))
                                   + (((-1.0) * pp * x1046)));
                            j4eval[0] = x1047;
                            j4eval[1] = IKsign(x1047);
                            if (IKabs(j4eval[0]) < 0.0000010000000000
                                || IKabs(j4eval[1]) < 0.0000010000000000)
                            {
                              {
                                IkReal j4eval[2];
                                IkReal x1048
                                    = (pp + (((-1.0) * (1.0) * (pz * pz))));
                                j4eval[0] = x1048;
                                j4eval[1] = IKsign(x1048);
                                if (IKabs(j4eval[0]) < 0.0000010000000000
                                    || IKabs(j4eval[1]) < 0.0000010000000000)
                                {
                                  {
                                    IkReal evalcond[4];
                                    bool bgotonextstatement = true;
                                    do
                                    {
                                      evalcond[0]
                                          = ((-3.14159265358979)
                                             + (IKfmod(
                                                 ((3.14159265358979)
                                                  + (IKabs(
                                                      ((-1.5707963267949)
                                                       + j8)))),
                                                 6.28318530717959)));
                                      evalcond[1]
                                          = ((0.39655) + (((0.0765) * sj9))
                                             + (((0.32595) * cj9))
                                             + (((-1.0) * (1.0) * pp)));
                                      evalcond[2]
                                          = ((((-1.0) * (0.3) * cj6 * cj9))
                                             + (((-1.0) * (0.55) * cj6)) + pz
                                             + (((-1.0) * (0.045) * cj6
                                                 * sj9)));
                                      if (IKabs(evalcond[0])
                                              < 0.0000010000000000
                                          && IKabs(evalcond[1])
                                                 < 0.0000010000000000
                                          && IKabs(evalcond[2])
                                                 < 0.0000010000000000)
                                      {
                                        bgotonextstatement = false;
                                        {
                                          IkReal j4eval[3];
                                          sj8 = 1.0;
                                          cj8 = 0;
                                          j8 = 1.5707963267949;
                                          IkReal x1049
                                              = ((((-1.0) * (1.0) * cj6
                                                   * (pz * pz)))
                                                 + ((cj6 * pp)));
                                          IkReal x1050
                                              = ((1.51009803921569) * cj6);
                                          IkReal x1051 = (pz * sj6);
                                          IkReal x1052
                                              = ((1.32323529411765) * cj6
                                                 * cj9);
                                          IkReal x1053
                                              = ((3.92156862745098) * cj6 * pp);
                                          j4eval[0] = x1049;
                                          j4eval[1] = IKsign(x1049);
                                          j4eval[2]
                                              = ((IKabs(
                                                     (((py * x1053))
                                                      + (((-1.0) * py * x1052))
                                                      + (((-1.0) * py * x1050))
                                                      + ((px * x1051)))))
                                                 + (IKabs(
                                                     (((px * x1052))
                                                      + ((px * x1050))
                                                      + ((py * x1051))
                                                      + (((-1.0) * px
                                                          * x1053))))));
                                          if (IKabs(j4eval[0])
                                                  < 0.0000010000000000
                                              || IKabs(j4eval[1])
                                                     < 0.0000010000000000
                                              || IKabs(j4eval[2])
                                                     < 0.0000010000000000)
                                          {
                                            {
                                              IkReal j4eval[3];
                                              sj8 = 1.0;
                                              cj8 = 0;
                                              j8 = 1.5707963267949;
                                              IkReal x1054 = (cj6 * pp);
                                              IkReal x1055 = (cj6 * (pz * pz));
                                              IkReal x1056 = ((0.2125) * cj6);
                                              IkReal x1057 = ((1.1) * pz);
                                              IkReal x1058
                                                  = ((0.09) * pz * sj6);
                                              j4eval[0]
                                                  = ((((-1.0) * x1055))
                                                     + x1054);
                                              j4eval[1] = IKsign(
                                                  ((((-0.09) * x1055))
                                                   + (((0.09) * x1054))));
                                              j4eval[2]
                                                  = ((IKabs(
                                                         (((py * x1058))
                                                          + ((px * x1057))
                                                          + (((-1.0) * px
                                                              * x1054))
                                                          + (((-1.0) * px
                                                              * x1056)))))
                                                     + (IKabs(
                                                         (((py * x1056))
                                                          + ((py * x1054))
                                                          + (((-1.0) * py
                                                              * x1057))
                                                          + ((px * x1058))))));
                                              if (IKabs(j4eval[0])
                                                      < 0.0000010000000000
                                                  || IKabs(j4eval[1])
                                                         < 0.0000010000000000
                                                  || IKabs(j4eval[2])
                                                         < 0.0000010000000000)
                                              {
                                                {
                                                  IkReal j4eval[3];
                                                  sj8 = 1.0;
                                                  cj8 = 0;
                                                  j8 = 1.5707963267949;
                                                  IkReal x1059
                                                      = (pp
                                                         + (((-1.0) * (1.0)
                                                             * (pz * pz))));
                                                  IkReal x1060
                                                      = ((1.32323529411765)
                                                         * cj9);
                                                  IkReal x1061
                                                      = ((3.92156862745098)
                                                         * pp);
                                                  IkReal x1062
                                                      = ((0.316735294117647)
                                                         * sj6);
                                                  IkReal x1063
                                                      = ((0.108264705882353)
                                                         * cj9 * sj6);
                                                  IkReal x1064
                                                      = ((0.588235294117647)
                                                         * pp * sj6);
                                                  j4eval[0] = x1059;
                                                  j4eval[1]
                                                      = ((IKabs((
                                                             (((-1.0)
                                                               * (1.51009803921569)
                                                               * py))
                                                             + ((px * x1064))
                                                             + (((-1.0) * py
                                                                 * x1060))
                                                             + ((px * x1063))
                                                             + ((py * x1061))
                                                             + ((px * x1062)))))
                                                         + (IKabs((
                                                             ((px * x1060))
                                                             + (((-1.0) * px
                                                                 * x1061))
                                                             + (((1.51009803921569)
                                                                 * px))
                                                             + ((py * x1063))
                                                             + ((py * x1062))
                                                             + ((py
                                                                 * x1064))))));
                                                  j4eval[2] = IKsign(x1059);
                                                  if (IKabs(j4eval[0])
                                                          < 0.0000010000000000
                                                      || IKabs(j4eval[1])
                                                             < 0.0000010000000000
                                                      || IKabs(j4eval[2])
                                                             < 0.0000010000000000)
                                                  {
                                                    {
                                                      IkReal evalcond[7];
                                                      bool bgotonextstatement
                                                          = true;
                                                      do
                                                      {
                                                        evalcond[0]
                                                            = ((-3.14159265358979)
                                                               + (IKfmod(
                                                                   ((3.14159265358979)
                                                                    + (IKabs((
                                                                        (-1.5707963267949)
                                                                        + j6)))),
                                                                   6.28318530717959)));
                                                        evalcond[1]
                                                            = ((-1.0)
                                                               * (((1.0)
                                                                   * pz)));
                                                        if (IKabs(evalcond[0])
                                                                < 0.0000010000000000
                                                            && IKabs(
                                                                   evalcond[1])
                                                                   < 0.0000010000000000)
                                                        {
                                                          bgotonextstatement
                                                              = false;
                                                          {
                                                            IkReal j4eval[3];
                                                            sj8 = 1.0;
                                                            cj8 = 0;
                                                            j8 = 1.5707963267949;
                                                            sj6 = 1.0;
                                                            cj6 = 0;
                                                            j6 = 1.5707963267949;
                                                            IkReal x1065
                                                                = (pp
                                                                   + (((-1.0)
                                                                       * (1.0)
                                                                       * (pz
                                                                          * pz))));
                                                            IkReal x1066
                                                                = (cj9 * px);
                                                            IkReal x1067
                                                                = (cj9 * py);
                                                            IkReal x1068
                                                                = ((3.92156862745098)
                                                                   * pp);
                                                            IkReal x1069
                                                                = ((0.045)
                                                                   * sj9);
                                                            j4eval[0] = x1065;
                                                            j4eval[1]
                                                                = ((IKabs((
                                                                       (((1.51009803921569)
                                                                         * px))
                                                                       + ((py
                                                                           * x1069))
                                                                       + (((0.55)
                                                                           * py))
                                                                       + (((0.3)
                                                                           * x1067))
                                                                       + (((1.32323529411765)
                                                                           * x1066))
                                                                       + (((-1.0)
                                                                           * px
                                                                           * x1068)))))
                                                                   + (IKabs((
                                                                       (((0.3)
                                                                         * x1066))
                                                                       + (((-1.0)
                                                                           * (1.51009803921569)
                                                                           * py))
                                                                       + (((-1.32323529411765)
                                                                           * x1067))
                                                                       + (((0.55)
                                                                           * px))
                                                                       + ((py
                                                                           * x1068))
                                                                       + ((px
                                                                           * x1069))))));
                                                            j4eval[2]
                                                                = IKsign(x1065);
                                                            if (IKabs(j4eval[0])
                                                                    < 0.0000010000000000
                                                                || IKabs(
                                                                       j4eval
                                                                           [1])
                                                                       < 0.0000010000000000
                                                                || IKabs(
                                                                       j4eval
                                                                           [2])
                                                                       < 0.0000010000000000)
                                                            {
                                                              {
                                                                IkReal
                                                                    j4eval[3];
                                                                sj8 = 1.0;
                                                                cj8 = 0;
                                                                j8 = 1.5707963267949;
                                                                sj6 = 1.0;
                                                                cj6 = 0;
                                                                j6 = 1.5707963267949;
                                                                IkReal x1070
                                                                    = (pp
                                                                       + (((-1.0)
                                                                           * (1.0)
                                                                           * (pz
                                                                              * pz))));
                                                                IkReal x1071
                                                                    = (cj9
                                                                       * px);
                                                                IkReal x1072
                                                                    = (cj9
                                                                       * py);
                                                                IkReal x1073
                                                                    = (pp * px);
                                                                IkReal x1074
                                                                    = (pp * py);
                                                                j4eval[0]
                                                                    = x1070;
                                                                j4eval[1]
                                                                    = ((IKabs((
                                                                           (((0.108264705882353)
                                                                             * x1072))
                                                                           + (((0.588235294117647)
                                                                               * x1074))
                                                                           + (((1.32323529411765)
                                                                               * x1071))
                                                                           + (((0.316735294117647)
                                                                               * py))
                                                                           + (((1.51009803921569)
                                                                               * px))
                                                                           + (((-3.92156862745098)
                                                                               * x1073)))))
                                                                       + (IKabs((
                                                                           (((-1.32323529411765)
                                                                             * x1072))
                                                                           + (((0.588235294117647)
                                                                               * x1073))
                                                                           + (((3.92156862745098)
                                                                               * x1074))
                                                                           + (((0.316735294117647)
                                                                               * px))
                                                                           + (((0.108264705882353)
                                                                               * x1071))
                                                                           + (((-1.0)
                                                                               * (1.51009803921569)
                                                                               * py))))));
                                                                j4eval[2]
                                                                    = IKsign(
                                                                        x1070);
                                                                if (IKabs(
                                                                        j4eval
                                                                            [0])
                                                                        < 0.0000010000000000
                                                                    || IKabs(
                                                                           j4eval
                                                                               [1])
                                                                           < 0.0000010000000000
                                                                    || IKabs(
                                                                           j4eval
                                                                               [2])
                                                                           < 0.0000010000000000)
                                                                {
                                                                  {
                                                                    IkReal
                                                                        j4eval
                                                                            [3];
                                                                    sj8 = 1.0;
                                                                    cj8 = 0;
                                                                    j8 = 1.5707963267949;
                                                                    sj6 = 1.0;
                                                                    cj6 = 0;
                                                                    j6 = 1.5707963267949;
                                                                    IkReal x1075
                                                                        = pz
                                                                          * pz;
                                                                    IkReal x1076
                                                                        = (cj9
                                                                           * px);
                                                                    IkReal x1077
                                                                        = (cj9
                                                                           * py);
                                                                    IkReal x1078
                                                                        = (pp
                                                                           * px);
                                                                    IkReal x1079
                                                                        = (pp
                                                                           * py);
                                                                    j4eval[0]
                                                                        = ((((-1.0)
                                                                             * x1075))
                                                                           + pp);
                                                                    j4eval[1]
                                                                        = ((IKabs((
                                                                               (((0.348408823529412)
                                                                                 * py))
                                                                               + (((1.66110784313725)
                                                                                   * px))
                                                                               + (((1.45555882352941)
                                                                                   * x1076))
                                                                               + (((0.647058823529412)
                                                                                   * x1079))
                                                                               + (((-4.31372549019608)
                                                                                   * x1078))
                                                                               + (((0.119091176470588)
                                                                                   * x1077)))))
                                                                           + (IKabs((
                                                                               (((0.348408823529412)
                                                                                 * px))
                                                                               + (((-1.45555882352941)
                                                                                   * x1077))
                                                                               + (((4.31372549019608)
                                                                                   * x1079))
                                                                               + (((0.647058823529412)
                                                                                   * x1078))
                                                                               + (((-1.0)
                                                                                   * (1.66110784313725)
                                                                                   * py))
                                                                               + (((0.119091176470588)
                                                                                   * x1076))))));
                                                                    j4eval[2] = IKsign((
                                                                        (((1.1)
                                                                          * pp))
                                                                        + (((-1.1)
                                                                            * x1075))));
                                                                    if (IKabs(
                                                                            j4eval
                                                                                [0])
                                                                            < 0.0000010000000000
                                                                        || IKabs(
                                                                               j4eval
                                                                                   [1])
                                                                               < 0.0000010000000000
                                                                        || IKabs(
                                                                               j4eval
                                                                                   [2])
                                                                               < 0.0000010000000000)
                                                                    {
                                                                      {
                                                                        IkReal evalcond
                                                                            [6];
                                                                        bool
                                                                            bgotonextstatement
                                                                            = true;
                                                                        do
                                                                        {
                                                                          IkReal
                                                                              x1080
                                                                              = ((-1.51009803921569)
                                                                                 + (((-1.0)
                                                                                     * (1.32323529411765)
                                                                                     * cj9))
                                                                                 + (((3.92156862745098)
                                                                                     * pp)));
                                                                          evalcond
                                                                              [0]
                                                                              = ((IKabs(
                                                                                     py))
                                                                                 + (IKabs(
                                                                                     px)));
                                                                          evalcond
                                                                              [1]
                                                                              = ((-0.55)
                                                                                 + (((-1.0)
                                                                                     * (0.3)
                                                                                     * cj9))
                                                                                 + (((-1.0)
                                                                                     * (0.045)
                                                                                     * sj9)));
                                                                          evalcond
                                                                              [2]
                                                                              = x1080;
                                                                          evalcond
                                                                              [3]
                                                                              = x1080;
                                                                          evalcond
                                                                              [4]
                                                                              = ((0.316735294117647)
                                                                                 + (((0.108264705882353)
                                                                                     * cj9))
                                                                                 + (((0.588235294117647)
                                                                                     * pp)));
                                                                          evalcond
                                                                              [5]
                                                                              = ((-0.2125)
                                                                                 + (((-1.0)
                                                                                     * (1.0)
                                                                                     * pp)));
                                                                          if (IKabs(
                                                                                  evalcond
                                                                                      [0])
                                                                                  < 0.0000010000000000
                                                                              && IKabs(
                                                                                     evalcond
                                                                                         [1])
                                                                                     < 0.0000010000000000
                                                                              && IKabs(
                                                                                     evalcond
                                                                                         [2])
                                                                                     < 0.0000010000000000
                                                                              && IKabs(
                                                                                     evalcond
                                                                                         [3])
                                                                                     < 0.0000010000000000
                                                                              && IKabs(
                                                                                     evalcond
                                                                                         [4])
                                                                                     < 0.0000010000000000
                                                                              && IKabs(
                                                                                     evalcond
                                                                                         [5])
                                                                                     < 0.0000010000000000)
                                                                          {
                                                                            bgotonextstatement
                                                                                = false;
                                                                            {
                                                                              IkReal j4array
                                                                                  [4],
                                                                                  cj4array
                                                                                      [4],
                                                                                  sj4array
                                                                                      [4];
                                                                              bool j4valid
                                                                                  [4]
                                                                                  = {false};
                                                                              _nj4
                                                                                  = 4;
                                                                              j4array
                                                                                  [0]
                                                                                  = 0;
                                                                              sj4array
                                                                                  [0]
                                                                                  = IKsin(
                                                                                      j4array
                                                                                          [0]);
                                                                              cj4array
                                                                                  [0]
                                                                                  = IKcos(
                                                                                      j4array
                                                                                          [0]);
                                                                              j4array
                                                                                  [1]
                                                                                  = 1.5707963267949;
                                                                              sj4array
                                                                                  [1]
                                                                                  = IKsin(
                                                                                      j4array
                                                                                          [1]);
                                                                              cj4array
                                                                                  [1]
                                                                                  = IKcos(
                                                                                      j4array
                                                                                          [1]);
                                                                              j4array
                                                                                  [2]
                                                                                  = 3.14159265358979;
                                                                              sj4array
                                                                                  [2]
                                                                                  = IKsin(
                                                                                      j4array
                                                                                          [2]);
                                                                              cj4array
                                                                                  [2]
                                                                                  = IKcos(
                                                                                      j4array
                                                                                          [2]);
                                                                              j4array
                                                                                  [3]
                                                                                  = -1.5707963267949;
                                                                              sj4array
                                                                                  [3]
                                                                                  = IKsin(
                                                                                      j4array
                                                                                          [3]);
                                                                              cj4array
                                                                                  [3]
                                                                                  = IKcos(
                                                                                      j4array
                                                                                          [3]);
                                                                              if (j4array
                                                                                      [0]
                                                                                  > IKPI)
                                                                              {
                                                                                j4array
                                                                                    [0]
                                                                                    -= IK2PI;
                                                                              }
                                                                              else if (
                                                                                  j4array
                                                                                      [0]
                                                                                  < -IKPI)
                                                                              {
                                                                                j4array
                                                                                    [0]
                                                                                    += IK2PI;
                                                                              }
                                                                              j4valid
                                                                                  [0]
                                                                                  = true;
                                                                              if (j4array
                                                                                      [1]
                                                                                  > IKPI)
                                                                              {
                                                                                j4array
                                                                                    [1]
                                                                                    -= IK2PI;
                                                                              }
                                                                              else if (
                                                                                  j4array
                                                                                      [1]
                                                                                  < -IKPI)
                                                                              {
                                                                                j4array
                                                                                    [1]
                                                                                    += IK2PI;
                                                                              }
                                                                              j4valid
                                                                                  [1]
                                                                                  = true;
                                                                              if (j4array
                                                                                      [2]
                                                                                  > IKPI)
                                                                              {
                                                                                j4array
                                                                                    [2]
                                                                                    -= IK2PI;
                                                                              }
                                                                              else if (
                                                                                  j4array
                                                                                      [2]
                                                                                  < -IKPI)
                                                                              {
                                                                                j4array
                                                                                    [2]
                                                                                    += IK2PI;
                                                                              }
                                                                              j4valid
                                                                                  [2]
                                                                                  = true;
                                                                              if (j4array
                                                                                      [3]
                                                                                  > IKPI)
                                                                              {
                                                                                j4array
                                                                                    [3]
                                                                                    -= IK2PI;
                                                                              }
                                                                              else if (
                                                                                  j4array
                                                                                      [3]
                                                                                  < -IKPI)
                                                                              {
                                                                                j4array
                                                                                    [3]
                                                                                    += IK2PI;
                                                                              }
                                                                              j4valid
                                                                                  [3]
                                                                                  = true;
                                                                              for (
                                                                                  int ij4
                                                                                  = 0;
                                                                                  ij4
                                                                                  < 4;
                                                                                  ++ij4)
                                                                              {
                                                                                if (!j4valid
                                                                                        [ij4])
                                                                                {
                                                                                  continue;
                                                                                }
                                                                                _ij4[0]
                                                                                    = ij4;
                                                                                _ij4[1]
                                                                                    = -1;
                                                                                for (
                                                                                    int iij4
                                                                                    = ij4
                                                                                      + 1;
                                                                                    iij4
                                                                                    < 4;
                                                                                    ++iij4)
                                                                                {
                                                                                  if (j4valid
                                                                                          [iij4]
                                                                                      && IKabs(
                                                                                             cj4array
                                                                                                 [ij4]
                                                                                             - cj4array
                                                                                                 [iij4])
                                                                                             < IKFAST_SOLUTION_THRESH
                                                                                      && IKabs(
                                                                                             sj4array
                                                                                                 [ij4]
                                                                                             - sj4array
                                                                                                 [iij4])
                                                                                             < IKFAST_SOLUTION_THRESH)
                                                                                  {
                                                                                    j4valid
                                                                                        [iij4]
                                                                                        = false;
                                                                                    _ij4[1]
                                                                                        = iij4;
                                                                                    break;
                                                                                  }
                                                                                }
                                                                                j4 = j4array
                                                                                    [ij4];
                                                                                cj4 = cj4array
                                                                                    [ij4];
                                                                                sj4 = sj4array
                                                                                    [ij4];

                                                                                rotationfunction0(
                                                                                    solutions);
                                                                              }
                                                                            }
                                                                          }
                                                                        } while (
                                                                            0);
                                                                        if (bgotonextstatement)
                                                                        {
                                                                          bool
                                                                              bgotonextstatement
                                                                              = true;
                                                                          do
                                                                          {
                                                                            if (1)
                                                                            {
                                                                              bgotonextstatement
                                                                                  = false;
                                                                              continue; // branch miss [j4]
                                                                            }
                                                                          } while (
                                                                              0);
                                                                          if (bgotonextstatement)
                                                                          {
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                    else
                                                                    {
                                                                      {
                                                                        IkReal j4array
                                                                            [1],
                                                                            cj4array
                                                                                [1],
                                                                            sj4array
                                                                                [1];
                                                                        bool j4valid
                                                                            [1]
                                                                            = {false};
                                                                        _nj4
                                                                            = 1;
                                                                        IkReal
                                                                            x1081
                                                                            = (cj9
                                                                               * px);
                                                                        IkReal
                                                                            x1082
                                                                            = (cj9
                                                                               * py);
                                                                        IkReal
                                                                            x1083
                                                                            = (pp
                                                                               * px);
                                                                        IkReal
                                                                            x1084
                                                                            = (pp
                                                                               * py);
                                                                        CheckValue<IkReal> x1085 = IKatan2WithCheck(
                                                                            IkReal((
                                                                                (((0.119091176470588)
                                                                                  * x1082))
                                                                                + (((0.348408823529412)
                                                                                    * py))
                                                                                + (((1.66110784313725)
                                                                                    * px))
                                                                                + (((0.647058823529412)
                                                                                    * x1084))
                                                                                + (((-4.31372549019608)
                                                                                    * x1083))
                                                                                + (((1.45555882352941)
                                                                                    * x1081)))),
                                                                            ((((4.31372549019608)
                                                                               * x1084))
                                                                             + (((0.119091176470588)
                                                                                 * x1081))
                                                                             + (((0.348408823529412)
                                                                                 * px))
                                                                             + (((0.647058823529412)
                                                                                 * x1083))
                                                                             + (((-1.45555882352941)
                                                                                 * x1082))
                                                                             + (((-1.0)
                                                                                 * (1.66110784313725)
                                                                                 * py))),
                                                                            IKFAST_ATAN2_MAGTHRESH);
                                                                        if (!x1085
                                                                                 .valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        CheckValue<IkReal> x1086 = IKPowWithIntegerCheck(
                                                                            IKsign((
                                                                                (((1.1)
                                                                                  * pp))
                                                                                + (((-1.0)
                                                                                    * (1.1)
                                                                                    * (pz
                                                                                       * pz))))),
                                                                            -1);
                                                                        if (!x1086
                                                                                 .valid)
                                                                        {
                                                                          continue;
                                                                        }
                                                                        j4array
                                                                            [0]
                                                                            = ((-1.5707963267949)
                                                                               + (x1085
                                                                                      .value)
                                                                               + (((1.5707963267949)
                                                                                   * (x1086
                                                                                          .value))));
                                                                        sj4array
                                                                            [0]
                                                                            = IKsin(
                                                                                j4array
                                                                                    [0]);
                                                                        cj4array
                                                                            [0]
                                                                            = IKcos(
                                                                                j4array
                                                                                    [0]);
                                                                        if (j4array
                                                                                [0]
                                                                            > IKPI)
                                                                        {
                                                                          j4array
                                                                              [0]
                                                                              -= IK2PI;
                                                                        }
                                                                        else if (
                                                                            j4array
                                                                                [0]
                                                                            < -IKPI)
                                                                        {
                                                                          j4array
                                                                              [0]
                                                                              += IK2PI;
                                                                        }
                                                                        j4valid
                                                                            [0]
                                                                            = true;
                                                                        for (
                                                                            int ij4
                                                                            = 0;
                                                                            ij4
                                                                            < 1;
                                                                            ++ij4)
                                                                        {
                                                                          if (!j4valid
                                                                                  [ij4])
                                                                          {
                                                                            continue;
                                                                          }
                                                                          _ij4[0]
                                                                              = ij4;
                                                                          _ij4[1]
                                                                              = -1;
                                                                          for (
                                                                              int iij4
                                                                              = ij4
                                                                                + 1;
                                                                              iij4
                                                                              < 1;
                                                                              ++iij4)
                                                                          {
                                                                            if (j4valid
                                                                                    [iij4]
                                                                                && IKabs(
                                                                                       cj4array
                                                                                           [ij4]
                                                                                       - cj4array
                                                                                           [iij4])
                                                                                       < IKFAST_SOLUTION_THRESH
                                                                                && IKabs(
                                                                                       sj4array
                                                                                           [ij4]
                                                                                       - sj4array
                                                                                           [iij4])
                                                                                       < IKFAST_SOLUTION_THRESH)
                                                                            {
                                                                              j4valid
                                                                                  [iij4]
                                                                                  = false;
                                                                              _ij4[1]
                                                                                  = iij4;
                                                                              break;
                                                                            }
                                                                          }
                                                                          j4 = j4array
                                                                              [ij4];
                                                                          cj4 = cj4array
                                                                              [ij4];
                                                                          sj4 = sj4array
                                                                              [ij4];
                                                                          {
                                                                            IkReal evalcond
                                                                                [4];
                                                                            IkReal
                                                                                x1087
                                                                                = IKcos(
                                                                                    j4);
                                                                            IkReal
                                                                                x1088
                                                                                = (px
                                                                                   * x1087);
                                                                            IkReal
                                                                                x1089
                                                                                = IKsin(
                                                                                    j4);
                                                                            IkReal
                                                                                x1090
                                                                                = (py
                                                                                   * x1089);
                                                                            IkReal
                                                                                x1091
                                                                                = (px
                                                                                   * x1089);
                                                                            IkReal
                                                                                x1092
                                                                                = (py
                                                                                   * x1087);
                                                                            evalcond
                                                                                [0]
                                                                                = ((-0.55)
                                                                                   + x1088
                                                                                   + (((-1.0)
                                                                                       * (0.3)
                                                                                       * cj9))
                                                                                   + x1090
                                                                                   + (((-1.0)
                                                                                       * (0.045)
                                                                                       * sj9)));
                                                                            evalcond
                                                                                [1]
                                                                                = ((-1.51009803921569)
                                                                                   + (((-1.0)
                                                                                       * x1092))
                                                                                   + (((-1.0)
                                                                                       * (1.32323529411765)
                                                                                       * cj9))
                                                                                   + (((3.92156862745098)
                                                                                       * pp))
                                                                                   + x1091);
                                                                            evalcond
                                                                                [2]
                                                                                = ((0.316735294117647)
                                                                                   + (((-1.0)
                                                                                       * x1090))
                                                                                   + (((-1.0)
                                                                                       * x1088))
                                                                                   + (((0.108264705882353)
                                                                                       * cj9))
                                                                                   + (((0.588235294117647)
                                                                                       * pp)));
                                                                            evalcond
                                                                                [3]
                                                                                = ((-0.2125)
                                                                                   + (((1.1)
                                                                                       * x1090))
                                                                                   + (((0.09)
                                                                                       * x1092))
                                                                                   + (((-0.09)
                                                                                       * x1091))
                                                                                   + (((1.1)
                                                                                       * x1088))
                                                                                   + (((-1.0)
                                                                                       * (1.0)
                                                                                       * pp)));
                                                                            if (IKabs(
                                                                                    evalcond
                                                                                        [0])
                                                                                    > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [1])
                                                                                       > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [2])
                                                                                       > IKFAST_EVALCOND_THRESH
                                                                                || IKabs(
                                                                                       evalcond
                                                                                           [3])
                                                                                       > IKFAST_EVALCOND_THRESH)
                                                                            {
                                                                              continue;
                                                                            }
                                                                          }

                                                                          rotationfunction0(
                                                                              solutions);
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                                else
                                                                {
                                                                  {
                                                                    IkReal
                                                                        j4array
                                                                            [1],
                                                                        cj4array
                                                                            [1],
                                                                        sj4array
                                                                            [1];
                                                                    bool j4valid
                                                                        [1]
                                                                        = {false};
                                                                    _nj4 = 1;
                                                                    IkReal x1093
                                                                        = (cj9
                                                                           * px);
                                                                    IkReal x1094
                                                                        = (cj9
                                                                           * py);
                                                                    IkReal x1095
                                                                        = (pp
                                                                           * px);
                                                                    IkReal x1096
                                                                        = (pp
                                                                           * py);
                                                                    CheckValue<IkReal> x1097 = IKatan2WithCheck(
                                                                        IkReal((
                                                                            (((-3.92156862745098)
                                                                              * x1095))
                                                                            + (((0.316735294117647)
                                                                                * py))
                                                                            + (((1.51009803921569)
                                                                                * px))
                                                                            + (((0.108264705882353)
                                                                                * x1094))
                                                                            + (((1.32323529411765)
                                                                                * x1093))
                                                                            + (((0.588235294117647)
                                                                                * x1096)))),
                                                                        ((((0.108264705882353)
                                                                           * x1093))
                                                                         + (((0.588235294117647)
                                                                             * x1095))
                                                                         + (((-1.32323529411765)
                                                                             * x1094))
                                                                         + (((0.316735294117647)
                                                                             * px))
                                                                         + (((-1.0)
                                                                             * (1.51009803921569)
                                                                             * py))
                                                                         + (((3.92156862745098)
                                                                             * x1096))),
                                                                        IKFAST_ATAN2_MAGTHRESH);
                                                                    if (!x1097
                                                                             .valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    CheckValue<IkReal> x1098 = IKPowWithIntegerCheck(
                                                                        IKsign((
                                                                            pp
                                                                            + (((-1.0)
                                                                                * (1.0)
                                                                                * (pz
                                                                                   * pz))))),
                                                                        -1);
                                                                    if (!x1098
                                                                             .valid)
                                                                    {
                                                                      continue;
                                                                    }
                                                                    j4array[0]
                                                                        = ((-1.5707963267949)
                                                                           + (x1097
                                                                                  .value)
                                                                           + (((1.5707963267949)
                                                                               * (x1098
                                                                                      .value))));
                                                                    sj4array[0] = IKsin(
                                                                        j4array
                                                                            [0]);
                                                                    cj4array[0] = IKcos(
                                                                        j4array
                                                                            [0]);
                                                                    if (j4array
                                                                            [0]
                                                                        > IKPI)
                                                                    {
                                                                      j4array[0]
                                                                          -= IK2PI;
                                                                    }
                                                                    else if (
                                                                        j4array
                                                                            [0]
                                                                        < -IKPI)
                                                                    {
                                                                      j4array[0]
                                                                          += IK2PI;
                                                                    }
                                                                    j4valid[0]
                                                                        = true;
                                                                    for (int ij4
                                                                         = 0;
                                                                         ij4
                                                                         < 1;
                                                                         ++ij4)
                                                                    {
                                                                      if (!j4valid
                                                                              [ij4])
                                                                      {
                                                                        continue;
                                                                      }
                                                                      _ij4[0]
                                                                          = ij4;
                                                                      _ij4[1]
                                                                          = -1;
                                                                      for (
                                                                          int iij4
                                                                          = ij4
                                                                            + 1;
                                                                          iij4
                                                                          < 1;
                                                                          ++iij4)
                                                                      {
                                                                        if (j4valid
                                                                                [iij4]
                                                                            && IKabs(
                                                                                   cj4array
                                                                                       [ij4]
                                                                                   - cj4array
                                                                                       [iij4])
                                                                                   < IKFAST_SOLUTION_THRESH
                                                                            && IKabs(
                                                                                   sj4array
                                                                                       [ij4]
                                                                                   - sj4array
                                                                                       [iij4])
                                                                                   < IKFAST_SOLUTION_THRESH)
                                                                        {
                                                                          j4valid
                                                                              [iij4]
                                                                              = false;
                                                                          _ij4[1]
                                                                              = iij4;
                                                                          break;
                                                                        }
                                                                      }
                                                                      j4 = j4array
                                                                          [ij4];
                                                                      cj4 = cj4array
                                                                          [ij4];
                                                                      sj4 = sj4array
                                                                          [ij4];
                                                                      {
                                                                        IkReal evalcond
                                                                            [4];
                                                                        IkReal
                                                                            x1099
                                                                            = IKcos(
                                                                                j4);
                                                                        IkReal
                                                                            x1100
                                                                            = (px
                                                                               * x1099);
                                                                        IkReal
                                                                            x1101
                                                                            = IKsin(
                                                                                j4);
                                                                        IkReal
                                                                            x1102
                                                                            = (py
                                                                               * x1101);
                                                                        IkReal
                                                                            x1103
                                                                            = (px
                                                                               * x1101);
                                                                        IkReal
                                                                            x1104
                                                                            = (py
                                                                               * x1099);
                                                                        evalcond
                                                                            [0]
                                                                            = ((-0.55)
                                                                               + x1102
                                                                               + x1100
                                                                               + (((-1.0)
                                                                                   * (0.3)
                                                                                   * cj9))
                                                                               + (((-1.0)
                                                                                   * (0.045)
                                                                                   * sj9)));
                                                                        evalcond
                                                                            [1]
                                                                            = ((-1.51009803921569)
                                                                               + (((-1.0)
                                                                                   * x1104))
                                                                               + (((-1.0)
                                                                                   * (1.32323529411765)
                                                                                   * cj9))
                                                                               + x1103
                                                                               + (((3.92156862745098)
                                                                                   * pp)));
                                                                        evalcond
                                                                            [2]
                                                                            = ((0.316735294117647)
                                                                               + (((-1.0)
                                                                                   * x1102))
                                                                               + (((-1.0)
                                                                                   * x1100))
                                                                               + (((0.108264705882353)
                                                                                   * cj9))
                                                                               + (((0.588235294117647)
                                                                                   * pp)));
                                                                        evalcond
                                                                            [3]
                                                                            = ((-0.2125)
                                                                               + (((-0.09)
                                                                                   * x1103))
                                                                               + (((1.1)
                                                                                   * x1100))
                                                                               + (((1.1)
                                                                                   * x1102))
                                                                               + (((-1.0)
                                                                                   * (1.0)
                                                                                   * pp))
                                                                               + (((0.09)
                                                                                   * x1104)));
                                                                        if (IKabs(
                                                                                evalcond
                                                                                    [0])
                                                                                > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [1])
                                                                                   > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [2])
                                                                                   > IKFAST_EVALCOND_THRESH
                                                                            || IKabs(
                                                                                   evalcond
                                                                                       [3])
                                                                                   > IKFAST_EVALCOND_THRESH)
                                                                        {
                                                                          continue;
                                                                        }
                                                                      }

                                                                      rotationfunction0(
                                                                          solutions);
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                            else
                                                            {
                                                              {
                                                                IkReal
                                                                    j4array[1],
                                                                    cj4array[1],
                                                                    sj4array[1];
                                                                bool j4valid[1]
                                                                    = {false};
                                                                _nj4 = 1;
                                                                IkReal x1105
                                                                    = (cj9
                                                                       * px);
                                                                IkReal x1106
                                                                    = (cj9
                                                                       * py);
                                                                IkReal x1107
                                                                    = ((3.92156862745098)
                                                                       * pp);
                                                                IkReal x1108
                                                                    = ((0.045)
                                                                       * sj9);
                                                                CheckValue<IkReal> x1109 = IKPowWithIntegerCheck(
                                                                    IKsign((
                                                                        pp
                                                                        + (((-1.0)
                                                                            * (1.0)
                                                                            * (pz
                                                                               * pz))))),
                                                                    -1);
                                                                if (!x1109
                                                                         .valid)
                                                                {
                                                                  continue;
                                                                }
                                                                CheckValue<IkReal> x1110 = IKatan2WithCheck(
                                                                    IkReal((
                                                                        (((-1.0)
                                                                          * px
                                                                          * x1107))
                                                                        + ((py
                                                                            * x1108))
                                                                        + (((1.51009803921569)
                                                                            * px))
                                                                        + (((0.55)
                                                                            * py))
                                                                        + (((1.32323529411765)
                                                                            * x1105))
                                                                        + (((0.3)
                                                                            * x1106)))),
                                                                    ((((-1.32323529411765)
                                                                       * x1106))
                                                                     + (((-1.0)
                                                                         * (1.51009803921569)
                                                                         * py))
                                                                     + ((py
                                                                         * x1107))
                                                                     + (((0.55)
                                                                         * px))
                                                                     + ((px
                                                                         * x1108))
                                                                     + (((0.3)
                                                                         * x1105))),
                                                                    IKFAST_ATAN2_MAGTHRESH);
                                                                if (!x1110
                                                                         .valid)
                                                                {
                                                                  continue;
                                                                }
                                                                j4array[0]
                                                                    = ((-1.5707963267949)
                                                                       + (((1.5707963267949)
                                                                           * (x1109
                                                                                  .value)))
                                                                       + (x1110
                                                                              .value));
                                                                sj4array[0]
                                                                    = IKsin(
                                                                        j4array
                                                                            [0]);
                                                                cj4array[0]
                                                                    = IKcos(
                                                                        j4array
                                                                            [0]);
                                                                if (j4array[0]
                                                                    > IKPI)
                                                                {
                                                                  j4array[0]
                                                                      -= IK2PI;
                                                                }
                                                                else if (
                                                                    j4array[0]
                                                                    < -IKPI)
                                                                {
                                                                  j4array[0]
                                                                      += IK2PI;
                                                                }
                                                                j4valid[0]
                                                                    = true;
                                                                for (int ij4
                                                                     = 0;
                                                                     ij4 < 1;
                                                                     ++ij4)
                                                                {
                                                                  if (!j4valid
                                                                          [ij4])
                                                                  {
                                                                    continue;
                                                                  }
                                                                  _ij4[0] = ij4;
                                                                  _ij4[1] = -1;
                                                                  for (int iij4
                                                                       = ij4
                                                                         + 1;
                                                                       iij4 < 1;
                                                                       ++iij4)
                                                                  {
                                                                    if (j4valid
                                                                            [iij4]
                                                                        && IKabs(
                                                                               cj4array
                                                                                   [ij4]
                                                                               - cj4array
                                                                                   [iij4])
                                                                               < IKFAST_SOLUTION_THRESH
                                                                        && IKabs(
                                                                               sj4array
                                                                                   [ij4]
                                                                               - sj4array
                                                                                   [iij4])
                                                                               < IKFAST_SOLUTION_THRESH)
                                                                    {
                                                                      j4valid
                                                                          [iij4]
                                                                          = false;
                                                                      _ij4[1]
                                                                          = iij4;
                                                                      break;
                                                                    }
                                                                  }
                                                                  j4 = j4array
                                                                      [ij4];
                                                                  cj4 = cj4array
                                                                      [ij4];
                                                                  sj4 = sj4array
                                                                      [ij4];
                                                                  {
                                                                    IkReal
                                                                        evalcond
                                                                            [4];
                                                                    IkReal x1111
                                                                        = IKcos(
                                                                            j4);
                                                                    IkReal x1112
                                                                        = (px
                                                                           * x1111);
                                                                    IkReal x1113
                                                                        = IKsin(
                                                                            j4);
                                                                    IkReal x1114
                                                                        = (py
                                                                           * x1113);
                                                                    IkReal x1115
                                                                        = (px
                                                                           * x1113);
                                                                    IkReal x1116
                                                                        = (py
                                                                           * x1111);
                                                                    evalcond[0]
                                                                        = ((-0.55)
                                                                           + x1112
                                                                           + x1114
                                                                           + (((-1.0)
                                                                               * (0.3)
                                                                               * cj9))
                                                                           + (((-1.0)
                                                                               * (0.045)
                                                                               * sj9)));
                                                                    evalcond[1]
                                                                        = ((-1.51009803921569)
                                                                           + x1115
                                                                           + (((-1.0)
                                                                               * (1.32323529411765)
                                                                               * cj9))
                                                                           + (((-1.0)
                                                                               * x1116))
                                                                           + (((3.92156862745098)
                                                                               * pp)));
                                                                    evalcond[2]
                                                                        = ((0.316735294117647)
                                                                           + (((-1.0)
                                                                               * x1114))
                                                                           + (((0.108264705882353)
                                                                               * cj9))
                                                                           + (((0.588235294117647)
                                                                               * pp))
                                                                           + (((-1.0)
                                                                               * x1112)));
                                                                    evalcond[3]
                                                                        = ((-0.2125)
                                                                           + (((-0.09)
                                                                               * x1115))
                                                                           + (((1.1)
                                                                               * x1114))
                                                                           + (((1.1)
                                                                               * x1112))
                                                                           + (((-1.0)
                                                                               * (1.0)
                                                                               * pp))
                                                                           + (((0.09)
                                                                               * x1116)));
                                                                    if (IKabs(
                                                                            evalcond
                                                                                [0])
                                                                            > IKFAST_EVALCOND_THRESH
                                                                        || IKabs(
                                                                               evalcond
                                                                                   [1])
                                                                               > IKFAST_EVALCOND_THRESH
                                                                        || IKabs(
                                                                               evalcond
                                                                                   [2])
                                                                               > IKFAST_EVALCOND_THRESH
                                                                        || IKabs(
                                                                               evalcond
                                                                                   [3])
                                                                               > IKFAST_EVALCOND_THRESH)
                                                                    {
                                                                      continue;
                                                                    }
                                                                  }

                                                                  rotationfunction0(
                                                                      solutions);
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      } while (0);
                                                      if (bgotonextstatement)
                                                      {
                                                        bool bgotonextstatement
                                                            = true;
                                                        do
                                                        {
                                                          evalcond[0]
                                                              = ((-3.14159265358979)
                                                                 + (IKfmod(
                                                                     ((3.14159265358979)
                                                                      + (IKabs((
                                                                          (1.5707963267949)
                                                                          + j6)))),
                                                                     6.28318530717959)));
                                                          evalcond[1] = pz;
                                                          if (IKabs(evalcond[0])
                                                                  < 0.0000010000000000
                                                              && IKabs(evalcond
                                                                           [1])
                                                                     < 0.0000010000000000)
                                                          {
                                                            bgotonextstatement
                                                                = false;
                                                            {
                                                              IkReal j4eval[3];
                                                              sj8 = 1.0;
                                                              cj8 = 0;
                                                              j8 = 1.5707963267949;
                                                              sj6 = -1.0;
                                                              cj6 = 0;
                                                              j6 = -1.5707963267949;
                                                              IkReal x1117
                                                                  = (pp
                                                                     + (((-1.0)
                                                                         * (1.0)
                                                                         * (pz
                                                                            * pz))));
                                                              IkReal x1118
                                                                  = (cj9 * px);
                                                              IkReal x1119
                                                                  = (cj9 * py);
                                                              IkReal x1120
                                                                  = ((3.92156862745098)
                                                                     * pp);
                                                              IkReal x1121
                                                                  = ((0.045)
                                                                     * sj9);
                                                              j4eval[0] = x1117;
                                                              j4eval[1]
                                                                  = ((IKabs((
                                                                         (((-0.3)
                                                                           * x1119))
                                                                         + (((1.51009803921569)
                                                                             * px))
                                                                         + (((1.32323529411765)
                                                                             * x1118))
                                                                         + (((-1.0)
                                                                             * px
                                                                             * x1120))
                                                                         + (((-1.0)
                                                                             * py
                                                                             * x1121))
                                                                         + (((-1.0)
                                                                             * (0.55)
                                                                             * py)))))
                                                                     + (IKabs((
                                                                         (((-1.0)
                                                                           * px
                                                                           * x1121))
                                                                         + (((-1.0)
                                                                             * (0.55)
                                                                             * px))
                                                                         + (((-0.3)
                                                                             * x1118))
                                                                         + (((-1.0)
                                                                             * (1.51009803921569)
                                                                             * py))
                                                                         + ((py
                                                                             * x1120))
                                                                         + (((-1.32323529411765)
                                                                             * x1119))))));
                                                              j4eval[2]
                                                                  = IKsign(
                                                                      x1117);
                                                              if (IKabs(
                                                                      j4eval[0])
                                                                      < 0.0000010000000000
                                                                  || IKabs(
                                                                         j4eval
                                                                             [1])
                                                                         < 0.0000010000000000
                                                                  || IKabs(
                                                                         j4eval
                                                                             [2])
                                                                         < 0.0000010000000000)
                                                              {
                                                                {
                                                                  IkReal
                                                                      j4eval[3];
                                                                  sj8 = 1.0;
                                                                  cj8 = 0;
                                                                  j8 = 1.5707963267949;
                                                                  sj6 = -1.0;
                                                                  cj6 = 0;
                                                                  j6 = -1.5707963267949;
                                                                  IkReal x1122
                                                                      = (pp
                                                                         + (((-1.0)
                                                                             * (1.0)
                                                                             * (pz
                                                                                * pz))));
                                                                  IkReal x1123
                                                                      = (cj9
                                                                         * px);
                                                                  IkReal x1124
                                                                      = (cj9
                                                                         * py);
                                                                  IkReal x1125
                                                                      = (pp
                                                                         * px);
                                                                  IkReal x1126
                                                                      = (pp
                                                                         * py);
                                                                  j4eval[0]
                                                                      = x1122;
                                                                  j4eval[1]
                                                                      = ((IKabs((
                                                                             (((-0.108264705882353)
                                                                               * x1124))
                                                                             + (((1.51009803921569)
                                                                                 * px))
                                                                             + (((-1.0)
                                                                                 * (0.316735294117647)
                                                                                 * py))
                                                                             + (((-3.92156862745098)
                                                                                 * x1125))
                                                                             + (((-0.588235294117647)
                                                                                 * x1126))
                                                                             + (((1.32323529411765)
                                                                                 * x1123)))))
                                                                         + (IKabs((
                                                                             (((-0.108264705882353)
                                                                               * x1123))
                                                                             + (((-1.0)
                                                                                 * (1.51009803921569)
                                                                                 * py))
                                                                             + (((-1.0)
                                                                                 * (0.316735294117647)
                                                                                 * px))
                                                                             + (((-0.588235294117647)
                                                                                 * x1125))
                                                                             + (((3.92156862745098)
                                                                                 * x1126))
                                                                             + (((-1.32323529411765)
                                                                                 * x1124))))));
                                                                  j4eval[2]
                                                                      = IKsign(
                                                                          x1122);
                                                                  if (IKabs(
                                                                          j4eval
                                                                              [0])
                                                                          < 0.0000010000000000
                                                                      || IKabs(
                                                                             j4eval
                                                                                 [1])
                                                                             < 0.0000010000000000
                                                                      || IKabs(
                                                                             j4eval
                                                                                 [2])
                                                                             < 0.0000010000000000)
                                                                  {
                                                                    {
                                                                      IkReal j4eval
                                                                          [3];
                                                                      sj8 = 1.0;
                                                                      cj8 = 0;
                                                                      j8 = 1.5707963267949;
                                                                      sj6 = -1.0;
                                                                      cj6 = 0;
                                                                      j6 = -1.5707963267949;
                                                                      IkReal
                                                                          x1127
                                                                          = pz
                                                                            * pz;
                                                                      IkReal
                                                                          x1128
                                                                          = (cj9
                                                                             * px);
                                                                      IkReal
                                                                          x1129
                                                                          = (cj9
                                                                             * py);
                                                                      IkReal
                                                                          x1130
                                                                          = (pp
                                                                             * px);
                                                                      IkReal
                                                                          x1131
                                                                          = (pp
                                                                             * py);
                                                                      j4eval[0]
                                                                          = (x1127
                                                                             + (((-1.0)
                                                                                 * (1.0)
                                                                                 * pp)));
                                                                      j4eval[1] = IKsign((
                                                                          (((1.1)
                                                                            * x1127))
                                                                          + (((-1.0)
                                                                              * (1.1)
                                                                              * pp))));
                                                                      j4eval[2]
                                                                          = ((IKabs((
                                                                                 (((0.348408823529412)
                                                                                   * px))
                                                                                 + (((1.66110784313725)
                                                                                     * py))
                                                                                 + (((0.119091176470588)
                                                                                     * x1128))
                                                                                 + (((0.647058823529412)
                                                                                     * x1130))
                                                                                 + (((1.45555882352941)
                                                                                     * x1129))
                                                                                 + (((-4.31372549019608)
                                                                                     * x1131)))))
                                                                             + (IKabs((
                                                                                 (((0.647058823529412)
                                                                                   * x1131))
                                                                                 + (((0.348408823529412)
                                                                                     * py))
                                                                                 + (((0.119091176470588)
                                                                                     * x1129))
                                                                                 + (((4.31372549019608)
                                                                                     * x1130))
                                                                                 + (((-1.0)
                                                                                     * (1.66110784313725)
                                                                                     * px))
                                                                                 + (((-1.45555882352941)
                                                                                     * x1128))))));
                                                                      if (IKabs(
                                                                              j4eval
                                                                                  [0])
                                                                              < 0.0000010000000000
                                                                          || IKabs(
                                                                                 j4eval
                                                                                     [1])
                                                                                 < 0.0000010000000000
                                                                          || IKabs(
                                                                                 j4eval
                                                                                     [2])
                                                                                 < 0.0000010000000000)
                                                                      {
                                                                        {
                                                                          IkReal evalcond
                                                                              [6];
                                                                          bool
                                                                              bgotonextstatement
                                                                              = true;
                                                                          do
                                                                          {
                                                                            IkReal
                                                                                x1132
                                                                                = ((-1.51009803921569)
                                                                                   + (((-1.0)
                                                                                       * (1.32323529411765)
                                                                                       * cj9))
                                                                                   + (((3.92156862745098)
                                                                                       * pp)));
                                                                            evalcond
                                                                                [0]
                                                                                = ((IKabs(
                                                                                       py))
                                                                                   + (IKabs(
                                                                                       px)));
                                                                            evalcond
                                                                                [1]
                                                                                = ((-0.55)
                                                                                   + (((-1.0)
                                                                                       * (0.3)
                                                                                       * cj9))
                                                                                   + (((-1.0)
                                                                                       * (0.045)
                                                                                       * sj9)));
                                                                            evalcond
                                                                                [2]
                                                                                = x1132;
                                                                            evalcond
                                                                                [3]
                                                                                = x1132;
                                                                            evalcond
                                                                                [4]
                                                                                = ((-0.316735294117647)
                                                                                   + (((-1.0)
                                                                                       * (0.588235294117647)
                                                                                       * pp))
                                                                                   + (((-1.0)
                                                                                       * (0.108264705882353)
                                                                                       * cj9)));
                                                                            evalcond
                                                                                [5]
                                                                                = ((-0.2125)
                                                                                   + (((-1.0)
                                                                                       * (1.0)
                                                                                       * pp)));
                                                                            if (IKabs(
                                                                                    evalcond
                                                                                        [0])
                                                                                    < 0.0000010000000000
                                                                                && IKabs(
                                                                                       evalcond
                                                                                           [1])
                                                                                       < 0.0000010000000000
                                                                                && IKabs(
                                                                                       evalcond
                                                                                           [2])
                                                                                       < 0.0000010000000000
                                                                                && IKabs(
                                                                                       evalcond
                                                                                           [3])
                                                                                       < 0.0000010000000000
                                                                                && IKabs(
                                                                                       evalcond
                                                                                           [4])
                                                                                       < 0.0000010000000000
                                                                                && IKabs(
                                                                                       evalcond
                                                                                           [5])
                                                                                       < 0.0000010000000000)
                                                                            {
                                                                              bgotonextstatement
                                                                                  = false;
                                                                              {
                                                                                IkReal j4array
                                                                                    [4],
                                                                                    cj4array
                                                                                        [4],
                                                                                    sj4array
                                                                                        [4];
                                                                                bool j4valid
                                                                                    [4]
                                                                                    = {false};
                                                                                _nj4
                                                                                    = 4;
                                                                                j4array
                                                                                    [0]
                                                                                    = 0;
                                                                                sj4array
                                                                                    [0]
                                                                                    = IKsin(
                                                                                        j4array
                                                                                            [0]);
                                                                                cj4array
                                                                                    [0]
                                                                                    = IKcos(
                                                                                        j4array
                                                                                            [0]);
                                                                                j4array
                                                                                    [1]
                                                                                    = 1.5707963267949;
                                                                                sj4array
                                                                                    [1]
                                                                                    = IKsin(
                                                                                        j4array
                                                                                            [1]);
                                                                                cj4array
                                                                                    [1]
                                                                                    = IKcos(
                                                                                        j4array
                                                                                            [1]);
                                                                                j4array
                                                                                    [2]
                                                                                    = 3.14159265358979;
                                                                                sj4array
                                                                                    [2]
                                                                                    = IKsin(
                                                                                        j4array
                                                                                            [2]);
                                                                                cj4array
                                                                                    [2]
                                                                                    = IKcos(
                                                                                        j4array
                                                                                            [2]);
                                                                                j4array
                                                                                    [3]
                                                                                    = -1.5707963267949;
                                                                                sj4array
                                                                                    [3]
                                                                                    = IKsin(
                                                                                        j4array
                                                                                            [3]);
                                                                                cj4array
                                                                                    [3]
                                                                                    = IKcos(
                                                                                        j4array
                                                                                            [3]);
                                                                                if (j4array
                                                                                        [0]
                                                                                    > IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [0]
                                                                                      -= IK2PI;
                                                                                }
                                                                                else if (
                                                                                    j4array
                                                                                        [0]
                                                                                    < -IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [0]
                                                                                      += IK2PI;
                                                                                }
                                                                                j4valid
                                                                                    [0]
                                                                                    = true;
                                                                                if (j4array
                                                                                        [1]
                                                                                    > IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [1]
                                                                                      -= IK2PI;
                                                                                }
                                                                                else if (
                                                                                    j4array
                                                                                        [1]
                                                                                    < -IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [1]
                                                                                      += IK2PI;
                                                                                }
                                                                                j4valid
                                                                                    [1]
                                                                                    = true;
                                                                                if (j4array
                                                                                        [2]
                                                                                    > IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [2]
                                                                                      -= IK2PI;
                                                                                }
                                                                                else if (
                                                                                    j4array
                                                                                        [2]
                                                                                    < -IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [2]
                                                                                      += IK2PI;
                                                                                }
                                                                                j4valid
                                                                                    [2]
                                                                                    = true;
                                                                                if (j4array
                                                                                        [3]
                                                                                    > IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [3]
                                                                                      -= IK2PI;
                                                                                }
                                                                                else if (
                                                                                    j4array
                                                                                        [3]
                                                                                    < -IKPI)
                                                                                {
                                                                                  j4array
                                                                                      [3]
                                                                                      += IK2PI;
                                                                                }
                                                                                j4valid
                                                                                    [3]
                                                                                    = true;
                                                                                for (
                                                                                    int ij4
                                                                                    = 0;
                                                                                    ij4
                                                                                    < 4;
                                                                                    ++ij4)
                                                                                {
                                                                                  if (!j4valid
                                                                                          [ij4])
                                                                                  {
                                                                                    continue;
                                                                                  }
                                                                                  _ij4[0]
                                                                                      = ij4;
                                                                                  _ij4[1]
                                                                                      = -1;
                                                                                  for (
                                                                                      int iij4
                                                                                      = ij4
                                                                                        + 1;
                                                                                      iij4
                                                                                      < 4;
                                                                                      ++iij4)
                                                                                  {
                                                                                    if (j4valid
                                                                                            [iij4]
                                                                                        && IKabs(
                                                                                               cj4array
                                                                                                   [ij4]
                                                                                               - cj4array
                                                                                                   [iij4])
                                                                                               < IKFAST_SOLUTION_THRESH
                                                                                        && IKabs(
                                                                                               sj4array
                                                                                                   [ij4]
                                                                                               - sj4array
                                                                                                   [iij4])
                                                                                               < IKFAST_SOLUTION_THRESH)
                                                                                    {
                                                                                      j4valid
                                                                                          [iij4]
                                                                                          = false;
                                                                                      _ij4[1]
                                                                                          = iij4;
                                                                                      break;
                                                                                    }
                                                                                  }
                                                                                  j4 = j4array
                                                                                      [ij4];
                                                                                  cj4 = cj4array
                                                                                      [ij4];
                                                                                  sj4 = sj4array
                                                                                      [ij4];

                                                                                  rotationfunction0(
                                                                                      solutions);
                                                                                }
                                                                              }
                                                                            }
                                                                          } while (
                                                                              0);
                                                                          if (bgotonextstatement)
                                                                          {
                                                                            bool
                                                                                bgotonextstatement
                                                                                = true;
                                                                            do
                                                                            {
                                                                              if (1)
                                                                              {
                                                                                bgotonextstatement
                                                                                    = false;
                                                                                continue; // branch miss [j4]
                                                                              }
                                                                            } while (
                                                                                0);
                                                                            if (bgotonextstatement)
                                                                            {
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                      else
                                                                      {
                                                                        {
                                                                          IkReal j4array
                                                                              [1],
                                                                              cj4array
                                                                                  [1],
                                                                              sj4array
                                                                                  [1];
                                                                          bool j4valid
                                                                              [1]
                                                                              = {false};
                                                                          _nj4
                                                                              = 1;
                                                                          IkReal
                                                                              x1133
                                                                              = (cj9
                                                                                 * px);
                                                                          IkReal
                                                                              x1134
                                                                              = (cj9
                                                                                 * py);
                                                                          IkReal
                                                                              x1135
                                                                              = (pp
                                                                                 * px);
                                                                          IkReal
                                                                              x1136
                                                                              = (pp
                                                                                 * py);
                                                                          CheckValue<IkReal> x1137 = IKatan2WithCheck(
                                                                              IkReal((
                                                                                  (((4.31372549019608)
                                                                                    * x1135))
                                                                                  + (((-1.45555882352941)
                                                                                      * x1133))
                                                                                  + (((0.348408823529412)
                                                                                      * py))
                                                                                  + (((0.119091176470588)
                                                                                      * x1134))
                                                                                  + (((-1.0)
                                                                                      * (1.66110784313725)
                                                                                      * px))
                                                                                  + (((0.647058823529412)
                                                                                      * x1136)))),
                                                                              ((((0.348408823529412)
                                                                                 * px))
                                                                               + (((0.119091176470588)
                                                                                   * x1133))
                                                                               + (((1.66110784313725)
                                                                                   * py))
                                                                               + (((1.45555882352941)
                                                                                   * x1134))
                                                                               + (((-4.31372549019608)
                                                                                   * x1136))
                                                                               + (((0.647058823529412)
                                                                                   * x1135))),
                                                                              IKFAST_ATAN2_MAGTHRESH);
                                                                          if (!x1137
                                                                                   .valid)
                                                                          {
                                                                            continue;
                                                                          }
                                                                          CheckValue<IkReal> x1138 = IKPowWithIntegerCheck(
                                                                              IKsign((
                                                                                  (((1.1)
                                                                                    * (pz
                                                                                       * pz)))
                                                                                  + (((-1.0)
                                                                                      * (1.1)
                                                                                      * pp)))),
                                                                              -1);
                                                                          if (!x1138
                                                                                   .valid)
                                                                          {
                                                                            continue;
                                                                          }
                                                                          j4array
                                                                              [0]
                                                                              = ((-1.5707963267949)
                                                                                 + (x1137
                                                                                        .value)
                                                                                 + (((1.5707963267949)
                                                                                     * (x1138
                                                                                            .value))));
                                                                          sj4array
                                                                              [0]
                                                                              = IKsin(
                                                                                  j4array
                                                                                      [0]);
                                                                          cj4array
                                                                              [0]
                                                                              = IKcos(
                                                                                  j4array
                                                                                      [0]);
                                                                          if (j4array
                                                                                  [0]
                                                                              > IKPI)
                                                                          {
                                                                            j4array
                                                                                [0]
                                                                                -= IK2PI;
                                                                          }
                                                                          else if (
                                                                              j4array
                                                                                  [0]
                                                                              < -IKPI)
                                                                          {
                                                                            j4array
                                                                                [0]
                                                                                += IK2PI;
                                                                          }
                                                                          j4valid
                                                                              [0]
                                                                              = true;
                                                                          for (
                                                                              int ij4
                                                                              = 0;
                                                                              ij4
                                                                              < 1;
                                                                              ++ij4)
                                                                          {
                                                                            if (!j4valid
                                                                                    [ij4])
                                                                            {
                                                                              continue;
                                                                            }
                                                                            _ij4[0]
                                                                                = ij4;
                                                                            _ij4[1]
                                                                                = -1;
                                                                            for (
                                                                                int iij4
                                                                                = ij4
                                                                                  + 1;
                                                                                iij4
                                                                                < 1;
                                                                                ++iij4)
                                                                            {
                                                                              if (j4valid
                                                                                      [iij4]
                                                                                  && IKabs(
                                                                                         cj4array
                                                                                             [ij4]
                                                                                         - cj4array
                                                                                             [iij4])
                                                                                         < IKFAST_SOLUTION_THRESH
                                                                                  && IKabs(
                                                                                         sj4array
                                                                                             [ij4]
                                                                                         - sj4array
                                                                                             [iij4])
                                                                                         < IKFAST_SOLUTION_THRESH)
                                                                              {
                                                                                j4valid
                                                                                    [iij4]
                                                                                    = false;
                                                                                _ij4[1]
                                                                                    = iij4;
                                                                                break;
                                                                              }
                                                                            }
                                                                            j4 = j4array
                                                                                [ij4];
                                                                            cj4 = cj4array
                                                                                [ij4];
                                                                            sj4 = sj4array
                                                                                [ij4];
                                                                            {
                                                                              IkReal evalcond
                                                                                  [4];
                                                                              IkReal
                                                                                  x1139
                                                                                  = IKsin(
                                                                                      j4);
                                                                              IkReal
                                                                                  x1140
                                                                                  = (px
                                                                                     * x1139);
                                                                              IkReal
                                                                                  x1141
                                                                                  = IKcos(
                                                                                      j4);
                                                                              IkReal
                                                                                  x1142
                                                                                  = (py
                                                                                     * x1141);
                                                                              IkReal
                                                                                  x1143
                                                                                  = (px
                                                                                     * x1141);
                                                                              IkReal
                                                                                  x1144
                                                                                  = (py
                                                                                     * x1139);
                                                                              IkReal
                                                                                  x1145
                                                                                  = ((((-1.0)
                                                                                       * x1144))
                                                                                     + (((-1.0)
                                                                                         * x1143)));
                                                                              evalcond
                                                                                  [0]
                                                                                  = ((-1.51009803921569)
                                                                                     + (((-1.0)
                                                                                         * (1.32323529411765)
                                                                                         * cj9))
                                                                                     + x1140
                                                                                     + (((3.92156862745098)
                                                                                         * pp))
                                                                                     + (((-1.0)
                                                                                         * x1142)));
                                                                              evalcond
                                                                                  [1]
                                                                                  = ((-0.55)
                                                                                     + x1145
                                                                                     + (((-1.0)
                                                                                         * (0.3)
                                                                                         * cj9))
                                                                                     + (((-1.0)
                                                                                         * (0.045)
                                                                                         * sj9)));
                                                                              evalcond
                                                                                  [2]
                                                                                  = ((-0.316735294117647)
                                                                                     + x1145
                                                                                     + (((-1.0)
                                                                                         * (0.588235294117647)
                                                                                         * pp))
                                                                                     + (((-1.0)
                                                                                         * (0.108264705882353)
                                                                                         * cj9)));
                                                                              evalcond
                                                                                  [3]
                                                                                  = ((-0.2125)
                                                                                     + (((-0.09)
                                                                                         * x1140))
                                                                                     + (((-1.1)
                                                                                         * x1144))
                                                                                     + (((-1.1)
                                                                                         * x1143))
                                                                                     + (((0.09)
                                                                                         * x1142))
                                                                                     + (((-1.0)
                                                                                         * (1.0)
                                                                                         * pp)));
                                                                              if (IKabs(
                                                                                      evalcond
                                                                                          [0])
                                                                                      > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [1])
                                                                                         > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [2])
                                                                                         > IKFAST_EVALCOND_THRESH
                                                                                  || IKabs(
                                                                                         evalcond
                                                                                             [3])
                                                                                         > IKFAST_EVALCOND_THRESH)
                                                                              {
                                                                                continue;
                                                                              }
                                                                            }

                                                                            rotationfunction0(
                                                                                solutions);
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                  else
                                                                  {
                                                                    {
                                                                      IkReal j4array
                                                                          [1],
                                                                          cj4array
                                                                              [1],
                                                                          sj4array
                                                                              [1];
                                                                      bool j4valid
                                                                          [1]
                                                                          = {false};
                                                                      _nj4 = 1;
                                                                      IkReal
                                                                          x1146
                                                                          = (cj9
                                                                             * px);
                                                                      IkReal
                                                                          x1147
                                                                          = (cj9
                                                                             * py);
                                                                      IkReal
                                                                          x1148
                                                                          = (pp
                                                                             * px);
                                                                      IkReal
                                                                          x1149
                                                                          = (pp
                                                                             * py);
                                                                      CheckValue<IkReal> x1150 = IKatan2WithCheck(
                                                                          IkReal((
                                                                              (((1.51009803921569)
                                                                                * px))
                                                                              + (((-1.0)
                                                                                  * (0.316735294117647)
                                                                                  * py))
                                                                              + (((-0.108264705882353)
                                                                                  * x1147))
                                                                              + (((-0.588235294117647)
                                                                                  * x1149))
                                                                              + (((1.32323529411765)
                                                                                  * x1146))
                                                                              + (((-3.92156862745098)
                                                                                  * x1148)))),
                                                                          ((((-0.108264705882353)
                                                                             * x1146))
                                                                           + (((-1.32323529411765)
                                                                               * x1147))
                                                                           + (((3.92156862745098)
                                                                               * x1149))
                                                                           + (((-1.0)
                                                                               * (1.51009803921569)
                                                                               * py))
                                                                           + (((-1.0)
                                                                               * (0.316735294117647)
                                                                               * px))
                                                                           + (((-0.588235294117647)
                                                                               * x1148))),
                                                                          IKFAST_ATAN2_MAGTHRESH);
                                                                      if (!x1150
                                                                               .valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      CheckValue<IkReal> x1151 = IKPowWithIntegerCheck(
                                                                          IKsign((
                                                                              pp
                                                                              + (((-1.0)
                                                                                  * (1.0)
                                                                                  * (pz
                                                                                     * pz))))),
                                                                          -1);
                                                                      if (!x1151
                                                                               .valid)
                                                                      {
                                                                        continue;
                                                                      }
                                                                      j4array[0]
                                                                          = ((-1.5707963267949)
                                                                             + (x1150
                                                                                    .value)
                                                                             + (((1.5707963267949)
                                                                                 * (x1151
                                                                                        .value))));
                                                                      sj4array[0] = IKsin(
                                                                          j4array
                                                                              [0]);
                                                                      cj4array[0] = IKcos(
                                                                          j4array
                                                                              [0]);
                                                                      if (j4array
                                                                              [0]
                                                                          > IKPI)
                                                                      {
                                                                        j4array
                                                                            [0]
                                                                            -= IK2PI;
                                                                      }
                                                                      else if (
                                                                          j4array
                                                                              [0]
                                                                          < -IKPI)
                                                                      {
                                                                        j4array
                                                                            [0]
                                                                            += IK2PI;
                                                                      }
                                                                      j4valid[0]
                                                                          = true;
                                                                      for (
                                                                          int ij4
                                                                          = 0;
                                                                          ij4
                                                                          < 1;
                                                                          ++ij4)
                                                                      {
                                                                        if (!j4valid
                                                                                [ij4])
                                                                        {
                                                                          continue;
                                                                        }
                                                                        _ij4[0]
                                                                            = ij4;
                                                                        _ij4[1]
                                                                            = -1;
                                                                        for (
                                                                            int iij4
                                                                            = ij4
                                                                              + 1;
                                                                            iij4
                                                                            < 1;
                                                                            ++iij4)
                                                                        {
                                                                          if (j4valid
                                                                                  [iij4]
                                                                              && IKabs(
                                                                                     cj4array
                                                                                         [ij4]
                                                                                     - cj4array
                                                                                         [iij4])
                                                                                     < IKFAST_SOLUTION_THRESH
                                                                              && IKabs(
                                                                                     sj4array
                                                                                         [ij4]
                                                                                     - sj4array
                                                                                         [iij4])
                                                                                     < IKFAST_SOLUTION_THRESH)
                                                                          {
                                                                            j4valid
                                                                                [iij4]
                                                                                = false;
                                                                            _ij4[1]
                                                                                = iij4;
                                                                            break;
                                                                          }
                                                                        }
                                                                        j4 = j4array
                                                                            [ij4];
                                                                        cj4 = cj4array
                                                                            [ij4];
                                                                        sj4 = sj4array
                                                                            [ij4];
                                                                        {
                                                                          IkReal evalcond
                                                                              [4];
                                                                          IkReal
                                                                              x1152
                                                                              = IKsin(
                                                                                  j4);
                                                                          IkReal
                                                                              x1153
                                                                              = (px
                                                                                 * x1152);
                                                                          IkReal
                                                                              x1154
                                                                              = IKcos(
                                                                                  j4);
                                                                          IkReal
                                                                              x1155
                                                                              = (py
                                                                                 * x1154);
                                                                          IkReal
                                                                              x1156
                                                                              = (px
                                                                                 * x1154);
                                                                          IkReal
                                                                              x1157
                                                                              = (py
                                                                                 * x1152);
                                                                          IkReal
                                                                              x1158
                                                                              = ((((-1.0)
                                                                                   * x1156))
                                                                                 + (((-1.0)
                                                                                     * x1157)));
                                                                          evalcond
                                                                              [0]
                                                                              = ((-1.51009803921569)
                                                                                 + (((-1.0)
                                                                                     * x1155))
                                                                                 + x1153
                                                                                 + (((-1.0)
                                                                                     * (1.32323529411765)
                                                                                     * cj9))
                                                                                 + (((3.92156862745098)
                                                                                     * pp)));
                                                                          evalcond
                                                                              [1]
                                                                              = ((-0.55)
                                                                                 + x1158
                                                                                 + (((-1.0)
                                                                                     * (0.3)
                                                                                     * cj9))
                                                                                 + (((-1.0)
                                                                                     * (0.045)
                                                                                     * sj9)));
                                                                          evalcond
                                                                              [2]
                                                                              = ((-0.316735294117647)
                                                                                 + x1158
                                                                                 + (((-1.0)
                                                                                     * (0.588235294117647)
                                                                                     * pp))
                                                                                 + (((-1.0)
                                                                                     * (0.108264705882353)
                                                                                     * cj9)));
                                                                          evalcond
                                                                              [3]
                                                                              = ((-0.2125)
                                                                                 + (((-1.1)
                                                                                     * x1156))
                                                                                 + (((-1.1)
                                                                                     * x1157))
                                                                                 + (((-0.09)
                                                                                     * x1153))
                                                                                 + (((-1.0)
                                                                                     * (1.0)
                                                                                     * pp))
                                                                                 + (((0.09)
                                                                                     * x1155)));
                                                                          if (IKabs(
                                                                                  evalcond
                                                                                      [0])
                                                                                  > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [1])
                                                                                     > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [2])
                                                                                     > IKFAST_EVALCOND_THRESH
                                                                              || IKabs(
                                                                                     evalcond
                                                                                         [3])
                                                                                     > IKFAST_EVALCOND_THRESH)
                                                                          {
                                                                            continue;
                                                                          }
                                                                        }

                                                                        rotationfunction0(
                                                                            solutions);
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                              else
                                                              {
                                                                {
                                                                  IkReal j4array
                                                                      [1],
                                                                      cj4array
                                                                          [1],
                                                                      sj4array
                                                                          [1];
                                                                  bool
                                                                      j4valid[1]
                                                                      = {false};
                                                                  _nj4 = 1;
                                                                  IkReal x1159
                                                                      = (cj9
                                                                         * px);
                                                                  IkReal x1160
                                                                      = (cj9
                                                                         * py);
                                                                  IkReal x1161
                                                                      = ((3.92156862745098)
                                                                         * pp);
                                                                  IkReal x1162
                                                                      = ((0.045)
                                                                         * sj9);
                                                                  CheckValue<IkReal> x1163 = IKPowWithIntegerCheck(
                                                                      IKsign((
                                                                          pp
                                                                          + (((-1.0)
                                                                              * (1.0)
                                                                              * (pz
                                                                                 * pz))))),
                                                                      -1);
                                                                  if (!x1163
                                                                           .valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  CheckValue<IkReal> x1164 = IKatan2WithCheck(
                                                                      IkReal((
                                                                          (((-0.3)
                                                                            * x1160))
                                                                          + (((1.51009803921569)
                                                                              * px))
                                                                          + (((-1.0)
                                                                              * py
                                                                              * x1162))
                                                                          + (((-1.0)
                                                                              * px
                                                                              * x1161))
                                                                          + (((1.32323529411765)
                                                                              * x1159))
                                                                          + (((-1.0)
                                                                              * (0.55)
                                                                              * py)))),
                                                                      ((((-1.0)
                                                                         * (0.55)
                                                                         * px))
                                                                       + (((-1.32323529411765)
                                                                           * x1160))
                                                                       + (((-1.0)
                                                                           * (1.51009803921569)
                                                                           * py))
                                                                       + (((-0.3)
                                                                           * x1159))
                                                                       + ((py
                                                                           * x1161))
                                                                       + (((-1.0)
                                                                           * px
                                                                           * x1162))),
                                                                      IKFAST_ATAN2_MAGTHRESH);
                                                                  if (!x1164
                                                                           .valid)
                                                                  {
                                                                    continue;
                                                                  }
                                                                  j4array[0]
                                                                      = ((-1.5707963267949)
                                                                         + (((1.5707963267949)
                                                                             * (x1163
                                                                                    .value)))
                                                                         + (x1164
                                                                                .value));
                                                                  sj4array[0]
                                                                      = IKsin(
                                                                          j4array
                                                                              [0]);
                                                                  cj4array[0]
                                                                      = IKcos(
                                                                          j4array
                                                                              [0]);
                                                                  if (j4array[0]
                                                                      > IKPI)
                                                                  {
                                                                    j4array[0]
                                                                        -= IK2PI;
                                                                  }
                                                                  else if (
                                                                      j4array[0]
                                                                      < -IKPI)
                                                                  {
                                                                    j4array[0]
                                                                        += IK2PI;
                                                                  }
                                                                  j4valid[0]
                                                                      = true;
                                                                  for (int ij4
                                                                       = 0;
                                                                       ij4 < 1;
                                                                       ++ij4)
                                                                  {
                                                                    if (!j4valid
                                                                            [ij4])
                                                                    {
                                                                      continue;
                                                                    }
                                                                    _ij4[0]
                                                                        = ij4;
                                                                    _ij4[1]
                                                                        = -1;
                                                                    for (
                                                                        int iij4
                                                                        = ij4
                                                                          + 1;
                                                                        iij4
                                                                        < 1;
                                                                        ++iij4)
                                                                    {
                                                                      if (j4valid
                                                                              [iij4]
                                                                          && IKabs(
                                                                                 cj4array
                                                                                     [ij4]
                                                                                 - cj4array
                                                                                     [iij4])
                                                                                 < IKFAST_SOLUTION_THRESH
                                                                          && IKabs(
                                                                                 sj4array
                                                                                     [ij4]
                                                                                 - sj4array
                                                                                     [iij4])
                                                                                 < IKFAST_SOLUTION_THRESH)
                                                                      {
                                                                        j4valid
                                                                            [iij4]
                                                                            = false;
                                                                        _ij4[1]
                                                                            = iij4;
                                                                        break;
                                                                      }
                                                                    }
                                                                    j4 = j4array
                                                                        [ij4];
                                                                    cj4 = cj4array
                                                                        [ij4];
                                                                    sj4 = sj4array
                                                                        [ij4];
                                                                    {
                                                                      IkReal evalcond
                                                                          [4];
                                                                      IkReal
                                                                          x1165
                                                                          = IKsin(
                                                                              j4);
                                                                      IkReal
                                                                          x1166
                                                                          = (px
                                                                             * x1165);
                                                                      IkReal
                                                                          x1167
                                                                          = IKcos(
                                                                              j4);
                                                                      IkReal
                                                                          x1168
                                                                          = (py
                                                                             * x1167);
                                                                      IkReal
                                                                          x1169
                                                                          = (px
                                                                             * x1167);
                                                                      IkReal
                                                                          x1170
                                                                          = (py
                                                                             * x1165);
                                                                      IkReal
                                                                          x1171
                                                                          = ((((-1.0)
                                                                               * x1169))
                                                                             + (((-1.0)
                                                                                 * x1170)));
                                                                      evalcond
                                                                          [0]
                                                                          = ((-1.51009803921569)
                                                                             + (((-1.0)
                                                                                 * (1.32323529411765)
                                                                                 * cj9))
                                                                             + (((-1.0)
                                                                                 * x1168))
                                                                             + (((3.92156862745098)
                                                                                 * pp))
                                                                             + x1166);
                                                                      evalcond
                                                                          [1]
                                                                          = ((-0.55)
                                                                             + (((-1.0)
                                                                                 * (0.3)
                                                                                 * cj9))
                                                                             + x1171
                                                                             + (((-1.0)
                                                                                 * (0.045)
                                                                                 * sj9)));
                                                                      evalcond
                                                                          [2]
                                                                          = ((-0.316735294117647)
                                                                             + (((-1.0)
                                                                                 * (0.588235294117647)
                                                                                 * pp))
                                                                             + (((-1.0)
                                                                                 * (0.108264705882353)
                                                                                 * cj9))
                                                                             + x1171);
                                                                      evalcond
                                                                          [3]
                                                                          = ((-0.2125)
                                                                             + (((-1.1)
                                                                                 * x1170))
                                                                             + (((-1.1)
                                                                                 * x1169))
                                                                             + (((0.09)
                                                                                 * x1168))
                                                                             + (((-0.09)
                                                                                 * x1166))
                                                                             + (((-1.0)
                                                                                 * (1.0)
                                                                                 * pp)));
                                                                      if (IKabs(
                                                                              evalcond
                                                                                  [0])
                                                                              > IKFAST_EVALCOND_THRESH
                                                                          || IKabs(
                                                                                 evalcond
                                                                                     [1])
                                                                                 > IKFAST_EVALCOND_THRESH
                                                                          || IKabs(
                                                                                 evalcond
                                                                                     [2])
                                                                                 > IKFAST_EVALCOND_THRESH
                                                                          || IKabs(
                                                                                 evalcond
                                                                                     [3])
                                                                                 > IKFAST_EVALCOND_THRESH)
                                                                      {
                                                                        continue;
                                                                      }
                                                                    }

                                                                    rotationfunction0(
                                                                        solutions);
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        } while (0);
                                                        if (bgotonextstatement)
                                                        {
                                                          bool
                                                              bgotonextstatement
                                                              = true;
                                                          do
                                                          {
                                                            IkReal x1172
                                                                = (cj6 * pz);
                                                            IkReal x1173
                                                                = ((-1.51009803921569)
                                                                   + (((-1.0)
                                                                       * (1.32323529411765)
                                                                       * cj9))
                                                                   + (((3.92156862745098)
                                                                       * pp)));
                                                            evalcond[0]
                                                                = ((IKabs(py))
                                                                   + (IKabs(
                                                                       px)));
                                                            evalcond[1]
                                                                = ((-0.55)
                                                                   + (((-1.0)
                                                                       * (0.3)
                                                                       * cj9))
                                                                   + x1172
                                                                   + (((-1.0)
                                                                       * (0.045)
                                                                       * sj9)));
                                                            evalcond[2] = x1173;
                                                            evalcond[3]
                                                                = ((-1.0)
                                                                   * (((1.0)
                                                                       * pz
                                                                       * sj6)));
                                                            evalcond[4] = x1173;
                                                            evalcond[5]
                                                                = ((((0.108264705882353)
                                                                     * cj9
                                                                     * sj6))
                                                                   + (((0.588235294117647)
                                                                       * pp
                                                                       * sj6))
                                                                   + (((0.316735294117647)
                                                                       * sj6)));
                                                            evalcond[6]
                                                                = ((-0.2125)
                                                                   + (((1.1)
                                                                       * x1172))
                                                                   + (((-1.0)
                                                                       * (1.0)
                                                                       * pp)));
                                                            if (IKabs(
                                                                    evalcond[0])
                                                                    < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [1])
                                                                       < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [2])
                                                                       < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [3])
                                                                       < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [4])
                                                                       < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [5])
                                                                       < 0.0000010000000000
                                                                && IKabs(
                                                                       evalcond
                                                                           [6])
                                                                       < 0.0000010000000000)
                                                            {
                                                              bgotonextstatement
                                                                  = false;
                                                              {
                                                                IkReal
                                                                    j4array[4],
                                                                    cj4array[4],
                                                                    sj4array[4];
                                                                bool j4valid[4]
                                                                    = {false};
                                                                _nj4 = 4;
                                                                j4array[0] = 0;
                                                                sj4array[0]
                                                                    = IKsin(
                                                                        j4array
                                                                            [0]);
                                                                cj4array[0]
                                                                    = IKcos(
                                                                        j4array
                                                                            [0]);
                                                                j4array[1]
                                                                    = 1.5707963267949;
                                                                sj4array[1]
                                                                    = IKsin(
                                                                        j4array
                                                                            [1]);
                                                                cj4array[1]
                                                                    = IKcos(
                                                                        j4array
                                                                            [1]);
                                                                j4array[2]
                                                                    = 3.14159265358979;
                                                                sj4array[2]
                                                                    = IKsin(
                                                                        j4array
                                                                            [2]);
                                                                cj4array[2]
                                                                    = IKcos(
                                                                        j4array
                                                                            [2]);
                                                                j4array[3]
                                                                    = -1.5707963267949;
                                                                sj4array[3]
                                                                    = IKsin(
                                                                        j4array
                                                                            [3]);
                                                                cj4array[3]
                                                                    = IKcos(
                                                                        j4array
                                                                            [3]);
                                                                if (j4array[0]
                                                                    > IKPI)
                                                                {
                                                                  j4array[0]
                                                                      -= IK2PI;
                                                                }
                                                                else if (
                                                                    j4array[0]
                                                                    < -IKPI)
                                                                {
                                                                  j4array[0]
                                                                      += IK2PI;
                                                                }
                                                                j4valid[0]
                                                                    = true;
                                                                if (j4array[1]
                                                                    > IKPI)
                                                                {
                                                                  j4array[1]
                                                                      -= IK2PI;
                                                                }
                                                                else if (
                                                                    j4array[1]
                                                                    < -IKPI)
                                                                {
                                                                  j4array[1]
                                                                      += IK2PI;
                                                                }
                                                                j4valid[1]
                                                                    = true;
                                                                if (j4array[2]
                                                                    > IKPI)
                                                                {
                                                                  j4array[2]
                                                                      -= IK2PI;
                                                                }
                                                                else if (
                                                                    j4array[2]
                                                                    < -IKPI)
                                                                {
                                                                  j4array[2]
                                                                      += IK2PI;
                                                                }
                                                                j4valid[2]
                                                                    = true;
                                                                if (j4array[3]
                                                                    > IKPI)
                                                                {
                                                                  j4array[3]
                                                                      -= IK2PI;
                                                                }
                                                                else if (
                                                                    j4array[3]
                                                                    < -IKPI)
                                                                {
                                                                  j4array[3]
                                                                      += IK2PI;
                                                                }
                                                                j4valid[3]
                                                                    = true;
                                                                for (int ij4
                                                                     = 0;
                                                                     ij4 < 4;
                                                                     ++ij4)
                                                                {
                                                                  if (!j4valid
                                                                          [ij4])
                                                                  {
                                                                    continue;
                                                                  }
                                                                  _ij4[0] = ij4;
                                                                  _ij4[1] = -1;
                                                                  for (int iij4
                                                                       = ij4
                                                                         + 1;
                                                                       iij4 < 4;
                                                                       ++iij4)
                                                                  {
                                                                    if (j4valid
                                                                            [iij4]
                                                                        && IKabs(
                                                                               cj4array
                                                                                   [ij4]
                                                                               - cj4array
                                                                                   [iij4])
                                                                               < IKFAST_SOLUTION_THRESH
                                                                        && IKabs(
                                                                               sj4array
                                                                                   [ij4]
                                                                               - sj4array
                                                                                   [iij4])
                                                                               < IKFAST_SOLUTION_THRESH)
                                                                    {
                                                                      j4valid
                                                                          [iij4]
                                                                          = false;
                                                                      _ij4[1]
                                                                          = iij4;
                                                                      break;
                                                                    }
                                                                  }
                                                                  j4 = j4array
                                                                      [ij4];
                                                                  cj4 = cj4array
                                                                      [ij4];
                                                                  sj4 = sj4array
                                                                      [ij4];

                                                                  rotationfunction0(
                                                                      solutions);
                                                                }
                                     