//
// C++ Interface: inputbuffer
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@linux.nu>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef RPCINPUTBUFFER_H
#define RPCINPUTBUFFER_H

#include <boost/scoped_array.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/utility.hpp>

namespace rpc
{

/**
	@author Rikard Bjorklind <olof@linux.nu>
*/
template<typename T>
class InputBuffer : private boost::noncopyable
{
public:
    explicit InputBuffer(int aSize) : size( aSize ), buf( new char[size] ), p( buf.get() )
    {
    }
	
    T* bufPtr()
    {
        return (T*)buf.get();
    }
	
    T* curPtr()
    {
        return reinterpret_cast<T*>(p);
    }
	
    void advance(int bytes)
    {
        p += bytes;
    }
	
    bool filled() const
    {
        return p == ( buf.get() + size );
    }
	
	int remaining() const
	{
		return ( buf.get() + size ) - p;
	}
	
	/**
	 * Reset the pointer to the next data item.
	 */
	void reset()
	{
		// Reset the pointer so that we start at the begining of the buffer
		p = buf.get();
	}
	
    ~InputBuffer()
    {
    }
	
	int getSize() const {return size;}

private:
    const int size;
	boost::scoped_array<char> buf;
    char* p;  // points to the next free place
};

typedef boost::shared_ptr< InputBuffer<char> > CmdInputBufferPtr;

}

#endif
