//
// C++ Interface: globalusermodel
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GLOBALUSERMODEL_H
#define GLOBALUSERMODEL_H

#include <QObject>
#include <QHash>
#include "user.h"

/**
	Keeps a record of all users.
	Needed for easy access by all components who deals with users at some point.
	TODO: how are we going to clean this list when user objects are released in the backend?
*/
class GlobalUserModel : public QObject
{
    Q_OBJECT
public:
    GlobalUserModel(QObject *parent = 0);
    ~GlobalUserModel();

	User* getUser(int id);
	
public slots:
    void usersUpdated(int,QList<User*>);
	void userRemoved(int,int);
	void sessionInfo(int,const QString&,const QString&,const QList<User*>);
	
private:
	QHash<int,User*> userMap;
};

#endif
