/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/client-go/applyconfigurations/core/v1"
)

// ClusterCIDRSpecApplyConfiguration represents an declarative configuration of the ClusterCIDRSpec type for use
// with apply.
type ClusterCIDRSpecApplyConfiguration struct {
	NodeSelector    *v1.NodeSelectorApplyConfiguration `json:"nodeSelector,omitempty"`
	PerNodeHostBits *int32                             `json:"perNodeHostBits,omitempty"`
	IPv4            *string                            `json:"ipv4,omitempty"`
	IPv6            *string                            `json:"ipv6,omitempty"`
}

// ClusterCIDRSpecApplyConfiguration constructs an declarative configuration of the ClusterCIDRSpec type for use with
// apply.
func ClusterCIDRSpec() *ClusterCIDRSpecApplyConfiguration {
	return &ClusterCIDRSpecApplyConfiguration{}
}

// WithNodeSelector sets the NodeSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeSelector field is set to the value of the last call.
func (b *ClusterCIDRSpecApplyConfiguration) WithNodeSelector(value *v1.NodeSelectorApplyConfiguration) *ClusterCIDRSpecApplyConfiguration {
	b.NodeSelector = value
	return b
}

// WithPerNodeHostBits sets the PerNodeHostBits field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PerNodeHostBits field is set to the value of the last call.
func (b *ClusterCIDRSpecApplyConfiguration) WithPerNodeHostBits(value int32) *ClusterCIDRSpecApplyConfiguration {
	b.PerNodeHostBits = &value
	return b
}

// WithIPv4 sets the IPv4 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IPv4 field is set to the value of the last call.
func (b *ClusterCIDRSpecApplyConfiguration) WithIPv4(value string) *ClusterCIDRSpecApplyConfiguration {
	b.IPv4 = &value
	return b
}

// WithIPv6 sets the IPv6 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IPv6 field is set to the value of the last call.
func (b *ClusterCIDRSpecApplyConfiguration) WithIPv6(value string) *ClusterCIDRSpecApplyConfiguration {
	b.IPv6 = &value
	return b
}
