/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QDir>
#include <QFile>
#include <QMenu>
#include <QPainter>
#include <QSettings>
#include <QFileDialog>
#include <QGraphicsView>

#include "ddesktopwidget.h"
#include "ui_applicationPropertiesWindow.h"

ddesktopwidget::ddesktopwidget(void):QGraphicsScene()
{
  QSettings settings;

  if(settings.contains("desktopBackground"))
    backgroundImageFileName = settings.value("desktopBackground").toString();
  else
    {
      QDir currentDir(QDir::currentPath());

      backgroundImageFileName = QString
	("%1/Images/doobledesktop_background_ublue.png").arg
	(currentDir.path());
      settings.setValue("desktopBackground", backgroundImageFileName);
    }
}

ddesktopwidget::~ddesktopwidget()
{
}

void ddesktopwidget::drawBackground(QPainter *painter, const QRectF &rect)
{
  /*
  ** Attempt to determine the background image's format.
  */

  char bytes[10];
  QFile file(backgroundImageFileName);
  qint64 bytesRead = 0;
  QString imageFormat("");

  (void) memset(bytes, 0, sizeof(bytes));

  if(file.open(QIODevice::ReadOnly) && (bytesRead =
					file.read(bytes, sizeof(bytes))) > 0)
    {
      if(bytesRead >= 4 && bytes[1] == 'P' && bytes[2] == 'N' &&
	 bytes[3] == 'G')
	imageFormat = "png";
      else if(bytesRead >= 10 && bytes[6] == 'J' && bytes[7] == 'F' &&
	      bytes[8] == 'I' && bytes[9] == 'F')
	imageFormat = "jpg";
      else if(bytesRead >= 2 && bytes[0] == 'B' && bytes[1] == 'M')
	imageFormat = "bmp";
    }

  file.close();

  if(imageFormat.isEmpty())
    {
      QString ext("");

      if(backgroundImageFileName.contains("."))
	ext = backgroundImageFileName.mid
	  (backgroundImageFileName.lastIndexOf(".") + 1);

      if(ext.isEmpty())
	imageFormat = "jpg";
      else
	imageFormat = ext;
    }

  QImage image(backgroundImageFileName, imageFormat.toAscii().data());

  painter->drawImage(rect, image);

  QSettings settings;

  settings.setValue("desktopBackground", backgroundImageFileName);

  int i = 0;
  bool imageFound = false;
  QStringList allKeys(settings.allKeys());

  for(i = 0; i < allKeys.size(); i++)
    if(allKeys[i].startsWith("settingsWindow/backgroundImage"))
      if(settings.value(allKeys[i]).toString().trimmed() ==
	 backgroundImageFileName)
	{
	  imageFound = true;
	  break;
	}

  allKeys.clear();

  if(!imageFound)
    settings.setValue(QString("settingsWindow/backgroundImage%1").arg(i),
		      backgroundImageFileName);
}

void ddesktopwidget::contextMenuEvent
(QGraphicsSceneContextMenuEvent *contextMenuEvent)
{
  contextMenuEvent->accept();

  QMenu menu;

  menu.addAction(tr("&Add Application Icon"),
		 this, SLOT(slotAddApplicationIcon(void)));
  menu.addSeparator();
  menu.addAction(tr("&Change Desktop Background"),
		 this, SLOT(slotChangeDesktopBackground(void)));
  menu.exec(QCursor::pos());
}

void ddesktopwidget::slotChangeDesktopBackground(void)
{
  QDir currentDir(QDir::currentPath());
  QFileDialog fileDialog(parentWindow());

  fileDialog.setWindowTitle(tr("Dooble Web Browser: Desktop "
			       "Background Image Selection"));
  fileDialog.setFileMode(QFileDialog::ExistingFile);
  fileDialog.setLabelText(QFileDialog::Accept, tr("&Select"));
  currentDir.cd("Images");
  fileDialog.setDirectory(currentDir.path());

  if(fileDialog.exec() == QDialog::Accepted)
    {
      backgroundImageFileName = fileDialog.selectedFiles()[0];

      for(int i = 0; i < views().size(); i++)
	views().at(i)->resetCachedContent();
    }
}

void ddesktopwidget::slotBackgroundImageChanged(void)
{
  QSettings settings;

  if(settings.contains("desktopBackground"))
    {
      backgroundImageFileName = settings.value("desktopBackground").toString();

      for(int i = 0; i < views().size(); i++)
	views().at(i)->resetCachedContent();
    }
}

QWidget *ddesktopwidget::parentWindow(void)
{
  QWidget *parent = 0;

  for(int i = 0; i < views().size(); i++)
    if(views().at(i)->isActiveWindow())
      {
	/*
	** Find the window parent.
	*/

	parent = views().at(i)->parentWidget();

	while(parent && parent->windowType() != Qt::Window)
	  parent = parent->parentWidget();
	    
	break;
      }

  if(!parent)
    {
      parent = views().at(0)->parentWidget();

      while(parent && parent->windowType() != Qt::Window)
	parent = parent->parentWidget();
    }

  return parent;
}

void ddesktopwidget::slotAddApplicationIcon(void)
{
  int X = 0;
  int Y = 0;
  QPoint p(0, 0);
  QDialog *propertiesDialog = 0;
  QWidget *parent = parentWindow();
  QSettings settings;
  QSettings cfgSettings(settings.value("iconSet").toString(),
			QSettings::IniFormat);
  Ui_applicationPropertiesWindow propertiesUI;

  propertiesDialog = new QDialog(parent);
  propertiesDialog->setWindowIcon
    (QIcon(cfgSettings.value("propertiesDialog/windowIcon").toString()));
  propertiesUI.setupUi(propertiesDialog);
  p = parent->pos();

  if(parent->width() >= propertiesDialog->width())
    X = p.x() + parent->width() / 2 - propertiesDialog->width() / 2;
  else
    X = p.x() - (propertiesDialog->width() / 2 - parent->width() / 2);

  if(parent->height() >= propertiesDialog->height())
    Y = p.y() + parent->height() / 2 - propertiesDialog->height() / 2;
  else
    Y = p.y() - (propertiesDialog->height() / 2 - parent->height() / 2);

  connect(propertiesUI.buttonBox, SIGNAL(accepted(void)), this,
	  SLOT(slotOK(void)));
  propertiesDialog->move(X, Y);
  propertiesDialog->show();
}

void ddesktopwidget::slotOK(void)
{
}
