﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 6 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>
#nullable enable

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net60
{
    public partial class Net60GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.String[]>? _StringArray;
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.String[]> StringArray
        {
            get
            {
                if (_StringArray == null)
                {
                    global::System.Text.Json.Serialization.JsonConverter? customConverter;
                    if (Options.Converters.Count > 0 && (customConverter = GetRuntimeProvidedCustomConverter(typeof(global::System.String[]))) != null)
                    {
                        _StringArray = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateValueInfo<global::System.String[]>(Options, customConverter);
                    }
                    else
                    {
                        global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.String[]> info = new global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.String[]>()
                            {
                                ObjectCreator = null,
                                KeyInfo = null,
                                ElementInfo = this.String,
                                NumberHandling = default,
                                SerializeHandler = StringArraySerializeHandler
                            };
            
                            _StringArray = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateArrayInfo<global::System.String>(Options, info);
            
                    }
                }
        
                return _StringArray;
            }
        }
        
        private static void StringArraySerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.String[]? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
        
            writer.WriteStartArray();
        
            for (int i = 0; i < value.Length; i++)
            {
                writer.WriteStringValue(value[i]);
            }
        
            writer.WriteEndArray();
        }
    }
}
