﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 8 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>

#nullable enable annotations
#nullable disable warnings

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0612, CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net80
{
    public partial class Net80GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs>? _WeatherForecastWithPOCOs;
        
        /// <summary>
        /// Defines the source generated JSON serialization contract metadata for a given type.
        /// </summary>
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs> WeatherForecastWithPOCOs
        {
            get => _WeatherForecastWithPOCOs ??= (global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs>)Options.GetTypeInfo(typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs));
        }
        
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs> Create_WeatherForecastWithPOCOs(global::System.Text.Json.JsonSerializerOptions options)
        {
            if (!TryGetTypeInfoForRuntimeCustomConverter<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs>(options, out global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs> jsonTypeInfo))
            {
                var objectInfo = new global::System.Text.Json.Serialization.Metadata.JsonObjectInfoValues<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs>
                {
                    ObjectCreator = () => new global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs(),
                    ObjectWithParameterizedConstructorCreator = null,
                    PropertyMetadataInitializer = _ => WeatherForecastWithPOCOsPropInit(options),
                    ConstructorParameterMetadataInitializer = null,
                    SerializeHandler = WeatherForecastWithPOCOsSerializeHandler
                };
                
                jsonTypeInfo = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateObjectInfo<global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs>(options, objectInfo);
                jsonTypeInfo.NumberHandling = null;
            }
        
            jsonTypeInfo.OriginatingResolver = this;
            return jsonTypeInfo;
        }

        private static global::System.Text.Json.Serialization.Metadata.JsonPropertyInfo[] WeatherForecastWithPOCOsPropInit(global::System.Text.Json.JsonSerializerOptions options)
        {
            var properties = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfo[7];

            var info0 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<global::System.DateTimeOffset>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).Date,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).Date = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "Date",
                JsonPropertyName = null
            };
            
            properties[0] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<global::System.DateTimeOffset>(options, info0);

            var info1 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<int>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).TemperatureCelsius,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).TemperatureCelsius = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "TemperatureCelsius",
                JsonPropertyName = null
            };
            
            properties[1] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<int>(options, info1);

            var info2 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<string>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).Summary,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).Summary = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "Summary",
                JsonPropertyName = null
            };
            
            properties[2] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<string>(options, info2);

            var info3 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<global::System.Collections.Generic.List<global::System.DateTimeOffset>>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).DatesAvailable,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).DatesAvailable = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "DatesAvailable",
                JsonPropertyName = null
            };
            
            properties[3] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<global::System.Collections.Generic.List<global::System.DateTimeOffset>>(options, info3);

            var info4 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).TemperatureRanges,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).TemperatureRanges = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "TemperatureRanges",
                JsonPropertyName = null
            };
            
            properties[4] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>(options, info4);

            var info5 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<string[]>
            {
                IsProperty = true,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).SummaryWords,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).SummaryWords = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "SummaryWords",
                JsonPropertyName = null
            };
            
            properties[5] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<string[]>(options, info5);

            var info6 = new global::System.Text.Json.Serialization.Metadata.JsonPropertyInfoValues<string>
            {
                IsProperty = false,
                IsPublic = true,
                IsVirtual = false,
                DeclaringType = typeof(global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs),
                Converter = null,
                Getter = static obj => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).SummaryField,
                Setter = static (obj, value) => ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)obj).SummaryField = value!,
                IgnoreCondition = null,
                HasJsonInclude = false,
                IsExtensionData = false,
                NumberHandling = null,
                PropertyName = "SummaryField",
                JsonPropertyName = null
            };
            
            properties[6] = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreatePropertyInfo<string>(options, info6);

            return properties;
        }

        // Intentionally not a static method because we create a delegate to it. Invoking delegates to instance
        // methods is almost as fast as virtual calls. Static methods need to go through a shuffle thunk.
        private void WeatherForecastWithPOCOsSerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
            
            writer.WriteStartObject();

            writer.WriteString(PropName_Date, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).Date);
            writer.WriteNumber(PropName_TemperatureCelsius, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).TemperatureCelsius);
            writer.WriteString(PropName_Summary, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).Summary);
            writer.WritePropertyName(PropName_DatesAvailable);
            ListDateTimeOffsetSerializeHandler(writer, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).DatesAvailable);
            writer.WritePropertyName(PropName_TemperatureRanges);
            DictionaryStringHighLowTempsSerializeHandler(writer, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).TemperatureRanges);
            writer.WritePropertyName(PropName_SummaryWords);
            StringArraySerializeHandler(writer, ((global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.WeatherForecastWithPOCOs)value).SummaryWords);

            writer.WriteEndObject();
        }
    }
}
