﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace Microsoft.TemplateEngine.Abstractions.Installer
{
    /// <summary>
    /// Provides information about detected vulnerabilities for a particular severity.
    /// </summary>
    /// <param name="Severity">Represents level of detected vulnerability: 3 stands for critical, 0 for low.</param>
    /// <param name="AdvisoryUris">Link to vulnerability info.</param>
    public readonly record struct VulnerabilityInfo(int Severity, IReadOnlyList<string> AdvisoryUris);
}
