## RS1041: Compiler extensions should be implemented in assemblies targeting netstandard2.0

Types which implement compiler extension points should only be declared in assemblies targeting netstandard2.0. More specific target frameworks are only available in a subset of supported compilation scenarios, so targeting them may cause the feature to behave unpredictably.

|Item|Value|
|-|-|
|Category|MicrosoftCodeAnalysisCorrectness|
|Enabled|True|
|Severity|Warning|
|CodeFix|False|
---

This rule helps ensure compiler extensions (e.g. analyzers and source generators) will load correctly in all compilation
scenarios. Depending on the manner in which the compiler is invoked, the compiler may execute under .NET Framework or
.NET, and compiler extensions are expected to work consistently in both cases. By targeting netstandard2.0, compiler
extensions are known to be compatible with both execution environments.

### Compiler extension points

The following compiler extension points are examined by this analyzer:

* `DiagnosticAnalyzer`
* `DiagnosticSuppressor`
* `ISourceGenerator`
* `IIncrementalGenerator`
