// A Bison parser, made by GNU Bison 3.3.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2019 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// Undocumented macros, especially those whose name start with YY_,
// are private implementation details.  Do not rely on them.





#include "Parser.hh"


// Unqualified %code blocks.
#line 48 "Parser.yy" // lalr1.cc:435

#include "Driver.hh"

/* this "connects" the bison parser in the driver to the flex scanner class
 * object. it defines the yylex() function call to pull the next token from the
 * current lexer object of the driver context. */
#undef yylex
#define yylex driver.lexer->lex


#line 56 "Parser.cc" // lalr1.cc:435


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Suppress unused-variable warnings by "using" E.
#define YYUSE(E) ((void) (E))

// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yystack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 25 "Parser.yy" // lalr1.cc:510
namespace Tokenizer {
#line 151 "Parser.cc" // lalr1.cc:510

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }


  /// Build a parser object.
  parser::parser (macro::Driver &driver_yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      driver (driver_yyarg)
  {}

  parser::~parser ()
  {}

  parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------------.
  | Symbol types.  |
  `---------------*/

  // basic_symbol.
#if 201103L <= YY_CPLUSPLUS
  template <typename Base>
  parser::basic_symbol<Base>::basic_symbol (basic_symbol&& that)
    : Base (std::move (that))
    , value ()
    , location (std::move (that.location))
  {
    switch (this->type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.move< DirectivePtr > (std::move (that.value));
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.move< ExpressionPtr > (std::move (that.value));
        break;

      case 120: // function
        value.move< FunctionPtr > (std::move (that.value));
        break;

      case 119: // symbol
        value.move< VariablePtr > (std::move (that.value));
        break;

      case 114: // elseif
      case 116: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (std::move (that.value));
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.move< string > (std::move (that.value));
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (std::move (that.value));
        break;

      case 111: // if_list
      case 112: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (std::move (that.value));
        break;

      case 100: // name_list
        value.move< vector<string> > (std::move (that.value));
        break;

      default:
        break;
    }

  }
#endif

  template <typename Base>
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
    , location (that.location)
  {
    switch (this->type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.copy< DirectivePtr > (YY_MOVE (that.value));
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.copy< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case 120: // function
        value.copy< FunctionPtr > (YY_MOVE (that.value));
        break;

      case 119: // symbol
        value.copy< VariablePtr > (YY_MOVE (that.value));
        break;

      case 114: // elseif
      case 116: // else
        value.copy< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.copy< string > (YY_MOVE (that.value));
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.copy< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case 111: // if_list
      case 112: // if_list1
        value.copy< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case 100: // name_list
        value.copy< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }



  template <typename Base>
  bool
  parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return Base::type_get () == empty_symbol;
  }

  template <typename Base>
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.move< DirectivePtr > (YY_MOVE (s.value));
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.move< ExpressionPtr > (YY_MOVE (s.value));
        break;

      case 120: // function
        value.move< FunctionPtr > (YY_MOVE (s.value));
        break;

      case 119: // symbol
        value.move< VariablePtr > (YY_MOVE (s.value));
        break;

      case 114: // elseif
      case 116: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (s.value));
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.move< string > (YY_MOVE (s.value));
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (YY_MOVE (s.value));
        break;

      case 111: // if_list
      case 112: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (s.value));
        break;

      case 100: // name_list
        value.move< vector<string> > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

    location = YY_MOVE (s.location);
  }

  // by_type.
  parser::by_type::by_type ()
    : type (empty_symbol)
  {}

#if 201103L <= YY_CPLUSPLUS
  parser::by_type::by_type (by_type&& that)
    : type (that.type)
  {
    that.clear ();
  }
#endif

  parser::by_type::by_type (const by_type& that)
    : type (that.type)
  {}

  parser::by_type::by_type (token_type t)
    : type (yytranslate_ (t))
  {}

  void
  parser::by_type::clear ()
  {
    type = empty_symbol;
  }

  void
  parser::by_type::move (by_type& that)
  {
    type = that.type;
    that.clear ();
  }

  int
  parser::by_type::type_get () const YY_NOEXCEPT
  {
    return type;
  }


  // by_state.
  parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  parser::symbol_number_type
  parser::by_state::type_get () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return empty_symbol;
    else
      return yystos_[state];
  }

  parser::stack_symbol_type::stack_symbol_type ()
  {}

  parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.YY_MOVE_OR_COPY< DirectivePtr > (YY_MOVE (that.value));
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.YY_MOVE_OR_COPY< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case 120: // function
        value.YY_MOVE_OR_COPY< FunctionPtr > (YY_MOVE (that.value));
        break;

      case 119: // symbol
        value.YY_MOVE_OR_COPY< VariablePtr > (YY_MOVE (that.value));
        break;

      case 114: // elseif
      case 116: // else
        value.YY_MOVE_OR_COPY< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.YY_MOVE_OR_COPY< string > (YY_MOVE (that.value));
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.YY_MOVE_OR_COPY< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case 111: // if_list
      case 112: // if_list1
        value.YY_MOVE_OR_COPY< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case 100: // name_list
        value.YY_MOVE_OR_COPY< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.move< DirectivePtr > (YY_MOVE (that.value));
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.move< ExpressionPtr > (YY_MOVE (that.value));
        break;

      case 120: // function
        value.move< FunctionPtr > (YY_MOVE (that.value));
        break;

      case 119: // symbol
        value.move< VariablePtr > (YY_MOVE (that.value));
        break;

      case 114: // elseif
      case 116: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (YY_MOVE (that.value));
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.move< string > (YY_MOVE (that.value));
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (YY_MOVE (that.value));
        break;

      case 111: // if_list
      case 112: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (YY_MOVE (that.value));
        break;

      case 100: // name_list
        value.move< vector<string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.type = empty_symbol;
  }

#if YY_CPLUSPLUS < 201103L
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.type_get ())
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        value.move< DirectivePtr > (that.value);
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        value.move< ExpressionPtr > (that.value);
        break;

      case 120: // function
        value.move< FunctionPtr > (that.value);
        break;

      case 119: // symbol
        value.move< VariablePtr > (that.value);
        break;

      case 114: // elseif
      case 116: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (that.value);
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        value.move< string > (that.value);
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (that.value);
        break;

      case 111: // if_list
      case 112: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (that.value);
        break;

      case 100: // name_list
        value.move< vector<string> > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo,
                                     const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    symbol_number_type yytype = yysym.type_get ();
#if defined __GNUC__ && ! defined __clang__ && ! defined __ICC && __GNUC__ * 100 + __GNUC_MINOR__ <= 408
    // Avoid a (spurious) G++ 4.8 warning about "array subscript is
    // below array bounds".
    if (yysym.empty ())
      std::abort ();
#endif
    yyo << (yytype < yyntokens_ ? "token" : "nterm")
        << ' ' << yytname_[yytype] << " ("
        << yysym.location << ": ";
    YYUSE (yytype);
    yyo << ')';
  }
#endif

  void
  parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  parser::yypop_ (int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - yyntokens_] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - yyntokens_];
  }

  bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::operator() ()
  {
    return parse ();
  }

  int
  parser::parse ()
  {
    // State.
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    // User initialization code.
#line 38 "Parser.yy" // lalr1.cc:788
{
  // Initialize the location filenames
  yyla.location.begin.filename = yyla.location.end.filename = &driver.file;
}

#line 881 "Parser.cc" // lalr1.cc:788

    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << yystack_[0].state << '\n';

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token: ";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.type = yytranslate_ (yylex (&yyla.value, &yyla.location, driver));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.type_get ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.type_get ())
      goto yydefault;

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", yyn, YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case 97: // statement
      case 98: // directive
      case 99: // directive_one_line
      case 101: // directive_multiline
      case 103: // for
      case 105: // if
      case 107: // ifdef
      case 109: // ifndef
      case 117: // text
      case 118: // eval
        yylhs.value.emplace< DirectivePtr > ();
        break;

      case 102: // for_when
      case 124: // primary_expr
      case 125: // oper_expr
      case 126: // colon_expr
      case 127: // expr
        yylhs.value.emplace< ExpressionPtr > ();
        break;

      case 120: // function
        yylhs.value.emplace< FunctionPtr > ();
        break;

      case 119: // symbol
        yylhs.value.emplace< VariablePtr > ();
        break;

      case 114: // elseif
      case 116: // else
        yylhs.value.emplace< pair<ExpressionPtr, vector<DirectivePtr>> > ();
        break;

      case 90: // NAME
      case 91: // TEXT
      case 92: // QUOTED_STRING
      case 93: // NUMBER
      case 94: // EOL
        yylhs.value.emplace< string > ();
        break;

      case 121: // function_args
      case 122: // comma_expr
      case 123: // tuple_comma_expr
        yylhs.value.emplace< vector<ExpressionPtr> > ();
        break;

      case 111: // if_list
      case 112: // if_list1
        yylhs.value.emplace< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
        break;

      case 100: // name_list
        yylhs.value.emplace< vector<string> > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2:
#line 110 "Parser.yy" // lalr1.cc:919
    {
               driver.inContext() ? driver.pushContextTop(yystack_[0].value.as < DirectivePtr > ()) : driver.pushStatements(yystack_[0].value.as < DirectivePtr > ());
             }
#line 1063 "Parser.cc" // lalr1.cc:919
    break;

  case 3:
#line 114 "Parser.yy" // lalr1.cc:919
    {
               driver.inContext() ? driver.pushContextTop(yystack_[0].value.as < DirectivePtr > ()) : driver.pushStatements(yystack_[0].value.as < DirectivePtr > ());
             }
#line 1071 "Parser.cc" // lalr1.cc:919
    break;

  case 4:
#line 119 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1077 "Parser.cc" // lalr1.cc:919
    break;

  case 5:
#line 120 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1083 "Parser.cc" // lalr1.cc:919
    break;

  case 6:
#line 121 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1089 "Parser.cc" // lalr1.cc:919
    break;

  case 7:
#line 124 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[1].value.as < DirectivePtr > (); }
#line 1095 "Parser.cc" // lalr1.cc:919
    break;

  case 8:
#line 125 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[1].value.as < DirectivePtr > (); }
#line 1101 "Parser.cc" // lalr1.cc:919
    break;

  case 9:
#line 129 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Include>(yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1107 "Parser.cc" // lalr1.cc:919
    break;

  case 10:
#line 131 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<IncludePath>(yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1113 "Parser.cc" // lalr1.cc:919
    break;

  case 11:
#line 133 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Define>(yystack_[2].value.as < VariablePtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1119 "Parser.cc" // lalr1.cc:919
    break;

  case 12:
#line 135 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Define>(yystack_[2].value.as < FunctionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1125 "Parser.cc" // lalr1.cc:919
    break;

  case 13:
#line 137 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Echo>(yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1131 "Parser.cc" // lalr1.cc:919
    break;

  case 14:
#line 139 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Error>(yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1137 "Parser.cc" // lalr1.cc:919
    break;

  case 15:
#line 141 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(false, driver.env, yylhs.location); }
#line 1143 "Parser.cc" // lalr1.cc:919
    break;

  case 16:
#line 143 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(false, yystack_[0].value.as < vector<string> > (), driver.env, yylhs.location); }
#line 1149 "Parser.cc" // lalr1.cc:919
    break;

  case 17:
#line 145 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(true, driver.env, yylhs.location); }
#line 1155 "Parser.cc" // lalr1.cc:919
    break;

  case 18:
#line 147 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<EchoMacroVars>(true, yystack_[0].value.as < vector<string> > (), driver.env, yylhs.location); }
#line 1161 "Parser.cc" // lalr1.cc:919
    break;

  case 19:
#line 149 "Parser.yy" // lalr1.cc:919
    {
                       // `@#line` is ignored; adjust newlines in output to accord
                       auto l = static_cast<Tokenizer::parser::location_type>(yylhs.location);
                       yylhs.value.as < DirectivePtr > () = make_shared<TextNode>(string(l.end.line - l.begin.line + 1, '\n'), driver.env, yylhs.location);
                     }
#line 1171 "Parser.cc" // lalr1.cc:919
    break;

  case 20:
#line 157 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<string> > () = vector<string>{yystack_[0].value.as < string > ()}; }
#line 1177 "Parser.cc" // lalr1.cc:919
    break;

  case 21:
#line 159 "Parser.yy" // lalr1.cc:919
    {
              yystack_[1].value.as < vector<string> > ().emplace_back(yystack_[0].value.as < string > ());
              yylhs.value.as < vector<string> > () = yystack_[1].value.as < vector<string> > ();
            }
#line 1186 "Parser.cc" // lalr1.cc:919
    break;

  case 22:
#line 165 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1192 "Parser.cc" // lalr1.cc:919
    break;

  case 23:
#line 166 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1198 "Parser.cc" // lalr1.cc:919
    break;

  case 24:
#line 167 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1204 "Parser.cc" // lalr1.cc:919
    break;

  case 25:
#line 168 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = yystack_[0].value.as < DirectivePtr > (); }
#line 1210 "Parser.cc" // lalr1.cc:919
    break;

  case 26:
#line 172 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = shared_ptr<Expression>(); }
#line 1216 "Parser.cc" // lalr1.cc:919
    break;

  case 27:
#line 174 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1222 "Parser.cc" // lalr1.cc:919
    break;

  case 28:
#line 177 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1228 "Parser.cc" // lalr1.cc:919
    break;

  case 29:
#line 178 "Parser.yy" // lalr1.cc:919
    {
        vector<VariablePtr> vvnp;
        auto tmpt = dynamic_pointer_cast<Tuple>(yystack_[6].value.as < ExpressionPtr > ());
        auto tmpv = dynamic_pointer_cast<Variable>(yystack_[6].value.as < ExpressionPtr > ());
        if (tmpv)
          vvnp.emplace_back(tmpv);
        else if (tmpt)
          for (const auto & it : tmpt->getValue())
            {
              auto vnp = dynamic_pointer_cast<Variable>(it);
              if (!vnp)
                error(yylhs.location, "For loop indices must be variables");
              vvnp.emplace_back(vnp);
            }
        else
          error(yystack_[8].location, "For loop indices must be a variable or a tuple");

        auto vdp = driver.popContext();
        vdp.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));

        if (!yystack_[3].value.as < ExpressionPtr > ())
          yylhs.value.as < DirectivePtr > () = make_shared<For>(vvnp, yystack_[4].value.as < ExpressionPtr > (), vdp, driver.env, yylhs.location);
        else
          {
            auto tmpc = make_shared<Comprehension>(true, yystack_[6].value.as < ExpressionPtr > (), yystack_[4].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), driver.env, yystack_[3].location);
            yylhs.value.as < DirectivePtr > () = make_shared<For>(vvnp, tmpc, vdp, driver.env, yylhs.location);
          }
      }
#line 1261 "Parser.cc" // lalr1.cc:919
    break;

  case 30:
#line 208 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1267 "Parser.cc" // lalr1.cc:919
    break;

  case 31:
#line 209 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<If>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), driver.env, yylhs.location); }
#line 1273 "Parser.cc" // lalr1.cc:919
    break;

  case 32:
#line 212 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1279 "Parser.cc" // lalr1.cc:919
    break;

  case 33:
#line 213 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Ifdef>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), driver.env, yylhs.location); }
#line 1285 "Parser.cc" // lalr1.cc:919
    break;

  case 34:
#line 216 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1291 "Parser.cc" // lalr1.cc:919
    break;

  case 35:
#line 217 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Ifndef>(yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (), driver.env, yylhs.location); }
#line 1297 "Parser.cc" // lalr1.cc:919
    break;

  case 36:
#line 220 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[0].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (); }
#line 1303 "Parser.cc" // lalr1.cc:919
    break;

  case 37:
#line 222 "Parser.yy" // lalr1.cc:919
    {
            yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ().emplace_back(yystack_[0].value.as < pair<ExpressionPtr, vector<DirectivePtr>> > ());
            yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
          }
#line 1312 "Parser.cc" // lalr1.cc:919
    break;

  case 38:
#line 229 "Parser.yy" // lalr1.cc:919
    {
             auto context = driver.popContext();
             context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = vector<pair<ExpressionPtr, vector<DirectivePtr>>> {{yystack_[1].value.as < ExpressionPtr > (), context}};
           }
#line 1322 "Parser.cc" // lalr1.cc:919
    break;

  case 39:
#line 235 "Parser.yy" // lalr1.cc:919
    {
             auto context = driver.popContext();
             context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = vector<pair<ExpressionPtr, vector<DirectivePtr>>> {{yystack_[2].value.as < ExpressionPtr > (), context}};
           }
#line 1332 "Parser.cc" // lalr1.cc:919
    break;

  case 40:
#line 241 "Parser.yy" // lalr1.cc:919
    {
             yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ().emplace_back(yystack_[0].value.as < pair<ExpressionPtr, vector<DirectivePtr>> > ());
             yylhs.value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > () = yystack_[1].value.as < vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
           }
#line 1341 "Parser.cc" // lalr1.cc:919
    break;

  case 41:
#line 247 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1347 "Parser.cc" // lalr1.cc:919
    break;

  case 42:
#line 250 "Parser.yy" // lalr1.cc:919
    {
           auto context = driver.popContext();
           context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
           yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {yystack_[1].value.as < ExpressionPtr > (), context};
         }
#line 1357 "Parser.cc" // lalr1.cc:919
    break;

  case 43:
#line 256 "Parser.yy" // lalr1.cc:919
    {
           auto context = driver.popContext();
           context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
           yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {yystack_[2].value.as < ExpressionPtr > (), context};
         }
#line 1367 "Parser.cc" // lalr1.cc:919
    break;

  case 44:
#line 263 "Parser.yy" // lalr1.cc:919
    { driver.pushContext(); }
#line 1373 "Parser.cc" // lalr1.cc:919
    break;

  case 45:
#line 266 "Parser.yy" // lalr1.cc:919
    {
         auto context = driver.popContext();
         context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
         yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {make_shared<Bool>(true, driver.env, yystack_[1].location), context};
       }
#line 1383 "Parser.cc" // lalr1.cc:919
    break;

  case 46:
#line 272 "Parser.yy" // lalr1.cc:919
    {
         auto context = driver.popContext();
         context.emplace_back(make_shared<TextNode>("\n", driver.env, yystack_[0].location));
         yylhs.value.as < pair<ExpressionPtr, vector<DirectivePtr>> > () = {make_shared<Bool>(true, driver.env, yystack_[2].location), context};
       }
#line 1393 "Parser.cc" // lalr1.cc:919
    break;

  case 47:
#line 280 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<TextNode>(yystack_[0].value.as < string > (), driver.env, yylhs.location); }
#line 1399 "Parser.cc" // lalr1.cc:919
    break;

  case 48:
#line 282 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<TextNode>(yystack_[0].value.as < string > (), driver.env, yylhs.location); }
#line 1405 "Parser.cc" // lalr1.cc:919
    break;

  case 49:
#line 286 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < DirectivePtr > () = make_shared<Eval>(yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1411 "Parser.cc" // lalr1.cc:919
    break;

  case 50:
#line 290 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < VariablePtr > () = make_shared<Variable>(yystack_[0].value.as < string > (), driver.env, yylhs.location); }
#line 1417 "Parser.cc" // lalr1.cc:919
    break;

  case 51:
#line 294 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < FunctionPtr > () = make_shared<Function>(yystack_[2].value.as < string > (), vector<ExpressionPtr>(), driver.env, yylhs.location); }
#line 1423 "Parser.cc" // lalr1.cc:919
    break;

  case 52:
#line 296 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < FunctionPtr > () = make_shared<Function>(yystack_[3].value.as < string > (), yystack_[1].value.as < vector<ExpressionPtr> > (), driver.env, yylhs.location); }
#line 1429 "Parser.cc" // lalr1.cc:919
    break;

  case 53:
#line 300 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{yystack_[0].value.as < VariablePtr > ()}; }
#line 1435 "Parser.cc" // lalr1.cc:919
    break;

  case 54:
#line 302 "Parser.yy" // lalr1.cc:919
    { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < VariablePtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1441 "Parser.cc" // lalr1.cc:919
    break;

  case 55:
#line 306 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{}; }
#line 1447 "Parser.cc" // lalr1.cc:919
    break;

  case 56:
#line 308 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{yystack_[0].value.as < ExpressionPtr > ()}; }
#line 1453 "Parser.cc" // lalr1.cc:919
    break;

  case 57:
#line 310 "Parser.yy" // lalr1.cc:919
    { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < ExpressionPtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1459 "Parser.cc" // lalr1.cc:919
    break;

  case 58:
#line 314 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{}; }
#line 1465 "Parser.cc" // lalr1.cc:919
    break;

  case 59:
#line 316 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{yystack_[1].value.as < ExpressionPtr > ()}; }
#line 1471 "Parser.cc" // lalr1.cc:919
    break;

  case 60:
#line 318 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < vector<ExpressionPtr> > () = vector<ExpressionPtr>{yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > ()}; }
#line 1477 "Parser.cc" // lalr1.cc:919
    break;

  case 61:
#line 320 "Parser.yy" // lalr1.cc:919
    { yystack_[2].value.as < vector<ExpressionPtr> > ().emplace_back(yystack_[0].value.as < ExpressionPtr > ()); yylhs.value.as < vector<ExpressionPtr> > () = yystack_[2].value.as < vector<ExpressionPtr> > (); }
#line 1483 "Parser.cc" // lalr1.cc:919
    break;

  case 62:
#line 324 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[1].value.as < ExpressionPtr > (); }
#line 1489 "Parser.cc" // lalr1.cc:919
    break;

  case 63:
#line 326 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < VariablePtr > (); }
#line 1495 "Parser.cc" // lalr1.cc:919
    break;

  case 64:
#line 328 "Parser.yy" // lalr1.cc:919
    {
                 yylhs.value.as < ExpressionPtr > () = make_shared<Variable>(yystack_[3].value.as < string > (), make_shared<Array>(yystack_[1].value.as < vector<ExpressionPtr> > (), driver.env, yystack_[1].location),
                                            driver.env, yylhs.location);
               }
#line 1504 "Parser.cc" // lalr1.cc:919
    break;

  case 65:
#line 333 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Function>(yystack_[3].value.as < string > (), yystack_[1].value.as < vector<ExpressionPtr> > (), driver.env, yylhs.location); }
#line 1510 "Parser.cc" // lalr1.cc:919
    break;

  case 66:
#line 335 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Bool>(true, driver.env, yylhs.location); }
#line 1516 "Parser.cc" // lalr1.cc:919
    break;

  case 67:
#line 337 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Bool>(false, driver.env, yylhs.location); }
#line 1522 "Parser.cc" // lalr1.cc:919
    break;

  case 68:
#line 339 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Real>(yystack_[0].value.as < string > (), driver.env, yylhs.location); }
#line 1528 "Parser.cc" // lalr1.cc:919
    break;

  case 69:
#line 341 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<String>(yystack_[0].value.as < string > (), driver.env, yylhs.location); }
#line 1534 "Parser.cc" // lalr1.cc:919
    break;

  case 70:
#line 343 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Array>(yystack_[1].value.as < vector<ExpressionPtr> > (), driver.env, yylhs.location); }
#line 1540 "Parser.cc" // lalr1.cc:919
    break;

  case 71:
#line 345 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Tuple>(yystack_[1].value.as < vector<ExpressionPtr> > (), driver.env, yylhs.location); }
#line 1546 "Parser.cc" // lalr1.cc:919
    break;

  case 72:
#line 347 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(true, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1552 "Parser.cc" // lalr1.cc:919
    break;

  case 73:
#line 349 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1558 "Parser.cc" // lalr1.cc:919
    break;

  case 74:
#line 351 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Comprehension>(yystack_[7].value.as < ExpressionPtr > (), yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1564 "Parser.cc" // lalr1.cc:919
    break;

  case 75:
#line 353 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::length, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1570 "Parser.cc" // lalr1.cc:919
    break;

  case 76:
#line 355 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isempty, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1576 "Parser.cc" // lalr1.cc:919
    break;

  case 77:
#line 357 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isboolean, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1582 "Parser.cc" // lalr1.cc:919
    break;

  case 78:
#line 359 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isreal, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1588 "Parser.cc" // lalr1.cc:919
    break;

  case 79:
#line 361 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isstring, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1594 "Parser.cc" // lalr1.cc:919
    break;

  case 80:
#line 363 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::istuple, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1600 "Parser.cc" // lalr1.cc:919
    break;

  case 81:
#line 365 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::isarray, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1606 "Parser.cc" // lalr1.cc:919
    break;

  case 82:
#line 367 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::exp, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1612 "Parser.cc" // lalr1.cc:919
    break;

  case 83:
#line 369 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ln, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1618 "Parser.cc" // lalr1.cc:919
    break;

  case 84:
#line 371 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ln, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1624 "Parser.cc" // lalr1.cc:919
    break;

  case 85:
#line 373 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::log10, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1630 "Parser.cc" // lalr1.cc:919
    break;

  case 86:
#line 375 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sin, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1636 "Parser.cc" // lalr1.cc:919
    break;

  case 87:
#line 377 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cos, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1642 "Parser.cc" // lalr1.cc:919
    break;

  case 88:
#line 379 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::tan, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1648 "Parser.cc" // lalr1.cc:919
    break;

  case 89:
#line 381 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::asin, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1654 "Parser.cc" // lalr1.cc:919
    break;

  case 90:
#line 383 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::acos, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1660 "Parser.cc" // lalr1.cc:919
    break;

  case 91:
#line 385 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::atan, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1666 "Parser.cc" // lalr1.cc:919
    break;

  case 92:
#line 387 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sqrt, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1672 "Parser.cc" // lalr1.cc:919
    break;

  case 93:
#line 389 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cbrt, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1678 "Parser.cc" // lalr1.cc:919
    break;

  case 94:
#line 391 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sign, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1684 "Parser.cc" // lalr1.cc:919
    break;

  case 95:
#line 393 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::floor, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1690 "Parser.cc" // lalr1.cc:919
    break;

  case 96:
#line 395 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::ceil, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1696 "Parser.cc" // lalr1.cc:919
    break;

  case 97:
#line 397 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::trunc, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1702 "Parser.cc" // lalr1.cc:919
    break;

  case 98:
#line 399 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::sum, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1708 "Parser.cc" // lalr1.cc:919
    break;

  case 99:
#line 401 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::erf, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1714 "Parser.cc" // lalr1.cc:919
    break;

  case 100:
#line 403 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::erfc, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1720 "Parser.cc" // lalr1.cc:919
    break;

  case 101:
#line 405 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::gamma, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1726 "Parser.cc" // lalr1.cc:919
    break;

  case 102:
#line 407 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::lgamma, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1732 "Parser.cc" // lalr1.cc:919
    break;

  case 103:
#line 409 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::round, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1738 "Parser.cc" // lalr1.cc:919
    break;

  case 104:
#line 411 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::normpdf, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1744 "Parser.cc" // lalr1.cc:919
    break;

  case 105:
#line 413 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::normcdf, yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1750 "Parser.cc" // lalr1.cc:919
    break;

  case 106:
#line 415 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::max, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1756 "Parser.cc" // lalr1.cc:919
    break;

  case 107:
#line 417 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::min, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1762 "Parser.cc" // lalr1.cc:919
    break;

  case 108:
#line 419 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::mod, yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1768 "Parser.cc" // lalr1.cc:919
    break;

  case 109:
#line 421 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<TrinaryOp>(codes::TrinaryOp::normpdf, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1774 "Parser.cc" // lalr1.cc:919
    break;

  case 110:
#line 423 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<TrinaryOp>(codes::TrinaryOp::normcdf, yystack_[5].value.as < ExpressionPtr > (), yystack_[3].value.as < ExpressionPtr > (), yystack_[1].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1780 "Parser.cc" // lalr1.cc:919
    break;

  case 111:
#line 425 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::defined, make_shared<String>(yystack_[1].value.as < string > (), driver.env, yystack_[1].location), driver.env, yylhs.location); }
#line 1786 "Parser.cc" // lalr1.cc:919
    break;

  case 112:
#line 428 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1792 "Parser.cc" // lalr1.cc:919
    break;

  case 113:
#line 430 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_bool, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1798 "Parser.cc" // lalr1.cc:919
    break;

  case 114:
#line 432 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_real, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1804 "Parser.cc" // lalr1.cc:919
    break;

  case 115:
#line 434 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_string, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1810 "Parser.cc" // lalr1.cc:919
    break;

  case 116:
#line 436 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_tuple, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1816 "Parser.cc" // lalr1.cc:919
    break;

  case 117:
#line 438 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::cast_array, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1822 "Parser.cc" // lalr1.cc:919
    break;

  case 118:
#line 440 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::logical_not, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1828 "Parser.cc" // lalr1.cc:919
    break;

  case 119:
#line 442 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::unary_minus, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1834 "Parser.cc" // lalr1.cc:919
    break;

  case 120:
#line 444 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<UnaryOp>(codes::UnaryOp::unary_plus, yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1840 "Parser.cc" // lalr1.cc:919
    break;

  case 121:
#line 446 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::plus, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1846 "Parser.cc" // lalr1.cc:919
    break;

  case 122:
#line 448 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::minus, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1852 "Parser.cc" // lalr1.cc:919
    break;

  case 123:
#line 450 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::times, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1858 "Parser.cc" // lalr1.cc:919
    break;

  case 124:
#line 452 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::divide, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1864 "Parser.cc" // lalr1.cc:919
    break;

  case 125:
#line 454 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::power, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1870 "Parser.cc" // lalr1.cc:919
    break;

  case 126:
#line 456 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::set_union, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1876 "Parser.cc" // lalr1.cc:919
    break;

  case 127:
#line 458 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::set_intersection, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1882 "Parser.cc" // lalr1.cc:919
    break;

  case 128:
#line 462 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Range>(yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1888 "Parser.cc" // lalr1.cc:919
    break;

  case 129:
#line 464 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<Range>(yystack_[4].value.as < ExpressionPtr > (), yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1894 "Parser.cc" // lalr1.cc:919
    break;

  case 130:
#line 467 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1900 "Parser.cc" // lalr1.cc:919
    break;

  case 131:
#line 468 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = yystack_[0].value.as < ExpressionPtr > (); }
#line 1906 "Parser.cc" // lalr1.cc:919
    break;

  case 132:
#line 470 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::equal_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1912 "Parser.cc" // lalr1.cc:919
    break;

  case 133:
#line 472 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::not_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1918 "Parser.cc" // lalr1.cc:919
    break;

  case 134:
#line 474 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::less, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1924 "Parser.cc" // lalr1.cc:919
    break;

  case 135:
#line 476 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::greater, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1930 "Parser.cc" // lalr1.cc:919
    break;

  case 136:
#line 478 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::less_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1936 "Parser.cc" // lalr1.cc:919
    break;

  case 137:
#line 480 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::greater_equal, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1942 "Parser.cc" // lalr1.cc:919
    break;

  case 138:
#line 482 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::logical_and, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1948 "Parser.cc" // lalr1.cc:919
    break;

  case 139:
#line 484 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::logical_or, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1954 "Parser.cc" // lalr1.cc:919
    break;

  case 140:
#line 486 "Parser.yy" // lalr1.cc:919
    { yylhs.value.as < ExpressionPtr > () = make_shared<BinaryOp>(codes::BinaryOp::in, yystack_[2].value.as < ExpressionPtr > (), yystack_[0].value.as < ExpressionPtr > (), driver.env, yylhs.location); }
#line 1960 "Parser.cc" // lalr1.cc:919
    break;


#line 1964 "Parser.cc" // lalr1.cc:919
            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;
      YY_STACK_PRINT ();

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        error (yyla.location, yysyntax_error_ (yystack_[0].state, yyla));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.type_get () == yyeof_)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    {
      stack_symbol_type error_token;
      for (;;)
        {
          yyn = yypact_[yystack_[0].state];
          if (!yy_pact_value_is_default_ (yyn))
            {
              yyn += yyterror_;
              if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
                {
                  yyn = yytable_[yyn];
                  if (0 < yyn)
                    break;
                }
            }

          // Pop the current state because it cannot handle the error token.
          if (yystack_.size () == 1)
            YYABORT;

          yyerror_range[1].location = yystack_[0].location;
          yy_destroy_ ("Error: popping", yystack_[0]);
          yypop_ ();
          YY_STACK_PRINT ();
        }

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = yyn;
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (state_type yystate, const symbol_type& yyla) const
  {
    // Number of reported tokens (one for the "unexpected", one per
    // "expected").
    size_t yycount = 0;
    // Its maximum.
    enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
    // Arguments of yyformat.
    char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];

    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state
         merging (from LALR or IELR) and default reductions corrupt the
         expected token list.  However, the list is correct for
         canonical LR with one exception: it will still contain any
         token that will not be accepted due to an error action in a
         later state.
    */
    if (!yyla.empty ())
      {
        int yytoken = yyla.type_get ();
        yyarg[yycount++] = yytname_[yytoken];
        int yyn = yypact_[yystate];
        if (!yy_pact_value_is_default_ (yyn))
          {
            /* Start YYX at -YYN if negative to avoid negative indexes in
               YYCHECK.  In other words, skip the first -YYN actions for
               this state because they are default actions.  */
            int yyxbegin = yyn < 0 ? -yyn : 0;
            // Stay within bounds of both yycheck and yytname.
            int yychecklim = yylast_ - yyn + 1;
            int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
            for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
              if (yycheck_[yyx + yyn] == yyx && yyx != yyterror_
                  && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
                {
                  if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                    {
                      yycount = 1;
                      break;
                    }
                  else
                    yyarg[yycount++] = yytname_[yyx];
                }
          }
      }

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    size_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += yytnamerr_ (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short parser::yypact_ninf_ = -170;

  const signed char parser::yytable_ninf_ = -27;

  const short
  parser::yypact_[] =
  {
     215,  -170,  -170,  -170,  -170,   373,   373,   -16,   373,   373,
     373,    -2,   -40,  -170,  -170,    48,  -170,  -170,    -4,    57,
    -170,  -170,  -170,  -170,  -170,  -170,   373,   373,   373,   373,
    -170,  -170,   309,   373,    72,   132,   145,   152,   154,   163,
     164,   166,   168,   170,   178,   179,   186,   189,   203,   204,
     205,   206,   207,   211,   214,   216,   217,   218,   219,   221,
     223,   225,   229,   256,   257,   258,   259,   260,   265,   373,
     373,   373,     9,  -170,  -170,  -170,  -170,   494,  -170,   910,
     910,   266,   185,   231,   910,   910,   988,   261,  -170,   200,
     142,  -170,  -170,  -170,  -170,   997,   277,     1,   -38,   281,
     282,   272,   274,   287,   289,   290,    28,   181,   -11,     8,
     373,   373,   373,   373,   373,   373,   373,   373,   373,   373,
     373,   373,   373,   373,   373,   373,   373,   373,   373,   373,
     373,   373,   373,   373,   373,   373,   373,   373,   373,   373,
     373,   373,   373,   373,   224,   226,   226,   226,   373,   373,
     373,   373,   373,   373,   373,   373,   373,   373,   373,   373,
     373,   373,   373,   373,   373,   373,   373,   -14,   373,   373,
    -170,   297,  -170,  -170,   373,  -170,  -170,  -170,   373,  -170,
     228,  -170,   215,  -170,  -170,   373,   373,   373,   373,   373,
     373,  -170,   373,  -170,   373,  -170,   373,   373,   463,   476,
     493,   521,   534,   551,   560,   569,   579,   592,   627,   637,
     650,   197,   375,   659,   668,   685,   695,   435,   726,   743,
     753,   762,   771,   227,   418,   784,   801,   829,   842,   859,
     868,   877,   302,    70,   910,   148,   593,   -59,   -25,   -17,
     -17,   226,   226,   235,    26,   188,    71,    71,   247,   247,
     247,   247,   248,  -170,  -170,  -170,   149,   910,   910,   238,
      -7,   404,   215,   215,   226,   226,   226,   226,   226,   910,
     910,   910,  1006,    -8,  -170,  -170,  -170,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,  -170,  -170,  -170,   373,   373,  -170,
    -170,  -170,  -170,   373,  -170,  -170,  -170,  -170,  -170,   373,
    -170,   373,  -170,  -170,  -170,  -170,  -170,  -170,  -170,  -170,
    -170,  -170,  -170,   373,   240,  -170,   200,   373,   241,   215,
     215,   373,   373,   887,   900,   935,   445,   454,   -39,  -170,
     910,   215,   215,    -9,   967,  -170,  -170,  -170,   373,   373,
     190,  -170,   373,  -170,   945,   958,  -170,   976,  -170,  -170,
    -170
  };

  const unsigned char
  parser::yydefact_[] =
  {
       0,    28,    30,    32,    34,     0,     0,     0,     0,     0,
       0,    15,     0,    47,    48,     0,     2,     4,     0,     0,
      22,    23,    24,    25,     5,     6,     0,     0,     0,     0,
      66,    67,    58,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,    69,    68,    63,   112,   130,   131,     9,
      10,    50,     0,     0,    13,    14,     0,     0,    20,    16,
       0,     1,     3,     7,     8,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   120,   119,   118,    55,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,    21,    19,     0,    31,    41,    44,     0,    40,
       0,    37,    38,    33,    35,     0,     0,     0,     0,     0,
       0,    71,    59,    62,     0,    70,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,   128,   126,   127,   121,
     122,   123,   124,   125,   139,   138,   132,   133,   134,   135,
     136,   137,   140,    51,    50,    53,     0,    11,    12,    17,
     140,     0,    45,    39,   113,   114,   115,   116,   117,    61,
      60,    57,     0,   140,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,     0,     0,    95,
      96,    97,    98,     0,    99,   100,   101,   102,   103,     0,
     104,     0,   105,    75,    76,    77,    78,    79,    80,    81,
     111,    65,    64,     0,     0,    52,    18,     0,     0,    42,
      46,     0,     0,     0,     0,     0,     0,     0,   129,    54,
      27,     0,    43,   140,     0,   106,   107,   108,     0,     0,
       0,    73,     0,    72,     0,     0,    29,     0,   109,   110,
      74
  };

  const short
  parser::yypgoto_[] =
  {
    -170,  -169,   -13,  -170,  -170,    73,  -170,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,  -170,  -170,   112,  -170,  -170,  -170,
    -170,  -170,  -170,  -170,    -1,  -170,  -170,  -129,  -170,  -170,
      25,  -170,    -5
  };

  const short
  parser::yydefgoto_[] =
  {
      -1,    15,    16,    17,    18,    89,    19,   318,    20,    26,
      21,    27,    22,    28,    23,    29,    96,    97,   178,   179,
     180,   181,    24,    25,    75,    83,   256,   108,   106,    76,
      77,    78,    98
  };

  const short
  parser::yytable_[] =
  {
      79,    80,    92,    84,    85,    86,    82,   253,   194,   176,
     177,   196,   195,   263,   341,   342,   322,   317,    87,   233,
     235,    95,   152,   153,   154,   155,   156,   107,   109,   148,
     157,   149,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   151,   152,   153,   154,   155,   156,   190,    91,   191,
     157,     1,    90,     2,     3,     4,   182,   153,   154,   155,
     156,     5,     6,     7,   157,     8,     9,   155,   156,   -27,
     -27,   -27,   157,    10,    81,    11,   254,    12,   158,   159,
     160,   161,   162,   163,   164,   165,   197,   -26,    88,   194,
      93,   311,   110,   320,   145,   146,   147,   159,   160,   161,
     162,   163,   164,   165,   166,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,    13,
      99,   100,    14,   234,   234,   162,   163,   164,   165,   166,
     332,    94,   111,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   340,   257,   258,   112,   255,   194,   314,   260,
     315,   312,   113,   261,   114,   236,   237,   238,   239,   240,
     241,   242,   243,   115,   116,   269,   117,   270,   118,   271,
     119,   272,   273,     1,   346,     2,     3,     4,   120,   121,
     192,   168,   193,     5,     6,     7,   122,     8,     9,   123,
     264,   265,   266,   267,   268,    10,   287,    11,     1,    12,
       2,     3,     4,   124,   125,   126,   127,   128,     5,     6,
       7,   129,     8,     9,   130,   173,   131,   132,   133,   134,
      10,   135,    11,   136,    12,   137,   299,   169,   300,   138,
      92,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     160,   161,   162,   163,   164,   165,   166,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   139,   140,   141,   142,
     143,    13,   323,   324,    14,   144,   167,   175,   325,   171,
     172,   183,   184,   185,   326,   186,   327,   158,   159,   160,
     161,   162,   163,   164,   165,   166,    13,    92,   187,    14,
     188,   189,   330,   329,   232,   157,   333,   334,   259,    92,
      30,    31,   262,   310,   -27,   166,   -27,    92,    88,    32,
     254,    33,   316,   344,   345,   331,     0,   347,   328,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,   101,   102,   103,   104,   105,    68,     0,
       0,     0,     0,     0,    30,    31,     0,     0,     0,     0,
       0,    69,    70,    32,   288,    33,    71,     0,     0,    72,
       0,    73,    74,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,   301,     0,   302,
       0,     0,    68,     0,     0,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   293,    69,    70,     0,     0,     0,
      71,     0,     0,    72,   338,    73,    74,     0,     0,     0,
       0,     0,     0,   339,   158,   159,   160,   161,   162,   163,
     164,   165,   166,     0,   274,     0,     0,     0,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   275,   319,     0,
       0,     0,     0,     0,     0,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   276,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   277,     0,     0,     0,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   278,     0,     0,     0,     0,
       0,     0,     0,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   279,   150,   151,   152,   153,   154,   155,   156,
       0,   280,     0,   157,     0,     0,     0,     0,     0,     0,
     281,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     282,     0,     0,     0,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   283,     0,     0,     0,     0,     0,     0,
       0,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   284,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   285,     0,
       0,     0,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   286,   313,   151,   152,   153,   154,   155,   156,     0,
     289,     0,   157,     0,     0,     0,     0,     0,     0,   290,
       0,     0,     0,     0,     0,     0,     0,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   291,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   292,     0,     0,     0,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   294,     0,     0,
       0,     0,     0,     0,     0,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   295,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   296,     0,     0,     0,     0,     0,
       0,     0,     0,   297,     0,     0,     0,     0,     0,     0,
       0,     0,   298,     0,     0,     0,   158,   159,   160,   161,
     162,   163,   164,   165,   166,   303,     0,     0,     0,     0,
       0,     0,     0,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   304,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     305,     0,     0,     0,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   306,     0,     0,     0,     0,     0,     0,
       0,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     307,     0,     0,     0,     0,     0,     0,     0,     0,   308,
       0,     0,     0,     0,     0,     0,     0,     0,   309,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   335,     0,
       0,     0,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   336,     0,     0,     0,     0,     0,     0,     0,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   337,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   348,     0,     0,     0,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   349,
     158,   159,   160,   161,   162,   163,   164,   165,   166,     0,
     343,     0,     0,     0,     0,     0,     0,     0,     0,   350,
       0,     0,     0,     0,     0,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   170,   158,   159,   160,   161,   162,
     163,   164,   165,   166,     0,     0,     0,     0,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   158,   159,   160,   161,
     162,   163,   164,   165,   166,     0,     0,     0,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   158,   159,   160,
     161,   162,   163,   164,   165,   174,   158,   159,   160,   161,
     162,   163,   164,   165,   321
  };

  const short
  parser::yycheck_[] =
  {
       5,     6,    15,     8,     9,    10,     7,    21,    19,     8,
       9,     3,    23,   182,    23,    24,    24,    24,    20,   148,
     149,    26,    81,    82,    83,    84,    85,    32,    33,    20,
      89,    22,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    80,    81,    82,    83,    84,    85,    19,     0,    21,
      89,     3,    92,     5,     6,     7,    94,    82,    83,    84,
      85,    13,    14,    15,    89,    17,    18,    84,    85,    78,
      78,    78,    89,    25,    90,    27,    90,    29,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    94,    90,    19,
      94,    21,    20,   262,    69,    70,    71,    71,    72,    73,
      74,    75,    76,    77,    78,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,    91,
      28,    29,    94,   148,   149,    74,    75,    76,    77,    78,
     319,    94,    20,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   331,   168,   169,    20,   167,    19,    19,   174,
      21,    23,    20,   178,    20,   150,   151,   152,   153,   154,
     155,   156,   157,    20,    20,   190,    20,   192,    20,   194,
      20,   196,   197,     3,     4,     5,     6,     7,    20,    20,
      19,    16,    21,    13,    14,    15,    20,    17,    18,    20,
     185,   186,   187,   188,   189,    25,    19,    27,     3,    29,
       5,     6,     7,    20,    20,    20,    20,    20,    13,    14,
      15,    20,    17,    18,    20,    93,    20,    20,    20,    20,
      25,    20,    27,    20,    29,    20,    19,    16,    21,    20,
     263,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      72,    73,    74,    75,    76,    77,    78,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    20,    20,    20,    20,
      20,    91,   287,   288,    94,    20,    20,    10,   293,    28,
      90,    10,    10,    21,   299,    21,   301,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    91,   320,    21,    94,
      21,    21,   317,   314,    90,    89,   321,   322,    21,   332,
      11,    12,    94,    21,    89,    78,    78,   340,    90,    20,
      90,    22,   259,   338,   339,    94,    -1,   342,   313,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    -1,
      -1,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    -1,
      -1,    82,    83,    20,    19,    22,    87,    -1,    -1,    90,
      -1,    92,    93,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    19,    -1,    21,
      -1,    -1,    69,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    19,    82,    83,    -1,    -1,    -1,
      87,    -1,    -1,    90,    19,    92,    93,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    -1,    21,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    21,    94,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    21,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    21,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    21,    79,    80,    81,    82,    83,    84,    85,
      -1,    21,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      21,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    21,    79,    80,    81,    82,    83,    84,    85,    -1,
      21,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    21,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    21,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    21,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    21,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    21,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    21,    -1,    -1,    -1,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    21,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    -1,    -1,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    21,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    21,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    21,    -1,
      -1,    -1,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    21,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    21,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    21,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    21,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,
      -1,    -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    26,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    -1,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    -1,    -1,    -1,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    70,    71,    72,    73,
      74,    75,    76,    77,    78
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     3,     5,     6,     7,    13,    14,    15,    17,    18,
      25,    27,    29,    91,    94,    96,    97,    98,    99,   101,
     103,   105,   107,   109,   117,   118,   104,   106,   108,   110,
      11,    12,    20,    22,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    69,    82,
      83,    87,    90,    92,    93,   119,   124,   125,   126,   127,
     127,    90,   119,   120,   127,   127,   127,    20,    90,   100,
      92,     0,    97,    94,    94,   127,   111,   112,   127,   111,
     111,    64,    65,    66,    67,    68,   123,   127,   122,   127,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,   125,   125,   125,    20,    22,
      79,    80,    81,    82,    83,    84,    85,    89,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    20,    16,    16,
      26,    28,    90,    93,    78,    10,     8,     9,   113,   114,
     115,   116,    94,    10,    10,    21,    21,    21,    21,    21,
      19,    21,    19,    21,    19,    23,     3,    78,   127,   127,
     127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
     127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
     127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
     127,   127,    90,   122,   127,   122,   125,   125,   125,   125,
     125,   125,   125,   125,   127,   127,   127,   127,   127,   127,
     127,   127,   127,    21,    90,   119,   121,   127,   127,    21,
     127,   127,    94,    96,   125,   125,   125,   125,   125,   127,
     127,   127,   127,   127,    21,    21,    21,    21,    21,    21,
      21,    21,    21,    21,    21,    21,    21,    19,    19,    21,
      21,    21,    21,    19,    21,    21,    21,    21,    21,    19,
      21,    19,    21,    21,    21,    21,    21,    21,    21,    21,
      21,    21,    23,    79,    19,    21,   100,    24,   102,    94,
      96,    78,    24,   127,   127,   127,   127,   127,   125,   119,
     127,    94,    96,   127,   127,    21,    21,    21,    19,    19,
      96,    23,    24,    23,   127,   127,     4,   127,    21,    21,
      23
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    95,    96,    96,    97,    97,    97,    98,    98,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
     100,   100,   101,   101,   101,   101,   102,   102,   104,   103,
     106,   105,   108,   107,   110,   109,   111,   111,   112,   112,
     112,   113,   114,   114,   115,   116,   116,   117,   117,   118,
     119,   120,   120,   121,   121,   122,   122,   122,   123,   123,
     123,   123,   124,   124,   124,   124,   124,   124,   124,   124,
     124,   124,   124,   124,   124,   124,   124,   124,   124,   124,
     124,   124,   124,   124,   124,   124,   124,   124,   124,   124,
     124,   124,   124,   124,   124,   124,   124,   124,   124,   124,
     124,   124,   124,   124,   124,   124,   124,   124,   124,   124,
     124,   124,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   125,   125,   125,   125,   125,   126,   126,
     127,   127,   127,   127,   127,   127,   127,   127,   127,   127,
     127
  };

  const unsigned char
  parser::yyr2_[] =
  {
       0,     2,     1,     2,     1,     1,     1,     2,     2,     2,
       2,     4,     4,     2,     2,     1,     2,     4,     5,     3,
       1,     2,     1,     1,     1,     1,     0,     2,     0,     9,
       0,     4,     0,     4,     0,     4,     1,     2,     2,     3,
       2,     1,     3,     4,     1,     2,     3,     1,     1,     3,
       1,     3,     4,     1,     3,     0,     1,     3,     0,     2,
       3,     3,     3,     1,     4,     4,     1,     1,     1,     1,
       3,     3,     7,     7,     9,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     6,     6,     6,     8,
       8,     4,     1,     4,     4,     4,     4,     4,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     3,
       3
  };



  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a yyntokens_, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "$end", "error", "$undefined", "FOR", "ENDFOR", "IF", "IFDEF", "IFNDEF",
  "ELSEIF", "ELSE", "ENDIF", "TRUE", "FALSE", "INCLUDE", "INCLUDEPATH",
  "DEFINE", "EQUAL", "D_ECHO", "ERROR", "COMMA", "LPAREN", "RPAREN",
  "LBRACKET", "RBRACKET", "WHEN", "BEGIN_EVAL", "END_EVAL",
  "ECHOMACROVARS", "SAVE", "LINE", "EXP", "LOG", "LN", "LOG10", "SIN",
  "COS", "TAN", "ASIN", "ACOS", "ATAN", "SQRT", "CBRT", "SIGN", "MAX",
  "MIN", "FLOOR", "CEIL", "TRUNC", "SUM", "MOD", "ERF", "ERFC", "GAMMA",
  "LGAMMA", "ROUND", "NORMPDF", "NORMCDF", "LENGTH", "ISEMPTY",
  "ISBOOLEAN", "ISREAL", "ISSTRING", "ISTUPLE", "ISARRAY", "BOOL", "REAL",
  "STRING", "TUPLE", "ARRAY", "DEFINED", "OR", "AND", "EQUAL_EQUAL",
  "NOT_EQUAL", "LESS", "GREATER", "LESS_EQUAL", "GREATER_EQUAL", "IN",
  "COLON", "UNION", "INTERSECTION", "PLUS", "MINUS", "TIMES", "DIVIDE",
  "UNARY", "NOT", "CAST", "POWER", "NAME", "TEXT", "QUOTED_STRING",
  "NUMBER", "EOL", "$accept", "statements", "statement", "directive",
  "directive_one_line", "name_list", "directive_multiline", "for_when",
  "for", "$@1", "if", "$@2", "ifdef", "$@3", "ifndef", "$@4", "if_list",
  "if_list1", "elseif_begin", "elseif", "else_begin", "else", "text",
  "eval", "symbol", "function", "function_args", "comma_expr",
  "tuple_comma_expr", "primary_expr", "oper_expr", "colon_expr", "expr", YY_NULLPTR
  };

#if YYDEBUG
  const unsigned short
  parser::yyrline_[] =
  {
       0,   109,   109,   113,   119,   120,   121,   124,   125,   128,
     130,   132,   134,   136,   138,   140,   142,   144,   146,   148,
     156,   158,   165,   166,   167,   168,   171,   173,   177,   177,
     208,   208,   212,   212,   216,   216,   220,   221,   228,   234,
     240,   247,   249,   255,   263,   265,   271,   279,   281,   285,
     289,   293,   295,   299,   301,   305,   307,   309,   313,   315,
     317,   319,   323,   325,   327,   332,   334,   336,   338,   340,
     342,   344,   346,   348,   350,   352,   354,   356,   358,   360,
     362,   364,   366,   368,   370,   372,   374,   376,   378,   380,
     382,   384,   386,   388,   390,   392,   394,   396,   398,   400,
     402,   404,   406,   408,   410,   412,   414,   416,   418,   420,
     422,   424,   428,   429,   431,   433,   435,   437,   439,   441,
     443,   445,   447,   449,   451,   453,   455,   457,   461,   463,
     467,   468,   469,   471,   473,   475,   477,   479,   481,   483,
     485
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << i->state;
    *yycdebug_ << '\n';
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  parser::token_number_type
  parser::yytranslate_ (int t)
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const token_number_type
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94
    };
    const unsigned user_token_number_max_ = 349;
    const token_number_type undef_token_ = 2;

    if (static_cast<int> (t) <= yyeof_)
      return yyeof_;
    else if (static_cast<unsigned> (t) <= user_token_number_max_)
      return translate_table[t];
    else
      return undef_token_;
  }

#line 25 "Parser.yy" // lalr1.cc:1242
} // Tokenizer
#line 2783 "Parser.cc" // lalr1.cc:1242
#line 489 "Parser.yy" // lalr1.cc:1243


void
Tokenizer::parser::error(const Tokenizer::parser::location_type &l, const string &m)
{
  driver.error(l, m);
}
