/*
 * (C) Copyright 2005- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>

#include "grib_api_internal.h"

/*
 * Test encoding of LAM spectral fields
 * philippe.marguinaud@meteo.fr, 02/2016
 */

static double values[] = {
    2.75181294152902012e+02, 0.00000000000000000e+00, 0.00000000000000000e+00, 0.00000000000000000e+00, -2.00031443764104797e-02,
    2.20986262423002011e-01, 0.00000000000000000e+00, 0.00000000000000000e+00, -6.50831583306859668e-02, 9.56915910153004201e-02,
    0.00000000000000000e+00, 0.00000000000000000e+00, -7.69949998097087390e-02, 2.15126568901680588e-02, 0.00000000000000000e+00,
    0.00000000000000000e+00, -2.15191777195716909e-02, -1.77751950764027111e-02, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -9.03325926869718264e-03, -6.45905357075528350e-03, 0.00000000000000000e+00, 0.00000000000000000e+00, 3.76554930890086407e-03,
    4.28150996355022243e-03, 0.00000000000000000e+00, 0.00000000000000000e+00, -4.48334654946085272e-03, -3.24945933688448613e-03,
    0.00000000000000000e+00, 0.00000000000000000e+00, -8.33958311735325322e-03, 2.67394757861415906e-03, 0.00000000000000000e+00,
    0.00000000000000000e+00, -2.88928782235351811e-03, 1.11276030204927202e-02, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -6.89744178202101980e-03, 1.68577225483147806e-03, 0.00000000000000000e+00, 0.00000000000000000e+00, -4.05911636160587782e-03,
    -8.63040459605283984e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, 1.77788775751947913e-03, 1.62646256200294588e-03,
    0.00000000000000000e+00, 0.00000000000000000e+00, -2.34489308196387896e-04, 6.26464829859012945e-03, 0.00000000000000000e+00,
    0.00000000000000000e+00, -1.52923310566158415e-03, 3.51952946092800104e-03, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -2.12456107651320296e-03, 7.80855898848169944e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, -1.03218475301503098e-03,
    -4.84939736793421616e-05, 0.00000000000000000e+00, 0.00000000000000000e+00, -1.27050726547289815e-03, 6.10515922008610795e-04,
    0.00000000000000000e+00, 0.00000000000000000e+00, -4.61636562893467212e-04, 3.78318476621734151e-04, 0.00000000000000000e+00,
    0.00000000000000000e+00, -1.90620242437837724e-04, 2.39481618132839210e-03, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -1.47687884032438608e-03, 2.42544367345591408e-03, 0.00000000000000000e+00, 0.00000000000000000e+00, -2.46192219258621788e-03,
    2.46579511004843988e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, -1.50607540488831206e-03, -3.75857847911556075e-04,
    0.00000000000000000e+00, 0.00000000000000000e+00, -7.25805584180000754e-04, 9.78641239992627046e-05, 0.00000000000000000e+00,
    0.00000000000000000e+00, -7.80340606647248088e-04, 8.75931120319022039e-04, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -1.47851165924441194e-03, 1.17811049164095192e-03, 0.00000000000000000e+00, 0.00000000000000000e+00, -2.08460733839155700e-03,
    6.42619155220282463e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, -1.86653178182583090e-03, -1.51572352026370312e-04,
    0.00000000000000000e+00, 0.00000000000000000e+00, -1.07549275530616001e-03, -4.44853427976503511e-04, 0.00000000000000000e+00,
    0.00000000000000000e+00, -6.33166214776187397e-04, 1.77518665839971507e-05, 0.00000000000000000e+00, 0.00000000000000000e+00,
    -7.92028302924727146e-04, 4.38426731572627625e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, -1.36111299097537602e-03,
    3.55302636498244784e-04, 0.00000000000000000e+00, 0.00000000000000000e+00, 4.31165906519952527e-02, 0.00000000000000000e+00,
    3.80339924146994024e-01, 0.00000000000000000e+00, -6.26107842259959399e-03, 1.64616708332782904e-03, 7.15529452992990245e-03,
    -1.86210941905016296e-02, 5.36772367761992244e-03, -3.37215608643290496e-03, -6.27927374167897446e-03, 1.59410804744731308e-02,
    -1.10370818380311399e-02, -6.84039900395983468e-04, -7.35117541436946381e-03, -4.87635242059330717e-03, -7.33706364752968569e-03,
    6.58538980656067294e-03, -6.56001297130070615e-03, 2.39042653237417005e-04, 4.18393771850396725e-04, -9.83382649555805503e-03,
    -4.32676605363364018e-03, -1.10999673219588004e-02, -3.07797564052225605e-03, -2.83896250149829514e-03, 4.23882761382370337e-03,
    -2.26439224781546308e-03, -2.32047257122214301e-03, -2.86523743964195400e-03, 1.16753700036647200e-03, -1.96688706621135590e-03,
    -5.64532360297308362e-03, 3.86163113000431019e-03, -4.55210116404825178e-03, -2.31820675144046905e-03, -7.54930221713808131e-04,
    5.42645956136695879e-03, -1.37359456800822195e-04, -1.41701530146446709e-03, -7.24047803220819299e-04, 2.97282693804422219e-03,
    -9.21178724545542739e-04, 2.17304781678062013e-03, 5.02933596226693130e-03, 4.19709065989953400e-04, -2.32808772095879088e-03,
    -3.96816140679685759e-04, 1.66528807434054306e-03, -4.34672804984864508e-04, 6.71774253284030125e-04, -9.64395020788669558e-04,
    5.60151148527374262e-04, -2.54932855784003589e-03, 2.20163163376581403e-03, 9.04215953722457551e-04, 1.20823533199773401e-04,
    -2.59868122477286410e-04, -1.65945495141917997e-04, 1.46538996917019689e-03, -1.68476757946802304e-03, 1.07540452680088500e-05,
    5.87513082394260696e-04, -1.24863532530485998e-03, -3.40155704130869251e-04, 5.06914392022354376e-04, 3.59174751231139280e-04,
    -6.95434364128791230e-04, 5.31028293884702393e-04, -4.85338794987818855e-05, 9.80353244783757497e-04, -2.73784354447844888e-04,
    6.75383024029988280e-04, -5.75995357037249419e-04, 1.90931744053672494e-04, 4.24537699070617045e-04, -4.71947030265784521e-04,
    -4.46465504992567892e-04, 3.33337956522936497e-04, -1.27617452248717108e-04, -8.67351806263058525e-05, 1.84741230040785993e-04,
    2.68168590454641613e-04, -1.31760079895587510e-05, -1.96141696634310206e-04, 3.15977777045840907e-05, 5.52964000678949098e-05,
    -5.68648317683832915e-05, -1.24618526993470704e-04, -1.64319991484120808e-04, 9.90021761468646032e-05, -2.89641341863940680e-04,
    1.55648200162975805e-04, -1.61276662168002686e-04, 3.37883315497318677e-04, -3.00041726450727992e-04, 2.26196161548845496e-04,
    1.04382192438164800e-04, 4.50994722382257825e-04, -9.02537135361254129e-05, 5.64332474405111417e-05, 2.40936093599355207e-04,
    2.94628358869333785e-04, 9.40238863724802596e-05, -1.25490327018252206e-04, 1.13999493763013607e-04, 9.90868525905299344e-05,
    2.79939342717346504e-05, -1.21103070944854899e-04, -9.78183419047561525e-05, 7.97907489358191165e-05, -1.56274876625488320e-04,
    6.91110956986578159e-05, -1.78274579094107812e-04, 2.35172712320294510e-04, -1.86487667645096914e-04, 1.81359168243560220e-04,
    -8.28267034951306894e-05, 3.64422258672049697e-04, -6.00161449209830129e-05, 1.53669854000615012e-04, 5.33940976909759048e-05,
    2.71098832854533114e-04, 1.16978179717633208e-04, -7.04014134697032723e-02, 0.00000000000000000e+00, 9.62756934345549015e-02,
    0.00000000000000000e+00, -5.01308988644840123e-02, 1.90874724562156602e-02, -2.80953874485262711e-02, 9.94764679201346272e-03,
    -2.78516472981488912e-02, -3.06618517103302880e-02, 7.58078492851659708e-03, -4.18797526833174401e-03, -9.28131704978618285e-03,
    -1.46423285050521004e-02, -1.12982430235375603e-02, -4.45163187034482329e-03, -8.86607378544559607e-04, -1.37678041188198305e-02,
    -3.04744522425032726e-03, 1.40705206691586690e-02, 4.92736702444518219e-03, -5.90514134511184539e-03, -4.54964421596467609e-03,
    -8.39159774589658125e-03, -4.46148003495234514e-03, -1.62058199127339503e-03, 5.61408022308887422e-03, 4.49055900394370114e-03,
    -1.82071051913615303e-03, -4.09318011341107141e-03, -4.97865560096572360e-03, -3.90714411692000101e-03, -2.72428801010754702e-04,
    3.29022970106107040e-05, -3.71301533763268490e-03, 3.48487792329992983e-04, 1.15959669498262694e-03, 4.98979531764007374e-04,
    7.26403024471391199e-04, 1.64864318070091407e-03, 5.15149461852990758e-04, -1.86307159089303892e-03, 1.07464821641563204e-03,
    1.93916722418667302e-03, 1.78527114422754305e-03, -3.69908045453888525e-03, 1.35978350637315200e-03, 1.97378490377768823e-03,
    -1.12077965666117305e-03, 1.89400552511022986e-03, 1.34901499797743002e-03, -7.17376936946564751e-04, 3.77336189237397162e-04,
    -8.49455521901115469e-04, 1.76458772526797607e-03, -1.34910889239185107e-03, -8.88652895477685142e-04, -1.56500185302029806e-04,
    -8.76093972833636445e-04, -2.00964500803350399e-03, 1.58208594440964988e-03, -4.99776272008587265e-04, 9.21092504090277532e-04,
    -9.50973675462412054e-04, 9.34360703323434722e-04, 1.13569489093607798e-03, -2.35584557310445026e-04, -4.38069769484956937e-05,
    3.24577435798492555e-04, -1.25354645423132001e-03, 2.23682595620860417e-04, 3.66036513139383663e-04, 1.40216714894795505e-03,
    2.27750709584358922e-05, -1.93328972751045800e-04, 2.02025568799330516e-04, -2.74656452169796581e-04, -7.13136078966307191e-04,
    -7.74076812485903487e-04, -1.02274882001159593e-03, 5.52829074765155888e-04, -3.68749942830809982e-04, 5.23471145957211991e-04,
    -5.11988764810234896e-04, 6.02265891061533310e-04, -2.11327004479523907e-04, 6.41691954883075503e-04, -2.93053466696699415e-05,
    5.44704761041802841e-04, -5.66628145474610301e-05, 3.06917641025358854e-04, 2.85907713552362608e-04, 3.77388927634152475e-04,
    -3.77819009899353793e-05, -7.23439228551873374e-05, 9.85771074035036001e-05, 3.21327432771281263e-04, -1.59908157634313996e-04,
    -6.09095752283840726e-05, -2.76136058709174526e-04, 3.87616442158483353e-04, -2.26542483972600318e-04, 2.54495029230095593e-04,
    -4.53136334566828323e-04, 4.85440002953321521e-04, -1.62296622208713188e-04, 5.57461157340177543e-04, -2.18109633528073014e-04,
    4.40938655580095133e-04, -2.50802656486350106e-05, 4.94156181908487774e-04, 1.46912930391045014e-04, 3.39995298139647573e-04,
    2.31575644258876931e-05, 1.27693888311369109e-04, 2.66757357090615819e-04, 2.81659456088537022e-04, -1.77008256058765415e-05,
    -5.59528798333871517e-05, 8.03605031599087131e-05, 2.85552901830860538e-04, -4.53068755612621334e-05, 1.02695668114354909e-05,
    -9.52364495838409209e-05, -5.81103624210425537e-02, 0.00000000000000000e+00, -6.11613220936809646e-03, 0.00000000000000000e+00,
    4.43140816018786771e-03, -2.60999931564933826e-03, -9.40668310127974576e-03, -1.48661226497603313e-02, -1.36502130860806405e-02,
    -2.14796277886411605e-02, -4.29520125994365363e-03, -1.26923474000257205e-02, -7.86135852771467636e-03, 1.28725912652949892e-03,
    -6.82233374677557874e-03, 4.39686715387468952e-03, 1.82006684281001488e-03, 1.49296576633828294e-03, -1.98801597839639611e-03,
    1.62071513114028917e-03, 5.34277138633573300e-03, 2.01625340607174391e-03, 4.65092297717760190e-03, -4.98019846270408330e-03,
    -8.09160267604481370e-03, 3.44643931971669272e-04, -5.89232406165003143e-03, 2.42334465848842917e-03, -8.80352946027558960e-04,
    9.84336007576140171e-04, -7.45770687978821595e-03, 4.75822395048473845e-05, 1.47566490371992703e-04, 5.47124159393165554e-03,
    1.21021033478159695e-03, 9.69205973697771176e-04, 2.87549817812144098e-03, -3.61852844247361654e-04, 6.44364669700349130e-04,
    1.29877596456263100e-03, 9.38391522093622900e-04, -2.22314144452083603e-03, 3.10148815196359916e-03, 5.28716763746763570e-04,
    8.26155935032032562e-04, 1.57427796494904104e-03, -7.38296066748109475e-04, 1.14662499560429709e-03, -8.33016875095013713e-04,
    -1.55185739616535206e-03, 2.04015157270918393e-03, -9.48182790145658426e-04, -8.81430768705695989e-04, -1.79127396420232423e-04,
    -1.10273859532507507e-03, 6.53764928387371141e-04, -7.73895587008780373e-04, 2.68077770038103081e-04, 6.51103785496301673e-04,
    -2.71669965700574879e-03, -3.88256693905312568e-04, 7.85903560292053544e-04, 1.18648988600738399e-03, 2.73534309775586828e-04,
    -1.60929713471156209e-04, 1.29735976231497405e-03, 1.37988749081522505e-03, -1.59601915859147411e-04, 4.72539428788721608e-04,
    -1.63508530969875198e-04, -8.04497515605788580e-04, -5.60952219538972049e-04, 9.62352783411973291e-04, -3.25986940863303451e-04,
    -6.62865052534385266e-04, 1.83077290521144301e-04, -6.67815027189929333e-04, -8.20763509623387072e-04, 5.50944728278969943e-04,
    -9.18368507559945896e-05, -4.97262747933818947e-05, 1.44527740863390717e-05, 6.02268801895407160e-04, -6.90060856109303935e-04,
    -6.61151667662298806e-05, 5.24607915693856908e-05, 8.71389161220942712e-04, -5.22209563697972917e-05, -8.81069372491589524e-05,
    6.89674388639323560e-05, 4.89296492873659379e-04, 3.42949950767033190e-04, -1.04594279689411803e-04, 7.88048702858046301e-05,
    -4.51080354005282619e-05, 1.92927499298747385e-04, -1.00799248168193510e-04, 8.42070445097134625e-05, -1.15456876718276306e-04,
    -3.52801267299761995e-04, -1.17385826010707806e-04, 6.41826840143688848e-05, 3.00430937194893165e-04, -5.88191734441591263e-04,
    -9.60097825665722621e-05, 3.24876263135078137e-05, 6.81936922695665707e-04, -2.77700061014415391e-04, -8.20877129250762892e-05,
    2.58047697700600437e-05, 6.00380468626232297e-04, 1.78126157739820522e-04, -8.91255866487739501e-05, 1.94618282851708810e-05,
    1.70413830952822023e-04, 3.43572086262713874e-04, -7.77228636917948808e-05, -3.36010502648343538e-05, -9.07658016101573108e-05,
    6.59277748270443569e-05, -3.98051260408716171e-05, -7.94909595164307867e-05, 7.05083701220457573e-06, -2.12150267214743503e-04,
    -7.10752955220507326e-02, 0.00000000000000000e+00, -2.81525293764823895e-02, 0.00000000000000000e+00, -8.89502773245340675e-03,
    3.66324267155502007e-03, -1.50462462993148395e-02, -2.63916495927209518e-03, -6.79652165859046149e-03, -1.65529453407753518e-02,
    -1.78928182217595808e-02, -3.14303722891423219e-03, -7.11006250769349781e-03, 5.34684474246508237e-03, -1.16327476368806200e-02,
    -8.05468546023600102e-03, -1.64149955851847803e-03, -5.35863352681676449e-03, 3.15321608325506422e-03, 6.26277160082160155e-04,
    -7.27484684891808748e-03, 2.70646376760276911e-05, 3.62617414329000813e-03, -3.65054682510651410e-03, -1.07696110037195595e-03,
    3.53182686525143003e-04, -3.38538738633310885e-03, -7.71206253588103529e-03, 2.05797839658368497e-03, -3.13248774975358191e-03,
    -2.15184243056480489e-03, -3.10225639086903707e-03, -3.54796544314458281e-03, 5.24964106894207014e-03, -3.81132388565878430e-03,
    1.24107114742582204e-03, 2.71419662078310015e-03, -3.13258905575883794e-03, -9.86678579803712151e-04, 4.35158904158106617e-03,
    2.00811015548373484e-03, -2.44534593887737084e-04, 2.98862265427273909e-03, -2.36637278792602287e-03, 3.79010793951217370e-04,
    -1.91817673989295003e-03, 2.40904857950564920e-03, -3.68671975810225518e-05, -7.50728259162286669e-04, -9.77411399558630834e-04,
    1.12160681390244201e-03, -9.57618916404621382e-04, -8.44772814505887035e-04, 1.60262870617885501e-04, -5.95028162206373166e-04,
    -2.17343777372838720e-03, 3.90627040005680354e-04, -4.03549139392471315e-04, 3.97904392302268501e-04, -3.35021587533471910e-05,
    4.01596406318290207e-04, 6.19679429553130195e-04, -5.84235894305245641e-04, -6.29586561100089689e-04, 6.85720848834345492e-04,
    -5.99546684685926617e-04, 6.48484311900055866e-04, 1.15749079052879009e-04, 5.89928032208336022e-04, 2.56662217500460083e-04,
    5.35723750474414269e-04, -3.87102961262356411e-05, 3.59715192754469484e-04, -9.00619185516589576e-04, -3.38206174007513985e-04,
    -9.06717141110745728e-04, -1.06691607710405902e-05, -5.73066630815214089e-04, 5.82183667967025014e-04, -6.19647103989654315e-04,
    3.46608782632846157e-04, -3.19542958077236765e-04, 3.35326676850777677e-04, -1.19041590268576002e-04, 3.84807935714832959e-04,
    -1.52580432572096801e-04, 2.88659162699535080e-04, -2.17457459774854719e-04, 3.15640030614073891e-04, -1.14589683204190809e-04,
    3.56359089290164666e-04, -2.36086433127905303e-04, 2.57962183435875032e-04, -1.32919881425900210e-04, 4.21275854832142444e-04,
    -1.68637918303468496e-04, 2.60132103423249507e-04, -1.76518696101003004e-04, 3.98510318978629783e-04, -5.55874927229614931e-05,
    2.72262300197169426e-04, -1.54791064873725413e-04, 3.23912719054422868e-04, -3.97599407313694884e-05, 2.79412001537185026e-04,
    -1.05419347221602004e-04, 2.74788768477940990e-04, -7.92444947406713388e-05, 2.69699801276835011e-04, -7.08821370313268408e-05,
    2.98757387283285329e-04, -1.28176226969026500e-04, 2.27528760050574108e-04, -3.45101835866923435e-05, 3.27201675215891879e-04,
    -1.03881991208881104e-04, 2.10033165807443418e-04, -8.75501048007582717e-06, 3.14478195541950775e-04, -4.79621649743055035e-05,
    1.67328405215387999e-04, 5.84472169559277965e-05, 3.00859150369670600e-04, -4.13684186119337124e-05, -1.21379119254994196e-02,
    0.00000000000000000e+00, -3.44462771591686687e-02, 0.00000000000000000e+00, -2.10316876980239705e-03, -7.47964378791162073e-03,
    1.40631809424170899e-03, -4.56039796742323082e-03, -9.34831571155880781e-03, 2.15655290496510887e-03, -1.06117832938669408e-02,
    -1.70679350958285111e-02, 3.45017088487963204e-03, 3.82119470199968102e-03, -1.04997387285308396e-02, 1.63770792198145408e-02,
    -3.26765150921354405e-03, -3.41571868356958797e-03, 4.58286575207184597e-03, 7.06393644576057845e-03, 4.30168798968698536e-03,
    2.07824034827653725e-03, -5.00231032938888449e-03, 4.53087742807849192e-03, 2.91006074117702894e-03, -6.79674760908184714e-03,
    -4.20731287313864249e-03, 5.57341847431139063e-03, 1.84243144490180903e-03, 1.09041767054943606e-03, 6.02340248129294817e-04,
    8.87323969884404020e-05, 4.08856464359921205e-04, -4.12118732042999428e-03, -2.92119223691378500e-03, 2.52960402262236098e-03,
    -4.99253509354547322e-04, -2.00114581595349722e-03, 3.31933921536656500e-03, 7.87586653237865768e-04, -1.98777567108299191e-03,
    -4.35319605759405999e-04, 1.21890703961077709e-03, -1.74310547912238505e-04, -1.83804873490097005e-03, -6.33286472639934075e-04,
    -8.54973407243040696e-04, 8.38731087266057014e-04, 1.96859281933702002e-03, 6.71187690856791001e-04, -1.49680241656290503e-03,
    -1.31746694774600721e-04, -5.85150551831325094e-05, -6.08777129793491617e-04, -1.55499350657023103e-03, 4.32423633493066899e-04,
    -7.46011357659906449e-04, 5.16518970476651830e-04, 7.33542013514307950e-04, 3.00206273742392163e-04, -5.67707291610191050e-04,
    -3.97317356634302660e-04, 2.64927626375300240e-04, 1.32652469615073400e-03, 9.03100594211069126e-04, 7.93215800430159003e-04,
    6.39870260721876012e-04, 7.82518537978101281e-05, 3.10263950097946896e-06, -1.26280600703676396e-03, 1.35625753882703392e-04,
    5.92621033709781484e-04, 2.51897673756406736e-04, 8.35622028888639260e-04, -6.93190155969104597e-05, -2.47307402787471232e-04,
    1.97347646277906523e-04, -1.34291266624796601e-03, 7.04966419754734131e-04, -7.06261498209776703e-05, -5.18409841922224825e-05,
    7.90341985335329185e-05, 1.80027806692415588e-04, -3.60528094008153680e-04, -7.56475687345502479e-05, -5.09855582516119030e-05,
    3.43362661185179466e-04, 1.61699210709818420e-05, 5.50871102682905156e-06, -1.02545159022227300e-04, 6.00035958822780515e-05,
    2.98136883703973015e-04, 1.16044262782009412e-04, -7.17220274644972855e-05, -2.43404673157207726e-04, 1.65311416998437696e-04,
    1.41142580311535314e-04, 4.05231207494100349e-05, -2.82502183903395997e-04, -1.58301868094413317e-04, 3.25713204301173530e-05,
    8.34399540573364004e-05, -1.26258103319842004e-05, -3.02338835543194398e-04, -3.51598517208215631e-05, 3.05105441207013402e-05,
    2.02208048958474806e-04, -1.11880851566251209e-04, -5.75222282747011801e-05, -7.53488797685568308e-05, 1.64740146653522901e-04,
    1.55665282582546916e-04, 2.78627075985471035e-05, -8.24982697512496936e-05, -7.68641253913072698e-05, 2.11795439387258810e-04,
    1.08497663196070504e-04, -1.30771986857948203e-05, -2.15508188823196713e-04, 5.93088828912528187e-05, 5.92245582038734042e-05,
    8.71924479130562830e-05, -1.39371452945136589e-04, -1.15412352616742702e-04, -1.55050056359223414e-02, 0.00000000000000000e+00,
    1.08882691507289995e-02, 0.00000000000000000e+00, -4.71011842162717600e-03, -5.87720496469847434e-03, 1.05047777608648796e-02,
    4.58059600186255811e-04, -2.00504402837270619e-03, -2.95424720587515992e-03, 4.87799357670548345e-03, 8.35135183044262257e-03,
    1.94658690699765899e-03, -2.51595561155665282e-03, -8.21127194754033354e-03, 3.70391436894767405e-03, 6.83120937695324247e-03,
    -1.76002874535725103e-03, -8.63390502398148768e-03, -4.10387342301893592e-03, -2.35444581629096900e-03, -4.09310051133190012e-03,
    4.22858049368528928e-04, 3.15099824102575005e-03, -1.23657205447147900e-03, -8.10122047065819917e-04, -1.43423373808739592e-03,
    1.48713803506179206e-04, -5.85087310259259233e-04, -6.23235356221657727e-04, -1.06063231727299210e-03, 1.80378281336268697e-03,
    -9.30282245216480525e-04, -3.76269823446016231e-03, 1.84105606293760693e-04, 3.37515462362718115e-03, -7.38805157796997296e-04,
    -9.12877602010101418e-05, -1.02645186453899405e-03, 3.16915550462153802e-03, 8.21937753793873418e-05, 1.25314454345307408e-03,
    -5.88422124427039972e-04, 4.22118976254676735e-04, 3.62450580886171467e-04, 4.90060323653639541e-04, -1.34998872593530199e-03,
    -6.25809469695063941e-04, 1.07186821528799502e-03, 7.90345047493609437e-04, 2.06073300326440516e-03, 4.16554698971398525e-04,
    1.00476579342678512e-03, -5.22637914683046919e-04, -1.81017262357454885e-04, 6.19944137220488213e-04, 3.63742289398431666e-04,
    -1.10527646027455098e-03, -1.42755618597237006e-03, -3.07067139655041281e-04, 5.03169289358491628e-04, -6.13386797343335724e-04,
    -1.37656831881363109e-04, 1.21565460886625997e-03, 1.93210758951368198e-04, -7.27388822794831111e-04, -1.21911187459386103e-03,
    2.29157486346871021e-04, 6.67416548838800248e-05, 4.51521060719632748e-04, 4.64612988038229510e-04, 4.44675281930900941e-04,
    -4.22961891024955822e-04, -2.87267784296158901e-04, 9.37302358619733185e-04, -2.37795974551285302e-04, -1.61418528524817423e-04,
    3.59975251107788624e-05, -1.57709648390207509e-04, 7.99467773702482827e-04, 4.21146651409620644e-04, -4.26833911251724520e-04,
    -5.21716154653551769e-04, 4.97628543500075742e-04, 5.69987976708835435e-04, -1.00118566849244998e-04, -6.64319064977684495e-04,
    1.05701411709688202e-04, 3.40518869723608394e-04, 1.38903605427121693e-04, -3.87886151334127351e-04, -1.95775443050584909e-04,
    5.96229633518891928e-05, 7.96570701940503198e-05, -5.60593924645873246e-05, -1.03370927417524607e-04, 6.36583825020037681e-07,
    -2.04477272097361299e-04, -3.83914221304656642e-06, 2.13649300126834708e-04, 2.31094008501680310e-04, -3.30860288794278951e-04,
    -2.30463924421211216e-04, 3.94263693122693575e-04, 4.08880948289188305e-04, -1.53040820632931304e-04, -5.12662237394530674e-04,
    2.24113090569518506e-04, 3.65643596805839092e-04, 7.58146844467415010e-05, -4.58187196559824389e-04, -9.80416207378538508e-05,
    1.46100253250197316e-04, 1.33893857135371198e-04, -1.85809415470792585e-04, -2.14519862579163896e-04, 2.04062649947744427e-05,
    3.80782834009347831e-05, 6.10446036778424544e-06, -5.41890344947285041e-05, 7.34556813889813786e-05, -4.83384314725215133e-05,
    -2.59332653570620112e-05, 9.78677118932030546e-05, 7.19857997319553727e-03, 0.00000000000000000e+00, 3.32311287830635389e-03,
    0.00000000000000000e+00, 1.29016889639107005e-03, 2.60642731444820416e-03, -5.79342819017824098e-04, 5.30553834626121441e-03,
    -4.68788965044094827e-03, 2.08217120134517215e-03, 3.06452640436348598e-03, 5.58776901253584674e-03, -2.07323557931271898e-03,
    -2.51258894621679899e-03, -3.85306585928035317e-03, 2.82848860506730321e-03, 1.90040888967029416e-03, -1.58852311515139590e-03,
    -1.76310573539159793e-04, 5.21842268138928713e-04, 3.67316069752267500e-03, -6.98195275610524226e-03, 1.22648241960540911e-03,
    -3.85429235509009193e-03, 1.91566146354165903e-04, -1.33552008300326001e-04, -2.39186538029803998e-03, 2.63157630488062991e-03,
    6.36877311590974615e-05, -3.36814172885773399e-03, -3.97233550032412720e-03, -1.23589782939034797e-03, -1.42523994062913190e-03,
    8.72837867417999738e-04, 3.32205772971433909e-03, 2.07205784967486126e-03, -1.63524299563669795e-03, -2.98899158700940103e-03,
    -2.93061091875026396e-03, 2.44095189396288485e-03, -7.33561682360080094e-04, 2.19256835525849004e-04, -1.37923737441638804e-03,
    4.74155589490909838e-04, 5.50343470600480364e-04, 1.00710104262438410e-03, 7.63755994840873711e-04, 3.52120109902711968e-04,
    -4.30626975626065701e-04, -1.05186955567569901e-03, 3.11980751557737598e-04, 6.58461838349606908e-04, 6.30925164678347626e-04,
    6.91309027775518218e-05, 1.47672053042282301e-03, 1.92736773096099717e-03, 3.53213480182088489e-04, 1.06216068629913702e-03,
    3.41679775713064481e-04, -6.50019951649382938e-04, -4.56695902171019223e-04, 3.93151598436330794e-05, 1.04036608397413606e-03,
    -1.18660622982701093e-03, 1.15800807328811394e-03, -7.09182118909679562e-04, 1.90406623619408615e-04, -6.86534881354838433e-04,
    3.74063714066177986e-04, 2.87317791919599233e-05, -1.16732558544984798e-03, -1.10231759344286994e-03, -1.45057348478687506e-04,
    -5.57631367297447612e-04, -1.26396191893281599e-03, 9.56518764874356837e-04, 2.31333566436199502e-04, 9.41915043002358412e-05,
    -3.56903031585823878e-07, 1.70374203686440915e-04, 4.97443740660158911e-05, 5.02386869340809095e-05, -8.05492641090750411e-05,
    2.03150152926000996e-04, -2.65367060549427609e-05, -1.39929371447721412e-04, -1.81910288097425200e-04, 3.94364895467108318e-06,
    1.36003216887327697e-04, -2.46687639381463130e-04, -4.25147549979305140e-05, -8.12611885612382043e-05, 3.02172089350402477e-04,
    -1.81936841170158323e-04, 3.92697525610298230e-05, -5.64000622052212617e-05, 2.99517040483845130e-04, 1.13720483995726007e-05,
    5.49904859412459219e-05, 3.88977423049413005e-05, 1.38947205623771099e-04, 1.02861024666216704e-04, -2.71713077848858631e-05,
    7.39149761082318377e-05, -2.13569983855703405e-06, 1.95773483474666312e-05, -8.34252306505384720e-05, 1.68968172956159728e-05,
    5.64292102822087512e-05, -1.35096864921712995e-04, -7.11597471040555693e-05, -2.52508230251673836e-05, 1.83000199944189002e-04,
    -1.56863264288969296e-04, -2.39818567491244685e-06, -3.74840941875673682e-05, 2.52668447454548132e-04, -7.34450727330187984e-05,
    2.95967272053869410e-05, -5.33444905612428026e-06, 2.22014749180963908e-04, 2.93310494637914723e-05, 5.44126157522075029e-05,
    3.76250220322146280e-05, 2.78416115424583296e-03, 0.00000000000000000e+00, 1.26854722193290095e-02, 0.00000000000000000e+00,
    -9.47804839873612852e-03, -4.45215591850271764e-03, -2.28388657889899401e-03, -3.32276281845919792e-03, 5.62482041639104599e-04,
    -2.53847581390776594e-03, 1.34408286936057005e-04, -1.61357826059901704e-03, -2.84333470827229182e-03, -3.22367666765658104e-03,
    -3.07078967414139861e-04, -1.05330262451769005e-03, 1.51227891659255200e-03, -2.70213282972538897e-03, 2.02388698147050521e-04,
    2.20186932966095301e-03, -3.46483641839626620e-03, 1.55788110436725713e-03, 1.30282918690895205e-04, 3.74261542464799681e-03,
    -3.16046541370569589e-03, 1.31143131345886309e-03, -3.08399041187059568e-04, 5.99037253132680470e-04, 8.62250737785963677e-04,
    -1.73930881785822793e-03, -5.02626684595700274e-04, -1.60752061144315206e-03, 7.20944097052917190e-04, 8.65412307424915685e-04,
    -3.32776058197007101e-03, 2.18561816312586005e-04, -1.22068813598305397e-03, 8.37000871453652122e-05, 2.89630578538259539e-04,
    4.82163205454582029e-03, 1.58867890981335318e-03, -6.22401809893891717e-04, 1.73896479816057600e-03, -5.20439782855769287e-04,
    1.14168473800226804e-03, -7.20558866174143202e-04, 8.74793001198065205e-04, 1.64170074485570604e-03, -7.27026482331195574e-04,
    1.04357444655336007e-03, 4.59221225965631406e-04, 4.24503050387132737e-04, 8.77028221914163226e-04, -6.33662223335107683e-04,
    5.80098072084693720e-07, -1.94429183743168813e-03, -2.73977550274014515e-04, -1.22197633314669800e-03, -3.66274805050316758e-04,
    -1.18302708414683407e-04, 4.83059391503256827e-04, -7.07985315638565041e-04, -7.25686338634964055e-04, 7.23020017804716305e-05,
    -6.42241235767167500e-04, 9.07713195018969711e-04, -2.93369116036286404e-04, 1.04773232584438295e-03, -3.97340087708606071e-05,
    -4.37058278643554128e-05, 8.83966961412785890e-04, 1.21999205784775700e-03, 8.94789314789739523e-04, -8.52167205194715740e-04,
    7.03592776492062985e-04, -1.02021757762579498e-03, 7.16083852460278780e-05, -2.48733302885627229e-04, -1.70335565690782711e-04,
    -2.20660416975401708e-04, 1.87004473663415186e-04, -2.36331832688707318e-04, 1.15639534404308602e-04, -2.09475188880555710e-04,
    2.99683684796347039e-04, -1.29855910005338915e-04, 1.75091368398453285e-04, 3.55882792130287544e-05, 2.34718856730567211e-04,
    1.51728148824903899e-05, 2.54166504458850315e-05, 1.64049233181359300e-04, 9.01549142149536497e-05, -1.71648594910176101e-06,
    -1.59944524407326617e-04, 1.19348548726544397e-04, 7.85268336308512794e-05, -1.03800844517790107e-04, -1.81405986799001117e-04,
    -5.13845974642025707e-05, 1.63365999753164808e-04, -1.42106018914941090e-04, -1.00097984965546201e-05, -1.62863659689661610e-04,
    2.30666095969170819e-04, -8.81570200580615110e-05, 1.38332264647423106e-04, -7.84715508241847002e-05, 2.14089085919024407e-04,
    -9.69562479731096954e-07, 1.16669648028640911e-04, 9.26066168070304737e-05, 1.42929551657034615e-04, 4.86176193502030807e-05,
    -3.75360180136114031e-05, 1.36175658034411997e-04, 8.05716768732491124e-05, 1.91707714907214908e-05, -1.27718856709836399e-04,
    2.04269030182744926e-05, -1.03334865816164002e-02, 0.00000000000000000e+00, 2.69365088408525391e-03, 0.00000000000000000e+00,
    -6.21250475397177519e-04, -1.35909955444097702e-04, -1.27945203373861101e-03, 1.90953207115528200e-03, -2.77850442376668429e-03,
    1.82862043928144194e-03, 2.66233674928770606e-03, -1.72532539859110087e-03, -1.01000873702640102e-03, 4.43243166778230311e-03,
    5.00370125591865882e-04, 6.35632869696106575e-03, -1.95259500854165317e-03, -1.87608290871500000e-03, 6.66882212379246231e-05,
    1.13997830429131398e-03, 2.26573181023742316e-03, 3.31913493881087112e-03, 7.10866341422408785e-05, 1.03399524854338207e-03,
    -2.88342179376523534e-04, -7.57173461251488050e-04, 1.36785880414229898e-03, 1.77020330499936900e-03, -3.23746337552742285e-03,
    -7.51329696680427665e-04, -3.11037507343977409e-03, 1.40367482810333389e-03, 2.03570909239716123e-03, 1.75365599912788613e-03,
    -7.08325905403631834e-04, 1.68119206080417092e-03, 8.48077650551798824e-05, -2.99705652529596103e-04, 2.99009451038331677e-03,
    2.85542960442462627e-03, 1.23578474740311409e-04, -6.38235388827023439e-04, 1.51611990460678208e-03, 4.61776934587180546e-04,
    -1.33829897826344001e-03, -3.75584022082175160e-04, 2.48101123647880809e-04, 3.85122657189657569e-04, 5.51670773382135333e-05,
    -1.85882436015654090e-04, 4.87174768902445344e-04, -1.83533572841154896e-03, -1.27644194171767705e-03, 8.68015753068456745e-04,
    -1.31905566544782702e-03, 7.65379040425717737e-04, -2.19797395477818716e-04, 3.88332435901323088e-04, 3.13034401313501485e-04,
    -8.59762290013867548e-04, 1.13994740546106998e-03, 1.72994716473204605e-03, -1.89307846611188403e-04, 6.98495755050348890e-04,
    3.01973282939228989e-04, -7.74094999922277186e-05, 1.16378030420384910e-04, 1.29967573750049191e-04, -5.72500693830566416e-05,
    -8.22972732968274339e-04, -3.12276374844850854e-04, -1.08545016715341010e-04, 4.78239995403885131e-05, -6.14717757473743454e-05,
    -2.23684510111112999e-04, 6.04283674132463503e-05, 9.19527187931604801e-05, 2.31593535142378412e-05, -2.03967753321729318e-04,
    -1.35370345643743119e-04, 1.14790539148631810e-05, -1.74220441476465203e-05, 1.82429012417977831e-05, -6.38348667371286822e-05,
    -2.70462292805629515e-05, -6.86210087098047746e-05, 5.65492551243059147e-05, 8.81166356637452818e-05, 5.29353466250463340e-05,
    -9.92223055798126811e-05, -8.05966223176598730e-05, 1.61920504601891299e-04, 8.00282427584589920e-05, -6.22535596383927311e-05,
    -1.77477592715217017e-04, 1.06509181968351499e-04, 6.66734941894863201e-05, -1.20710760285688811e-05, -1.89746906538367400e-04,
    -2.94151505612680823e-05, 4.31300335916989639e-05, 6.23352108610686946e-06, -6.80348953995890205e-05, -9.08766889893978445e-05,
    -1.29721911177051616e-05, -1.67407832425932389e-05, 4.30275146318171822e-05, -2.82181843060568528e-05, -7.85956166541929683e-06,
    -2.93591647656230893e-05, 4.59262032554511328e-05, 1.02171357029562308e-04, 3.63911400851528937e-05, -4.73433551198325242e-05,
    -7.05174086134095903e-05, 1.12859884248809006e-04, 8.44054700606726937e-05, -1.95691919855953615e-05, -1.32409500860587216e-04,
    1.07325320429094103e-05, -3.85655230757970310e-03, 0.00000000000000000e+00, -5.39979047907412739e-03, 0.00000000000000000e+00,
    5.60193598745740377e-03, 1.34496931366289698e-03, 1.84053007999470698e-03, -3.07922098017868098e-03, 1.39726178798314999e-03,
    4.39676641449973649e-03, -1.68890814938530798e-03, 1.07275962852819507e-04, 9.37596905032942862e-04, 3.29160028373130104e-03,
    -1.93176530108272017e-03, -3.82389751326079903e-03, 3.28111585382161977e-04, 1.35165071421654509e-03, -2.44934605063826206e-03,
    -1.01374060585952093e-03, 1.90315179056236802e-03, -1.16243792021998994e-03, -2.23449354109382789e-03, -1.37390419356787702e-03,
    2.67043029813209421e-04, -2.46387317504163407e-04, 1.27404158449048992e-03, -3.11409821004060127e-03, 1.42054350882327412e-03,
    8.50945067451520584e-04, -2.18139096460945791e-03, 5.37585425556584451e-06, 7.70672126369275528e-04, 1.47205746609291919e-05,
    -2.27122252035303826e-03, 2.73471086137731237e-04, -1.71770098939768396e-03, 1.79548953791325598e-03, 1.07201759382979695e-03,
    8.00872631239443744e-04, -6.93421194978720073e-04, -9.30281393379723794e-04, -6.30390648496625906e-05, -5.82231422949086564e-04,
    -8.46299597976315013e-05, 9.00081479610586330e-04, 1.17059400966708599e-04, -1.17657919631858798e-03, 3.80463130954153492e-04,
    5.94799888416260611e-04, 1.37458545422499095e-03, -8.65911436633437981e-04, 4.03986631244411239e-04, -3.68569836363924258e-04,
    -1.37212853610761101e-03, -3.54583726830509790e-04, 8.18394448681560531e-05, -6.41741245488995269e-05, -1.10730062409925695e-03,
    -3.87839975193070567e-04, -1.49797684923353618e-03, 2.76129210001028514e-04, -2.21530592066440717e-04, 3.67206383764497469e-04,
    -1.63449552926589903e-04, 1.33340756263806808e-04, 1.37461576726487196e-04, 9.37402543812214275e-04, 9.35976623153734815e-04,
    1.09446608551640808e-03, 6.60314338498173671e-04, 7.41023267300118505e-05, 1.96356821062653686e-05, 3.34462678969324925e-06,
    9.07111562029388140e-05, -8.59497626179119625e-05, -6.54182748356717204e-05, 3.18023886151265879e-04, 1.24059973148808592e-04,
    1.29131408350483987e-06, -2.85001271494982804e-04, 2.98328205348700711e-04, 7.22351177834776889e-05, 2.65141433646711721e-05,
    -3.79703799498017980e-04, 1.00891724908919100e-04, -5.67380361354338442e-06, -1.33785413564818402e-05, -2.54723362593513693e-04,
    -9.25645051781121415e-05, 2.47768104742008215e-05, -6.62764910229686775e-05, -5.69736192888645860e-05, -3.41068237011527789e-05,
    8.09156539163736121e-05, -5.62162696420001598e-05, -3.43941083506186279e-05, 1.33619279220014320e-04, 9.09933194450521986e-05,
    1.10025788491296402e-05, -1.41269448084213606e-04, 1.97425730308574887e-04, 4.13949297778524444e-05, 2.28029456020616418e-05,
    -2.51957187227819538e-04, 1.07087421267623703e-04, 2.01951240903083911e-05, 2.16232156916533599e-06, -2.34732325786082114e-04,
    -3.44848725799019331e-05, 1.02322264729879813e-05, -2.95808799705676908e-05, -1.27372633332256295e-04, -1.01181675232029001e-04,
    2.43965285934001316e-05, -1.56339350729979790e-05, -3.10666087069938407e-06, -6.48565764324702686e-05, 5.66240428071342533e-05,
    -4.80947203208227109e-06, -3.27434987496428307e-03, 0.00000000000000000e+00, 1.94001371970481206e-04, 0.00000000000000000e+00,
    -4.22146600015671676e-03, 1.85560412822053321e-04, 5.91960667993999233e-03, 3.46745751020892997e-03, -1.49624542277282911e-03,
    -7.46997420480836351e-04, 2.71956837568511616e-03, -2.00362589759237692e-03, 2.84403667909016201e-03, 1.38522786944513302e-03,
    -5.36253982302081788e-04, 8.98944385900057180e-04, 9.45948316279443557e-04, -1.10724429141635401e-03, 3.46491308247556264e-04,
    1.71076868721512518e-03, -2.83621464332214999e-03, -1.04214110182014098e-03, -3.29843443238391268e-04, 1.16249263818666692e-03,
    -1.51263971259868598e-04, -5.12095086650722468e-04, -4.43868928176068683e-03, 1.09452571151002305e-03, -1.95905282494774008e-03,
    -7.16502823696713313e-04, 1.80703181275910802e-03, 3.08021488597660107e-03, 7.63416447485232405e-05, -2.40820896115498200e-04,
    -5.42123846874502098e-04, 2.79921673263123887e-03, 9.56711213597357204e-04, 9.12734617363823698e-04, 1.18329385902973100e-03,
    2.70548437862810518e-03, -7.56421605209681158e-04, -1.10451578857403000e-03, -4.68535394733205607e-04, 1.19301359831118807e-03,
    2.28790726615612307e-04, 1.01465655922533307e-04, 4.07810849728176426e-04, 2.37329397140924927e-05, 1.67118007317343706e-04,
    -1.85034347043011804e-04, 2.39043782577092709e-04, 1.07377907210822799e-03, -5.05008157646158105e-04, -3.03557662440200656e-04,
    -5.24421474456220906e-04, 7.10470807822329150e-04, -2.65441489219161812e-04, 1.86528767525131816e-04, 1.18768236344364813e-04,
    2.73773866769723212e-04, -1.37336329257661718e-04, 4.25102267178067332e-04, 3.61425250084589772e-04, 9.31561412223019954e-04,
    9.00923909497920207e-04, -6.91244956332927194e-05, 6.81184644780815534e-05, 4.94292460722651344e-04, 5.57832768280572605e-05,
    -1.78247906031541014e-05, -5.39356541770310516e-05, 1.12847683543339510e-04, 6.97768161894662503e-05, -1.28801112173031391e-04,
    -1.36258124552730511e-04, 7.52752984009248194e-05, 1.80478192845277815e-05, -1.41645378129016193e-04, -2.57661323644306191e-04,
    1.41172970367211290e-04, 1.68446669744071312e-04, -1.43510684701046498e-04, -2.49605693568589191e-04, 2.09270025912965222e-04,
    1.73380332203807320e-04, -4.31528168315061845e-05, -2.69385649188820129e-04, 1.44262017722768493e-04, 1.21410391924219496e-04,
    -2.07613658141512274e-06, -2.75471606365465440e-04, 7.75847983715348654e-05, 6.67669015816173777e-05, -3.47205197316259882e-05,
    -2.20564258990204199e-04, 6.79078647130726426e-05, 5.59892631528520842e-05, -7.15773427619622281e-05, -2.01846729733602123e-04,
    8.12540527443827596e-05, 8.67509042232947450e-05, -9.40223467407713106e-05, -2.10067860124576197e-04, 9.90070868211715723e-05,
    1.27019435552551516e-04, -5.23811311183937698e-05, -2.22191208252392599e-04, 8.42154234690965325e-05, 1.31078778198552006e-04,
    5.85256321380583660e-06, -2.20106146426574611e-04, 3.43903585322539085e-05, 8.17679926137757117e-05, 3.57696523905280228e-05,
    -1.71306620715922918e-04, -1.69639454518841103e-05, 3.60183337728328407e-03, 0.00000000000000000e+00, 1.21002498222732104e-03,
    0.00000000000000000e+00, -5.31067389607137001e-04, -2.22812727852063006e-03, -8.94992413192695607e-04, 3.02492958377452523e-03,
    4.52889634571147846e-04, 7.04024195597577774e-04, -1.76994018522177218e-03, -2.78698760786973490e-03, 8.84419486352532524e-06,
    -1.60114345443433800e-03, -1.79602328856612098e-03, 1.69645827046587699e-03, 1.22263306124923104e-03, -1.38672671784444796e-03,
    -1.81715401816120699e-03, 1.12291672961585505e-04, -1.74014595698025396e-03, 3.00638238969133014e-03, 5.38769342023656716e-04,
    1.01168286456173001e-03, 1.25835738989465897e-03, -2.14855111778818704e-03, 1.94025636506503399e-03, 1.60138198682476798e-03,
    3.04996716051287957e-04, 1.51347934909390003e-04, 5.21670106763438379e-04, 1.75693890008179202e-04, -2.26149697116798717e-03,
    -2.18303710192580295e-04, -1.51398914585641406e-03, -1.58816215964855886e-03, 1.55927169355978798e-04, -4.94225640241941215e-04,
    8.36202145908589763e-04, 4.73292588125403895e-04, 1.06473894198859907e-03, 2.09611117891008196e-03, 3.25952685546390664e-04,
    -1.01655912251420307e-04, -5.18107271101577132e-04, -3.16226537170489612e-05, -6.51602000247405327e-04, -3.27558099950500984e-04,
    1.17758636912919704e-03, -2.12360966362415822e-04, -3.87091188014523164e-04, -9.60683801574256695e-05, -1.30698707823795617e-04,
    -9.27708167827058093e-05, 4.67257929136822116e-04, 5.26735365201713777e-04, 8.67242094192128112e-05, -7.67583181024485969e-05,
    2.96172266445650628e-04, 1.17659790932125708e-04, 7.92032613046985052e-04, -4.73512687405615112e-04, -1.16486541346945304e-05,
    -4.35223289100590137e-04, -4.07299279253803910e-04, 3.52623807285629663e-04, -5.29775841676903103e-04, -4.05973013715962621e-04,
    3.01167171669751194e-05, 4.49564889859656861e-05, 4.98072315856021145e-05, -4.68575668174601442e-05, -4.26129773365465023e-05,
    2.68927754707826733e-05, 4.85345234325915614e-05, 5.01423283319458619e-05, 3.74641852071465678e-05, -1.15116648622984601e-04,
    -6.37275438469799910e-05, 4.80550144767946612e-05, 1.06992536936288300e-04, -1.04196940176600408e-04, -7.16075071301549481e-05,
    2.43099112315813413e-05, 1.17741921950054504e-04, -3.77547890067578420e-05, -9.10460029082267824e-05, -9.11504130315538267e-06,
    4.97971810224103162e-05, -1.58264998536182614e-05, -4.29621030846360960e-05, -1.14992848529921406e-05, 1.54112443854980599e-05,
    5.70264442689391733e-06, 1.07379249356645216e-05, -2.07929050873082623e-05, -5.79162054506014299e-07, -1.78040733197804610e-05,
    2.89084424773166903e-05, 2.71190365929275905e-05, 5.58295705560797958e-05, -6.04971618174102746e-05, -3.76119450581838938e-05,
    5.89902787458344548e-05, 9.92815613917080503e-05, -4.15442049260147703e-05, -9.02971715609474616e-05, 3.14235053266474025e-05,
    1.01079611905228811e-04, 4.68143507524649596e-06, -6.77319129898850883e-05, -1.82988584621209425e-05, 5.02189403381184127e-05,
    1.73189683402960021e-05, -4.66784771895106733e-05, -2.66409942440282929e-05, -1.34728524105830606e-03, 0.00000000000000000e+00,
    3.12714909306053895e-03, 0.00000000000000000e+00, 1.18306606932572895e-03, 6.05240992502963007e-04, 1.88764954821659086e-04,
    5.42596575385474313e-05, 2.38749601975439107e-03, 1.22954432709531194e-03, 1.48925894226772590e-03, -2.20463386750377596e-03,
    -1.18702352618399401e-06, -1.90558390450811617e-03, 1.14020421473847301e-03, -2.28729301768068621e-04, -1.88094245511257613e-03,
    -2.01084137143882813e-04, 1.32488933882795711e-03, 1.18616181726357499e-03, 1.29398001359800913e-03, -2.71207856984953012e-03,
    8.19803578829499032e-05, -6.65644985171580774e-04, 8.75321220674210219e-04, 1.84074218759263395e-03, 4.06738204865472806e-04,
    4.38901299441693939e-04, -2.67651935970348621e-03, 6.81954479043894637e-04, 6.68960422943894986e-05, -9.81998477803277181e-04,
    1.20805174682736713e-05, -2.81493824936257227e-04, 6.95809492034823291e-04, 4.19125664581867304e-04, 1.75523867792575210e-03,
    7.32292775253121737e-04, -2.82641400905200510e-04, -1.46138290430873900e-03, 5.75321504003394740e-04, 2.86865541338693028e-04,
    4.34876815609579008e-04, 7.83080633245084208e-04, 4.94068325342467878e-04, -8.49557197723212068e-04, -8.31842546134029881e-04,
    5.34145624564779644e-04, -6.14076102583219338e-04, -9.72964231627292640e-04, -1.43721827729833109e-04, 2.01814576789058711e-04,
    7.67106614249287539e-04, 7.90377521464399315e-04, 4.14567584917532341e-04, -1.99241162791407225e-05, -1.66330553501719002e-04,
    -1.39824103009899810e-03, -4.42117898608442521e-05, 5.84579711485059780e-04, 5.75612275643427223e-04, 2.74664173075564607e-04,
    2.65715923566144636e-05, -4.21666909316897534e-05, -1.19734102816029612e-05, -1.94256110037154401e-04, 1.01515434301023007e-04,
    2.67927527956691980e-04, 1.21374022529998612e-04, -3.81182434679552928e-05, -3.99384457032958676e-05, 1.67162746294344109e-04,
    6.14866880150712615e-06, -3.85414892397567823e-05, -1.12966523933537806e-04, 6.34552866927493963e-05, 1.93741280076219993e-07,
    4.10563732161052979e-06, -1.26284088177673306e-04, -7.55315779155755080e-05, 1.92745758019108296e-05, -1.13406998393739012e-05,
    4.07566430480326360e-05, -4.48671856566166020e-05, 5.14430653688213020e-07, -4.07333593756617344e-05, 8.00104941396855918e-05,
    5.41507565868616441e-05, 3.98494652648809884e-05, -2.07914223765169624e-05, -1.25512252041928818e-05, 1.41940036871691613e-04,
    7.32425589110114811e-05, -2.51512828443974635e-05, -1.19512272253876809e-04, 9.67416793113340325e-05, 5.82166703146601216e-05,
    -6.26370433431184249e-06, -1.09923499775177200e-04, -2.87744323783186204e-05, 2.54233406189743207e-05, -2.10691302726592179e-06,
    -3.12188949662077221e-05, -5.86605172857020092e-05, 1.89560583816991700e-05, -1.04040428617575500e-05, 4.44595633021011336e-05,
    -1.56251824021060200e-05, 3.41616520292055713e-05, -1.52515501601725206e-05, 2.31782612290289723e-05, 4.54765941433281945e-05,
    3.70353965639083326e-05, -2.48628648484161422e-05, -3.78366768210461839e-05, 6.18128780983269579e-05, 1.00801012570994608e-03,
    0.00000000000000000e+00, 3.47342291476345876e-04, 0.00000000000000000e+00, 7.91801506949049000e-04, 2.41648709536439622e-03,
    2.75878765148988314e-05, -1.42178280189469899e-03, 9.03240112720424823e-04, -1.56794445064509409e-03, 2.94565430782157717e-04,
    1.18232427518331494e-03, 2.50420503753315303e-03, 7.18942036700169896e-04, -5.36395691591266192e-04, -1.86258200998779509e-03,
    3.29548349853266565e-04, -5.13252882376217934e-05, -1.94254317541928687e-03, 2.18830456667285195e-04, -9.60854372387139272e-04,
    -1.16624243286916505e-03, -7.85552741685865383e-05, -1.32933508428586297e-04, 3.09585668826129650e-04, -7.10966795883627824e-04,
    -8.71756659030432663e-04, -2.27897207039004610e-04, 1.61772288010974315e-03, 7.16790313587811995e-04, -5.01650554121614123e-04,
    9.71216763704305639e-04, -1.22884709652954904e-03, -1.46349407630147108e-03, 3.77995433273275170e-04, 1.17850182886075107e-03,
    -8.07524644944247099e-04, 5.47488208982875005e-04, -2.83179916648217922e-05, 3.22551697665504763e-04, -1.09287117692114400e-03,
    -9.25209472688941724e-05, 1.55444562488144710e-05, -7.54245519189904352e-04, -1.14660162251744202e-03, 7.48883115386481937e-04,
    1.71732250142289308e-03, -1.47036164048469710e-05, 4.51407428437879436e-04, 1.18680813584906390e-03, -6.72638438381541063e-04,
    -6.97316848749536490e-04, -3.08263583383085790e-04, 5.65595983350456626e-04, -5.59797981166573668e-04, -4.26396998746973431e-05,
    5.98503817888803680e-04, 1.13018384155006801e-03, 7.22319902981317995e-04, -4.73045270082827313e-04, -9.90990376668181587e-05,
    1.31642491991061888e-04, 1.56034616915051694e-04, -1.14773260272165305e-04, 2.03221727850923800e-07, -3.50912025092656228e-05,
    1.32230955962657016e-04, -1.98452567834938321e-05, 1.05361071131588310e-05, -3.98500767524021935e-06, 2.79257280511491612e-05,
    -8.26066314796087718e-05, 3.94515619184286295e-06, 1.43449934940676807e-05, 7.28684565532049394e-06, -2.02274386187340809e-05,
    -5.80238351293255621e-06, 6.41043912182615570e-05, 4.18971091022072242e-05, -1.17256699183353403e-04, -1.80114114610353696e-05,
    2.98002704400505139e-05, 6.00549650472916225e-05, -7.26624164000236908e-05, -5.08022754955713893e-05, 2.12961246777251218e-05,
    8.15905788537672430e-05, -5.24679151035354737e-05, -4.72793083387787640e-05, -1.00706341258723311e-05, 7.85407806503067980e-05,
    -1.67426868521839296e-07, -1.53964885518920599e-05, -1.73452868932099002e-05, 5.41309373643272800e-06, -7.78796169440987244e-06,
    4.24209004120176683e-06, 1.31103899532218097e-06, 9.03134330516295739e-06, -5.47716075715314646e-05, -1.75259416817880711e-05,
    3.39369459010566274e-05, 4.45394216516285720e-05, -6.33645059964500198e-05, -4.53989029125374428e-05, 2.30499073301049214e-05,
    7.01930476332635278e-05, -3.70740476127565899e-05, -3.95730802289417580e-05, -1.28283101994449709e-05, 5.13649901186186223e-05,
    1.62222452549143097e-05, -3.95332838575619596e-03, 0.00000000000000000e+00, 9.73971711510582564e-04, 0.00000000000000000e+00,
    -1.63334095657213601e-03, 2.47566297975661915e-03, -4.61067854034823989e-04, 1.00227945503756797e-03, -8.98849702359479129e-04,
    -9.89062784124243724e-05, 4.16612817020121440e-04, 1.69845399686099387e-04, 1.40704833076194490e-03, 1.58608145473462586e-03,
    -1.91534747392348593e-03, -1.50556041518790020e-04, -7.41177503466006714e-04, 1.80077341737210116e-03, 1.82148333058896402e-03,
    -2.36480063043344104e-04, -6.69607791546209994e-04, 1.45142101651430299e-03, 1.73832130576143714e-04, 8.93804851118562668e-04,
    5.14804835010676596e-04, -8.60802883056195796e-04, -1.49094753190589895e-03, -5.49339444448599160e-04, -9.43782543463274435e-05,
    6.78581866352359793e-04, 2.40555226995407996e-03, 5.50420320933374310e-04, 1.06689345052416503e-03, 1.11546355912698204e-03,
    -2.51654815915527226e-04, 1.05362642615015507e-04, 1.51342669550902598e-04, -1.18709605961395514e-05, -3.48687623727660372e-05,
    2.66172462883273715e-04, 1.22640520127150393e-04, -3.53049495511274401e-04, 2.10819480972762000e-04, -1.32719882022899207e-03,
    -2.68288818956041589e-04, -2.09821739624757906e-04, 4.54672184206733891e-04, -1.85821605909427607e-04, -6.69258067322836808e-04,
    4.19466498351806936e-04, 5.98458432727136413e-04, 3.41464685789424362e-04, 3.08215819645630260e-04, -2.95548945659434843e-04,
    -7.24507159240115662e-04, -1.69082755504923292e-03, -1.93520904983491714e-05, 1.35191372580951795e-04, -2.56397811086976233e-05,
    2.33630592103984520e-05, -3.87116937938718973e-05, 7.81921474464154553e-05, -6.33964727838977121e-05, -2.12567160577475314e-05,
    -9.42215352607953948e-05, 5.33226219041193637e-05, -2.21376049296527211e-05, 6.92024697881541171e-05, -1.20697375237608106e-05,
    -5.29224653986627494e-05, -5.69801791450185759e-06, -3.27120027041702426e-05, 2.85749659021073320e-05, -4.20546764722071632e-05,
    1.98781427031484195e-05, -5.38405801763815410e-06, -3.60922281559310912e-05, 2.75190032543574721e-05, -2.65219063811620724e-05,
    3.90728273668446096e-06, -4.56887670342133939e-05, 1.64537934490613995e-06, -4.85903112312865320e-05, 4.24402246231590422e-05,
    -4.13561365234884525e-05, 8.75373073637312674e-06, -1.21030282885749017e-05, 6.58122011178998717e-07, -4.77810740958057329e-05,
    7.18444564697379224e-06, -1.26287955993816603e-05, -4.19957851422694573e-06, -3.40668636228985117e-05, -1.81427746122776006e-05,
    -1.29807277238031617e-05, 1.52633508008959505e-05, -9.32846106770538938e-07, -8.25199093839484345e-06, -1.53075654575231387e-05,
    1.90849812166562513e-05, -1.94244976250517904e-05, 2.30351054519609033e-05, -8.12019352100231694e-06, 1.41254032313609714e-05,
    -5.15379624616807793e-05, 2.10763449534356613e-05, -3.20853263814959310e-06, 8.77168653988632320e-06, -2.58071167847657522e-05,
    -7.75701334972038760e-06, -9.93028892835044389e-06, 1.38436251757236696e-06, -5.72249229404819815e-03, 0.00000000000000000e+00,
    -6.32581087658179333e-04, 0.00000000000000000e+00, 1.61767889408735797e-03, 2.19778973626455487e-03, 1.96918718115947095e-03,
    -2.65739741538310219e-03, -4.02877235435324934e-04, 1.82841358339318606e-03, -1.98190948111654397e-04, 1.84031700925872818e-04,
    9.14586352256133118e-04, 3.19426607242560368e-04, -2.39250809083575884e-03, 5.81493000541998505e-04, 3.77857679493603688e-04,
    -6.86936120110013377e-04, -2.82807248390244833e-04, -6.70701771087373505e-05, 1.05241439367069302e-04, 4.46545395702673144e-05,
    1.68820664009942988e-03, 1.18800350711883193e-03, -6.58313265148805686e-04, 1.17053380848879200e-04, -7.17271890677809485e-05,
    1.85577007448963415e-03, 6.56520849846081700e-04, 8.06017465774315294e-04, -1.93797726968085720e-04, -1.75313812654149300e-03,
    9.27674844695662668e-04, 1.17445496798684705e-03, 9.54690738368271698e-04, 6.09946281790876106e-04, -1.02725245012973807e-04,
    -1.03470126681415200e-03, 2.71870677502123641e-04, 1.01664056791575709e-04, 1.40092211191593103e-04, -7.42827786391725441e-04,
    2.54015410108206197e-04, 4.62154858422488414e-04, 4.73601196282340514e-04, 8.36667553932069407e-04, -4.24839064668559993e-04,
    -1.18580662211388403e-03, 5.53470270383688029e-06, -7.12069686521007972e-04, -3.12850226308962768e-04, -6.28311957809785690e-04,
    -8.30599693854902740e-05, 1.55928940929191389e-04, -1.60018398001453190e-04, 1.85250076757384821e-04, -1.57732838480953709e-05,
    2.95813088176528736e-05, -2.23827148064990915e-04, 4.80249509368113500e-05, -5.82639775077897334e-05, 7.00915612005133102e-05,
    -1.77709281195849987e-05, 9.54475479352618022e-05, -1.06501231685877503e-04, -2.52725768132289197e-06, -2.87163499743147541e-05,
    2.39634619540592104e-04, -7.01848644852101600e-05, -1.07730520602342608e-04, -9.15501307042449695e-05, 5.55930835071830897e-05,
    7.65236411313137280e-05, 3.78463407174196132e-05, -8.20428675414204951e-06, -5.70295554976857978e-06, 1.26162015242596914e-05,
    1.10521120895615412e-04, -6.19508662898057469e-05, 3.94284099299287429e-05, -1.06451388614695302e-04, 7.47878473709218306e-05,
    -5.21118007184475231e-05, 5.90512347485764542e-05, -9.31374583187064725e-05, -1.76537540334046529e-05, -7.82954623428642381e-05,
    6.31966793043861619e-05, -3.36067601811582521e-05, -5.23997892308786733e-05, -6.79521363541582459e-05, 3.05704464569093182e-05,
    2.23407406348362189e-06, -1.17716210222080909e-05, -5.41817760084240387e-05, 2.65837093897156702e-05, 9.77892152361844917e-06,
    3.98189921094368982e-05, -4.68398123377187695e-05, 2.83937454235591119e-05, -2.31712065750914126e-05, 5.78505330157043243e-05,
    -6.07388476988686199e-05, 2.80495746496069133e-05, -7.16977469524132671e-05, 3.06211359179215205e-05, -4.91673798626069715e-05,
    2.17809145436793205e-05, -1.20189266317283195e-03, 0.00000000000000000e+00, -1.24444005867499095e-03, 0.00000000000000000e+00,
    1.73864859937527096e-03, -2.10016679995760200e-03, 1.28097965557804499e-03, -9.37869122558217835e-04, 1.23244624215056511e-03,
    4.29296709581100113e-04, -1.39876407807240904e-03, -1.77139693497456300e-03, -1.75368292696427997e-03, -1.88220407037240512e-03,
    -5.97882747390380697e-04, -3.20840209140584487e-04, 1.07829902637683606e-03, 3.48422576558867793e-04, -4.98399522356942812e-04,
    4.85015946638849439e-04, -7.40868022399493063e-04, 3.89788722352541486e-05, -1.50683679721151501e-03, -5.68710376996097691e-04,
    -1.17794557282445807e-04, -6.69071298330275012e-04, -1.54243277037009394e-03, 3.93673397135044668e-04, 5.02542184595859242e-04,
    -1.06141332845498607e-03, -4.68541722612586032e-04, 8.09111430645225208e-05, -5.50488474901892027e-04, -1.76232702790926301e-04,
    1.17927273469369909e-04, 8.80531874629222823e-04, -3.17470244298062771e-04, 4.64126640010351500e-04, -5.84186413684128505e-04,
    -1.42019871106746317e-04, 1.14102906216628905e-03, -1.13422500815021313e-03, -4.40136070204560524e-04, 7.81230568059088971e-04,
    -7.48231811144619272e-05, 2.70624883281615704e-06, 7.77629329803327529e-06, -4.64890263687434737e-05, 1.29456925148187810e-04,
    -8.26415855695131331e-06, -1.35796182420071221e-04, -1.13417756509377808e-04, 4.71475937122163948e-05, -1.35640896999089205e-04,
    -1.77588284877164021e-04, 4.44527488443097229e-05, 3.61597554605081118e-06, -8.57653366949178396e-05, -1.04773375499409501e-04,
    1.67387410624966980e-06, 3.27745304038831628e-05, -7.35752623470212766e-05, 9.67836329131315262e-06, 1.24611546920806011e-04,
    -2.07100197446184124e-05, -4.74290184099852226e-05, -6.27778738001704550e-06, 1.14722525535037299e-04, 9.15928222588590575e-06,
    -5.24769508651932535e-07, -2.64488074208383205e-05, 1.89369901667540120e-05, -9.02543609331752848e-06, 5.05981564857997049e-06,
    1.50033852168410511e-05, -3.22506474294869728e-05, 1.69892618976147802e-05, -1.22510414201922799e-05, -1.72479602440841401e-05,
    -5.38753752232114648e-05, 3.82701797625889268e-05, -2.52126883145274404e-05, -2.72655360701411011e-06, 2.38136850519584826e-05,
    3.89460713712125724e-05, -1.44085864133448205e-05, -1.99183168836612192e-05, 1.40299281945465198e-05, 3.41954900402774203e-05,
    -3.38967848729448998e-06, -3.34956295772950317e-05, -8.08169691723178865e-06, 1.75633301603197390e-05, 5.66459538142349871e-06,
    -2.32417858834375024e-05, -2.61422397808690076e-06, 1.61959819366858825e-05, -1.41749825797410821e-05, -1.69536160529109602e-05,
    -1.31441549108300885e-06, 1.56297638295987488e-05, -1.11585138806505809e-05, -1.65126158152218315e-05, 9.87884239323989340e-06,
    2.03783651816531221e-03, 0.00000000000000000e+00, 2.96441215597000821e-03, 0.00000000000000000e+00, -1.20692298413791507e-03,
    -1.67976475604672201e-03, -5.55507989859292846e-04, 2.41084152649467202e-04, 1.56009441290519001e-03, 1.29451122431705899e-03,
    -7.34843389900259429e-04, -1.14363222895938195e-03, -1.04558576783006095e-03, -1.36385048193016396e-03, -1.40388960701079294e-03,
    6.47371830280723940e-04, -7.50606293589330164e-04, -8.54271538689986695e-04, -4.38830402088630537e-04, 5.99525655311079764e-04,
    -1.78097452143089407e-04, -2.74859279931684324e-05, 4.58302159015211809e-04, 6.96953952070895151e-04, -9.09138958706189721e-04,
    1.00859289053476311e-03, 1.03420094281303607e-03, 6.06923899074255464e-04, 1.89553126330842806e-04, 1.07961345910163406e-04,
    1.22474291555961902e-04, 8.97871951519685265e-04, -2.03363015143865218e-04, -2.90422734859094615e-04, -1.16390797079040211e-03,
    -4.07437136982752909e-04, -3.33759313478539392e-05, -4.13217846735850717e-04, 6.11501445766974655e-05, 2.30660848037552498e-04,
    -1.65860197748338308e-04, 7.32838125453208456e-05, 3.05772451206082208e-05, -5.86058550125370254e-06, -1.00712626716708905e-04,
    -1.16636328519362104e-04, -4.39030870540731342e-05, 2.85746939544883230e-05, 1.21787965357839705e-04, 3.46888941913913528e-05,
    1.02679377633142107e-04, 4.05996014113190428e-05, 2.30543771929583613e-04, 5.14945396569508813e-06, -1.65368020862696715e-05,
    9.04748986364313894e-06, 2.93878012034917504e-05, -7.94825676720516274e-05, -3.80497824239483319e-05, 7.03625355594050394e-05,
    8.98471420453423214e-05, -2.80862342068120786e-04, -8.14566101491249101e-05, 3.25979861574083376e-05, 1.06156949242827603e-04,
    -1.32132181275301412e-04, 1.27583620705697613e-05, -5.79628880366303540e-06, 2.43199623878137608e-05, -3.60126018132162520e-05,
    6.15951019505404804e-05, -3.99183515734159737e-06, -1.76186429787627617e-05, -4.49466237943879815e-06, -9.63231232761454656e-06,
    2.20206236945611825e-05, 4.64279356163652205e-05, -8.18007824948389131e-05, -1.75678833941443713e-05, 1.16166757075860911e-05,
    8.50503368640412397e-05, -5.73112362586235122e-05, -3.02595465759658291e-05, 2.43223590855599709e-05, 9.00167115746459403e-05,
    -4.42196883338474652e-05, -4.77861166708995849e-05, 1.47871285798455200e-06, 6.46850476250585682e-05, -2.84469853186260997e-05,
    -4.06690705935917952e-06, -1.52285477243602015e-05, 5.34350029362040406e-05, -2.36525750629738904e-05, 1.79723054916162533e-05,
    -9.66549826127890040e-06, 5.63345183102968898e-05, -2.80051432389576894e-05, 3.21773388999549127e-06, 1.50608941802879105e-05,
    5.60896638506370299e-05, -2.17105368788846218e-05, -1.18764180976179311e-05, 7.83174918154457391e-06, -3.60332041478658661e-04,
    0.00000000000000000e+00, 3.49318793191280520e-03, 0.00000000000000000e+00, -4.69558634437114002e-05, 7.74460196242976196e-05,
    -1.72713645917304507e-03, 9.25559109923871173e-04, 2.70769786797511226e-04, 1.31867157982758915e-03, 8.27630755758396825e-04,
    -9.10032934212391328e-04, 1.05207266211394096e-03, -8.61162790483724626e-05, 5.89935325723504357e-04, 9.44401798870870619e-05,
    -5.30424580391579309e-05, 6.46005187543645225e-05, -1.38406487947310611e-04, 7.71434788940860436e-04, 5.73812403577386287e-04,
    9.96893494257266189e-04, 1.03367888609143905e-03, -6.48856607584904002e-04, 1.75666860474048509e-04, 3.15758899087953469e-04,
    8.50083079068923893e-04, 3.13659018423505167e-04, 1.51559585553799191e-04, 1.51467162868235410e-04, -1.29431785041904613e-04,
    -2.39797674845940504e-04, 2.33549706236320912e-04, -3.00841368338772394e-04, -7.95062782924988755e-05, -2.07935910158562009e-04,
    -3.92408950341176794e-05, -3.35406314150178588e-04, -1.45057999540062810e-04, -1.56325561593936710e-04, -2.13483774208381123e-05,
    1.23660725477051607e-04, -4.52126231413514295e-06, 1.23543299691240512e-04, -2.02273348603037631e-05, -1.12762498094144112e-05,
    1.29264958426136413e-05, 1.42217450806022812e-04, 4.33277313716177756e-05, -8.88754036309822399e-05, -4.52579094020371517e-05,
    1.53952587710451221e-04, 1.49223702486409108e-04, 1.89769705761112033e-05, 8.79407357783015825e-05, -2.42581624364586902e-05,
    -2.09538727115885126e-05, 3.19715400980995704e-06, 2.93210815056320497e-05, -9.82593484599446274e-06, 3.54911921458880570e-05,
    -1.01403207835097905e-04, 4.75557097499886204e-05, -5.15654800601184123e-05, 2.56187188204641513e-05, -4.40789852288279039e-05,
    9.02715865368834106e-05, -6.39625122936784616e-06, 3.91163204254141270e-07, -1.43497473262268803e-05, 1.48738995955006900e-05,
    7.10059543838856299e-05, -1.44858422217440211e-05, -2.29202291658015780e-06, -4.74320720877375356e-05, 2.16688715314149923e-05,
    3.19024146278115502e-05, 6.65770850586241554e-06, -2.52674351434578406e-05, -5.95618473210036723e-05, 1.85160634771636908e-05,
    -1.66385627558361417e-05, 3.01536532216370809e-05, -2.34318990675550609e-05, 1.99994047973059210e-05, 1.20799934486498588e-06,
    4.68905539792476611e-05, -4.05199614593984003e-07, 2.15121745493054430e-05, -9.06512486920190993e-06, 1.60091575368399188e-05,
    4.26017345086028326e-05, 2.60811047294765523e-05, -6.95236528206229650e-06, -1.14411704502663105e-05, 2.15010636838700904e-05,
    1.45470558851883310e-05, -6.07212258084767841e-06, -3.22028438478360636e-05, -3.17933241488657482e-07, -2.53151479665288202e-03,
    0.00000000000000000e+00, 1.12967622013809398e-03, 0.00000000000000000e+00, 5.16439235336714790e-04, 9.13502172529712803e-04,
    -1.10885916513099808e-04, -5.87650332004382970e-04, -3.10824645598157688e-04, -2.04340181774912815e-04, 1.50058658499531005e-04,
    -6.27762758616644544e-05, 6.34086998122845619e-04, 1.62611213591308410e-04, -2.58000457753021289e-04, -2.28405829315187425e-04,
    -2.41752383261545410e-04, 3.87195735267530246e-04, 1.31350888922379520e-04, -1.29243632867355305e-04, -1.86027850373812504e-04,
    2.69006585922663719e-05, 5.31648558458435233e-05, -2.81913823664273785e-04, 6.12596182709963886e-05, -1.99722422596107518e-04,
    1.65292373762217508e-04, 1.93923419729845505e-04, 2.75862370177224576e-04, 2.77743170358154992e-04, -2.42249854023419709e-04,
    -2.36920920177450216e-04, 1.24587860121446999e-04, 1.12559537025789104e-04, -8.91336246402938640e-05, -1.40571914192917500e-04,
    9.69331183964188236e-05, -1.44820965513538111e-04, -1.28839828734424514e-04, -5.82527231861141738e-05, 4.37826620002375143e-05,
    -7.67180354379144502e-05, 5.74861437218499151e-06, 5.02678298138450438e-05, -5.91313323346461106e-05, -1.08838366163098205e-04,
    6.49284469111140313e-05, 1.76727711960057211e-04, -6.84530490306975691e-05, -1.42567887910064205e-04, -3.17538645802270311e-05,
    6.82633542136118585e-05, -2.69908329748347014e-05, 1.98739426028434396e-05, 7.54438074321606313e-05, -6.35141527967402148e-05,
    1.72478873877519024e-05, 6.65218946661316610e-05, 5.90351225582636660e-06, -5.29346479560344747e-05, -6.09586847041837740e-05,
    5.77794329008206426e-05, 5.15519395345650716e-05, -5.66799896792458604e-05, -7.73712507640684068e-05, -4.08972980683335022e-05,
    6.47698884178398945e-05, 2.56965476906213634e-05, -1.07169096508788499e-05, -3.11367084296445586e-05, 2.64692802759765304e-05,
    4.09729157302286519e-05, 3.11189278864267132e-05, -5.78741270881866221e-06, -1.16942216776686414e-05, -1.41167610522350718e-05,
    2.77421966670059834e-05, 3.43719238319505278e-05, -1.16804942644560203e-05, -6.12184985312735501e-05, -2.94284212452698707e-05,
    3.96388866360877800e-05, 3.78998547828979167e-05, -4.92209043992790452e-05, -5.40755588507646826e-05, 2.16255420278872399e-06,
    4.63317120113593031e-05, 6.94969244998754276e-07, -1.75200269820160494e-05, -3.06430625697614833e-05, 3.43536241910082486e-05,
    1.58233835524091911e-05, 1.81976913278585211e-05, -1.12638695311979910e-05, -1.18290933055904215e-05, 1.54065347512193402e-05,
    -1.97457057792955592e-03, 0.00000000000000000e+00, -6.17903706175687285e-05, 0.00000000000000000e+00, 2.39974191600898101e-04,
    1.09676205964747407e-03, 2.66073294575686298e-04, 8.97726904827368986e-05, -4.21704772986081135e-04, -2.82186869262147694e-04,
    -1.97386162412418906e-04, -4.55182257600979224e-04, 6.90018589665085673e-04, 4.30022425770627912e-04, -4.13602752490345210e-04,
    5.26412358602485543e-05, -2.99605019324083717e-04, 3.36147203973198865e-04, 5.35288011923700297e-05, 1.19957570327492498e-04,
    -1.36669491045843299e-04, 1.94136007080692206e-04, 2.01776429817749806e-05, 4.22807143534335079e-06, -9.29802360975042527e-05,
    -1.55693138695467696e-04, -2.64935701201438924e-04, 3.83809379110780418e-05, 3.68315910254809705e-04, 2.22675272309271816e-04,
    -8.40837046939708617e-05, -1.26650144654841398e-04, 2.75725685385756389e-04, 2.08514653482221111e-04, -1.32192752900868492e-04,
    2.67546735251402909e-04, -1.46951286818532412e-05, -9.51276528158519121e-05, 1.12515159008266409e-05, 1.65126940488277810e-04,
    -1.05096096778006392e-06, -1.48931894867637118e-04, 3.88335645430680542e-05, -6.79220808847396388e-05, -5.68333508117840373e-06,
    -1.13497193495425101e-04, 4.40865395213776718e-05, 5.81689000146885115e-05, -1.07304496192630510e-04, -1.09553109663381809e-04,
    -7.36678296651362596e-05, 3.05076035218356775e-07, -7.14562184723935252e-05, -2.17689602162982504e-05, -8.86635043731916103e-05,
    1.55830079922932419e-05, 8.53188645751188393e-06, 1.27616620265669114e-04, -3.07660183064505199e-06, 1.77693877526996815e-05,
    -1.21881433351298308e-04, 9.70820239258155421e-05, -6.88477447173295197e-06, 8.35812145959487023e-05, -7.08861142732914167e-05,
    -1.95410408058430200e-05, -2.99815675113649160e-06, 5.30146506678979022e-05, -1.17983237948369116e-05, -4.06521074556727538e-05,
    -1.35928793450611709e-05, -2.69206670526964770e-06, 2.37405849777586631e-05, 1.41027369716773706e-05, 2.38608811716672410e-05,
    -1.04093815988561802e-05, 2.94018573099677933e-05, 4.79097717318764199e-05, -3.04484990645996103e-05, -7.41822772705316389e-06,
    -4.31780968615617526e-05, 6.00484819457901999e-05, -2.16148968238596922e-05, 2.63326485734068621e-05, -6.98149485535926799e-05,
    6.37673262907134300e-06, -1.49451539851202210e-05, 5.16763312907252601e-06, -3.01509621222700420e-05, -3.38437301504128696e-05,
    -3.09602298739826106e-06, 1.17686850815125304e-05, -1.46172096654267804e-03, 0.00000000000000000e+00, -1.04257220251350712e-03,
    0.00000000000000000e+00, 3.37601615679230670e-04, 3.62179244244991653e-04, 4.66516969872935697e-04, 2.20896945250713200e-04,
    -1.14856098350701606e-04, 3.71733378208419078e-04, -4.56528102625122800e-04, -5.00478119862720716e-04, 6.08268940632159427e-04,
    -3.32928662560408225e-05, -5.59187320611888869e-04, 4.24940469217676927e-04, -1.54626662460820405e-04, 1.53803155025080491e-04,
    1.42877804893037906e-06, 6.98532531440891971e-05, -2.98746773248649629e-05, 1.35471141341737106e-04, 6.98092718847611736e-05,
    3.63862564501528970e-04, 1.77889982501028103e-04, -1.05830904220531507e-04, -5.61018978334430437e-04, -2.70461507638364820e-05,
    2.69731733460872600e-04, 6.85854381210795444e-05, 3.93859632863456042e-05, -3.31099850163778212e-05, 3.15642194180260993e-04,
    -8.55565884347129894e-05, -8.81178757452353422e-06, 4.14099579966528220e-04, -1.18125841112851310e-04, -1.58864732692415517e-04,
    3.00173248333441702e-05, 2.77190872568433815e-04, -2.56765255788473531e-05, -1.57033171768035395e-04, -3.32959711484975829e-05,
    -9.63927667599435235e-05, -2.54742433883303236e-05, -6.50765457697475766e-05, 5.04018352818951719e-05, -3.43950512225536629e-05,
    -6.17363546212169873e-05, 5.10273923307524849e-06, -5.84607735450458815e-05, 1.64379737466675901e-05, 1.29734901817078911e-05,
    -3.92696914882976447e-05, -1.64041530160981709e-04, 1.42915901318080097e-05, 4.48109662215338665e-05, 6.40760478636463835e-05,
    -4.00827654443697601e-05, 5.23179794399272952e-05, -2.72653980923539735e-05, 4.13038148568586624e-06, -6.86097916757893300e-05,
    1.53031279669278410e-04, -3.76813873437484393e-05, -6.06148813378603305e-05, -6.39726082097255067e-05, 9.97952163664085433e-05,
    -8.05566844538046094e-07, -1.79349356201000397e-05, -2.64035614102093801e-06, -2.27319992387671927e-05, 2.44803623725549528e-05,
    -4.92446408524156795e-06, 1.69097417534366305e-05, -2.02331969300959902e-05, 2.23257754347340127e-05, 2.79953564079958715e-05,
    -2.77971641526118441e-05, 5.31337018758826847e-05, -1.51685357707728206e-05, 1.21185601596955313e-05, -5.54255754132544848e-05,
    3.39800800142221935e-05, -1.37705220101120503e-05, 1.17026527332457494e-06, -4.84099736084911341e-05, 1.72580930219210916e-05,
    -3.67873286266726476e-04, 0.00000000000000000e+00, -9.71856035308778688e-04, 0.00000000000000000e+00, 3.68001000603857041e-05,
    -1.80366306297578393e-04, 5.95465838399280006e-04, -9.73074587525231199e-05, 4.33035509414850597e-04, 8.68813550017956382e-04,
    -3.55604219599788853e-04, -2.09149810167836517e-04, 6.05497606635874435e-04, -4.44285688213212702e-04, -4.96326090016681234e-04,
    2.76200191743740885e-04, 1.05594362050475299e-04, -7.31746111760187581e-05, 5.25437405368234128e-05, -7.03636533238632066e-05,
    -7.04810658251703114e-05, -2.21448446357462613e-04, 8.40919434072135200e-05, 3.61285642497185589e-04, 4.63859693039894900e-04,
    9.95447465281579533e-06, -3.90334836566050476e-04, -7.15137273935237281e-05, 1.58344253289186405e-04, -9.66561524647479064e-06,
    -2.88464063028901239e-05, 3.20394934323419382e-05, 2.27870727298711814e-04, -3.85003894403811674e-04, 3.95453114218767795e-05,
    2.52344815518091095e-04, -1.28109809597042892e-04, -3.13591750088317250e-04, 4.95361157057811461e-05, 1.52566847685289017e-04,
    -4.65342429065181135e-05, -4.37630316986734248e-05, -2.94250258841729114e-05, -2.88828323869860414e-05, 3.73909881626153694e-06,
    2.72162890905132315e-05, -2.00735783121399998e-06, -8.45647849999474224e-05, 1.21455512759758114e-05, -1.54519685732128702e-05,
    -4.95728310623586458e-05, 4.23491907495121640e-05, 1.22893175677633306e-04, -2.68419786355757812e-05, -9.60596847652382831e-05,
    3.08820983081861631e-05, 5.83890486469687431e-05, -3.73708698488206477e-05, -5.19159241357444848e-05, 3.66386671593869911e-05,
    5.07658846861618521e-05, -1.07304750005830703e-04, -2.83663556542631599e-05, 9.28807206358021626e-05, 3.70104011521805719e-05,
    -8.34551268891536098e-05, -3.14113155589142528e-05, 6.63182318337119205e-05, 1.60213917824094198e-05, -3.52794936491844085e-05,
    -1.59225419093221418e-05, -8.34046194147479916e-07, -9.65280581409041511e-06, 5.07677914813006063e-06, 2.03902166810200127e-05,
    -1.25974535618156500e-05, 3.67496199937445797e-05, -1.69153230944175091e-05, -3.29180959908194180e-05, 2.52964761838148521e-05,
    2.14550118421411021e-05, -2.55984106137294917e-05, -2.09892146802813526e-05, 1.45091691712559505e-05, 1.05889292279405406e-04,
    0.00000000000000000e+00, 6.96557645777117211e-04, 0.00000000000000000e+00, -3.20653240139645156e-04, -3.06664898492693173e-04,
    -1.30135967286087193e-04, -3.43685687318228197e-04, 6.99243111115629935e-04, 1.00931484720404399e-03, 2.27872845646686414e-04,
    5.60556585522428805e-05, 5.06668770409637393e-04, -5.61098753829031857e-04, -1.77788812269638309e-04, -9.26838818560580326e-05,
    4.80704370686056920e-05, -3.94480920452870476e-05, 1.13743624415380402e-04, -1.95593364550650988e-04, -8.22385939115209569e-06,
    -2.22550243804433797e-04, 3.83433777349945372e-05, -6.14113903833953543e-05, 5.65029175348560203e-04, 1.64254592755116099e-05,
    6.44997102970363238e-05, 6.58176612450044410e-05, 1.26948782028661410e-04, -6.85633288983039511e-05, -1.17595095165860504e-04,
    -5.90185476888272837e-05, 1.31585913470637410e-04, -4.56978252250974911e-04, -1.00958846936701602e-04, -1.25259617920235096e-04,
    -1.04798018922154108e-04, -2.72545293701832833e-04, 4.86208256378739653e-05, -4.49465427200034320e-05, -5.65278962179857657e-05,
    5.46913188228785663e-06, -7.25997168582917762e-05, 1.14384344901122901e-04, 1.12924097562157112e-05, 3.68523306125718506e-05,
    -1.58208335465920613e-05, 1.20613043672090303e-05, 5.27346073833204513e-05, -3.86529074265486920e-05, 4.46597253672119545e-05,
    4.49755028762217115e-05, 1.30762541454545214e-04, -2.23656324639177317e-05, 3.19275114821177829e-05, 4.05961036565850809e-05,
    5.72814922207066132e-05, -6.32001323493957027e-05, -2.11556776338600419e-05, -5.16301940103973931e-05, 4.71248075383639623e-05,
    -1.16687520784574999e-04, 3.37705783718914737e-05, -3.55213809620370029e-05, 2.36245507648186426e-05, -9.39852209287609514e-05,
    4.18229647627686027e-05, 2.05795533565095200e-05, 2.95759782556888409e-05, -1.11460217666459313e-05, 5.56781374858055805e-07,
    1.61083673677120723e-05, -8.87804840750498273e-06, 4.69737707507023012e-06, -1.46943693829812711e-05, 8.96017347561271887e-07,
    2.31898944912936817e-05, -5.75437116150547476e-06, -1.04050964809673511e-05, -2.31844808370536218e-05, -1.24228889211622706e-03,
    0.00000000000000000e+00, 1.91447976012779097e-03, 0.00000000000000000e+00, 1.86361784351676802e-04, 1.22099836958390012e-05,
    -7.18563451828412871e-04, -5.44913205591266835e-04, 2.62429988030197430e-04, 7.46591568526208975e-04, 5.58329937558502609e-04,
    1.73536073229491603e-04, 3.28522185630468282e-04, -1.86008732903326717e-04, -5.28015697290392397e-05, -2.60360888337061416e-04,
    3.38623159395887096e-06, 3.98523056007639166e-05, 9.85712987849502202e-05, -1.84923290917329212e-04, -7.71217348849064299e-06,
    -5.95492370208864554e-06, 9.80226288250609149e-05, -2.85565844690997426e-04, 2.03773487125666412e-04, -7.62700465832047414e-05,
    2.74605378426968504e-04, 1.01722822597336303e-04, 1.72888937367956423e-04, 6.14980529476756761e-05, -1.65564582674629617e-04,
    -1.03937770636500405e-04, 1.79433136537534101e-04, -2.08448758771769422e-04, -1.89466752673463220e-04, -3.16495343152525463e-04,
    -4.65119297713267725e-05, -1.06418923164135207e-04, 2.92133315556121309e-05, -6.26522370914165365e-05, -3.80204692959265470e-05,
    -3.19351411420031736e-05, -2.69623453745025131e-05, 1.37371381422677307e-04, -2.75022603732538636e-05, -8.32319716531201625e-05,
    -1.83373351979320508e-05, 5.83418131216442243e-05, 3.02271302751488504e-05, -4.98112931491525709e-05, 9.55320075053375307e-05,
    5.27885328323068648e-05, 1.74669745949123195e-05, 7.07665598251270749e-06, 7.65295271797020177e-05, -2.16827317655175404e-06,
    2.56158486391027717e-05, 3.90319152054964128e-06, 1.09187600520226411e-05, -7.09932774164822179e-05, -3.10808798303788108e-06,
    -1.99276187654574111e-05, 6.66283232503938456e-05, -9.53193663619292649e-05, -1.38192357228852599e-05, -5.06310999643882654e-05,
    5.41699610443037853e-05, -3.01513898130062012e-05, 7.50384806164352122e-06, -2.46089181875213920e-05, 2.59233801595598333e-05,
    3.61281563025534099e-05, 1.03245043482577200e-05, 1.06651433549918202e-06, -2.36670929937189898e-05, 1.18133123540063415e-05,
    -2.37752112057859405e-03, 0.00000000000000000e+00, 9.79902373011075313e-04, 0.00000000000000000e+00, 6.24243707435149868e-04,
    5.32552953373556688e-04, -3.43350821058730849e-04, -2.74480805820874235e-04, -2.27192880699002904e-04, 2.78499590851373610e-04,
    2.16286114391411107e-04, -1.60014133917291410e-05, 3.34567174557116290e-04, 1.63861606954495299e-04, -7.32105805604817811e-05,
    -2.75173445122268732e-05, -1.63823844717904518e-04, 1.54240508845202994e-04, 2.27247826319914723e-05, -1.25891429989861308e-04,
    -7.50300602967604688e-05, 2.19336099049784612e-04, 5.12062944564588537e-05, -1.20931381190694310e-04, -3.93305054302574525e-05,
    -1.85764088661301817e-04, 1.26452686799904506e-04, 8.28267314219328091e-05, 1.70060420266698105e-04, 1.85986806711261124e-04,
    -1.26597460571993109e-04, -6.99927087500373682e-05, 2.43504463420420004e-04, 8.90929191691563495e-05, -1.08361903761964912e-04,
    -1.22129315467521012e-04, 3.69685678194193193e-06, -9.76853026011532927e-06, 2.31262017597801630e-05, 1.13627595483176917e-05,
    -4.73528940188713203e-05, -6.48206454745550508e-05, -1.22100888451138691e-06, 7.56468638352087683e-05, -2.53416560145800336e-05,
    -1.38940053681318499e-04, 7.20623765471817058e-06, 3.21809048129001281e-05, -2.21024328556184202e-05, -6.64125089630887160e-05,
    3.94708805911000318e-05, 9.71077583953939775e-06, -3.54527000430615696e-05, 3.69577787600789033e-05, 2.78095735286460204e-05,
    -5.72103304090500763e-06, -2.29889369505701688e-07, 4.82107116030443131e-05, -2.41508628637585772e-06, -2.63405093477893100e-05,
    -5.39352079240862240e-05, 5.49021393227147052e-05, 1.62938702966068904e-05, -3.35135604887079182e-05, -5.53241700444050103e-05,
    -3.74072324766078626e-06, 4.09192387408724616e-05, -1.27958514490034509e-05, -1.86071122399451600e-03, 0.00000000000000000e+00,
    -4.75292082404548451e-04, 0.00000000000000000e+00, 3.68780932191134698e-04, 5.54191148812023461e-04, 2.46565766805826323e-04,
    3.31614351952607561e-04, -1.71631555193545323e-04, 1.53116472177868300e-04, -3.93962061732021601e-04, -4.67407565386735021e-04,
    3.81580763254471577e-04, 2.04730687941415503e-04, -1.01606503900109209e-04, 2.85959959364757792e-04, -1.79032452140105822e-04,
    1.92416359225170601e-04, -7.84680634606176557e-05, 1.27965049428417914e-04, -8.79129716389746087e-05, 1.11181217880199307e-04,
    9.05309967637526850e-06, 1.00254047693470205e-04, 4.69931316356031836e-05, -1.26891478535794204e-04, -2.36948343468677716e-04,
    -4.48140930566895122e-05, 1.56053941255461314e-04, 1.62691879050438606e-04, -3.04275795445205909e-05, 2.34900095260012922e-05,
    1.89834915726008312e-04, 4.41324083801779445e-05, -2.43723672445334893e-06, 2.63792044876342115e-04, 4.15153428121390933e-05,
    -1.05194441751740605e-05, 3.07488334573277619e-05, 1.10224518899548499e-04, -4.91642006568435838e-05, -6.09507607897971724e-05,
    2.34553756526172398e-05, -5.48126075903642140e-05, -1.20368960697293707e-05, -1.24150118293778319e-04, -1.48408936527305184e-06,
    -2.32711453314438716e-05, -2.44128815133471698e-05, -8.80086425816799928e-05, -6.20023416923870383e-05, 1.39888880163119112e-05,
    -2.63313922516788706e-05, 2.90497335887282418e-05, -5.35969666694607321e-05, 7.45670074227807885e-06, 6.05689174479715297e-06,
    4.71747810724217328e-05, -7.45009495718939600e-06, 5.00189732462369597e-05, -4.37607562907335924e-05, 4.81409963763506648e-05,
    -2.77590927613943195e-05, 4.52414041552540728e-05, -5.31259473640927006e-04, 0.00000000000000000e+00, -8.52598896055884966e-04,
    0.00000000000000000e+00, -1.34885197765120801e-04, 3.96653458139192421e-05, 3.79863748404974581e-04, 4.72379949916368639e-04,
    3.10022768658648959e-04, 5.69786980729471452e-04, -5.32004027356815690e-04, -5.51946785340620108e-04, 4.75232705602061337e-04,
    -1.43688936593265289e-04, -1.34145640806652110e-04, 3.50186859951718285e-04, -9.73995300596363001e-05, 3.44420910592402329e-05,
    -7.18080185080251102e-05, 1.60789183521345793e-04, -2.22624413329587016e-05, -1.28193723235865101e-04, -5.86367985071233234e-05,
    1.73808458946174806e-04, 3.30813591969955861e-04, -2.71856805616303913e-05, -3.78174032231158770e-04, -5.90252957383779106e-05,
    8.26749071828692322e-05, 4.95775684062529633e-05, 5.44580124316286832e-05, 4.66596997412812434e-05, 1.38805718688968211e-04,
    -2.33571291413536304e-04, 1.03732179389248707e-05, 3.60726661880703256e-04, -1.47507354615690205e-05, -1.19512727220272909e-04,
    1.74914259207988697e-05, 1.47486413543964701e-04, -3.32823665073807436e-05, -1.22842848319823202e-05, 1.43169594952067807e-05,
    -7.76973814947431698e-05, -3.88223282922580738e-06, -6.06833041894285847e-05, 1.69396426346393996e-05, -1.68622586139392799e-05,
    2.13089649442872411e-05, -4.32134801386761130e-05, -6.80517923313584582e-05, -7.35601065807071865e-06, 5.38945357647690934e-05,
    -1.80635421990123584e-05, -7.24410824853465490e-05, -8.49791200553206016e-06, 2.38648729302909319e-04, 0.00000000000000000e+00,
    -1.21834637822591509e-04, 0.00000000000000000e+00, -3.35292268503080285e-04, -2.25765584210752207e-04, 1.20333852013061409e-04,
    8.76160017921376148e-05, 5.77938304508217315e-04, 7.60972878504902238e-04, -1.82272425178899499e-04, -1.60779267929980014e-04,
    5.35448065399970162e-04, -3.79066952306616653e-04, -8.56199550095533123e-05, 6.92585641489698963e-05, -1.77063677568286815e-07,
    -6.19787069144851961e-05, -4.12494051966487958e-06, 9.23467471398991294e-06, 2.20656813337354222e-05, -2.68841353591363623e-04,
    -4.41569566824339039e-05, 9.39704392249946418e-05, 5.05686186431699705e-04, -1.34069787456886217e-05, -1.24401821560768692e-04,
    -3.57022391309666403e-05, 3.18289650058353326e-05, -4.55877181661160831e-05, 1.88308936718896921e-05, 1.10332673498877904e-05,
    8.26712109978732347e-05, -3.60749199807011971e-04, 1.66345821208051797e-05, 1.38102500835173112e-04, -5.00940250071407793e-05,
    -1.95402563658848610e-04, -3.17286321063148396e-05, 1.79777030274422993e-05, 7.63370547491521362e-06, -1.10396898961960510e-05,
    3.33369496271408800e-05, -3.04264250781569691e-05, -1.57216726797123306e-04, 0.00000000000000000e+00, 6.59370968572886660e-04,
    0.00000000000000000e+00, -1.58158308265806205e-04, -1.39270436780774621e-05, -1.30148387599806405e-04, -1.89881255738238400e-04,
    3.53165617144957002e-04, 5.52476715941731993e-04, 1.62507460835903910e-04, 1.96382682741124315e-04, 4.95030561024928590e-04,
    -2.51538337834093535e-04, 1.01358288830775107e-04, -2.31117761155268212e-04, 1.61393344792953511e-05, 2.99917826599387518e-05,
    7.51186147023420687e-05, -9.84683991244665293e-05, -3.13331160710574486e-05, -1.62522943150101489e-04, -1.23500835514879590e-06,
    -1.33566023652081705e-04, 3.97104494240615893e-04, 5.35531200087193626e-06, 2.03178932800896107e-04, 2.04733048314890730e-05,
    1.65109198739017411e-04, 3.56627616721475523e-05, 2.11796830261870299e-05, -2.55894236371568098e-05, -1.17754597691724491e-03,
    0.00000000000000000e+00, 8.07133621695610274e-04, 0.00000000000000000e+00
};

#define ILCHAM 3128
#define NSTRON 10
#define NSMAX 31
#define NMSMAX 31

static void rectfromellipse(double* vr, const double* ve, int nsmax, int nmsmax)
{
    int i, j, kr = 0, ke = 0;
    for (i = 0; i <= nsmax; i++)
        for (j = 0; j <= nmsmax; j++) {
            double xi = (double)i / (double)nsmax;
            double xj = (double)j / (double)nmsmax;
            if (xi * xi + xj * xj < 1) {
                vr[kr + 0] = ve[ke + 0];
                vr[kr + 1] = ve[ke + 1];
                vr[kr + 2] = ve[ke + 2];
                vr[kr + 3] = ve[ke + 3];
                ke += 4;
            }
            else {
                vr[kr + 0] = 0.;
                vr[kr + 1] = 0.;
                vr[kr + 2] = 0.;
                vr[kr + 3] = 0.;
            }
            kr += 4;
        }
}

typedef struct
{
    int trunc;    /* 77, 88, 99 = truncation type */
    int subtrunc; /* 77, 88, 99 = subtruncation type */
    int subnsmax;
    int subnmsmax;
    double* values;
    int len;
    const char* name;
} trunc_t;

int main(int argc, char* argv[])
{
    grib_handle* h;
    size_t len;
    const char* grids[] = { "lambert_bf", "mercator_bf", "polar_stereographic_bf" };
    int igrid, itrunc;
    trunc_t trunc[3];
    long unpackedSubsetPrecision = 0;

    /* Elliptic truncation with diamond subtruncation */
    trunc[0].trunc     = 88;
    trunc[0].subtrunc  = 99;
    trunc[0].subnsmax  = NSTRON;
    trunc[0].subnmsmax = NSTRON;
    trunc[0].len       = ILCHAM;
    trunc[0].values    = (double*)values;
    trunc[0].name      = "ellipse_diamond";

    /* Rectangle truncation with rectangle subtruncation */
    trunc[1].trunc     = 77;
    trunc[1].subtrunc  = 77;
    trunc[1].subnsmax  = NSTRON;
    trunc[1].subnmsmax = NSTRON;
    trunc[1].len       = 4 * (NSMAX + 1) * (NMSMAX + 1);
    trunc[1].values    = (double*)malloc(sizeof(double) * trunc[1].len);
    trunc[1].name      = "rectangle_rectangle";
    rectfromellipse(trunc[1].values, trunc[0].values, NSMAX, NMSMAX);

    /* Elliptic truncation with full subtruncation */
    trunc[2].trunc     = 88;
    trunc[2].subtrunc  = 88;
    trunc[2].subnsmax  = NSMAX;
    trunc[2].subnmsmax = NMSMAX;
    trunc[2].len       = ILCHAM;
    trunc[2].values    = (double*)values;
    trunc[2].name      = "ellipse_full";

    for (itrunc = 0; itrunc < 3; itrunc++) {
        for (igrid = 0; igrid < 3; igrid++) {
            GRIB_CHECK(((h = grib_handle_new_from_samples(NULL, "lambert_bf_grib2")) == NULL), 0);

            GRIB_CHECK(grib_set_long(h, "centre", 85), 0);
            GRIB_CHECK(grib_set_long(h, "tablesVersion", 23), 0);
            len = strlen(grids[igrid]);
            GRIB_CHECK(grib_set_string(h, "gridType", grids[igrid], &len), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierResolutionParameterN", NSMAX), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierResolutionParameterM", NMSMAX), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierTruncationType", trunc[itrunc].trunc), 0);

            GRIB_CHECK(grib_set_long(h, "LxInMetres", 2000), 0);
            GRIB_CHECK(grib_set_long(h, "LyInMetres", 2000), 0);

            GRIB_CHECK(grib_set_long(h, "LuxInMetres", 1800), 0);
            GRIB_CHECK(grib_set_long(h, "LuyInMetres", 1800), 0);

            GRIB_CHECK(grib_set_long(h, "LcxInMetres", 100), 0);
            GRIB_CHECK(grib_set_long(h, "LcyInMetres", 100), 0);

            if (igrid == 0) {
                GRIB_CHECK(grib_set_double(h, "latitudeOfFirstGridPointInDegrees", 67.9372009520603), 0);
                GRIB_CHECK(grib_set_double(h, "longitudeOfFirstGridPointInDegrees", 25.1580207144963), 0);
                GRIB_CHECK(grib_set_long(h, "latitudeOfSouthernPoleInDegrees", 0), 0);
                GRIB_CHECK(grib_set_long(h, "longitudeOfSouthernPoleInDegrees", 0), 0);
                GRIB_CHECK(grib_set_double(h, "LoVInDegrees", 26.6400000000000), 0);
                GRIB_CHECK(grib_set_double(h, "Latin1InDegrees", 67.3600000000000), 0);
                GRIB_CHECK(grib_set_double(h, "Latin2InDegrees", 67.3600000000000), 0);
                GRIB_CHECK(grib_set_long(h, "projectionCentreFlag", 0), 0);
                GRIB_CHECK(grib_set_long(h, "bitsPerValue", 16), 0);
            }
            else if (igrid == 1) {
                GRIB_CHECK(grib_set_double(h, "latitudeOfFirstGridPointInDegrees", 67.9372009520603), 0);
                GRIB_CHECK(grib_set_double(h, "longitudeOfFirstGridPointInDegrees", 25.1580207144963), 0);
                GRIB_CHECK(grib_set_double(h, "LaDInDegrees", 0.), 0);
                GRIB_CHECK(grib_set_double(h, "latitudeOfLastGridPointInDegrees", 72.9372009520603), 0);
                GRIB_CHECK(grib_set_double(h, "longitudeOfLastGridPointInDegrees", 29.1580207144963), 0);
                GRIB_CHECK(grib_set_double(h, "orientationOfTheGridInDegrees", 0.), 0);
            }
            else if (igrid == 2) {
                GRIB_CHECK(grib_set_double(h, "latitudeOfFirstGridPointInDegrees", 67.9372009520603), 0);
                GRIB_CHECK(grib_set_double(h, "longitudeOfFirstGridPointInDegrees", 25.1580207144963), 0);
                GRIB_CHECK(grib_set_double(h, "LaDInDegrees", 0.), 0);
                GRIB_CHECK(grib_set_double(h, "orientationOfTheGridInDegrees", 0.), 0);
            }

            len = strlen("bifourier_complex");
            GRIB_CHECK(grib_set_string(h, "packingType", "bifourier_complex", &len), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierResolutionSubSetParameterN", trunc[itrunc].subnsmax), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierResolutionSubSetParameterM", trunc[itrunc].subnmsmax), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierSubTruncationType", trunc[itrunc].subtrunc), 0);
            GRIB_CHECK(grib_set_long(h, "biFourierPackingModeForAxes", 1), 0);
            /* "unpackedSubsetPrecision" value is used for "ieee_floats".
               ieee_floats=2 means bytes=8 and grib_long_to_ieee64 is used, which is supported
               only when sizeof(double) == sizeof(long)
            */
            if (sizeof(double) == sizeof(long))
                  unpackedSubsetPrecision = 2;
            else
                  unpackedSubsetPrecision = 1;
            GRIB_CHECK(grib_set_long(h, "unpackedSubsetPrecision", unpackedSubsetPrecision), 0);

            len = trunc[itrunc].len;
            GRIB_CHECK(grib_set_double_array(h, "values", trunc[itrunc].values, len), 0);

            if (1) {
                char f[128];
                FILE* fp;
                size_t size;
                const void* buffer = NULL;
                snprintf(f, 128, "lam_bf_%s_%s.grib", grids[igrid], trunc[itrunc].name);
                fp = fopen(f, "wb");
                GRIB_CHECK(grib_get_message(h, &buffer, &size), 0);
                if (fwrite(buffer, 1, size, fp) != size) {
                    perror(f);
                    return 1;
                }
                fclose(fp);
            }

            GRIB_CHECK(grib_handle_delete(h), 0);

            /* Check message correctness */
            {
                char f[128];
                FILE* fp;
                double* vals;
                double norm = 0.;
                int i, err;
                size_t values_len, geometry_len;
                long int LxInMetres, LyInMetres, LuxInMetres, LuyInMetres, LcxInMetres, LcyInMetres;
                long int nsmax, nmsmax;
                char geometry[128];

                snprintf(f, 128, "lam_bf_%s_%s.grib", grids[igrid], trunc[itrunc].name);
                fp         = fopen(f, "rb");
                h          = grib_handle_new_from_file(0, fp, &err);
                vals       = (double*)malloc(sizeof(double) * trunc[itrunc].len);
                values_len = trunc[itrunc].len;
                GRIB_CHECK(grib_get_double_array(h, "values", vals, &values_len), 0);
                for (i = 0; i < trunc[itrunc].len; i++)
                    norm += (trunc[itrunc].values[i] - vals[i]) * (trunc[itrunc].values[i] - vals[i]);
                norm = sqrt(norm / trunc[itrunc].len);
                free(vals);

                if (norm > 0.0001) {
                    fprintf(stderr, "Error too large! norm=%g\n", norm);
                    return 1;
                }
                fclose(fp);

                GRIB_CHECK(grib_get_long(h, "biFourierResolutionParameterN", &nsmax), 0);
                GRIB_CHECK(grib_get_long(h, "biFourierResolutionParameterM", &nmsmax), 0);

                GRIB_CHECK(grib_get_long(h, "LxInMetres", &LxInMetres), 0);
                GRIB_CHECK(grib_get_long(h, "LyInMetres", &LyInMetres), 0);

                GRIB_CHECK(grib_get_long(h, "LuxInMetres", &LuxInMetres), 0);
                GRIB_CHECK(grib_get_long(h, "LuyInMetres", &LuyInMetres), 0);

                GRIB_CHECK(grib_get_long(h, "LcxInMetres", &LcxInMetres), 0);
                GRIB_CHECK(grib_get_long(h, "LcyInMetres", &LcyInMetres), 0);

                if (LxInMetres != 2000 || LyInMetres != 2000 ||
                    LuxInMetres != 1800 || LuyInMetres != 1800 ||
                    LcxInMetres != 100 || LcyInMetres != 100 ||
                    NSMAX != nsmax || NMSMAX != nmsmax) {
                    fprintf(stderr, "Geometry is incorrect\n");
                    return 1;
                }

                geometry_len = 128;
                GRIB_CHECK(grib_get_string(h, "gridType", geometry, &geometry_len), 0);
                if (strcmp(geometry, grids[igrid])) {
                    fprintf(stderr, "Geometry is incorrect\n");
                    return 1;
                }

                GRIB_CHECK(grib_handle_delete(h), 0);
            }
        }
    }
    free(trunc[1].values);
    return 0;
}
