
! Copyright (C) 2023 J. K. Dewhurst and S. Sharma.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine trimrfg(rfir)
use modmain
implicit none
! arguments
real(8), intent(inout) :: rfir(ngtot)
! allocatable arrays
complex(8), allocatable :: zfft(:)
allocate(zfft(ngtot))
! Fourier transform function to G-space
zfft(:)=rfir(:)
call zfftifc(3,ngridg,-1,zfft)
! zero the components for |G| > 2 gkmax
zfft(igfft(ngvc+1:ngtot))=0.d0
! Fourier transform back to real-space
call zfftifc(3,ngridg,1,zfft)
rfir(:)=dble(zfft(:))
deallocate(zfft)
end subroutine
