/*  
   Elmer, A Finite Element Software for Multiphysical Problems
   Copyright 1st April 1995 - , CSC - IT Center for Science Ltd., Finland

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/***********************************************************************
Program:    ELMER Data base interface (EIO)
Author(s):  Harri Hakula 10.03.98
************************************************************************/

#ifndef EIOPARTWRITER_H
#define EIOPARTWRITER_H

#include "EIOModelManager.h"

const int partWriterFiles = 5;

class EIOPartWriter
{
public:
  EIOPartWriter(int& partCount, EIOModelManager *mm);
  ~EIOPartWriter();

  int createPartitioning(const char *dir);
  int closePartitioning();
  
  int activatePart(int part);
  int deactivatePart();

  // WRITE
  int write_descriptor(int& nodeC,
		       int& sharedC,
		       int& elementC, 
		       int& borderC, 
		       int& boundaryC, 
		       int& usedElementTypes,
		       int* elementTypeTags,
		       int* elementCountByType);

  int write_node(int& tag, int& type, double *coord, int& partC, int *parts);
  int write_element(int& tag, int& body, int& type, int *nodes, int& border);

private:
  // We "use" ModelManager in every Agent.
  EIOModelManager *manager;

  // All streams
  fstream meshFileStream[partWriterFiles];
  // Sizes
  char newdir[PATH_MAX];

  int parts;
  int me;

  int nodeCount;
  int elementCount;
  int boundaryElementCount;
  int elementTypes;
  int *elementTypeTags;
  int *elementTypeCount;
  //
  void openStreams();
  void closeStreams();
};

#endif /* EIOPARTWRITER_H */
